/*
Copyright the Velero contributors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by lister-gen. DO NOT EDIT.

package v1

import (
	v1 "github.com/heptio/velero/pkg/apis/velero/v1"
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
)

// ResticRepositoryLister helps list ResticRepositories.
type ResticRepositoryLister interface {
	// List lists all ResticRepositories in the indexer.
	List(selector labels.Selector) (ret []*v1.ResticRepository, err error)
	// ResticRepositories returns an object that can list and get ResticRepositories.
	ResticRepositories(namespace string) ResticRepositoryNamespaceLister
	ResticRepositoryListerExpansion
}

// resticRepositoryLister implements the ResticRepositoryLister interface.
type resticRepositoryLister struct {
	indexer cache.Indexer
}

// NewResticRepositoryLister returns a new ResticRepositoryLister.
func NewResticRepositoryLister(indexer cache.Indexer) ResticRepositoryLister {
	return &resticRepositoryLister{indexer: indexer}
}

// List lists all ResticRepositories in the indexer.
func (s *resticRepositoryLister) List(selector labels.Selector) (ret []*v1.ResticRepository, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v1.ResticRepository))
	})
	return ret, err
}

// ResticRepositories returns an object that can list and get ResticRepositories.
func (s *resticRepositoryLister) ResticRepositories(namespace string) ResticRepositoryNamespaceLister {
	return resticRepositoryNamespaceLister{indexer: s.indexer, namespace: namespace}
}

// ResticRepositoryNamespaceLister helps list and get ResticRepositories.
type ResticRepositoryNamespaceLister interface {
	// List lists all ResticRepositories in the indexer for a given namespace.
	List(selector labels.Selector) (ret []*v1.ResticRepository, err error)
	// Get retrieves the ResticRepository from the indexer for a given namespace and name.
	Get(name string) (*v1.ResticRepository, error)
	ResticRepositoryNamespaceListerExpansion
}

// resticRepositoryNamespaceLister implements the ResticRepositoryNamespaceLister
// interface.
type resticRepositoryNamespaceLister struct {
	indexer   cache.Indexer
	namespace string
}

// List lists all ResticRepositories in the indexer for a given namespace.
func (s resticRepositoryNamespaceLister) List(selector labels.Selector) (ret []*v1.ResticRepository, err error) {
	err = cache.ListAllByNamespace(s.indexer, s.namespace, selector, func(m interface{}) {
		ret = append(ret, m.(*v1.ResticRepository))
	})
	return ret, err
}

// Get retrieves the ResticRepository from the indexer for a given namespace and name.
func (s resticRepositoryNamespaceLister) Get(name string) (*v1.ResticRepository, error) {
	obj, exists, err := s.indexer.GetByKey(s.namespace + "/" + name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(v1.Resource("resticrepository"), name)
	}
	return obj.(*v1.ResticRepository), nil
}
