// +build go1.9

// Copyright 2020 Microsoft Corporation
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// This code was auto-generated by:
// github.com/Azure/azure-sdk-for-go/tools/profileBuilder

package kubernetesconfiguration

import (
	"context"

	original "github.com/Azure/azure-sdk-for-go/services/preview/kubernetesconfiguration/mgmt/2019-11-01-preview/kubernetesconfiguration"
)

const (
	DefaultBaseURI = original.DefaultBaseURI
)

type ComplianceState = original.ComplianceState

const (
	Compliant    ComplianceState = original.Compliant
	Failed       ComplianceState = original.Failed
	Installed    ComplianceState = original.Installed
	Noncompliant ComplianceState = original.Noncompliant
	Pending      ComplianceState = original.Pending
)

type EnableHelmOperator = original.EnableHelmOperator

const (
	False EnableHelmOperator = original.False
	True  EnableHelmOperator = original.True
)

type MessageLevel = original.MessageLevel

const (
	Error       MessageLevel = original.Error
	Information MessageLevel = original.Information
	Warning     MessageLevel = original.Warning
)

type OperatorScope = original.OperatorScope

const (
	Cluster   OperatorScope = original.Cluster
	Namespace OperatorScope = original.Namespace
)

type OperatorType = original.OperatorType

const (
	Flux OperatorType = original.Flux
)

type ProvisioningState = original.ProvisioningState

const (
	ProvisioningStateAccepted  ProvisioningState = original.ProvisioningStateAccepted
	ProvisioningStateDeleting  ProvisioningState = original.ProvisioningStateDeleting
	ProvisioningStateFailed    ProvisioningState = original.ProvisioningStateFailed
	ProvisioningStateRunning   ProvisioningState = original.ProvisioningStateRunning
	ProvisioningStateSucceeded ProvisioningState = original.ProvisioningStateSucceeded
)

type BaseClient = original.BaseClient
type ComplianceStatus = original.ComplianceStatus
type ErrorDefinition = original.ErrorDefinition
type ErrorResponse = original.ErrorResponse
type HelmOperatorProperties = original.HelmOperatorProperties
type OperationsClient = original.OperationsClient
type ProxyResource = original.ProxyResource
type Resource = original.Resource
type ResourceProviderOperation = original.ResourceProviderOperation
type ResourceProviderOperationDisplay = original.ResourceProviderOperationDisplay
type ResourceProviderOperationList = original.ResourceProviderOperationList
type ResourceProviderOperationListIterator = original.ResourceProviderOperationListIterator
type ResourceProviderOperationListPage = original.ResourceProviderOperationListPage
type Result = original.Result
type SourceControlConfiguration = original.SourceControlConfiguration
type SourceControlConfigurationList = original.SourceControlConfigurationList
type SourceControlConfigurationListIterator = original.SourceControlConfigurationListIterator
type SourceControlConfigurationListPage = original.SourceControlConfigurationListPage
type SourceControlConfigurationProperties = original.SourceControlConfigurationProperties
type SourceControlConfigurationsClient = original.SourceControlConfigurationsClient
type SourceControlConfigurationsDeleteFuture = original.SourceControlConfigurationsDeleteFuture

func New(subscriptionID string) BaseClient {
	return original.New(subscriptionID)
}
func NewOperationsClient(subscriptionID string) OperationsClient {
	return original.NewOperationsClient(subscriptionID)
}
func NewOperationsClientWithBaseURI(baseURI string, subscriptionID string) OperationsClient {
	return original.NewOperationsClientWithBaseURI(baseURI, subscriptionID)
}
func NewResourceProviderOperationListIterator(page ResourceProviderOperationListPage) ResourceProviderOperationListIterator {
	return original.NewResourceProviderOperationListIterator(page)
}
func NewResourceProviderOperationListPage(getNextPage func(context.Context, ResourceProviderOperationList) (ResourceProviderOperationList, error)) ResourceProviderOperationListPage {
	return original.NewResourceProviderOperationListPage(getNextPage)
}
func NewSourceControlConfigurationListIterator(page SourceControlConfigurationListPage) SourceControlConfigurationListIterator {
	return original.NewSourceControlConfigurationListIterator(page)
}
func NewSourceControlConfigurationListPage(getNextPage func(context.Context, SourceControlConfigurationList) (SourceControlConfigurationList, error)) SourceControlConfigurationListPage {
	return original.NewSourceControlConfigurationListPage(getNextPage)
}
func NewSourceControlConfigurationsClient(subscriptionID string) SourceControlConfigurationsClient {
	return original.NewSourceControlConfigurationsClient(subscriptionID)
}
func NewSourceControlConfigurationsClientWithBaseURI(baseURI string, subscriptionID string) SourceControlConfigurationsClient {
	return original.NewSourceControlConfigurationsClientWithBaseURI(baseURI, subscriptionID)
}
func NewWithBaseURI(baseURI string, subscriptionID string) BaseClient {
	return original.NewWithBaseURI(baseURI, subscriptionID)
}
func PossibleComplianceStateValues() []ComplianceState {
	return original.PossibleComplianceStateValues()
}
func PossibleEnableHelmOperatorValues() []EnableHelmOperator {
	return original.PossibleEnableHelmOperatorValues()
}
func PossibleMessageLevelValues() []MessageLevel {
	return original.PossibleMessageLevelValues()
}
func PossibleOperatorScopeValues() []OperatorScope {
	return original.PossibleOperatorScopeValues()
}
func PossibleOperatorTypeValues() []OperatorType {
	return original.PossibleOperatorTypeValues()
}
func PossibleProvisioningStateValues() []ProvisioningState {
	return original.PossibleProvisioningStateValues()
}
func UserAgent() string {
	return original.UserAgent() + " profiles/preview"
}
func Version() string {
	return original.Version()
}
