package arms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetServices invokes the arms.GetServices API synchronously
// api document: https://help.aliyun.com/api/arms/getservices.html
func (client *Client) GetServices(request *GetServicesRequest) (response *GetServicesResponse, err error) {
	response = CreateGetServicesResponse()
	err = client.DoAction(request, response)
	return
}

// GetServicesWithChan invokes the arms.GetServices API asynchronously
// api document: https://help.aliyun.com/api/arms/getservices.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetServicesWithChan(request *GetServicesRequest) (<-chan *GetServicesResponse, <-chan error) {
	responseChan := make(chan *GetServicesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetServices(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetServicesWithCallback invokes the arms.GetServices API asynchronously
// api document: https://help.aliyun.com/api/arms/getservices.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetServicesWithCallback(request *GetServicesRequest, callback func(response *GetServicesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetServicesResponse
		var err error
		defer close(result)
		response, err = client.GetServices(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetServicesRequest is the request struct for api GetServices
type GetServicesRequest struct {
	*requests.RpcRequest
	AppType string `position:"Query" name:"AppType"`
}

// GetServicesResponse is the response struct for api GetServices
type GetServicesResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateGetServicesRequest creates a request to invoke GetServices API
func CreateGetServicesRequest() (request *GetServicesRequest) {
	request = &GetServicesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ARMS", "2019-02-19", "GetServices", "", "")
	return
}

// CreateGetServicesResponse creates a response to parse from GetServices response
func CreateGetServicesResponse() (response *GetServicesResponse) {
	response = &GetServicesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
