package cms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteEventRules invokes the cms.DeleteEventRules API synchronously
// api document: https://help.aliyun.com/api/cms/deleteeventrules.html
func (client *Client) DeleteEventRules(request *DeleteEventRulesRequest) (response *DeleteEventRulesResponse, err error) {
	response = CreateDeleteEventRulesResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteEventRulesWithChan invokes the cms.DeleteEventRules API asynchronously
// api document: https://help.aliyun.com/api/cms/deleteeventrules.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteEventRulesWithChan(request *DeleteEventRulesRequest) (<-chan *DeleteEventRulesResponse, <-chan error) {
	responseChan := make(chan *DeleteEventRulesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteEventRules(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteEventRulesWithCallback invokes the cms.DeleteEventRules API asynchronously
// api document: https://help.aliyun.com/api/cms/deleteeventrules.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteEventRulesWithCallback(request *DeleteEventRulesRequest, callback func(response *DeleteEventRulesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteEventRulesResponse
		var err error
		defer close(result)
		response, err = client.DeleteEventRules(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteEventRulesRequest is the request struct for api DeleteEventRules
type DeleteEventRulesRequest struct {
	*requests.RpcRequest
	RuleNames *[]string `position:"Query" name:"RuleNames"  type:"Repeated"`
}

// DeleteEventRulesResponse is the response struct for api DeleteEventRules
type DeleteEventRulesResponse struct {
	*responses.BaseResponse
	Success   bool   `json:"Success" xml:"Success"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteEventRulesRequest creates a request to invoke DeleteEventRules API
func CreateDeleteEventRulesRequest() (request *DeleteEventRulesRequest) {
	request = &DeleteEventRulesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cms", "2019-01-01", "DeleteEventRules", "cms", "openAPI")
	return
}

// CreateDeleteEventRulesResponse creates a response to parse from DeleteEventRules response
func CreateDeleteEventRulesResponse() (response *DeleteEventRulesResponse) {
	response = &DeleteEventRulesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
