// Code generated by main. DO NOT EDIT.

package v1

import (
	"time"

	v1 "github.com/openshift/hive/pkg/apis/hive/v1"
	scheme "github.com/openshift/hive/pkg/client/clientset-generated/clientset/scheme"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// MachinePoolNameLeasesGetter has a method to return a MachinePoolNameLeaseInterface.
// A group's client should implement this interface.
type MachinePoolNameLeasesGetter interface {
	MachinePoolNameLeases(namespace string) MachinePoolNameLeaseInterface
}

// MachinePoolNameLeaseInterface has methods to work with MachinePoolNameLease resources.
type MachinePoolNameLeaseInterface interface {
	Create(*v1.MachinePoolNameLease) (*v1.MachinePoolNameLease, error)
	Update(*v1.MachinePoolNameLease) (*v1.MachinePoolNameLease, error)
	UpdateStatus(*v1.MachinePoolNameLease) (*v1.MachinePoolNameLease, error)
	Delete(name string, options *metav1.DeleteOptions) error
	DeleteCollection(options *metav1.DeleteOptions, listOptions metav1.ListOptions) error
	Get(name string, options metav1.GetOptions) (*v1.MachinePoolNameLease, error)
	List(opts metav1.ListOptions) (*v1.MachinePoolNameLeaseList, error)
	Watch(opts metav1.ListOptions) (watch.Interface, error)
	Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1.MachinePoolNameLease, err error)
	MachinePoolNameLeaseExpansion
}

// machinePoolNameLeases implements MachinePoolNameLeaseInterface
type machinePoolNameLeases struct {
	client rest.Interface
	ns     string
}

// newMachinePoolNameLeases returns a MachinePoolNameLeases
func newMachinePoolNameLeases(c *HiveV1Client, namespace string) *machinePoolNameLeases {
	return &machinePoolNameLeases{
		client: c.RESTClient(),
		ns:     namespace,
	}
}

// Get takes name of the machinePoolNameLease, and returns the corresponding machinePoolNameLease object, and an error if there is any.
func (c *machinePoolNameLeases) Get(name string, options metav1.GetOptions) (result *v1.MachinePoolNameLease, err error) {
	result = &v1.MachinePoolNameLease{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("machinepoolnameleases").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do().
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of MachinePoolNameLeases that match those selectors.
func (c *machinePoolNameLeases) List(opts metav1.ListOptions) (result *v1.MachinePoolNameLeaseList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1.MachinePoolNameLeaseList{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("machinepoolnameleases").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do().
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested machinePoolNameLeases.
func (c *machinePoolNameLeases) Watch(opts metav1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Namespace(c.ns).
		Resource("machinepoolnameleases").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch()
}

// Create takes the representation of a machinePoolNameLease and creates it.  Returns the server's representation of the machinePoolNameLease, and an error, if there is any.
func (c *machinePoolNameLeases) Create(machinePoolNameLease *v1.MachinePoolNameLease) (result *v1.MachinePoolNameLease, err error) {
	result = &v1.MachinePoolNameLease{}
	err = c.client.Post().
		Namespace(c.ns).
		Resource("machinepoolnameleases").
		Body(machinePoolNameLease).
		Do().
		Into(result)
	return
}

// Update takes the representation of a machinePoolNameLease and updates it. Returns the server's representation of the machinePoolNameLease, and an error, if there is any.
func (c *machinePoolNameLeases) Update(machinePoolNameLease *v1.MachinePoolNameLease) (result *v1.MachinePoolNameLease, err error) {
	result = &v1.MachinePoolNameLease{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("machinepoolnameleases").
		Name(machinePoolNameLease.Name).
		Body(machinePoolNameLease).
		Do().
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().

func (c *machinePoolNameLeases) UpdateStatus(machinePoolNameLease *v1.MachinePoolNameLease) (result *v1.MachinePoolNameLease, err error) {
	result = &v1.MachinePoolNameLease{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("machinepoolnameleases").
		Name(machinePoolNameLease.Name).
		SubResource("status").
		Body(machinePoolNameLease).
		Do().
		Into(result)
	return
}

// Delete takes name of the machinePoolNameLease and deletes it. Returns an error if one occurs.
func (c *machinePoolNameLeases) Delete(name string, options *metav1.DeleteOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("machinepoolnameleases").
		Name(name).
		Body(options).
		Do().
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *machinePoolNameLeases) DeleteCollection(options *metav1.DeleteOptions, listOptions metav1.ListOptions) error {
	var timeout time.Duration
	if listOptions.TimeoutSeconds != nil {
		timeout = time.Duration(*listOptions.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Namespace(c.ns).
		Resource("machinepoolnameleases").
		VersionedParams(&listOptions, scheme.ParameterCodec).
		Timeout(timeout).
		Body(options).
		Do().
		Error()
}

// Patch applies the patch and returns the patched machinePoolNameLease.
func (c *machinePoolNameLeases) Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1.MachinePoolNameLease, err error) {
	result = &v1.MachinePoolNameLease{}
	err = c.client.Patch(pt).
		Namespace(c.ns).
		Resource("machinepoolnameleases").
		SubResource(subresources...).
		Name(name).
		Body(data).
		Do().
		Into(result)
	return
}
