// Code generated by main. DO NOT EDIT.

package fake

import (
	hivev1 "github.com/openshift/hive/pkg/apis/hive/v1"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	schema "k8s.io/apimachinery/pkg/runtime/schema"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
)

// FakeSyncSets implements SyncSetInterface
type FakeSyncSets struct {
	Fake *FakeHiveV1
	ns   string
}

var syncsetsResource = schema.GroupVersionResource{Group: "hive.openshift.io", Version: "v1", Resource: "syncsets"}

var syncsetsKind = schema.GroupVersionKind{Group: "hive.openshift.io", Version: "v1", Kind: "SyncSet"}

// Get takes name of the syncSet, and returns the corresponding syncSet object, and an error if there is any.
func (c *FakeSyncSets) Get(name string, options v1.GetOptions) (result *hivev1.SyncSet, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewGetAction(syncsetsResource, c.ns, name), &hivev1.SyncSet{})

	if obj == nil {
		return nil, err
	}
	return obj.(*hivev1.SyncSet), err
}

// List takes label and field selectors, and returns the list of SyncSets that match those selectors.
func (c *FakeSyncSets) List(opts v1.ListOptions) (result *hivev1.SyncSetList, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewListAction(syncsetsResource, syncsetsKind, c.ns, opts), &hivev1.SyncSetList{})

	if obj == nil {
		return nil, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &hivev1.SyncSetList{ListMeta: obj.(*hivev1.SyncSetList).ListMeta}
	for _, item := range obj.(*hivev1.SyncSetList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested syncSets.
func (c *FakeSyncSets) Watch(opts v1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewWatchAction(syncsetsResource, c.ns, opts))

}

// Create takes the representation of a syncSet and creates it.  Returns the server's representation of the syncSet, and an error, if there is any.
func (c *FakeSyncSets) Create(syncSet *hivev1.SyncSet) (result *hivev1.SyncSet, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewCreateAction(syncsetsResource, c.ns, syncSet), &hivev1.SyncSet{})

	if obj == nil {
		return nil, err
	}
	return obj.(*hivev1.SyncSet), err
}

// Update takes the representation of a syncSet and updates it. Returns the server's representation of the syncSet, and an error, if there is any.
func (c *FakeSyncSets) Update(syncSet *hivev1.SyncSet) (result *hivev1.SyncSet, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateAction(syncsetsResource, c.ns, syncSet), &hivev1.SyncSet{})

	if obj == nil {
		return nil, err
	}
	return obj.(*hivev1.SyncSet), err
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *FakeSyncSets) UpdateStatus(syncSet *hivev1.SyncSet) (*hivev1.SyncSet, error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateSubresourceAction(syncsetsResource, "status", c.ns, syncSet), &hivev1.SyncSet{})

	if obj == nil {
		return nil, err
	}
	return obj.(*hivev1.SyncSet), err
}

// Delete takes name of the syncSet and deletes it. Returns an error if one occurs.
func (c *FakeSyncSets) Delete(name string, options *v1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewDeleteAction(syncsetsResource, c.ns, name), &hivev1.SyncSet{})

	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeSyncSets) DeleteCollection(options *v1.DeleteOptions, listOptions v1.ListOptions) error {
	action := testing.NewDeleteCollectionAction(syncsetsResource, c.ns, listOptions)

	_, err := c.Fake.Invokes(action, &hivev1.SyncSetList{})
	return err
}

// Patch applies the patch and returns the patched syncSet.
func (c *FakeSyncSets) Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *hivev1.SyncSet, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceAction(syncsetsResource, c.ns, name, pt, data, subresources...), &hivev1.SyncSet{})

	if obj == nil {
		return nil, err
	}
	return obj.(*hivev1.SyncSet), err
}
