// Licensed Materials - Property of IBM
// (c) Copyright IBM Corporation 2018. All Rights Reserved.
// Note to U.S. Government Users Restricted Rights:
// Use, duplication or disclosure restricted by GSA ADP Schedule
// Contract with IBM Corp.

// Code generated by client-gen. DO NOT EDIT.

package v1alpha1

import (
	"time"

	v1alpha1 "github.com/open-cluster-management/multicloud-operators-foundation/pkg/apis/mcm/v1alpha1"
	scheme "github.com/open-cluster-management/multicloud-operators-foundation/pkg/client/clientset_generated/clientset/scheme"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// WorkSetsGetter has a method to return a WorkSetInterface.
// A group's client should implement this interface.
type WorkSetsGetter interface {
	WorkSets(namespace string) WorkSetInterface
}

// WorkSetInterface has methods to work with WorkSet resources.
type WorkSetInterface interface {
	Create(*v1alpha1.WorkSet) (*v1alpha1.WorkSet, error)
	Update(*v1alpha1.WorkSet) (*v1alpha1.WorkSet, error)
	UpdateStatus(*v1alpha1.WorkSet) (*v1alpha1.WorkSet, error)
	Delete(name string, options *v1.DeleteOptions) error
	DeleteCollection(options *v1.DeleteOptions, listOptions v1.ListOptions) error
	Get(name string, options v1.GetOptions) (*v1alpha1.WorkSet, error)
	List(opts v1.ListOptions) (*v1alpha1.WorkSetList, error)
	Watch(opts v1.ListOptions) (watch.Interface, error)
	Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1alpha1.WorkSet, err error)
	WorkSetExpansion
}

// workSets implements WorkSetInterface
type workSets struct {
	client rest.Interface
	ns     string
}

// newWorkSets returns a WorkSets
func newWorkSets(c *McmV1alpha1Client, namespace string) *workSets {
	return &workSets{
		client: c.RESTClient(),
		ns:     namespace,
	}
}

// Get takes name of the workSet, and returns the corresponding workSet object, and an error if there is any.
func (c *workSets) Get(name string, options v1.GetOptions) (result *v1alpha1.WorkSet, err error) {
	result = &v1alpha1.WorkSet{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("worksets").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do().
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of WorkSets that match those selectors.
func (c *workSets) List(opts v1.ListOptions) (result *v1alpha1.WorkSetList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1alpha1.WorkSetList{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("worksets").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do().
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested workSets.
func (c *workSets) Watch(opts v1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Namespace(c.ns).
		Resource("worksets").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch()
}

// Create takes the representation of a workSet and creates it.  Returns the server's representation of the workSet, and an error, if there is any.
func (c *workSets) Create(workSet *v1alpha1.WorkSet) (result *v1alpha1.WorkSet, err error) {
	result = &v1alpha1.WorkSet{}
	err = c.client.Post().
		Namespace(c.ns).
		Resource("worksets").
		Body(workSet).
		Do().
		Into(result)
	return
}

// Update takes the representation of a workSet and updates it. Returns the server's representation of the workSet, and an error, if there is any.
func (c *workSets) Update(workSet *v1alpha1.WorkSet) (result *v1alpha1.WorkSet, err error) {
	result = &v1alpha1.WorkSet{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("worksets").
		Name(workSet.Name).
		Body(workSet).
		Do().
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().

func (c *workSets) UpdateStatus(workSet *v1alpha1.WorkSet) (result *v1alpha1.WorkSet, err error) {
	result = &v1alpha1.WorkSet{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("worksets").
		Name(workSet.Name).
		SubResource("status").
		Body(workSet).
		Do().
		Into(result)
	return
}

// Delete takes name of the workSet and deletes it. Returns an error if one occurs.
func (c *workSets) Delete(name string, options *v1.DeleteOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("worksets").
		Name(name).
		Body(options).
		Do().
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *workSets) DeleteCollection(options *v1.DeleteOptions, listOptions v1.ListOptions) error {
	var timeout time.Duration
	if listOptions.TimeoutSeconds != nil {
		timeout = time.Duration(*listOptions.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Namespace(c.ns).
		Resource("worksets").
		VersionedParams(&listOptions, scheme.ParameterCodec).
		Timeout(timeout).
		Body(options).
		Do().
		Error()
}

// Patch applies the patch and returns the patched workSet.
func (c *workSets) Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1alpha1.WorkSet, err error) {
	result = &v1alpha1.WorkSet{}
	err = c.client.Patch(pt).
		Namespace(c.ns).
		Resource("worksets").
		SubResource(subresources...).
		Name(name).
		Body(data).
		Do().
		Into(result)
	return
}
