// Licensed Materials - Property of IBM
// (c) Copyright IBM Corporation 2018. All Rights Reserved.
// Note to U.S. Government Users Restricted Rights:
// Use, duplication or disclosure restricted by GSA ADP Schedule
// Contract with IBM Corp.

// Code generated by client-gen. DO NOT EDIT.

package internalversion

import (
	"time"

	mcm "github.com/open-cluster-management/multicloud-operators-foundation/pkg/apis/mcm"
	scheme "github.com/open-cluster-management/multicloud-operators-foundation/pkg/client/clientset_generated/internalclientset/scheme"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// PlacementPoliciesGetter has a method to return a PlacementPolicyInterface.
// A group's client should implement this interface.
type PlacementPoliciesGetter interface {
	PlacementPolicies(namespace string) PlacementPolicyInterface
}

// PlacementPolicyInterface has methods to work with PlacementPolicy resources.
type PlacementPolicyInterface interface {
	Create(*mcm.PlacementPolicy) (*mcm.PlacementPolicy, error)
	Update(*mcm.PlacementPolicy) (*mcm.PlacementPolicy, error)
	UpdateStatus(*mcm.PlacementPolicy) (*mcm.PlacementPolicy, error)
	Delete(name string, options *v1.DeleteOptions) error
	DeleteCollection(options *v1.DeleteOptions, listOptions v1.ListOptions) error
	Get(name string, options v1.GetOptions) (*mcm.PlacementPolicy, error)
	List(opts v1.ListOptions) (*mcm.PlacementPolicyList, error)
	Watch(opts v1.ListOptions) (watch.Interface, error)
	Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *mcm.PlacementPolicy, err error)
	PlacementPolicyExpansion
}

// placementPolicies implements PlacementPolicyInterface
type placementPolicies struct {
	client rest.Interface
	ns     string
}

// newPlacementPolicies returns a PlacementPolicies
func newPlacementPolicies(c *McmClient, namespace string) *placementPolicies {
	return &placementPolicies{
		client: c.RESTClient(),
		ns:     namespace,
	}
}

// Get takes name of the placementPolicy, and returns the corresponding placementPolicy object, and an error if there is any.
func (c *placementPolicies) Get(name string, options v1.GetOptions) (result *mcm.PlacementPolicy, err error) {
	result = &mcm.PlacementPolicy{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("placementpolicies").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do().
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of PlacementPolicies that match those selectors.
func (c *placementPolicies) List(opts v1.ListOptions) (result *mcm.PlacementPolicyList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &mcm.PlacementPolicyList{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("placementpolicies").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do().
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested placementPolicies.
func (c *placementPolicies) Watch(opts v1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Namespace(c.ns).
		Resource("placementpolicies").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch()
}

// Create takes the representation of a placementPolicy and creates it.  Returns the server's representation of the placementPolicy, and an error, if there is any.
func (c *placementPolicies) Create(placementPolicy *mcm.PlacementPolicy) (result *mcm.PlacementPolicy, err error) {
	result = &mcm.PlacementPolicy{}
	err = c.client.Post().
		Namespace(c.ns).
		Resource("placementpolicies").
		Body(placementPolicy).
		Do().
		Into(result)
	return
}

// Update takes the representation of a placementPolicy and updates it. Returns the server's representation of the placementPolicy, and an error, if there is any.
func (c *placementPolicies) Update(placementPolicy *mcm.PlacementPolicy) (result *mcm.PlacementPolicy, err error) {
	result = &mcm.PlacementPolicy{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("placementpolicies").
		Name(placementPolicy.Name).
		Body(placementPolicy).
		Do().
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().

func (c *placementPolicies) UpdateStatus(placementPolicy *mcm.PlacementPolicy) (result *mcm.PlacementPolicy, err error) {
	result = &mcm.PlacementPolicy{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("placementpolicies").
		Name(placementPolicy.Name).
		SubResource("status").
		Body(placementPolicy).
		Do().
		Into(result)
	return
}

// Delete takes name of the placementPolicy and deletes it. Returns an error if one occurs.
func (c *placementPolicies) Delete(name string, options *v1.DeleteOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("placementpolicies").
		Name(name).
		Body(options).
		Do().
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *placementPolicies) DeleteCollection(options *v1.DeleteOptions, listOptions v1.ListOptions) error {
	var timeout time.Duration
	if listOptions.TimeoutSeconds != nil {
		timeout = time.Duration(*listOptions.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Namespace(c.ns).
		Resource("placementpolicies").
		VersionedParams(&listOptions, scheme.ParameterCodec).
		Timeout(timeout).
		Body(options).
		Do().
		Error()
}

// Patch applies the patch and returns the patched placementPolicy.
func (c *placementPolicies) Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *mcm.PlacementPolicy, err error) {
	result = &mcm.PlacementPolicy{}
	err = c.client.Patch(pt).
		Namespace(c.ns).
		Resource("placementpolicies").
		SubResource(subresources...).
		Name(name).
		Body(data).
		Do().
		Into(result)
	return
}
