# Release process

## Semi-automatic

1. associate a gpg key to your github account. See: https://help.github.com/en/articles/signing-commits
2. Make sure your repo is clean by git's standards
3. If this is a new minor release, create a new release branch and push to github, for example `release-0.2`
4. run `go run cmd/release/main.go -version v0.1.2` but replace the version with the version you'd like.
5. push the docker images that were generated with this release tool
6. Edit the release notes and make sure the binaries uploaded return the correct version
7. Perform the [image promotion process](https://github.com/kubernetes/k8s.io/tree/master/k8s.gcr.io#image-promoter)
8. Publish draft
9. If it's a major release, notify `kubernetes-dev@googlegroups.com`

## Manual

1. Make sure your repo is clean by git's standards
2. If this is a new minor release, create a new release branch and push to github, for example `release-0.2`
3. Tag the repository and push the tag `git tag -s $VERSION`
4. Create a draft release in github and associate it with the tag that was just created
5. Checkout the tag you've just created and make sure git is in a clean state
6. Run `make release-artifacts REGISTRY=us.gcr.io/k8s-artifacts-prod/cluster-api-aws MANAGER_IMAGE_TAG=${VERSION}`
7. Attach the tarball to the drafted release
8. Attach `clusterawsadm` and `clusterctl` to the drafted release (for darwin and linux architectures)
9. Run `make docker-build docker-push REGISTRY=gcr.io/k8s-staging-cluster-api-aws MANAGER_IMAGE_TAG=${VERSION}`
10. Perform the [image promotion process](https://github.com/kubernetes/k8s.io/tree/master/k8s.gcr.io#image-promoter)
11. Write the release notes (see note below on release notes)
12. Publish release
13. Email `kubernetes-dev@googlegroups.com` to announce the release

## Expected artifacts

1. A container image containing the aws-provider manager binary
2. A release tarball containing the manifest-templates and a script to generate
   the actual manifests
3. `clusterctl`
4. `clusterawsadm`
5. Release notes
6. Email to `kubernetes-dev@googlegroups.com` announcing the release

## Output locations

### Container image

The container image will live in the registry `gcr.io/k8s-staging-cluster-api-aws`
under the image name `cluster-api-aws-controller:<tag>` where `<tag>` is
replaced by the version being released.

### Manifests

Manifests must be generated by hand.

Running `make release-artifacts` will create a tarball that you can attach to
the drafted release.

### Binaries

The two binaries produced by a release are the `clusterctl` binary and the
`clusterawsadm` binary. There should be support for both darwin and linux architectures.

### Release Notes

Release notes are written by hand. Generally we'll make a [hackmd](hackmd.io)
and share the release note responsibility for a few days in advance of the
release.

The markdown is shared in the kubernetes slack in the channel #cluster-api-aws.
