/*
Copyright 2018 The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package sts

import (
	"regexp"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/service/sts"
	"github.com/pkg/errors"
)

var reAccountID = regexp.MustCompile(`[0-9]{12}`)

// AccountID gets the current account ID
func (s *Service) AccountID() (string, error) {
	input := &sts.GetCallerIdentityInput{}

	out, err := s.STS.GetCallerIdentity(input)

	if err != nil {
		return "", errors.Wrap(err, "unable to get caller identity")
	}

	return aws.StringValue(out.Account), nil
}

// ValidateAccountID checks an account ID is valid
func ValidateAccountID(str string) bool {
	return reAccountID.MatchString(str) && len(str) == 12
}
