package apimanagement

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// APIProtocolContract enumerates the values for api protocol contract.
type APIProtocolContract string

const (
	// HTTP ...
	HTTP APIProtocolContract = "Http"
	// HTTPS ...
	HTTPS APIProtocolContract = "Https"
)

// PossibleAPIProtocolContractValues returns an array of possible values for the APIProtocolContract const type.
func PossibleAPIProtocolContractValues() []APIProtocolContract {
	return []APIProtocolContract{HTTP, HTTPS}
}

// APITypeContract enumerates the values for api type contract.
type APITypeContract string

const (
	// APITypeContractHTTP ...
	APITypeContractHTTP APITypeContract = "Http"
	// APITypeContractSoap ...
	APITypeContractSoap APITypeContract = "Soap"
)

// PossibleAPITypeContractValues returns an array of possible values for the APITypeContract const type.
func PossibleAPITypeContractValues() []APITypeContract {
	return []APITypeContract{APITypeContractHTTP, APITypeContractSoap}
}

// AsyncOperationState enumerates the values for async operation state.
type AsyncOperationState string

const (
	// Failed ...
	Failed AsyncOperationState = "Failed"
	// InProgress ...
	InProgress AsyncOperationState = "InProgress"
	// Started ...
	Started AsyncOperationState = "Started"
	// Succeeded ...
	Succeeded AsyncOperationState = "Succeeded"
)

// PossibleAsyncOperationStateValues returns an array of possible values for the AsyncOperationState const type.
func PossibleAsyncOperationStateValues() []AsyncOperationState {
	return []AsyncOperationState{Failed, InProgress, Started, Succeeded}
}

// BearerTokenSendingMethodsContract enumerates the values for bearer token sending methods contract.
type BearerTokenSendingMethodsContract string

const (
	// AuthorizationHeader ...
	AuthorizationHeader BearerTokenSendingMethodsContract = "authorizationHeader"
	// Query ...
	Query BearerTokenSendingMethodsContract = "query"
)

// PossibleBearerTokenSendingMethodsContractValues returns an array of possible values for the BearerTokenSendingMethodsContract const type.
func PossibleBearerTokenSendingMethodsContractValues() []BearerTokenSendingMethodsContract {
	return []BearerTokenSendingMethodsContract{AuthorizationHeader, Query}
}

// ClientAuthenticationMethodContract enumerates the values for client authentication method contract.
type ClientAuthenticationMethodContract string

const (
	// Basic ...
	Basic ClientAuthenticationMethodContract = "Basic"
	// Body ...
	Body ClientAuthenticationMethodContract = "Body"
)

// PossibleClientAuthenticationMethodContractValues returns an array of possible values for the ClientAuthenticationMethodContract const type.
func PossibleClientAuthenticationMethodContractValues() []ClientAuthenticationMethodContract {
	return []ClientAuthenticationMethodContract{Basic, Body}
}

// GrantTypesContract enumerates the values for grant types contract.
type GrantTypesContract string

const (
	// AuthorizationCode ...
	AuthorizationCode GrantTypesContract = "authorizationCode"
	// ClientCredentials ...
	ClientCredentials GrantTypesContract = "clientCredentials"
	// Implicit ...
	Implicit GrantTypesContract = "implicit"
	// ResourceOwnerPassword ...
	ResourceOwnerPassword GrantTypesContract = "resourceOwnerPassword"
)

// PossibleGrantTypesContractValues returns an array of possible values for the GrantTypesContract const type.
func PossibleGrantTypesContractValues() []GrantTypesContract {
	return []GrantTypesContract{AuthorizationCode, ClientCredentials, Implicit, ResourceOwnerPassword}
}

// GroupTypeContract enumerates the values for group type contract.
type GroupTypeContract string

const (
	// Custom ...
	Custom GroupTypeContract = "Custom"
	// External ...
	External GroupTypeContract = "External"
	// System ...
	System GroupTypeContract = "System"
)

// PossibleGroupTypeContractValues returns an array of possible values for the GroupTypeContract const type.
func PossibleGroupTypeContractValues() []GroupTypeContract {
	return []GroupTypeContract{Custom, External, System}
}

// HostnameType enumerates the values for hostname type.
type HostnameType string

const (
	// Management ...
	Management HostnameType = "Management"
	// Portal ...
	Portal HostnameType = "Portal"
	// Proxy ...
	Proxy HostnameType = "Proxy"
	// Scm ...
	Scm HostnameType = "Scm"
)

// PossibleHostnameTypeValues returns an array of possible values for the HostnameType const type.
func PossibleHostnameTypeValues() []HostnameType {
	return []HostnameType{Management, Portal, Proxy, Scm}
}

// HTTPStatusCode enumerates the values for http status code.
type HTTPStatusCode string

const (
	// Accepted ...
	Accepted HTTPStatusCode = "Accepted"
	// Conflict ...
	Conflict HTTPStatusCode = "Conflict"
	// Continue ...
	Continue HTTPStatusCode = "Continue"
	// Created ...
	Created HTTPStatusCode = "Created"
	// NotFound ...
	NotFound HTTPStatusCode = "NotFound"
	// OK ...
	OK HTTPStatusCode = "OK"
)

// PossibleHTTPStatusCodeValues returns an array of possible values for the HTTPStatusCode const type.
func PossibleHTTPStatusCodeValues() []HTTPStatusCode {
	return []HTTPStatusCode{Accepted, Conflict, Continue, Created, NotFound, OK}
}

// IdentityProviderNameType enumerates the values for identity provider name type.
type IdentityProviderNameType string

const (
	// Aad ...
	Aad IdentityProviderNameType = "aad"
	// Facebook ...
	Facebook IdentityProviderNameType = "facebook"
	// Google ...
	Google IdentityProviderNameType = "google"
	// Microsoft ...
	Microsoft IdentityProviderNameType = "microsoft"
	// Twitter ...
	Twitter IdentityProviderNameType = "twitter"
)

// PossibleIdentityProviderNameTypeValues returns an array of possible values for the IdentityProviderNameType const type.
func PossibleIdentityProviderNameTypeValues() []IdentityProviderNameType {
	return []IdentityProviderNameType{Aad, Facebook, Google, Microsoft, Twitter}
}

// MethodContract enumerates the values for method contract.
type MethodContract string

const (
	// DELETE ...
	DELETE MethodContract = "DELETE"
	// GET ...
	GET MethodContract = "GET"
	// HEAD ...
	HEAD MethodContract = "HEAD"
	// OPTIONS ...
	OPTIONS MethodContract = "OPTIONS"
	// PATCH ...
	PATCH MethodContract = "PATCH"
	// POST ...
	POST MethodContract = "POST"
	// PUT ...
	PUT MethodContract = "PUT"
	// TRACE ...
	TRACE MethodContract = "TRACE"
)

// PossibleMethodContractValues returns an array of possible values for the MethodContract const type.
func PossibleMethodContractValues() []MethodContract {
	return []MethodContract{DELETE, GET, HEAD, OPTIONS, PATCH, POST, PUT, TRACE}
}

// NameAvailabilityReason enumerates the values for name availability reason.
type NameAvailabilityReason string

const (
	// AlreadyExists ...
	AlreadyExists NameAvailabilityReason = "AlreadyExists"
	// Invalid ...
	Invalid NameAvailabilityReason = "Invalid"
	// Valid ...
	Valid NameAvailabilityReason = "Valid"
)

// PossibleNameAvailabilityReasonValues returns an array of possible values for the NameAvailabilityReason const type.
func PossibleNameAvailabilityReasonValues() []NameAvailabilityReason {
	return []NameAvailabilityReason{AlreadyExists, Invalid, Valid}
}

// OperationStatus enumerates the values for operation status.
type OperationStatus string

const (
	// OperationStatusFailed ...
	OperationStatusFailed OperationStatus = "Failed"
	// OperationStatusInProgress ...
	OperationStatusInProgress OperationStatus = "InProgress"
	// OperationStatusSucceeded ...
	OperationStatusSucceeded OperationStatus = "Succeeded"
)

// PossibleOperationStatusValues returns an array of possible values for the OperationStatus const type.
func PossibleOperationStatusValues() []OperationStatus {
	return []OperationStatus{OperationStatusFailed, OperationStatusInProgress, OperationStatusSucceeded}
}

// PolicyScopeContract enumerates the values for policy scope contract.
type PolicyScopeContract string

const (
	// All ...
	All PolicyScopeContract = "All"
	// API ...
	API PolicyScopeContract = "Api"
	// Operation ...
	Operation PolicyScopeContract = "Operation"
	// Product ...
	Product PolicyScopeContract = "Product"
	// Tenant ...
	Tenant PolicyScopeContract = "Tenant"
)

// PossiblePolicyScopeContractValues returns an array of possible values for the PolicyScopeContract const type.
func PossiblePolicyScopeContractValues() []PolicyScopeContract {
	return []PolicyScopeContract{All, API, Operation, Product, Tenant}
}

// ProductStateContract enumerates the values for product state contract.
type ProductStateContract string

const (
	// NotPublished ...
	NotPublished ProductStateContract = "NotPublished"
	// Published ...
	Published ProductStateContract = "Published"
)

// PossibleProductStateContractValues returns an array of possible values for the ProductStateContract const type.
func PossibleProductStateContractValues() []ProductStateContract {
	return []ProductStateContract{NotPublished, Published}
}

// ReportsAggregation enumerates the values for reports aggregation.
type ReportsAggregation string

const (
	// ByAPI ...
	ByAPI ReportsAggregation = "byApi"
	// ByGeo ...
	ByGeo ReportsAggregation = "byGeo"
	// ByOperation ...
	ByOperation ReportsAggregation = "byOperation"
	// ByProduct ...
	ByProduct ReportsAggregation = "byProduct"
	// BySubscription ...
	BySubscription ReportsAggregation = "bySubscription"
	// ByTime ...
	ByTime ReportsAggregation = "byTime"
	// ByUser ...
	ByUser ReportsAggregation = "byUser"
)

// PossibleReportsAggregationValues returns an array of possible values for the ReportsAggregation const type.
func PossibleReportsAggregationValues() []ReportsAggregation {
	return []ReportsAggregation{ByAPI, ByGeo, ByOperation, ByProduct, BySubscription, ByTime, ByUser}
}

// SkuType enumerates the values for sku type.
type SkuType string

const (
	// Developer ...
	Developer SkuType = "Developer"
	// Premium ...
	Premium SkuType = "Premium"
	// Standard ...
	Standard SkuType = "Standard"
)

// PossibleSkuTypeValues returns an array of possible values for the SkuType const type.
func PossibleSkuTypeValues() []SkuType {
	return []SkuType{Developer, Premium, Standard}
}

// SubscriptionStateContract enumerates the values for subscription state contract.
type SubscriptionStateContract string

const (
	// Active ...
	Active SubscriptionStateContract = "Active"
	// Cancelled ...
	Cancelled SubscriptionStateContract = "Cancelled"
	// Expired ...
	Expired SubscriptionStateContract = "Expired"
	// Rejected ...
	Rejected SubscriptionStateContract = "Rejected"
	// Submitted ...
	Submitted SubscriptionStateContract = "Submitted"
	// Suspended ...
	Suspended SubscriptionStateContract = "Suspended"
)

// PossibleSubscriptionStateContractValues returns an array of possible values for the SubscriptionStateContract const type.
func PossibleSubscriptionStateContractValues() []SubscriptionStateContract {
	return []SubscriptionStateContract{Active, Cancelled, Expired, Rejected, Submitted, Suspended}
}

// UserStateContract enumerates the values for user state contract.
type UserStateContract string

const (
	// UserStateContractActive ...
	UserStateContractActive UserStateContract = "Active"
	// UserStateContractBlocked ...
	UserStateContractBlocked UserStateContract = "Blocked"
)

// PossibleUserStateContractValues returns an array of possible values for the UserStateContract const type.
func PossibleUserStateContractValues() []UserStateContract {
	return []UserStateContract{UserStateContractActive, UserStateContractBlocked}
}

// VirtualNetworkType enumerates the values for virtual network type.
type VirtualNetworkType string

const (
	// VirtualNetworkTypeExternal ...
	VirtualNetworkTypeExternal VirtualNetworkType = "External"
	// VirtualNetworkTypeInternal ...
	VirtualNetworkTypeInternal VirtualNetworkType = "Internal"
	// VirtualNetworkTypeNone ...
	VirtualNetworkTypeNone VirtualNetworkType = "None"
)

// PossibleVirtualNetworkTypeValues returns an array of possible values for the VirtualNetworkType const type.
func PossibleVirtualNetworkTypeValues() []VirtualNetworkType {
	return []VirtualNetworkType{VirtualNetworkTypeExternal, VirtualNetworkTypeInternal, VirtualNetworkTypeNone}
}
