package cdn

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// CacheBehavior enumerates the values for cache behavior.
type CacheBehavior string

const (
	// BypassCache ...
	BypassCache CacheBehavior = "BypassCache"
	// Override ...
	Override CacheBehavior = "Override"
	// SetIfMissing ...
	SetIfMissing CacheBehavior = "SetIfMissing"
)

// PossibleCacheBehaviorValues returns an array of possible values for the CacheBehavior const type.
func PossibleCacheBehaviorValues() []CacheBehavior {
	return []CacheBehavior{BypassCache, Override, SetIfMissing}
}

// CertificateSource enumerates the values for certificate source.
type CertificateSource string

const (
	// CertificateSourceAzureKeyVault ...
	CertificateSourceAzureKeyVault CertificateSource = "AzureKeyVault"
	// CertificateSourceCdn ...
	CertificateSourceCdn CertificateSource = "Cdn"
	// CertificateSourceCustomDomainHTTPSParameters ...
	CertificateSourceCustomDomainHTTPSParameters CertificateSource = "CustomDomainHttpsParameters"
)

// PossibleCertificateSourceValues returns an array of possible values for the CertificateSource const type.
func PossibleCertificateSourceValues() []CertificateSource {
	return []CertificateSource{CertificateSourceAzureKeyVault, CertificateSourceCdn, CertificateSourceCustomDomainHTTPSParameters}
}

// CertificateType enumerates the values for certificate type.
type CertificateType string

const (
	// Dedicated ...
	Dedicated CertificateType = "Dedicated"
	// Shared ...
	Shared CertificateType = "Shared"
)

// PossibleCertificateTypeValues returns an array of possible values for the CertificateType const type.
func PossibleCertificateTypeValues() []CertificateType {
	return []CertificateType{Dedicated, Shared}
}

// CustomDomainResourceState enumerates the values for custom domain resource state.
type CustomDomainResourceState string

const (
	// Active ...
	Active CustomDomainResourceState = "Active"
	// Creating ...
	Creating CustomDomainResourceState = "Creating"
	// Deleting ...
	Deleting CustomDomainResourceState = "Deleting"
)

// PossibleCustomDomainResourceStateValues returns an array of possible values for the CustomDomainResourceState const type.
func PossibleCustomDomainResourceStateValues() []CustomDomainResourceState {
	return []CustomDomainResourceState{Active, Creating, Deleting}
}

// CustomHTTPSProvisioningState enumerates the values for custom https provisioning state.
type CustomHTTPSProvisioningState string

const (
	// Disabled ...
	Disabled CustomHTTPSProvisioningState = "Disabled"
	// Disabling ...
	Disabling CustomHTTPSProvisioningState = "Disabling"
	// Enabled ...
	Enabled CustomHTTPSProvisioningState = "Enabled"
	// Enabling ...
	Enabling CustomHTTPSProvisioningState = "Enabling"
	// Failed ...
	Failed CustomHTTPSProvisioningState = "Failed"
)

// PossibleCustomHTTPSProvisioningStateValues returns an array of possible values for the CustomHTTPSProvisioningState const type.
func PossibleCustomHTTPSProvisioningStateValues() []CustomHTTPSProvisioningState {
	return []CustomHTTPSProvisioningState{Disabled, Disabling, Enabled, Enabling, Failed}
}

// CustomHTTPSProvisioningSubstate enumerates the values for custom https provisioning substate.
type CustomHTTPSProvisioningSubstate string

const (
	// CertificateDeleted ...
	CertificateDeleted CustomHTTPSProvisioningSubstate = "CertificateDeleted"
	// CertificateDeployed ...
	CertificateDeployed CustomHTTPSProvisioningSubstate = "CertificateDeployed"
	// DeletingCertificate ...
	DeletingCertificate CustomHTTPSProvisioningSubstate = "DeletingCertificate"
	// DeployingCertificate ...
	DeployingCertificate CustomHTTPSProvisioningSubstate = "DeployingCertificate"
	// DomainControlValidationRequestApproved ...
	DomainControlValidationRequestApproved CustomHTTPSProvisioningSubstate = "DomainControlValidationRequestApproved"
	// DomainControlValidationRequestRejected ...
	DomainControlValidationRequestRejected CustomHTTPSProvisioningSubstate = "DomainControlValidationRequestRejected"
	// DomainControlValidationRequestTimedOut ...
	DomainControlValidationRequestTimedOut CustomHTTPSProvisioningSubstate = "DomainControlValidationRequestTimedOut"
	// IssuingCertificate ...
	IssuingCertificate CustomHTTPSProvisioningSubstate = "IssuingCertificate"
	// PendingDomainControlValidationREquestApproval ...
	PendingDomainControlValidationREquestApproval CustomHTTPSProvisioningSubstate = "PendingDomainControlValidationREquestApproval"
	// SubmittingDomainControlValidationRequest ...
	SubmittingDomainControlValidationRequest CustomHTTPSProvisioningSubstate = "SubmittingDomainControlValidationRequest"
)

// PossibleCustomHTTPSProvisioningSubstateValues returns an array of possible values for the CustomHTTPSProvisioningSubstate const type.
func PossibleCustomHTTPSProvisioningSubstateValues() []CustomHTTPSProvisioningSubstate {
	return []CustomHTTPSProvisioningSubstate{CertificateDeleted, CertificateDeployed, DeletingCertificate, DeployingCertificate, DomainControlValidationRequestApproved, DomainControlValidationRequestRejected, DomainControlValidationRequestTimedOut, IssuingCertificate, PendingDomainControlValidationREquestApproval, SubmittingDomainControlValidationRequest}
}

// EndpointResourceState enumerates the values for endpoint resource state.
type EndpointResourceState string

const (
	// EndpointResourceStateCreating ...
	EndpointResourceStateCreating EndpointResourceState = "Creating"
	// EndpointResourceStateDeleting ...
	EndpointResourceStateDeleting EndpointResourceState = "Deleting"
	// EndpointResourceStateRunning ...
	EndpointResourceStateRunning EndpointResourceState = "Running"
	// EndpointResourceStateStarting ...
	EndpointResourceStateStarting EndpointResourceState = "Starting"
	// EndpointResourceStateStopped ...
	EndpointResourceStateStopped EndpointResourceState = "Stopped"
	// EndpointResourceStateStopping ...
	EndpointResourceStateStopping EndpointResourceState = "Stopping"
)

// PossibleEndpointResourceStateValues returns an array of possible values for the EndpointResourceState const type.
func PossibleEndpointResourceStateValues() []EndpointResourceState {
	return []EndpointResourceState{EndpointResourceStateCreating, EndpointResourceStateDeleting, EndpointResourceStateRunning, EndpointResourceStateStarting, EndpointResourceStateStopped, EndpointResourceStateStopping}
}

// GeoFilterActions enumerates the values for geo filter actions.
type GeoFilterActions string

const (
	// Allow ...
	Allow GeoFilterActions = "Allow"
	// Block ...
	Block GeoFilterActions = "Block"
)

// PossibleGeoFilterActionsValues returns an array of possible values for the GeoFilterActions const type.
func PossibleGeoFilterActionsValues() []GeoFilterActions {
	return []GeoFilterActions{Allow, Block}
}

// MatchType enumerates the values for match type.
type MatchType string

const (
	// Literal ...
	Literal MatchType = "Literal"
	// Wildcard ...
	Wildcard MatchType = "Wildcard"
)

// PossibleMatchTypeValues returns an array of possible values for the MatchType const type.
func PossibleMatchTypeValues() []MatchType {
	return []MatchType{Literal, Wildcard}
}

// Name enumerates the values for name.
type Name string

const (
	// NameCacheExpiration ...
	NameCacheExpiration Name = "CacheExpiration"
	// NameDeliveryRuleAction ...
	NameDeliveryRuleAction Name = "DeliveryRuleAction"
)

// PossibleNameValues returns an array of possible values for the Name const type.
func PossibleNameValues() []Name {
	return []Name{NameCacheExpiration, NameDeliveryRuleAction}
}

// NameBasicDeliveryRuleCondition enumerates the values for name basic delivery rule condition.
type NameBasicDeliveryRuleCondition string

const (
	// NameDeliveryRuleCondition ...
	NameDeliveryRuleCondition NameBasicDeliveryRuleCondition = "DeliveryRuleCondition"
	// NameURLFileExtension ...
	NameURLFileExtension NameBasicDeliveryRuleCondition = "UrlFileExtension"
	// NameURLPath ...
	NameURLPath NameBasicDeliveryRuleCondition = "UrlPath"
)

// PossibleNameBasicDeliveryRuleConditionValues returns an array of possible values for the NameBasicDeliveryRuleCondition const type.
func PossibleNameBasicDeliveryRuleConditionValues() []NameBasicDeliveryRuleCondition {
	return []NameBasicDeliveryRuleCondition{NameDeliveryRuleCondition, NameURLFileExtension, NameURLPath}
}

// OptimizationType enumerates the values for optimization type.
type OptimizationType string

const (
	// DynamicSiteAcceleration ...
	DynamicSiteAcceleration OptimizationType = "DynamicSiteAcceleration"
	// GeneralMediaStreaming ...
	GeneralMediaStreaming OptimizationType = "GeneralMediaStreaming"
	// GeneralWebDelivery ...
	GeneralWebDelivery OptimizationType = "GeneralWebDelivery"
	// LargeFileDownload ...
	LargeFileDownload OptimizationType = "LargeFileDownload"
	// VideoOnDemandMediaStreaming ...
	VideoOnDemandMediaStreaming OptimizationType = "VideoOnDemandMediaStreaming"
)

// PossibleOptimizationTypeValues returns an array of possible values for the OptimizationType const type.
func PossibleOptimizationTypeValues() []OptimizationType {
	return []OptimizationType{DynamicSiteAcceleration, GeneralMediaStreaming, GeneralWebDelivery, LargeFileDownload, VideoOnDemandMediaStreaming}
}

// OriginResourceState enumerates the values for origin resource state.
type OriginResourceState string

const (
	// OriginResourceStateActive ...
	OriginResourceStateActive OriginResourceState = "Active"
	// OriginResourceStateCreating ...
	OriginResourceStateCreating OriginResourceState = "Creating"
	// OriginResourceStateDeleting ...
	OriginResourceStateDeleting OriginResourceState = "Deleting"
)

// PossibleOriginResourceStateValues returns an array of possible values for the OriginResourceState const type.
func PossibleOriginResourceStateValues() []OriginResourceState {
	return []OriginResourceState{OriginResourceStateActive, OriginResourceStateCreating, OriginResourceStateDeleting}
}

// ProfileResourceState enumerates the values for profile resource state.
type ProfileResourceState string

const (
	// ProfileResourceStateActive ...
	ProfileResourceStateActive ProfileResourceState = "Active"
	// ProfileResourceStateCreating ...
	ProfileResourceStateCreating ProfileResourceState = "Creating"
	// ProfileResourceStateDeleting ...
	ProfileResourceStateDeleting ProfileResourceState = "Deleting"
	// ProfileResourceStateDisabled ...
	ProfileResourceStateDisabled ProfileResourceState = "Disabled"
)

// PossibleProfileResourceStateValues returns an array of possible values for the ProfileResourceState const type.
func PossibleProfileResourceStateValues() []ProfileResourceState {
	return []ProfileResourceState{ProfileResourceStateActive, ProfileResourceStateCreating, ProfileResourceStateDeleting, ProfileResourceStateDisabled}
}

// ProtocolType enumerates the values for protocol type.
type ProtocolType string

const (
	// IPBased ...
	IPBased ProtocolType = "IPBased"
	// ServerNameIndication ...
	ServerNameIndication ProtocolType = "ServerNameIndication"
)

// PossibleProtocolTypeValues returns an array of possible values for the ProtocolType const type.
func PossibleProtocolTypeValues() []ProtocolType {
	return []ProtocolType{IPBased, ServerNameIndication}
}

// QueryStringCachingBehavior enumerates the values for query string caching behavior.
type QueryStringCachingBehavior string

const (
	// BypassCaching ...
	BypassCaching QueryStringCachingBehavior = "BypassCaching"
	// IgnoreQueryString ...
	IgnoreQueryString QueryStringCachingBehavior = "IgnoreQueryString"
	// NotSet ...
	NotSet QueryStringCachingBehavior = "NotSet"
	// UseQueryString ...
	UseQueryString QueryStringCachingBehavior = "UseQueryString"
)

// PossibleQueryStringCachingBehaviorValues returns an array of possible values for the QueryStringCachingBehavior const type.
func PossibleQueryStringCachingBehaviorValues() []QueryStringCachingBehavior {
	return []QueryStringCachingBehavior{BypassCaching, IgnoreQueryString, NotSet, UseQueryString}
}

// ResourceType enumerates the values for resource type.
type ResourceType string

const (
	// MicrosoftCdnProfilesEndpoints ...
	MicrosoftCdnProfilesEndpoints ResourceType = "Microsoft.Cdn/Profiles/Endpoints"
)

// PossibleResourceTypeValues returns an array of possible values for the ResourceType const type.
func PossibleResourceTypeValues() []ResourceType {
	return []ResourceType{MicrosoftCdnProfilesEndpoints}
}

// SkuName enumerates the values for sku name.
type SkuName string

const (
	// CustomVerizon ...
	CustomVerizon SkuName = "Custom_Verizon"
	// PremiumChinaCdn ...
	PremiumChinaCdn SkuName = "Premium_ChinaCdn"
	// PremiumVerizon ...
	PremiumVerizon SkuName = "Premium_Verizon"
	// StandardAkamai ...
	StandardAkamai SkuName = "Standard_Akamai"
	// StandardChinaCdn ...
	StandardChinaCdn SkuName = "Standard_ChinaCdn"
	// StandardMicrosoft ...
	StandardMicrosoft SkuName = "Standard_Microsoft"
	// StandardVerizon ...
	StandardVerizon SkuName = "Standard_Verizon"
)

// PossibleSkuNameValues returns an array of possible values for the SkuName const type.
func PossibleSkuNameValues() []SkuName {
	return []SkuName{CustomVerizon, PremiumChinaCdn, PremiumVerizon, StandardAkamai, StandardChinaCdn, StandardMicrosoft, StandardVerizon}
}
