package dtl

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// CostThresholdStatus enumerates the values for cost threshold status.
type CostThresholdStatus string

const (
	// Disabled ...
	Disabled CostThresholdStatus = "Disabled"
	// Enabled ...
	Enabled CostThresholdStatus = "Enabled"
)

// PossibleCostThresholdStatusValues returns an array of possible values for the CostThresholdStatus const type.
func PossibleCostThresholdStatusValues() []CostThresholdStatus {
	return []CostThresholdStatus{Disabled, Enabled}
}

// CostType enumerates the values for cost type.
type CostType string

const (
	// Projected ...
	Projected CostType = "Projected"
	// Reported ...
	Reported CostType = "Reported"
	// Unavailable ...
	Unavailable CostType = "Unavailable"
)

// PossibleCostTypeValues returns an array of possible values for the CostType const type.
func PossibleCostTypeValues() []CostType {
	return []CostType{Projected, Reported, Unavailable}
}

// CustomImageOsType enumerates the values for custom image os type.
type CustomImageOsType string

const (
	// Linux ...
	Linux CustomImageOsType = "Linux"
	// None ...
	None CustomImageOsType = "None"
	// Windows ...
	Windows CustomImageOsType = "Windows"
)

// PossibleCustomImageOsTypeValues returns an array of possible values for the CustomImageOsType const type.
func PossibleCustomImageOsTypeValues() []CustomImageOsType {
	return []CustomImageOsType{Linux, None, Windows}
}

// EnableStatus enumerates the values for enable status.
type EnableStatus string

const (
	// EnableStatusDisabled ...
	EnableStatusDisabled EnableStatus = "Disabled"
	// EnableStatusEnabled ...
	EnableStatusEnabled EnableStatus = "Enabled"
)

// PossibleEnableStatusValues returns an array of possible values for the EnableStatus const type.
func PossibleEnableStatusValues() []EnableStatus {
	return []EnableStatus{EnableStatusDisabled, EnableStatusEnabled}
}

// FileUploadOptions enumerates the values for file upload options.
type FileUploadOptions string

const (
	// FileUploadOptionsNone ...
	FileUploadOptionsNone FileUploadOptions = "None"
	// FileUploadOptionsUploadFilesAndGenerateSasTokens ...
	FileUploadOptionsUploadFilesAndGenerateSasTokens FileUploadOptions = "UploadFilesAndGenerateSasTokens"
)

// PossibleFileUploadOptionsValues returns an array of possible values for the FileUploadOptions const type.
func PossibleFileUploadOptionsValues() []FileUploadOptions {
	return []FileUploadOptions{FileUploadOptionsNone, FileUploadOptionsUploadFilesAndGenerateSasTokens}
}

// HostCachingOptions enumerates the values for host caching options.
type HostCachingOptions string

const (
	// HostCachingOptionsNone ...
	HostCachingOptionsNone HostCachingOptions = "None"
	// HostCachingOptionsReadOnly ...
	HostCachingOptionsReadOnly HostCachingOptions = "ReadOnly"
	// HostCachingOptionsReadWrite ...
	HostCachingOptionsReadWrite HostCachingOptions = "ReadWrite"
)

// PossibleHostCachingOptionsValues returns an array of possible values for the HostCachingOptions const type.
func PossibleHostCachingOptionsValues() []HostCachingOptions {
	return []HostCachingOptions{HostCachingOptionsNone, HostCachingOptionsReadOnly, HostCachingOptionsReadWrite}
}

// HTTPStatusCode enumerates the values for http status code.
type HTTPStatusCode string

const (
	// Accepted ...
	Accepted HTTPStatusCode = "Accepted"
	// BadGateway ...
	BadGateway HTTPStatusCode = "BadGateway"
	// BadRequest ...
	BadRequest HTTPStatusCode = "BadRequest"
	// Conflict ...
	Conflict HTTPStatusCode = "Conflict"
	// Continue ...
	Continue HTTPStatusCode = "Continue"
	// Created ...
	Created HTTPStatusCode = "Created"
	// ExpectationFailed ...
	ExpectationFailed HTTPStatusCode = "ExpectationFailed"
	// Forbidden ...
	Forbidden HTTPStatusCode = "Forbidden"
	// GatewayTimeout ...
	GatewayTimeout HTTPStatusCode = "GatewayTimeout"
	// Gone ...
	Gone HTTPStatusCode = "Gone"
	// HTTPVersionNotSupported ...
	HTTPVersionNotSupported HTTPStatusCode = "HttpVersionNotSupported"
	// InternalServerError ...
	InternalServerError HTTPStatusCode = "InternalServerError"
	// LengthRequired ...
	LengthRequired HTTPStatusCode = "LengthRequired"
	// MethodNotAllowed ...
	MethodNotAllowed HTTPStatusCode = "MethodNotAllowed"
	// MovedPermanently ...
	MovedPermanently HTTPStatusCode = "MovedPermanently"
	// MultipleChoices ...
	MultipleChoices HTTPStatusCode = "MultipleChoices"
	// NoContent ...
	NoContent HTTPStatusCode = "NoContent"
	// NonAuthoritativeInformation ...
	NonAuthoritativeInformation HTTPStatusCode = "NonAuthoritativeInformation"
	// NotAcceptable ...
	NotAcceptable HTTPStatusCode = "NotAcceptable"
	// NotFound ...
	NotFound HTTPStatusCode = "NotFound"
	// NotImplemented ...
	NotImplemented HTTPStatusCode = "NotImplemented"
	// NotModified ...
	NotModified HTTPStatusCode = "NotModified"
	// OK ...
	OK HTTPStatusCode = "OK"
	// PartialContent ...
	PartialContent HTTPStatusCode = "PartialContent"
	// PaymentRequired ...
	PaymentRequired HTTPStatusCode = "PaymentRequired"
	// PreconditionFailed ...
	PreconditionFailed HTTPStatusCode = "PreconditionFailed"
	// ProxyAuthenticationRequired ...
	ProxyAuthenticationRequired HTTPStatusCode = "ProxyAuthenticationRequired"
	// Redirect ...
	Redirect HTTPStatusCode = "Redirect"
	// RequestedRangeNotSatisfiable ...
	RequestedRangeNotSatisfiable HTTPStatusCode = "RequestedRangeNotSatisfiable"
	// RequestEntityTooLarge ...
	RequestEntityTooLarge HTTPStatusCode = "RequestEntityTooLarge"
	// RequestTimeout ...
	RequestTimeout HTTPStatusCode = "RequestTimeout"
	// RequestURITooLong ...
	RequestURITooLong HTTPStatusCode = "RequestUriTooLong"
	// ResetContent ...
	ResetContent HTTPStatusCode = "ResetContent"
	// SeeOther ...
	SeeOther HTTPStatusCode = "SeeOther"
	// ServiceUnavailable ...
	ServiceUnavailable HTTPStatusCode = "ServiceUnavailable"
	// SwitchingProtocols ...
	SwitchingProtocols HTTPStatusCode = "SwitchingProtocols"
	// TemporaryRedirect ...
	TemporaryRedirect HTTPStatusCode = "TemporaryRedirect"
	// Unauthorized ...
	Unauthorized HTTPStatusCode = "Unauthorized"
	// UnsupportedMediaType ...
	UnsupportedMediaType HTTPStatusCode = "UnsupportedMediaType"
	// Unused ...
	Unused HTTPStatusCode = "Unused"
	// UpgradeRequired ...
	UpgradeRequired HTTPStatusCode = "UpgradeRequired"
	// UseProxy ...
	UseProxy HTTPStatusCode = "UseProxy"
)

// PossibleHTTPStatusCodeValues returns an array of possible values for the HTTPStatusCode const type.
func PossibleHTTPStatusCodeValues() []HTTPStatusCode {
	return []HTTPStatusCode{Accepted, BadGateway, BadRequest, Conflict, Continue, Created, ExpectationFailed, Forbidden, GatewayTimeout, Gone, HTTPVersionNotSupported, InternalServerError, LengthRequired, MethodNotAllowed, MovedPermanently, MultipleChoices, NoContent, NonAuthoritativeInformation, NotAcceptable, NotFound, NotImplemented, NotModified, OK, PartialContent, PaymentRequired, PreconditionFailed, ProxyAuthenticationRequired, Redirect, RequestedRangeNotSatisfiable, RequestEntityTooLarge, RequestTimeout, RequestURITooLong, ResetContent, SeeOther, ServiceUnavailable, SwitchingProtocols, TemporaryRedirect, Unauthorized, UnsupportedMediaType, Unused, UpgradeRequired, UseProxy}
}

// LinuxOsState enumerates the values for linux os state.
type LinuxOsState string

const (
	// DeprovisionApplied ...
	DeprovisionApplied LinuxOsState = "DeprovisionApplied"
	// DeprovisionRequested ...
	DeprovisionRequested LinuxOsState = "DeprovisionRequested"
	// NonDeprovisioned ...
	NonDeprovisioned LinuxOsState = "NonDeprovisioned"
)

// PossibleLinuxOsStateValues returns an array of possible values for the LinuxOsState const type.
func PossibleLinuxOsStateValues() []LinuxOsState {
	return []LinuxOsState{DeprovisionApplied, DeprovisionRequested, NonDeprovisioned}
}

// NotificationChannelEventType enumerates the values for notification channel event type.
type NotificationChannelEventType string

const (
	// AutoShutdown ...
	AutoShutdown NotificationChannelEventType = "AutoShutdown"
	// Cost ...
	Cost NotificationChannelEventType = "Cost"
)

// PossibleNotificationChannelEventTypeValues returns an array of possible values for the NotificationChannelEventType const type.
func PossibleNotificationChannelEventTypeValues() []NotificationChannelEventType {
	return []NotificationChannelEventType{AutoShutdown, Cost}
}

// NotificationStatus enumerates the values for notification status.
type NotificationStatus string

const (
	// NotificationStatusDisabled ...
	NotificationStatusDisabled NotificationStatus = "Disabled"
	// NotificationStatusEnabled ...
	NotificationStatusEnabled NotificationStatus = "Enabled"
)

// PossibleNotificationStatusValues returns an array of possible values for the NotificationStatus const type.
func PossibleNotificationStatusValues() []NotificationStatus {
	return []NotificationStatus{NotificationStatusDisabled, NotificationStatusEnabled}
}

// PolicyEvaluatorType enumerates the values for policy evaluator type.
type PolicyEvaluatorType string

const (
	// AllowedValuesPolicy ...
	AllowedValuesPolicy PolicyEvaluatorType = "AllowedValuesPolicy"
	// MaxValuePolicy ...
	MaxValuePolicy PolicyEvaluatorType = "MaxValuePolicy"
)

// PossiblePolicyEvaluatorTypeValues returns an array of possible values for the PolicyEvaluatorType const type.
func PossiblePolicyEvaluatorTypeValues() []PolicyEvaluatorType {
	return []PolicyEvaluatorType{AllowedValuesPolicy, MaxValuePolicy}
}

// PolicyFactName enumerates the values for policy fact name.
type PolicyFactName string

const (
	// PolicyFactNameGalleryImage ...
	PolicyFactNameGalleryImage PolicyFactName = "GalleryImage"
	// PolicyFactNameLabPremiumVMCount ...
	PolicyFactNameLabPremiumVMCount PolicyFactName = "LabPremiumVmCount"
	// PolicyFactNameLabTargetCost ...
	PolicyFactNameLabTargetCost PolicyFactName = "LabTargetCost"
	// PolicyFactNameLabVMCount ...
	PolicyFactNameLabVMCount PolicyFactName = "LabVmCount"
	// PolicyFactNameLabVMSize ...
	PolicyFactNameLabVMSize PolicyFactName = "LabVmSize"
	// PolicyFactNameUserOwnedLabPremiumVMCount ...
	PolicyFactNameUserOwnedLabPremiumVMCount PolicyFactName = "UserOwnedLabPremiumVmCount"
	// PolicyFactNameUserOwnedLabVMCount ...
	PolicyFactNameUserOwnedLabVMCount PolicyFactName = "UserOwnedLabVmCount"
	// PolicyFactNameUserOwnedLabVMCountInSubnet ...
	PolicyFactNameUserOwnedLabVMCountInSubnet PolicyFactName = "UserOwnedLabVmCountInSubnet"
)

// PossiblePolicyFactNameValues returns an array of possible values for the PolicyFactName const type.
func PossiblePolicyFactNameValues() []PolicyFactName {
	return []PolicyFactName{PolicyFactNameGalleryImage, PolicyFactNameLabPremiumVMCount, PolicyFactNameLabTargetCost, PolicyFactNameLabVMCount, PolicyFactNameLabVMSize, PolicyFactNameUserOwnedLabPremiumVMCount, PolicyFactNameUserOwnedLabVMCount, PolicyFactNameUserOwnedLabVMCountInSubnet}
}

// PolicyStatus enumerates the values for policy status.
type PolicyStatus string

const (
	// PolicyStatusDisabled ...
	PolicyStatusDisabled PolicyStatus = "Disabled"
	// PolicyStatusEnabled ...
	PolicyStatusEnabled PolicyStatus = "Enabled"
)

// PossiblePolicyStatusValues returns an array of possible values for the PolicyStatus const type.
func PossiblePolicyStatusValues() []PolicyStatus {
	return []PolicyStatus{PolicyStatusDisabled, PolicyStatusEnabled}
}

// PremiumDataDisk enumerates the values for premium data disk.
type PremiumDataDisk string

const (
	// PremiumDataDiskDisabled ...
	PremiumDataDiskDisabled PremiumDataDisk = "Disabled"
	// PremiumDataDiskEnabled ...
	PremiumDataDiskEnabled PremiumDataDisk = "Enabled"
)

// PossiblePremiumDataDiskValues returns an array of possible values for the PremiumDataDisk const type.
func PossiblePremiumDataDiskValues() []PremiumDataDisk {
	return []PremiumDataDisk{PremiumDataDiskDisabled, PremiumDataDiskEnabled}
}

// ReportingCycleType enumerates the values for reporting cycle type.
type ReportingCycleType string

const (
	// CalendarMonth ...
	CalendarMonth ReportingCycleType = "CalendarMonth"
	// Custom ...
	Custom ReportingCycleType = "Custom"
)

// PossibleReportingCycleTypeValues returns an array of possible values for the ReportingCycleType const type.
func PossibleReportingCycleTypeValues() []ReportingCycleType {
	return []ReportingCycleType{CalendarMonth, Custom}
}

// SourceControlType enumerates the values for source control type.
type SourceControlType string

const (
	// GitHub ...
	GitHub SourceControlType = "GitHub"
	// VsoGit ...
	VsoGit SourceControlType = "VsoGit"
)

// PossibleSourceControlTypeValues returns an array of possible values for the SourceControlType const type.
func PossibleSourceControlTypeValues() []SourceControlType {
	return []SourceControlType{GitHub, VsoGit}
}

// StorageType enumerates the values for storage type.
type StorageType string

const (
	// Premium ...
	Premium StorageType = "Premium"
	// Standard ...
	Standard StorageType = "Standard"
)

// PossibleStorageTypeValues returns an array of possible values for the StorageType const type.
func PossibleStorageTypeValues() []StorageType {
	return []StorageType{Premium, Standard}
}

// TargetCostStatus enumerates the values for target cost status.
type TargetCostStatus string

const (
	// TargetCostStatusDisabled ...
	TargetCostStatusDisabled TargetCostStatus = "Disabled"
	// TargetCostStatusEnabled ...
	TargetCostStatusEnabled TargetCostStatus = "Enabled"
)

// PossibleTargetCostStatusValues returns an array of possible values for the TargetCostStatus const type.
func PossibleTargetCostStatusValues() []TargetCostStatus {
	return []TargetCostStatus{TargetCostStatusDisabled, TargetCostStatusEnabled}
}

// TransportProtocol enumerates the values for transport protocol.
type TransportProtocol string

const (
	// TCP ...
	TCP TransportProtocol = "Tcp"
	// UDP ...
	UDP TransportProtocol = "Udp"
)

// PossibleTransportProtocolValues returns an array of possible values for the TransportProtocol const type.
func PossibleTransportProtocolValues() []TransportProtocol {
	return []TransportProtocol{TCP, UDP}
}

// UsagePermissionType enumerates the values for usage permission type.
type UsagePermissionType string

const (
	// Allow ...
	Allow UsagePermissionType = "Allow"
	// Default ...
	Default UsagePermissionType = "Default"
	// Deny ...
	Deny UsagePermissionType = "Deny"
)

// PossibleUsagePermissionTypeValues returns an array of possible values for the UsagePermissionType const type.
func PossibleUsagePermissionTypeValues() []UsagePermissionType {
	return []UsagePermissionType{Allow, Default, Deny}
}

// VirtualMachineCreationSource enumerates the values for virtual machine creation source.
type VirtualMachineCreationSource string

const (
	// FromCustomImage ...
	FromCustomImage VirtualMachineCreationSource = "FromCustomImage"
	// FromGalleryImage ...
	FromGalleryImage VirtualMachineCreationSource = "FromGalleryImage"
)

// PossibleVirtualMachineCreationSourceValues returns an array of possible values for the VirtualMachineCreationSource const type.
func PossibleVirtualMachineCreationSourceValues() []VirtualMachineCreationSource {
	return []VirtualMachineCreationSource{FromCustomImage, FromGalleryImage}
}

// WindowsOsState enumerates the values for windows os state.
type WindowsOsState string

const (
	// NonSysprepped ...
	NonSysprepped WindowsOsState = "NonSysprepped"
	// SysprepApplied ...
	SysprepApplied WindowsOsState = "SysprepApplied"
	// SysprepRequested ...
	SysprepRequested WindowsOsState = "SysprepRequested"
)

// PossibleWindowsOsStateValues returns an array of possible values for the WindowsOsState const type.
func PossibleWindowsOsStateValues() []WindowsOsState {
	return []WindowsOsState{NonSysprepped, SysprepApplied, SysprepRequested}
}
