package cdn

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// ActionType enumerates the values for action type.
type ActionType string

const (
	// Allow ...
	Allow ActionType = "Allow"
	// Block ...
	Block ActionType = "Block"
	// Log ...
	Log ActionType = "Log"
	// Redirect ...
	Redirect ActionType = "Redirect"
)

// PossibleActionTypeValues returns an array of possible values for the ActionType const type.
func PossibleActionTypeValues() []ActionType {
	return []ActionType{Allow, Block, Log, Redirect}
}

// Algorithm enumerates the values for algorithm.
type Algorithm string

const (
	// SHA256 ...
	SHA256 Algorithm = "SHA256"
)

// PossibleAlgorithmValues returns an array of possible values for the Algorithm const type.
func PossibleAlgorithmValues() []Algorithm {
	return []Algorithm{SHA256}
}

// CacheBehavior enumerates the values for cache behavior.
type CacheBehavior string

const (
	// BypassCache ...
	BypassCache CacheBehavior = "BypassCache"
	// Override ...
	Override CacheBehavior = "Override"
	// SetIfMissing ...
	SetIfMissing CacheBehavior = "SetIfMissing"
)

// PossibleCacheBehaviorValues returns an array of possible values for the CacheBehavior const type.
func PossibleCacheBehaviorValues() []CacheBehavior {
	return []CacheBehavior{BypassCache, Override, SetIfMissing}
}

// CertificateSource enumerates the values for certificate source.
type CertificateSource string

const (
	// CertificateSourceAzureKeyVault ...
	CertificateSourceAzureKeyVault CertificateSource = "AzureKeyVault"
	// CertificateSourceCdn ...
	CertificateSourceCdn CertificateSource = "Cdn"
	// CertificateSourceCustomDomainHTTPSParameters ...
	CertificateSourceCustomDomainHTTPSParameters CertificateSource = "CustomDomainHttpsParameters"
)

// PossibleCertificateSourceValues returns an array of possible values for the CertificateSource const type.
func PossibleCertificateSourceValues() []CertificateSource {
	return []CertificateSource{CertificateSourceAzureKeyVault, CertificateSourceCdn, CertificateSourceCustomDomainHTTPSParameters}
}

// CertificateType enumerates the values for certificate type.
type CertificateType string

const (
	// Dedicated ...
	Dedicated CertificateType = "Dedicated"
	// Shared ...
	Shared CertificateType = "Shared"
)

// PossibleCertificateTypeValues returns an array of possible values for the CertificateType const type.
func PossibleCertificateTypeValues() []CertificateType {
	return []CertificateType{Dedicated, Shared}
}

// CookiesOperator enumerates the values for cookies operator.
type CookiesOperator string

const (
	// Any ...
	Any CookiesOperator = "Any"
	// BeginsWith ...
	BeginsWith CookiesOperator = "BeginsWith"
	// Contains ...
	Contains CookiesOperator = "Contains"
	// EndsWith ...
	EndsWith CookiesOperator = "EndsWith"
	// Equal ...
	Equal CookiesOperator = "Equal"
	// GreaterThan ...
	GreaterThan CookiesOperator = "GreaterThan"
	// GreaterThanOrEqual ...
	GreaterThanOrEqual CookiesOperator = "GreaterThanOrEqual"
	// LessThan ...
	LessThan CookiesOperator = "LessThan"
	// LessThanOrEqual ...
	LessThanOrEqual CookiesOperator = "LessThanOrEqual"
)

// PossibleCookiesOperatorValues returns an array of possible values for the CookiesOperator const type.
func PossibleCookiesOperatorValues() []CookiesOperator {
	return []CookiesOperator{Any, BeginsWith, Contains, EndsWith, Equal, GreaterThan, GreaterThanOrEqual, LessThan, LessThanOrEqual}
}

// CustomDomainResourceState enumerates the values for custom domain resource state.
type CustomDomainResourceState string

const (
	// Active ...
	Active CustomDomainResourceState = "Active"
	// Creating ...
	Creating CustomDomainResourceState = "Creating"
	// Deleting ...
	Deleting CustomDomainResourceState = "Deleting"
)

// PossibleCustomDomainResourceStateValues returns an array of possible values for the CustomDomainResourceState const type.
func PossibleCustomDomainResourceStateValues() []CustomDomainResourceState {
	return []CustomDomainResourceState{Active, Creating, Deleting}
}

// CustomHTTPSProvisioningState enumerates the values for custom https provisioning state.
type CustomHTTPSProvisioningState string

const (
	// Disabled ...
	Disabled CustomHTTPSProvisioningState = "Disabled"
	// Disabling ...
	Disabling CustomHTTPSProvisioningState = "Disabling"
	// Enabled ...
	Enabled CustomHTTPSProvisioningState = "Enabled"
	// Enabling ...
	Enabling CustomHTTPSProvisioningState = "Enabling"
	// Failed ...
	Failed CustomHTTPSProvisioningState = "Failed"
)

// PossibleCustomHTTPSProvisioningStateValues returns an array of possible values for the CustomHTTPSProvisioningState const type.
func PossibleCustomHTTPSProvisioningStateValues() []CustomHTTPSProvisioningState {
	return []CustomHTTPSProvisioningState{Disabled, Disabling, Enabled, Enabling, Failed}
}

// CustomHTTPSProvisioningSubstate enumerates the values for custom https provisioning substate.
type CustomHTTPSProvisioningSubstate string

const (
	// CertificateDeleted ...
	CertificateDeleted CustomHTTPSProvisioningSubstate = "CertificateDeleted"
	// CertificateDeployed ...
	CertificateDeployed CustomHTTPSProvisioningSubstate = "CertificateDeployed"
	// DeletingCertificate ...
	DeletingCertificate CustomHTTPSProvisioningSubstate = "DeletingCertificate"
	// DeployingCertificate ...
	DeployingCertificate CustomHTTPSProvisioningSubstate = "DeployingCertificate"
	// DomainControlValidationRequestApproved ...
	DomainControlValidationRequestApproved CustomHTTPSProvisioningSubstate = "DomainControlValidationRequestApproved"
	// DomainControlValidationRequestRejected ...
	DomainControlValidationRequestRejected CustomHTTPSProvisioningSubstate = "DomainControlValidationRequestRejected"
	// DomainControlValidationRequestTimedOut ...
	DomainControlValidationRequestTimedOut CustomHTTPSProvisioningSubstate = "DomainControlValidationRequestTimedOut"
	// IssuingCertificate ...
	IssuingCertificate CustomHTTPSProvisioningSubstate = "IssuingCertificate"
	// PendingDomainControlValidationREquestApproval ...
	PendingDomainControlValidationREquestApproval CustomHTTPSProvisioningSubstate = "PendingDomainControlValidationREquestApproval"
	// SubmittingDomainControlValidationRequest ...
	SubmittingDomainControlValidationRequest CustomHTTPSProvisioningSubstate = "SubmittingDomainControlValidationRequest"
)

// PossibleCustomHTTPSProvisioningSubstateValues returns an array of possible values for the CustomHTTPSProvisioningSubstate const type.
func PossibleCustomHTTPSProvisioningSubstateValues() []CustomHTTPSProvisioningSubstate {
	return []CustomHTTPSProvisioningSubstate{CertificateDeleted, CertificateDeployed, DeletingCertificate, DeployingCertificate, DomainControlValidationRequestApproved, DomainControlValidationRequestRejected, DomainControlValidationRequestTimedOut, IssuingCertificate, PendingDomainControlValidationREquestApproval, SubmittingDomainControlValidationRequest}
}

// CustomRuleEnabledState enumerates the values for custom rule enabled state.
type CustomRuleEnabledState string

const (
	// CustomRuleEnabledStateDisabled ...
	CustomRuleEnabledStateDisabled CustomRuleEnabledState = "Disabled"
	// CustomRuleEnabledStateEnabled ...
	CustomRuleEnabledStateEnabled CustomRuleEnabledState = "Enabled"
)

// PossibleCustomRuleEnabledStateValues returns an array of possible values for the CustomRuleEnabledState const type.
func PossibleCustomRuleEnabledStateValues() []CustomRuleEnabledState {
	return []CustomRuleEnabledState{CustomRuleEnabledStateDisabled, CustomRuleEnabledStateEnabled}
}

// DestinationProtocol enumerates the values for destination protocol.
type DestinationProtocol string

const (
	// HTTP ...
	HTTP DestinationProtocol = "Http"
	// HTTPS ...
	HTTPS DestinationProtocol = "Https"
	// MatchRequest ...
	MatchRequest DestinationProtocol = "MatchRequest"
)

// PossibleDestinationProtocolValues returns an array of possible values for the DestinationProtocol const type.
func PossibleDestinationProtocolValues() []DestinationProtocol {
	return []DestinationProtocol{HTTP, HTTPS, MatchRequest}
}

// EndpointResourceState enumerates the values for endpoint resource state.
type EndpointResourceState string

const (
	// EndpointResourceStateCreating ...
	EndpointResourceStateCreating EndpointResourceState = "Creating"
	// EndpointResourceStateDeleting ...
	EndpointResourceStateDeleting EndpointResourceState = "Deleting"
	// EndpointResourceStateRunning ...
	EndpointResourceStateRunning EndpointResourceState = "Running"
	// EndpointResourceStateStarting ...
	EndpointResourceStateStarting EndpointResourceState = "Starting"
	// EndpointResourceStateStopped ...
	EndpointResourceStateStopped EndpointResourceState = "Stopped"
	// EndpointResourceStateStopping ...
	EndpointResourceStateStopping EndpointResourceState = "Stopping"
)

// PossibleEndpointResourceStateValues returns an array of possible values for the EndpointResourceState const type.
func PossibleEndpointResourceStateValues() []EndpointResourceState {
	return []EndpointResourceState{EndpointResourceStateCreating, EndpointResourceStateDeleting, EndpointResourceStateRunning, EndpointResourceStateStarting, EndpointResourceStateStopped, EndpointResourceStateStopping}
}

// GeoFilterActions enumerates the values for geo filter actions.
type GeoFilterActions string

const (
	// GeoFilterActionsAllow ...
	GeoFilterActionsAllow GeoFilterActions = "Allow"
	// GeoFilterActionsBlock ...
	GeoFilterActionsBlock GeoFilterActions = "Block"
)

// PossibleGeoFilterActionsValues returns an array of possible values for the GeoFilterActions const type.
func PossibleGeoFilterActionsValues() []GeoFilterActions {
	return []GeoFilterActions{GeoFilterActionsAllow, GeoFilterActionsBlock}
}

// HeaderAction enumerates the values for header action.
type HeaderAction string

const (
	// Append ...
	Append HeaderAction = "Append"
	// Delete ...
	Delete HeaderAction = "Delete"
	// Overwrite ...
	Overwrite HeaderAction = "Overwrite"
)

// PossibleHeaderActionValues returns an array of possible values for the HeaderAction const type.
func PossibleHeaderActionValues() []HeaderAction {
	return []HeaderAction{Append, Delete, Overwrite}
}

// HealthProbeRequestType enumerates the values for health probe request type.
type HealthProbeRequestType string

const (
	// GET ...
	GET HealthProbeRequestType = "GET"
	// HEAD ...
	HEAD HealthProbeRequestType = "HEAD"
	// NotSet ...
	NotSet HealthProbeRequestType = "NotSet"
)

// PossibleHealthProbeRequestTypeValues returns an array of possible values for the HealthProbeRequestType const type.
func PossibleHealthProbeRequestTypeValues() []HealthProbeRequestType {
	return []HealthProbeRequestType{GET, HEAD, NotSet}
}

// ManagedRuleEnabledState enumerates the values for managed rule enabled state.
type ManagedRuleEnabledState string

const (
	// ManagedRuleEnabledStateDisabled ...
	ManagedRuleEnabledStateDisabled ManagedRuleEnabledState = "Disabled"
	// ManagedRuleEnabledStateEnabled ...
	ManagedRuleEnabledStateEnabled ManagedRuleEnabledState = "Enabled"
)

// PossibleManagedRuleEnabledStateValues returns an array of possible values for the ManagedRuleEnabledState const type.
func PossibleManagedRuleEnabledStateValues() []ManagedRuleEnabledState {
	return []ManagedRuleEnabledState{ManagedRuleEnabledStateDisabled, ManagedRuleEnabledStateEnabled}
}

// MatchVariable enumerates the values for match variable.
type MatchVariable string

const (
	// Cookies ...
	Cookies MatchVariable = "Cookies"
	// PostArgs ...
	PostArgs MatchVariable = "PostArgs"
	// QueryString ...
	QueryString MatchVariable = "QueryString"
	// RemoteAddr ...
	RemoteAddr MatchVariable = "RemoteAddr"
	// RequestBody ...
	RequestBody MatchVariable = "RequestBody"
	// RequestHeader ...
	RequestHeader MatchVariable = "RequestHeader"
	// RequestMethod ...
	RequestMethod MatchVariable = "RequestMethod"
	// RequestURI ...
	RequestURI MatchVariable = "RequestUri"
	// SocketAddr ...
	SocketAddr MatchVariable = "SocketAddr"
)

// PossibleMatchVariableValues returns an array of possible values for the MatchVariable const type.
func PossibleMatchVariableValues() []MatchVariable {
	return []MatchVariable{Cookies, PostArgs, QueryString, RemoteAddr, RequestBody, RequestHeader, RequestMethod, RequestURI, SocketAddr}
}

// MinimumTLSVersion enumerates the values for minimum tls version.
type MinimumTLSVersion string

const (
	// None ...
	None MinimumTLSVersion = "None"
	// TLS10 ...
	TLS10 MinimumTLSVersion = "TLS10"
	// TLS12 ...
	TLS12 MinimumTLSVersion = "TLS12"
)

// PossibleMinimumTLSVersionValues returns an array of possible values for the MinimumTLSVersion const type.
func PossibleMinimumTLSVersionValues() []MinimumTLSVersion {
	return []MinimumTLSVersion{None, TLS10, TLS12}
}

// Name enumerates the values for name.
type Name string

const (
	// NameCookies ...
	NameCookies Name = "Cookies"
	// NameDeliveryRuleCondition ...
	NameDeliveryRuleCondition Name = "DeliveryRuleCondition"
	// NameHTTPVersion ...
	NameHTTPVersion Name = "HttpVersion"
	// NameIsDevice ...
	NameIsDevice Name = "IsDevice"
	// NamePostArgs ...
	NamePostArgs Name = "PostArgs"
	// NameQueryString ...
	NameQueryString Name = "QueryString"
	// NameRemoteAddress ...
	NameRemoteAddress Name = "RemoteAddress"
	// NameRequestBody ...
	NameRequestBody Name = "RequestBody"
	// NameRequestHeader ...
	NameRequestHeader Name = "RequestHeader"
	// NameRequestMethod ...
	NameRequestMethod Name = "RequestMethod"
	// NameRequestScheme ...
	NameRequestScheme Name = "RequestScheme"
	// NameRequestURI ...
	NameRequestURI Name = "RequestUri"
	// NameURLFileExtension ...
	NameURLFileExtension Name = "UrlFileExtension"
	// NameURLFileName ...
	NameURLFileName Name = "UrlFileName"
	// NameURLPath ...
	NameURLPath Name = "UrlPath"
)

// PossibleNameValues returns an array of possible values for the Name const type.
func PossibleNameValues() []Name {
	return []Name{NameCookies, NameDeliveryRuleCondition, NameHTTPVersion, NameIsDevice, NamePostArgs, NameQueryString, NameRemoteAddress, NameRequestBody, NameRequestHeader, NameRequestMethod, NameRequestScheme, NameRequestURI, NameURLFileExtension, NameURLFileName, NameURLPath}
}

// NameBasicDeliveryRuleAction enumerates the values for name basic delivery rule action.
type NameBasicDeliveryRuleAction string

const (
	// NameCacheExpiration ...
	NameCacheExpiration NameBasicDeliveryRuleAction = "CacheExpiration"
	// NameCacheKeyQueryString ...
	NameCacheKeyQueryString NameBasicDeliveryRuleAction = "CacheKeyQueryString"
	// NameDeliveryRuleAction ...
	NameDeliveryRuleAction NameBasicDeliveryRuleAction = "DeliveryRuleAction"
	// NameModifyRequestHeader ...
	NameModifyRequestHeader NameBasicDeliveryRuleAction = "ModifyRequestHeader"
	// NameModifyResponseHeader ...
	NameModifyResponseHeader NameBasicDeliveryRuleAction = "ModifyResponseHeader"
	// NameURLRedirect ...
	NameURLRedirect NameBasicDeliveryRuleAction = "UrlRedirect"
	// NameURLRewrite ...
	NameURLRewrite NameBasicDeliveryRuleAction = "UrlRewrite"
)

// PossibleNameBasicDeliveryRuleActionValues returns an array of possible values for the NameBasicDeliveryRuleAction const type.
func PossibleNameBasicDeliveryRuleActionValues() []NameBasicDeliveryRuleAction {
	return []NameBasicDeliveryRuleAction{NameCacheExpiration, NameCacheKeyQueryString, NameDeliveryRuleAction, NameModifyRequestHeader, NameModifyResponseHeader, NameURLRedirect, NameURLRewrite}
}

// OdataType enumerates the values for odata type.
type OdataType string

const (
	// MicrosoftAzureCdnModelsDeliveryRuleURLSigningActionParameters ...
	MicrosoftAzureCdnModelsDeliveryRuleURLSigningActionParameters OdataType = "#Microsoft.Azure.Cdn.Models.DeliveryRuleUrlSigningActionParameters"
)

// PossibleOdataTypeValues returns an array of possible values for the OdataType const type.
func PossibleOdataTypeValues() []OdataType {
	return []OdataType{MicrosoftAzureCdnModelsDeliveryRuleURLSigningActionParameters}
}

// Operator enumerates the values for operator.
type Operator string

const (
	// OperatorAny ...
	OperatorAny Operator = "Any"
	// OperatorBeginsWith ...
	OperatorBeginsWith Operator = "BeginsWith"
	// OperatorContains ...
	OperatorContains Operator = "Contains"
	// OperatorEndsWith ...
	OperatorEndsWith Operator = "EndsWith"
	// OperatorEqual ...
	OperatorEqual Operator = "Equal"
	// OperatorGeoMatch ...
	OperatorGeoMatch Operator = "GeoMatch"
	// OperatorGreaterThan ...
	OperatorGreaterThan Operator = "GreaterThan"
	// OperatorGreaterThanOrEqual ...
	OperatorGreaterThanOrEqual Operator = "GreaterThanOrEqual"
	// OperatorIPMatch ...
	OperatorIPMatch Operator = "IPMatch"
	// OperatorLessThan ...
	OperatorLessThan Operator = "LessThan"
	// OperatorLessThanOrEqual ...
	OperatorLessThanOrEqual Operator = "LessThanOrEqual"
	// OperatorRegEx ...
	OperatorRegEx Operator = "RegEx"
)

// PossibleOperatorValues returns an array of possible values for the Operator const type.
func PossibleOperatorValues() []Operator {
	return []Operator{OperatorAny, OperatorBeginsWith, OperatorContains, OperatorEndsWith, OperatorEqual, OperatorGeoMatch, OperatorGreaterThan, OperatorGreaterThanOrEqual, OperatorIPMatch, OperatorLessThan, OperatorLessThanOrEqual, OperatorRegEx}
}

// OptimizationType enumerates the values for optimization type.
type OptimizationType string

const (
	// DynamicSiteAcceleration ...
	DynamicSiteAcceleration OptimizationType = "DynamicSiteAcceleration"
	// GeneralMediaStreaming ...
	GeneralMediaStreaming OptimizationType = "GeneralMediaStreaming"
	// GeneralWebDelivery ...
	GeneralWebDelivery OptimizationType = "GeneralWebDelivery"
	// LargeFileDownload ...
	LargeFileDownload OptimizationType = "LargeFileDownload"
	// VideoOnDemandMediaStreaming ...
	VideoOnDemandMediaStreaming OptimizationType = "VideoOnDemandMediaStreaming"
)

// PossibleOptimizationTypeValues returns an array of possible values for the OptimizationType const type.
func PossibleOptimizationTypeValues() []OptimizationType {
	return []OptimizationType{DynamicSiteAcceleration, GeneralMediaStreaming, GeneralWebDelivery, LargeFileDownload, VideoOnDemandMediaStreaming}
}

// OriginGroupResourceState enumerates the values for origin group resource state.
type OriginGroupResourceState string

const (
	// OriginGroupResourceStateActive ...
	OriginGroupResourceStateActive OriginGroupResourceState = "Active"
	// OriginGroupResourceStateCreating ...
	OriginGroupResourceStateCreating OriginGroupResourceState = "Creating"
	// OriginGroupResourceStateDeleting ...
	OriginGroupResourceStateDeleting OriginGroupResourceState = "Deleting"
)

// PossibleOriginGroupResourceStateValues returns an array of possible values for the OriginGroupResourceState const type.
func PossibleOriginGroupResourceStateValues() []OriginGroupResourceState {
	return []OriginGroupResourceState{OriginGroupResourceStateActive, OriginGroupResourceStateCreating, OriginGroupResourceStateDeleting}
}

// OriginResourceState enumerates the values for origin resource state.
type OriginResourceState string

const (
	// OriginResourceStateActive ...
	OriginResourceStateActive OriginResourceState = "Active"
	// OriginResourceStateCreating ...
	OriginResourceStateCreating OriginResourceState = "Creating"
	// OriginResourceStateDeleting ...
	OriginResourceStateDeleting OriginResourceState = "Deleting"
)

// PossibleOriginResourceStateValues returns an array of possible values for the OriginResourceState const type.
func PossibleOriginResourceStateValues() []OriginResourceState {
	return []OriginResourceState{OriginResourceStateActive, OriginResourceStateCreating, OriginResourceStateDeleting}
}

// ParamIndicator enumerates the values for param indicator.
type ParamIndicator string

const (
	// Expires ...
	Expires ParamIndicator = "Expires"
	// KeyID ...
	KeyID ParamIndicator = "KeyId"
	// Signature ...
	Signature ParamIndicator = "Signature"
)

// PossibleParamIndicatorValues returns an array of possible values for the ParamIndicator const type.
func PossibleParamIndicatorValues() []ParamIndicator {
	return []ParamIndicator{Expires, KeyID, Signature}
}

// PolicyEnabledState enumerates the values for policy enabled state.
type PolicyEnabledState string

const (
	// PolicyEnabledStateDisabled ...
	PolicyEnabledStateDisabled PolicyEnabledState = "Disabled"
	// PolicyEnabledStateEnabled ...
	PolicyEnabledStateEnabled PolicyEnabledState = "Enabled"
)

// PossiblePolicyEnabledStateValues returns an array of possible values for the PolicyEnabledState const type.
func PossiblePolicyEnabledStateValues() []PolicyEnabledState {
	return []PolicyEnabledState{PolicyEnabledStateDisabled, PolicyEnabledStateEnabled}
}

// PolicyMode enumerates the values for policy mode.
type PolicyMode string

const (
	// Detection ...
	Detection PolicyMode = "Detection"
	// Prevention ...
	Prevention PolicyMode = "Prevention"
)

// PossiblePolicyModeValues returns an array of possible values for the PolicyMode const type.
func PossiblePolicyModeValues() []PolicyMode {
	return []PolicyMode{Detection, Prevention}
}

// PolicyResourceState enumerates the values for policy resource state.
type PolicyResourceState string

const (
	// PolicyResourceStateCreating ...
	PolicyResourceStateCreating PolicyResourceState = "Creating"
	// PolicyResourceStateDeleting ...
	PolicyResourceStateDeleting PolicyResourceState = "Deleting"
	// PolicyResourceStateDisabled ...
	PolicyResourceStateDisabled PolicyResourceState = "Disabled"
	// PolicyResourceStateDisabling ...
	PolicyResourceStateDisabling PolicyResourceState = "Disabling"
	// PolicyResourceStateEnabled ...
	PolicyResourceStateEnabled PolicyResourceState = "Enabled"
	// PolicyResourceStateEnabling ...
	PolicyResourceStateEnabling PolicyResourceState = "Enabling"
)

// PossiblePolicyResourceStateValues returns an array of possible values for the PolicyResourceState const type.
func PossiblePolicyResourceStateValues() []PolicyResourceState {
	return []PolicyResourceState{PolicyResourceStateCreating, PolicyResourceStateDeleting, PolicyResourceStateDisabled, PolicyResourceStateDisabling, PolicyResourceStateEnabled, PolicyResourceStateEnabling}
}

// PostArgsOperator enumerates the values for post args operator.
type PostArgsOperator string

const (
	// PostArgsOperatorAny ...
	PostArgsOperatorAny PostArgsOperator = "Any"
	// PostArgsOperatorBeginsWith ...
	PostArgsOperatorBeginsWith PostArgsOperator = "BeginsWith"
	// PostArgsOperatorContains ...
	PostArgsOperatorContains PostArgsOperator = "Contains"
	// PostArgsOperatorEndsWith ...
	PostArgsOperatorEndsWith PostArgsOperator = "EndsWith"
	// PostArgsOperatorEqual ...
	PostArgsOperatorEqual PostArgsOperator = "Equal"
	// PostArgsOperatorGreaterThan ...
	PostArgsOperatorGreaterThan PostArgsOperator = "GreaterThan"
	// PostArgsOperatorGreaterThanOrEqual ...
	PostArgsOperatorGreaterThanOrEqual PostArgsOperator = "GreaterThanOrEqual"
	// PostArgsOperatorLessThan ...
	PostArgsOperatorLessThan PostArgsOperator = "LessThan"
	// PostArgsOperatorLessThanOrEqual ...
	PostArgsOperatorLessThanOrEqual PostArgsOperator = "LessThanOrEqual"
)

// PossiblePostArgsOperatorValues returns an array of possible values for the PostArgsOperator const type.
func PossiblePostArgsOperatorValues() []PostArgsOperator {
	return []PostArgsOperator{PostArgsOperatorAny, PostArgsOperatorBeginsWith, PostArgsOperatorContains, PostArgsOperatorEndsWith, PostArgsOperatorEqual, PostArgsOperatorGreaterThan, PostArgsOperatorGreaterThanOrEqual, PostArgsOperatorLessThan, PostArgsOperatorLessThanOrEqual}
}

// PrivateEndpointStatus enumerates the values for private endpoint status.
type PrivateEndpointStatus string

const (
	// Approved ...
	Approved PrivateEndpointStatus = "Approved"
	// Disconnected ...
	Disconnected PrivateEndpointStatus = "Disconnected"
	// Pending ...
	Pending PrivateEndpointStatus = "Pending"
	// Rejected ...
	Rejected PrivateEndpointStatus = "Rejected"
	// Timeout ...
	Timeout PrivateEndpointStatus = "Timeout"
)

// PossiblePrivateEndpointStatusValues returns an array of possible values for the PrivateEndpointStatus const type.
func PossiblePrivateEndpointStatusValues() []PrivateEndpointStatus {
	return []PrivateEndpointStatus{Approved, Disconnected, Pending, Rejected, Timeout}
}

// ProbeProtocol enumerates the values for probe protocol.
type ProbeProtocol string

const (
	// ProbeProtocolHTTP ...
	ProbeProtocolHTTP ProbeProtocol = "Http"
	// ProbeProtocolHTTPS ...
	ProbeProtocolHTTPS ProbeProtocol = "Https"
	// ProbeProtocolNotSet ...
	ProbeProtocolNotSet ProbeProtocol = "NotSet"
)

// PossibleProbeProtocolValues returns an array of possible values for the ProbeProtocol const type.
func PossibleProbeProtocolValues() []ProbeProtocol {
	return []ProbeProtocol{ProbeProtocolHTTP, ProbeProtocolHTTPS, ProbeProtocolNotSet}
}

// ProfileResourceState enumerates the values for profile resource state.
type ProfileResourceState string

const (
	// ProfileResourceStateActive ...
	ProfileResourceStateActive ProfileResourceState = "Active"
	// ProfileResourceStateCreating ...
	ProfileResourceStateCreating ProfileResourceState = "Creating"
	// ProfileResourceStateDeleting ...
	ProfileResourceStateDeleting ProfileResourceState = "Deleting"
	// ProfileResourceStateDisabled ...
	ProfileResourceStateDisabled ProfileResourceState = "Disabled"
)

// PossibleProfileResourceStateValues returns an array of possible values for the ProfileResourceState const type.
func PossibleProfileResourceStateValues() []ProfileResourceState {
	return []ProfileResourceState{ProfileResourceStateActive, ProfileResourceStateCreating, ProfileResourceStateDeleting, ProfileResourceStateDisabled}
}

// ProtocolType enumerates the values for protocol type.
type ProtocolType string

const (
	// IPBased ...
	IPBased ProtocolType = "IPBased"
	// ServerNameIndication ...
	ServerNameIndication ProtocolType = "ServerNameIndication"
)

// PossibleProtocolTypeValues returns an array of possible values for the ProtocolType const type.
func PossibleProtocolTypeValues() []ProtocolType {
	return []ProtocolType{IPBased, ServerNameIndication}
}

// ProvisioningState enumerates the values for provisioning state.
type ProvisioningState string

const (
	// ProvisioningStateCreating ...
	ProvisioningStateCreating ProvisioningState = "Creating"
	// ProvisioningStateFailed ...
	ProvisioningStateFailed ProvisioningState = "Failed"
	// ProvisioningStateSucceeded ...
	ProvisioningStateSucceeded ProvisioningState = "Succeeded"
)

// PossibleProvisioningStateValues returns an array of possible values for the ProvisioningState const type.
func PossibleProvisioningStateValues() []ProvisioningState {
	return []ProvisioningState{ProvisioningStateCreating, ProvisioningStateFailed, ProvisioningStateSucceeded}
}

// QueryStringBehavior enumerates the values for query string behavior.
type QueryStringBehavior string

const (
	// Exclude ...
	Exclude QueryStringBehavior = "Exclude"
	// ExcludeAll ...
	ExcludeAll QueryStringBehavior = "ExcludeAll"
	// Include ...
	Include QueryStringBehavior = "Include"
	// IncludeAll ...
	IncludeAll QueryStringBehavior = "IncludeAll"
)

// PossibleQueryStringBehaviorValues returns an array of possible values for the QueryStringBehavior const type.
func PossibleQueryStringBehaviorValues() []QueryStringBehavior {
	return []QueryStringBehavior{Exclude, ExcludeAll, Include, IncludeAll}
}

// QueryStringCachingBehavior enumerates the values for query string caching behavior.
type QueryStringCachingBehavior string

const (
	// QueryStringCachingBehaviorBypassCaching ...
	QueryStringCachingBehaviorBypassCaching QueryStringCachingBehavior = "BypassCaching"
	// QueryStringCachingBehaviorIgnoreQueryString ...
	QueryStringCachingBehaviorIgnoreQueryString QueryStringCachingBehavior = "IgnoreQueryString"
	// QueryStringCachingBehaviorNotSet ...
	QueryStringCachingBehaviorNotSet QueryStringCachingBehavior = "NotSet"
	// QueryStringCachingBehaviorUseQueryString ...
	QueryStringCachingBehaviorUseQueryString QueryStringCachingBehavior = "UseQueryString"
)

// PossibleQueryStringCachingBehaviorValues returns an array of possible values for the QueryStringCachingBehavior const type.
func PossibleQueryStringCachingBehaviorValues() []QueryStringCachingBehavior {
	return []QueryStringCachingBehavior{QueryStringCachingBehaviorBypassCaching, QueryStringCachingBehaviorIgnoreQueryString, QueryStringCachingBehaviorNotSet, QueryStringCachingBehaviorUseQueryString}
}

// QueryStringOperator enumerates the values for query string operator.
type QueryStringOperator string

const (
	// QueryStringOperatorAny ...
	QueryStringOperatorAny QueryStringOperator = "Any"
	// QueryStringOperatorBeginsWith ...
	QueryStringOperatorBeginsWith QueryStringOperator = "BeginsWith"
	// QueryStringOperatorContains ...
	QueryStringOperatorContains QueryStringOperator = "Contains"
	// QueryStringOperatorEndsWith ...
	QueryStringOperatorEndsWith QueryStringOperator = "EndsWith"
	// QueryStringOperatorEqual ...
	QueryStringOperatorEqual QueryStringOperator = "Equal"
	// QueryStringOperatorGreaterThan ...
	QueryStringOperatorGreaterThan QueryStringOperator = "GreaterThan"
	// QueryStringOperatorGreaterThanOrEqual ...
	QueryStringOperatorGreaterThanOrEqual QueryStringOperator = "GreaterThanOrEqual"
	// QueryStringOperatorLessThan ...
	QueryStringOperatorLessThan QueryStringOperator = "LessThan"
	// QueryStringOperatorLessThanOrEqual ...
	QueryStringOperatorLessThanOrEqual QueryStringOperator = "LessThanOrEqual"
)

// PossibleQueryStringOperatorValues returns an array of possible values for the QueryStringOperator const type.
func PossibleQueryStringOperatorValues() []QueryStringOperator {
	return []QueryStringOperator{QueryStringOperatorAny, QueryStringOperatorBeginsWith, QueryStringOperatorContains, QueryStringOperatorEndsWith, QueryStringOperatorEqual, QueryStringOperatorGreaterThan, QueryStringOperatorGreaterThanOrEqual, QueryStringOperatorLessThan, QueryStringOperatorLessThanOrEqual}
}

// RedirectType enumerates the values for redirect type.
type RedirectType string

const (
	// Found ...
	Found RedirectType = "Found"
	// Moved ...
	Moved RedirectType = "Moved"
	// PermanentRedirect ...
	PermanentRedirect RedirectType = "PermanentRedirect"
	// TemporaryRedirect ...
	TemporaryRedirect RedirectType = "TemporaryRedirect"
)

// PossibleRedirectTypeValues returns an array of possible values for the RedirectType const type.
func PossibleRedirectTypeValues() []RedirectType {
	return []RedirectType{Found, Moved, PermanentRedirect, TemporaryRedirect}
}

// RemoteAddressOperator enumerates the values for remote address operator.
type RemoteAddressOperator string

const (
	// RemoteAddressOperatorAny ...
	RemoteAddressOperatorAny RemoteAddressOperator = "Any"
	// RemoteAddressOperatorGeoMatch ...
	RemoteAddressOperatorGeoMatch RemoteAddressOperator = "GeoMatch"
	// RemoteAddressOperatorIPMatch ...
	RemoteAddressOperatorIPMatch RemoteAddressOperator = "IPMatch"
)

// PossibleRemoteAddressOperatorValues returns an array of possible values for the RemoteAddressOperator const type.
func PossibleRemoteAddressOperatorValues() []RemoteAddressOperator {
	return []RemoteAddressOperator{RemoteAddressOperatorAny, RemoteAddressOperatorGeoMatch, RemoteAddressOperatorIPMatch}
}

// RequestBodyOperator enumerates the values for request body operator.
type RequestBodyOperator string

const (
	// RequestBodyOperatorAny ...
	RequestBodyOperatorAny RequestBodyOperator = "Any"
	// RequestBodyOperatorBeginsWith ...
	RequestBodyOperatorBeginsWith RequestBodyOperator = "BeginsWith"
	// RequestBodyOperatorContains ...
	RequestBodyOperatorContains RequestBodyOperator = "Contains"
	// RequestBodyOperatorEndsWith ...
	RequestBodyOperatorEndsWith RequestBodyOperator = "EndsWith"
	// RequestBodyOperatorEqual ...
	RequestBodyOperatorEqual RequestBodyOperator = "Equal"
	// RequestBodyOperatorGreaterThan ...
	RequestBodyOperatorGreaterThan RequestBodyOperator = "GreaterThan"
	// RequestBodyOperatorGreaterThanOrEqual ...
	RequestBodyOperatorGreaterThanOrEqual RequestBodyOperator = "GreaterThanOrEqual"
	// RequestBodyOperatorLessThan ...
	RequestBodyOperatorLessThan RequestBodyOperator = "LessThan"
	// RequestBodyOperatorLessThanOrEqual ...
	RequestBodyOperatorLessThanOrEqual RequestBodyOperator = "LessThanOrEqual"
)

// PossibleRequestBodyOperatorValues returns an array of possible values for the RequestBodyOperator const type.
func PossibleRequestBodyOperatorValues() []RequestBodyOperator {
	return []RequestBodyOperator{RequestBodyOperatorAny, RequestBodyOperatorBeginsWith, RequestBodyOperatorContains, RequestBodyOperatorEndsWith, RequestBodyOperatorEqual, RequestBodyOperatorGreaterThan, RequestBodyOperatorGreaterThanOrEqual, RequestBodyOperatorLessThan, RequestBodyOperatorLessThanOrEqual}
}

// RequestHeaderOperator enumerates the values for request header operator.
type RequestHeaderOperator string

const (
	// RequestHeaderOperatorAny ...
	RequestHeaderOperatorAny RequestHeaderOperator = "Any"
	// RequestHeaderOperatorBeginsWith ...
	RequestHeaderOperatorBeginsWith RequestHeaderOperator = "BeginsWith"
	// RequestHeaderOperatorContains ...
	RequestHeaderOperatorContains RequestHeaderOperator = "Contains"
	// RequestHeaderOperatorEndsWith ...
	RequestHeaderOperatorEndsWith RequestHeaderOperator = "EndsWith"
	// RequestHeaderOperatorEqual ...
	RequestHeaderOperatorEqual RequestHeaderOperator = "Equal"
	// RequestHeaderOperatorGreaterThan ...
	RequestHeaderOperatorGreaterThan RequestHeaderOperator = "GreaterThan"
	// RequestHeaderOperatorGreaterThanOrEqual ...
	RequestHeaderOperatorGreaterThanOrEqual RequestHeaderOperator = "GreaterThanOrEqual"
	// RequestHeaderOperatorLessThan ...
	RequestHeaderOperatorLessThan RequestHeaderOperator = "LessThan"
	// RequestHeaderOperatorLessThanOrEqual ...
	RequestHeaderOperatorLessThanOrEqual RequestHeaderOperator = "LessThanOrEqual"
)

// PossibleRequestHeaderOperatorValues returns an array of possible values for the RequestHeaderOperator const type.
func PossibleRequestHeaderOperatorValues() []RequestHeaderOperator {
	return []RequestHeaderOperator{RequestHeaderOperatorAny, RequestHeaderOperatorBeginsWith, RequestHeaderOperatorContains, RequestHeaderOperatorEndsWith, RequestHeaderOperatorEqual, RequestHeaderOperatorGreaterThan, RequestHeaderOperatorGreaterThanOrEqual, RequestHeaderOperatorLessThan, RequestHeaderOperatorLessThanOrEqual}
}

// RequestURIOperator enumerates the values for request uri operator.
type RequestURIOperator string

const (
	// RequestURIOperatorAny ...
	RequestURIOperatorAny RequestURIOperator = "Any"
	// RequestURIOperatorBeginsWith ...
	RequestURIOperatorBeginsWith RequestURIOperator = "BeginsWith"
	// RequestURIOperatorContains ...
	RequestURIOperatorContains RequestURIOperator = "Contains"
	// RequestURIOperatorEndsWith ...
	RequestURIOperatorEndsWith RequestURIOperator = "EndsWith"
	// RequestURIOperatorEqual ...
	RequestURIOperatorEqual RequestURIOperator = "Equal"
	// RequestURIOperatorGreaterThan ...
	RequestURIOperatorGreaterThan RequestURIOperator = "GreaterThan"
	// RequestURIOperatorGreaterThanOrEqual ...
	RequestURIOperatorGreaterThanOrEqual RequestURIOperator = "GreaterThanOrEqual"
	// RequestURIOperatorLessThan ...
	RequestURIOperatorLessThan RequestURIOperator = "LessThan"
	// RequestURIOperatorLessThanOrEqual ...
	RequestURIOperatorLessThanOrEqual RequestURIOperator = "LessThanOrEqual"
)

// PossibleRequestURIOperatorValues returns an array of possible values for the RequestURIOperator const type.
func PossibleRequestURIOperatorValues() []RequestURIOperator {
	return []RequestURIOperator{RequestURIOperatorAny, RequestURIOperatorBeginsWith, RequestURIOperatorContains, RequestURIOperatorEndsWith, RequestURIOperatorEqual, RequestURIOperatorGreaterThan, RequestURIOperatorGreaterThanOrEqual, RequestURIOperatorLessThan, RequestURIOperatorLessThanOrEqual}
}

// ResourceType enumerates the values for resource type.
type ResourceType string

const (
	// MicrosoftCdnProfilesEndpoints ...
	MicrosoftCdnProfilesEndpoints ResourceType = "Microsoft.Cdn/Profiles/Endpoints"
)

// PossibleResourceTypeValues returns an array of possible values for the ResourceType const type.
func PossibleResourceTypeValues() []ResourceType {
	return []ResourceType{MicrosoftCdnProfilesEndpoints}
}

// ResponseBasedDetectedErrorTypes enumerates the values for response based detected error types.
type ResponseBasedDetectedErrorTypes string

const (
	// ResponseBasedDetectedErrorTypesNone ...
	ResponseBasedDetectedErrorTypesNone ResponseBasedDetectedErrorTypes = "None"
	// ResponseBasedDetectedErrorTypesTCPAndHTTPErrors ...
	ResponseBasedDetectedErrorTypesTCPAndHTTPErrors ResponseBasedDetectedErrorTypes = "TcpAndHttpErrors"
	// ResponseBasedDetectedErrorTypesTCPErrorsOnly ...
	ResponseBasedDetectedErrorTypesTCPErrorsOnly ResponseBasedDetectedErrorTypes = "TcpErrorsOnly"
)

// PossibleResponseBasedDetectedErrorTypesValues returns an array of possible values for the ResponseBasedDetectedErrorTypes const type.
func PossibleResponseBasedDetectedErrorTypesValues() []ResponseBasedDetectedErrorTypes {
	return []ResponseBasedDetectedErrorTypes{ResponseBasedDetectedErrorTypesNone, ResponseBasedDetectedErrorTypesTCPAndHTTPErrors, ResponseBasedDetectedErrorTypesTCPErrorsOnly}
}

// SkuName enumerates the values for sku name.
type SkuName string

const (
	// CustomVerizon ...
	CustomVerizon SkuName = "Custom_Verizon"
	// PremiumChinaCdn ...
	PremiumChinaCdn SkuName = "Premium_ChinaCdn"
	// PremiumVerizon ...
	PremiumVerizon SkuName = "Premium_Verizon"
	// StandardAkamai ...
	StandardAkamai SkuName = "Standard_Akamai"
	// StandardChinaCdn ...
	StandardChinaCdn SkuName = "Standard_ChinaCdn"
	// StandardMicrosoft ...
	StandardMicrosoft SkuName = "Standard_Microsoft"
	// StandardVerizon ...
	StandardVerizon SkuName = "Standard_Verizon"
)

// PossibleSkuNameValues returns an array of possible values for the SkuName const type.
func PossibleSkuNameValues() []SkuName {
	return []SkuName{CustomVerizon, PremiumChinaCdn, PremiumVerizon, StandardAkamai, StandardChinaCdn, StandardMicrosoft, StandardVerizon}
}

// Transform enumerates the values for transform.
type Transform string

const (
	// Lowercase ...
	Lowercase Transform = "Lowercase"
	// Uppercase ...
	Uppercase Transform = "Uppercase"
)

// PossibleTransformValues returns an array of possible values for the Transform const type.
func PossibleTransformValues() []Transform {
	return []Transform{Lowercase, Uppercase}
}

// TransformType enumerates the values for transform type.
type TransformType string

const (
	// TransformTypeLowercase ...
	TransformTypeLowercase TransformType = "Lowercase"
	// TransformTypeRemoveNulls ...
	TransformTypeRemoveNulls TransformType = "RemoveNulls"
	// TransformTypeTrim ...
	TransformTypeTrim TransformType = "Trim"
	// TransformTypeUppercase ...
	TransformTypeUppercase TransformType = "Uppercase"
	// TransformTypeURLDecode ...
	TransformTypeURLDecode TransformType = "UrlDecode"
	// TransformTypeURLEncode ...
	TransformTypeURLEncode TransformType = "UrlEncode"
)

// PossibleTransformTypeValues returns an array of possible values for the TransformType const type.
func PossibleTransformTypeValues() []TransformType {
	return []TransformType{TransformTypeLowercase, TransformTypeRemoveNulls, TransformTypeTrim, TransformTypeUppercase, TransformTypeURLDecode, TransformTypeURLEncode}
}

// URLFileExtensionOperator enumerates the values for url file extension operator.
type URLFileExtensionOperator string

const (
	// URLFileExtensionOperatorAny ...
	URLFileExtensionOperatorAny URLFileExtensionOperator = "Any"
	// URLFileExtensionOperatorBeginsWith ...
	URLFileExtensionOperatorBeginsWith URLFileExtensionOperator = "BeginsWith"
	// URLFileExtensionOperatorContains ...
	URLFileExtensionOperatorContains URLFileExtensionOperator = "Contains"
	// URLFileExtensionOperatorEndsWith ...
	URLFileExtensionOperatorEndsWith URLFileExtensionOperator = "EndsWith"
	// URLFileExtensionOperatorEqual ...
	URLFileExtensionOperatorEqual URLFileExtensionOperator = "Equal"
	// URLFileExtensionOperatorGreaterThan ...
	URLFileExtensionOperatorGreaterThan URLFileExtensionOperator = "GreaterThan"
	// URLFileExtensionOperatorGreaterThanOrEqual ...
	URLFileExtensionOperatorGreaterThanOrEqual URLFileExtensionOperator = "GreaterThanOrEqual"
	// URLFileExtensionOperatorLessThan ...
	URLFileExtensionOperatorLessThan URLFileExtensionOperator = "LessThan"
	// URLFileExtensionOperatorLessThanOrEqual ...
	URLFileExtensionOperatorLessThanOrEqual URLFileExtensionOperator = "LessThanOrEqual"
)

// PossibleURLFileExtensionOperatorValues returns an array of possible values for the URLFileExtensionOperator const type.
func PossibleURLFileExtensionOperatorValues() []URLFileExtensionOperator {
	return []URLFileExtensionOperator{URLFileExtensionOperatorAny, URLFileExtensionOperatorBeginsWith, URLFileExtensionOperatorContains, URLFileExtensionOperatorEndsWith, URLFileExtensionOperatorEqual, URLFileExtensionOperatorGreaterThan, URLFileExtensionOperatorGreaterThanOrEqual, URLFileExtensionOperatorLessThan, URLFileExtensionOperatorLessThanOrEqual}
}

// URLFileNameOperator enumerates the values for url file name operator.
type URLFileNameOperator string

const (
	// URLFileNameOperatorAny ...
	URLFileNameOperatorAny URLFileNameOperator = "Any"
	// URLFileNameOperatorBeginsWith ...
	URLFileNameOperatorBeginsWith URLFileNameOperator = "BeginsWith"
	// URLFileNameOperatorContains ...
	URLFileNameOperatorContains URLFileNameOperator = "Contains"
	// URLFileNameOperatorEndsWith ...
	URLFileNameOperatorEndsWith URLFileNameOperator = "EndsWith"
	// URLFileNameOperatorEqual ...
	URLFileNameOperatorEqual URLFileNameOperator = "Equal"
	// URLFileNameOperatorGreaterThan ...
	URLFileNameOperatorGreaterThan URLFileNameOperator = "GreaterThan"
	// URLFileNameOperatorGreaterThanOrEqual ...
	URLFileNameOperatorGreaterThanOrEqual URLFileNameOperator = "GreaterThanOrEqual"
	// URLFileNameOperatorLessThan ...
	URLFileNameOperatorLessThan URLFileNameOperator = "LessThan"
	// URLFileNameOperatorLessThanOrEqual ...
	URLFileNameOperatorLessThanOrEqual URLFileNameOperator = "LessThanOrEqual"
)

// PossibleURLFileNameOperatorValues returns an array of possible values for the URLFileNameOperator const type.
func PossibleURLFileNameOperatorValues() []URLFileNameOperator {
	return []URLFileNameOperator{URLFileNameOperatorAny, URLFileNameOperatorBeginsWith, URLFileNameOperatorContains, URLFileNameOperatorEndsWith, URLFileNameOperatorEqual, URLFileNameOperatorGreaterThan, URLFileNameOperatorGreaterThanOrEqual, URLFileNameOperatorLessThan, URLFileNameOperatorLessThanOrEqual}
}

// URLPathOperator enumerates the values for url path operator.
type URLPathOperator string

const (
	// URLPathOperatorAny ...
	URLPathOperatorAny URLPathOperator = "Any"
	// URLPathOperatorBeginsWith ...
	URLPathOperatorBeginsWith URLPathOperator = "BeginsWith"
	// URLPathOperatorContains ...
	URLPathOperatorContains URLPathOperator = "Contains"
	// URLPathOperatorEndsWith ...
	URLPathOperatorEndsWith URLPathOperator = "EndsWith"
	// URLPathOperatorEqual ...
	URLPathOperatorEqual URLPathOperator = "Equal"
	// URLPathOperatorGreaterThan ...
	URLPathOperatorGreaterThan URLPathOperator = "GreaterThan"
	// URLPathOperatorGreaterThanOrEqual ...
	URLPathOperatorGreaterThanOrEqual URLPathOperator = "GreaterThanOrEqual"
	// URLPathOperatorLessThan ...
	URLPathOperatorLessThan URLPathOperator = "LessThan"
	// URLPathOperatorLessThanOrEqual ...
	URLPathOperatorLessThanOrEqual URLPathOperator = "LessThanOrEqual"
	// URLPathOperatorWildcard ...
	URLPathOperatorWildcard URLPathOperator = "Wildcard"
)

// PossibleURLPathOperatorValues returns an array of possible values for the URLPathOperator const type.
func PossibleURLPathOperatorValues() []URLPathOperator {
	return []URLPathOperator{URLPathOperatorAny, URLPathOperatorBeginsWith, URLPathOperatorContains, URLPathOperatorEndsWith, URLPathOperatorEqual, URLPathOperatorGreaterThan, URLPathOperatorGreaterThanOrEqual, URLPathOperatorLessThan, URLPathOperatorLessThanOrEqual, URLPathOperatorWildcard}
}
