package hybridnetwork

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/preview/management/2020-01-01-preview/hybridnetwork"

// Device hybrid network device resource.
type Device struct {
	autorest.Response `json:"-"`
	// BasicDevicePropertiesFormat - Hybrid network device properties.
	BasicDevicePropertiesFormat `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Device.
func (d Device) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["properties"] = d.BasicDevicePropertiesFormat
	if d.Location != nil {
		objectMap["location"] = d.Location
	}
	if d.Tags != nil {
		objectMap["tags"] = d.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Device struct.
func (d *Device) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				basicDevicePropertiesFormat, err := unmarshalBasicDevicePropertiesFormat(*v)
				if err != nil {
					return err
				}
				d.BasicDevicePropertiesFormat = basicDevicePropertiesFormat
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				d.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				d.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				d.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				d.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				d.Tags = tags
			}
		}
	}

	return nil
}

// DeviceListResult response for hybrid network devices API service call.
type DeviceListResult struct {
	autorest.Response `json:"-"`
	// Value - A list of hybrid network devices.
	Value *[]Device `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for DeviceListResult.
func (dlr DeviceListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dlr.Value != nil {
		objectMap["value"] = dlr.Value
	}
	return json.Marshal(objectMap)
}

// DeviceListResultIterator provides access to a complete listing of Device values.
type DeviceListResultIterator struct {
	i    int
	page DeviceListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *DeviceListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DeviceListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *DeviceListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter DeviceListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter DeviceListResultIterator) Response() DeviceListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter DeviceListResultIterator) Value() Device {
	if !iter.page.NotDone() {
		return Device{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the DeviceListResultIterator type.
func NewDeviceListResultIterator(page DeviceListResultPage) DeviceListResultIterator {
	return DeviceListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (dlr DeviceListResult) IsEmpty() bool {
	return dlr.Value == nil || len(*dlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (dlr DeviceListResult) hasNextLink() bool {
	return dlr.NextLink != nil && len(*dlr.NextLink) != 0
}

// deviceListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (dlr DeviceListResult) deviceListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !dlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(dlr.NextLink)))
}

// DeviceListResultPage contains a page of Device values.
type DeviceListResultPage struct {
	fn  func(context.Context, DeviceListResult) (DeviceListResult, error)
	dlr DeviceListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *DeviceListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DeviceListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.dlr)
		if err != nil {
			return err
		}
		page.dlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *DeviceListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page DeviceListResultPage) NotDone() bool {
	return !page.dlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page DeviceListResultPage) Response() DeviceListResult {
	return page.dlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page DeviceListResultPage) Values() []Device {
	if page.dlr.IsEmpty() {
		return nil
	}
	return *page.dlr.Value
}

// Creates a new instance of the DeviceListResultPage type.
func NewDeviceListResultPage(getNextPage func(context.Context, DeviceListResult) (DeviceListResult, error)) DeviceListResultPage {
	return DeviceListResultPage{fn: getNextPage}
}

// BasicDevicePropertiesFormat hybrid network device properties.
type BasicDevicePropertiesFormat interface {
	AsDevicePropertiesFormat() (*DevicePropertiesFormat, bool)
}

// DevicePropertiesFormat hybrid network device properties.
type DevicePropertiesFormat struct {
	// Status - READ-ONLY; The current device status. Possible values include: 'StatusUnknown', 'StatusNotRegistered', 'StatusRegistered'
	Status Status `json:"status,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state of the hybrid network device resource. Possible values include: 'ProvisioningStateUnknown', 'ProvisioningStateSucceeded', 'ProvisioningStateAccepted', 'ProvisioningStateDeleting', 'ProvisioningStateFailed', 'ProvisioningStateCanceled', 'ProvisioningStateDeleted'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// AzureStackEdge - The reference to the azure stack edge device.
	AzureStackEdge *SubResource `json:"azureStackEdge,omitempty"`
	// VirtualNetworkFunctions - READ-ONLY; The list of virtual network functions deployed on the hybrid network device.
	VirtualNetworkFunctions *[]SubResource `json:"virtualNetworkFunctions,omitempty"`
	// DeviceType - Possible values include: 'DeviceTypeDevicePropertiesFormat'
	DeviceType DeviceType `json:"deviceType,omitempty"`
}

func unmarshalBasicDevicePropertiesFormat(body []byte) (BasicDevicePropertiesFormat, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["deviceType"] {
	default:
		var dpf DevicePropertiesFormat
		err := json.Unmarshal(body, &dpf)
		return dpf, err
	}
}
func unmarshalBasicDevicePropertiesFormatArray(body []byte) ([]BasicDevicePropertiesFormat, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	dpfArray := make([]BasicDevicePropertiesFormat, len(rawMessages))

	for index, rawMessage := range rawMessages {
		dpf, err := unmarshalBasicDevicePropertiesFormat(*rawMessage)
		if err != nil {
			return nil, err
		}
		dpfArray[index] = dpf
	}
	return dpfArray, nil
}

// MarshalJSON is the custom marshaler for DevicePropertiesFormat.
func (dpf DevicePropertiesFormat) MarshalJSON() ([]byte, error) {
	dpf.DeviceType = DeviceTypeDevicePropertiesFormat
	objectMap := make(map[string]interface{})
	if dpf.AzureStackEdge != nil {
		objectMap["azureStackEdge"] = dpf.AzureStackEdge
	}
	if dpf.DeviceType != "" {
		objectMap["deviceType"] = dpf.DeviceType
	}
	return json.Marshal(objectMap)
}

// AsDevicePropertiesFormat is the BasicDevicePropertiesFormat implementation for DevicePropertiesFormat.
func (dpf DevicePropertiesFormat) AsDevicePropertiesFormat() (*DevicePropertiesFormat, bool) {
	return &dpf, true
}

// AsBasicDevicePropertiesFormat is the BasicDevicePropertiesFormat implementation for DevicePropertiesFormat.
func (dpf DevicePropertiesFormat) AsBasicDevicePropertiesFormat() (BasicDevicePropertiesFormat, bool) {
	return &dpf, true
}

// DeviceRegistrationKey the hybrid network device registration key
type DeviceRegistrationKey struct {
	autorest.Response `json:"-"`
	// RegistrationKey - READ-ONLY; The registration key for hybrid network device.
	RegistrationKey *string `json:"registrationKey,omitempty"`
}

// DevicesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type DevicesCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *DevicesCreateOrUpdateFuture) Result(client DevicesClient) (d Device, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hybridnetwork.DevicesCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("hybridnetwork.DevicesCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if d.Response.Response, err = future.GetResult(sender); err == nil && d.Response.Response.StatusCode != http.StatusNoContent {
		d, err = client.CreateOrUpdateResponder(d.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "hybridnetwork.DevicesCreateOrUpdateFuture", "Result", d.Response.Response, "Failure responding to request")
		}
	}
	return
}

// DevicesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type DevicesDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *DevicesDeleteFuture) Result(client DevicesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hybridnetwork.DevicesDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("hybridnetwork.DevicesDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ErrorDetails the error response that indicates why an operation has failed.
type ErrorDetails struct {
	Error *ErrorResponse `json:"error,omitempty"`
}

// ErrorResponse the error response details containing error code and error message
type ErrorResponse struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// Code - READ-ONLY; The error code.
	Code *string `json:"code,omitempty"`
	// Message - READ-ONLY; The error message.
	Message *string `json:"message,omitempty"`
}

// MarshalJSON is the custom marshaler for ErrorResponse.
func (er ErrorResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	for k, v := range er.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ErrorResponse struct.
func (er *ErrorResponse) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if er.AdditionalProperties == nil {
					er.AdditionalProperties = make(map[string]interface{})
				}
				er.AdditionalProperties[k] = additionalProperties
			}
		case "code":
			if v != nil {
				var code string
				err = json.Unmarshal(*v, &code)
				if err != nil {
					return err
				}
				er.Code = &code
			}
		case "message":
			if v != nil {
				var message string
				err = json.Unmarshal(*v, &message)
				if err != nil {
					return err
				}
				er.Message = &message
			}
		}
	}

	return nil
}

// ImageReference the image reference properties.
type ImageReference struct {
	// OsType - The OS type. Possible values include: 'OperatingSystemTypesUnknown', 'OperatingSystemTypesWindows', 'OperatingSystemTypesLinux'
	OsType OperatingSystemTypes `json:"osType,omitempty"`
	// VhdName - The VHD name.
	VhdName *string `json:"vhdName,omitempty"`
	// VhdType - The VHD type. Possible values include: 'VHDTypeUnknown', 'VHDTypeVHD', 'VHDTypeVHDX'
	VhdType VHDType `json:"vhdType,omitempty"`
	// SasURI - The VHD SAS URI.
	SasURI *string `json:"sasUri,omitempty"`
}

// NetworkInterface network interface properties.
type NetworkInterface struct {
	// NetworkInterfaceName - The name of the network interface.
	NetworkInterfaceName *string `json:"networkInterfaceName,omitempty"`
	// MacAddress - The MAC address of the network interface.
	MacAddress *string `json:"macAddress,omitempty"`
	// IPConfigurations - A list of IP configurations of the network interface.
	IPConfigurations *[]NetworkInterfaceIPConfiguration `json:"ipConfigurations,omitempty"`
	// VMSwitchType - The type of VM switch. Possible values include: 'VMSwitchTypeUnknown', 'VMSwitchTypeManagement', 'VMSwitchTypeWan', 'VMSwitchTypeLan', 'VMSwitchTypeInternal'
	VMSwitchType VMSwitchType `json:"vmSwitchType,omitempty"`
}

// NetworkInterfaceIPConfiguration network interface IP configuration properties.
type NetworkInterfaceIPConfiguration struct {
	// IPAllocationMethod - IP address allocation method. Possible values include: 'Unknown', 'Static', 'Dynamic'
	IPAllocationMethod IPAllocationMethod `json:"ipAllocationMethod,omitempty"`
	// IPAddress - The value of the IP address.
	IPAddress *string `json:"ipAddress,omitempty"`
	// Subnet - The value of the subnet.
	Subnet *string `json:"subnet,omitempty"`
	// Gateway - The value of the gateway.
	Gateway *string `json:"gateway,omitempty"`
	// IPVersion - IP address version. Possible values include: 'IPVersionUnknown', 'IPVersionIPv4'
	IPVersion IPVersion `json:"ipVersion,omitempty"`
	// DNSServers - The list of DNS servers IP addresses.
	DNSServers *[]string `json:"dnsServers,omitempty"`
}

// Operation object that describes a single Microsoft.HybridNetwork operation.
type Operation struct {
	// Name - READ-ONLY; Operation name: {provider}/{resource}/{operation}
	Name *string `json:"name,omitempty"`
	// Display - READ-ONLY; The object that represents the operation.
	Display *OperationDisplay `json:"display,omitempty"`
}

// OperationDisplay the object that represents the operation.
type OperationDisplay struct {
	// Provider - Service provider: Microsoft.HybridNetwork
	Provider *string `json:"provider,omitempty"`
	// Resource - Resource on which the operation is performed: Registration definition, registration assignment etc.
	Resource *string `json:"resource,omitempty"`
	// Operation - Operation type: Read, write, delete, etc.
	Operation *string `json:"operation,omitempty"`
	// Description - Description of the operation.
	Description *string `json:"description,omitempty"`
}

// OperationList list of the operations.
type OperationList struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of Microsoft.HybridNetwork operations.
	Value *[]Operation `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// OperationListIterator provides access to a complete listing of Operation values.
type OperationListIterator struct {
	i    int
	page OperationListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OperationListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *OperationListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OperationListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OperationListIterator) Response() OperationList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OperationListIterator) Value() Operation {
	if !iter.page.NotDone() {
		return Operation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the OperationListIterator type.
func NewOperationListIterator(page OperationListPage) OperationListIterator {
	return OperationListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ol OperationList) IsEmpty() bool {
	return ol.Value == nil || len(*ol.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (ol OperationList) hasNextLink() bool {
	return ol.NextLink != nil && len(*ol.NextLink) != 0
}

// operationListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ol OperationList) operationListPreparer(ctx context.Context) (*http.Request, error) {
	if !ol.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ol.NextLink)))
}

// OperationListPage contains a page of Operation values.
type OperationListPage struct {
	fn func(context.Context, OperationList) (OperationList, error)
	ol OperationList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OperationListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.ol)
		if err != nil {
			return err
		}
		page.ol = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *OperationListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OperationListPage) NotDone() bool {
	return !page.ol.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OperationListPage) Response() OperationList {
	return page.ol
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OperationListPage) Values() []Operation {
	if page.ol.IsEmpty() {
		return nil
	}
	return *page.ol.Value
}

// Creates a new instance of the OperationListPage type.
func NewOperationListPage(getNextPage func(context.Context, OperationList) (OperationList, error)) OperationListPage {
	return OperationListPage{fn: getNextPage}
}

// OsProfile specifies the operating system settings for the role instance.
type OsProfile struct {
	// AdminUsername - Specifies the name of the administrator account. <br><br> **Windows-only restriction:** Cannot end in "." <br><br> **Disallowed values:** "administrator", "admin", "user", "user1", "test", "user2", "test1", "user3", "admin1", "1", "123", "a", "actuser", "adm", "admin2", "aspnet", "backup", "console", "david", "guest", "john", "owner", "root", "server", "sql", "support", "support_388945a0", "sys", "test2", "test3", "user4", "user5". <br><br> **Minimum-length (Linux):** 1  character <br><br> **Max-length (Linux):** 64 characters <br><br> **Max-length (Windows):** 20 characters  <br><br><li> For root access to the Linux VM, see [Using root privileges on Linux virtual machines in Azure](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-use-root-privileges?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json)<br><li> For a list of built-in system users on Linux that should not be used in this field, see [Selecting User Names for Linux on Azure](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-usernames?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json).
	AdminUsername *string `json:"adminUsername,omitempty"`
	// AdminPassword - Specifies the password of the administrator account. <br><br> **Minimum-length (Windows):** 8 characters <br><br> **Minimum-length (Linux):** 6 characters <br><br> **Max-length (Windows):** 123 characters <br><br> **Max-length (Linux):** 72 characters <br><br> **Complexity requirements:** 3 out of 4 conditions below need to be fulfilled <br> Has lower characters <br>Has upper characters <br> Has a digit <br> Has a special character (Regex match [\W_]) <br><br> For resetting the password, see [How to reset the Remote Desktop service or its login password in a Windows VM](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-reset-rdp?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json) <br><br> For resetting root password, see [Manage users, SSH, and check or repair disks on Azure Linux VMs using the VMAccess Extension](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-using-vmaccess-extension?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json#reset-root-password).
	AdminPassword *string `json:"adminPassword,omitempty"`
	// SSHPublicKey - Contains information about SSH certificate public key and the path on the Linux VM where the public key is placed.
	SSHPublicKey *string `json:"sshPublicKey,omitempty"`
}

// PreviewSubscription customer subscription which can use a sku.
type PreviewSubscription struct {
	autorest.Response `json:"-"`
	// Name - READ-ONLY; Preview subscription id
	Name *string `json:"name,omitempty"`
	// ID - READ-ONLY; ARM id of the resource
	ID *string `json:"id,omitempty"`
	// Type - READ-ONLY; Type of the resource
	Type *string `json:"type,omitempty"`
}

// PreviewSubscriptionsList list of customer subscriptions which can use a sku.
type PreviewSubscriptionsList struct {
	autorest.Response `json:"-"`
	// Value - A list of preview subscriptions.
	Value *[]PreviewSubscription `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for PreviewSubscriptionsList.
func (psl PreviewSubscriptionsList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if psl.Value != nil {
		objectMap["value"] = psl.Value
	}
	return json.Marshal(objectMap)
}

// PreviewSubscriptionsListIterator provides access to a complete listing of PreviewSubscription values.
type PreviewSubscriptionsListIterator struct {
	i    int
	page PreviewSubscriptionsListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *PreviewSubscriptionsListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PreviewSubscriptionsListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *PreviewSubscriptionsListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter PreviewSubscriptionsListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter PreviewSubscriptionsListIterator) Response() PreviewSubscriptionsList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter PreviewSubscriptionsListIterator) Value() PreviewSubscription {
	if !iter.page.NotDone() {
		return PreviewSubscription{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the PreviewSubscriptionsListIterator type.
func NewPreviewSubscriptionsListIterator(page PreviewSubscriptionsListPage) PreviewSubscriptionsListIterator {
	return PreviewSubscriptionsListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (psl PreviewSubscriptionsList) IsEmpty() bool {
	return psl.Value == nil || len(*psl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (psl PreviewSubscriptionsList) hasNextLink() bool {
	return psl.NextLink != nil && len(*psl.NextLink) != 0
}

// previewSubscriptionsListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (psl PreviewSubscriptionsList) previewSubscriptionsListPreparer(ctx context.Context) (*http.Request, error) {
	if !psl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(psl.NextLink)))
}

// PreviewSubscriptionsListPage contains a page of PreviewSubscription values.
type PreviewSubscriptionsListPage struct {
	fn  func(context.Context, PreviewSubscriptionsList) (PreviewSubscriptionsList, error)
	psl PreviewSubscriptionsList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *PreviewSubscriptionsListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PreviewSubscriptionsListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.psl)
		if err != nil {
			return err
		}
		page.psl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *PreviewSubscriptionsListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page PreviewSubscriptionsListPage) NotDone() bool {
	return !page.psl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page PreviewSubscriptionsListPage) Response() PreviewSubscriptionsList {
	return page.psl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page PreviewSubscriptionsListPage) Values() []PreviewSubscription {
	if page.psl.IsEmpty() {
		return nil
	}
	return *page.psl.Value
}

// Creates a new instance of the PreviewSubscriptionsListPage type.
func NewPreviewSubscriptionsListPage(getNextPage func(context.Context, PreviewSubscriptionsList) (PreviewSubscriptionsList, error)) PreviewSubscriptionsListPage {
	return PreviewSubscriptionsListPage{fn: getNextPage}
}

// Resource common resource representation.
type Resource struct {
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if r.Location != nil {
		objectMap["location"] = r.Location
	}
	if r.Tags != nil {
		objectMap["tags"] = r.Tags
	}
	return json.Marshal(objectMap)
}

// SkuOverview the virtual network function sku overview.
type SkuOverview struct {
	// SkuName - The vendor sku name.
	SkuName *string `json:"skuName,omitempty"`
	// SkuType - The vendor sku type. Possible values include: 'SkuTypeUnknown', 'SkuTypeEvolvedPacketCore', 'SkuTypeSDWAN'
	SkuType SkuType `json:"skuType,omitempty"`
}

// SubResource reference to another sub resource.
type SubResource struct {
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// TagsObject tags object for patch operations.
type TagsObject struct {
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for TagsObject.
func (toVar TagsObject) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if toVar.Tags != nil {
		objectMap["tags"] = toVar.Tags
	}
	return json.Marshal(objectMap)
}

// Vendor vendor resource.
type Vendor struct {
	autorest.Response `json:"-"`
	// VendorPropertiesFormat - Vendor properties.
	*VendorPropertiesFormat `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Vendor.
func (vVar Vendor) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vVar.VendorPropertiesFormat != nil {
		objectMap["properties"] = vVar.VendorPropertiesFormat
	}
	if vVar.Location != nil {
		objectMap["location"] = vVar.Location
	}
	if vVar.Tags != nil {
		objectMap["tags"] = vVar.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Vendor struct.
func (vVar *Vendor) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var vendorPropertiesFormat VendorPropertiesFormat
				err = json.Unmarshal(*v, &vendorPropertiesFormat)
				if err != nil {
					return err
				}
				vVar.VendorPropertiesFormat = &vendorPropertiesFormat
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				vVar.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				vVar.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				vVar.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				vVar.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				vVar.Tags = tags
			}
		}
	}

	return nil
}

// VendorDetails the virtual network function vendor details.
type VendorDetails struct {
	// VendorName - The virtual network function vendor name.
	VendorName *string `json:"vendorName,omitempty"`
	// SkuList - The virtual network function sku list.
	SkuList *[]SkuOverview `json:"skuList,omitempty"`
}

// VendorListResult response for Vendors API service call.
type VendorListResult struct {
	autorest.Response `json:"-"`
	// Value - A list of vendors.
	Value *[]Vendor `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for VendorListResult.
func (vlr VendorListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vlr.Value != nil {
		objectMap["value"] = vlr.Value
	}
	return json.Marshal(objectMap)
}

// VendorListResultIterator provides access to a complete listing of Vendor values.
type VendorListResultIterator struct {
	i    int
	page VendorListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *VendorListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VendorListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *VendorListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter VendorListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter VendorListResultIterator) Response() VendorListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter VendorListResultIterator) Value() Vendor {
	if !iter.page.NotDone() {
		return Vendor{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the VendorListResultIterator type.
func NewVendorListResultIterator(page VendorListResultPage) VendorListResultIterator {
	return VendorListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (vlr VendorListResult) IsEmpty() bool {
	return vlr.Value == nil || len(*vlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (vlr VendorListResult) hasNextLink() bool {
	return vlr.NextLink != nil && len(*vlr.NextLink) != 0
}

// vendorListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (vlr VendorListResult) vendorListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !vlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(vlr.NextLink)))
}

// VendorListResultPage contains a page of Vendor values.
type VendorListResultPage struct {
	fn  func(context.Context, VendorListResult) (VendorListResult, error)
	vlr VendorListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *VendorListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VendorListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.vlr)
		if err != nil {
			return err
		}
		page.vlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *VendorListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page VendorListResultPage) NotDone() bool {
	return !page.vlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page VendorListResultPage) Response() VendorListResult {
	return page.vlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page VendorListResultPage) Values() []Vendor {
	if page.vlr.IsEmpty() {
		return nil
	}
	return *page.vlr.Value
}

// Creates a new instance of the VendorListResultPage type.
func NewVendorListResultPage(getNextPage func(context.Context, VendorListResult) (VendorListResult, error)) VendorListResultPage {
	return VendorListResultPage{fn: getNextPage}
}

// VendorPropertiesFormat vendor properties.
type VendorPropertiesFormat struct {
	// ProvisioningState - READ-ONLY; The provisioning state of the vendor resource. Possible values include: 'ProvisioningStateUnknown', 'ProvisioningStateSucceeded', 'ProvisioningStateAccepted', 'ProvisioningStateDeleting', 'ProvisioningStateFailed', 'ProvisioningStateCanceled', 'ProvisioningStateDeleted'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// Skus - READ-ONLY; A list of ids of the vendor skus offered by the vendor.
	Skus *[]SubResource `json:"skus,omitempty"`
}

// VendorsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type VendorsCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *VendorsCreateOrUpdateFuture) Result(client VendorsClient) (vVar Vendor, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hybridnetwork.VendorsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("hybridnetwork.VendorsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if vVar.Response.Response, err = future.GetResult(sender); err == nil && vVar.Response.Response.StatusCode != http.StatusNoContent {
		vVar, err = client.CreateOrUpdateResponder(vVar.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "hybridnetwork.VendorsCreateOrUpdateFuture", "Result", vVar.Response.Response, "Failure responding to request")
		}
	}
	return
}

// VendorsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type VendorsDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *VendorsDeleteFuture) Result(client VendorsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hybridnetwork.VendorsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("hybridnetwork.VendorsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// VendorSku sku sub resource.
type VendorSku struct {
	autorest.Response `json:"-"`
	// VendorSkuPropertiesFormat - Vendor sku details.
	*VendorSkuPropertiesFormat `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for VendorSku.
func (vs VendorSku) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vs.VendorSkuPropertiesFormat != nil {
		objectMap["properties"] = vs.VendorSkuPropertiesFormat
	}
	if vs.Location != nil {
		objectMap["location"] = vs.Location
	}
	if vs.Tags != nil {
		objectMap["tags"] = vs.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for VendorSku struct.
func (vs *VendorSku) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var vendorSkuPropertiesFormat VendorSkuPropertiesFormat
				err = json.Unmarshal(*v, &vendorSkuPropertiesFormat)
				if err != nil {
					return err
				}
				vs.VendorSkuPropertiesFormat = &vendorSkuPropertiesFormat
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				vs.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				vs.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				vs.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				vs.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				vs.Tags = tags
			}
		}
	}

	return nil
}

// VendorSkuListResult response for list vendor sku API service call.
type VendorSkuListResult struct {
	autorest.Response `json:"-"`
	// Value - A list of vendor skus offered by the vendor.
	Value *[]VendorSku `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URI to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for VendorSkuListResult.
func (vslr VendorSkuListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vslr.Value != nil {
		objectMap["value"] = vslr.Value
	}
	return json.Marshal(objectMap)
}

// VendorSkuListResultIterator provides access to a complete listing of VendorSku values.
type VendorSkuListResultIterator struct {
	i    int
	page VendorSkuListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *VendorSkuListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VendorSkuListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *VendorSkuListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter VendorSkuListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter VendorSkuListResultIterator) Response() VendorSkuListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter VendorSkuListResultIterator) Value() VendorSku {
	if !iter.page.NotDone() {
		return VendorSku{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the VendorSkuListResultIterator type.
func NewVendorSkuListResultIterator(page VendorSkuListResultPage) VendorSkuListResultIterator {
	return VendorSkuListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (vslr VendorSkuListResult) IsEmpty() bool {
	return vslr.Value == nil || len(*vslr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (vslr VendorSkuListResult) hasNextLink() bool {
	return vslr.NextLink != nil && len(*vslr.NextLink) != 0
}

// vendorSkuListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (vslr VendorSkuListResult) vendorSkuListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !vslr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(vslr.NextLink)))
}

// VendorSkuListResultPage contains a page of VendorSku values.
type VendorSkuListResultPage struct {
	fn   func(context.Context, VendorSkuListResult) (VendorSkuListResult, error)
	vslr VendorSkuListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *VendorSkuListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VendorSkuListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.vslr)
		if err != nil {
			return err
		}
		page.vslr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *VendorSkuListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page VendorSkuListResultPage) NotDone() bool {
	return !page.vslr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page VendorSkuListResultPage) Response() VendorSkuListResult {
	return page.vslr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page VendorSkuListResultPage) Values() []VendorSku {
	if page.vslr.IsEmpty() {
		return nil
	}
	return *page.vslr.Value
}

// Creates a new instance of the VendorSkuListResultPage type.
func NewVendorSkuListResultPage(getNextPage func(context.Context, VendorSkuListResult) (VendorSkuListResult, error)) VendorSkuListResultPage {
	return VendorSkuListResultPage{fn: getNextPage}
}

// VendorSkuPreviewCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type VendorSkuPreviewCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *VendorSkuPreviewCreateOrUpdateFuture) Result(client VendorSkuPreviewClient) (ps PreviewSubscription, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hybridnetwork.VendorSkuPreviewCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("hybridnetwork.VendorSkuPreviewCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if ps.Response.Response, err = future.GetResult(sender); err == nil && ps.Response.Response.StatusCode != http.StatusNoContent {
		ps, err = client.CreateOrUpdateResponder(ps.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "hybridnetwork.VendorSkuPreviewCreateOrUpdateFuture", "Result", ps.Response.Response, "Failure responding to request")
		}
	}
	return
}

// VendorSkuPreviewDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type VendorSkuPreviewDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *VendorSkuPreviewDeleteFuture) Result(client VendorSkuPreviewClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hybridnetwork.VendorSkuPreviewDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("hybridnetwork.VendorSkuPreviewDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// VendorSkuPropertiesFormat sku  properties
type VendorSkuPropertiesFormat struct {
	// ProvisioningState - READ-ONLY; The provisioning state of the vendor sku sub resource. Possible values include: 'ProvisioningStateUnknown', 'ProvisioningStateSucceeded', 'ProvisioningStateAccepted', 'ProvisioningStateDeleting', 'ProvisioningStateFailed', 'ProvisioningStateCanceled', 'ProvisioningStateDeleted'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// SkuType - Sku type. Possible values include: 'SkuTypeUnknown', 'SkuTypeEvolvedPacketCore', 'SkuTypeSDWAN'
	SkuType SkuType `json:"skuType,omitempty"`
	// DeploymentMode - Sku deployment mode. Possible values include: 'SkuDeploymentModeUnknown', 'SkuDeploymentModeAzure', 'SkuDeploymentModePrivateEdgeZone'
	DeploymentMode SkuDeploymentMode `json:"deploymentMode,omitempty"`
	// Preview - Indicates if the vendor sku is in preview mode.
	Preview *bool `json:"preview,omitempty"`
	// ManagedApplicationParameters - The parameters for the managed application to be supplied by vendor.
	ManagedApplicationParameters interface{} `json:"managedApplicationParameters,omitempty"`
	// ManagedApplicationTemplate - The template for the managed application deployment.
	ManagedApplicationTemplate interface{} `json:"managedApplicationTemplate,omitempty"`
	// VirtualNetworkFunctionTemplate - The template definition of the virtual network function.
	VirtualNetworkFunctionTemplate *VirtualNetworkFunctionTemplate `json:"virtualNetworkFunctionTemplate,omitempty"`
}

// MarshalJSON is the custom marshaler for VendorSkuPropertiesFormat.
func (vspf VendorSkuPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vspf.SkuType != "" {
		objectMap["skuType"] = vspf.SkuType
	}
	if vspf.DeploymentMode != "" {
		objectMap["deploymentMode"] = vspf.DeploymentMode
	}
	if vspf.Preview != nil {
		objectMap["preview"] = vspf.Preview
	}
	if vspf.ManagedApplicationParameters != nil {
		objectMap["managedApplicationParameters"] = vspf.ManagedApplicationParameters
	}
	if vspf.ManagedApplicationTemplate != nil {
		objectMap["managedApplicationTemplate"] = vspf.ManagedApplicationTemplate
	}
	if vspf.VirtualNetworkFunctionTemplate != nil {
		objectMap["virtualNetworkFunctionTemplate"] = vspf.VirtualNetworkFunctionTemplate
	}
	return json.Marshal(objectMap)
}

// VendorSkusCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type VendorSkusCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *VendorSkusCreateOrUpdateFuture) Result(client VendorSkusClient) (vs VendorSku, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hybridnetwork.VendorSkusCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("hybridnetwork.VendorSkusCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if vs.Response.Response, err = future.GetResult(sender); err == nil && vs.Response.Response.StatusCode != http.StatusNoContent {
		vs, err = client.CreateOrUpdateResponder(vs.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "hybridnetwork.VendorSkusCreateOrUpdateFuture", "Result", vs.Response.Response, "Failure responding to request")
		}
	}
	return
}

// VendorSkusDeleteFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type VendorSkusDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *VendorSkusDeleteFuture) Result(client VendorSkusClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hybridnetwork.VendorSkusDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("hybridnetwork.VendorSkusDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// VendorVirtualNetworkFunction vendor virtual network function sub resource.
type VendorVirtualNetworkFunction struct {
	autorest.Response `json:"-"`
	// VendorVirtualNetworkFunctionPropertiesFormat - Virtual network function details.
	*VendorVirtualNetworkFunctionPropertiesFormat `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for VendorVirtualNetworkFunction.
func (vvnf VendorVirtualNetworkFunction) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vvnf.VendorVirtualNetworkFunctionPropertiesFormat != nil {
		objectMap["properties"] = vvnf.VendorVirtualNetworkFunctionPropertiesFormat
	}
	if vvnf.Location != nil {
		objectMap["location"] = vvnf.Location
	}
	if vvnf.Tags != nil {
		objectMap["tags"] = vvnf.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for VendorVirtualNetworkFunction struct.
func (vvnf *VendorVirtualNetworkFunction) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var vendorVirtualNetworkFunctionPropertiesFormat VendorVirtualNetworkFunctionPropertiesFormat
				err = json.Unmarshal(*v, &vendorVirtualNetworkFunctionPropertiesFormat)
				if err != nil {
					return err
				}
				vvnf.VendorVirtualNetworkFunctionPropertiesFormat = &vendorVirtualNetworkFunctionPropertiesFormat
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				vvnf.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				vvnf.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				vvnf.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				vvnf.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				vvnf.Tags = tags
			}
		}
	}

	return nil
}

// VendorVirtualNetworkFunctionListResult response for vendors API service call.
type VendorVirtualNetworkFunctionListResult struct {
	autorest.Response `json:"-"`
	// Value - A list of vendor virtual network function.
	Value *[]VendorVirtualNetworkFunction `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for VendorVirtualNetworkFunctionListResult.
func (vvnflr VendorVirtualNetworkFunctionListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vvnflr.Value != nil {
		objectMap["value"] = vvnflr.Value
	}
	return json.Marshal(objectMap)
}

// VendorVirtualNetworkFunctionListResultIterator provides access to a complete listing of
// VendorVirtualNetworkFunction values.
type VendorVirtualNetworkFunctionListResultIterator struct {
	i    int
	page VendorVirtualNetworkFunctionListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *VendorVirtualNetworkFunctionListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VendorVirtualNetworkFunctionListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *VendorVirtualNetworkFunctionListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter VendorVirtualNetworkFunctionListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter VendorVirtualNetworkFunctionListResultIterator) Response() VendorVirtualNetworkFunctionListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter VendorVirtualNetworkFunctionListResultIterator) Value() VendorVirtualNetworkFunction {
	if !iter.page.NotDone() {
		return VendorVirtualNetworkFunction{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the VendorVirtualNetworkFunctionListResultIterator type.
func NewVendorVirtualNetworkFunctionListResultIterator(page VendorVirtualNetworkFunctionListResultPage) VendorVirtualNetworkFunctionListResultIterator {
	return VendorVirtualNetworkFunctionListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (vvnflr VendorVirtualNetworkFunctionListResult) IsEmpty() bool {
	return vvnflr.Value == nil || len(*vvnflr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (vvnflr VendorVirtualNetworkFunctionListResult) hasNextLink() bool {
	return vvnflr.NextLink != nil && len(*vvnflr.NextLink) != 0
}

// vendorVirtualNetworkFunctionListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (vvnflr VendorVirtualNetworkFunctionListResult) vendorVirtualNetworkFunctionListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !vvnflr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(vvnflr.NextLink)))
}

// VendorVirtualNetworkFunctionListResultPage contains a page of VendorVirtualNetworkFunction values.
type VendorVirtualNetworkFunctionListResultPage struct {
	fn     func(context.Context, VendorVirtualNetworkFunctionListResult) (VendorVirtualNetworkFunctionListResult, error)
	vvnflr VendorVirtualNetworkFunctionListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *VendorVirtualNetworkFunctionListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VendorVirtualNetworkFunctionListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.vvnflr)
		if err != nil {
			return err
		}
		page.vvnflr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *VendorVirtualNetworkFunctionListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page VendorVirtualNetworkFunctionListResultPage) NotDone() bool {
	return !page.vvnflr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page VendorVirtualNetworkFunctionListResultPage) Response() VendorVirtualNetworkFunctionListResult {
	return page.vvnflr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page VendorVirtualNetworkFunctionListResultPage) Values() []VendorVirtualNetworkFunction {
	if page.vvnflr.IsEmpty() {
		return nil
	}
	return *page.vvnflr.Value
}

// Creates a new instance of the VendorVirtualNetworkFunctionListResultPage type.
func NewVendorVirtualNetworkFunctionListResultPage(getNextPage func(context.Context, VendorVirtualNetworkFunctionListResult) (VendorVirtualNetworkFunctionListResult, error)) VendorVirtualNetworkFunctionListResultPage {
	return VendorVirtualNetworkFunctionListResultPage{fn: getNextPage}
}

// VendorVirtualNetworkFunctionPropertiesFormat vendor virtual network function properties
type VendorVirtualNetworkFunctionPropertiesFormat struct {
	// ProvisioningState - READ-ONLY; The provisioning state of the vendor virtual network function sub resource. Possible values include: 'ProvisioningStateUnknown', 'ProvisioningStateSucceeded', 'ProvisioningStateAccepted', 'ProvisioningStateDeleting', 'ProvisioningStateFailed', 'ProvisioningStateCanceled', 'ProvisioningStateDeleted'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// VendorProvisioningState - Vendor controlled provisioning state of the vendor virtual network function. Possible values include: 'VendorProvisioningStateUnknown', 'VendorProvisioningStateNotProvisioned', 'VendorProvisioningStateProvisioning', 'VendorProvisioningStateProvisioned', 'VendorProvisioningStateDeprovisioned', 'VendorProvisioningStateUserDataValidationFailed'
	VendorProvisioningState VendorProvisioningState `json:"vendorProvisioningState,omitempty"`
	// SkuName - READ-ONLY; Name of the sku
	SkuName *string `json:"skuName,omitempty"`
	// SkuType - READ-ONLY; Sku type. Possible values include: 'SkuTypeUnknown', 'SkuTypeEvolvedPacketCore', 'SkuTypeSDWAN'
	SkuType SkuType `json:"skuType,omitempty"`
	// VirtualNetworkFunctionVendorConfigurations - An array of virtual network function vendor configurations.
	VirtualNetworkFunctionVendorConfigurations *[]VirtualNetworkFunctionVendorConfiguration `json:"virtualNetworkFunctionVendorConfigurations,omitempty"`
}

// MarshalJSON is the custom marshaler for VendorVirtualNetworkFunctionPropertiesFormat.
func (vvnfpf VendorVirtualNetworkFunctionPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vvnfpf.VendorProvisioningState != "" {
		objectMap["vendorProvisioningState"] = vvnfpf.VendorProvisioningState
	}
	if vvnfpf.VirtualNetworkFunctionVendorConfigurations != nil {
		objectMap["virtualNetworkFunctionVendorConfigurations"] = vvnfpf.VirtualNetworkFunctionVendorConfigurations
	}
	return json.Marshal(objectMap)
}

// VendorVirtualNetworkFunctionsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results
// of a long-running operation.
type VendorVirtualNetworkFunctionsCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *VendorVirtualNetworkFunctionsCreateOrUpdateFuture) Result(client VendorVirtualNetworkFunctionsClient) (vvnf VendorVirtualNetworkFunction, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hybridnetwork.VendorVirtualNetworkFunctionsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("hybridnetwork.VendorVirtualNetworkFunctionsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if vvnf.Response.Response, err = future.GetResult(sender); err == nil && vvnf.Response.Response.StatusCode != http.StatusNoContent {
		vvnf, err = client.CreateOrUpdateResponder(vvnf.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "hybridnetwork.VendorVirtualNetworkFunctionsCreateOrUpdateFuture", "Result", vvnf.Response.Response, "Failure responding to request")
		}
	}
	return
}

// VirtualNetworkFunction hybrid network virtual network function resource response.
type VirtualNetworkFunction struct {
	autorest.Response `json:"-"`
	// VirtualNetworkFunctionPropertiesFormat - Hybrid network virtual network function properties.
	*VirtualNetworkFunctionPropertiesFormat `json:"properties,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for VirtualNetworkFunction.
func (vnf VirtualNetworkFunction) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vnf.VirtualNetworkFunctionPropertiesFormat != nil {
		objectMap["properties"] = vnf.VirtualNetworkFunctionPropertiesFormat
	}
	if vnf.Etag != nil {
		objectMap["etag"] = vnf.Etag
	}
	if vnf.Location != nil {
		objectMap["location"] = vnf.Location
	}
	if vnf.Tags != nil {
		objectMap["tags"] = vnf.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for VirtualNetworkFunction struct.
func (vnf *VirtualNetworkFunction) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var virtualNetworkFunctionPropertiesFormat VirtualNetworkFunctionPropertiesFormat
				err = json.Unmarshal(*v, &virtualNetworkFunctionPropertiesFormat)
				if err != nil {
					return err
				}
				vnf.VirtualNetworkFunctionPropertiesFormat = &virtualNetworkFunctionPropertiesFormat
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				vnf.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				vnf.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				vnf.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				vnf.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				vnf.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				vnf.Tags = tags
			}
		}
	}

	return nil
}

// VirtualNetworkFunctionListResult response for hybrid network virtual network function API service call.
type VirtualNetworkFunctionListResult struct {
	autorest.Response `json:"-"`
	// Value - A list of hybrid network virtual network function resources in a subscription or resource group.
	Value *[]VirtualNetworkFunction `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for VirtualNetworkFunctionListResult.
func (vnflr VirtualNetworkFunctionListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vnflr.Value != nil {
		objectMap["value"] = vnflr.Value
	}
	return json.Marshal(objectMap)
}

// VirtualNetworkFunctionListResultIterator provides access to a complete listing of VirtualNetworkFunction
// values.
type VirtualNetworkFunctionListResultIterator struct {
	i    int
	page VirtualNetworkFunctionListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *VirtualNetworkFunctionListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VirtualNetworkFunctionListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *VirtualNetworkFunctionListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter VirtualNetworkFunctionListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter VirtualNetworkFunctionListResultIterator) Response() VirtualNetworkFunctionListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter VirtualNetworkFunctionListResultIterator) Value() VirtualNetworkFunction {
	if !iter.page.NotDone() {
		return VirtualNetworkFunction{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the VirtualNetworkFunctionListResultIterator type.
func NewVirtualNetworkFunctionListResultIterator(page VirtualNetworkFunctionListResultPage) VirtualNetworkFunctionListResultIterator {
	return VirtualNetworkFunctionListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (vnflr VirtualNetworkFunctionListResult) IsEmpty() bool {
	return vnflr.Value == nil || len(*vnflr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (vnflr VirtualNetworkFunctionListResult) hasNextLink() bool {
	return vnflr.NextLink != nil && len(*vnflr.NextLink) != 0
}

// virtualNetworkFunctionListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (vnflr VirtualNetworkFunctionListResult) virtualNetworkFunctionListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !vnflr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(vnflr.NextLink)))
}

// VirtualNetworkFunctionListResultPage contains a page of VirtualNetworkFunction values.
type VirtualNetworkFunctionListResultPage struct {
	fn    func(context.Context, VirtualNetworkFunctionListResult) (VirtualNetworkFunctionListResult, error)
	vnflr VirtualNetworkFunctionListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *VirtualNetworkFunctionListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VirtualNetworkFunctionListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.vnflr)
		if err != nil {
			return err
		}
		page.vnflr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *VirtualNetworkFunctionListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page VirtualNetworkFunctionListResultPage) NotDone() bool {
	return !page.vnflr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page VirtualNetworkFunctionListResultPage) Response() VirtualNetworkFunctionListResult {
	return page.vnflr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page VirtualNetworkFunctionListResultPage) Values() []VirtualNetworkFunction {
	if page.vnflr.IsEmpty() {
		return nil
	}
	return *page.vnflr.Value
}

// Creates a new instance of the VirtualNetworkFunctionListResultPage type.
func NewVirtualNetworkFunctionListResultPage(getNextPage func(context.Context, VirtualNetworkFunctionListResult) (VirtualNetworkFunctionListResult, error)) VirtualNetworkFunctionListResultPage {
	return VirtualNetworkFunctionListResultPage{fn: getNextPage}
}

// VirtualNetworkFunctionPropertiesFormat hybrid network virtual network function properties.
type VirtualNetworkFunctionPropertiesFormat struct {
	// ProvisioningState - READ-ONLY; The provisioning state of the hybrid network virtual network function resource. Possible values include: 'ProvisioningStateUnknown', 'ProvisioningStateSucceeded', 'ProvisioningStateAccepted', 'ProvisioningStateDeleting', 'ProvisioningStateFailed', 'ProvisioningStateCanceled', 'ProvisioningStateDeleted'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// Device - The reference to the hybrid network device.
	Device *SubResource `json:"device,omitempty"`
	// SkuName - The sku name for the hybrid network virtual network function.
	SkuName *string `json:"skuName,omitempty"`
	// SkuType - READ-ONLY; The sku type for the hybrid network virtual network function. Possible values include: 'SkuTypeUnknown', 'SkuTypeEvolvedPacketCore', 'SkuTypeSDWAN'
	SkuType SkuType `json:"skuType,omitempty"`
	// VendorName - The vendor name for the hybrid network virtual network function.
	VendorName *string `json:"vendorName,omitempty"`
	// ServiceKey - READ-ONLY; The service key for the virtual network function resource.
	ServiceKey *string `json:"serviceKey,omitempty"`
	// VendorProvisioningState - READ-ONLY; The vendor provisioning state for the virtual network function resource. Possible values include: 'VendorProvisioningStateUnknown', 'VendorProvisioningStateNotProvisioned', 'VendorProvisioningStateProvisioning', 'VendorProvisioningStateProvisioned', 'VendorProvisioningStateDeprovisioned', 'VendorProvisioningStateUserDataValidationFailed'
	VendorProvisioningState VendorProvisioningState `json:"vendorProvisioningState,omitempty"`
	// ManagedApplication - READ-ONLY; The resource URI of the managed application.
	ManagedApplication *SubResource `json:"managedApplication,omitempty"`
	// ManagedApplicationParameters - The parameters for the managed application.
	ManagedApplicationParameters interface{} `json:"managedApplicationParameters,omitempty"`
	// VirtualNetworkFunctionUserConfigurations - The virtual network function configurations from the user.
	VirtualNetworkFunctionUserConfigurations *[]VirtualNetworkFunctionUserConfiguration `json:"virtualNetworkFunctionUserConfigurations,omitempty"`
}

// MarshalJSON is the custom marshaler for VirtualNetworkFunctionPropertiesFormat.
func (vnfpf VirtualNetworkFunctionPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vnfpf.Device != nil {
		objectMap["device"] = vnfpf.Device
	}
	if vnfpf.SkuName != nil {
		objectMap["skuName"] = vnfpf.SkuName
	}
	if vnfpf.VendorName != nil {
		objectMap["vendorName"] = vnfpf.VendorName
	}
	if vnfpf.ManagedApplicationParameters != nil {
		objectMap["managedApplicationParameters"] = vnfpf.ManagedApplicationParameters
	}
	if vnfpf.VirtualNetworkFunctionUserConfigurations != nil {
		objectMap["virtualNetworkFunctionUserConfigurations"] = vnfpf.VirtualNetworkFunctionUserConfigurations
	}
	return json.Marshal(objectMap)
}

// VirtualNetworkFunctionRoleConfiguration virtual network function role configuration.
type VirtualNetworkFunctionRoleConfiguration struct {
	// RoleName - The name of the virtual network function role.
	RoleName *string `json:"roleName,omitempty"`
	// RoleType - Role type. Possible values include: 'VirtualNetworkFunctionRoleConfigurationTypeUnknown', 'VirtualNetworkFunctionRoleConfigurationTypeVirtualMachine'
	RoleType VirtualNetworkFunctionRoleConfigurationType `json:"roleType,omitempty"`
	// VirtualMachineSize - The size of the virtual machine. Possible values include: 'VirtualMachineSizeTypesUnknown', 'VirtualMachineSizeTypesStandardD1V2', 'VirtualMachineSizeTypesStandardD2V2', 'VirtualMachineSizeTypesStandardD3V2', 'VirtualMachineSizeTypesStandardD4V2', 'VirtualMachineSizeTypesStandardD5V2', 'VirtualMachineSizeTypesStandardD11V2', 'VirtualMachineSizeTypesStandardD12V2', 'VirtualMachineSizeTypesStandardD13V2', 'VirtualMachineSizeTypesStandardDS1V2', 'VirtualMachineSizeTypesStandardDS2V2', 'VirtualMachineSizeTypesStandardDS3V2', 'VirtualMachineSizeTypesStandardDS4V2', 'VirtualMachineSizeTypesStandardDS5V2', 'VirtualMachineSizeTypesStandardDS11V2', 'VirtualMachineSizeTypesStandardDS12V2', 'VirtualMachineSizeTypesStandardDS13V2'
	VirtualMachineSize VirtualMachineSizeTypes `json:"virtualMachineSize,omitempty"`
	// ImageReference - The definition of image reference.
	ImageReference *ImageReference `json:"imageReference,omitempty"`
	// OsProfile - Specifies the operating system settings for the role instance. This value can be updated during the deployment of virtual network function.
	OsProfile *OsProfile `json:"osProfile,omitempty"`
	// UserDataTemplate - The user data template for customers. This is json scheme template describing the format and data type of user data parameters.
	UserDataTemplate interface{} `json:"userDataTemplate,omitempty"`
	// UserDataParameters - The user parameters for customers. The format of user data parameters has to be matched with the provided user data template.
	UserDataParameters interface{} `json:"userDataParameters,omitempty"`
	// NetworkInterfaces - The network interface configurations.
	NetworkInterfaces *[]NetworkInterface `json:"networkInterfaces,omitempty"`
}

// VirtualNetworkFunctionsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type VirtualNetworkFunctionsCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *VirtualNetworkFunctionsCreateOrUpdateFuture) Result(client VirtualNetworkFunctionsClient) (vnf VirtualNetworkFunction, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hybridnetwork.VirtualNetworkFunctionsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("hybridnetwork.VirtualNetworkFunctionsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if vnf.Response.Response, err = future.GetResult(sender); err == nil && vnf.Response.Response.StatusCode != http.StatusNoContent {
		vnf, err = client.CreateOrUpdateResponder(vnf.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "hybridnetwork.VirtualNetworkFunctionsCreateOrUpdateFuture", "Result", vnf.Response.Response, "Failure responding to request")
		}
	}
	return
}

// VirtualNetworkFunctionsDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type VirtualNetworkFunctionsDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *VirtualNetworkFunctionsDeleteFuture) Result(client VirtualNetworkFunctionsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hybridnetwork.VirtualNetworkFunctionsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("hybridnetwork.VirtualNetworkFunctionsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// VirtualNetworkFunctionSkuDetails the virtual network function sku details.
type VirtualNetworkFunctionSkuDetails struct {
	autorest.Response `json:"-"`
	// SkuType - The virtual network function sku type. Possible values include: 'SkuTypeUnknown', 'SkuTypeEvolvedPacketCore', 'SkuTypeSDWAN'
	SkuType SkuType `json:"skuType,omitempty"`
	// Value - The virtual network function sku role details.
	Value *[]VirtualNetworkFunctionSkuRoleDetails `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for VirtualNetworkFunctionSkuDetails.
func (vnfsd VirtualNetworkFunctionSkuDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vnfsd.SkuType != "" {
		objectMap["skuType"] = vnfsd.SkuType
	}
	if vnfsd.Value != nil {
		objectMap["value"] = vnfsd.Value
	}
	return json.Marshal(objectMap)
}

// VirtualNetworkFunctionSkuDetailsIterator provides access to a complete listing of
// VirtualNetworkFunctionSkuRoleDetails values.
type VirtualNetworkFunctionSkuDetailsIterator struct {
	i    int
	page VirtualNetworkFunctionSkuDetailsPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *VirtualNetworkFunctionSkuDetailsIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VirtualNetworkFunctionSkuDetailsIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *VirtualNetworkFunctionSkuDetailsIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter VirtualNetworkFunctionSkuDetailsIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter VirtualNetworkFunctionSkuDetailsIterator) Response() VirtualNetworkFunctionSkuDetails {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter VirtualNetworkFunctionSkuDetailsIterator) Value() VirtualNetworkFunctionSkuRoleDetails {
	if !iter.page.NotDone() {
		return VirtualNetworkFunctionSkuRoleDetails{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the VirtualNetworkFunctionSkuDetailsIterator type.
func NewVirtualNetworkFunctionSkuDetailsIterator(page VirtualNetworkFunctionSkuDetailsPage) VirtualNetworkFunctionSkuDetailsIterator {
	return VirtualNetworkFunctionSkuDetailsIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (vnfsd VirtualNetworkFunctionSkuDetails) IsEmpty() bool {
	return vnfsd.Value == nil || len(*vnfsd.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (vnfsd VirtualNetworkFunctionSkuDetails) hasNextLink() bool {
	return vnfsd.NextLink != nil && len(*vnfsd.NextLink) != 0
}

// virtualNetworkFunctionSkuDetailsPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (vnfsd VirtualNetworkFunctionSkuDetails) virtualNetworkFunctionSkuDetailsPreparer(ctx context.Context) (*http.Request, error) {
	if !vnfsd.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(vnfsd.NextLink)))
}

// VirtualNetworkFunctionSkuDetailsPage contains a page of VirtualNetworkFunctionSkuRoleDetails values.
type VirtualNetworkFunctionSkuDetailsPage struct {
	fn    func(context.Context, VirtualNetworkFunctionSkuDetails) (VirtualNetworkFunctionSkuDetails, error)
	vnfsd VirtualNetworkFunctionSkuDetails
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *VirtualNetworkFunctionSkuDetailsPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VirtualNetworkFunctionSkuDetailsPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.vnfsd)
		if err != nil {
			return err
		}
		page.vnfsd = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *VirtualNetworkFunctionSkuDetailsPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page VirtualNetworkFunctionSkuDetailsPage) NotDone() bool {
	return !page.vnfsd.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page VirtualNetworkFunctionSkuDetailsPage) Response() VirtualNetworkFunctionSkuDetails {
	return page.vnfsd
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page VirtualNetworkFunctionSkuDetailsPage) Values() []VirtualNetworkFunctionSkuRoleDetails {
	if page.vnfsd.IsEmpty() {
		return nil
	}
	return *page.vnfsd.Value
}

// Creates a new instance of the VirtualNetworkFunctionSkuDetailsPage type.
func NewVirtualNetworkFunctionSkuDetailsPage(getNextPage func(context.Context, VirtualNetworkFunctionSkuDetails) (VirtualNetworkFunctionSkuDetails, error)) VirtualNetworkFunctionSkuDetailsPage {
	return VirtualNetworkFunctionSkuDetailsPage{fn: getNextPage}
}

// VirtualNetworkFunctionSkuListResult a list of available hybrid network virtual network function skus.
type VirtualNetworkFunctionSkuListResult struct {
	autorest.Response `json:"-"`
	// Value - The virtual network function vendor sku overview properties.
	Value *[]SkuOverview `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for VirtualNetworkFunctionSkuListResult.
func (vnfslr VirtualNetworkFunctionSkuListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vnfslr.Value != nil {
		objectMap["value"] = vnfslr.Value
	}
	return json.Marshal(objectMap)
}

// VirtualNetworkFunctionSkuListResultIterator provides access to a complete listing of SkuOverview values.
type VirtualNetworkFunctionSkuListResultIterator struct {
	i    int
	page VirtualNetworkFunctionSkuListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *VirtualNetworkFunctionSkuListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VirtualNetworkFunctionSkuListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *VirtualNetworkFunctionSkuListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter VirtualNetworkFunctionSkuListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter VirtualNetworkFunctionSkuListResultIterator) Response() VirtualNetworkFunctionSkuListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter VirtualNetworkFunctionSkuListResultIterator) Value() SkuOverview {
	if !iter.page.NotDone() {
		return SkuOverview{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the VirtualNetworkFunctionSkuListResultIterator type.
func NewVirtualNetworkFunctionSkuListResultIterator(page VirtualNetworkFunctionSkuListResultPage) VirtualNetworkFunctionSkuListResultIterator {
	return VirtualNetworkFunctionSkuListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (vnfslr VirtualNetworkFunctionSkuListResult) IsEmpty() bool {
	return vnfslr.Value == nil || len(*vnfslr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (vnfslr VirtualNetworkFunctionSkuListResult) hasNextLink() bool {
	return vnfslr.NextLink != nil && len(*vnfslr.NextLink) != 0
}

// virtualNetworkFunctionSkuListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (vnfslr VirtualNetworkFunctionSkuListResult) virtualNetworkFunctionSkuListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !vnfslr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(vnfslr.NextLink)))
}

// VirtualNetworkFunctionSkuListResultPage contains a page of SkuOverview values.
type VirtualNetworkFunctionSkuListResultPage struct {
	fn     func(context.Context, VirtualNetworkFunctionSkuListResult) (VirtualNetworkFunctionSkuListResult, error)
	vnfslr VirtualNetworkFunctionSkuListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *VirtualNetworkFunctionSkuListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VirtualNetworkFunctionSkuListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.vnfslr)
		if err != nil {
			return err
		}
		page.vnfslr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *VirtualNetworkFunctionSkuListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page VirtualNetworkFunctionSkuListResultPage) NotDone() bool {
	return !page.vnfslr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page VirtualNetworkFunctionSkuListResultPage) Response() VirtualNetworkFunctionSkuListResult {
	return page.vnfslr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page VirtualNetworkFunctionSkuListResultPage) Values() []SkuOverview {
	if page.vnfslr.IsEmpty() {
		return nil
	}
	return *page.vnfslr.Value
}

// Creates a new instance of the VirtualNetworkFunctionSkuListResultPage type.
func NewVirtualNetworkFunctionSkuListResultPage(getNextPage func(context.Context, VirtualNetworkFunctionSkuListResult) (VirtualNetworkFunctionSkuListResult, error)) VirtualNetworkFunctionSkuListResultPage {
	return VirtualNetworkFunctionSkuListResultPage{fn: getNextPage}
}

// VirtualNetworkFunctionSkuRoleDetails the virtual network function user configuration.
type VirtualNetworkFunctionSkuRoleDetails struct {
	// RoleName - The name of the virtual network function role.
	RoleName *string `json:"roleName,omitempty"`
	// UserDataTemplate - The user data template for customers.
	UserDataTemplate interface{} `json:"userDataTemplate,omitempty"`
	// UserDataParameters - The user parameters for customers.
	UserDataParameters interface{} `json:"userDataParameters,omitempty"`
	// NetworkInterfaces - The network interface configuration.
	NetworkInterfaces *[]NetworkInterface `json:"networkInterfaces,omitempty"`
}

// VirtualNetworkFunctionTemplate the virtual network function template.
type VirtualNetworkFunctionTemplate struct {
	// VirutalNetworkFunctionRoleConfigurations - An array of virtual network function role definitions.
	VirutalNetworkFunctionRoleConfigurations *[]VirtualNetworkFunctionRoleConfiguration `json:"virutalNetworkFunctionRoleConfigurations,omitempty"`
}

// VirtualNetworkFunctionUserConfiguration the virtual network function user configuration.
type VirtualNetworkFunctionUserConfiguration struct {
	// RoleName - The name of the virtual network function role.
	RoleName *string `json:"roleName,omitempty"`
	// UserDataParameters - The user data parameters from the customer.
	UserDataParameters interface{} `json:"userDataParameters,omitempty"`
	// NetworkInterfaces - The network interface configuration.
	NetworkInterfaces *[]NetworkInterface `json:"networkInterfaces,omitempty"`
}

// VirtualNetworkFunctionVendor the virtual network function vendor.
type VirtualNetworkFunctionVendor struct {
	// VendorDetails - Vendors of the hybrid network service provider.
	*VendorDetails `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for VirtualNetworkFunctionVendor.
func (vnfv VirtualNetworkFunctionVendor) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vnfv.VendorDetails != nil {
		objectMap["properties"] = vnfv.VendorDetails
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for VirtualNetworkFunctionVendor struct.
func (vnfv *VirtualNetworkFunctionVendor) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var vendorDetails VendorDetails
				err = json.Unmarshal(*v, &vendorDetails)
				if err != nil {
					return err
				}
				vnfv.VendorDetails = &vendorDetails
			}
		}
	}

	return nil
}

// VirtualNetworkFunctionVendorConfiguration virtual network function vendor configuration.
type VirtualNetworkFunctionVendorConfiguration struct {
	// RoleName - The name of the virtual network function role.
	RoleName *string `json:"roleName,omitempty"`
	// CustomData - Specifies a base-64 encoded string of custom data. The base-64 encoded string is decoded to a binary array that is saved as a file on the virtual machine. The maximum length of the binary array is 65535 bytes. <br><br> **Note: Do not pass any secrets or passwords in customData property** <br><br> This property cannot be updated after the VM is created. <br><br> customData is passed to the VM to be saved as a file, for more information see [Custom Data on Azure VMs](https://azure.microsoft.com/en-us/blog/custom-data-and-cloud-init-on-windows-azure/) <br><br> For using cloud-init for your Linux VM, see [Using cloud-init to customize a Linux VM during creation](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-using-cloud-init?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json)
	CustomData *string `json:"customData,omitempty"`
	// OsProfile - Specifies the operating system settings for the role instance.
	OsProfile *OsProfile `json:"osProfile,omitempty"`
	// UserDataParameters - READ-ONLY; The user parameters from the customer.
	UserDataParameters interface{} `json:"userDataParameters,omitempty"`
	// NetworkInterfaces - The network interface configurations.
	NetworkInterfaces *[]NetworkInterface `json:"networkInterfaces,omitempty"`
}

// MarshalJSON is the custom marshaler for VirtualNetworkFunctionVendorConfiguration.
func (vnfvc VirtualNetworkFunctionVendorConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vnfvc.RoleName != nil {
		objectMap["roleName"] = vnfvc.RoleName
	}
	if vnfvc.CustomData != nil {
		objectMap["customData"] = vnfvc.CustomData
	}
	if vnfvc.OsProfile != nil {
		objectMap["osProfile"] = vnfvc.OsProfile
	}
	if vnfvc.NetworkInterfaces != nil {
		objectMap["networkInterfaces"] = vnfvc.NetworkInterfaces
	}
	return json.Marshal(objectMap)
}

// VirtualNetworkFunctionVendorListResult the virtual network function vendor list result.
type VirtualNetworkFunctionVendorListResult struct {
	autorest.Response `json:"-"`
	// Value - A list of available hybrid network virtual network function vendors and skus.
	Value *[]VirtualNetworkFunctionVendor `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for VirtualNetworkFunctionVendorListResult.
func (vnfvlr VirtualNetworkFunctionVendorListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vnfvlr.Value != nil {
		objectMap["value"] = vnfvlr.Value
	}
	return json.Marshal(objectMap)
}

// VirtualNetworkFunctionVendorListResultIterator provides access to a complete listing of
// VirtualNetworkFunctionVendor values.
type VirtualNetworkFunctionVendorListResultIterator struct {
	i    int
	page VirtualNetworkFunctionVendorListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *VirtualNetworkFunctionVendorListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VirtualNetworkFunctionVendorListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *VirtualNetworkFunctionVendorListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter VirtualNetworkFunctionVendorListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter VirtualNetworkFunctionVendorListResultIterator) Response() VirtualNetworkFunctionVendorListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter VirtualNetworkFunctionVendorListResultIterator) Value() VirtualNetworkFunctionVendor {
	if !iter.page.NotDone() {
		return VirtualNetworkFunctionVendor{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the VirtualNetworkFunctionVendorListResultIterator type.
func NewVirtualNetworkFunctionVendorListResultIterator(page VirtualNetworkFunctionVendorListResultPage) VirtualNetworkFunctionVendorListResultIterator {
	return VirtualNetworkFunctionVendorListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (vnfvlr VirtualNetworkFunctionVendorListResult) IsEmpty() bool {
	return vnfvlr.Value == nil || len(*vnfvlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (vnfvlr VirtualNetworkFunctionVendorListResult) hasNextLink() bool {
	return vnfvlr.NextLink != nil && len(*vnfvlr.NextLink) != 0
}

// virtualNetworkFunctionVendorListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (vnfvlr VirtualNetworkFunctionVendorListResult) virtualNetworkFunctionVendorListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !vnfvlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(vnfvlr.NextLink)))
}

// VirtualNetworkFunctionVendorListResultPage contains a page of VirtualNetworkFunctionVendor values.
type VirtualNetworkFunctionVendorListResultPage struct {
	fn     func(context.Context, VirtualNetworkFunctionVendorListResult) (VirtualNetworkFunctionVendorListResult, error)
	vnfvlr VirtualNetworkFunctionVendorListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *VirtualNetworkFunctionVendorListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VirtualNetworkFunctionVendorListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.vnfvlr)
		if err != nil {
			return err
		}
		page.vnfvlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *VirtualNetworkFunctionVendorListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page VirtualNetworkFunctionVendorListResultPage) NotDone() bool {
	return !page.vnfvlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page VirtualNetworkFunctionVendorListResultPage) Response() VirtualNetworkFunctionVendorListResult {
	return page.vnfvlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page VirtualNetworkFunctionVendorListResultPage) Values() []VirtualNetworkFunctionVendor {
	if page.vnfvlr.IsEmpty() {
		return nil
	}
	return *page.vnfvlr.Value
}

// Creates a new instance of the VirtualNetworkFunctionVendorListResultPage type.
func NewVirtualNetworkFunctionVendorListResultPage(getNextPage func(context.Context, VirtualNetworkFunctionVendorListResult) (VirtualNetworkFunctionVendorListResult, error)) VirtualNetworkFunctionVendorListResultPage {
	return VirtualNetworkFunctionVendorListResultPage{fn: getNextPage}
}
