package sql

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"github.com/satori/go.uuid"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/preview/sql/mgmt/v3.0/sql"

// AdministratorListResult a list of active directory administrators.
type AdministratorListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]ServerAzureADAdministrator `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// AdministratorListResultIterator provides access to a complete listing of ServerAzureADAdministrator values.
type AdministratorListResultIterator struct {
	i    int
	page AdministratorListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *AdministratorListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AdministratorListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *AdministratorListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter AdministratorListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter AdministratorListResultIterator) Response() AdministratorListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter AdministratorListResultIterator) Value() ServerAzureADAdministrator {
	if !iter.page.NotDone() {
		return ServerAzureADAdministrator{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the AdministratorListResultIterator type.
func NewAdministratorListResultIterator(page AdministratorListResultPage) AdministratorListResultIterator {
	return AdministratorListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (alr AdministratorListResult) IsEmpty() bool {
	return alr.Value == nil || len(*alr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (alr AdministratorListResult) hasNextLink() bool {
	return alr.NextLink != nil && len(*alr.NextLink) != 0
}

// administratorListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (alr AdministratorListResult) administratorListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !alr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(alr.NextLink)))
}

// AdministratorListResultPage contains a page of ServerAzureADAdministrator values.
type AdministratorListResultPage struct {
	fn  func(context.Context, AdministratorListResult) (AdministratorListResult, error)
	alr AdministratorListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *AdministratorListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AdministratorListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.alr)
		if err != nil {
			return err
		}
		page.alr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *AdministratorListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page AdministratorListResultPage) NotDone() bool {
	return !page.alr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page AdministratorListResultPage) Response() AdministratorListResult {
	return page.alr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page AdministratorListResultPage) Values() []ServerAzureADAdministrator {
	if page.alr.IsEmpty() {
		return nil
	}
	return *page.alr.Value
}

// Creates a new instance of the AdministratorListResultPage type.
func NewAdministratorListResultPage(getNextPage func(context.Context, AdministratorListResult) (AdministratorListResult, error)) AdministratorListResultPage {
	return AdministratorListResultPage{fn: getNextPage}
}

// AdministratorProperties properties of a active directory administrator.
type AdministratorProperties struct {
	// AdministratorType - Type of the sever administrator.
	AdministratorType *string `json:"administratorType,omitempty"`
	// Login - Login name of the server administrator.
	Login *string `json:"login,omitempty"`
	// Sid - SID (object ID) of the server administrator.
	Sid *uuid.UUID `json:"sid,omitempty"`
	// TenantID - Tenant ID of the administrator.
	TenantID *uuid.UUID `json:"tenantId,omitempty"`
	// AzureADOnlyAuthentication - READ-ONLY; Azure Active Directory only Authentication enabled.
	AzureADOnlyAuthentication *bool `json:"azureADOnlyAuthentication,omitempty"`
}

// MarshalJSON is the custom marshaler for AdministratorProperties.
func (ap AdministratorProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ap.AdministratorType != nil {
		objectMap["administratorType"] = ap.AdministratorType
	}
	if ap.Login != nil {
		objectMap["login"] = ap.Login
	}
	if ap.Sid != nil {
		objectMap["sid"] = ap.Sid
	}
	if ap.TenantID != nil {
		objectMap["tenantId"] = ap.TenantID
	}
	return json.Marshal(objectMap)
}

// AutomaticTuningOptions automatic tuning properties for individual advisors.
type AutomaticTuningOptions struct {
	// DesiredState - Automatic tuning option desired state. Possible values include: 'AutomaticTuningOptionModeDesiredOff', 'AutomaticTuningOptionModeDesiredOn', 'AutomaticTuningOptionModeDesiredDefault'
	DesiredState AutomaticTuningOptionModeDesired `json:"desiredState,omitempty"`
	// ActualState - READ-ONLY; Automatic tuning option actual state. Possible values include: 'Off', 'On'
	ActualState AutomaticTuningOptionModeActual `json:"actualState,omitempty"`
	// ReasonCode - READ-ONLY; Reason code if desired and actual state are different.
	ReasonCode *int32 `json:"reasonCode,omitempty"`
	// ReasonDesc - READ-ONLY; Reason description if desired and actual state are different. Possible values include: 'Default', 'Disabled', 'AutoConfigured', 'InheritedFromServer', 'QueryStoreOff', 'QueryStoreReadOnly', 'NotSupported'
	ReasonDesc AutomaticTuningDisabledReason `json:"reasonDesc,omitempty"`
}

// MarshalJSON is the custom marshaler for AutomaticTuningOptions.
func (ato AutomaticTuningOptions) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ato.DesiredState != "" {
		objectMap["desiredState"] = ato.DesiredState
	}
	return json.Marshal(objectMap)
}

// AutomaticTuningServerOptions automatic tuning properties for individual advisors.
type AutomaticTuningServerOptions struct {
	// DesiredState - Automatic tuning option desired state. Possible values include: 'AutomaticTuningOptionModeDesiredOff', 'AutomaticTuningOptionModeDesiredOn', 'AutomaticTuningOptionModeDesiredDefault'
	DesiredState AutomaticTuningOptionModeDesired `json:"desiredState,omitempty"`
	// ActualState - READ-ONLY; Automatic tuning option actual state. Possible values include: 'Off', 'On'
	ActualState AutomaticTuningOptionModeActual `json:"actualState,omitempty"`
	// ReasonCode - READ-ONLY; Reason code if desired and actual state are different.
	ReasonCode *int32 `json:"reasonCode,omitempty"`
	// ReasonDesc - READ-ONLY; Reason description if desired and actual state are different. Possible values include: 'AutomaticTuningServerReasonDefault', 'AutomaticTuningServerReasonDisabled', 'AutomaticTuningServerReasonAutoConfigured'
	ReasonDesc AutomaticTuningServerReason `json:"reasonDesc,omitempty"`
}

// MarshalJSON is the custom marshaler for AutomaticTuningServerOptions.
func (atso AutomaticTuningServerOptions) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if atso.DesiredState != "" {
		objectMap["desiredState"] = atso.DesiredState
	}
	return json.Marshal(objectMap)
}

// AutomaticTuningServerProperties server-level Automatic Tuning properties.
type AutomaticTuningServerProperties struct {
	// DesiredState - Automatic tuning desired state. Possible values include: 'AutomaticTuningServerModeCustom', 'AutomaticTuningServerModeAuto', 'AutomaticTuningServerModeUnspecified'
	DesiredState AutomaticTuningServerMode `json:"desiredState,omitempty"`
	// ActualState - READ-ONLY; Automatic tuning actual state. Possible values include: 'AutomaticTuningServerModeCustom', 'AutomaticTuningServerModeAuto', 'AutomaticTuningServerModeUnspecified'
	ActualState AutomaticTuningServerMode `json:"actualState,omitempty"`
	// Options - Automatic tuning options definition.
	Options map[string]*AutomaticTuningServerOptions `json:"options"`
}

// MarshalJSON is the custom marshaler for AutomaticTuningServerProperties.
func (atsp AutomaticTuningServerProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if atsp.DesiredState != "" {
		objectMap["desiredState"] = atsp.DesiredState
	}
	if atsp.Options != nil {
		objectMap["options"] = atsp.Options
	}
	return json.Marshal(objectMap)
}

// AutoPauseDelayTimeRange supported auto pause delay time range
type AutoPauseDelayTimeRange struct {
	// MinValue - READ-ONLY; Minimum value
	MinValue *int32 `json:"minValue,omitempty"`
	// MaxValue - READ-ONLY; Maximum value
	MaxValue *int32 `json:"maxValue,omitempty"`
	// StepSize - READ-ONLY; Step value for discrete values between the minimum value and the maximum value.
	StepSize *int32 `json:"stepSize,omitempty"`
	// Default - READ-ONLY; Default value is no value is provided
	Default *int32 `json:"default,omitempty"`
	// Unit - READ-ONLY; Unit of time that delay is expressed in. Possible values include: 'Minutes'
	Unit PauseDelayTimeUnit `json:"unit,omitempty"`
	// DoNotPauseValue - READ-ONLY; Value that is used to not pause (infinite delay before pause)
	DoNotPauseValue *int32 `json:"doNotPauseValue,omitempty"`
}

// AzureADOnlyAuthListResult a list of active directory only authentications.
type AzureADOnlyAuthListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]ServerAzureADOnlyAuthentication `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// AzureADOnlyAuthListResultIterator provides access to a complete listing of ServerAzureADOnlyAuthentication
// values.
type AzureADOnlyAuthListResultIterator struct {
	i    int
	page AzureADOnlyAuthListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *AzureADOnlyAuthListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AzureADOnlyAuthListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *AzureADOnlyAuthListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter AzureADOnlyAuthListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter AzureADOnlyAuthListResultIterator) Response() AzureADOnlyAuthListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter AzureADOnlyAuthListResultIterator) Value() ServerAzureADOnlyAuthentication {
	if !iter.page.NotDone() {
		return ServerAzureADOnlyAuthentication{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the AzureADOnlyAuthListResultIterator type.
func NewAzureADOnlyAuthListResultIterator(page AzureADOnlyAuthListResultPage) AzureADOnlyAuthListResultIterator {
	return AzureADOnlyAuthListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (aaoalr AzureADOnlyAuthListResult) IsEmpty() bool {
	return aaoalr.Value == nil || len(*aaoalr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (aaoalr AzureADOnlyAuthListResult) hasNextLink() bool {
	return aaoalr.NextLink != nil && len(*aaoalr.NextLink) != 0
}

// azureADOnlyAuthListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (aaoalr AzureADOnlyAuthListResult) azureADOnlyAuthListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !aaoalr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(aaoalr.NextLink)))
}

// AzureADOnlyAuthListResultPage contains a page of ServerAzureADOnlyAuthentication values.
type AzureADOnlyAuthListResultPage struct {
	fn     func(context.Context, AzureADOnlyAuthListResult) (AzureADOnlyAuthListResult, error)
	aaoalr AzureADOnlyAuthListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *AzureADOnlyAuthListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AzureADOnlyAuthListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.aaoalr)
		if err != nil {
			return err
		}
		page.aaoalr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *AzureADOnlyAuthListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page AzureADOnlyAuthListResultPage) NotDone() bool {
	return !page.aaoalr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page AzureADOnlyAuthListResultPage) Response() AzureADOnlyAuthListResult {
	return page.aaoalr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page AzureADOnlyAuthListResultPage) Values() []ServerAzureADOnlyAuthentication {
	if page.aaoalr.IsEmpty() {
		return nil
	}
	return *page.aaoalr.Value
}

// Creates a new instance of the AzureADOnlyAuthListResultPage type.
func NewAzureADOnlyAuthListResultPage(getNextPage func(context.Context, AzureADOnlyAuthListResult) (AzureADOnlyAuthListResult, error)) AzureADOnlyAuthListResultPage {
	return AzureADOnlyAuthListResultPage{fn: getNextPage}
}

// AzureADOnlyAuthProperties properties of a active directory only authentication.
type AzureADOnlyAuthProperties struct {
	// AzureADOnlyAuthentication - Azure Active Directory only Authentication enabled.
	AzureADOnlyAuthentication *bool `json:"azureADOnlyAuthentication,omitempty"`
}

// BackupLongTermRetentionPoliciesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results
// of a long-running operation.
type BackupLongTermRetentionPoliciesCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *BackupLongTermRetentionPoliciesCreateOrUpdateFuture) Result(client BackupLongTermRetentionPoliciesClient) (bltrp BackupLongTermRetentionPolicy, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.BackupLongTermRetentionPoliciesCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.BackupLongTermRetentionPoliciesCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if bltrp.Response.Response, err = future.GetResult(sender); err == nil && bltrp.Response.Response.StatusCode != http.StatusNoContent {
		bltrp, err = client.CreateOrUpdateResponder(bltrp.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.BackupLongTermRetentionPoliciesCreateOrUpdateFuture", "Result", bltrp.Response.Response, "Failure responding to request")
		}
	}
	return
}

// BackupLongTermRetentionPolicy a long term retention policy.
type BackupLongTermRetentionPolicy struct {
	autorest.Response `json:"-"`
	// LongTermRetentionPolicyProperties - Resource properties.
	*LongTermRetentionPolicyProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for BackupLongTermRetentionPolicy.
func (bltrp BackupLongTermRetentionPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if bltrp.LongTermRetentionPolicyProperties != nil {
		objectMap["properties"] = bltrp.LongTermRetentionPolicyProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for BackupLongTermRetentionPolicy struct.
func (bltrp *BackupLongTermRetentionPolicy) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var longTermRetentionPolicyProperties LongTermRetentionPolicyProperties
				err = json.Unmarshal(*v, &longTermRetentionPolicyProperties)
				if err != nil {
					return err
				}
				bltrp.LongTermRetentionPolicyProperties = &longTermRetentionPolicyProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				bltrp.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				bltrp.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				bltrp.Type = &typeVar
			}
		}
	}

	return nil
}

// BackupShortTermRetentionPoliciesCreateOrUpdateFuture an abstraction for monitoring and retrieving the
// results of a long-running operation.
type BackupShortTermRetentionPoliciesCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *BackupShortTermRetentionPoliciesCreateOrUpdateFuture) Result(client BackupShortTermRetentionPoliciesClient) (bstrp BackupShortTermRetentionPolicy, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.BackupShortTermRetentionPoliciesCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.BackupShortTermRetentionPoliciesCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if bstrp.Response.Response, err = future.GetResult(sender); err == nil && bstrp.Response.Response.StatusCode != http.StatusNoContent {
		bstrp, err = client.CreateOrUpdateResponder(bstrp.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.BackupShortTermRetentionPoliciesCreateOrUpdateFuture", "Result", bstrp.Response.Response, "Failure responding to request")
		}
	}
	return
}

// BackupShortTermRetentionPoliciesUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type BackupShortTermRetentionPoliciesUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *BackupShortTermRetentionPoliciesUpdateFuture) Result(client BackupShortTermRetentionPoliciesClient) (bstrp BackupShortTermRetentionPolicy, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.BackupShortTermRetentionPoliciesUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.BackupShortTermRetentionPoliciesUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if bstrp.Response.Response, err = future.GetResult(sender); err == nil && bstrp.Response.Response.StatusCode != http.StatusNoContent {
		bstrp, err = client.UpdateResponder(bstrp.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.BackupShortTermRetentionPoliciesUpdateFuture", "Result", bstrp.Response.Response, "Failure responding to request")
		}
	}
	return
}

// BackupShortTermRetentionPolicy a short term retention policy.
type BackupShortTermRetentionPolicy struct {
	autorest.Response `json:"-"`
	// BackupShortTermRetentionPolicyProperties - Resource properties.
	*BackupShortTermRetentionPolicyProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for BackupShortTermRetentionPolicy.
func (bstrp BackupShortTermRetentionPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if bstrp.BackupShortTermRetentionPolicyProperties != nil {
		objectMap["properties"] = bstrp.BackupShortTermRetentionPolicyProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for BackupShortTermRetentionPolicy struct.
func (bstrp *BackupShortTermRetentionPolicy) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var backupShortTermRetentionPolicyProperties BackupShortTermRetentionPolicyProperties
				err = json.Unmarshal(*v, &backupShortTermRetentionPolicyProperties)
				if err != nil {
					return err
				}
				bstrp.BackupShortTermRetentionPolicyProperties = &backupShortTermRetentionPolicyProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				bstrp.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				bstrp.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				bstrp.Type = &typeVar
			}
		}
	}

	return nil
}

// BackupShortTermRetentionPolicyListResult a list of short term retention policies.
type BackupShortTermRetentionPolicyListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]BackupShortTermRetentionPolicy `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// BackupShortTermRetentionPolicyListResultIterator provides access to a complete listing of
// BackupShortTermRetentionPolicy values.
type BackupShortTermRetentionPolicyListResultIterator struct {
	i    int
	page BackupShortTermRetentionPolicyListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *BackupShortTermRetentionPolicyListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BackupShortTermRetentionPolicyListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *BackupShortTermRetentionPolicyListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter BackupShortTermRetentionPolicyListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter BackupShortTermRetentionPolicyListResultIterator) Response() BackupShortTermRetentionPolicyListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter BackupShortTermRetentionPolicyListResultIterator) Value() BackupShortTermRetentionPolicy {
	if !iter.page.NotDone() {
		return BackupShortTermRetentionPolicy{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the BackupShortTermRetentionPolicyListResultIterator type.
func NewBackupShortTermRetentionPolicyListResultIterator(page BackupShortTermRetentionPolicyListResultPage) BackupShortTermRetentionPolicyListResultIterator {
	return BackupShortTermRetentionPolicyListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (bstrplr BackupShortTermRetentionPolicyListResult) IsEmpty() bool {
	return bstrplr.Value == nil || len(*bstrplr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (bstrplr BackupShortTermRetentionPolicyListResult) hasNextLink() bool {
	return bstrplr.NextLink != nil && len(*bstrplr.NextLink) != 0
}

// backupShortTermRetentionPolicyListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (bstrplr BackupShortTermRetentionPolicyListResult) backupShortTermRetentionPolicyListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !bstrplr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(bstrplr.NextLink)))
}

// BackupShortTermRetentionPolicyListResultPage contains a page of BackupShortTermRetentionPolicy values.
type BackupShortTermRetentionPolicyListResultPage struct {
	fn      func(context.Context, BackupShortTermRetentionPolicyListResult) (BackupShortTermRetentionPolicyListResult, error)
	bstrplr BackupShortTermRetentionPolicyListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *BackupShortTermRetentionPolicyListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BackupShortTermRetentionPolicyListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.bstrplr)
		if err != nil {
			return err
		}
		page.bstrplr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *BackupShortTermRetentionPolicyListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page BackupShortTermRetentionPolicyListResultPage) NotDone() bool {
	return !page.bstrplr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page BackupShortTermRetentionPolicyListResultPage) Response() BackupShortTermRetentionPolicyListResult {
	return page.bstrplr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page BackupShortTermRetentionPolicyListResultPage) Values() []BackupShortTermRetentionPolicy {
	if page.bstrplr.IsEmpty() {
		return nil
	}
	return *page.bstrplr.Value
}

// Creates a new instance of the BackupShortTermRetentionPolicyListResultPage type.
func NewBackupShortTermRetentionPolicyListResultPage(getNextPage func(context.Context, BackupShortTermRetentionPolicyListResult) (BackupShortTermRetentionPolicyListResult, error)) BackupShortTermRetentionPolicyListResultPage {
	return BackupShortTermRetentionPolicyListResultPage{fn: getNextPage}
}

// BackupShortTermRetentionPolicyProperties properties of a short term retention policy
type BackupShortTermRetentionPolicyProperties struct {
	// RetentionDays - The backup retention period in days. This is how many days Point-in-Time Restore will be supported.
	RetentionDays *int32 `json:"retentionDays,omitempty"`
}

// BaseLongTermRetentionPolicyProperties properties of a long term retention policy
type BaseLongTermRetentionPolicyProperties struct {
	// WeeklyRetention - The weekly retention policy for an LTR backup in an ISO 8601 format.
	WeeklyRetention *string `json:"weeklyRetention,omitempty"`
	// MonthlyRetention - The monthly retention policy for an LTR backup in an ISO 8601 format.
	MonthlyRetention *string `json:"monthlyRetention,omitempty"`
	// YearlyRetention - The yearly retention policy for an LTR backup in an ISO 8601 format.
	YearlyRetention *string `json:"yearlyRetention,omitempty"`
	// WeekOfYear - The week of year to take the yearly backup in an ISO 8601 format.
	WeekOfYear *int32 `json:"weekOfYear,omitempty"`
}

// CheckNameAvailabilityRequest a request to check whether the specified name for a resource is available.
type CheckNameAvailabilityRequest struct {
	Name *string `json:"name,omitempty"`
	Type *string `json:"type,omitempty"`
}

// CheckNameAvailabilityResponse the result of a name availability check.
type CheckNameAvailabilityResponse struct {
	autorest.Response `json:"-"`
	// Name - READ-ONLY; The name whose availability was checked.
	Name *string `json:"name,omitempty"`
	// Available - READ-ONLY; True if the name is available, otherwise false.
	Available *bool `json:"available,omitempty"`
	// Reason - READ-ONLY; The reason code explaining why the name is unavailable. Will be undefined if the name is available. Possible values include: 'Invalid', 'AlreadyExists'
	Reason CheckNameAvailabilityReason `json:"reason,omitempty"`
	// Message - READ-ONLY; A message explaining why the name is unavailable. Will be undefined if the name is available.
	Message *string `json:"message,omitempty"`
}

// CompleteDatabaseRestoreDefinition contains the information necessary to perform a complete database restore
// operation.
type CompleteDatabaseRestoreDefinition struct {
	// LastBackupName - The last backup name to apply
	LastBackupName *string `json:"lastBackupName,omitempty"`
}

// CreateDatabaseRestorePointDefinition contains the information necessary to perform a create database restore
// point operation.
type CreateDatabaseRestorePointDefinition struct {
	// RestorePointLabel - The restore point label to apply
	RestorePointLabel *string `json:"restorePointLabel,omitempty"`
}

// Database a database resource.
type Database struct {
	autorest.Response `json:"-"`
	// Sku - The database SKU.
	//
	// The list of SKUs may vary by region and support offer. To determine the SKUs (including the SKU name, tier/edition, family, and capacity) that are available to your subscription in an Azure region, use the `Capabilities_ListByLocation` REST API or one of the following commands:
	//
	// ```azurecli
	// az sql db list-editions -l <location> -o table
	// ````
	//
	// ```powershell
	// Get-AzSqlServerServiceObjective -Location <location>
	// ````
	Sku *Sku `json:"sku,omitempty"`
	// Kind - READ-ONLY; Kind of database. This is metadata used for the Azure portal experience.
	Kind *string `json:"kind,omitempty"`
	// ManagedBy - READ-ONLY; Resource that manages the database.
	ManagedBy *string `json:"managedBy,omitempty"`
	// DatabaseProperties - Resource properties.
	*DatabaseProperties `json:"properties,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Database.
func (d Database) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if d.Sku != nil {
		objectMap["sku"] = d.Sku
	}
	if d.DatabaseProperties != nil {
		objectMap["properties"] = d.DatabaseProperties
	}
	if d.Location != nil {
		objectMap["location"] = d.Location
	}
	if d.Tags != nil {
		objectMap["tags"] = d.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Database struct.
func (d *Database) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "sku":
			if v != nil {
				var sku Sku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				d.Sku = &sku
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				d.Kind = &kind
			}
		case "managedBy":
			if v != nil {
				var managedBy string
				err = json.Unmarshal(*v, &managedBy)
				if err != nil {
					return err
				}
				d.ManagedBy = &managedBy
			}
		case "properties":
			if v != nil {
				var databaseProperties DatabaseProperties
				err = json.Unmarshal(*v, &databaseProperties)
				if err != nil {
					return err
				}
				d.DatabaseProperties = &databaseProperties
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				d.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				d.Tags = tags
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				d.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				d.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				d.Type = &typeVar
			}
		}
	}

	return nil
}

// DatabaseAutomaticTuning database-level Automatic Tuning.
type DatabaseAutomaticTuning struct {
	autorest.Response `json:"-"`
	// DatabaseAutomaticTuningProperties - Resource properties.
	*DatabaseAutomaticTuningProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for DatabaseAutomaticTuning.
func (dat DatabaseAutomaticTuning) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dat.DatabaseAutomaticTuningProperties != nil {
		objectMap["properties"] = dat.DatabaseAutomaticTuningProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DatabaseAutomaticTuning struct.
func (dat *DatabaseAutomaticTuning) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var databaseAutomaticTuningProperties DatabaseAutomaticTuningProperties
				err = json.Unmarshal(*v, &databaseAutomaticTuningProperties)
				if err != nil {
					return err
				}
				dat.DatabaseAutomaticTuningProperties = &databaseAutomaticTuningProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				dat.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				dat.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				dat.Type = &typeVar
			}
		}
	}

	return nil
}

// DatabaseAutomaticTuningProperties database-level Automatic Tuning properties.
type DatabaseAutomaticTuningProperties struct {
	// DesiredState - Automatic tuning desired state. Possible values include: 'Inherit', 'Custom', 'Auto', 'Unspecified'
	DesiredState AutomaticTuningMode `json:"desiredState,omitempty"`
	// ActualState - READ-ONLY; Automatic tuning actual state. Possible values include: 'Inherit', 'Custom', 'Auto', 'Unspecified'
	ActualState AutomaticTuningMode `json:"actualState,omitempty"`
	// Options - Automatic tuning options definition.
	Options map[string]*AutomaticTuningOptions `json:"options"`
}

// MarshalJSON is the custom marshaler for DatabaseAutomaticTuningProperties.
func (datp DatabaseAutomaticTuningProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if datp.DesiredState != "" {
		objectMap["desiredState"] = datp.DesiredState
	}
	if datp.Options != nil {
		objectMap["options"] = datp.Options
	}
	return json.Marshal(objectMap)
}

// DatabaseBlobAuditingPolicy a database blob auditing policy.
type DatabaseBlobAuditingPolicy struct {
	autorest.Response `json:"-"`
	// Kind - READ-ONLY; Resource kind.
	Kind *string `json:"kind,omitempty"`
	// DatabaseBlobAuditingPolicyProperties - Resource properties.
	*DatabaseBlobAuditingPolicyProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for DatabaseBlobAuditingPolicy.
func (dbap DatabaseBlobAuditingPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dbap.DatabaseBlobAuditingPolicyProperties != nil {
		objectMap["properties"] = dbap.DatabaseBlobAuditingPolicyProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DatabaseBlobAuditingPolicy struct.
func (dbap *DatabaseBlobAuditingPolicy) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				dbap.Kind = &kind
			}
		case "properties":
			if v != nil {
				var databaseBlobAuditingPolicyProperties DatabaseBlobAuditingPolicyProperties
				err = json.Unmarshal(*v, &databaseBlobAuditingPolicyProperties)
				if err != nil {
					return err
				}
				dbap.DatabaseBlobAuditingPolicyProperties = &databaseBlobAuditingPolicyProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				dbap.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				dbap.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				dbap.Type = &typeVar
			}
		}
	}

	return nil
}

// DatabaseBlobAuditingPolicyListResult a list of database auditing settings.
type DatabaseBlobAuditingPolicyListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]DatabaseBlobAuditingPolicy `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// DatabaseBlobAuditingPolicyListResultIterator provides access to a complete listing of
// DatabaseBlobAuditingPolicy values.
type DatabaseBlobAuditingPolicyListResultIterator struct {
	i    int
	page DatabaseBlobAuditingPolicyListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *DatabaseBlobAuditingPolicyListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DatabaseBlobAuditingPolicyListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *DatabaseBlobAuditingPolicyListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter DatabaseBlobAuditingPolicyListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter DatabaseBlobAuditingPolicyListResultIterator) Response() DatabaseBlobAuditingPolicyListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter DatabaseBlobAuditingPolicyListResultIterator) Value() DatabaseBlobAuditingPolicy {
	if !iter.page.NotDone() {
		return DatabaseBlobAuditingPolicy{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the DatabaseBlobAuditingPolicyListResultIterator type.
func NewDatabaseBlobAuditingPolicyListResultIterator(page DatabaseBlobAuditingPolicyListResultPage) DatabaseBlobAuditingPolicyListResultIterator {
	return DatabaseBlobAuditingPolicyListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (dbaplr DatabaseBlobAuditingPolicyListResult) IsEmpty() bool {
	return dbaplr.Value == nil || len(*dbaplr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (dbaplr DatabaseBlobAuditingPolicyListResult) hasNextLink() bool {
	return dbaplr.NextLink != nil && len(*dbaplr.NextLink) != 0
}

// databaseBlobAuditingPolicyListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (dbaplr DatabaseBlobAuditingPolicyListResult) databaseBlobAuditingPolicyListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !dbaplr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(dbaplr.NextLink)))
}

// DatabaseBlobAuditingPolicyListResultPage contains a page of DatabaseBlobAuditingPolicy values.
type DatabaseBlobAuditingPolicyListResultPage struct {
	fn     func(context.Context, DatabaseBlobAuditingPolicyListResult) (DatabaseBlobAuditingPolicyListResult, error)
	dbaplr DatabaseBlobAuditingPolicyListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *DatabaseBlobAuditingPolicyListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DatabaseBlobAuditingPolicyListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.dbaplr)
		if err != nil {
			return err
		}
		page.dbaplr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *DatabaseBlobAuditingPolicyListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page DatabaseBlobAuditingPolicyListResultPage) NotDone() bool {
	return !page.dbaplr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page DatabaseBlobAuditingPolicyListResultPage) Response() DatabaseBlobAuditingPolicyListResult {
	return page.dbaplr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page DatabaseBlobAuditingPolicyListResultPage) Values() []DatabaseBlobAuditingPolicy {
	if page.dbaplr.IsEmpty() {
		return nil
	}
	return *page.dbaplr.Value
}

// Creates a new instance of the DatabaseBlobAuditingPolicyListResultPage type.
func NewDatabaseBlobAuditingPolicyListResultPage(getNextPage func(context.Context, DatabaseBlobAuditingPolicyListResult) (DatabaseBlobAuditingPolicyListResult, error)) DatabaseBlobAuditingPolicyListResultPage {
	return DatabaseBlobAuditingPolicyListResultPage{fn: getNextPage}
}

// DatabaseBlobAuditingPolicyProperties properties of a database blob auditing policy.
type DatabaseBlobAuditingPolicyProperties struct {
	// State - Specifies the state of the policy. If state is Enabled, storageEndpoint or isAzureMonitorTargetEnabled are required. Possible values include: 'BlobAuditingPolicyStateEnabled', 'BlobAuditingPolicyStateDisabled'
	State BlobAuditingPolicyState `json:"state,omitempty"`
	// StorageEndpoint - Specifies the blob storage endpoint (e.g. https://MyAccount.blob.core.windows.net). If state is Enabled, storageEndpoint or isAzureMonitorTargetEnabled is required.
	StorageEndpoint *string `json:"storageEndpoint,omitempty"`
	// StorageAccountAccessKey - Specifies the identifier key of the auditing storage account.
	// If state is Enabled and storageEndpoint is specified, not specifying the storageAccountAccessKey will use SQL server system-assigned managed identity to access the storage.
	// Prerequisites for using managed identity authentication:
	// 1. Assign SQL Server a system-assigned managed identity in Azure Active Directory (AAD).
	// 2. Grant SQL Server identity access to the storage account by adding 'Storage Blob Data Contributor' RBAC role to the server identity.
	// For more information, see [Auditing to storage using Managed Identity authentication](https://go.microsoft.com/fwlink/?linkid=2114355)
	StorageAccountAccessKey *string `json:"storageAccountAccessKey,omitempty"`
	// RetentionDays - Specifies the number of days to keep in the audit logs in the storage account.
	RetentionDays *int32 `json:"retentionDays,omitempty"`
	// AuditActionsAndGroups - Specifies the Actions-Groups and Actions to audit.
	//
	// The recommended set of action groups to use is the following combination - this will audit all the queries and stored procedures executed against the database, as well as successful and failed logins:
	//
	// BATCH_COMPLETED_GROUP,
	// SUCCESSFUL_DATABASE_AUTHENTICATION_GROUP,
	// FAILED_DATABASE_AUTHENTICATION_GROUP.
	//
	// This above combination is also the set that is configured by default when enabling auditing from the Azure portal.
	//
	// The supported action groups to audit are (note: choose only specific groups that cover your auditing needs. Using unnecessary groups could lead to very large quantities of audit records):
	//
	// APPLICATION_ROLE_CHANGE_PASSWORD_GROUP
	// BACKUP_RESTORE_GROUP
	// DATABASE_LOGOUT_GROUP
	// DATABASE_OBJECT_CHANGE_GROUP
	// DATABASE_OBJECT_OWNERSHIP_CHANGE_GROUP
	// DATABASE_OBJECT_PERMISSION_CHANGE_GROUP
	// DATABASE_OPERATION_GROUP
	// DATABASE_PERMISSION_CHANGE_GROUP
	// DATABASE_PRINCIPAL_CHANGE_GROUP
	// DATABASE_PRINCIPAL_IMPERSONATION_GROUP
	// DATABASE_ROLE_MEMBER_CHANGE_GROUP
	// FAILED_DATABASE_AUTHENTICATION_GROUP
	// SCHEMA_OBJECT_ACCESS_GROUP
	// SCHEMA_OBJECT_CHANGE_GROUP
	// SCHEMA_OBJECT_OWNERSHIP_CHANGE_GROUP
	// SCHEMA_OBJECT_PERMISSION_CHANGE_GROUP
	// SUCCESSFUL_DATABASE_AUTHENTICATION_GROUP
	// USER_CHANGE_PASSWORD_GROUP
	// BATCH_STARTED_GROUP
	// BATCH_COMPLETED_GROUP
	//
	// These are groups that cover all sql statements and stored procedures executed against the database, and should not be used in combination with other groups as this will result in duplicate audit logs.
	//
	// For more information, see [Database-Level Audit Action Groups](https://docs.microsoft.com/en-us/sql/relational-databases/security/auditing/sql-server-audit-action-groups-and-actions#database-level-audit-action-groups).
	//
	// For Database auditing policy, specific Actions can also be specified (note that Actions cannot be specified for Server auditing policy). The supported actions to audit are:
	// SELECT
	// UPDATE
	// INSERT
	// DELETE
	// EXECUTE
	// RECEIVE
	// REFERENCES
	//
	// The general form for defining an action to be audited is:
	// {action} ON {object} BY {principal}
	//
	// Note that <object> in the above format can refer to an object like a table, view, or stored procedure, or an entire database or schema. For the latter cases, the forms DATABASE::{db_name} and SCHEMA::{schema_name} are used, respectively.
	//
	// For example:
	// SELECT on dbo.myTable by public
	// SELECT on DATABASE::myDatabase by public
	// SELECT on SCHEMA::mySchema by public
	//
	// For more information, see [Database-Level Audit Actions](https://docs.microsoft.com/en-us/sql/relational-databases/security/auditing/sql-server-audit-action-groups-and-actions#database-level-audit-actions)
	AuditActionsAndGroups *[]string `json:"auditActionsAndGroups,omitempty"`
	// StorageAccountSubscriptionID - Specifies the blob storage subscription Id.
	StorageAccountSubscriptionID *uuid.UUID `json:"storageAccountSubscriptionId,omitempty"`
	// IsStorageSecondaryKeyInUse - Specifies whether storageAccountAccessKey value is the storage's secondary key.
	IsStorageSecondaryKeyInUse *bool `json:"isStorageSecondaryKeyInUse,omitempty"`
	// IsAzureMonitorTargetEnabled - Specifies whether audit events are sent to Azure Monitor.
	// In order to send the events to Azure Monitor, specify 'state' as 'Enabled' and 'isAzureMonitorTargetEnabled' as true.
	//
	// When using REST API to configure auditing, Diagnostic Settings with 'SQLSecurityAuditEvents' diagnostic logs category on the database should be also created.
	// Note that for server level audit you should use the 'master' database as {databaseName}.
	//
	// Diagnostic Settings URI format:
	// PUT https://management.azure.com/subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/providers/microsoft.insights/diagnosticSettings/{settingsName}?api-version=2017-05-01-preview
	//
	// For more information, see [Diagnostic Settings REST API](https://go.microsoft.com/fwlink/?linkid=2033207)
	// or [Diagnostic Settings PowerShell](https://go.microsoft.com/fwlink/?linkid=2033043)
	IsAzureMonitorTargetEnabled *bool `json:"isAzureMonitorTargetEnabled,omitempty"`
	// QueueDelayMs - Specifies the amount of time in milliseconds that can elapse before audit actions are forced to be processed.
	// The default minimum value is 1000 (1 second). The maximum is 2,147,483,647.
	QueueDelayMs *int32 `json:"queueDelayMs,omitempty"`
}

// DatabaseListResult a list of databases.
type DatabaseListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]Database `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// DatabaseListResultIterator provides access to a complete listing of Database values.
type DatabaseListResultIterator struct {
	i    int
	page DatabaseListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *DatabaseListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DatabaseListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *DatabaseListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter DatabaseListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter DatabaseListResultIterator) Response() DatabaseListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter DatabaseListResultIterator) Value() Database {
	if !iter.page.NotDone() {
		return Database{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the DatabaseListResultIterator type.
func NewDatabaseListResultIterator(page DatabaseListResultPage) DatabaseListResultIterator {
	return DatabaseListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (dlr DatabaseListResult) IsEmpty() bool {
	return dlr.Value == nil || len(*dlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (dlr DatabaseListResult) hasNextLink() bool {
	return dlr.NextLink != nil && len(*dlr.NextLink) != 0
}

// databaseListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (dlr DatabaseListResult) databaseListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !dlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(dlr.NextLink)))
}

// DatabaseListResultPage contains a page of Database values.
type DatabaseListResultPage struct {
	fn  func(context.Context, DatabaseListResult) (DatabaseListResult, error)
	dlr DatabaseListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *DatabaseListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DatabaseListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.dlr)
		if err != nil {
			return err
		}
		page.dlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *DatabaseListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page DatabaseListResultPage) NotDone() bool {
	return !page.dlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page DatabaseListResultPage) Response() DatabaseListResult {
	return page.dlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page DatabaseListResultPage) Values() []Database {
	if page.dlr.IsEmpty() {
		return nil
	}
	return *page.dlr.Value
}

// Creates a new instance of the DatabaseListResultPage type.
func NewDatabaseListResultPage(getNextPage func(context.Context, DatabaseListResult) (DatabaseListResult, error)) DatabaseListResultPage {
	return DatabaseListResultPage{fn: getNextPage}
}

// DatabaseOperation a database operation.
type DatabaseOperation struct {
	// DatabaseOperationProperties - Resource properties.
	*DatabaseOperationProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for DatabaseOperation.
func (do DatabaseOperation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if do.DatabaseOperationProperties != nil {
		objectMap["properties"] = do.DatabaseOperationProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DatabaseOperation struct.
func (do *DatabaseOperation) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var databaseOperationProperties DatabaseOperationProperties
				err = json.Unmarshal(*v, &databaseOperationProperties)
				if err != nil {
					return err
				}
				do.DatabaseOperationProperties = &databaseOperationProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				do.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				do.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				do.Type = &typeVar
			}
		}
	}

	return nil
}

// DatabaseOperationListResult the response to a list database operations request
type DatabaseOperationListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]DatabaseOperation `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// DatabaseOperationListResultIterator provides access to a complete listing of DatabaseOperation values.
type DatabaseOperationListResultIterator struct {
	i    int
	page DatabaseOperationListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *DatabaseOperationListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DatabaseOperationListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *DatabaseOperationListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter DatabaseOperationListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter DatabaseOperationListResultIterator) Response() DatabaseOperationListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter DatabaseOperationListResultIterator) Value() DatabaseOperation {
	if !iter.page.NotDone() {
		return DatabaseOperation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the DatabaseOperationListResultIterator type.
func NewDatabaseOperationListResultIterator(page DatabaseOperationListResultPage) DatabaseOperationListResultIterator {
	return DatabaseOperationListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (dolr DatabaseOperationListResult) IsEmpty() bool {
	return dolr.Value == nil || len(*dolr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (dolr DatabaseOperationListResult) hasNextLink() bool {
	return dolr.NextLink != nil && len(*dolr.NextLink) != 0
}

// databaseOperationListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (dolr DatabaseOperationListResult) databaseOperationListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !dolr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(dolr.NextLink)))
}

// DatabaseOperationListResultPage contains a page of DatabaseOperation values.
type DatabaseOperationListResultPage struct {
	fn   func(context.Context, DatabaseOperationListResult) (DatabaseOperationListResult, error)
	dolr DatabaseOperationListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *DatabaseOperationListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DatabaseOperationListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.dolr)
		if err != nil {
			return err
		}
		page.dolr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *DatabaseOperationListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page DatabaseOperationListResultPage) NotDone() bool {
	return !page.dolr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page DatabaseOperationListResultPage) Response() DatabaseOperationListResult {
	return page.dolr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page DatabaseOperationListResultPage) Values() []DatabaseOperation {
	if page.dolr.IsEmpty() {
		return nil
	}
	return *page.dolr.Value
}

// Creates a new instance of the DatabaseOperationListResultPage type.
func NewDatabaseOperationListResultPage(getNextPage func(context.Context, DatabaseOperationListResult) (DatabaseOperationListResult, error)) DatabaseOperationListResultPage {
	return DatabaseOperationListResultPage{fn: getNextPage}
}

// DatabaseOperationProperties the properties of a database operation.
type DatabaseOperationProperties struct {
	// DatabaseName - READ-ONLY; The name of the database the operation is being performed on.
	DatabaseName *string `json:"databaseName,omitempty"`
	// Operation - READ-ONLY; The name of operation.
	Operation *string `json:"operation,omitempty"`
	// OperationFriendlyName - READ-ONLY; The friendly name of operation.
	OperationFriendlyName *string `json:"operationFriendlyName,omitempty"`
	// PercentComplete - READ-ONLY; The percentage of the operation completed.
	PercentComplete *int32 `json:"percentComplete,omitempty"`
	// ServerName - READ-ONLY; The name of the server.
	ServerName *string `json:"serverName,omitempty"`
	// StartTime - READ-ONLY; The operation start time.
	StartTime *date.Time `json:"startTime,omitempty"`
	// State - READ-ONLY; The operation state. Possible values include: 'ManagementOperationStatePending', 'ManagementOperationStateInProgress', 'ManagementOperationStateSucceeded', 'ManagementOperationStateFailed', 'ManagementOperationStateCancelInProgress', 'ManagementOperationStateCancelled'
	State ManagementOperationState `json:"state,omitempty"`
	// ErrorCode - READ-ONLY; The operation error code.
	ErrorCode *int32 `json:"errorCode,omitempty"`
	// ErrorDescription - READ-ONLY; The operation error description.
	ErrorDescription *string `json:"errorDescription,omitempty"`
	// ErrorSeverity - READ-ONLY; The operation error severity.
	ErrorSeverity *int32 `json:"errorSeverity,omitempty"`
	// IsUserError - READ-ONLY; Whether or not the error is a user error.
	IsUserError *bool `json:"isUserError,omitempty"`
	// EstimatedCompletionTime - READ-ONLY; The estimated completion time of the operation.
	EstimatedCompletionTime *date.Time `json:"estimatedCompletionTime,omitempty"`
	// Description - READ-ONLY; The operation description.
	Description *string `json:"description,omitempty"`
	// IsCancellable - READ-ONLY; Whether the operation can be cancelled.
	IsCancellable *bool `json:"isCancellable,omitempty"`
}

// DatabaseProperties the database's properties.
type DatabaseProperties struct {
	// CreateMode - Specifies the mode of database creation.
	//
	// Default: regular database creation.
	//
	// Copy: creates a database as a copy of an existing database. sourceDatabaseId must be specified as the resource ID of the source database.
	//
	// Secondary: creates a database as a secondary replica of an existing database. sourceDatabaseId must be specified as the resource ID of the existing primary database.
	//
	// PointInTimeRestore: Creates a database by restoring a point in time backup of an existing database. sourceDatabaseId must be specified as the resource ID of the existing database, and restorePointInTime must be specified.
	//
	// Recovery: Creates a database by restoring a geo-replicated backup. sourceDatabaseId must be specified as the recoverable database resource ID to restore.
	//
	// Restore: Creates a database by restoring a backup of a deleted database. sourceDatabaseId must be specified. If sourceDatabaseId is the database's original resource ID, then sourceDatabaseDeletionDate must be specified. Otherwise sourceDatabaseId must be the restorable dropped database resource ID and sourceDatabaseDeletionDate is ignored. restorePointInTime may also be specified to restore from an earlier point in time.
	//
	// RestoreLongTermRetentionBackup: Creates a database by restoring from a long term retention vault. recoveryServicesRecoveryPointResourceId must be specified as the recovery point resource ID.
	//
	// Copy, Secondary, and RestoreLongTermRetentionBackup are not supported for DataWarehouse edition. Possible values include: 'CreateModeDefault', 'CreateModeCopy', 'CreateModeSecondary', 'CreateModePointInTimeRestore', 'CreateModeRestore', 'CreateModeRecovery', 'CreateModeRestoreExternalBackup', 'CreateModeRestoreExternalBackupSecondary', 'CreateModeRestoreLongTermRetentionBackup', 'CreateModeOnlineSecondary'
	CreateMode CreateMode `json:"createMode,omitempty"`
	// Collation - The collation of the database.
	Collation *string `json:"collation,omitempty"`
	// MaxSizeBytes - The max size of the database expressed in bytes.
	MaxSizeBytes *int64 `json:"maxSizeBytes,omitempty"`
	// SampleName - The name of the sample schema to apply when creating this database. Possible values include: 'AdventureWorksLT', 'WideWorldImportersStd', 'WideWorldImportersFull'
	SampleName SampleName `json:"sampleName,omitempty"`
	// ElasticPoolID - The resource identifier of the elastic pool containing this database.
	ElasticPoolID *string `json:"elasticPoolId,omitempty"`
	// SourceDatabaseID - The resource identifier of the source database associated with create operation of this database.
	SourceDatabaseID *string `json:"sourceDatabaseId,omitempty"`
	// Status - READ-ONLY; The status of the database. Possible values include: 'DatabaseStatusOnline', 'DatabaseStatusRestoring', 'DatabaseStatusRecoveryPending', 'DatabaseStatusRecovering', 'DatabaseStatusSuspect', 'DatabaseStatusOffline', 'DatabaseStatusStandby', 'DatabaseStatusShutdown', 'DatabaseStatusEmergencyMode', 'DatabaseStatusAutoClosed', 'DatabaseStatusCopying', 'DatabaseStatusCreating', 'DatabaseStatusInaccessible', 'DatabaseStatusOfflineSecondary', 'DatabaseStatusPausing', 'DatabaseStatusPaused', 'DatabaseStatusResuming', 'DatabaseStatusScaling', 'DatabaseStatusOfflineChangingDwPerformanceTiers', 'DatabaseStatusOnlineChangingDwPerformanceTiers', 'DatabaseStatusDisabled'
	Status DatabaseStatus `json:"status,omitempty"`
	// DatabaseID - READ-ONLY; The ID of the database.
	DatabaseID *uuid.UUID `json:"databaseId,omitempty"`
	// CreationDate - READ-ONLY; The creation date of the database (ISO8601 format).
	CreationDate *date.Time `json:"creationDate,omitempty"`
	// CurrentServiceObjectiveName - READ-ONLY; The current service level objective name of the database.
	CurrentServiceObjectiveName *string `json:"currentServiceObjectiveName,omitempty"`
	// RequestedServiceObjectiveName - READ-ONLY; The requested service level objective name of the database.
	RequestedServiceObjectiveName *string `json:"requestedServiceObjectiveName,omitempty"`
	// DefaultSecondaryLocation - READ-ONLY; The default secondary region for this database.
	DefaultSecondaryLocation *string `json:"defaultSecondaryLocation,omitempty"`
	// FailoverGroupID - READ-ONLY; Failover Group resource identifier that this database belongs to.
	FailoverGroupID *string `json:"failoverGroupId,omitempty"`
	// RestorePointInTime - Specifies the point in time (ISO8601 format) of the source database that will be restored to create the new database.
	RestorePointInTime *date.Time `json:"restorePointInTime,omitempty"`
	// SourceDatabaseDeletionDate - Specifies the time that the database was deleted.
	SourceDatabaseDeletionDate *date.Time `json:"sourceDatabaseDeletionDate,omitempty"`
	// RecoveryServicesRecoveryPointID - The resource identifier of the recovery point associated with create operation of this database.
	RecoveryServicesRecoveryPointID *string `json:"recoveryServicesRecoveryPointId,omitempty"`
	// LongTermRetentionBackupResourceID - The resource identifier of the long term retention backup associated with create operation of this database.
	LongTermRetentionBackupResourceID *string `json:"longTermRetentionBackupResourceId,omitempty"`
	// RecoverableDatabaseID - The resource identifier of the recoverable database associated with create operation of this database.
	RecoverableDatabaseID *string `json:"recoverableDatabaseId,omitempty"`
	// RestorableDroppedDatabaseID - The resource identifier of the restorable dropped database associated with create operation of this database.
	RestorableDroppedDatabaseID *string `json:"restorableDroppedDatabaseId,omitempty"`
	// CatalogCollation - Collation of the metadata catalog. Possible values include: 'DATABASEDEFAULT', 'SQLLatin1GeneralCP1CIAS'
	CatalogCollation CatalogCollationType `json:"catalogCollation,omitempty"`
	// ZoneRedundant - Whether or not this database is zone redundant, which means the replicas of this database will be spread across multiple availability zones.
	ZoneRedundant *bool `json:"zoneRedundant,omitempty"`
	// LicenseType - The license type to apply for this database. `LicenseIncluded` if you need a license, or `BasePrice` if you have a license and are eligible for the Azure Hybrid Benefit. Possible values include: 'LicenseIncluded', 'BasePrice'
	LicenseType DatabaseLicenseType `json:"licenseType,omitempty"`
	// MaxLogSizeBytes - READ-ONLY; The max log size for this database.
	MaxLogSizeBytes *int64 `json:"maxLogSizeBytes,omitempty"`
	// EarliestRestoreDate - READ-ONLY; This records the earliest start date and time that restore is available for this database (ISO8601 format).
	EarliestRestoreDate *date.Time `json:"earliestRestoreDate,omitempty"`
	// ReadScale - If enabled, connections that have application intent set to readonly in their connection string may be routed to a readonly secondary replica. This property is only settable for Premium and Business Critical databases. Possible values include: 'DatabaseReadScaleEnabled', 'DatabaseReadScaleDisabled'
	ReadScale DatabaseReadScale `json:"readScale,omitempty"`
	// ReadReplicaCount - The number of readonly secondary replicas associated with the database to which readonly application intent connections may be routed. This property is only settable for Hyperscale edition databases.
	ReadReplicaCount *int32 `json:"readReplicaCount,omitempty"`
	// CurrentSku - READ-ONLY; The name and tier of the SKU.
	CurrentSku *Sku `json:"currentSku,omitempty"`
	// AutoPauseDelay - Time in minutes after which database is automatically paused. A value of -1 means that automatic pause is disabled
	AutoPauseDelay *int32 `json:"autoPauseDelay,omitempty"`
	// MinCapacity - Minimal capacity that database will always have allocated, if not paused
	MinCapacity *float64 `json:"minCapacity,omitempty"`
	// PausedDate - READ-ONLY; The date when database was paused by user configuration or action (ISO8601 format). Null if the database is ready.
	PausedDate *date.Time `json:"pausedDate,omitempty"`
	// ResumedDate - READ-ONLY; The date when database was resumed by user action or database login (ISO8601 format). Null if the database is paused.
	ResumedDate *date.Time `json:"resumedDate,omitempty"`
}

// MarshalJSON is the custom marshaler for DatabaseProperties.
func (dp DatabaseProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dp.CreateMode != "" {
		objectMap["createMode"] = dp.CreateMode
	}
	if dp.Collation != nil {
		objectMap["collation"] = dp.Collation
	}
	if dp.MaxSizeBytes != nil {
		objectMap["maxSizeBytes"] = dp.MaxSizeBytes
	}
	if dp.SampleName != "" {
		objectMap["sampleName"] = dp.SampleName
	}
	if dp.ElasticPoolID != nil {
		objectMap["elasticPoolId"] = dp.ElasticPoolID
	}
	if dp.SourceDatabaseID != nil {
		objectMap["sourceDatabaseId"] = dp.SourceDatabaseID
	}
	if dp.RestorePointInTime != nil {
		objectMap["restorePointInTime"] = dp.RestorePointInTime
	}
	if dp.SourceDatabaseDeletionDate != nil {
		objectMap["sourceDatabaseDeletionDate"] = dp.SourceDatabaseDeletionDate
	}
	if dp.RecoveryServicesRecoveryPointID != nil {
		objectMap["recoveryServicesRecoveryPointId"] = dp.RecoveryServicesRecoveryPointID
	}
	if dp.LongTermRetentionBackupResourceID != nil {
		objectMap["longTermRetentionBackupResourceId"] = dp.LongTermRetentionBackupResourceID
	}
	if dp.RecoverableDatabaseID != nil {
		objectMap["recoverableDatabaseId"] = dp.RecoverableDatabaseID
	}
	if dp.RestorableDroppedDatabaseID != nil {
		objectMap["restorableDroppedDatabaseId"] = dp.RestorableDroppedDatabaseID
	}
	if dp.CatalogCollation != "" {
		objectMap["catalogCollation"] = dp.CatalogCollation
	}
	if dp.ZoneRedundant != nil {
		objectMap["zoneRedundant"] = dp.ZoneRedundant
	}
	if dp.LicenseType != "" {
		objectMap["licenseType"] = dp.LicenseType
	}
	if dp.ReadScale != "" {
		objectMap["readScale"] = dp.ReadScale
	}
	if dp.ReadReplicaCount != nil {
		objectMap["readReplicaCount"] = dp.ReadReplicaCount
	}
	if dp.AutoPauseDelay != nil {
		objectMap["autoPauseDelay"] = dp.AutoPauseDelay
	}
	if dp.MinCapacity != nil {
		objectMap["minCapacity"] = dp.MinCapacity
	}
	return json.Marshal(objectMap)
}

// DatabasesCreateImportOperationFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type DatabasesCreateImportOperationFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *DatabasesCreateImportOperationFuture) Result(client DatabasesClient) (ier ImportExportResponse, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.DatabasesCreateImportOperationFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.DatabasesCreateImportOperationFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if ier.Response.Response, err = future.GetResult(sender); err == nil && ier.Response.Response.StatusCode != http.StatusNoContent {
		ier, err = client.CreateImportOperationResponder(ier.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.DatabasesCreateImportOperationFuture", "Result", ier.Response.Response, "Failure responding to request")
		}
	}
	return
}

// DatabasesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type DatabasesCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *DatabasesCreateOrUpdateFuture) Result(client DatabasesClient) (d Database, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.DatabasesCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.DatabasesCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if d.Response.Response, err = future.GetResult(sender); err == nil && d.Response.Response.StatusCode != http.StatusNoContent {
		d, err = client.CreateOrUpdateResponder(d.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.DatabasesCreateOrUpdateFuture", "Result", d.Response.Response, "Failure responding to request")
		}
	}
	return
}

// DatabasesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type DatabasesDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *DatabasesDeleteFuture) Result(client DatabasesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.DatabasesDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.DatabasesDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// DatabaseSecurityAlertPolicy contains information about a database Threat Detection policy.
type DatabaseSecurityAlertPolicy struct {
	autorest.Response `json:"-"`
	// Location - The geo-location where the resource lives
	Location *string `json:"location,omitempty"`
	// Kind - READ-ONLY; Resource kind.
	Kind *string `json:"kind,omitempty"`
	// DatabaseSecurityAlertPolicyProperties - Properties of the security alert policy.
	*DatabaseSecurityAlertPolicyProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for DatabaseSecurityAlertPolicy.
func (dsap DatabaseSecurityAlertPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dsap.Location != nil {
		objectMap["location"] = dsap.Location
	}
	if dsap.DatabaseSecurityAlertPolicyProperties != nil {
		objectMap["properties"] = dsap.DatabaseSecurityAlertPolicyProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DatabaseSecurityAlertPolicy struct.
func (dsap *DatabaseSecurityAlertPolicy) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				dsap.Location = &location
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				dsap.Kind = &kind
			}
		case "properties":
			if v != nil {
				var databaseSecurityAlertPolicyProperties DatabaseSecurityAlertPolicyProperties
				err = json.Unmarshal(*v, &databaseSecurityAlertPolicyProperties)
				if err != nil {
					return err
				}
				dsap.DatabaseSecurityAlertPolicyProperties = &databaseSecurityAlertPolicyProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				dsap.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				dsap.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				dsap.Type = &typeVar
			}
		}
	}

	return nil
}

// DatabaseSecurityAlertPolicyProperties properties for a database Threat Detection policy.
type DatabaseSecurityAlertPolicyProperties struct {
	// State - Specifies the state of the policy. If state is Enabled, storageEndpoint and storageAccountAccessKey are required. Possible values include: 'SecurityAlertPolicyStateNew', 'SecurityAlertPolicyStateEnabled', 'SecurityAlertPolicyStateDisabled'
	State SecurityAlertPolicyState `json:"state,omitempty"`
	// DisabledAlerts - Specifies the semicolon-separated list of alerts that are disabled, or empty string to disable no alerts. Possible values: Sql_Injection; Sql_Injection_Vulnerability; Access_Anomaly; Data_Exfiltration; Unsafe_Action.
	DisabledAlerts *string `json:"disabledAlerts,omitempty"`
	// EmailAddresses - Specifies the semicolon-separated list of e-mail addresses to which the alert is sent.
	EmailAddresses *string `json:"emailAddresses,omitempty"`
	// EmailAccountAdmins - Specifies that the alert is sent to the account administrators. Possible values include: 'SecurityAlertPolicyEmailAccountAdminsEnabled', 'SecurityAlertPolicyEmailAccountAdminsDisabled'
	EmailAccountAdmins SecurityAlertPolicyEmailAccountAdmins `json:"emailAccountAdmins,omitempty"`
	// StorageEndpoint - Specifies the blob storage endpoint (e.g. https://MyAccount.blob.core.windows.net). This blob storage will hold all Threat Detection audit logs. If state is Enabled, storageEndpoint is required.
	StorageEndpoint *string `json:"storageEndpoint,omitempty"`
	// StorageAccountAccessKey - Specifies the identifier key of the Threat Detection audit storage account. If state is Enabled, storageAccountAccessKey is required.
	StorageAccountAccessKey *string `json:"storageAccountAccessKey,omitempty"`
	// RetentionDays - Specifies the number of days to keep in the Threat Detection audit logs.
	RetentionDays *int32 `json:"retentionDays,omitempty"`
	// UseServerDefault - Specifies whether to use the default server policy. Possible values include: 'SecurityAlertPolicyUseServerDefaultEnabled', 'SecurityAlertPolicyUseServerDefaultDisabled'
	UseServerDefault SecurityAlertPolicyUseServerDefault `json:"useServerDefault,omitempty"`
}

// DatabasesExportFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type DatabasesExportFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *DatabasesExportFuture) Result(client DatabasesClient) (ier ImportExportResponse, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.DatabasesExportFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.DatabasesExportFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if ier.Response.Response, err = future.GetResult(sender); err == nil && ier.Response.Response.StatusCode != http.StatusNoContent {
		ier, err = client.ExportResponder(ier.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.DatabasesExportFuture", "Result", ier.Response.Response, "Failure responding to request")
		}
	}
	return
}

// DatabasesFailoverFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type DatabasesFailoverFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *DatabasesFailoverFuture) Result(client DatabasesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.DatabasesFailoverFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.DatabasesFailoverFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// DatabasesImportFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type DatabasesImportFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *DatabasesImportFuture) Result(client DatabasesClient) (ier ImportExportResponse, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.DatabasesImportFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.DatabasesImportFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if ier.Response.Response, err = future.GetResult(sender); err == nil && ier.Response.Response.StatusCode != http.StatusNoContent {
		ier, err = client.ImportResponder(ier.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.DatabasesImportFuture", "Result", ier.Response.Response, "Failure responding to request")
		}
	}
	return
}

// DatabasesPauseFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type DatabasesPauseFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *DatabasesPauseFuture) Result(client DatabasesClient) (d Database, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.DatabasesPauseFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.DatabasesPauseFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if d.Response.Response, err = future.GetResult(sender); err == nil && d.Response.Response.StatusCode != http.StatusNoContent {
		d, err = client.PauseResponder(d.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.DatabasesPauseFuture", "Result", d.Response.Response, "Failure responding to request")
		}
	}
	return
}

// DatabasesResumeFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type DatabasesResumeFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *DatabasesResumeFuture) Result(client DatabasesClient) (d Database, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.DatabasesResumeFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.DatabasesResumeFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if d.Response.Response, err = future.GetResult(sender); err == nil && d.Response.Response.StatusCode != http.StatusNoContent {
		d, err = client.ResumeResponder(d.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.DatabasesResumeFuture", "Result", d.Response.Response, "Failure responding to request")
		}
	}
	return
}

// DatabasesUpdateFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type DatabasesUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *DatabasesUpdateFuture) Result(client DatabasesClient) (d Database, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.DatabasesUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.DatabasesUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if d.Response.Response, err = future.GetResult(sender); err == nil && d.Response.Response.StatusCode != http.StatusNoContent {
		d, err = client.UpdateResponder(d.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.DatabasesUpdateFuture", "Result", d.Response.Response, "Failure responding to request")
		}
	}
	return
}

// DatabasesUpgradeDataWarehouseFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type DatabasesUpgradeDataWarehouseFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *DatabasesUpgradeDataWarehouseFuture) Result(client DatabasesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.DatabasesUpgradeDataWarehouseFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.DatabasesUpgradeDataWarehouseFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// DatabaseUpdate a database resource.
type DatabaseUpdate struct {
	// Sku - The name and tier of the SKU.
	Sku *Sku `json:"sku,omitempty"`
	// DatabaseProperties - Resource properties.
	*DatabaseProperties `json:"properties,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for DatabaseUpdate.
func (du DatabaseUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if du.Sku != nil {
		objectMap["sku"] = du.Sku
	}
	if du.DatabaseProperties != nil {
		objectMap["properties"] = du.DatabaseProperties
	}
	if du.Tags != nil {
		objectMap["tags"] = du.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DatabaseUpdate struct.
func (du *DatabaseUpdate) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "sku":
			if v != nil {
				var sku Sku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				du.Sku = &sku
			}
		case "properties":
			if v != nil {
				var databaseProperties DatabaseProperties
				err = json.Unmarshal(*v, &databaseProperties)
				if err != nil {
					return err
				}
				du.DatabaseProperties = &databaseProperties
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				du.Tags = tags
			}
		}
	}

	return nil
}

// DatabaseUsage the database usages.
type DatabaseUsage struct {
	// Name - READ-ONLY; The name of the usage metric.
	Name *string `json:"name,omitempty"`
	// ResourceName - READ-ONLY; The name of the resource.
	ResourceName *string `json:"resourceName,omitempty"`
	// DisplayName - READ-ONLY; The usage metric display name.
	DisplayName *string `json:"displayName,omitempty"`
	// CurrentValue - READ-ONLY; The current value of the usage metric.
	CurrentValue *float64 `json:"currentValue,omitempty"`
	// Limit - READ-ONLY; The current limit of the usage metric.
	Limit *float64 `json:"limit,omitempty"`
	// Unit - READ-ONLY; The units of the usage metric.
	Unit *string `json:"unit,omitempty"`
	// NextResetTime - READ-ONLY; The next reset time for the usage metric (ISO8601 format).
	NextResetTime *date.Time `json:"nextResetTime,omitempty"`
}

// DatabaseUsageListResult the response to a list database metrics request.
type DatabaseUsageListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of database usages for the database.
	Value *[]DatabaseUsage `json:"value,omitempty"`
}

// DatabaseVulnerabilityAssessment a database vulnerability assessment.
type DatabaseVulnerabilityAssessment struct {
	autorest.Response `json:"-"`
	// DatabaseVulnerabilityAssessmentProperties - Resource properties.
	*DatabaseVulnerabilityAssessmentProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for DatabaseVulnerabilityAssessment.
func (dva DatabaseVulnerabilityAssessment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dva.DatabaseVulnerabilityAssessmentProperties != nil {
		objectMap["properties"] = dva.DatabaseVulnerabilityAssessmentProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DatabaseVulnerabilityAssessment struct.
func (dva *DatabaseVulnerabilityAssessment) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var databaseVulnerabilityAssessmentProperties DatabaseVulnerabilityAssessmentProperties
				err = json.Unmarshal(*v, &databaseVulnerabilityAssessmentProperties)
				if err != nil {
					return err
				}
				dva.DatabaseVulnerabilityAssessmentProperties = &databaseVulnerabilityAssessmentProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				dva.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				dva.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				dva.Type = &typeVar
			}
		}
	}

	return nil
}

// DatabaseVulnerabilityAssessmentListResult a list of the database's vulnerability assessments.
type DatabaseVulnerabilityAssessmentListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]DatabaseVulnerabilityAssessment `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// DatabaseVulnerabilityAssessmentListResultIterator provides access to a complete listing of
// DatabaseVulnerabilityAssessment values.
type DatabaseVulnerabilityAssessmentListResultIterator struct {
	i    int
	page DatabaseVulnerabilityAssessmentListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *DatabaseVulnerabilityAssessmentListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DatabaseVulnerabilityAssessmentListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *DatabaseVulnerabilityAssessmentListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter DatabaseVulnerabilityAssessmentListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter DatabaseVulnerabilityAssessmentListResultIterator) Response() DatabaseVulnerabilityAssessmentListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter DatabaseVulnerabilityAssessmentListResultIterator) Value() DatabaseVulnerabilityAssessment {
	if !iter.page.NotDone() {
		return DatabaseVulnerabilityAssessment{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the DatabaseVulnerabilityAssessmentListResultIterator type.
func NewDatabaseVulnerabilityAssessmentListResultIterator(page DatabaseVulnerabilityAssessmentListResultPage) DatabaseVulnerabilityAssessmentListResultIterator {
	return DatabaseVulnerabilityAssessmentListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (dvalr DatabaseVulnerabilityAssessmentListResult) IsEmpty() bool {
	return dvalr.Value == nil || len(*dvalr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (dvalr DatabaseVulnerabilityAssessmentListResult) hasNextLink() bool {
	return dvalr.NextLink != nil && len(*dvalr.NextLink) != 0
}

// databaseVulnerabilityAssessmentListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (dvalr DatabaseVulnerabilityAssessmentListResult) databaseVulnerabilityAssessmentListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !dvalr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(dvalr.NextLink)))
}

// DatabaseVulnerabilityAssessmentListResultPage contains a page of DatabaseVulnerabilityAssessment values.
type DatabaseVulnerabilityAssessmentListResultPage struct {
	fn    func(context.Context, DatabaseVulnerabilityAssessmentListResult) (DatabaseVulnerabilityAssessmentListResult, error)
	dvalr DatabaseVulnerabilityAssessmentListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *DatabaseVulnerabilityAssessmentListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DatabaseVulnerabilityAssessmentListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.dvalr)
		if err != nil {
			return err
		}
		page.dvalr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *DatabaseVulnerabilityAssessmentListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page DatabaseVulnerabilityAssessmentListResultPage) NotDone() bool {
	return !page.dvalr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page DatabaseVulnerabilityAssessmentListResultPage) Response() DatabaseVulnerabilityAssessmentListResult {
	return page.dvalr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page DatabaseVulnerabilityAssessmentListResultPage) Values() []DatabaseVulnerabilityAssessment {
	if page.dvalr.IsEmpty() {
		return nil
	}
	return *page.dvalr.Value
}

// Creates a new instance of the DatabaseVulnerabilityAssessmentListResultPage type.
func NewDatabaseVulnerabilityAssessmentListResultPage(getNextPage func(context.Context, DatabaseVulnerabilityAssessmentListResult) (DatabaseVulnerabilityAssessmentListResult, error)) DatabaseVulnerabilityAssessmentListResultPage {
	return DatabaseVulnerabilityAssessmentListResultPage{fn: getNextPage}
}

// DatabaseVulnerabilityAssessmentProperties properties of a database Vulnerability Assessment.
type DatabaseVulnerabilityAssessmentProperties struct {
	// StorageContainerPath - A blob storage container path to hold the scan results (e.g. https://myStorage.blob.core.windows.net/VaScans/).  It is required if server level vulnerability assessment policy doesn't set
	StorageContainerPath *string `json:"storageContainerPath,omitempty"`
	// StorageContainerSasKey - A shared access signature (SAS Key) that has read and write access to the blob container specified in 'storageContainerPath' parameter. If 'storageAccountAccessKey' isn't specified, StorageContainerSasKey is required.
	StorageContainerSasKey *string `json:"storageContainerSasKey,omitempty"`
	// StorageAccountAccessKey - Specifies the identifier key of the storage account for vulnerability assessment scan results. If 'StorageContainerSasKey' isn't specified, storageAccountAccessKey is required.
	StorageAccountAccessKey *string `json:"storageAccountAccessKey,omitempty"`
	// RecurringScans - The recurring scans settings
	RecurringScans *VulnerabilityAssessmentRecurringScansProperties `json:"recurringScans,omitempty"`
}

// DatabaseVulnerabilityAssessmentRuleBaseline a database vulnerability assessment rule baseline.
type DatabaseVulnerabilityAssessmentRuleBaseline struct {
	autorest.Response `json:"-"`
	// DatabaseVulnerabilityAssessmentRuleBaselineProperties - Resource properties.
	*DatabaseVulnerabilityAssessmentRuleBaselineProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for DatabaseVulnerabilityAssessmentRuleBaseline.
func (dvarb DatabaseVulnerabilityAssessmentRuleBaseline) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dvarb.DatabaseVulnerabilityAssessmentRuleBaselineProperties != nil {
		objectMap["properties"] = dvarb.DatabaseVulnerabilityAssessmentRuleBaselineProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DatabaseVulnerabilityAssessmentRuleBaseline struct.
func (dvarb *DatabaseVulnerabilityAssessmentRuleBaseline) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var databaseVulnerabilityAssessmentRuleBaselineProperties DatabaseVulnerabilityAssessmentRuleBaselineProperties
				err = json.Unmarshal(*v, &databaseVulnerabilityAssessmentRuleBaselineProperties)
				if err != nil {
					return err
				}
				dvarb.DatabaseVulnerabilityAssessmentRuleBaselineProperties = &databaseVulnerabilityAssessmentRuleBaselineProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				dvarb.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				dvarb.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				dvarb.Type = &typeVar
			}
		}
	}

	return nil
}

// DatabaseVulnerabilityAssessmentRuleBaselineItem properties for an Azure SQL Database Vulnerability
// Assessment rule baseline's result.
type DatabaseVulnerabilityAssessmentRuleBaselineItem struct {
	// Result - The rule baseline result
	Result *[]string `json:"result,omitempty"`
}

// DatabaseVulnerabilityAssessmentRuleBaselineProperties properties of a database Vulnerability Assessment rule
// baseline.
type DatabaseVulnerabilityAssessmentRuleBaselineProperties struct {
	// BaselineResults - The rule baseline result
	BaselineResults *[]DatabaseVulnerabilityAssessmentRuleBaselineItem `json:"baselineResults,omitempty"`
}

// DatabaseVulnerabilityAssessmentScanExportProperties properties of the export operation's result.
type DatabaseVulnerabilityAssessmentScanExportProperties struct {
	// ExportedReportLocation - READ-ONLY; Location of the exported report (e.g. https://myStorage.blob.core.windows.net/VaScans/scans/serverName/databaseName/scan_scanId.xlsx).
	ExportedReportLocation *string `json:"exportedReportLocation,omitempty"`
}

// DatabaseVulnerabilityAssessmentScansExport a database Vulnerability Assessment scan export resource.
type DatabaseVulnerabilityAssessmentScansExport struct {
	autorest.Response `json:"-"`
	// DatabaseVulnerabilityAssessmentScanExportProperties - Resource properties.
	*DatabaseVulnerabilityAssessmentScanExportProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for DatabaseVulnerabilityAssessmentScansExport.
func (dvase DatabaseVulnerabilityAssessmentScansExport) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dvase.DatabaseVulnerabilityAssessmentScanExportProperties != nil {
		objectMap["properties"] = dvase.DatabaseVulnerabilityAssessmentScanExportProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DatabaseVulnerabilityAssessmentScansExport struct.
func (dvase *DatabaseVulnerabilityAssessmentScansExport) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var databaseVulnerabilityAssessmentScanExportProperties DatabaseVulnerabilityAssessmentScanExportProperties
				err = json.Unmarshal(*v, &databaseVulnerabilityAssessmentScanExportProperties)
				if err != nil {
					return err
				}
				dvase.DatabaseVulnerabilityAssessmentScanExportProperties = &databaseVulnerabilityAssessmentScanExportProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				dvase.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				dvase.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				dvase.Type = &typeVar
			}
		}
	}

	return nil
}

// DatabaseVulnerabilityAssessmentScansInitiateScanFuture an abstraction for monitoring and retrieving the
// results of a long-running operation.
type DatabaseVulnerabilityAssessmentScansInitiateScanFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *DatabaseVulnerabilityAssessmentScansInitiateScanFuture) Result(client DatabaseVulnerabilityAssessmentScansClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.DatabaseVulnerabilityAssessmentScansInitiateScanFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.DatabaseVulnerabilityAssessmentScansInitiateScanFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// DataMaskingPolicy represents a database data masking policy.
type DataMaskingPolicy struct {
	autorest.Response `json:"-"`
	// DataMaskingPolicyProperties - The properties of the data masking policy.
	*DataMaskingPolicyProperties `json:"properties,omitempty"`
	// Location - READ-ONLY; The location of the data masking policy.
	Location *string `json:"location,omitempty"`
	// Kind - READ-ONLY; The kind of data masking policy. Metadata, used for Azure portal.
	Kind *string `json:"kind,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for DataMaskingPolicy.
func (dmp DataMaskingPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dmp.DataMaskingPolicyProperties != nil {
		objectMap["properties"] = dmp.DataMaskingPolicyProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DataMaskingPolicy struct.
func (dmp *DataMaskingPolicy) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var dataMaskingPolicyProperties DataMaskingPolicyProperties
				err = json.Unmarshal(*v, &dataMaskingPolicyProperties)
				if err != nil {
					return err
				}
				dmp.DataMaskingPolicyProperties = &dataMaskingPolicyProperties
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				dmp.Location = &location
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				dmp.Kind = &kind
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				dmp.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				dmp.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				dmp.Type = &typeVar
			}
		}
	}

	return nil
}

// DataMaskingPolicyProperties the properties of a database data masking policy.
type DataMaskingPolicyProperties struct {
	// DataMaskingState - The state of the data masking policy. Possible values include: 'DataMaskingStateDisabled', 'DataMaskingStateEnabled'
	DataMaskingState DataMaskingState `json:"dataMaskingState,omitempty"`
	// ExemptPrincipals - The list of the exempt principals. Specifies the semicolon-separated list of database users for which the data masking policy does not apply. The specified users receive data results without masking for all of the database queries.
	ExemptPrincipals *string `json:"exemptPrincipals,omitempty"`
	// ApplicationPrincipals - READ-ONLY; The list of the application principals. This is a legacy parameter and is no longer used.
	ApplicationPrincipals *string `json:"applicationPrincipals,omitempty"`
	// MaskingLevel - READ-ONLY; The masking level. This is a legacy parameter and is no longer used.
	MaskingLevel *string `json:"maskingLevel,omitempty"`
}

// MarshalJSON is the custom marshaler for DataMaskingPolicyProperties.
func (dmpp DataMaskingPolicyProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dmpp.DataMaskingState != "" {
		objectMap["dataMaskingState"] = dmpp.DataMaskingState
	}
	if dmpp.ExemptPrincipals != nil {
		objectMap["exemptPrincipals"] = dmpp.ExemptPrincipals
	}
	return json.Marshal(objectMap)
}

// DataMaskingRule represents a database data masking rule.
type DataMaskingRule struct {
	autorest.Response `json:"-"`
	// DataMaskingRuleProperties - The properties of the resource.
	*DataMaskingRuleProperties `json:"properties,omitempty"`
	// Location - READ-ONLY; The location of the data masking rule.
	Location *string `json:"location,omitempty"`
	// Kind - READ-ONLY; The kind of Data Masking Rule. Metadata, used for Azure portal.
	Kind *string `json:"kind,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for DataMaskingRule.
func (dmr DataMaskingRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dmr.DataMaskingRuleProperties != nil {
		objectMap["properties"] = dmr.DataMaskingRuleProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DataMaskingRule struct.
func (dmr *DataMaskingRule) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var dataMaskingRuleProperties DataMaskingRuleProperties
				err = json.Unmarshal(*v, &dataMaskingRuleProperties)
				if err != nil {
					return err
				}
				dmr.DataMaskingRuleProperties = &dataMaskingRuleProperties
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				dmr.Location = &location
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				dmr.Kind = &kind
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				dmr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				dmr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				dmr.Type = &typeVar
			}
		}
	}

	return nil
}

// DataMaskingRuleListResult the response to a list data masking rules request.
type DataMaskingRuleListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of database data masking rules.
	Value *[]DataMaskingRule `json:"value,omitempty"`
}

// DataMaskingRuleProperties the properties of a database data masking rule.
type DataMaskingRuleProperties struct {
	// ID - READ-ONLY; The rule Id.
	ID *string `json:"id,omitempty"`
	// AliasName - The alias name. This is a legacy parameter and is no longer used.
	AliasName *string `json:"aliasName,omitempty"`
	// RuleState - The rule state. Used to delete a rule. To delete an existing rule, specify the schemaName, tableName, columnName, maskingFunction, and specify ruleState as disabled. However, if the rule doesn't already exist, the rule will be created with ruleState set to enabled, regardless of the provided value of ruleState. Possible values include: 'DataMaskingRuleStateDisabled', 'DataMaskingRuleStateEnabled'
	RuleState DataMaskingRuleState `json:"ruleState,omitempty"`
	// SchemaName - The schema name on which the data masking rule is applied.
	SchemaName *string `json:"schemaName,omitempty"`
	// TableName - The table name on which the data masking rule is applied.
	TableName *string `json:"tableName,omitempty"`
	// ColumnName - The column name on which the data masking rule is applied.
	ColumnName *string `json:"columnName,omitempty"`
	// MaskingFunction - The masking function that is used for the data masking rule. Possible values include: 'DataMaskingFunctionDefault', 'DataMaskingFunctionCCN', 'DataMaskingFunctionEmail', 'DataMaskingFunctionNumber', 'DataMaskingFunctionSSN', 'DataMaskingFunctionText'
	MaskingFunction DataMaskingFunction `json:"maskingFunction,omitempty"`
	// NumberFrom - The numberFrom property of the masking rule. Required if maskingFunction is set to Number, otherwise this parameter will be ignored.
	NumberFrom *string `json:"numberFrom,omitempty"`
	// NumberTo - The numberTo property of the data masking rule. Required if maskingFunction is set to Number, otherwise this parameter will be ignored.
	NumberTo *string `json:"numberTo,omitempty"`
	// PrefixSize - If maskingFunction is set to Text, the number of characters to show unmasked in the beginning of the string. Otherwise, this parameter will be ignored.
	PrefixSize *string `json:"prefixSize,omitempty"`
	// SuffixSize - If maskingFunction is set to Text, the number of characters to show unmasked at the end of the string. Otherwise, this parameter will be ignored.
	SuffixSize *string `json:"suffixSize,omitempty"`
	// ReplacementString - If maskingFunction is set to Text, the character to use for masking the unexposed part of the string. Otherwise, this parameter will be ignored.
	ReplacementString *string `json:"replacementString,omitempty"`
}

// MarshalJSON is the custom marshaler for DataMaskingRuleProperties.
func (dmrp DataMaskingRuleProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dmrp.AliasName != nil {
		objectMap["aliasName"] = dmrp.AliasName
	}
	if dmrp.RuleState != "" {
		objectMap["ruleState"] = dmrp.RuleState
	}
	if dmrp.SchemaName != nil {
		objectMap["schemaName"] = dmrp.SchemaName
	}
	if dmrp.TableName != nil {
		objectMap["tableName"] = dmrp.TableName
	}
	if dmrp.ColumnName != nil {
		objectMap["columnName"] = dmrp.ColumnName
	}
	if dmrp.MaskingFunction != "" {
		objectMap["maskingFunction"] = dmrp.MaskingFunction
	}
	if dmrp.NumberFrom != nil {
		objectMap["numberFrom"] = dmrp.NumberFrom
	}
	if dmrp.NumberTo != nil {
		objectMap["numberTo"] = dmrp.NumberTo
	}
	if dmrp.PrefixSize != nil {
		objectMap["prefixSize"] = dmrp.PrefixSize
	}
	if dmrp.SuffixSize != nil {
		objectMap["suffixSize"] = dmrp.SuffixSize
	}
	if dmrp.ReplacementString != nil {
		objectMap["replacementString"] = dmrp.ReplacementString
	}
	return json.Marshal(objectMap)
}

// EditionCapability the edition capability.
type EditionCapability struct {
	// Name - READ-ONLY; The database edition name.
	Name *string `json:"name,omitempty"`
	// SupportedServiceLevelObjectives - READ-ONLY; The list of supported service objectives for the edition.
	SupportedServiceLevelObjectives *[]ServiceObjectiveCapability `json:"supportedServiceLevelObjectives,omitempty"`
	// ZoneRedundant - READ-ONLY; Whether or not zone redundancy is supported for the edition.
	ZoneRedundant *bool `json:"zoneRedundant,omitempty"`
	// ReadScale - READ-ONLY; The read scale capability for the edition.
	ReadScale *ReadScaleCapability `json:"readScale,omitempty"`
	// SupportedStorageCapabilities - READ-ONLY; The list of supported storage capabilities for this edition
	SupportedStorageCapabilities *[]StorageCapability `json:"supportedStorageCapabilities,omitempty"`
	// Status - READ-ONLY; The status of the capability. Possible values include: 'CapabilityStatusVisible', 'CapabilityStatusAvailable', 'CapabilityStatusDefault', 'CapabilityStatusDisabled'
	Status CapabilityStatus `json:"status,omitempty"`
	// Reason - The reason for the capability not being available.
	Reason *string `json:"reason,omitempty"`
}

// MarshalJSON is the custom marshaler for EditionCapability.
func (ec EditionCapability) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ec.Reason != nil {
		objectMap["reason"] = ec.Reason
	}
	return json.Marshal(objectMap)
}

// ElasticPool an elastic pool.
type ElasticPool struct {
	autorest.Response `json:"-"`
	// Sku - The elastic pool SKU.
	//
	// The list of SKUs may vary by region and support offer. To determine the SKUs (including the SKU name, tier/edition, family, and capacity) that are available to your subscription in an Azure region, use the `Capabilities_ListByLocation` REST API or the following command:
	//
	// ```azurecli
	// az sql elastic-pool list-editions -l <location> -o table
	// ````
	Sku *Sku `json:"sku,omitempty"`
	// Kind - READ-ONLY; Kind of elastic pool. This is metadata used for the Azure portal experience.
	Kind *string `json:"kind,omitempty"`
	// ElasticPoolProperties - Resource properties.
	*ElasticPoolProperties `json:"properties,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ElasticPool.
func (ep ElasticPool) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ep.Sku != nil {
		objectMap["sku"] = ep.Sku
	}
	if ep.ElasticPoolProperties != nil {
		objectMap["properties"] = ep.ElasticPoolProperties
	}
	if ep.Location != nil {
		objectMap["location"] = ep.Location
	}
	if ep.Tags != nil {
		objectMap["tags"] = ep.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ElasticPool struct.
func (ep *ElasticPool) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "sku":
			if v != nil {
				var sku Sku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				ep.Sku = &sku
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				ep.Kind = &kind
			}
		case "properties":
			if v != nil {
				var elasticPoolProperties ElasticPoolProperties
				err = json.Unmarshal(*v, &elasticPoolProperties)
				if err != nil {
					return err
				}
				ep.ElasticPoolProperties = &elasticPoolProperties
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				ep.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				ep.Tags = tags
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ep.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ep.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ep.Type = &typeVar
			}
		}
	}

	return nil
}

// ElasticPoolActivity represents the activity on an elastic pool.
type ElasticPoolActivity struct {
	// Location - The geo-location where the resource lives
	Location *string `json:"location,omitempty"`
	// ElasticPoolActivityProperties - The properties representing the resource.
	*ElasticPoolActivityProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ElasticPoolActivity.
func (epa ElasticPoolActivity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if epa.Location != nil {
		objectMap["location"] = epa.Location
	}
	if epa.ElasticPoolActivityProperties != nil {
		objectMap["properties"] = epa.ElasticPoolActivityProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ElasticPoolActivity struct.
func (epa *ElasticPoolActivity) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				epa.Location = &location
			}
		case "properties":
			if v != nil {
				var elasticPoolActivityProperties ElasticPoolActivityProperties
				err = json.Unmarshal(*v, &elasticPoolActivityProperties)
				if err != nil {
					return err
				}
				epa.ElasticPoolActivityProperties = &elasticPoolActivityProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				epa.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				epa.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				epa.Type = &typeVar
			}
		}
	}

	return nil
}

// ElasticPoolActivityListResult represents the response to a list elastic pool activity request.
type ElasticPoolActivityListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of elastic pool activities.
	Value *[]ElasticPoolActivity `json:"value,omitempty"`
}

// ElasticPoolActivityProperties represents the properties of an elastic pool.
type ElasticPoolActivityProperties struct {
	// EndTime - READ-ONLY; The time the operation finished (ISO8601 format).
	EndTime *date.Time `json:"endTime,omitempty"`
	// ErrorCode - READ-ONLY; The error code if available.
	ErrorCode *int32 `json:"errorCode,omitempty"`
	// ErrorMessage - READ-ONLY; The error message if available.
	ErrorMessage *string `json:"errorMessage,omitempty"`
	// ErrorSeverity - READ-ONLY; The error severity if available.
	ErrorSeverity *int32 `json:"errorSeverity,omitempty"`
	// Operation - READ-ONLY; The operation name.
	Operation *string `json:"operation,omitempty"`
	// OperationID - READ-ONLY; The unique operation ID.
	OperationID *uuid.UUID `json:"operationId,omitempty"`
	// PercentComplete - READ-ONLY; The percentage complete if available.
	PercentComplete *int32 `json:"percentComplete,omitempty"`
	// RequestedDatabaseDtuMax - READ-ONLY; The requested max DTU per database if available.
	RequestedDatabaseDtuMax *int32 `json:"requestedDatabaseDtuMax,omitempty"`
	// RequestedDatabaseDtuMin - READ-ONLY; The requested min DTU per database if available.
	RequestedDatabaseDtuMin *int32 `json:"requestedDatabaseDtuMin,omitempty"`
	// RequestedDtu - READ-ONLY; The requested DTU for the pool if available.
	RequestedDtu *int32 `json:"requestedDtu,omitempty"`
	// RequestedElasticPoolName - READ-ONLY; The requested name for the elastic pool if available.
	RequestedElasticPoolName *string `json:"requestedElasticPoolName,omitempty"`
	// RequestedStorageLimitInGB - READ-ONLY; The requested storage limit for the pool in GB if available.
	RequestedStorageLimitInGB *int64 `json:"requestedStorageLimitInGB,omitempty"`
	// ElasticPoolName - READ-ONLY; The name of the elastic pool.
	ElasticPoolName *string `json:"elasticPoolName,omitempty"`
	// ServerName - READ-ONLY; The name of the server the elastic pool is in.
	ServerName *string `json:"serverName,omitempty"`
	// StartTime - READ-ONLY; The time the operation started (ISO8601 format).
	StartTime *date.Time `json:"startTime,omitempty"`
	// State - READ-ONLY; The current state of the operation.
	State *string `json:"state,omitempty"`
	// RequestedStorageLimitInMB - READ-ONLY; The requested storage limit in MB.
	RequestedStorageLimitInMB *int32 `json:"requestedStorageLimitInMB,omitempty"`
	// RequestedDatabaseDtuGuarantee - READ-ONLY; The requested per database DTU guarantee.
	RequestedDatabaseDtuGuarantee *int32 `json:"requestedDatabaseDtuGuarantee,omitempty"`
	// RequestedDatabaseDtuCap - READ-ONLY; The requested per database DTU cap.
	RequestedDatabaseDtuCap *int32 `json:"requestedDatabaseDtuCap,omitempty"`
	// RequestedDtuGuarantee - READ-ONLY; The requested DTU guarantee.
	RequestedDtuGuarantee *int32 `json:"requestedDtuGuarantee,omitempty"`
}

// ElasticPoolDatabaseActivity represents the activity on an elastic pool.
type ElasticPoolDatabaseActivity struct {
	// Location - The geo-location where the resource lives
	Location *string `json:"location,omitempty"`
	// ElasticPoolDatabaseActivityProperties - The properties representing the resource.
	*ElasticPoolDatabaseActivityProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ElasticPoolDatabaseActivity.
func (epda ElasticPoolDatabaseActivity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if epda.Location != nil {
		objectMap["location"] = epda.Location
	}
	if epda.ElasticPoolDatabaseActivityProperties != nil {
		objectMap["properties"] = epda.ElasticPoolDatabaseActivityProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ElasticPoolDatabaseActivity struct.
func (epda *ElasticPoolDatabaseActivity) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				epda.Location = &location
			}
		case "properties":
			if v != nil {
				var elasticPoolDatabaseActivityProperties ElasticPoolDatabaseActivityProperties
				err = json.Unmarshal(*v, &elasticPoolDatabaseActivityProperties)
				if err != nil {
					return err
				}
				epda.ElasticPoolDatabaseActivityProperties = &elasticPoolDatabaseActivityProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				epda.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				epda.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				epda.Type = &typeVar
			}
		}
	}

	return nil
}

// ElasticPoolDatabaseActivityListResult represents the response to a list elastic pool database activity
// request.
type ElasticPoolDatabaseActivityListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of elastic pool database activities.
	Value *[]ElasticPoolDatabaseActivity `json:"value,omitempty"`
}

// ElasticPoolDatabaseActivityProperties represents the properties of an elastic pool database activity.
type ElasticPoolDatabaseActivityProperties struct {
	// DatabaseName - READ-ONLY; The database name.
	DatabaseName *string `json:"databaseName,omitempty"`
	// EndTime - READ-ONLY; The time the operation finished (ISO8601 format).
	EndTime *date.Time `json:"endTime,omitempty"`
	// ErrorCode - READ-ONLY; The error code if available.
	ErrorCode *int32 `json:"errorCode,omitempty"`
	// ErrorMessage - READ-ONLY; The error message if available.
	ErrorMessage *string `json:"errorMessage,omitempty"`
	// ErrorSeverity - READ-ONLY; The error severity if available.
	ErrorSeverity *int32 `json:"errorSeverity,omitempty"`
	// Operation - READ-ONLY; The operation name.
	Operation *string `json:"operation,omitempty"`
	// OperationID - READ-ONLY; The unique operation ID.
	OperationID *uuid.UUID `json:"operationId,omitempty"`
	// PercentComplete - READ-ONLY; The percentage complete if available.
	PercentComplete *int32 `json:"percentComplete,omitempty"`
	// RequestedElasticPoolName - READ-ONLY; The name for the elastic pool the database is moving into if available.
	RequestedElasticPoolName *string `json:"requestedElasticPoolName,omitempty"`
	// CurrentElasticPoolName - READ-ONLY; The name of the current elastic pool the database is in if available.
	CurrentElasticPoolName *string `json:"currentElasticPoolName,omitempty"`
	// CurrentServiceObjective - READ-ONLY; The name of the current service objective if available.
	CurrentServiceObjective *string `json:"currentServiceObjective,omitempty"`
	// RequestedServiceObjective - READ-ONLY; The name of the requested service objective if available.
	RequestedServiceObjective *string `json:"requestedServiceObjective,omitempty"`
	// ServerName - READ-ONLY; The name of the server the elastic pool is in.
	ServerName *string `json:"serverName,omitempty"`
	// StartTime - READ-ONLY; The time the operation started (ISO8601 format).
	StartTime *date.Time `json:"startTime,omitempty"`
	// State - READ-ONLY; The current state of the operation.
	State *string `json:"state,omitempty"`
}

// ElasticPoolEditionCapability the elastic pool edition capability.
type ElasticPoolEditionCapability struct {
	// Name - READ-ONLY; The elastic pool edition name.
	Name *string `json:"name,omitempty"`
	// SupportedElasticPoolPerformanceLevels - READ-ONLY; The list of supported elastic pool DTU levels for the edition.
	SupportedElasticPoolPerformanceLevels *[]ElasticPoolPerformanceLevelCapability `json:"supportedElasticPoolPerformanceLevels,omitempty"`
	// ZoneRedundant - READ-ONLY; Whether or not zone redundancy is supported for the edition.
	ZoneRedundant *bool `json:"zoneRedundant,omitempty"`
	// Status - READ-ONLY; The status of the capability. Possible values include: 'CapabilityStatusVisible', 'CapabilityStatusAvailable', 'CapabilityStatusDefault', 'CapabilityStatusDisabled'
	Status CapabilityStatus `json:"status,omitempty"`
	// Reason - The reason for the capability not being available.
	Reason *string `json:"reason,omitempty"`
}

// MarshalJSON is the custom marshaler for ElasticPoolEditionCapability.
func (epec ElasticPoolEditionCapability) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if epec.Reason != nil {
		objectMap["reason"] = epec.Reason
	}
	return json.Marshal(objectMap)
}

// ElasticPoolListResult the result of an elastic pool list request.
type ElasticPoolListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]ElasticPool `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ElasticPoolListResultIterator provides access to a complete listing of ElasticPool values.
type ElasticPoolListResultIterator struct {
	i    int
	page ElasticPoolListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ElasticPoolListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ElasticPoolListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ElasticPoolListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ElasticPoolListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ElasticPoolListResultIterator) Response() ElasticPoolListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ElasticPoolListResultIterator) Value() ElasticPool {
	if !iter.page.NotDone() {
		return ElasticPool{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ElasticPoolListResultIterator type.
func NewElasticPoolListResultIterator(page ElasticPoolListResultPage) ElasticPoolListResultIterator {
	return ElasticPoolListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (eplr ElasticPoolListResult) IsEmpty() bool {
	return eplr.Value == nil || len(*eplr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (eplr ElasticPoolListResult) hasNextLink() bool {
	return eplr.NextLink != nil && len(*eplr.NextLink) != 0
}

// elasticPoolListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (eplr ElasticPoolListResult) elasticPoolListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !eplr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(eplr.NextLink)))
}

// ElasticPoolListResultPage contains a page of ElasticPool values.
type ElasticPoolListResultPage struct {
	fn   func(context.Context, ElasticPoolListResult) (ElasticPoolListResult, error)
	eplr ElasticPoolListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ElasticPoolListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ElasticPoolListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.eplr)
		if err != nil {
			return err
		}
		page.eplr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ElasticPoolListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ElasticPoolListResultPage) NotDone() bool {
	return !page.eplr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ElasticPoolListResultPage) Response() ElasticPoolListResult {
	return page.eplr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ElasticPoolListResultPage) Values() []ElasticPool {
	if page.eplr.IsEmpty() {
		return nil
	}
	return *page.eplr.Value
}

// Creates a new instance of the ElasticPoolListResultPage type.
func NewElasticPoolListResultPage(getNextPage func(context.Context, ElasticPoolListResult) (ElasticPoolListResult, error)) ElasticPoolListResultPage {
	return ElasticPoolListResultPage{fn: getNextPage}
}

// ElasticPoolOperation a elastic pool operation.
type ElasticPoolOperation struct {
	// ElasticPoolOperationProperties - Resource properties.
	*ElasticPoolOperationProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ElasticPoolOperation.
func (epo ElasticPoolOperation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if epo.ElasticPoolOperationProperties != nil {
		objectMap["properties"] = epo.ElasticPoolOperationProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ElasticPoolOperation struct.
func (epo *ElasticPoolOperation) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var elasticPoolOperationProperties ElasticPoolOperationProperties
				err = json.Unmarshal(*v, &elasticPoolOperationProperties)
				if err != nil {
					return err
				}
				epo.ElasticPoolOperationProperties = &elasticPoolOperationProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				epo.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				epo.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				epo.Type = &typeVar
			}
		}
	}

	return nil
}

// ElasticPoolOperationListResult the response to a list elastic pool operations request
type ElasticPoolOperationListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]ElasticPoolOperation `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ElasticPoolOperationListResultIterator provides access to a complete listing of ElasticPoolOperation values.
type ElasticPoolOperationListResultIterator struct {
	i    int
	page ElasticPoolOperationListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ElasticPoolOperationListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ElasticPoolOperationListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ElasticPoolOperationListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ElasticPoolOperationListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ElasticPoolOperationListResultIterator) Response() ElasticPoolOperationListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ElasticPoolOperationListResultIterator) Value() ElasticPoolOperation {
	if !iter.page.NotDone() {
		return ElasticPoolOperation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ElasticPoolOperationListResultIterator type.
func NewElasticPoolOperationListResultIterator(page ElasticPoolOperationListResultPage) ElasticPoolOperationListResultIterator {
	return ElasticPoolOperationListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (epolr ElasticPoolOperationListResult) IsEmpty() bool {
	return epolr.Value == nil || len(*epolr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (epolr ElasticPoolOperationListResult) hasNextLink() bool {
	return epolr.NextLink != nil && len(*epolr.NextLink) != 0
}

// elasticPoolOperationListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (epolr ElasticPoolOperationListResult) elasticPoolOperationListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !epolr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(epolr.NextLink)))
}

// ElasticPoolOperationListResultPage contains a page of ElasticPoolOperation values.
type ElasticPoolOperationListResultPage struct {
	fn    func(context.Context, ElasticPoolOperationListResult) (ElasticPoolOperationListResult, error)
	epolr ElasticPoolOperationListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ElasticPoolOperationListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ElasticPoolOperationListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.epolr)
		if err != nil {
			return err
		}
		page.epolr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ElasticPoolOperationListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ElasticPoolOperationListResultPage) NotDone() bool {
	return !page.epolr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ElasticPoolOperationListResultPage) Response() ElasticPoolOperationListResult {
	return page.epolr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ElasticPoolOperationListResultPage) Values() []ElasticPoolOperation {
	if page.epolr.IsEmpty() {
		return nil
	}
	return *page.epolr.Value
}

// Creates a new instance of the ElasticPoolOperationListResultPage type.
func NewElasticPoolOperationListResultPage(getNextPage func(context.Context, ElasticPoolOperationListResult) (ElasticPoolOperationListResult, error)) ElasticPoolOperationListResultPage {
	return ElasticPoolOperationListResultPage{fn: getNextPage}
}

// ElasticPoolOperationProperties the properties of a elastic pool operation.
type ElasticPoolOperationProperties struct {
	// ElasticPoolName - READ-ONLY; The name of the elastic pool the operation is being performed on.
	ElasticPoolName *string `json:"elasticPoolName,omitempty"`
	// Operation - READ-ONLY; The name of operation.
	Operation *string `json:"operation,omitempty"`
	// OperationFriendlyName - READ-ONLY; The friendly name of operation.
	OperationFriendlyName *string `json:"operationFriendlyName,omitempty"`
	// PercentComplete - READ-ONLY; The percentage of the operation completed.
	PercentComplete *int32 `json:"percentComplete,omitempty"`
	// ServerName - READ-ONLY; The name of the server.
	ServerName *string `json:"serverName,omitempty"`
	// StartTime - READ-ONLY; The operation start time.
	StartTime *date.Time `json:"startTime,omitempty"`
	// State - READ-ONLY; The operation state.
	State *string `json:"state,omitempty"`
	// ErrorCode - READ-ONLY; The operation error code.
	ErrorCode *int32 `json:"errorCode,omitempty"`
	// ErrorDescription - READ-ONLY; The operation error description.
	ErrorDescription *string `json:"errorDescription,omitempty"`
	// ErrorSeverity - READ-ONLY; The operation error severity.
	ErrorSeverity *int32 `json:"errorSeverity,omitempty"`
	// IsUserError - READ-ONLY; Whether or not the error is a user error.
	IsUserError *bool `json:"isUserError,omitempty"`
	// EstimatedCompletionTime - READ-ONLY; The estimated completion time of the operation.
	EstimatedCompletionTime *date.Time `json:"estimatedCompletionTime,omitempty"`
	// Description - READ-ONLY; The operation description.
	Description *string `json:"description,omitempty"`
	// IsCancellable - READ-ONLY; Whether the operation can be cancelled.
	IsCancellable *bool `json:"isCancellable,omitempty"`
}

// ElasticPoolPerDatabaseMaxPerformanceLevelCapability the max per-database performance level capability.
type ElasticPoolPerDatabaseMaxPerformanceLevelCapability struct {
	// Limit - READ-ONLY; The maximum performance level per database.
	Limit *float64 `json:"limit,omitempty"`
	// Unit - READ-ONLY; Unit type used to measure performance level. Possible values include: 'DTU', 'VCores'
	Unit PerformanceLevelUnit `json:"unit,omitempty"`
	// SupportedPerDatabaseMinPerformanceLevels - READ-ONLY; The list of supported min database performance levels.
	SupportedPerDatabaseMinPerformanceLevels *[]ElasticPoolPerDatabaseMinPerformanceLevelCapability `json:"supportedPerDatabaseMinPerformanceLevels,omitempty"`
	// Status - READ-ONLY; The status of the capability. Possible values include: 'CapabilityStatusVisible', 'CapabilityStatusAvailable', 'CapabilityStatusDefault', 'CapabilityStatusDisabled'
	Status CapabilityStatus `json:"status,omitempty"`
	// Reason - The reason for the capability not being available.
	Reason *string `json:"reason,omitempty"`
}

// MarshalJSON is the custom marshaler for ElasticPoolPerDatabaseMaxPerformanceLevelCapability.
func (eppdmplc ElasticPoolPerDatabaseMaxPerformanceLevelCapability) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if eppdmplc.Reason != nil {
		objectMap["reason"] = eppdmplc.Reason
	}
	return json.Marshal(objectMap)
}

// ElasticPoolPerDatabaseMinPerformanceLevelCapability the minimum per-database performance level capability.
type ElasticPoolPerDatabaseMinPerformanceLevelCapability struct {
	// Limit - READ-ONLY; The minimum performance level per database.
	Limit *float64 `json:"limit,omitempty"`
	// Unit - READ-ONLY; Unit type used to measure performance level. Possible values include: 'DTU', 'VCores'
	Unit PerformanceLevelUnit `json:"unit,omitempty"`
	// Status - READ-ONLY; The status of the capability. Possible values include: 'CapabilityStatusVisible', 'CapabilityStatusAvailable', 'CapabilityStatusDefault', 'CapabilityStatusDisabled'
	Status CapabilityStatus `json:"status,omitempty"`
	// Reason - The reason for the capability not being available.
	Reason *string `json:"reason,omitempty"`
}

// MarshalJSON is the custom marshaler for ElasticPoolPerDatabaseMinPerformanceLevelCapability.
func (eppdmplc ElasticPoolPerDatabaseMinPerformanceLevelCapability) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if eppdmplc.Reason != nil {
		objectMap["reason"] = eppdmplc.Reason
	}
	return json.Marshal(objectMap)
}

// ElasticPoolPerDatabaseSettings per database settings of an elastic pool.
type ElasticPoolPerDatabaseSettings struct {
	// MinCapacity - The minimum capacity all databases are guaranteed.
	MinCapacity *float64 `json:"minCapacity,omitempty"`
	// MaxCapacity - The maximum capacity any one database can consume.
	MaxCapacity *float64 `json:"maxCapacity,omitempty"`
}

// ElasticPoolPerformanceLevelCapability the Elastic Pool performance level capability.
type ElasticPoolPerformanceLevelCapability struct {
	// PerformanceLevel - READ-ONLY; The performance level for the pool.
	PerformanceLevel *PerformanceLevelCapability `json:"performanceLevel,omitempty"`
	// Sku - READ-ONLY; The sku.
	Sku *Sku `json:"sku,omitempty"`
	// SupportedLicenseTypes - READ-ONLY; List of supported license types.
	SupportedLicenseTypes *[]LicenseTypeCapability `json:"supportedLicenseTypes,omitempty"`
	// MaxDatabaseCount - READ-ONLY; The maximum number of databases supported.
	MaxDatabaseCount *int32 `json:"maxDatabaseCount,omitempty"`
	// IncludedMaxSize - READ-ONLY; The included (free) max size for this performance level.
	IncludedMaxSize *MaxSizeCapability `json:"includedMaxSize,omitempty"`
	// SupportedMaxSizes - READ-ONLY; The list of supported max sizes.
	SupportedMaxSizes *[]MaxSizeRangeCapability `json:"supportedMaxSizes,omitempty"`
	// SupportedPerDatabaseMaxSizes - READ-ONLY; The list of supported per database max sizes.
	SupportedPerDatabaseMaxSizes *[]MaxSizeRangeCapability `json:"supportedPerDatabaseMaxSizes,omitempty"`
	// SupportedPerDatabaseMaxPerformanceLevels - READ-ONLY; The list of supported per database max performance levels.
	SupportedPerDatabaseMaxPerformanceLevels *[]ElasticPoolPerDatabaseMaxPerformanceLevelCapability `json:"supportedPerDatabaseMaxPerformanceLevels,omitempty"`
	// ZoneRedundant - READ-ONLY; Whether or not zone redundancy is supported for the performance level.
	ZoneRedundant *bool `json:"zoneRedundant,omitempty"`
	// Status - READ-ONLY; The status of the capability. Possible values include: 'CapabilityStatusVisible', 'CapabilityStatusAvailable', 'CapabilityStatusDefault', 'CapabilityStatusDisabled'
	Status CapabilityStatus `json:"status,omitempty"`
	// Reason - The reason for the capability not being available.
	Reason *string `json:"reason,omitempty"`
}

// MarshalJSON is the custom marshaler for ElasticPoolPerformanceLevelCapability.
func (epplc ElasticPoolPerformanceLevelCapability) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if epplc.Reason != nil {
		objectMap["reason"] = epplc.Reason
	}
	return json.Marshal(objectMap)
}

// ElasticPoolProperties properties of an elastic pool
type ElasticPoolProperties struct {
	// State - READ-ONLY; The state of the elastic pool. Possible values include: 'ElasticPoolStateCreating', 'ElasticPoolStateReady', 'ElasticPoolStateDisabled'
	State ElasticPoolState `json:"state,omitempty"`
	// CreationDate - READ-ONLY; The creation date of the elastic pool (ISO8601 format).
	CreationDate *date.Time `json:"creationDate,omitempty"`
	// MaxSizeBytes - The storage limit for the database elastic pool in bytes.
	MaxSizeBytes *int64 `json:"maxSizeBytes,omitempty"`
	// PerDatabaseSettings - The per database settings for the elastic pool.
	PerDatabaseSettings *ElasticPoolPerDatabaseSettings `json:"perDatabaseSettings,omitempty"`
	// ZoneRedundant - Whether or not this elastic pool is zone redundant, which means the replicas of this elastic pool will be spread across multiple availability zones.
	ZoneRedundant *bool `json:"zoneRedundant,omitempty"`
	// LicenseType - The license type to apply for this elastic pool. Possible values include: 'ElasticPoolLicenseTypeLicenseIncluded', 'ElasticPoolLicenseTypeBasePrice'
	LicenseType ElasticPoolLicenseType `json:"licenseType,omitempty"`
}

// MarshalJSON is the custom marshaler for ElasticPoolProperties.
func (epp ElasticPoolProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if epp.MaxSizeBytes != nil {
		objectMap["maxSizeBytes"] = epp.MaxSizeBytes
	}
	if epp.PerDatabaseSettings != nil {
		objectMap["perDatabaseSettings"] = epp.PerDatabaseSettings
	}
	if epp.ZoneRedundant != nil {
		objectMap["zoneRedundant"] = epp.ZoneRedundant
	}
	if epp.LicenseType != "" {
		objectMap["licenseType"] = epp.LicenseType
	}
	return json.Marshal(objectMap)
}

// ElasticPoolsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ElasticPoolsCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ElasticPoolsCreateOrUpdateFuture) Result(client ElasticPoolsClient) (ep ElasticPool, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.ElasticPoolsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.ElasticPoolsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if ep.Response.Response, err = future.GetResult(sender); err == nil && ep.Response.Response.StatusCode != http.StatusNoContent {
		ep, err = client.CreateOrUpdateResponder(ep.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.ElasticPoolsCreateOrUpdateFuture", "Result", ep.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ElasticPoolsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ElasticPoolsDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ElasticPoolsDeleteFuture) Result(client ElasticPoolsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.ElasticPoolsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.ElasticPoolsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ElasticPoolsFailoverFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ElasticPoolsFailoverFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ElasticPoolsFailoverFuture) Result(client ElasticPoolsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.ElasticPoolsFailoverFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.ElasticPoolsFailoverFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ElasticPoolsUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ElasticPoolsUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ElasticPoolsUpdateFuture) Result(client ElasticPoolsClient) (ep ElasticPool, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.ElasticPoolsUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.ElasticPoolsUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if ep.Response.Response, err = future.GetResult(sender); err == nil && ep.Response.Response.StatusCode != http.StatusNoContent {
		ep, err = client.UpdateResponder(ep.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.ElasticPoolsUpdateFuture", "Result", ep.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ElasticPoolUpdate an elastic pool update.
type ElasticPoolUpdate struct {
	Sku *Sku `json:"sku,omitempty"`
	// ElasticPoolUpdateProperties - Resource properties.
	*ElasticPoolUpdateProperties `json:"properties,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ElasticPoolUpdate.
func (epu ElasticPoolUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if epu.Sku != nil {
		objectMap["sku"] = epu.Sku
	}
	if epu.ElasticPoolUpdateProperties != nil {
		objectMap["properties"] = epu.ElasticPoolUpdateProperties
	}
	if epu.Tags != nil {
		objectMap["tags"] = epu.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ElasticPoolUpdate struct.
func (epu *ElasticPoolUpdate) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "sku":
			if v != nil {
				var sku Sku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				epu.Sku = &sku
			}
		case "properties":
			if v != nil {
				var elasticPoolUpdateProperties ElasticPoolUpdateProperties
				err = json.Unmarshal(*v, &elasticPoolUpdateProperties)
				if err != nil {
					return err
				}
				epu.ElasticPoolUpdateProperties = &elasticPoolUpdateProperties
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				epu.Tags = tags
			}
		}
	}

	return nil
}

// ElasticPoolUpdateProperties properties of an elastic pool
type ElasticPoolUpdateProperties struct {
	// MaxSizeBytes - The storage limit for the database elastic pool in bytes.
	MaxSizeBytes *int64 `json:"maxSizeBytes,omitempty"`
	// PerDatabaseSettings - The per database settings for the elastic pool.
	PerDatabaseSettings *ElasticPoolPerDatabaseSettings `json:"perDatabaseSettings,omitempty"`
	// ZoneRedundant - Whether or not this elastic pool is zone redundant, which means the replicas of this elastic pool will be spread across multiple availability zones.
	ZoneRedundant *bool `json:"zoneRedundant,omitempty"`
	// LicenseType - The license type to apply for this elastic pool. Possible values include: 'ElasticPoolLicenseTypeLicenseIncluded', 'ElasticPoolLicenseTypeBasePrice'
	LicenseType ElasticPoolLicenseType `json:"licenseType,omitempty"`
}

// EncryptionProtector the server encryption protector.
type EncryptionProtector struct {
	autorest.Response `json:"-"`
	// Kind - READ-ONLY; Kind of encryption protector. This is metadata used for the Azure portal experience.
	Kind *string `json:"kind,omitempty"`
	// Location - READ-ONLY; Resource location.
	Location *string `json:"location,omitempty"`
	// EncryptionProtectorProperties - Resource properties.
	*EncryptionProtectorProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for EncryptionProtector.
func (ep EncryptionProtector) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ep.EncryptionProtectorProperties != nil {
		objectMap["properties"] = ep.EncryptionProtectorProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for EncryptionProtector struct.
func (ep *EncryptionProtector) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				ep.Kind = &kind
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				ep.Location = &location
			}
		case "properties":
			if v != nil {
				var encryptionProtectorProperties EncryptionProtectorProperties
				err = json.Unmarshal(*v, &encryptionProtectorProperties)
				if err != nil {
					return err
				}
				ep.EncryptionProtectorProperties = &encryptionProtectorProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ep.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ep.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ep.Type = &typeVar
			}
		}
	}

	return nil
}

// EncryptionProtectorListResult a list of server encryption protectors.
type EncryptionProtectorListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]EncryptionProtector `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// EncryptionProtectorListResultIterator provides access to a complete listing of EncryptionProtector values.
type EncryptionProtectorListResultIterator struct {
	i    int
	page EncryptionProtectorListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *EncryptionProtectorListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/EncryptionProtectorListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *EncryptionProtectorListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter EncryptionProtectorListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter EncryptionProtectorListResultIterator) Response() EncryptionProtectorListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter EncryptionProtectorListResultIterator) Value() EncryptionProtector {
	if !iter.page.NotDone() {
		return EncryptionProtector{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the EncryptionProtectorListResultIterator type.
func NewEncryptionProtectorListResultIterator(page EncryptionProtectorListResultPage) EncryptionProtectorListResultIterator {
	return EncryptionProtectorListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (eplr EncryptionProtectorListResult) IsEmpty() bool {
	return eplr.Value == nil || len(*eplr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (eplr EncryptionProtectorListResult) hasNextLink() bool {
	return eplr.NextLink != nil && len(*eplr.NextLink) != 0
}

// encryptionProtectorListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (eplr EncryptionProtectorListResult) encryptionProtectorListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !eplr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(eplr.NextLink)))
}

// EncryptionProtectorListResultPage contains a page of EncryptionProtector values.
type EncryptionProtectorListResultPage struct {
	fn   func(context.Context, EncryptionProtectorListResult) (EncryptionProtectorListResult, error)
	eplr EncryptionProtectorListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *EncryptionProtectorListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/EncryptionProtectorListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.eplr)
		if err != nil {
			return err
		}
		page.eplr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *EncryptionProtectorListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page EncryptionProtectorListResultPage) NotDone() bool {
	return !page.eplr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page EncryptionProtectorListResultPage) Response() EncryptionProtectorListResult {
	return page.eplr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page EncryptionProtectorListResultPage) Values() []EncryptionProtector {
	if page.eplr.IsEmpty() {
		return nil
	}
	return *page.eplr.Value
}

// Creates a new instance of the EncryptionProtectorListResultPage type.
func NewEncryptionProtectorListResultPage(getNextPage func(context.Context, EncryptionProtectorListResult) (EncryptionProtectorListResult, error)) EncryptionProtectorListResultPage {
	return EncryptionProtectorListResultPage{fn: getNextPage}
}

// EncryptionProtectorProperties properties for an encryption protector execution.
type EncryptionProtectorProperties struct {
	// Subregion - READ-ONLY; Subregion of the encryption protector.
	Subregion *string `json:"subregion,omitempty"`
	// ServerKeyName - The name of the server key.
	ServerKeyName *string `json:"serverKeyName,omitempty"`
	// ServerKeyType - The encryption protector type like 'ServiceManaged', 'AzureKeyVault'. Possible values include: 'ServiceManaged', 'AzureKeyVault'
	ServerKeyType ServerKeyType `json:"serverKeyType,omitempty"`
	// URI - READ-ONLY; The URI of the server key.
	URI *string `json:"uri,omitempty"`
	// Thumbprint - READ-ONLY; Thumbprint of the server key.
	Thumbprint *string `json:"thumbprint,omitempty"`
}

// MarshalJSON is the custom marshaler for EncryptionProtectorProperties.
func (epp EncryptionProtectorProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if epp.ServerKeyName != nil {
		objectMap["serverKeyName"] = epp.ServerKeyName
	}
	if epp.ServerKeyType != "" {
		objectMap["serverKeyType"] = epp.ServerKeyType
	}
	return json.Marshal(objectMap)
}

// EncryptionProtectorsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type EncryptionProtectorsCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *EncryptionProtectorsCreateOrUpdateFuture) Result(client EncryptionProtectorsClient) (ep EncryptionProtector, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.EncryptionProtectorsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.EncryptionProtectorsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if ep.Response.Response, err = future.GetResult(sender); err == nil && ep.Response.Response.StatusCode != http.StatusNoContent {
		ep, err = client.CreateOrUpdateResponder(ep.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.EncryptionProtectorsCreateOrUpdateFuture", "Result", ep.Response.Response, "Failure responding to request")
		}
	}
	return
}

// EncryptionProtectorsRevalidateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type EncryptionProtectorsRevalidateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *EncryptionProtectorsRevalidateFuture) Result(client EncryptionProtectorsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.EncryptionProtectorsRevalidateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.EncryptionProtectorsRevalidateFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ExportRequest export database parameters.
type ExportRequest struct {
	// StorageKeyType - The type of the storage key to use. Possible values include: 'StorageAccessKey', 'SharedAccessKey'
	StorageKeyType StorageKeyType `json:"storageKeyType,omitempty"`
	// StorageKey - The storage key to use.  If storage key type is SharedAccessKey, it must be preceded with a "?."
	StorageKey *string `json:"storageKey,omitempty"`
	// StorageURI - The storage uri to use.
	StorageURI *string `json:"storageUri,omitempty"`
	// AdministratorLogin - The name of the SQL administrator.
	AdministratorLogin *string `json:"administratorLogin,omitempty"`
	// AdministratorLoginPassword - The password of the SQL administrator.
	AdministratorLoginPassword *string `json:"administratorLoginPassword,omitempty"`
	// AuthenticationType - The authentication type. Possible values include: 'SQL', 'ADPassword'
	AuthenticationType AuthenticationType `json:"authenticationType,omitempty"`
}

// ExtendedDatabaseBlobAuditingPolicy an extended database blob auditing policy.
type ExtendedDatabaseBlobAuditingPolicy struct {
	autorest.Response `json:"-"`
	// ExtendedDatabaseBlobAuditingPolicyProperties - Resource properties.
	*ExtendedDatabaseBlobAuditingPolicyProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ExtendedDatabaseBlobAuditingPolicy.
func (edbap ExtendedDatabaseBlobAuditingPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if edbap.ExtendedDatabaseBlobAuditingPolicyProperties != nil {
		objectMap["properties"] = edbap.ExtendedDatabaseBlobAuditingPolicyProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ExtendedDatabaseBlobAuditingPolicy struct.
func (edbap *ExtendedDatabaseBlobAuditingPolicy) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var extendedDatabaseBlobAuditingPolicyProperties ExtendedDatabaseBlobAuditingPolicyProperties
				err = json.Unmarshal(*v, &extendedDatabaseBlobAuditingPolicyProperties)
				if err != nil {
					return err
				}
				edbap.ExtendedDatabaseBlobAuditingPolicyProperties = &extendedDatabaseBlobAuditingPolicyProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				edbap.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				edbap.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				edbap.Type = &typeVar
			}
		}
	}

	return nil
}

// ExtendedDatabaseBlobAuditingPolicyListResult a list of database extended auditing settings.
type ExtendedDatabaseBlobAuditingPolicyListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]ExtendedDatabaseBlobAuditingPolicy `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ExtendedDatabaseBlobAuditingPolicyListResultIterator provides access to a complete listing of
// ExtendedDatabaseBlobAuditingPolicy values.
type ExtendedDatabaseBlobAuditingPolicyListResultIterator struct {
	i    int
	page ExtendedDatabaseBlobAuditingPolicyListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ExtendedDatabaseBlobAuditingPolicyListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ExtendedDatabaseBlobAuditingPolicyListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ExtendedDatabaseBlobAuditingPolicyListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ExtendedDatabaseBlobAuditingPolicyListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ExtendedDatabaseBlobAuditingPolicyListResultIterator) Response() ExtendedDatabaseBlobAuditingPolicyListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ExtendedDatabaseBlobAuditingPolicyListResultIterator) Value() ExtendedDatabaseBlobAuditingPolicy {
	if !iter.page.NotDone() {
		return ExtendedDatabaseBlobAuditingPolicy{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ExtendedDatabaseBlobAuditingPolicyListResultIterator type.
func NewExtendedDatabaseBlobAuditingPolicyListResultIterator(page ExtendedDatabaseBlobAuditingPolicyListResultPage) ExtendedDatabaseBlobAuditingPolicyListResultIterator {
	return ExtendedDatabaseBlobAuditingPolicyListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (edbaplr ExtendedDatabaseBlobAuditingPolicyListResult) IsEmpty() bool {
	return edbaplr.Value == nil || len(*edbaplr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (edbaplr ExtendedDatabaseBlobAuditingPolicyListResult) hasNextLink() bool {
	return edbaplr.NextLink != nil && len(*edbaplr.NextLink) != 0
}

// extendedDatabaseBlobAuditingPolicyListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (edbaplr ExtendedDatabaseBlobAuditingPolicyListResult) extendedDatabaseBlobAuditingPolicyListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !edbaplr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(edbaplr.NextLink)))
}

// ExtendedDatabaseBlobAuditingPolicyListResultPage contains a page of ExtendedDatabaseBlobAuditingPolicy
// values.
type ExtendedDatabaseBlobAuditingPolicyListResultPage struct {
	fn      func(context.Context, ExtendedDatabaseBlobAuditingPolicyListResult) (ExtendedDatabaseBlobAuditingPolicyListResult, error)
	edbaplr ExtendedDatabaseBlobAuditingPolicyListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ExtendedDatabaseBlobAuditingPolicyListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ExtendedDatabaseBlobAuditingPolicyListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.edbaplr)
		if err != nil {
			return err
		}
		page.edbaplr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ExtendedDatabaseBlobAuditingPolicyListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ExtendedDatabaseBlobAuditingPolicyListResultPage) NotDone() bool {
	return !page.edbaplr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ExtendedDatabaseBlobAuditingPolicyListResultPage) Response() ExtendedDatabaseBlobAuditingPolicyListResult {
	return page.edbaplr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ExtendedDatabaseBlobAuditingPolicyListResultPage) Values() []ExtendedDatabaseBlobAuditingPolicy {
	if page.edbaplr.IsEmpty() {
		return nil
	}
	return *page.edbaplr.Value
}

// Creates a new instance of the ExtendedDatabaseBlobAuditingPolicyListResultPage type.
func NewExtendedDatabaseBlobAuditingPolicyListResultPage(getNextPage func(context.Context, ExtendedDatabaseBlobAuditingPolicyListResult) (ExtendedDatabaseBlobAuditingPolicyListResult, error)) ExtendedDatabaseBlobAuditingPolicyListResultPage {
	return ExtendedDatabaseBlobAuditingPolicyListResultPage{fn: getNextPage}
}

// ExtendedDatabaseBlobAuditingPolicyProperties properties of an extended database blob auditing policy.
type ExtendedDatabaseBlobAuditingPolicyProperties struct {
	// PredicateExpression - Specifies condition of where clause when creating an audit.
	PredicateExpression *string `json:"predicateExpression,omitempty"`
	// State - Specifies the state of the policy. If state is Enabled, storageEndpoint or isAzureMonitorTargetEnabled are required. Possible values include: 'BlobAuditingPolicyStateEnabled', 'BlobAuditingPolicyStateDisabled'
	State BlobAuditingPolicyState `json:"state,omitempty"`
	// StorageEndpoint - Specifies the blob storage endpoint (e.g. https://MyAccount.blob.core.windows.net). If state is Enabled, storageEndpoint or isAzureMonitorTargetEnabled is required.
	StorageEndpoint *string `json:"storageEndpoint,omitempty"`
	// StorageAccountAccessKey - Specifies the identifier key of the auditing storage account.
	// If state is Enabled and storageEndpoint is specified, not specifying the storageAccountAccessKey will use SQL server system-assigned managed identity to access the storage.
	// Prerequisites for using managed identity authentication:
	// 1. Assign SQL Server a system-assigned managed identity in Azure Active Directory (AAD).
	// 2. Grant SQL Server identity access to the storage account by adding 'Storage Blob Data Contributor' RBAC role to the server identity.
	// For more information, see [Auditing to storage using Managed Identity authentication](https://go.microsoft.com/fwlink/?linkid=2114355)
	StorageAccountAccessKey *string `json:"storageAccountAccessKey,omitempty"`
	// RetentionDays - Specifies the number of days to keep in the audit logs in the storage account.
	RetentionDays *int32 `json:"retentionDays,omitempty"`
	// AuditActionsAndGroups - Specifies the Actions-Groups and Actions to audit.
	//
	// The recommended set of action groups to use is the following combination - this will audit all the queries and stored procedures executed against the database, as well as successful and failed logins:
	//
	// BATCH_COMPLETED_GROUP,
	// SUCCESSFUL_DATABASE_AUTHENTICATION_GROUP,
	// FAILED_DATABASE_AUTHENTICATION_GROUP.
	//
	// This above combination is also the set that is configured by default when enabling auditing from the Azure portal.
	//
	// The supported action groups to audit are (note: choose only specific groups that cover your auditing needs. Using unnecessary groups could lead to very large quantities of audit records):
	//
	// APPLICATION_ROLE_CHANGE_PASSWORD_GROUP
	// BACKUP_RESTORE_GROUP
	// DATABASE_LOGOUT_GROUP
	// DATABASE_OBJECT_CHANGE_GROUP
	// DATABASE_OBJECT_OWNERSHIP_CHANGE_GROUP
	// DATABASE_OBJECT_PERMISSION_CHANGE_GROUP
	// DATABASE_OPERATION_GROUP
	// DATABASE_PERMISSION_CHANGE_GROUP
	// DATABASE_PRINCIPAL_CHANGE_GROUP
	// DATABASE_PRINCIPAL_IMPERSONATION_GROUP
	// DATABASE_ROLE_MEMBER_CHANGE_GROUP
	// FAILED_DATABASE_AUTHENTICATION_GROUP
	// SCHEMA_OBJECT_ACCESS_GROUP
	// SCHEMA_OBJECT_CHANGE_GROUP
	// SCHEMA_OBJECT_OWNERSHIP_CHANGE_GROUP
	// SCHEMA_OBJECT_PERMISSION_CHANGE_GROUP
	// SUCCESSFUL_DATABASE_AUTHENTICATION_GROUP
	// USER_CHANGE_PASSWORD_GROUP
	// BATCH_STARTED_GROUP
	// BATCH_COMPLETED_GROUP
	//
	// These are groups that cover all sql statements and stored procedures executed against the database, and should not be used in combination with other groups as this will result in duplicate audit logs.
	//
	// For more information, see [Database-Level Audit Action Groups](https://docs.microsoft.com/en-us/sql/relational-databases/security/auditing/sql-server-audit-action-groups-and-actions#database-level-audit-action-groups).
	//
	// For Database auditing policy, specific Actions can also be specified (note that Actions cannot be specified for Server auditing policy). The supported actions to audit are:
	// SELECT
	// UPDATE
	// INSERT
	// DELETE
	// EXECUTE
	// RECEIVE
	// REFERENCES
	//
	// The general form for defining an action to be audited is:
	// {action} ON {object} BY {principal}
	//
	// Note that <object> in the above format can refer to an object like a table, view, or stored procedure, or an entire database or schema. For the latter cases, the forms DATABASE::{db_name} and SCHEMA::{schema_name} are used, respectively.
	//
	// For example:
	// SELECT on dbo.myTable by public
	// SELECT on DATABASE::myDatabase by public
	// SELECT on SCHEMA::mySchema by public
	//
	// For more information, see [Database-Level Audit Actions](https://docs.microsoft.com/en-us/sql/relational-databases/security/auditing/sql-server-audit-action-groups-and-actions#database-level-audit-actions)
	AuditActionsAndGroups *[]string `json:"auditActionsAndGroups,omitempty"`
	// StorageAccountSubscriptionID - Specifies the blob storage subscription Id.
	StorageAccountSubscriptionID *uuid.UUID `json:"storageAccountSubscriptionId,omitempty"`
	// IsStorageSecondaryKeyInUse - Specifies whether storageAccountAccessKey value is the storage's secondary key.
	IsStorageSecondaryKeyInUse *bool `json:"isStorageSecondaryKeyInUse,omitempty"`
	// IsAzureMonitorTargetEnabled - Specifies whether audit events are sent to Azure Monitor.
	// In order to send the events to Azure Monitor, specify 'state' as 'Enabled' and 'isAzureMonitorTargetEnabled' as true.
	//
	// When using REST API to configure auditing, Diagnostic Settings with 'SQLSecurityAuditEvents' diagnostic logs category on the database should be also created.
	// Note that for server level audit you should use the 'master' database as {databaseName}.
	//
	// Diagnostic Settings URI format:
	// PUT https://management.azure.com/subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/providers/microsoft.insights/diagnosticSettings/{settingsName}?api-version=2017-05-01-preview
	//
	// For more information, see [Diagnostic Settings REST API](https://go.microsoft.com/fwlink/?linkid=2033207)
	// or [Diagnostic Settings PowerShell](https://go.microsoft.com/fwlink/?linkid=2033043)
	IsAzureMonitorTargetEnabled *bool `json:"isAzureMonitorTargetEnabled,omitempty"`
	// QueueDelayMs - Specifies the amount of time in milliseconds that can elapse before audit actions are forced to be processed.
	// The default minimum value is 1000 (1 second). The maximum is 2,147,483,647.
	QueueDelayMs *int32 `json:"queueDelayMs,omitempty"`
}

// ExtendedServerBlobAuditingPoliciesCreateOrUpdateFuture an abstraction for monitoring and retrieving the
// results of a long-running operation.
type ExtendedServerBlobAuditingPoliciesCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ExtendedServerBlobAuditingPoliciesCreateOrUpdateFuture) Result(client ExtendedServerBlobAuditingPoliciesClient) (esbap ExtendedServerBlobAuditingPolicy, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.ExtendedServerBlobAuditingPoliciesCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.ExtendedServerBlobAuditingPoliciesCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if esbap.Response.Response, err = future.GetResult(sender); err == nil && esbap.Response.Response.StatusCode != http.StatusNoContent {
		esbap, err = client.CreateOrUpdateResponder(esbap.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.ExtendedServerBlobAuditingPoliciesCreateOrUpdateFuture", "Result", esbap.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ExtendedServerBlobAuditingPolicy an extended server blob auditing policy.
type ExtendedServerBlobAuditingPolicy struct {
	autorest.Response `json:"-"`
	// ExtendedServerBlobAuditingPolicyProperties - Resource properties.
	*ExtendedServerBlobAuditingPolicyProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ExtendedServerBlobAuditingPolicy.
func (esbap ExtendedServerBlobAuditingPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if esbap.ExtendedServerBlobAuditingPolicyProperties != nil {
		objectMap["properties"] = esbap.ExtendedServerBlobAuditingPolicyProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ExtendedServerBlobAuditingPolicy struct.
func (esbap *ExtendedServerBlobAuditingPolicy) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var extendedServerBlobAuditingPolicyProperties ExtendedServerBlobAuditingPolicyProperties
				err = json.Unmarshal(*v, &extendedServerBlobAuditingPolicyProperties)
				if err != nil {
					return err
				}
				esbap.ExtendedServerBlobAuditingPolicyProperties = &extendedServerBlobAuditingPolicyProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				esbap.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				esbap.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				esbap.Type = &typeVar
			}
		}
	}

	return nil
}

// ExtendedServerBlobAuditingPolicyListResult a list of server extended auditing settings.
type ExtendedServerBlobAuditingPolicyListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]ExtendedServerBlobAuditingPolicy `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ExtendedServerBlobAuditingPolicyListResultIterator provides access to a complete listing of
// ExtendedServerBlobAuditingPolicy values.
type ExtendedServerBlobAuditingPolicyListResultIterator struct {
	i    int
	page ExtendedServerBlobAuditingPolicyListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ExtendedServerBlobAuditingPolicyListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ExtendedServerBlobAuditingPolicyListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ExtendedServerBlobAuditingPolicyListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ExtendedServerBlobAuditingPolicyListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ExtendedServerBlobAuditingPolicyListResultIterator) Response() ExtendedServerBlobAuditingPolicyListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ExtendedServerBlobAuditingPolicyListResultIterator) Value() ExtendedServerBlobAuditingPolicy {
	if !iter.page.NotDone() {
		return ExtendedServerBlobAuditingPolicy{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ExtendedServerBlobAuditingPolicyListResultIterator type.
func NewExtendedServerBlobAuditingPolicyListResultIterator(page ExtendedServerBlobAuditingPolicyListResultPage) ExtendedServerBlobAuditingPolicyListResultIterator {
	return ExtendedServerBlobAuditingPolicyListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (esbaplr ExtendedServerBlobAuditingPolicyListResult) IsEmpty() bool {
	return esbaplr.Value == nil || len(*esbaplr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (esbaplr ExtendedServerBlobAuditingPolicyListResult) hasNextLink() bool {
	return esbaplr.NextLink != nil && len(*esbaplr.NextLink) != 0
}

// extendedServerBlobAuditingPolicyListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (esbaplr ExtendedServerBlobAuditingPolicyListResult) extendedServerBlobAuditingPolicyListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !esbaplr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(esbaplr.NextLink)))
}

// ExtendedServerBlobAuditingPolicyListResultPage contains a page of ExtendedServerBlobAuditingPolicy values.
type ExtendedServerBlobAuditingPolicyListResultPage struct {
	fn      func(context.Context, ExtendedServerBlobAuditingPolicyListResult) (ExtendedServerBlobAuditingPolicyListResult, error)
	esbaplr ExtendedServerBlobAuditingPolicyListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ExtendedServerBlobAuditingPolicyListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ExtendedServerBlobAuditingPolicyListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.esbaplr)
		if err != nil {
			return err
		}
		page.esbaplr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ExtendedServerBlobAuditingPolicyListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ExtendedServerBlobAuditingPolicyListResultPage) NotDone() bool {
	return !page.esbaplr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ExtendedServerBlobAuditingPolicyListResultPage) Response() ExtendedServerBlobAuditingPolicyListResult {
	return page.esbaplr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ExtendedServerBlobAuditingPolicyListResultPage) Values() []ExtendedServerBlobAuditingPolicy {
	if page.esbaplr.IsEmpty() {
		return nil
	}
	return *page.esbaplr.Value
}

// Creates a new instance of the ExtendedServerBlobAuditingPolicyListResultPage type.
func NewExtendedServerBlobAuditingPolicyListResultPage(getNextPage func(context.Context, ExtendedServerBlobAuditingPolicyListResult) (ExtendedServerBlobAuditingPolicyListResult, error)) ExtendedServerBlobAuditingPolicyListResultPage {
	return ExtendedServerBlobAuditingPolicyListResultPage{fn: getNextPage}
}

// ExtendedServerBlobAuditingPolicyProperties properties of an extended server blob auditing policy.
type ExtendedServerBlobAuditingPolicyProperties struct {
	// PredicateExpression - Specifies condition of where clause when creating an audit.
	PredicateExpression *string `json:"predicateExpression,omitempty"`
	// State - Specifies the state of the policy. If state is Enabled, storageEndpoint or isAzureMonitorTargetEnabled are required. Possible values include: 'BlobAuditingPolicyStateEnabled', 'BlobAuditingPolicyStateDisabled'
	State BlobAuditingPolicyState `json:"state,omitempty"`
	// StorageEndpoint - Specifies the blob storage endpoint (e.g. https://MyAccount.blob.core.windows.net). If state is Enabled, storageEndpoint or isAzureMonitorTargetEnabled is required.
	StorageEndpoint *string `json:"storageEndpoint,omitempty"`
	// StorageAccountAccessKey - Specifies the identifier key of the auditing storage account.
	// If state is Enabled and storageEndpoint is specified, not specifying the storageAccountAccessKey will use SQL server system-assigned managed identity to access the storage.
	// Prerequisites for using managed identity authentication:
	// 1. Assign SQL Server a system-assigned managed identity in Azure Active Directory (AAD).
	// 2. Grant SQL Server identity access to the storage account by adding 'Storage Blob Data Contributor' RBAC role to the server identity.
	// For more information, see [Auditing to storage using Managed Identity authentication](https://go.microsoft.com/fwlink/?linkid=2114355)
	StorageAccountAccessKey *string `json:"storageAccountAccessKey,omitempty"`
	// RetentionDays - Specifies the number of days to keep in the audit logs in the storage account.
	RetentionDays *int32 `json:"retentionDays,omitempty"`
	// AuditActionsAndGroups - Specifies the Actions-Groups and Actions to audit.
	//
	// The recommended set of action groups to use is the following combination - this will audit all the queries and stored procedures executed against the database, as well as successful and failed logins:
	//
	// BATCH_COMPLETED_GROUP,
	// SUCCESSFUL_DATABASE_AUTHENTICATION_GROUP,
	// FAILED_DATABASE_AUTHENTICATION_GROUP.
	//
	// This above combination is also the set that is configured by default when enabling auditing from the Azure portal.
	//
	// The supported action groups to audit are (note: choose only specific groups that cover your auditing needs. Using unnecessary groups could lead to very large quantities of audit records):
	//
	// APPLICATION_ROLE_CHANGE_PASSWORD_GROUP
	// BACKUP_RESTORE_GROUP
	// DATABASE_LOGOUT_GROUP
	// DATABASE_OBJECT_CHANGE_GROUP
	// DATABASE_OBJECT_OWNERSHIP_CHANGE_GROUP
	// DATABASE_OBJECT_PERMISSION_CHANGE_GROUP
	// DATABASE_OPERATION_GROUP
	// DATABASE_PERMISSION_CHANGE_GROUP
	// DATABASE_PRINCIPAL_CHANGE_GROUP
	// DATABASE_PRINCIPAL_IMPERSONATION_GROUP
	// DATABASE_ROLE_MEMBER_CHANGE_GROUP
	// FAILED_DATABASE_AUTHENTICATION_GROUP
	// SCHEMA_OBJECT_ACCESS_GROUP
	// SCHEMA_OBJECT_CHANGE_GROUP
	// SCHEMA_OBJECT_OWNERSHIP_CHANGE_GROUP
	// SCHEMA_OBJECT_PERMISSION_CHANGE_GROUP
	// SUCCESSFUL_DATABASE_AUTHENTICATION_GROUP
	// USER_CHANGE_PASSWORD_GROUP
	// BATCH_STARTED_GROUP
	// BATCH_COMPLETED_GROUP
	//
	// These are groups that cover all sql statements and stored procedures executed against the database, and should not be used in combination with other groups as this will result in duplicate audit logs.
	//
	// For more information, see [Database-Level Audit Action Groups](https://docs.microsoft.com/en-us/sql/relational-databases/security/auditing/sql-server-audit-action-groups-and-actions#database-level-audit-action-groups).
	//
	// For Database auditing policy, specific Actions can also be specified (note that Actions cannot be specified for Server auditing policy). The supported actions to audit are:
	// SELECT
	// UPDATE
	// INSERT
	// DELETE
	// EXECUTE
	// RECEIVE
	// REFERENCES
	//
	// The general form for defining an action to be audited is:
	// {action} ON {object} BY {principal}
	//
	// Note that <object> in the above format can refer to an object like a table, view, or stored procedure, or an entire database or schema. For the latter cases, the forms DATABASE::{db_name} and SCHEMA::{schema_name} are used, respectively.
	//
	// For example:
	// SELECT on dbo.myTable by public
	// SELECT on DATABASE::myDatabase by public
	// SELECT on SCHEMA::mySchema by public
	//
	// For more information, see [Database-Level Audit Actions](https://docs.microsoft.com/en-us/sql/relational-databases/security/auditing/sql-server-audit-action-groups-and-actions#database-level-audit-actions)
	AuditActionsAndGroups *[]string `json:"auditActionsAndGroups,omitempty"`
	// StorageAccountSubscriptionID - Specifies the blob storage subscription Id.
	StorageAccountSubscriptionID *uuid.UUID `json:"storageAccountSubscriptionId,omitempty"`
	// IsStorageSecondaryKeyInUse - Specifies whether storageAccountAccessKey value is the storage's secondary key.
	IsStorageSecondaryKeyInUse *bool `json:"isStorageSecondaryKeyInUse,omitempty"`
	// IsAzureMonitorTargetEnabled - Specifies whether audit events are sent to Azure Monitor.
	// In order to send the events to Azure Monitor, specify 'state' as 'Enabled' and 'isAzureMonitorTargetEnabled' as true.
	//
	// When using REST API to configure auditing, Diagnostic Settings with 'SQLSecurityAuditEvents' diagnostic logs category on the database should be also created.
	// Note that for server level audit you should use the 'master' database as {databaseName}.
	//
	// Diagnostic Settings URI format:
	// PUT https://management.azure.com/subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/providers/microsoft.insights/diagnosticSettings/{settingsName}?api-version=2017-05-01-preview
	//
	// For more information, see [Diagnostic Settings REST API](https://go.microsoft.com/fwlink/?linkid=2033207)
	// or [Diagnostic Settings PowerShell](https://go.microsoft.com/fwlink/?linkid=2033043)
	IsAzureMonitorTargetEnabled *bool `json:"isAzureMonitorTargetEnabled,omitempty"`
	// QueueDelayMs - Specifies the amount of time in milliseconds that can elapse before audit actions are forced to be processed.
	// The default minimum value is 1000 (1 second). The maximum is 2,147,483,647.
	QueueDelayMs *int32 `json:"queueDelayMs,omitempty"`
}

// FailoverGroup a failover group.
type FailoverGroup struct {
	autorest.Response `json:"-"`
	// Location - READ-ONLY; Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// FailoverGroupProperties - Resource properties.
	*FailoverGroupProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for FailoverGroup.
func (fg FailoverGroup) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if fg.Tags != nil {
		objectMap["tags"] = fg.Tags
	}
	if fg.FailoverGroupProperties != nil {
		objectMap["properties"] = fg.FailoverGroupProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for FailoverGroup struct.
func (fg *FailoverGroup) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				fg.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				fg.Tags = tags
			}
		case "properties":
			if v != nil {
				var failoverGroupProperties FailoverGroupProperties
				err = json.Unmarshal(*v, &failoverGroupProperties)
				if err != nil {
					return err
				}
				fg.FailoverGroupProperties = &failoverGroupProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				fg.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				fg.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				fg.Type = &typeVar
			}
		}
	}

	return nil
}

// FailoverGroupListResult a list of failover groups.
type FailoverGroupListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]FailoverGroup `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// FailoverGroupListResultIterator provides access to a complete listing of FailoverGroup values.
type FailoverGroupListResultIterator struct {
	i    int
	page FailoverGroupListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *FailoverGroupListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/FailoverGroupListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *FailoverGroupListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter FailoverGroupListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter FailoverGroupListResultIterator) Response() FailoverGroupListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter FailoverGroupListResultIterator) Value() FailoverGroup {
	if !iter.page.NotDone() {
		return FailoverGroup{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the FailoverGroupListResultIterator type.
func NewFailoverGroupListResultIterator(page FailoverGroupListResultPage) FailoverGroupListResultIterator {
	return FailoverGroupListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (fglr FailoverGroupListResult) IsEmpty() bool {
	return fglr.Value == nil || len(*fglr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (fglr FailoverGroupListResult) hasNextLink() bool {
	return fglr.NextLink != nil && len(*fglr.NextLink) != 0
}

// failoverGroupListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (fglr FailoverGroupListResult) failoverGroupListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !fglr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(fglr.NextLink)))
}

// FailoverGroupListResultPage contains a page of FailoverGroup values.
type FailoverGroupListResultPage struct {
	fn   func(context.Context, FailoverGroupListResult) (FailoverGroupListResult, error)
	fglr FailoverGroupListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *FailoverGroupListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/FailoverGroupListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.fglr)
		if err != nil {
			return err
		}
		page.fglr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *FailoverGroupListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page FailoverGroupListResultPage) NotDone() bool {
	return !page.fglr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page FailoverGroupListResultPage) Response() FailoverGroupListResult {
	return page.fglr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page FailoverGroupListResultPage) Values() []FailoverGroup {
	if page.fglr.IsEmpty() {
		return nil
	}
	return *page.fglr.Value
}

// Creates a new instance of the FailoverGroupListResultPage type.
func NewFailoverGroupListResultPage(getNextPage func(context.Context, FailoverGroupListResult) (FailoverGroupListResult, error)) FailoverGroupListResultPage {
	return FailoverGroupListResultPage{fn: getNextPage}
}

// FailoverGroupProperties properties of a failover group.
type FailoverGroupProperties struct {
	// ReadWriteEndpoint - Read-write endpoint of the failover group instance.
	ReadWriteEndpoint *FailoverGroupReadWriteEndpoint `json:"readWriteEndpoint,omitempty"`
	// ReadOnlyEndpoint - Read-only endpoint of the failover group instance.
	ReadOnlyEndpoint *FailoverGroupReadOnlyEndpoint `json:"readOnlyEndpoint,omitempty"`
	// ReplicationRole - READ-ONLY; Local replication role of the failover group instance. Possible values include: 'Primary', 'Secondary'
	ReplicationRole FailoverGroupReplicationRole `json:"replicationRole,omitempty"`
	// ReplicationState - READ-ONLY; Replication state of the failover group instance.
	ReplicationState *string `json:"replicationState,omitempty"`
	// PartnerServers - List of partner server information for the failover group.
	PartnerServers *[]PartnerInfo `json:"partnerServers,omitempty"`
	// Databases - List of databases in the failover group.
	Databases *[]string `json:"databases,omitempty"`
}

// MarshalJSON is the custom marshaler for FailoverGroupProperties.
func (fgp FailoverGroupProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if fgp.ReadWriteEndpoint != nil {
		objectMap["readWriteEndpoint"] = fgp.ReadWriteEndpoint
	}
	if fgp.ReadOnlyEndpoint != nil {
		objectMap["readOnlyEndpoint"] = fgp.ReadOnlyEndpoint
	}
	if fgp.PartnerServers != nil {
		objectMap["partnerServers"] = fgp.PartnerServers
	}
	if fgp.Databases != nil {
		objectMap["databases"] = fgp.Databases
	}
	return json.Marshal(objectMap)
}

// FailoverGroupReadOnlyEndpoint read-only endpoint of the failover group instance.
type FailoverGroupReadOnlyEndpoint struct {
	// FailoverPolicy - Failover policy of the read-only endpoint for the failover group. Possible values include: 'ReadOnlyEndpointFailoverPolicyDisabled', 'ReadOnlyEndpointFailoverPolicyEnabled'
	FailoverPolicy ReadOnlyEndpointFailoverPolicy `json:"failoverPolicy,omitempty"`
}

// FailoverGroupReadWriteEndpoint read-write endpoint of the failover group instance.
type FailoverGroupReadWriteEndpoint struct {
	// FailoverPolicy - Failover policy of the read-write endpoint for the failover group. If failoverPolicy is Automatic then failoverWithDataLossGracePeriodMinutes is required. Possible values include: 'Manual', 'Automatic'
	FailoverPolicy ReadWriteEndpointFailoverPolicy `json:"failoverPolicy,omitempty"`
	// FailoverWithDataLossGracePeriodMinutes - Grace period before failover with data loss is attempted for the read-write endpoint. If failoverPolicy is Automatic then failoverWithDataLossGracePeriodMinutes is required.
	FailoverWithDataLossGracePeriodMinutes *int32 `json:"failoverWithDataLossGracePeriodMinutes,omitempty"`
}

// FailoverGroupsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type FailoverGroupsCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *FailoverGroupsCreateOrUpdateFuture) Result(client FailoverGroupsClient) (fg FailoverGroup, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.FailoverGroupsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.FailoverGroupsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if fg.Response.Response, err = future.GetResult(sender); err == nil && fg.Response.Response.StatusCode != http.StatusNoContent {
		fg, err = client.CreateOrUpdateResponder(fg.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.FailoverGroupsCreateOrUpdateFuture", "Result", fg.Response.Response, "Failure responding to request")
		}
	}
	return
}

// FailoverGroupsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type FailoverGroupsDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *FailoverGroupsDeleteFuture) Result(client FailoverGroupsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.FailoverGroupsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.FailoverGroupsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// FailoverGroupsFailoverFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type FailoverGroupsFailoverFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *FailoverGroupsFailoverFuture) Result(client FailoverGroupsClient) (fg FailoverGroup, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.FailoverGroupsFailoverFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.FailoverGroupsFailoverFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if fg.Response.Response, err = future.GetResult(sender); err == nil && fg.Response.Response.StatusCode != http.StatusNoContent {
		fg, err = client.FailoverResponder(fg.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.FailoverGroupsFailoverFuture", "Result", fg.Response.Response, "Failure responding to request")
		}
	}
	return
}

// FailoverGroupsForceFailoverAllowDataLossFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type FailoverGroupsForceFailoverAllowDataLossFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *FailoverGroupsForceFailoverAllowDataLossFuture) Result(client FailoverGroupsClient) (fg FailoverGroup, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.FailoverGroupsForceFailoverAllowDataLossFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.FailoverGroupsForceFailoverAllowDataLossFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if fg.Response.Response, err = future.GetResult(sender); err == nil && fg.Response.Response.StatusCode != http.StatusNoContent {
		fg, err = client.ForceFailoverAllowDataLossResponder(fg.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.FailoverGroupsForceFailoverAllowDataLossFuture", "Result", fg.Response.Response, "Failure responding to request")
		}
	}
	return
}

// FailoverGroupsUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type FailoverGroupsUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *FailoverGroupsUpdateFuture) Result(client FailoverGroupsClient) (fg FailoverGroup, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.FailoverGroupsUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.FailoverGroupsUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if fg.Response.Response, err = future.GetResult(sender); err == nil && fg.Response.Response.StatusCode != http.StatusNoContent {
		fg, err = client.UpdateResponder(fg.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.FailoverGroupsUpdateFuture", "Result", fg.Response.Response, "Failure responding to request")
		}
	}
	return
}

// FailoverGroupUpdate a failover group update request.
type FailoverGroupUpdate struct {
	// FailoverGroupUpdateProperties - Resource properties.
	*FailoverGroupUpdateProperties `json:"properties,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for FailoverGroupUpdate.
func (fgu FailoverGroupUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if fgu.FailoverGroupUpdateProperties != nil {
		objectMap["properties"] = fgu.FailoverGroupUpdateProperties
	}
	if fgu.Tags != nil {
		objectMap["tags"] = fgu.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for FailoverGroupUpdate struct.
func (fgu *FailoverGroupUpdate) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var failoverGroupUpdateProperties FailoverGroupUpdateProperties
				err = json.Unmarshal(*v, &failoverGroupUpdateProperties)
				if err != nil {
					return err
				}
				fgu.FailoverGroupUpdateProperties = &failoverGroupUpdateProperties
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				fgu.Tags = tags
			}
		}
	}

	return nil
}

// FailoverGroupUpdateProperties properties of a failover group update.
type FailoverGroupUpdateProperties struct {
	// ReadWriteEndpoint - Read-write endpoint of the failover group instance.
	ReadWriteEndpoint *FailoverGroupReadWriteEndpoint `json:"readWriteEndpoint,omitempty"`
	// ReadOnlyEndpoint - Read-only endpoint of the failover group instance.
	ReadOnlyEndpoint *FailoverGroupReadOnlyEndpoint `json:"readOnlyEndpoint,omitempty"`
	// Databases - List of databases in the failover group.
	Databases *[]string `json:"databases,omitempty"`
}

// FirewallRule represents a server firewall rule.
type FirewallRule struct {
	autorest.Response `json:"-"`
	// Kind - READ-ONLY; Kind of server that contains this firewall rule.
	Kind *string `json:"kind,omitempty"`
	// Location - READ-ONLY; Location of the server that contains this firewall rule.
	Location *string `json:"location,omitempty"`
	// FirewallRuleProperties - The properties representing the resource.
	*FirewallRuleProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for FirewallRule.
func (fr FirewallRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if fr.FirewallRuleProperties != nil {
		objectMap["properties"] = fr.FirewallRuleProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for FirewallRule struct.
func (fr *FirewallRule) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				fr.Kind = &kind
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				fr.Location = &location
			}
		case "properties":
			if v != nil {
				var firewallRuleProperties FirewallRuleProperties
				err = json.Unmarshal(*v, &firewallRuleProperties)
				if err != nil {
					return err
				}
				fr.FirewallRuleProperties = &firewallRuleProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				fr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				fr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				fr.Type = &typeVar
			}
		}
	}

	return nil
}

// FirewallRuleListResult represents the response to a List Firewall Rules request.
type FirewallRuleListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of server firewall rules.
	Value *[]FirewallRule `json:"value,omitempty"`
}

// FirewallRuleProperties represents the properties of a server firewall rule.
type FirewallRuleProperties struct {
	// StartIPAddress - The start IP address of the firewall rule. Must be IPv4 format. Use value '0.0.0.0' to represent all Azure-internal IP addresses.
	StartIPAddress *string `json:"startIpAddress,omitempty"`
	// EndIPAddress - The end IP address of the firewall rule. Must be IPv4 format. Must be greater than or equal to startIpAddress. Use value '0.0.0.0' to represent all Azure-internal IP addresses.
	EndIPAddress *string `json:"endIpAddress,omitempty"`
}

// GeoBackupPolicy a database geo backup policy.
type GeoBackupPolicy struct {
	autorest.Response `json:"-"`
	// GeoBackupPolicyProperties - The properties of the geo backup policy.
	*GeoBackupPolicyProperties `json:"properties,omitempty"`
	// Kind - READ-ONLY; Kind of geo backup policy.  This is metadata used for the Azure portal experience.
	Kind *string `json:"kind,omitempty"`
	// Location - READ-ONLY; Backup policy location.
	Location *string `json:"location,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for GeoBackupPolicy.
func (gbp GeoBackupPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if gbp.GeoBackupPolicyProperties != nil {
		objectMap["properties"] = gbp.GeoBackupPolicyProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for GeoBackupPolicy struct.
func (gbp *GeoBackupPolicy) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var geoBackupPolicyProperties GeoBackupPolicyProperties
				err = json.Unmarshal(*v, &geoBackupPolicyProperties)
				if err != nil {
					return err
				}
				gbp.GeoBackupPolicyProperties = &geoBackupPolicyProperties
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				gbp.Kind = &kind
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				gbp.Location = &location
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				gbp.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				gbp.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				gbp.Type = &typeVar
			}
		}
	}

	return nil
}

// GeoBackupPolicyListResult the response to a list geo backup policies request.
type GeoBackupPolicyListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of geo backup policies.
	Value *[]GeoBackupPolicy `json:"value,omitempty"`
}

// GeoBackupPolicyProperties the properties of the geo backup policy.
type GeoBackupPolicyProperties struct {
	// State - The state of the geo backup policy. Possible values include: 'GeoBackupPolicyStateDisabled', 'GeoBackupPolicyStateEnabled'
	State GeoBackupPolicyState `json:"state,omitempty"`
	// StorageType - READ-ONLY; The storage type of the geo backup policy.
	StorageType *string `json:"storageType,omitempty"`
}

// MarshalJSON is the custom marshaler for GeoBackupPolicyProperties.
func (gbpp GeoBackupPolicyProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if gbpp.State != "" {
		objectMap["state"] = gbpp.State
	}
	return json.Marshal(objectMap)
}

// ImportExportResponse response for Import/Export Get operation.
type ImportExportResponse struct {
	autorest.Response `json:"-"`
	// ImportExportResponseProperties - The import/export operation properties.
	*ImportExportResponseProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ImportExportResponse.
func (ier ImportExportResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ier.ImportExportResponseProperties != nil {
		objectMap["properties"] = ier.ImportExportResponseProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ImportExportResponse struct.
func (ier *ImportExportResponse) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var importExportResponseProperties ImportExportResponseProperties
				err = json.Unmarshal(*v, &importExportResponseProperties)
				if err != nil {
					return err
				}
				ier.ImportExportResponseProperties = &importExportResponseProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ier.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ier.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ier.Type = &typeVar
			}
		}
	}

	return nil
}

// ImportExportResponseProperties response for Import/Export Status operation.
type ImportExportResponseProperties struct {
	// RequestType - READ-ONLY; The request type of the operation.
	RequestType *string `json:"requestType,omitempty"`
	// RequestID - READ-ONLY; The request type of the operation.
	RequestID *uuid.UUID `json:"requestId,omitempty"`
	// ServerName - READ-ONLY; The name of the server.
	ServerName *string `json:"serverName,omitempty"`
	// DatabaseName - READ-ONLY; The name of the database.
	DatabaseName *string `json:"databaseName,omitempty"`
	// Status - READ-ONLY; The status message returned from the server.
	Status *string `json:"status,omitempty"`
	// LastModifiedTime - READ-ONLY; The operation status last modified time.
	LastModifiedTime *string `json:"lastModifiedTime,omitempty"`
	// QueuedTime - READ-ONLY; The operation queued time.
	QueuedTime *string `json:"queuedTime,omitempty"`
	// BlobURI - READ-ONLY; The blob uri.
	BlobURI *string `json:"blobUri,omitempty"`
	// ErrorMessage - READ-ONLY; The error message returned from the server.
	ErrorMessage *string `json:"errorMessage,omitempty"`
}

// ImportExtensionProperties represents the properties for an import operation
type ImportExtensionProperties struct {
	// OperationMode - The type of import operation being performed. This is always Import.
	OperationMode *string `json:"operationMode,omitempty"`
	// StorageKeyType - The type of the storage key to use. Possible values include: 'StorageAccessKey', 'SharedAccessKey'
	StorageKeyType StorageKeyType `json:"storageKeyType,omitempty"`
	// StorageKey - The storage key to use.  If storage key type is SharedAccessKey, it must be preceded with a "?."
	StorageKey *string `json:"storageKey,omitempty"`
	// StorageURI - The storage uri to use.
	StorageURI *string `json:"storageUri,omitempty"`
	// AdministratorLogin - The name of the SQL administrator.
	AdministratorLogin *string `json:"administratorLogin,omitempty"`
	// AdministratorLoginPassword - The password of the SQL administrator.
	AdministratorLoginPassword *string `json:"administratorLoginPassword,omitempty"`
	// AuthenticationType - The authentication type. Possible values include: 'SQL', 'ADPassword'
	AuthenticationType AuthenticationType `json:"authenticationType,omitempty"`
}

// ImportExtensionRequest import database parameters.
type ImportExtensionRequest struct {
	// Name - The name of the extension.
	Name *string `json:"name,omitempty"`
	// Type - The type of the extension.
	Type *string `json:"type,omitempty"`
	// ImportExtensionProperties - Represents the properties of the resource.
	*ImportExtensionProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for ImportExtensionRequest.
func (ier ImportExtensionRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ier.Name != nil {
		objectMap["name"] = ier.Name
	}
	if ier.Type != nil {
		objectMap["type"] = ier.Type
	}
	if ier.ImportExtensionProperties != nil {
		objectMap["properties"] = ier.ImportExtensionProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ImportExtensionRequest struct.
func (ier *ImportExtensionRequest) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ier.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ier.Type = &typeVar
			}
		case "properties":
			if v != nil {
				var importExtensionProperties ImportExtensionProperties
				err = json.Unmarshal(*v, &importExtensionProperties)
				if err != nil {
					return err
				}
				ier.ImportExtensionProperties = &importExtensionProperties
			}
		}
	}

	return nil
}

// ImportRequest import database parameters.
type ImportRequest struct {
	// DatabaseName - The name of the database to import.
	DatabaseName *string `json:"databaseName,omitempty"`
	// Edition - The edition for the database being created.
	//
	// The list of SKUs may vary by region and support offer. To determine the SKUs (including the SKU name, tier/edition, family, and capacity) that are available to your subscription in an Azure region, use the `Capabilities_ListByLocation` REST API or one of the following commands:
	//
	// ```azurecli
	// az sql db list-editions -l <location> -o table
	// ````
	//
	// ```powershell
	// Get-AzSqlServerServiceObjective -Location <location>
	// ````
	// . Possible values include: 'Web', 'Business', 'Basic', 'Standard', 'Premium', 'PremiumRS', 'Free', 'Stretch', 'DataWarehouse', 'System', 'System2', 'GeneralPurpose', 'BusinessCritical', 'Hyperscale'
	Edition DatabaseEdition `json:"edition,omitempty"`
	// ServiceObjectiveName - The name of the service objective to assign to the database. Possible values include: 'ServiceObjectiveNameSystem', 'ServiceObjectiveNameSystem0', 'ServiceObjectiveNameSystem1', 'ServiceObjectiveNameSystem2', 'ServiceObjectiveNameSystem3', 'ServiceObjectiveNameSystem4', 'ServiceObjectiveNameSystem2L', 'ServiceObjectiveNameSystem3L', 'ServiceObjectiveNameSystem4L', 'ServiceObjectiveNameFree', 'ServiceObjectiveNameBasic', 'ServiceObjectiveNameS0', 'ServiceObjectiveNameS1', 'ServiceObjectiveNameS2', 'ServiceObjectiveNameS3', 'ServiceObjectiveNameS4', 'ServiceObjectiveNameS6', 'ServiceObjectiveNameS7', 'ServiceObjectiveNameS9', 'ServiceObjectiveNameS12', 'ServiceObjectiveNameP1', 'ServiceObjectiveNameP2', 'ServiceObjectiveNameP3', 'ServiceObjectiveNameP4', 'ServiceObjectiveNameP6', 'ServiceObjectiveNameP11', 'ServiceObjectiveNameP15', 'ServiceObjectiveNamePRS1', 'ServiceObjectiveNamePRS2', 'ServiceObjectiveNamePRS4', 'ServiceObjectiveNamePRS6', 'ServiceObjectiveNameDW100', 'ServiceObjectiveNameDW200', 'ServiceObjectiveNameDW300', 'ServiceObjectiveNameDW400', 'ServiceObjectiveNameDW500', 'ServiceObjectiveNameDW600', 'ServiceObjectiveNameDW1000', 'ServiceObjectiveNameDW1200', 'ServiceObjectiveNameDW1000c', 'ServiceObjectiveNameDW1500', 'ServiceObjectiveNameDW1500c', 'ServiceObjectiveNameDW2000', 'ServiceObjectiveNameDW2000c', 'ServiceObjectiveNameDW3000', 'ServiceObjectiveNameDW2500c', 'ServiceObjectiveNameDW3000c', 'ServiceObjectiveNameDW6000', 'ServiceObjectiveNameDW5000c', 'ServiceObjectiveNameDW6000c', 'ServiceObjectiveNameDW7500c', 'ServiceObjectiveNameDW10000c', 'ServiceObjectiveNameDW15000c', 'ServiceObjectiveNameDW30000c', 'ServiceObjectiveNameDS100', 'ServiceObjectiveNameDS200', 'ServiceObjectiveNameDS300', 'ServiceObjectiveNameDS400', 'ServiceObjectiveNameDS500', 'ServiceObjectiveNameDS600', 'ServiceObjectiveNameDS1000', 'ServiceObjectiveNameDS1200', 'ServiceObjectiveNameDS1500', 'ServiceObjectiveNameDS2000', 'ServiceObjectiveNameElasticPool'
	ServiceObjectiveName ServiceObjectiveName `json:"serviceObjectiveName,omitempty"`
	// MaxSizeBytes - The maximum size for the newly imported database.
	MaxSizeBytes *string `json:"maxSizeBytes,omitempty"`
	// StorageKeyType - The type of the storage key to use. Possible values include: 'StorageAccessKey', 'SharedAccessKey'
	StorageKeyType StorageKeyType `json:"storageKeyType,omitempty"`
	// StorageKey - The storage key to use.  If storage key type is SharedAccessKey, it must be preceded with a "?."
	StorageKey *string `json:"storageKey,omitempty"`
	// StorageURI - The storage uri to use.
	StorageURI *string `json:"storageUri,omitempty"`
	// AdministratorLogin - The name of the SQL administrator.
	AdministratorLogin *string `json:"administratorLogin,omitempty"`
	// AdministratorLoginPassword - The password of the SQL administrator.
	AdministratorLoginPassword *string `json:"administratorLoginPassword,omitempty"`
	// AuthenticationType - The authentication type. Possible values include: 'SQL', 'ADPassword'
	AuthenticationType AuthenticationType `json:"authenticationType,omitempty"`
}

// InstanceFailoverGroup an instance failover group.
type InstanceFailoverGroup struct {
	autorest.Response `json:"-"`
	// InstanceFailoverGroupProperties - Resource properties.
	*InstanceFailoverGroupProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for InstanceFailoverGroup.
func (ifg InstanceFailoverGroup) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ifg.InstanceFailoverGroupProperties != nil {
		objectMap["properties"] = ifg.InstanceFailoverGroupProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for InstanceFailoverGroup struct.
func (ifg *InstanceFailoverGroup) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var instanceFailoverGroupProperties InstanceFailoverGroupProperties
				err = json.Unmarshal(*v, &instanceFailoverGroupProperties)
				if err != nil {
					return err
				}
				ifg.InstanceFailoverGroupProperties = &instanceFailoverGroupProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ifg.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ifg.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ifg.Type = &typeVar
			}
		}
	}

	return nil
}

// InstanceFailoverGroupListResult a list of instance failover groups.
type InstanceFailoverGroupListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]InstanceFailoverGroup `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// InstanceFailoverGroupListResultIterator provides access to a complete listing of InstanceFailoverGroup
// values.
type InstanceFailoverGroupListResultIterator struct {
	i    int
	page InstanceFailoverGroupListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *InstanceFailoverGroupListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/InstanceFailoverGroupListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *InstanceFailoverGroupListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter InstanceFailoverGroupListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter InstanceFailoverGroupListResultIterator) Response() InstanceFailoverGroupListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter InstanceFailoverGroupListResultIterator) Value() InstanceFailoverGroup {
	if !iter.page.NotDone() {
		return InstanceFailoverGroup{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the InstanceFailoverGroupListResultIterator type.
func NewInstanceFailoverGroupListResultIterator(page InstanceFailoverGroupListResultPage) InstanceFailoverGroupListResultIterator {
	return InstanceFailoverGroupListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ifglr InstanceFailoverGroupListResult) IsEmpty() bool {
	return ifglr.Value == nil || len(*ifglr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (ifglr InstanceFailoverGroupListResult) hasNextLink() bool {
	return ifglr.NextLink != nil && len(*ifglr.NextLink) != 0
}

// instanceFailoverGroupListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ifglr InstanceFailoverGroupListResult) instanceFailoverGroupListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !ifglr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ifglr.NextLink)))
}

// InstanceFailoverGroupListResultPage contains a page of InstanceFailoverGroup values.
type InstanceFailoverGroupListResultPage struct {
	fn    func(context.Context, InstanceFailoverGroupListResult) (InstanceFailoverGroupListResult, error)
	ifglr InstanceFailoverGroupListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *InstanceFailoverGroupListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/InstanceFailoverGroupListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.ifglr)
		if err != nil {
			return err
		}
		page.ifglr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *InstanceFailoverGroupListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page InstanceFailoverGroupListResultPage) NotDone() bool {
	return !page.ifglr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page InstanceFailoverGroupListResultPage) Response() InstanceFailoverGroupListResult {
	return page.ifglr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page InstanceFailoverGroupListResultPage) Values() []InstanceFailoverGroup {
	if page.ifglr.IsEmpty() {
		return nil
	}
	return *page.ifglr.Value
}

// Creates a new instance of the InstanceFailoverGroupListResultPage type.
func NewInstanceFailoverGroupListResultPage(getNextPage func(context.Context, InstanceFailoverGroupListResult) (InstanceFailoverGroupListResult, error)) InstanceFailoverGroupListResultPage {
	return InstanceFailoverGroupListResultPage{fn: getNextPage}
}

// InstanceFailoverGroupProperties properties of a instance failover group.
type InstanceFailoverGroupProperties struct {
	// ReadWriteEndpoint - Read-write endpoint of the failover group instance.
	ReadWriteEndpoint *InstanceFailoverGroupReadWriteEndpoint `json:"readWriteEndpoint,omitempty"`
	// ReadOnlyEndpoint - Read-only endpoint of the failover group instance.
	ReadOnlyEndpoint *InstanceFailoverGroupReadOnlyEndpoint `json:"readOnlyEndpoint,omitempty"`
	// ReplicationRole - READ-ONLY; Local replication role of the failover group instance. Possible values include: 'InstanceFailoverGroupReplicationRolePrimary', 'InstanceFailoverGroupReplicationRoleSecondary'
	ReplicationRole InstanceFailoverGroupReplicationRole `json:"replicationRole,omitempty"`
	// ReplicationState - READ-ONLY; Replication state of the failover group instance.
	ReplicationState *string `json:"replicationState,omitempty"`
	// PartnerRegions - Partner region information for the failover group.
	PartnerRegions *[]PartnerRegionInfo `json:"partnerRegions,omitempty"`
	// ManagedInstancePairs - List of managed instance pairs in the failover group.
	ManagedInstancePairs *[]ManagedInstancePairInfo `json:"managedInstancePairs,omitempty"`
}

// MarshalJSON is the custom marshaler for InstanceFailoverGroupProperties.
func (ifgp InstanceFailoverGroupProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ifgp.ReadWriteEndpoint != nil {
		objectMap["readWriteEndpoint"] = ifgp.ReadWriteEndpoint
	}
	if ifgp.ReadOnlyEndpoint != nil {
		objectMap["readOnlyEndpoint"] = ifgp.ReadOnlyEndpoint
	}
	if ifgp.PartnerRegions != nil {
		objectMap["partnerRegions"] = ifgp.PartnerRegions
	}
	if ifgp.ManagedInstancePairs != nil {
		objectMap["managedInstancePairs"] = ifgp.ManagedInstancePairs
	}
	return json.Marshal(objectMap)
}

// InstanceFailoverGroupReadOnlyEndpoint read-only endpoint of the failover group instance.
type InstanceFailoverGroupReadOnlyEndpoint struct {
	// FailoverPolicy - Failover policy of the read-only endpoint for the failover group. Possible values include: 'ReadOnlyEndpointFailoverPolicyDisabled', 'ReadOnlyEndpointFailoverPolicyEnabled'
	FailoverPolicy ReadOnlyEndpointFailoverPolicy `json:"failoverPolicy,omitempty"`
}

// InstanceFailoverGroupReadWriteEndpoint read-write endpoint of the failover group instance.
type InstanceFailoverGroupReadWriteEndpoint struct {
	// FailoverPolicy - Failover policy of the read-write endpoint for the failover group. If failoverPolicy is Automatic then failoverWithDataLossGracePeriodMinutes is required. Possible values include: 'Manual', 'Automatic'
	FailoverPolicy ReadWriteEndpointFailoverPolicy `json:"failoverPolicy,omitempty"`
	// FailoverWithDataLossGracePeriodMinutes - Grace period before failover with data loss is attempted for the read-write endpoint. If failoverPolicy is Automatic then failoverWithDataLossGracePeriodMinutes is required.
	FailoverWithDataLossGracePeriodMinutes *int32 `json:"failoverWithDataLossGracePeriodMinutes,omitempty"`
}

// InstanceFailoverGroupsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type InstanceFailoverGroupsCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *InstanceFailoverGroupsCreateOrUpdateFuture) Result(client InstanceFailoverGroupsClient) (ifg InstanceFailoverGroup, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.InstanceFailoverGroupsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.InstanceFailoverGroupsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if ifg.Response.Response, err = future.GetResult(sender); err == nil && ifg.Response.Response.StatusCode != http.StatusNoContent {
		ifg, err = client.CreateOrUpdateResponder(ifg.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.InstanceFailoverGroupsCreateOrUpdateFuture", "Result", ifg.Response.Response, "Failure responding to request")
		}
	}
	return
}

// InstanceFailoverGroupsDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type InstanceFailoverGroupsDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *InstanceFailoverGroupsDeleteFuture) Result(client InstanceFailoverGroupsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.InstanceFailoverGroupsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.InstanceFailoverGroupsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// InstanceFailoverGroupsFailoverFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type InstanceFailoverGroupsFailoverFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *InstanceFailoverGroupsFailoverFuture) Result(client InstanceFailoverGroupsClient) (ifg InstanceFailoverGroup, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.InstanceFailoverGroupsFailoverFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.InstanceFailoverGroupsFailoverFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if ifg.Response.Response, err = future.GetResult(sender); err == nil && ifg.Response.Response.StatusCode != http.StatusNoContent {
		ifg, err = client.FailoverResponder(ifg.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.InstanceFailoverGroupsFailoverFuture", "Result", ifg.Response.Response, "Failure responding to request")
		}
	}
	return
}

// InstanceFailoverGroupsForceFailoverAllowDataLossFuture an abstraction for monitoring and retrieving the
// results of a long-running operation.
type InstanceFailoverGroupsForceFailoverAllowDataLossFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *InstanceFailoverGroupsForceFailoverAllowDataLossFuture) Result(client InstanceFailoverGroupsClient) (ifg InstanceFailoverGroup, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.InstanceFailoverGroupsForceFailoverAllowDataLossFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.InstanceFailoverGroupsForceFailoverAllowDataLossFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if ifg.Response.Response, err = future.GetResult(sender); err == nil && ifg.Response.Response.StatusCode != http.StatusNoContent {
		ifg, err = client.ForceFailoverAllowDataLossResponder(ifg.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.InstanceFailoverGroupsForceFailoverAllowDataLossFuture", "Result", ifg.Response.Response, "Failure responding to request")
		}
	}
	return
}

// InstancePool an Azure SQL instance pool.
type InstancePool struct {
	autorest.Response `json:"-"`
	// Sku - The name and tier of the SKU.
	Sku *Sku `json:"sku,omitempty"`
	// InstancePoolProperties - Resource properties.
	*InstancePoolProperties `json:"properties,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for InstancePool.
func (IP InstancePool) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if IP.Sku != nil {
		objectMap["sku"] = IP.Sku
	}
	if IP.InstancePoolProperties != nil {
		objectMap["properties"] = IP.InstancePoolProperties
	}
	if IP.Location != nil {
		objectMap["location"] = IP.Location
	}
	if IP.Tags != nil {
		objectMap["tags"] = IP.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for InstancePool struct.
func (IP *InstancePool) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "sku":
			if v != nil {
				var sku Sku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				IP.Sku = &sku
			}
		case "properties":
			if v != nil {
				var instancePoolProperties InstancePoolProperties
				err = json.Unmarshal(*v, &instancePoolProperties)
				if err != nil {
					return err
				}
				IP.InstancePoolProperties = &instancePoolProperties
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				IP.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				IP.Tags = tags
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				IP.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				IP.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				IP.Type = &typeVar
			}
		}
	}

	return nil
}

// InstancePoolEditionCapability the instance pool capability
type InstancePoolEditionCapability struct {
	// Name - READ-ONLY; The instance pool version name.
	Name *string `json:"name,omitempty"`
	// SupportedFamilies - READ-ONLY; The supported families.
	SupportedFamilies *[]InstancePoolFamilyCapability `json:"supportedFamilies,omitempty"`
	// Status - READ-ONLY; The status of the capability. Possible values include: 'CapabilityStatusVisible', 'CapabilityStatusAvailable', 'CapabilityStatusDefault', 'CapabilityStatusDisabled'
	Status CapabilityStatus `json:"status,omitempty"`
	// Reason - The reason for the capability not being available.
	Reason *string `json:"reason,omitempty"`
}

// MarshalJSON is the custom marshaler for InstancePoolEditionCapability.
func (ipec InstancePoolEditionCapability) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ipec.Reason != nil {
		objectMap["reason"] = ipec.Reason
	}
	return json.Marshal(objectMap)
}

// InstancePoolFamilyCapability the instance pool family capability.
type InstancePoolFamilyCapability struct {
	// Name - READ-ONLY; Family name.
	Name *string `json:"name,omitempty"`
	// SupportedLicenseTypes - READ-ONLY; List of supported license types.
	SupportedLicenseTypes *[]LicenseTypeCapability `json:"supportedLicenseTypes,omitempty"`
	// SupportedVcoresValues - READ-ONLY; List of supported virtual cores values.
	SupportedVcoresValues *[]InstancePoolVcoresCapability `json:"supportedVcoresValues,omitempty"`
	// Status - READ-ONLY; The status of the capability. Possible values include: 'CapabilityStatusVisible', 'CapabilityStatusAvailable', 'CapabilityStatusDefault', 'CapabilityStatusDisabled'
	Status CapabilityStatus `json:"status,omitempty"`
	// Reason - The reason for the capability not being available.
	Reason *string `json:"reason,omitempty"`
}

// MarshalJSON is the custom marshaler for InstancePoolFamilyCapability.
func (ipfc InstancePoolFamilyCapability) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ipfc.Reason != nil {
		objectMap["reason"] = ipfc.Reason
	}
	return json.Marshal(objectMap)
}

// InstancePoolListResult a list of Azure SQL instance pools.
type InstancePoolListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]InstancePool `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// InstancePoolListResultIterator provides access to a complete listing of InstancePool values.
type InstancePoolListResultIterator struct {
	i    int
	page InstancePoolListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *InstancePoolListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/InstancePoolListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *InstancePoolListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter InstancePoolListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter InstancePoolListResultIterator) Response() InstancePoolListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter InstancePoolListResultIterator) Value() InstancePool {
	if !iter.page.NotDone() {
		return InstancePool{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the InstancePoolListResultIterator type.
func NewInstancePoolListResultIterator(page InstancePoolListResultPage) InstancePoolListResultIterator {
	return InstancePoolListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (iplr InstancePoolListResult) IsEmpty() bool {
	return iplr.Value == nil || len(*iplr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (iplr InstancePoolListResult) hasNextLink() bool {
	return iplr.NextLink != nil && len(*iplr.NextLink) != 0
}

// instancePoolListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (iplr InstancePoolListResult) instancePoolListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !iplr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(iplr.NextLink)))
}

// InstancePoolListResultPage contains a page of InstancePool values.
type InstancePoolListResultPage struct {
	fn   func(context.Context, InstancePoolListResult) (InstancePoolListResult, error)
	iplr InstancePoolListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *InstancePoolListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/InstancePoolListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.iplr)
		if err != nil {
			return err
		}
		page.iplr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *InstancePoolListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page InstancePoolListResultPage) NotDone() bool {
	return !page.iplr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page InstancePoolListResultPage) Response() InstancePoolListResult {
	return page.iplr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page InstancePoolListResultPage) Values() []InstancePool {
	if page.iplr.IsEmpty() {
		return nil
	}
	return *page.iplr.Value
}

// Creates a new instance of the InstancePoolListResultPage type.
func NewInstancePoolListResultPage(getNextPage func(context.Context, InstancePoolListResult) (InstancePoolListResult, error)) InstancePoolListResultPage {
	return InstancePoolListResultPage{fn: getNextPage}
}

// InstancePoolProperties properties of an instance pool.
type InstancePoolProperties struct {
	// SubnetID - Resource ID of the subnet to place this instance pool in.
	SubnetID *string `json:"subnetId,omitempty"`
	// VCores - Count of vCores belonging to this instance pool.
	VCores *int32 `json:"vCores,omitempty"`
	// LicenseType - The license type. Possible values are 'LicenseIncluded' (price for SQL license is included) and 'BasePrice' (without SQL license price). Possible values include: 'InstancePoolLicenseTypeLicenseIncluded', 'InstancePoolLicenseTypeBasePrice'
	LicenseType InstancePoolLicenseType `json:"licenseType,omitempty"`
}

// InstancePoolsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type InstancePoolsCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *InstancePoolsCreateOrUpdateFuture) Result(client InstancePoolsClient) (IP InstancePool, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.InstancePoolsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.InstancePoolsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if IP.Response.Response, err = future.GetResult(sender); err == nil && IP.Response.Response.StatusCode != http.StatusNoContent {
		IP, err = client.CreateOrUpdateResponder(IP.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.InstancePoolsCreateOrUpdateFuture", "Result", IP.Response.Response, "Failure responding to request")
		}
	}
	return
}

// InstancePoolsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type InstancePoolsDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *InstancePoolsDeleteFuture) Result(client InstancePoolsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.InstancePoolsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.InstancePoolsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// InstancePoolsUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type InstancePoolsUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *InstancePoolsUpdateFuture) Result(client InstancePoolsClient) (IP InstancePool, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.InstancePoolsUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.InstancePoolsUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if IP.Response.Response, err = future.GetResult(sender); err == nil && IP.Response.Response.StatusCode != http.StatusNoContent {
		IP, err = client.UpdateResponder(IP.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.InstancePoolsUpdateFuture", "Result", IP.Response.Response, "Failure responding to request")
		}
	}
	return
}

// InstancePoolUpdate an update to an Instance pool.
type InstancePoolUpdate struct {
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for InstancePoolUpdate.
func (ipu InstancePoolUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ipu.Tags != nil {
		objectMap["tags"] = ipu.Tags
	}
	return json.Marshal(objectMap)
}

// InstancePoolVcoresCapability the managed instance virtual cores capability.
type InstancePoolVcoresCapability struct {
	// Name - READ-ONLY; The virtual cores identifier.
	Name *string `json:"name,omitempty"`
	// Value - READ-ONLY; The virtual cores value.
	Value *int32 `json:"value,omitempty"`
	// StorageLimit - READ-ONLY; Storage limit.
	StorageLimit *MaxSizeCapability `json:"storageLimit,omitempty"`
	// Status - READ-ONLY; The status of the capability. Possible values include: 'CapabilityStatusVisible', 'CapabilityStatusAvailable', 'CapabilityStatusDefault', 'CapabilityStatusDisabled'
	Status CapabilityStatus `json:"status,omitempty"`
	// Reason - The reason for the capability not being available.
	Reason *string `json:"reason,omitempty"`
}

// MarshalJSON is the custom marshaler for InstancePoolVcoresCapability.
func (ipvc InstancePoolVcoresCapability) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ipvc.Reason != nil {
		objectMap["reason"] = ipvc.Reason
	}
	return json.Marshal(objectMap)
}

// Job a job.
type Job struct {
	autorest.Response `json:"-"`
	// JobProperties - Resource properties.
	*JobProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Job.
func (j Job) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if j.JobProperties != nil {
		objectMap["properties"] = j.JobProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Job struct.
func (j *Job) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var jobProperties JobProperties
				err = json.Unmarshal(*v, &jobProperties)
				if err != nil {
					return err
				}
				j.JobProperties = &jobProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				j.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				j.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				j.Type = &typeVar
			}
		}
	}

	return nil
}

// JobAgent an Azure SQL job agent.
type JobAgent struct {
	autorest.Response `json:"-"`
	// Sku - The name and tier of the SKU.
	Sku *Sku `json:"sku,omitempty"`
	// JobAgentProperties - Resource properties.
	*JobAgentProperties `json:"properties,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for JobAgent.
func (ja JobAgent) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ja.Sku != nil {
		objectMap["sku"] = ja.Sku
	}
	if ja.JobAgentProperties != nil {
		objectMap["properties"] = ja.JobAgentProperties
	}
	if ja.Location != nil {
		objectMap["location"] = ja.Location
	}
	if ja.Tags != nil {
		objectMap["tags"] = ja.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for JobAgent struct.
func (ja *JobAgent) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "sku":
			if v != nil {
				var sku Sku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				ja.Sku = &sku
			}
		case "properties":
			if v != nil {
				var jobAgentProperties JobAgentProperties
				err = json.Unmarshal(*v, &jobAgentProperties)
				if err != nil {
					return err
				}
				ja.JobAgentProperties = &jobAgentProperties
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				ja.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				ja.Tags = tags
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ja.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ja.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ja.Type = &typeVar
			}
		}
	}

	return nil
}

// JobAgentListResult a list of Azure SQL job agents.
type JobAgentListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]JobAgent `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// JobAgentListResultIterator provides access to a complete listing of JobAgent values.
type JobAgentListResultIterator struct {
	i    int
	page JobAgentListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *JobAgentListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JobAgentListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *JobAgentListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter JobAgentListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter JobAgentListResultIterator) Response() JobAgentListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter JobAgentListResultIterator) Value() JobAgent {
	if !iter.page.NotDone() {
		return JobAgent{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the JobAgentListResultIterator type.
func NewJobAgentListResultIterator(page JobAgentListResultPage) JobAgentListResultIterator {
	return JobAgentListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (jalr JobAgentListResult) IsEmpty() bool {
	return jalr.Value == nil || len(*jalr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (jalr JobAgentListResult) hasNextLink() bool {
	return jalr.NextLink != nil && len(*jalr.NextLink) != 0
}

// jobAgentListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (jalr JobAgentListResult) jobAgentListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !jalr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(jalr.NextLink)))
}

// JobAgentListResultPage contains a page of JobAgent values.
type JobAgentListResultPage struct {
	fn   func(context.Context, JobAgentListResult) (JobAgentListResult, error)
	jalr JobAgentListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *JobAgentListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JobAgentListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.jalr)
		if err != nil {
			return err
		}
		page.jalr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *JobAgentListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page JobAgentListResultPage) NotDone() bool {
	return !page.jalr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page JobAgentListResultPage) Response() JobAgentListResult {
	return page.jalr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page JobAgentListResultPage) Values() []JobAgent {
	if page.jalr.IsEmpty() {
		return nil
	}
	return *page.jalr.Value
}

// Creates a new instance of the JobAgentListResultPage type.
func NewJobAgentListResultPage(getNextPage func(context.Context, JobAgentListResult) (JobAgentListResult, error)) JobAgentListResultPage {
	return JobAgentListResultPage{fn: getNextPage}
}

// JobAgentProperties properties of a job agent.
type JobAgentProperties struct {
	// DatabaseID - Resource ID of the database to store job metadata in.
	DatabaseID *string `json:"databaseId,omitempty"`
	// State - READ-ONLY; The state of the job agent. Possible values include: 'JobAgentStateCreating', 'JobAgentStateReady', 'JobAgentStateUpdating', 'JobAgentStateDeleting', 'JobAgentStateDisabled'
	State JobAgentState `json:"state,omitempty"`
}

// MarshalJSON is the custom marshaler for JobAgentProperties.
func (jap JobAgentProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if jap.DatabaseID != nil {
		objectMap["databaseId"] = jap.DatabaseID
	}
	return json.Marshal(objectMap)
}

// JobAgentsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type JobAgentsCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *JobAgentsCreateOrUpdateFuture) Result(client JobAgentsClient) (ja JobAgent, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.JobAgentsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.JobAgentsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if ja.Response.Response, err = future.GetResult(sender); err == nil && ja.Response.Response.StatusCode != http.StatusNoContent {
		ja, err = client.CreateOrUpdateResponder(ja.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.JobAgentsCreateOrUpdateFuture", "Result", ja.Response.Response, "Failure responding to request")
		}
	}
	return
}

// JobAgentsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type JobAgentsDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *JobAgentsDeleteFuture) Result(client JobAgentsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.JobAgentsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.JobAgentsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// JobAgentsUpdateFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type JobAgentsUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *JobAgentsUpdateFuture) Result(client JobAgentsClient) (ja JobAgent, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.JobAgentsUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.JobAgentsUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if ja.Response.Response, err = future.GetResult(sender); err == nil && ja.Response.Response.StatusCode != http.StatusNoContent {
		ja, err = client.UpdateResponder(ja.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.JobAgentsUpdateFuture", "Result", ja.Response.Response, "Failure responding to request")
		}
	}
	return
}

// JobAgentUpdate an update to an Azure SQL job agent.
type JobAgentUpdate struct {
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for JobAgentUpdate.
func (jau JobAgentUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if jau.Tags != nil {
		objectMap["tags"] = jau.Tags
	}
	return json.Marshal(objectMap)
}

// JobCredential a stored credential that can be used by a job to connect to target databases.
type JobCredential struct {
	autorest.Response `json:"-"`
	// JobCredentialProperties - Resource properties.
	*JobCredentialProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for JobCredential.
func (jc JobCredential) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if jc.JobCredentialProperties != nil {
		objectMap["properties"] = jc.JobCredentialProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for JobCredential struct.
func (jc *JobCredential) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var jobCredentialProperties JobCredentialProperties
				err = json.Unmarshal(*v, &jobCredentialProperties)
				if err != nil {
					return err
				}
				jc.JobCredentialProperties = &jobCredentialProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				jc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				jc.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				jc.Type = &typeVar
			}
		}
	}

	return nil
}

// JobCredentialListResult a list of job credentials.
type JobCredentialListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]JobCredential `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// JobCredentialListResultIterator provides access to a complete listing of JobCredential values.
type JobCredentialListResultIterator struct {
	i    int
	page JobCredentialListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *JobCredentialListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JobCredentialListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *JobCredentialListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter JobCredentialListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter JobCredentialListResultIterator) Response() JobCredentialListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter JobCredentialListResultIterator) Value() JobCredential {
	if !iter.page.NotDone() {
		return JobCredential{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the JobCredentialListResultIterator type.
func NewJobCredentialListResultIterator(page JobCredentialListResultPage) JobCredentialListResultIterator {
	return JobCredentialListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (jclr JobCredentialListResult) IsEmpty() bool {
	return jclr.Value == nil || len(*jclr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (jclr JobCredentialListResult) hasNextLink() bool {
	return jclr.NextLink != nil && len(*jclr.NextLink) != 0
}

// jobCredentialListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (jclr JobCredentialListResult) jobCredentialListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !jclr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(jclr.NextLink)))
}

// JobCredentialListResultPage contains a page of JobCredential values.
type JobCredentialListResultPage struct {
	fn   func(context.Context, JobCredentialListResult) (JobCredentialListResult, error)
	jclr JobCredentialListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *JobCredentialListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JobCredentialListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.jclr)
		if err != nil {
			return err
		}
		page.jclr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *JobCredentialListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page JobCredentialListResultPage) NotDone() bool {
	return !page.jclr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page JobCredentialListResultPage) Response() JobCredentialListResult {
	return page.jclr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page JobCredentialListResultPage) Values() []JobCredential {
	if page.jclr.IsEmpty() {
		return nil
	}
	return *page.jclr.Value
}

// Creates a new instance of the JobCredentialListResultPage type.
func NewJobCredentialListResultPage(getNextPage func(context.Context, JobCredentialListResult) (JobCredentialListResult, error)) JobCredentialListResultPage {
	return JobCredentialListResultPage{fn: getNextPage}
}

// JobCredentialProperties properties of a job credential.
type JobCredentialProperties struct {
	// Username - The credential user name.
	Username *string `json:"username,omitempty"`
	// Password - The credential password.
	Password *string `json:"password,omitempty"`
}

// JobExecution an execution of a job
type JobExecution struct {
	autorest.Response `json:"-"`
	// JobExecutionProperties - Resource properties.
	*JobExecutionProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for JobExecution.
func (je JobExecution) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if je.JobExecutionProperties != nil {
		objectMap["properties"] = je.JobExecutionProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for JobExecution struct.
func (je *JobExecution) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var jobExecutionProperties JobExecutionProperties
				err = json.Unmarshal(*v, &jobExecutionProperties)
				if err != nil {
					return err
				}
				je.JobExecutionProperties = &jobExecutionProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				je.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				je.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				je.Type = &typeVar
			}
		}
	}

	return nil
}

// JobExecutionListResult a list of job executions.
type JobExecutionListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]JobExecution `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// JobExecutionListResultIterator provides access to a complete listing of JobExecution values.
type JobExecutionListResultIterator struct {
	i    int
	page JobExecutionListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *JobExecutionListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JobExecutionListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *JobExecutionListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter JobExecutionListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter JobExecutionListResultIterator) Response() JobExecutionListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter JobExecutionListResultIterator) Value() JobExecution {
	if !iter.page.NotDone() {
		return JobExecution{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the JobExecutionListResultIterator type.
func NewJobExecutionListResultIterator(page JobExecutionListResultPage) JobExecutionListResultIterator {
	return JobExecutionListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (jelr JobExecutionListResult) IsEmpty() bool {
	return jelr.Value == nil || len(*jelr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (jelr JobExecutionListResult) hasNextLink() bool {
	return jelr.NextLink != nil && len(*jelr.NextLink) != 0
}

// jobExecutionListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (jelr JobExecutionListResult) jobExecutionListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !jelr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(jelr.NextLink)))
}

// JobExecutionListResultPage contains a page of JobExecution values.
type JobExecutionListResultPage struct {
	fn   func(context.Context, JobExecutionListResult) (JobExecutionListResult, error)
	jelr JobExecutionListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *JobExecutionListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JobExecutionListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.jelr)
		if err != nil {
			return err
		}
		page.jelr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *JobExecutionListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page JobExecutionListResultPage) NotDone() bool {
	return !page.jelr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page JobExecutionListResultPage) Response() JobExecutionListResult {
	return page.jelr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page JobExecutionListResultPage) Values() []JobExecution {
	if page.jelr.IsEmpty() {
		return nil
	}
	return *page.jelr.Value
}

// Creates a new instance of the JobExecutionListResultPage type.
func NewJobExecutionListResultPage(getNextPage func(context.Context, JobExecutionListResult) (JobExecutionListResult, error)) JobExecutionListResultPage {
	return JobExecutionListResultPage{fn: getNextPage}
}

// JobExecutionProperties properties for an Azure SQL Database Elastic job execution.
type JobExecutionProperties struct {
	// JobVersion - READ-ONLY; The job version number.
	JobVersion *int32 `json:"jobVersion,omitempty"`
	// StepName - READ-ONLY; The job step name.
	StepName *string `json:"stepName,omitempty"`
	// StepID - READ-ONLY; The job step id.
	StepID *int32 `json:"stepId,omitempty"`
	// JobExecutionID - READ-ONLY; The unique identifier of the job execution.
	JobExecutionID *uuid.UUID `json:"jobExecutionId,omitempty"`
	// Lifecycle - READ-ONLY; The detailed state of the job execution. Possible values include: 'Created', 'InProgress', 'WaitingForChildJobExecutions', 'WaitingForRetry', 'Succeeded', 'SucceededWithSkipped', 'Failed', 'TimedOut', 'Canceled', 'Skipped'
	Lifecycle JobExecutionLifecycle `json:"lifecycle,omitempty"`
	// ProvisioningState - READ-ONLY; The ARM provisioning state of the job execution. Possible values include: 'ProvisioningStateCreated', 'ProvisioningStateInProgress', 'ProvisioningStateSucceeded', 'ProvisioningStateFailed', 'ProvisioningStateCanceled'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// CreateTime - READ-ONLY; The time that the job execution was created.
	CreateTime *date.Time `json:"createTime,omitempty"`
	// StartTime - READ-ONLY; The time that the job execution started.
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - READ-ONLY; The time that the job execution completed.
	EndTime *date.Time `json:"endTime,omitempty"`
	// CurrentAttempts - Number of times the job execution has been attempted.
	CurrentAttempts *int32 `json:"currentAttempts,omitempty"`
	// CurrentAttemptStartTime - READ-ONLY; Start time of the current attempt.
	CurrentAttemptStartTime *date.Time `json:"currentAttemptStartTime,omitempty"`
	// LastMessage - READ-ONLY; The last status or error message.
	LastMessage *string `json:"lastMessage,omitempty"`
	// Target - READ-ONLY; The target that this execution is executed on.
	Target *JobExecutionTarget `json:"target,omitempty"`
}

// MarshalJSON is the custom marshaler for JobExecutionProperties.
func (jep JobExecutionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if jep.CurrentAttempts != nil {
		objectMap["currentAttempts"] = jep.CurrentAttempts
	}
	return json.Marshal(objectMap)
}

// JobExecutionsCreateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type JobExecutionsCreateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *JobExecutionsCreateFuture) Result(client JobExecutionsClient) (je JobExecution, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.JobExecutionsCreateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.JobExecutionsCreateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if je.Response.Response, err = future.GetResult(sender); err == nil && je.Response.Response.StatusCode != http.StatusNoContent {
		je, err = client.CreateResponder(je.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.JobExecutionsCreateFuture", "Result", je.Response.Response, "Failure responding to request")
		}
	}
	return
}

// JobExecutionsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type JobExecutionsCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *JobExecutionsCreateOrUpdateFuture) Result(client JobExecutionsClient) (je JobExecution, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.JobExecutionsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.JobExecutionsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if je.Response.Response, err = future.GetResult(sender); err == nil && je.Response.Response.StatusCode != http.StatusNoContent {
		je, err = client.CreateOrUpdateResponder(je.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.JobExecutionsCreateOrUpdateFuture", "Result", je.Response.Response, "Failure responding to request")
		}
	}
	return
}

// JobExecutionTarget the target that a job execution is executed on.
type JobExecutionTarget struct {
	// Type - READ-ONLY; The type of the target. Possible values include: 'JobTargetTypeTargetGroup', 'JobTargetTypeSQLDatabase', 'JobTargetTypeSQLElasticPool', 'JobTargetTypeSQLShardMap', 'JobTargetTypeSQLServer'
	Type JobTargetType `json:"type,omitempty"`
	// ServerName - READ-ONLY; The server name.
	ServerName *string `json:"serverName,omitempty"`
	// DatabaseName - READ-ONLY; The database name.
	DatabaseName *string `json:"databaseName,omitempty"`
}

// JobListResult a list of jobs.
type JobListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]Job `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// JobListResultIterator provides access to a complete listing of Job values.
type JobListResultIterator struct {
	i    int
	page JobListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *JobListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JobListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *JobListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter JobListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter JobListResultIterator) Response() JobListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter JobListResultIterator) Value() Job {
	if !iter.page.NotDone() {
		return Job{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the JobListResultIterator type.
func NewJobListResultIterator(page JobListResultPage) JobListResultIterator {
	return JobListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (jlr JobListResult) IsEmpty() bool {
	return jlr.Value == nil || len(*jlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (jlr JobListResult) hasNextLink() bool {
	return jlr.NextLink != nil && len(*jlr.NextLink) != 0
}

// jobListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (jlr JobListResult) jobListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !jlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(jlr.NextLink)))
}

// JobListResultPage contains a page of Job values.
type JobListResultPage struct {
	fn  func(context.Context, JobListResult) (JobListResult, error)
	jlr JobListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *JobListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JobListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.jlr)
		if err != nil {
			return err
		}
		page.jlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *JobListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page JobListResultPage) NotDone() bool {
	return !page.jlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page JobListResultPage) Response() JobListResult {
	return page.jlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page JobListResultPage) Values() []Job {
	if page.jlr.IsEmpty() {
		return nil
	}
	return *page.jlr.Value
}

// Creates a new instance of the JobListResultPage type.
func NewJobListResultPage(getNextPage func(context.Context, JobListResult) (JobListResult, error)) JobListResultPage {
	return JobListResultPage{fn: getNextPage}
}

// JobProperties properties of a job.
type JobProperties struct {
	// Description - User-defined description of the job.
	Description *string `json:"description,omitempty"`
	// Version - READ-ONLY; The job version number.
	Version *int32 `json:"version,omitempty"`
	// Schedule - Schedule properties of the job.
	Schedule *JobSchedule `json:"schedule,omitempty"`
}

// MarshalJSON is the custom marshaler for JobProperties.
func (jp JobProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if jp.Description != nil {
		objectMap["description"] = jp.Description
	}
	if jp.Schedule != nil {
		objectMap["schedule"] = jp.Schedule
	}
	return json.Marshal(objectMap)
}

// JobSchedule scheduling properties of a job.
type JobSchedule struct {
	// StartTime - Schedule start time.
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - Schedule end time.
	EndTime *date.Time `json:"endTime,omitempty"`
	// Type - Schedule interval type. Possible values include: 'Once', 'Recurring'
	Type JobScheduleType `json:"type,omitempty"`
	// Enabled - Whether or not the schedule is enabled.
	Enabled *bool `json:"enabled,omitempty"`
	// Interval - Value of the schedule's recurring interval, if the schedule type is recurring. ISO8601 duration format.
	Interval *string `json:"interval,omitempty"`
}

// JobStep a job step.
type JobStep struct {
	autorest.Response `json:"-"`
	// JobStepProperties - Resource properties.
	*JobStepProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for JobStep.
func (js JobStep) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if js.JobStepProperties != nil {
		objectMap["properties"] = js.JobStepProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for JobStep struct.
func (js *JobStep) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var jobStepProperties JobStepProperties
				err = json.Unmarshal(*v, &jobStepProperties)
				if err != nil {
					return err
				}
				js.JobStepProperties = &jobStepProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				js.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				js.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				js.Type = &typeVar
			}
		}
	}

	return nil
}

// JobStepAction the action to be executed by a job step.
type JobStepAction struct {
	// Type - Type of action being executed by the job step. Possible values include: 'TSQL'
	Type JobStepActionType `json:"type,omitempty"`
	// Source - The source of the action to execute. Possible values include: 'Inline'
	Source JobStepActionSource `json:"source,omitempty"`
	// Value - The action value, for example the text of the T-SQL script to execute.
	Value *string `json:"value,omitempty"`
}

// JobStepExecutionOptions the execution options of a job step.
type JobStepExecutionOptions struct {
	// TimeoutSeconds - Execution timeout for the job step.
	TimeoutSeconds *int32 `json:"timeoutSeconds,omitempty"`
	// RetryAttempts - Maximum number of times the job step will be reattempted if the first attempt fails.
	RetryAttempts *int32 `json:"retryAttempts,omitempty"`
	// InitialRetryIntervalSeconds - Initial delay between retries for job step execution.
	InitialRetryIntervalSeconds *int32 `json:"initialRetryIntervalSeconds,omitempty"`
	// MaximumRetryIntervalSeconds - The maximum amount of time to wait between retries for job step execution.
	MaximumRetryIntervalSeconds *int32 `json:"maximumRetryIntervalSeconds,omitempty"`
	// RetryIntervalBackoffMultiplier - The backoff multiplier for the time between retries.
	RetryIntervalBackoffMultiplier *float64 `json:"retryIntervalBackoffMultiplier,omitempty"`
}

// JobStepListResult a list of job steps.
type JobStepListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]JobStep `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// JobStepListResultIterator provides access to a complete listing of JobStep values.
type JobStepListResultIterator struct {
	i    int
	page JobStepListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *JobStepListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JobStepListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *JobStepListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter JobStepListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter JobStepListResultIterator) Response() JobStepListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter JobStepListResultIterator) Value() JobStep {
	if !iter.page.NotDone() {
		return JobStep{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the JobStepListResultIterator type.
func NewJobStepListResultIterator(page JobStepListResultPage) JobStepListResultIterator {
	return JobStepListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (jslr JobStepListResult) IsEmpty() bool {
	return jslr.Value == nil || len(*jslr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (jslr JobStepListResult) hasNextLink() bool {
	return jslr.NextLink != nil && len(*jslr.NextLink) != 0
}

// jobStepListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (jslr JobStepListResult) jobStepListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !jslr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(jslr.NextLink)))
}

// JobStepListResultPage contains a page of JobStep values.
type JobStepListResultPage struct {
	fn   func(context.Context, JobStepListResult) (JobStepListResult, error)
	jslr JobStepListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *JobStepListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JobStepListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.jslr)
		if err != nil {
			return err
		}
		page.jslr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *JobStepListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page JobStepListResultPage) NotDone() bool {
	return !page.jslr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page JobStepListResultPage) Response() JobStepListResult {
	return page.jslr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page JobStepListResultPage) Values() []JobStep {
	if page.jslr.IsEmpty() {
		return nil
	}
	return *page.jslr.Value
}

// Creates a new instance of the JobStepListResultPage type.
func NewJobStepListResultPage(getNextPage func(context.Context, JobStepListResult) (JobStepListResult, error)) JobStepListResultPage {
	return JobStepListResultPage{fn: getNextPage}
}

// JobStepOutput the output configuration of a job step.
type JobStepOutput struct {
	// Type - The output destination type. Possible values include: 'SQLDatabase'
	Type JobStepOutputType `json:"type,omitempty"`
	// SubscriptionID - The output destination subscription id.
	SubscriptionID *uuid.UUID `json:"subscriptionId,omitempty"`
	// ResourceGroupName - The output destination resource group.
	ResourceGroupName *string `json:"resourceGroupName,omitempty"`
	// ServerName - The output destination server name.
	ServerName *string `json:"serverName,omitempty"`
	// DatabaseName - The output destination database.
	DatabaseName *string `json:"databaseName,omitempty"`
	// SchemaName - The output destination schema.
	SchemaName *string `json:"schemaName,omitempty"`
	// TableName - The output destination table.
	TableName *string `json:"tableName,omitempty"`
	// Credential - The resource ID of the credential to use to connect to the output destination.
	Credential *string `json:"credential,omitempty"`
}

// JobStepProperties properties of a job step.
type JobStepProperties struct {
	// StepID - The job step's index within the job. If not specified when creating the job step, it will be created as the last step. If not specified when updating the job step, the step id is not modified.
	StepID *int32 `json:"stepId,omitempty"`
	// TargetGroup - The resource ID of the target group that the job step will be executed on.
	TargetGroup *string `json:"targetGroup,omitempty"`
	// Credential - The resource ID of the job credential that will be used to connect to the targets.
	Credential *string `json:"credential,omitempty"`
	// Action - The action payload of the job step.
	Action *JobStepAction `json:"action,omitempty"`
	// Output - Output destination properties of the job step.
	Output *JobStepOutput `json:"output,omitempty"`
	// ExecutionOptions - Execution options for the job step.
	ExecutionOptions *JobStepExecutionOptions `json:"executionOptions,omitempty"`
}

// JobTarget a job target, for example a specific database or a container of databases that is evaluated during
// job execution.
type JobTarget struct {
	// MembershipType - Whether the target is included or excluded from the group. Possible values include: 'Include', 'Exclude'
	MembershipType JobTargetGroupMembershipType `json:"membershipType,omitempty"`
	// Type - The target type. Possible values include: 'JobTargetTypeTargetGroup', 'JobTargetTypeSQLDatabase', 'JobTargetTypeSQLElasticPool', 'JobTargetTypeSQLShardMap', 'JobTargetTypeSQLServer'
	Type JobTargetType `json:"type,omitempty"`
	// ServerName - The target server name.
	ServerName *string `json:"serverName,omitempty"`
	// DatabaseName - The target database name.
	DatabaseName *string `json:"databaseName,omitempty"`
	// ElasticPoolName - The target elastic pool name.
	ElasticPoolName *string `json:"elasticPoolName,omitempty"`
	// ShardMapName - The target shard map.
	ShardMapName *string `json:"shardMapName,omitempty"`
	// RefreshCredential - The resource ID of the credential that is used during job execution to connect to the target and determine the list of databases inside the target.
	RefreshCredential *string `json:"refreshCredential,omitempty"`
}

// JobTargetGroup a group of job targets.
type JobTargetGroup struct {
	autorest.Response `json:"-"`
	// JobTargetGroupProperties - Resource properties.
	*JobTargetGroupProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for JobTargetGroup.
func (jtg JobTargetGroup) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if jtg.JobTargetGroupProperties != nil {
		objectMap["properties"] = jtg.JobTargetGroupProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for JobTargetGroup struct.
func (jtg *JobTargetGroup) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var jobTargetGroupProperties JobTargetGroupProperties
				err = json.Unmarshal(*v, &jobTargetGroupProperties)
				if err != nil {
					return err
				}
				jtg.JobTargetGroupProperties = &jobTargetGroupProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				jtg.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				jtg.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				jtg.Type = &typeVar
			}
		}
	}

	return nil
}

// JobTargetGroupListResult a list of target groups.
type JobTargetGroupListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]JobTargetGroup `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// JobTargetGroupListResultIterator provides access to a complete listing of JobTargetGroup values.
type JobTargetGroupListResultIterator struct {
	i    int
	page JobTargetGroupListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *JobTargetGroupListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JobTargetGroupListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *JobTargetGroupListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter JobTargetGroupListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter JobTargetGroupListResultIterator) Response() JobTargetGroupListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter JobTargetGroupListResultIterator) Value() JobTargetGroup {
	if !iter.page.NotDone() {
		return JobTargetGroup{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the JobTargetGroupListResultIterator type.
func NewJobTargetGroupListResultIterator(page JobTargetGroupListResultPage) JobTargetGroupListResultIterator {
	return JobTargetGroupListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (jtglr JobTargetGroupListResult) IsEmpty() bool {
	return jtglr.Value == nil || len(*jtglr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (jtglr JobTargetGroupListResult) hasNextLink() bool {
	return jtglr.NextLink != nil && len(*jtglr.NextLink) != 0
}

// jobTargetGroupListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (jtglr JobTargetGroupListResult) jobTargetGroupListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !jtglr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(jtglr.NextLink)))
}

// JobTargetGroupListResultPage contains a page of JobTargetGroup values.
type JobTargetGroupListResultPage struct {
	fn    func(context.Context, JobTargetGroupListResult) (JobTargetGroupListResult, error)
	jtglr JobTargetGroupListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *JobTargetGroupListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JobTargetGroupListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.jtglr)
		if err != nil {
			return err
		}
		page.jtglr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *JobTargetGroupListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page JobTargetGroupListResultPage) NotDone() bool {
	return !page.jtglr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page JobTargetGroupListResultPage) Response() JobTargetGroupListResult {
	return page.jtglr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page JobTargetGroupListResultPage) Values() []JobTargetGroup {
	if page.jtglr.IsEmpty() {
		return nil
	}
	return *page.jtglr.Value
}

// Creates a new instance of the JobTargetGroupListResultPage type.
func NewJobTargetGroupListResultPage(getNextPage func(context.Context, JobTargetGroupListResult) (JobTargetGroupListResult, error)) JobTargetGroupListResultPage {
	return JobTargetGroupListResultPage{fn: getNextPage}
}

// JobTargetGroupProperties properties of job target group.
type JobTargetGroupProperties struct {
	// Members - Members of the target group.
	Members *[]JobTarget `json:"members,omitempty"`
}

// JobVersion a job version.
type JobVersion struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// JobVersionListResult a list of job versions.
type JobVersionListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]JobVersion `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// JobVersionListResultIterator provides access to a complete listing of JobVersion values.
type JobVersionListResultIterator struct {
	i    int
	page JobVersionListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *JobVersionListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JobVersionListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *JobVersionListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter JobVersionListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter JobVersionListResultIterator) Response() JobVersionListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter JobVersionListResultIterator) Value() JobVersion {
	if !iter.page.NotDone() {
		return JobVersion{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the JobVersionListResultIterator type.
func NewJobVersionListResultIterator(page JobVersionListResultPage) JobVersionListResultIterator {
	return JobVersionListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (jvlr JobVersionListResult) IsEmpty() bool {
	return jvlr.Value == nil || len(*jvlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (jvlr JobVersionListResult) hasNextLink() bool {
	return jvlr.NextLink != nil && len(*jvlr.NextLink) != 0
}

// jobVersionListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (jvlr JobVersionListResult) jobVersionListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !jvlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(jvlr.NextLink)))
}

// JobVersionListResultPage contains a page of JobVersion values.
type JobVersionListResultPage struct {
	fn   func(context.Context, JobVersionListResult) (JobVersionListResult, error)
	jvlr JobVersionListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *JobVersionListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JobVersionListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.jvlr)
		if err != nil {
			return err
		}
		page.jvlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *JobVersionListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page JobVersionListResultPage) NotDone() bool {
	return !page.jvlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page JobVersionListResultPage) Response() JobVersionListResult {
	return page.jvlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page JobVersionListResultPage) Values() []JobVersion {
	if page.jvlr.IsEmpty() {
		return nil
	}
	return *page.jvlr.Value
}

// Creates a new instance of the JobVersionListResultPage type.
func NewJobVersionListResultPage(getNextPage func(context.Context, JobVersionListResult) (JobVersionListResult, error)) JobVersionListResultPage {
	return JobVersionListResultPage{fn: getNextPage}
}

// LicenseTypeCapability the license type capability
type LicenseTypeCapability struct {
	// Name - READ-ONLY; License type identifier.
	Name *string `json:"name,omitempty"`
	// Status - READ-ONLY; The status of the capability. Possible values include: 'CapabilityStatusVisible', 'CapabilityStatusAvailable', 'CapabilityStatusDefault', 'CapabilityStatusDisabled'
	Status CapabilityStatus `json:"status,omitempty"`
	// Reason - The reason for the capability not being available.
	Reason *string `json:"reason,omitempty"`
}

// MarshalJSON is the custom marshaler for LicenseTypeCapability.
func (ltc LicenseTypeCapability) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ltc.Reason != nil {
		objectMap["reason"] = ltc.Reason
	}
	return json.Marshal(objectMap)
}

// LocationCapabilities the location capability.
type LocationCapabilities struct {
	autorest.Response `json:"-"`
	// Name - READ-ONLY; The location name.
	Name *string `json:"name,omitempty"`
	// SupportedServerVersions - READ-ONLY; The list of supported server versions.
	SupportedServerVersions *[]ServerVersionCapability `json:"supportedServerVersions,omitempty"`
	// SupportedManagedInstanceVersions - READ-ONLY; The list of supported managed instance versions.
	SupportedManagedInstanceVersions *[]ManagedInstanceVersionCapability `json:"supportedManagedInstanceVersions,omitempty"`
	// Status - READ-ONLY; The status of the capability. Possible values include: 'CapabilityStatusVisible', 'CapabilityStatusAvailable', 'CapabilityStatusDefault', 'CapabilityStatusDisabled'
	Status CapabilityStatus `json:"status,omitempty"`
	// Reason - The reason for the capability not being available.
	Reason *string `json:"reason,omitempty"`
}

// MarshalJSON is the custom marshaler for LocationCapabilities.
func (lc LocationCapabilities) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if lc.Reason != nil {
		objectMap["reason"] = lc.Reason
	}
	return json.Marshal(objectMap)
}

// LogicalServerSecurityAlertPolicyListResult a list of the server's security alert policies.
type LogicalServerSecurityAlertPolicyListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]ServerSecurityAlertPolicy `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// LogicalServerSecurityAlertPolicyListResultIterator provides access to a complete listing of
// ServerSecurityAlertPolicy values.
type LogicalServerSecurityAlertPolicyListResultIterator struct {
	i    int
	page LogicalServerSecurityAlertPolicyListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *LogicalServerSecurityAlertPolicyListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/LogicalServerSecurityAlertPolicyListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *LogicalServerSecurityAlertPolicyListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter LogicalServerSecurityAlertPolicyListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter LogicalServerSecurityAlertPolicyListResultIterator) Response() LogicalServerSecurityAlertPolicyListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter LogicalServerSecurityAlertPolicyListResultIterator) Value() ServerSecurityAlertPolicy {
	if !iter.page.NotDone() {
		return ServerSecurityAlertPolicy{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the LogicalServerSecurityAlertPolicyListResultIterator type.
func NewLogicalServerSecurityAlertPolicyListResultIterator(page LogicalServerSecurityAlertPolicyListResultPage) LogicalServerSecurityAlertPolicyListResultIterator {
	return LogicalServerSecurityAlertPolicyListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (lssaplr LogicalServerSecurityAlertPolicyListResult) IsEmpty() bool {
	return lssaplr.Value == nil || len(*lssaplr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (lssaplr LogicalServerSecurityAlertPolicyListResult) hasNextLink() bool {
	return lssaplr.NextLink != nil && len(*lssaplr.NextLink) != 0
}

// logicalServerSecurityAlertPolicyListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (lssaplr LogicalServerSecurityAlertPolicyListResult) logicalServerSecurityAlertPolicyListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !lssaplr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(lssaplr.NextLink)))
}

// LogicalServerSecurityAlertPolicyListResultPage contains a page of ServerSecurityAlertPolicy values.
type LogicalServerSecurityAlertPolicyListResultPage struct {
	fn      func(context.Context, LogicalServerSecurityAlertPolicyListResult) (LogicalServerSecurityAlertPolicyListResult, error)
	lssaplr LogicalServerSecurityAlertPolicyListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *LogicalServerSecurityAlertPolicyListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/LogicalServerSecurityAlertPolicyListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.lssaplr)
		if err != nil {
			return err
		}
		page.lssaplr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *LogicalServerSecurityAlertPolicyListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page LogicalServerSecurityAlertPolicyListResultPage) NotDone() bool {
	return !page.lssaplr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page LogicalServerSecurityAlertPolicyListResultPage) Response() LogicalServerSecurityAlertPolicyListResult {
	return page.lssaplr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page LogicalServerSecurityAlertPolicyListResultPage) Values() []ServerSecurityAlertPolicy {
	if page.lssaplr.IsEmpty() {
		return nil
	}
	return *page.lssaplr.Value
}

// Creates a new instance of the LogicalServerSecurityAlertPolicyListResultPage type.
func NewLogicalServerSecurityAlertPolicyListResultPage(getNextPage func(context.Context, LogicalServerSecurityAlertPolicyListResult) (LogicalServerSecurityAlertPolicyListResult, error)) LogicalServerSecurityAlertPolicyListResultPage {
	return LogicalServerSecurityAlertPolicyListResultPage{fn: getNextPage}
}

// LogSizeCapability the log size capability.
type LogSizeCapability struct {
	// Limit - READ-ONLY; The log size limit (see 'unit' for the units).
	Limit *int32 `json:"limit,omitempty"`
	// Unit - READ-ONLY; The units that the limit is expressed in. Possible values include: 'Megabytes', 'Gigabytes', 'Terabytes', 'Petabytes', 'Percent'
	Unit LogSizeUnit `json:"unit,omitempty"`
}

// LongTermRetentionBackup a long term retention backup.
type LongTermRetentionBackup struct {
	autorest.Response `json:"-"`
	// LongTermRetentionBackupProperties - Resource properties.
	*LongTermRetentionBackupProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for LongTermRetentionBackup.
func (ltrb LongTermRetentionBackup) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ltrb.LongTermRetentionBackupProperties != nil {
		objectMap["properties"] = ltrb.LongTermRetentionBackupProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for LongTermRetentionBackup struct.
func (ltrb *LongTermRetentionBackup) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var longTermRetentionBackupProperties LongTermRetentionBackupProperties
				err = json.Unmarshal(*v, &longTermRetentionBackupProperties)
				if err != nil {
					return err
				}
				ltrb.LongTermRetentionBackupProperties = &longTermRetentionBackupProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ltrb.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ltrb.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ltrb.Type = &typeVar
			}
		}
	}

	return nil
}

// LongTermRetentionBackupListResult a list of long term retention backups.
type LongTermRetentionBackupListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]LongTermRetentionBackup `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// LongTermRetentionBackupListResultIterator provides access to a complete listing of LongTermRetentionBackup
// values.
type LongTermRetentionBackupListResultIterator struct {
	i    int
	page LongTermRetentionBackupListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *LongTermRetentionBackupListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/LongTermRetentionBackupListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *LongTermRetentionBackupListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter LongTermRetentionBackupListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter LongTermRetentionBackupListResultIterator) Response() LongTermRetentionBackupListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter LongTermRetentionBackupListResultIterator) Value() LongTermRetentionBackup {
	if !iter.page.NotDone() {
		return LongTermRetentionBackup{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the LongTermRetentionBackupListResultIterator type.
func NewLongTermRetentionBackupListResultIterator(page LongTermRetentionBackupListResultPage) LongTermRetentionBackupListResultIterator {
	return LongTermRetentionBackupListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ltrblr LongTermRetentionBackupListResult) IsEmpty() bool {
	return ltrblr.Value == nil || len(*ltrblr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (ltrblr LongTermRetentionBackupListResult) hasNextLink() bool {
	return ltrblr.NextLink != nil && len(*ltrblr.NextLink) != 0
}

// longTermRetentionBackupListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ltrblr LongTermRetentionBackupListResult) longTermRetentionBackupListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !ltrblr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ltrblr.NextLink)))
}

// LongTermRetentionBackupListResultPage contains a page of LongTermRetentionBackup values.
type LongTermRetentionBackupListResultPage struct {
	fn     func(context.Context, LongTermRetentionBackupListResult) (LongTermRetentionBackupListResult, error)
	ltrblr LongTermRetentionBackupListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *LongTermRetentionBackupListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/LongTermRetentionBackupListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.ltrblr)
		if err != nil {
			return err
		}
		page.ltrblr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *LongTermRetentionBackupListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page LongTermRetentionBackupListResultPage) NotDone() bool {
	return !page.ltrblr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page LongTermRetentionBackupListResultPage) Response() LongTermRetentionBackupListResult {
	return page.ltrblr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page LongTermRetentionBackupListResultPage) Values() []LongTermRetentionBackup {
	if page.ltrblr.IsEmpty() {
		return nil
	}
	return *page.ltrblr.Value
}

// Creates a new instance of the LongTermRetentionBackupListResultPage type.
func NewLongTermRetentionBackupListResultPage(getNextPage func(context.Context, LongTermRetentionBackupListResult) (LongTermRetentionBackupListResult, error)) LongTermRetentionBackupListResultPage {
	return LongTermRetentionBackupListResultPage{fn: getNextPage}
}

// LongTermRetentionBackupProperties properties of a long term retention backup
type LongTermRetentionBackupProperties struct {
	// ServerName - READ-ONLY; The server name that the backup database belong to.
	ServerName *string `json:"serverName,omitempty"`
	// ServerCreateTime - READ-ONLY; The create time of the server.
	ServerCreateTime *date.Time `json:"serverCreateTime,omitempty"`
	// DatabaseName - READ-ONLY; The name of the database the backup belong to
	DatabaseName *string `json:"databaseName,omitempty"`
	// DatabaseDeletionTime - READ-ONLY; The delete time of the database
	DatabaseDeletionTime *date.Time `json:"databaseDeletionTime,omitempty"`
	// BackupTime - READ-ONLY; The time the backup was taken
	BackupTime *date.Time `json:"backupTime,omitempty"`
	// BackupExpirationTime - READ-ONLY; The time the long term retention backup will expire.
	BackupExpirationTime *date.Time `json:"backupExpirationTime,omitempty"`
}

// LongTermRetentionBackupsDeleteByResourceGroupFuture an abstraction for monitoring and retrieving the results
// of a long-running operation.
type LongTermRetentionBackupsDeleteByResourceGroupFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *LongTermRetentionBackupsDeleteByResourceGroupFuture) Result(client LongTermRetentionBackupsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.LongTermRetentionBackupsDeleteByResourceGroupFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.LongTermRetentionBackupsDeleteByResourceGroupFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// LongTermRetentionBackupsDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type LongTermRetentionBackupsDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *LongTermRetentionBackupsDeleteFuture) Result(client LongTermRetentionBackupsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.LongTermRetentionBackupsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.LongTermRetentionBackupsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// LongTermRetentionManagedInstanceBackupsDeleteByResourceGroupFuture an abstraction for monitoring and
// retrieving the results of a long-running operation.
type LongTermRetentionManagedInstanceBackupsDeleteByResourceGroupFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *LongTermRetentionManagedInstanceBackupsDeleteByResourceGroupFuture) Result(client LongTermRetentionManagedInstanceBackupsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.LongTermRetentionManagedInstanceBackupsDeleteByResourceGroupFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.LongTermRetentionManagedInstanceBackupsDeleteByResourceGroupFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// LongTermRetentionManagedInstanceBackupsDeleteFuture an abstraction for monitoring and retrieving the results
// of a long-running operation.
type LongTermRetentionManagedInstanceBackupsDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *LongTermRetentionManagedInstanceBackupsDeleteFuture) Result(client LongTermRetentionManagedInstanceBackupsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.LongTermRetentionManagedInstanceBackupsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.LongTermRetentionManagedInstanceBackupsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// LongTermRetentionPolicyProperties properties of a long term retention policy
type LongTermRetentionPolicyProperties struct {
	// WeeklyRetention - The weekly retention policy for an LTR backup in an ISO 8601 format.
	WeeklyRetention *string `json:"weeklyRetention,omitempty"`
	// MonthlyRetention - The monthly retention policy for an LTR backup in an ISO 8601 format.
	MonthlyRetention *string `json:"monthlyRetention,omitempty"`
	// YearlyRetention - The yearly retention policy for an LTR backup in an ISO 8601 format.
	YearlyRetention *string `json:"yearlyRetention,omitempty"`
	// WeekOfYear - The week of year to take the yearly backup in an ISO 8601 format.
	WeekOfYear *int32 `json:"weekOfYear,omitempty"`
}

// ManagedBackupShortTermRetentionPoliciesCreateOrUpdateFuture an abstraction for monitoring and retrieving the
// results of a long-running operation.
type ManagedBackupShortTermRetentionPoliciesCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ManagedBackupShortTermRetentionPoliciesCreateOrUpdateFuture) Result(client ManagedBackupShortTermRetentionPoliciesClient) (mbstrp ManagedBackupShortTermRetentionPolicy, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.ManagedBackupShortTermRetentionPoliciesCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.ManagedBackupShortTermRetentionPoliciesCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if mbstrp.Response.Response, err = future.GetResult(sender); err == nil && mbstrp.Response.Response.StatusCode != http.StatusNoContent {
		mbstrp, err = client.CreateOrUpdateResponder(mbstrp.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.ManagedBackupShortTermRetentionPoliciesCreateOrUpdateFuture", "Result", mbstrp.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ManagedBackupShortTermRetentionPoliciesUpdateFuture an abstraction for monitoring and retrieving the results
// of a long-running operation.
type ManagedBackupShortTermRetentionPoliciesUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ManagedBackupShortTermRetentionPoliciesUpdateFuture) Result(client ManagedBackupShortTermRetentionPoliciesClient) (mbstrp ManagedBackupShortTermRetentionPolicy, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.ManagedBackupShortTermRetentionPoliciesUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.ManagedBackupShortTermRetentionPoliciesUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if mbstrp.Response.Response, err = future.GetResult(sender); err == nil && mbstrp.Response.Response.StatusCode != http.StatusNoContent {
		mbstrp, err = client.UpdateResponder(mbstrp.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.ManagedBackupShortTermRetentionPoliciesUpdateFuture", "Result", mbstrp.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ManagedBackupShortTermRetentionPolicy a short term retention policy.
type ManagedBackupShortTermRetentionPolicy struct {
	autorest.Response `json:"-"`
	// ManagedBackupShortTermRetentionPolicyProperties - Resource properties.
	*ManagedBackupShortTermRetentionPolicyProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagedBackupShortTermRetentionPolicy.
func (mbstrp ManagedBackupShortTermRetentionPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mbstrp.ManagedBackupShortTermRetentionPolicyProperties != nil {
		objectMap["properties"] = mbstrp.ManagedBackupShortTermRetentionPolicyProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ManagedBackupShortTermRetentionPolicy struct.
func (mbstrp *ManagedBackupShortTermRetentionPolicy) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var managedBackupShortTermRetentionPolicyProperties ManagedBackupShortTermRetentionPolicyProperties
				err = json.Unmarshal(*v, &managedBackupShortTermRetentionPolicyProperties)
				if err != nil {
					return err
				}
				mbstrp.ManagedBackupShortTermRetentionPolicyProperties = &managedBackupShortTermRetentionPolicyProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				mbstrp.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				mbstrp.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				mbstrp.Type = &typeVar
			}
		}
	}

	return nil
}

// ManagedBackupShortTermRetentionPolicyListResult a list of short term retention policies.
type ManagedBackupShortTermRetentionPolicyListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]ManagedBackupShortTermRetentionPolicy `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ManagedBackupShortTermRetentionPolicyListResultIterator provides access to a complete listing of
// ManagedBackupShortTermRetentionPolicy values.
type ManagedBackupShortTermRetentionPolicyListResultIterator struct {
	i    int
	page ManagedBackupShortTermRetentionPolicyListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ManagedBackupShortTermRetentionPolicyListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ManagedBackupShortTermRetentionPolicyListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ManagedBackupShortTermRetentionPolicyListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ManagedBackupShortTermRetentionPolicyListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ManagedBackupShortTermRetentionPolicyListResultIterator) Response() ManagedBackupShortTermRetentionPolicyListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ManagedBackupShortTermRetentionPolicyListResultIterator) Value() ManagedBackupShortTermRetentionPolicy {
	if !iter.page.NotDone() {
		return ManagedBackupShortTermRetentionPolicy{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ManagedBackupShortTermRetentionPolicyListResultIterator type.
func NewManagedBackupShortTermRetentionPolicyListResultIterator(page ManagedBackupShortTermRetentionPolicyListResultPage) ManagedBackupShortTermRetentionPolicyListResultIterator {
	return ManagedBackupShortTermRetentionPolicyListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (mbstrplr ManagedBackupShortTermRetentionPolicyListResult) IsEmpty() bool {
	return mbstrplr.Value == nil || len(*mbstrplr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (mbstrplr ManagedBackupShortTermRetentionPolicyListResult) hasNextLink() bool {
	return mbstrplr.NextLink != nil && len(*mbstrplr.NextLink) != 0
}

// managedBackupShortTermRetentionPolicyListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (mbstrplr ManagedBackupShortTermRetentionPolicyListResult) managedBackupShortTermRetentionPolicyListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !mbstrplr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(mbstrplr.NextLink)))
}

// ManagedBackupShortTermRetentionPolicyListResultPage contains a page of ManagedBackupShortTermRetentionPolicy
// values.
type ManagedBackupShortTermRetentionPolicyListResultPage struct {
	fn       func(context.Context, ManagedBackupShortTermRetentionPolicyListResult) (ManagedBackupShortTermRetentionPolicyListResult, error)
	mbstrplr ManagedBackupShortTermRetentionPolicyListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ManagedBackupShortTermRetentionPolicyListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ManagedBackupShortTermRetentionPolicyListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.mbstrplr)
		if err != nil {
			return err
		}
		page.mbstrplr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ManagedBackupShortTermRetentionPolicyListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ManagedBackupShortTermRetentionPolicyListResultPage) NotDone() bool {
	return !page.mbstrplr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ManagedBackupShortTermRetentionPolicyListResultPage) Response() ManagedBackupShortTermRetentionPolicyListResult {
	return page.mbstrplr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ManagedBackupShortTermRetentionPolicyListResultPage) Values() []ManagedBackupShortTermRetentionPolicy {
	if page.mbstrplr.IsEmpty() {
		return nil
	}
	return *page.mbstrplr.Value
}

// Creates a new instance of the ManagedBackupShortTermRetentionPolicyListResultPage type.
func NewManagedBackupShortTermRetentionPolicyListResultPage(getNextPage func(context.Context, ManagedBackupShortTermRetentionPolicyListResult) (ManagedBackupShortTermRetentionPolicyListResult, error)) ManagedBackupShortTermRetentionPolicyListResultPage {
	return ManagedBackupShortTermRetentionPolicyListResultPage{fn: getNextPage}
}

// ManagedBackupShortTermRetentionPolicyProperties properties of a short term retention policy
type ManagedBackupShortTermRetentionPolicyProperties struct {
	// RetentionDays - The backup retention period in days. This is how many days Point-in-Time Restore will be supported.
	RetentionDays *int32 `json:"retentionDays,omitempty"`
}

// ManagedDatabase a managed database resource.
type ManagedDatabase struct {
	autorest.Response `json:"-"`
	// ManagedDatabaseProperties - Resource properties.
	*ManagedDatabaseProperties `json:"properties,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagedDatabase.
func (md ManagedDatabase) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if md.ManagedDatabaseProperties != nil {
		objectMap["properties"] = md.ManagedDatabaseProperties
	}
	if md.Location != nil {
		objectMap["location"] = md.Location
	}
	if md.Tags != nil {
		objectMap["tags"] = md.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ManagedDatabase struct.
func (md *ManagedDatabase) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var managedDatabaseProperties ManagedDatabaseProperties
				err = json.Unmarshal(*v, &managedDatabaseProperties)
				if err != nil {
					return err
				}
				md.ManagedDatabaseProperties = &managedDatabaseProperties
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				md.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				md.Tags = tags
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				md.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				md.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				md.Type = &typeVar
			}
		}
	}

	return nil
}

// ManagedDatabaseListResult a list of managed databases.
type ManagedDatabaseListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]ManagedDatabase `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ManagedDatabaseListResultIterator provides access to a complete listing of ManagedDatabase values.
type ManagedDatabaseListResultIterator struct {
	i    int
	page ManagedDatabaseListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ManagedDatabaseListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ManagedDatabaseListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ManagedDatabaseListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ManagedDatabaseListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ManagedDatabaseListResultIterator) Response() ManagedDatabaseListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ManagedDatabaseListResultIterator) Value() ManagedDatabase {
	if !iter.page.NotDone() {
		return ManagedDatabase{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ManagedDatabaseListResultIterator type.
func NewManagedDatabaseListResultIterator(page ManagedDatabaseListResultPage) ManagedDatabaseListResultIterator {
	return ManagedDatabaseListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (mdlr ManagedDatabaseListResult) IsEmpty() bool {
	return mdlr.Value == nil || len(*mdlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (mdlr ManagedDatabaseListResult) hasNextLink() bool {
	return mdlr.NextLink != nil && len(*mdlr.NextLink) != 0
}

// managedDatabaseListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (mdlr ManagedDatabaseListResult) managedDatabaseListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !mdlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(mdlr.NextLink)))
}

// ManagedDatabaseListResultPage contains a page of ManagedDatabase values.
type ManagedDatabaseListResultPage struct {
	fn   func(context.Context, ManagedDatabaseListResult) (ManagedDatabaseListResult, error)
	mdlr ManagedDatabaseListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ManagedDatabaseListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ManagedDatabaseListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.mdlr)
		if err != nil {
			return err
		}
		page.mdlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ManagedDatabaseListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ManagedDatabaseListResultPage) NotDone() bool {
	return !page.mdlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ManagedDatabaseListResultPage) Response() ManagedDatabaseListResult {
	return page.mdlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ManagedDatabaseListResultPage) Values() []ManagedDatabase {
	if page.mdlr.IsEmpty() {
		return nil
	}
	return *page.mdlr.Value
}

// Creates a new instance of the ManagedDatabaseListResultPage type.
func NewManagedDatabaseListResultPage(getNextPage func(context.Context, ManagedDatabaseListResult) (ManagedDatabaseListResult, error)) ManagedDatabaseListResultPage {
	return ManagedDatabaseListResultPage{fn: getNextPage}
}

// ManagedDatabaseProperties the managed database's properties.
type ManagedDatabaseProperties struct {
	// Collation - Collation of the managed database.
	Collation *string `json:"collation,omitempty"`
	// Status - READ-ONLY; Status of the database. Possible values include: 'Online', 'Offline', 'Shutdown', 'Creating', 'Inaccessible', 'Restoring', 'Updating'
	Status ManagedDatabaseStatus `json:"status,omitempty"`
	// CreationDate - READ-ONLY; Creation date of the database.
	CreationDate *date.Time `json:"creationDate,omitempty"`
	// EarliestRestorePoint - READ-ONLY; Earliest restore point in time for point in time restore.
	EarliestRestorePoint *date.Time `json:"earliestRestorePoint,omitempty"`
	// RestorePointInTime - Conditional. If createMode is PointInTimeRestore, this value is required. Specifies the point in time (ISO8601 format) of the source database that will be restored to create the new database.
	RestorePointInTime *date.Time `json:"restorePointInTime,omitempty"`
	// DefaultSecondaryLocation - READ-ONLY; Geo paired region.
	DefaultSecondaryLocation *string `json:"defaultSecondaryLocation,omitempty"`
	// CatalogCollation - Collation of the metadata catalog. Possible values include: 'DATABASEDEFAULT', 'SQLLatin1GeneralCP1CIAS'
	CatalogCollation CatalogCollationType `json:"catalogCollation,omitempty"`
	// CreateMode - Managed database create mode. PointInTimeRestore: Create a database by restoring a point in time backup of an existing database. SourceDatabaseName, SourceManagedInstanceName and PointInTime must be specified. RestoreExternalBackup: Create a database by restoring from external backup files. Collation, StorageContainerUri and StorageContainerSasToken must be specified. Recovery: Creates a database by restoring a geo-replicated backup. RecoverableDatabaseId must be specified as the recoverable database resource ID to restore. RestoreLongTermRetentionBackup: Create a database by restoring from a long term retention backup (longTermRetentionBackupResourceId required). Possible values include: 'ManagedDatabaseCreateModeDefault', 'ManagedDatabaseCreateModeRestoreExternalBackup', 'ManagedDatabaseCreateModePointInTimeRestore', 'ManagedDatabaseCreateModeRecovery', 'ManagedDatabaseCreateModeRestoreLongTermRetentionBackup'
	CreateMode ManagedDatabaseCreateMode `json:"createMode,omitempty"`
	// StorageContainerURI - Conditional. If createMode is RestoreExternalBackup, this value is required. Specifies the uri of the storage container where backups for this restore are stored.
	StorageContainerURI *string `json:"storageContainerUri,omitempty"`
	// SourceDatabaseID - The resource identifier of the source database associated with create operation of this database.
	SourceDatabaseID *string `json:"sourceDatabaseId,omitempty"`
	// RestorableDroppedDatabaseID - The restorable dropped database resource id to restore when creating this database.
	RestorableDroppedDatabaseID *string `json:"restorableDroppedDatabaseId,omitempty"`
	// StorageContainerSasToken - Conditional. If createMode is RestoreExternalBackup, this value is required. Specifies the storage container sas token.
	StorageContainerSasToken *string `json:"storageContainerSasToken,omitempty"`
	// FailoverGroupID - READ-ONLY; Instance Failover Group resource identifier that this managed database belongs to.
	FailoverGroupID *string `json:"failoverGroupId,omitempty"`
	// RecoverableDatabaseID - The resource identifier of the recoverable database associated with create operation of this database.
	RecoverableDatabaseID *string `json:"recoverableDatabaseId,omitempty"`
	// LongTermRetentionBackupResourceID - The name of the Long Term Retention backup to be used for restore of this managed database.
	LongTermRetentionBackupResourceID *string `json:"longTermRetentionBackupResourceId,omitempty"`
	// AutoCompleteRestore - Whether to auto complete restore of this managed database.
	AutoCompleteRestore *bool `json:"autoCompleteRestore,omitempty"`
	// LastBackupName - Last backup file name for restore of this managed database.
	LastBackupName *string `json:"lastBackupName,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagedDatabaseProperties.
func (mdp ManagedDatabaseProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mdp.Collation != nil {
		objectMap["collation"] = mdp.Collation
	}
	if mdp.RestorePointInTime != nil {
		objectMap["restorePointInTime"] = mdp.RestorePointInTime
	}
	if mdp.CatalogCollation != "" {
		objectMap["catalogCollation"] = mdp.CatalogCollation
	}
	if mdp.CreateMode != "" {
		objectMap["createMode"] = mdp.CreateMode
	}
	if mdp.StorageContainerURI != nil {
		objectMap["storageContainerUri"] = mdp.StorageContainerURI
	}
	if mdp.SourceDatabaseID != nil {
		objectMap["sourceDatabaseId"] = mdp.SourceDatabaseID
	}
	if mdp.RestorableDroppedDatabaseID != nil {
		objectMap["restorableDroppedDatabaseId"] = mdp.RestorableDroppedDatabaseID
	}
	if mdp.StorageContainerSasToken != nil {
		objectMap["storageContainerSasToken"] = mdp.StorageContainerSasToken
	}
	if mdp.RecoverableDatabaseID != nil {
		objectMap["recoverableDatabaseId"] = mdp.RecoverableDatabaseID
	}
	if mdp.LongTermRetentionBackupResourceID != nil {
		objectMap["longTermRetentionBackupResourceId"] = mdp.LongTermRetentionBackupResourceID
	}
	if mdp.AutoCompleteRestore != nil {
		objectMap["autoCompleteRestore"] = mdp.AutoCompleteRestore
	}
	if mdp.LastBackupName != nil {
		objectMap["lastBackupName"] = mdp.LastBackupName
	}
	return json.Marshal(objectMap)
}

// ManagedDatabaseRestoreDetailsProperties the managed database's restore details properties.
type ManagedDatabaseRestoreDetailsProperties struct {
	// Status - READ-ONLY; Restore status.
	Status *string `json:"status,omitempty"`
	// CurrentRestoringFileName - READ-ONLY; Current restoring file name.
	CurrentRestoringFileName *string `json:"currentRestoringFileName,omitempty"`
	// LastRestoredFileName - READ-ONLY; Last restored file name.
	LastRestoredFileName *string `json:"lastRestoredFileName,omitempty"`
	// LastRestoredFileTime - READ-ONLY; Last restored file time.
	LastRestoredFileTime *date.Time `json:"lastRestoredFileTime,omitempty"`
	// PercentCompleted - READ-ONLY; Percent completed.
	PercentCompleted *float64 `json:"percentCompleted,omitempty"`
	// UnrestorableFiles - READ-ONLY; List of unrestorable files.
	UnrestorableFiles *[]string `json:"unrestorableFiles,omitempty"`
	// NumberOfFilesDetected - READ-ONLY; Number of files detected.
	NumberOfFilesDetected *int64 `json:"numberOfFilesDetected,omitempty"`
	// LastUploadedFileName - READ-ONLY; Last uploaded file name.
	LastUploadedFileName *string `json:"lastUploadedFileName,omitempty"`
	// LastUploadedFileTime - READ-ONLY; Last uploaded file time.
	LastUploadedFileTime *date.Time `json:"lastUploadedFileTime,omitempty"`
	// BlockReason - READ-ONLY; The reason why restore is in Blocked state.
	BlockReason *string `json:"blockReason,omitempty"`
}

// ManagedDatabaseRestoreDetailsResult a managed database restore details.
type ManagedDatabaseRestoreDetailsResult struct {
	autorest.Response `json:"-"`
	// ManagedDatabaseRestoreDetailsProperties - Resource properties.
	*ManagedDatabaseRestoreDetailsProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagedDatabaseRestoreDetailsResult.
func (mdrdr ManagedDatabaseRestoreDetailsResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mdrdr.ManagedDatabaseRestoreDetailsProperties != nil {
		objectMap["properties"] = mdrdr.ManagedDatabaseRestoreDetailsProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ManagedDatabaseRestoreDetailsResult struct.
func (mdrdr *ManagedDatabaseRestoreDetailsResult) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var managedDatabaseRestoreDetailsProperties ManagedDatabaseRestoreDetailsProperties
				err = json.Unmarshal(*v, &managedDatabaseRestoreDetailsProperties)
				if err != nil {
					return err
				}
				mdrdr.ManagedDatabaseRestoreDetailsProperties = &managedDatabaseRestoreDetailsProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				mdrdr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				mdrdr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				mdrdr.Type = &typeVar
			}
		}
	}

	return nil
}

// ManagedDatabasesCompleteRestoreFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ManagedDatabasesCompleteRestoreFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ManagedDatabasesCompleteRestoreFuture) Result(client ManagedDatabasesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.ManagedDatabasesCompleteRestoreFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.ManagedDatabasesCompleteRestoreFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ManagedDatabasesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ManagedDatabasesCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ManagedDatabasesCreateOrUpdateFuture) Result(client ManagedDatabasesClient) (md ManagedDatabase, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.ManagedDatabasesCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.ManagedDatabasesCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if md.Response.Response, err = future.GetResult(sender); err == nil && md.Response.Response.StatusCode != http.StatusNoContent {
		md, err = client.CreateOrUpdateResponder(md.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.ManagedDatabasesCreateOrUpdateFuture", "Result", md.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ManagedDatabasesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ManagedDatabasesDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ManagedDatabasesDeleteFuture) Result(client ManagedDatabasesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.ManagedDatabasesDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.ManagedDatabasesDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ManagedDatabaseSecurityAlertPolicy a managed database security alert policy.
type ManagedDatabaseSecurityAlertPolicy struct {
	autorest.Response `json:"-"`
	// SecurityAlertPolicyProperties - Resource properties.
	*SecurityAlertPolicyProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagedDatabaseSecurityAlertPolicy.
func (mdsap ManagedDatabaseSecurityAlertPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mdsap.SecurityAlertPolicyProperties != nil {
		objectMap["properties"] = mdsap.SecurityAlertPolicyProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ManagedDatabaseSecurityAlertPolicy struct.
func (mdsap *ManagedDatabaseSecurityAlertPolicy) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var securityAlertPolicyProperties SecurityAlertPolicyProperties
				err = json.Unmarshal(*v, &securityAlertPolicyProperties)
				if err != nil {
					return err
				}
				mdsap.SecurityAlertPolicyProperties = &securityAlertPolicyProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				mdsap.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				mdsap.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				mdsap.Type = &typeVar
			}
		}
	}

	return nil
}

// ManagedDatabaseSecurityAlertPolicyListResult a list of the managed database's security alert policies.
type ManagedDatabaseSecurityAlertPolicyListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]ManagedDatabaseSecurityAlertPolicy `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ManagedDatabaseSecurityAlertPolicyListResultIterator provides access to a complete listing of
// ManagedDatabaseSecurityAlertPolicy values.
type ManagedDatabaseSecurityAlertPolicyListResultIterator struct {
	i    int
	page ManagedDatabaseSecurityAlertPolicyListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ManagedDatabaseSecurityAlertPolicyListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ManagedDatabaseSecurityAlertPolicyListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ManagedDatabaseSecurityAlertPolicyListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ManagedDatabaseSecurityAlertPolicyListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ManagedDatabaseSecurityAlertPolicyListResultIterator) Response() ManagedDatabaseSecurityAlertPolicyListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ManagedDatabaseSecurityAlertPolicyListResultIterator) Value() ManagedDatabaseSecurityAlertPolicy {
	if !iter.page.NotDone() {
		return ManagedDatabaseSecurityAlertPolicy{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ManagedDatabaseSecurityAlertPolicyListResultIterator type.
func NewManagedDatabaseSecurityAlertPolicyListResultIterator(page ManagedDatabaseSecurityAlertPolicyListResultPage) ManagedDatabaseSecurityAlertPolicyListResultIterator {
	return ManagedDatabaseSecurityAlertPolicyListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (mdsaplr ManagedDatabaseSecurityAlertPolicyListResult) IsEmpty() bool {
	return mdsaplr.Value == nil || len(*mdsaplr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (mdsaplr ManagedDatabaseSecurityAlertPolicyListResult) hasNextLink() bool {
	return mdsaplr.NextLink != nil && len(*mdsaplr.NextLink) != 0
}

// managedDatabaseSecurityAlertPolicyListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (mdsaplr ManagedDatabaseSecurityAlertPolicyListResult) managedDatabaseSecurityAlertPolicyListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !mdsaplr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(mdsaplr.NextLink)))
}

// ManagedDatabaseSecurityAlertPolicyListResultPage contains a page of ManagedDatabaseSecurityAlertPolicy
// values.
type ManagedDatabaseSecurityAlertPolicyListResultPage struct {
	fn      func(context.Context, ManagedDatabaseSecurityAlertPolicyListResult) (ManagedDatabaseSecurityAlertPolicyListResult, error)
	mdsaplr ManagedDatabaseSecurityAlertPolicyListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ManagedDatabaseSecurityAlertPolicyListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ManagedDatabaseSecurityAlertPolicyListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.mdsaplr)
		if err != nil {
			return err
		}
		page.mdsaplr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ManagedDatabaseSecurityAlertPolicyListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ManagedDatabaseSecurityAlertPolicyListResultPage) NotDone() bool {
	return !page.mdsaplr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ManagedDatabaseSecurityAlertPolicyListResultPage) Response() ManagedDatabaseSecurityAlertPolicyListResult {
	return page.mdsaplr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ManagedDatabaseSecurityAlertPolicyListResultPage) Values() []ManagedDatabaseSecurityAlertPolicy {
	if page.mdsaplr.IsEmpty() {
		return nil
	}
	return *page.mdsaplr.Value
}

// Creates a new instance of the ManagedDatabaseSecurityAlertPolicyListResultPage type.
func NewManagedDatabaseSecurityAlertPolicyListResultPage(getNextPage func(context.Context, ManagedDatabaseSecurityAlertPolicyListResult) (ManagedDatabaseSecurityAlertPolicyListResult, error)) ManagedDatabaseSecurityAlertPolicyListResultPage {
	return ManagedDatabaseSecurityAlertPolicyListResultPage{fn: getNextPage}
}

// ManagedDatabasesUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ManagedDatabasesUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ManagedDatabasesUpdateFuture) Result(client ManagedDatabasesClient) (md ManagedDatabase, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.ManagedDatabasesUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.ManagedDatabasesUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if md.Response.Response, err = future.GetResult(sender); err == nil && md.Response.Response.StatusCode != http.StatusNoContent {
		md, err = client.UpdateResponder(md.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.ManagedDatabasesUpdateFuture", "Result", md.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ManagedDatabaseUpdate an managed database update.
type ManagedDatabaseUpdate struct {
	// ManagedDatabaseProperties - Resource properties.
	*ManagedDatabaseProperties `json:"properties,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ManagedDatabaseUpdate.
func (mdu ManagedDatabaseUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mdu.ManagedDatabaseProperties != nil {
		objectMap["properties"] = mdu.ManagedDatabaseProperties
	}
	if mdu.Tags != nil {
		objectMap["tags"] = mdu.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ManagedDatabaseUpdate struct.
func (mdu *ManagedDatabaseUpdate) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var managedDatabaseProperties ManagedDatabaseProperties
				err = json.Unmarshal(*v, &managedDatabaseProperties)
				if err != nil {
					return err
				}
				mdu.ManagedDatabaseProperties = &managedDatabaseProperties
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				mdu.Tags = tags
			}
		}
	}

	return nil
}

// ManagedDatabaseVulnerabilityAssessmentScansInitiateScanFuture an abstraction for monitoring and retrieving
// the results of a long-running operation.
type ManagedDatabaseVulnerabilityAssessmentScansInitiateScanFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ManagedDatabaseVulnerabilityAssessmentScansInitiateScanFuture) Result(client ManagedDatabaseVulnerabilityAssessmentScansClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.ManagedDatabaseVulnerabilityAssessmentScansInitiateScanFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.ManagedDatabaseVulnerabilityAssessmentScansInitiateScanFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ManagedInstance an Azure SQL managed instance.
type ManagedInstance struct {
	autorest.Response `json:"-"`
	// Identity - The Azure Active Directory identity of the managed instance.
	Identity *ResourceIdentity `json:"identity,omitempty"`
	// Sku - Managed instance SKU. Allowed values for sku.name: GP_Gen4, GP_Gen5, BC_Gen4, BC_Gen5
	Sku *Sku `json:"sku,omitempty"`
	// ManagedInstanceProperties - Resource properties.
	*ManagedInstanceProperties `json:"properties,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagedInstance.
func (mi ManagedInstance) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mi.Identity != nil {
		objectMap["identity"] = mi.Identity
	}
	if mi.Sku != nil {
		objectMap["sku"] = mi.Sku
	}
	if mi.ManagedInstanceProperties != nil {
		objectMap["properties"] = mi.ManagedInstanceProperties
	}
	if mi.Location != nil {
		objectMap["location"] = mi.Location
	}
	if mi.Tags != nil {
		objectMap["tags"] = mi.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ManagedInstance struct.
func (mi *ManagedInstance) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "identity":
			if v != nil {
				var identity ResourceIdentity
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				mi.Identity = &identity
			}
		case "sku":
			if v != nil {
				var sku Sku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				mi.Sku = &sku
			}
		case "properties":
			if v != nil {
				var managedInstanceProperties ManagedInstanceProperties
				err = json.Unmarshal(*v, &managedInstanceProperties)
				if err != nil {
					return err
				}
				mi.ManagedInstanceProperties = &managedInstanceProperties
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				mi.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				mi.Tags = tags
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				mi.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				mi.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				mi.Type = &typeVar
			}
		}
	}

	return nil
}

// ManagedInstanceAdministrator an Azure SQL managed instance administrator.
type ManagedInstanceAdministrator struct {
	autorest.Response `json:"-"`
	// ManagedInstanceAdministratorProperties - Resource properties.
	*ManagedInstanceAdministratorProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagedInstanceAdministrator.
func (mia ManagedInstanceAdministrator) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mia.ManagedInstanceAdministratorProperties != nil {
		objectMap["properties"] = mia.ManagedInstanceAdministratorProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ManagedInstanceAdministrator struct.
func (mia *ManagedInstanceAdministrator) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var managedInstanceAdministratorProperties ManagedInstanceAdministratorProperties
				err = json.Unmarshal(*v, &managedInstanceAdministratorProperties)
				if err != nil {
					return err
				}
				mia.ManagedInstanceAdministratorProperties = &managedInstanceAdministratorProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				mia.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				mia.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				mia.Type = &typeVar
			}
		}
	}

	return nil
}

// ManagedInstanceAdministratorListResult a list of managed instance administrators.
type ManagedInstanceAdministratorListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]ManagedInstanceAdministrator `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ManagedInstanceAdministratorListResultIterator provides access to a complete listing of
// ManagedInstanceAdministrator values.
type ManagedInstanceAdministratorListResultIterator struct {
	i    int
	page ManagedInstanceAdministratorListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ManagedInstanceAdministratorListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ManagedInstanceAdministratorListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ManagedInstanceAdministratorListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ManagedInstanceAdministratorListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ManagedInstanceAdministratorListResultIterator) Response() ManagedInstanceAdministratorListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ManagedInstanceAdministratorListResultIterator) Value() ManagedInstanceAdministrator {
	if !iter.page.NotDone() {
		return ManagedInstanceAdministrator{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ManagedInstanceAdministratorListResultIterator type.
func NewManagedInstanceAdministratorListResultIterator(page ManagedInstanceAdministratorListResultPage) ManagedInstanceAdministratorListResultIterator {
	return ManagedInstanceAdministratorListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (mialr ManagedInstanceAdministratorListResult) IsEmpty() bool {
	return mialr.Value == nil || len(*mialr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (mialr ManagedInstanceAdministratorListResult) hasNextLink() bool {
	return mialr.NextLink != nil && len(*mialr.NextLink) != 0
}

// managedInstanceAdministratorListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (mialr ManagedInstanceAdministratorListResult) managedInstanceAdministratorListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !mialr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(mialr.NextLink)))
}

// ManagedInstanceAdministratorListResultPage contains a page of ManagedInstanceAdministrator values.
type ManagedInstanceAdministratorListResultPage struct {
	fn    func(context.Context, ManagedInstanceAdministratorListResult) (ManagedInstanceAdministratorListResult, error)
	mialr ManagedInstanceAdministratorListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ManagedInstanceAdministratorListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ManagedInstanceAdministratorListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.mialr)
		if err != nil {
			return err
		}
		page.mialr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ManagedInstanceAdministratorListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ManagedInstanceAdministratorListResultPage) NotDone() bool {
	return !page.mialr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ManagedInstanceAdministratorListResultPage) Response() ManagedInstanceAdministratorListResult {
	return page.mialr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ManagedInstanceAdministratorListResultPage) Values() []ManagedInstanceAdministrator {
	if page.mialr.IsEmpty() {
		return nil
	}
	return *page.mialr.Value
}

// Creates a new instance of the ManagedInstanceAdministratorListResultPage type.
func NewManagedInstanceAdministratorListResultPage(getNextPage func(context.Context, ManagedInstanceAdministratorListResult) (ManagedInstanceAdministratorListResult, error)) ManagedInstanceAdministratorListResultPage {
	return ManagedInstanceAdministratorListResultPage{fn: getNextPage}
}

// ManagedInstanceAdministratorProperties the properties of a managed instance administrator.
type ManagedInstanceAdministratorProperties struct {
	// AdministratorType - Type of the managed instance administrator.
	AdministratorType *string `json:"administratorType,omitempty"`
	// Login - Login name of the managed instance administrator.
	Login *string `json:"login,omitempty"`
	// Sid - SID (object ID) of the managed instance administrator.
	Sid *uuid.UUID `json:"sid,omitempty"`
	// TenantID - Tenant ID of the managed instance administrator.
	TenantID *uuid.UUID `json:"tenantId,omitempty"`
}

// ManagedInstanceAdministratorsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results
// of a long-running operation.
type ManagedInstanceAdministratorsCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ManagedInstanceAdministratorsCreateOrUpdateFuture) Result(client ManagedInstanceAdministratorsClient) (mia ManagedInstanceAdministrator, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.ManagedInstanceAdministratorsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.ManagedInstanceAdministratorsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if mia.Response.Response, err = future.GetResult(sender); err == nil && mia.Response.Response.StatusCode != http.StatusNoContent {
		mia, err = client.CreateOrUpdateResponder(mia.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.ManagedInstanceAdministratorsCreateOrUpdateFuture", "Result", mia.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ManagedInstanceAdministratorsDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ManagedInstanceAdministratorsDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ManagedInstanceAdministratorsDeleteFuture) Result(client ManagedInstanceAdministratorsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.ManagedInstanceAdministratorsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.ManagedInstanceAdministratorsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ManagedInstanceEditionCapability the managed server capability
type ManagedInstanceEditionCapability struct {
	// Name - READ-ONLY; The managed server version name.
	Name *string `json:"name,omitempty"`
	// SupportedFamilies - READ-ONLY; The supported families.
	SupportedFamilies *[]ManagedInstanceFamilyCapability `json:"supportedFamilies,omitempty"`
	// Status - READ-ONLY; The status of the capability. Possible values include: 'CapabilityStatusVisible', 'CapabilityStatusAvailable', 'CapabilityStatusDefault', 'CapabilityStatusDisabled'
	Status CapabilityStatus `json:"status,omitempty"`
	// Reason - The reason for the capability not being available.
	Reason *string `json:"reason,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagedInstanceEditionCapability.
func (miec ManagedInstanceEditionCapability) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if miec.Reason != nil {
		objectMap["reason"] = miec.Reason
	}
	return json.Marshal(objectMap)
}

// ManagedInstanceEncryptionProtector the managed instance encryption protector.
type ManagedInstanceEncryptionProtector struct {
	autorest.Response `json:"-"`
	// Kind - READ-ONLY; Kind of encryption protector. This is metadata used for the Azure portal experience.
	Kind *string `json:"kind,omitempty"`
	// ManagedInstanceEncryptionProtectorProperties - Resource properties.
	*ManagedInstanceEncryptionProtectorProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagedInstanceEncryptionProtector.
func (miep ManagedInstanceEncryptionProtector) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if miep.ManagedInstanceEncryptionProtectorProperties != nil {
		objectMap["properties"] = miep.ManagedInstanceEncryptionProtectorProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ManagedInstanceEncryptionProtector struct.
func (miep *ManagedInstanceEncryptionProtector) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				miep.Kind = &kind
			}
		case "properties":
			if v != nil {
				var managedInstanceEncryptionProtectorProperties ManagedInstanceEncryptionProtectorProperties
				err = json.Unmarshal(*v, &managedInstanceEncryptionProtectorProperties)
				if err != nil {
					return err
				}
				miep.ManagedInstanceEncryptionProtectorProperties = &managedInstanceEncryptionProtectorProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				miep.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				miep.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				miep.Type = &typeVar
			}
		}
	}

	return nil
}

// ManagedInstanceEncryptionProtectorListResult a list of managed instance encryption protectors.
type ManagedInstanceEncryptionProtectorListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]ManagedInstanceEncryptionProtector `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ManagedInstanceEncryptionProtectorListResultIterator provides access to a complete listing of
// ManagedInstanceEncryptionProtector values.
type ManagedInstanceEncryptionProtectorListResultIterator struct {
	i    int
	page ManagedInstanceEncryptionProtectorListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ManagedInstanceEncryptionProtectorListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ManagedInstanceEncryptionProtectorListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ManagedInstanceEncryptionProtectorListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ManagedInstanceEncryptionProtectorListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ManagedInstanceEncryptionProtectorListResultIterator) Response() ManagedInstanceEncryptionProtectorListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ManagedInstanceEncryptionProtectorListResultIterator) Value() ManagedInstanceEncryptionProtector {
	if !iter.page.NotDone() {
		return ManagedInstanceEncryptionProtector{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ManagedInstanceEncryptionProtectorListResultIterator type.
func NewManagedInstanceEncryptionProtectorListResultIterator(page ManagedInstanceEncryptionProtectorListResultPage) ManagedInstanceEncryptionProtectorListResultIterator {
	return ManagedInstanceEncryptionProtectorListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (mieplr ManagedInstanceEncryptionProtectorListResult) IsEmpty() bool {
	return mieplr.Value == nil || len(*mieplr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (mieplr ManagedInstanceEncryptionProtectorListResult) hasNextLink() bool {
	return mieplr.NextLink != nil && len(*mieplr.NextLink) != 0
}

// managedInstanceEncryptionProtectorListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (mieplr ManagedInstanceEncryptionProtectorListResult) managedInstanceEncryptionProtectorListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !mieplr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(mieplr.NextLink)))
}

// ManagedInstanceEncryptionProtectorListResultPage contains a page of ManagedInstanceEncryptionProtector
// values.
type ManagedInstanceEncryptionProtectorListResultPage struct {
	fn     func(context.Context, ManagedInstanceEncryptionProtectorListResult) (ManagedInstanceEncryptionProtectorListResult, error)
	mieplr ManagedInstanceEncryptionProtectorListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ManagedInstanceEncryptionProtectorListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ManagedInstanceEncryptionProtectorListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.mieplr)
		if err != nil {
			return err
		}
		page.mieplr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ManagedInstanceEncryptionProtectorListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ManagedInstanceEncryptionProtectorListResultPage) NotDone() bool {
	return !page.mieplr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ManagedInstanceEncryptionProtectorListResultPage) Response() ManagedInstanceEncryptionProtectorListResult {
	return page.mieplr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ManagedInstanceEncryptionProtectorListResultPage) Values() []ManagedInstanceEncryptionProtector {
	if page.mieplr.IsEmpty() {
		return nil
	}
	return *page.mieplr.Value
}

// Creates a new instance of the ManagedInstanceEncryptionProtectorListResultPage type.
func NewManagedInstanceEncryptionProtectorListResultPage(getNextPage func(context.Context, ManagedInstanceEncryptionProtectorListResult) (ManagedInstanceEncryptionProtectorListResult, error)) ManagedInstanceEncryptionProtectorListResultPage {
	return ManagedInstanceEncryptionProtectorListResultPage{fn: getNextPage}
}

// ManagedInstanceEncryptionProtectorProperties properties for an encryption protector execution.
type ManagedInstanceEncryptionProtectorProperties struct {
	// ServerKeyName - The name of the managed instance key.
	ServerKeyName *string `json:"serverKeyName,omitempty"`
	// ServerKeyType - The encryption protector type like 'ServiceManaged', 'AzureKeyVault'. Possible values include: 'ServiceManaged', 'AzureKeyVault'
	ServerKeyType ServerKeyType `json:"serverKeyType,omitempty"`
	// URI - READ-ONLY; The URI of the server key.
	URI *string `json:"uri,omitempty"`
	// Thumbprint - READ-ONLY; Thumbprint of the server key.
	Thumbprint *string `json:"thumbprint,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagedInstanceEncryptionProtectorProperties.
func (miepp ManagedInstanceEncryptionProtectorProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if miepp.ServerKeyName != nil {
		objectMap["serverKeyName"] = miepp.ServerKeyName
	}
	if miepp.ServerKeyType != "" {
		objectMap["serverKeyType"] = miepp.ServerKeyType
	}
	return json.Marshal(objectMap)
}

// ManagedInstanceEncryptionProtectorsCreateOrUpdateFuture an abstraction for monitoring and retrieving the
// results of a long-running operation.
type ManagedInstanceEncryptionProtectorsCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ManagedInstanceEncryptionProtectorsCreateOrUpdateFuture) Result(client ManagedInstanceEncryptionProtectorsClient) (miep ManagedInstanceEncryptionProtector, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.ManagedInstanceEncryptionProtectorsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.ManagedInstanceEncryptionProtectorsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if miep.Response.Response, err = future.GetResult(sender); err == nil && miep.Response.Response.StatusCode != http.StatusNoContent {
		miep, err = client.CreateOrUpdateResponder(miep.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.ManagedInstanceEncryptionProtectorsCreateOrUpdateFuture", "Result", miep.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ManagedInstanceEncryptionProtectorsRevalidateFuture an abstraction for monitoring and retrieving the results
// of a long-running operation.
type ManagedInstanceEncryptionProtectorsRevalidateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ManagedInstanceEncryptionProtectorsRevalidateFuture) Result(client ManagedInstanceEncryptionProtectorsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.ManagedInstanceEncryptionProtectorsRevalidateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.ManagedInstanceEncryptionProtectorsRevalidateFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ManagedInstanceFamilyCapability the managed server family capability.
type ManagedInstanceFamilyCapability struct {
	// Name - READ-ONLY; Family name.
	Name *string `json:"name,omitempty"`
	// Sku - READ-ONLY; SKU name.
	Sku *string `json:"sku,omitempty"`
	// SupportedLicenseTypes - READ-ONLY; List of supported license types.
	SupportedLicenseTypes *[]LicenseTypeCapability `json:"supportedLicenseTypes,omitempty"`
	// SupportedVcoresValues - READ-ONLY; List of supported virtual cores values.
	SupportedVcoresValues *[]ManagedInstanceVcoresCapability `json:"supportedVcoresValues,omitempty"`
	// Status - READ-ONLY; The status of the capability. Possible values include: 'CapabilityStatusVisible', 'CapabilityStatusAvailable', 'CapabilityStatusDefault', 'CapabilityStatusDisabled'
	Status CapabilityStatus `json:"status,omitempty"`
	// Reason - The reason for the capability not being available.
	Reason *string `json:"reason,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagedInstanceFamilyCapability.
func (mifc ManagedInstanceFamilyCapability) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mifc.Reason != nil {
		objectMap["reason"] = mifc.Reason
	}
	return json.Marshal(objectMap)
}

// ManagedInstanceKey a managed instance key.
type ManagedInstanceKey struct {
	autorest.Response `json:"-"`
	// Kind - READ-ONLY; Kind of encryption protector. This is metadata used for the Azure portal experience.
	Kind *string `json:"kind,omitempty"`
	// ManagedInstanceKeyProperties - Resource properties.
	*ManagedInstanceKeyProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagedInstanceKey.
func (mik ManagedInstanceKey) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mik.ManagedInstanceKeyProperties != nil {
		objectMap["properties"] = mik.ManagedInstanceKeyProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ManagedInstanceKey struct.
func (mik *ManagedInstanceKey) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				mik.Kind = &kind
			}
		case "properties":
			if v != nil {
				var managedInstanceKeyProperties ManagedInstanceKeyProperties
				err = json.Unmarshal(*v, &managedInstanceKeyProperties)
				if err != nil {
					return err
				}
				mik.ManagedInstanceKeyProperties = &managedInstanceKeyProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				mik.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				mik.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				mik.Type = &typeVar
			}
		}
	}

	return nil
}

// ManagedInstanceKeyListResult a list of managed instance keys.
type ManagedInstanceKeyListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]ManagedInstanceKey `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ManagedInstanceKeyListResultIterator provides access to a complete listing of ManagedInstanceKey values.
type ManagedInstanceKeyListResultIterator struct {
	i    int
	page ManagedInstanceKeyListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ManagedInstanceKeyListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ManagedInstanceKeyListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ManagedInstanceKeyListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ManagedInstanceKeyListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ManagedInstanceKeyListResultIterator) Response() ManagedInstanceKeyListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ManagedInstanceKeyListResultIterator) Value() ManagedInstanceKey {
	if !iter.page.NotDone() {
		return ManagedInstanceKey{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ManagedInstanceKeyListResultIterator type.
func NewManagedInstanceKeyListResultIterator(page ManagedInstanceKeyListResultPage) ManagedInstanceKeyListResultIterator {
	return ManagedInstanceKeyListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (miklr ManagedInstanceKeyListResult) IsEmpty() bool {
	return miklr.Value == nil || len(*miklr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (miklr ManagedInstanceKeyListResult) hasNextLink() bool {
	return miklr.NextLink != nil && len(*miklr.NextLink) != 0
}

// managedInstanceKeyListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (miklr ManagedInstanceKeyListResult) managedInstanceKeyListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !miklr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(miklr.NextLink)))
}

// ManagedInstanceKeyListResultPage contains a page of ManagedInstanceKey values.
type ManagedInstanceKeyListResultPage struct {
	fn    func(context.Context, ManagedInstanceKeyListResult) (ManagedInstanceKeyListResult, error)
	miklr ManagedInstanceKeyListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ManagedInstanceKeyListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ManagedInstanceKeyListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.miklr)
		if err != nil {
			return err
		}
		page.miklr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ManagedInstanceKeyListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ManagedInstanceKeyListResultPage) NotDone() bool {
	return !page.miklr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ManagedInstanceKeyListResultPage) Response() ManagedInstanceKeyListResult {
	return page.miklr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ManagedInstanceKeyListResultPage) Values() []ManagedInstanceKey {
	if page.miklr.IsEmpty() {
		return nil
	}
	return *page.miklr.Value
}

// Creates a new instance of the ManagedInstanceKeyListResultPage type.
func NewManagedInstanceKeyListResultPage(getNextPage func(context.Context, ManagedInstanceKeyListResult) (ManagedInstanceKeyListResult, error)) ManagedInstanceKeyListResultPage {
	return ManagedInstanceKeyListResultPage{fn: getNextPage}
}

// ManagedInstanceKeyProperties properties for a key execution.
type ManagedInstanceKeyProperties struct {
	// ServerKeyType - The key type like 'ServiceManaged', 'AzureKeyVault'. Possible values include: 'ServiceManaged', 'AzureKeyVault'
	ServerKeyType ServerKeyType `json:"serverKeyType,omitempty"`
	// URI - The URI of the key. If the ServerKeyType is AzureKeyVault, then the URI is required.
	URI *string `json:"uri,omitempty"`
	// Thumbprint - READ-ONLY; Thumbprint of the key.
	Thumbprint *string `json:"thumbprint,omitempty"`
	// CreationDate - READ-ONLY; The key creation date.
	CreationDate *date.Time `json:"creationDate,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagedInstanceKeyProperties.
func (mikp ManagedInstanceKeyProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mikp.ServerKeyType != "" {
		objectMap["serverKeyType"] = mikp.ServerKeyType
	}
	if mikp.URI != nil {
		objectMap["uri"] = mikp.URI
	}
	return json.Marshal(objectMap)
}

// ManagedInstanceKeysCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ManagedInstanceKeysCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ManagedInstanceKeysCreateOrUpdateFuture) Result(client ManagedInstanceKeysClient) (mik ManagedInstanceKey, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.ManagedInstanceKeysCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.ManagedInstanceKeysCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if mik.Response.Response, err = future.GetResult(sender); err == nil && mik.Response.Response.StatusCode != http.StatusNoContent {
		mik, err = client.CreateOrUpdateResponder(mik.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.ManagedInstanceKeysCreateOrUpdateFuture", "Result", mik.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ManagedInstanceKeysDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ManagedInstanceKeysDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ManagedInstanceKeysDeleteFuture) Result(client ManagedInstanceKeysClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.ManagedInstanceKeysDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.ManagedInstanceKeysDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ManagedInstanceListResult a list of managed instances.
type ManagedInstanceListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]ManagedInstance `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ManagedInstanceListResultIterator provides access to a complete listing of ManagedInstance values.
type ManagedInstanceListResultIterator struct {
	i    int
	page ManagedInstanceListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ManagedInstanceListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ManagedInstanceListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ManagedInstanceListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ManagedInstanceListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ManagedInstanceListResultIterator) Response() ManagedInstanceListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ManagedInstanceListResultIterator) Value() ManagedInstance {
	if !iter.page.NotDone() {
		return ManagedInstance{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ManagedInstanceListResultIterator type.
func NewManagedInstanceListResultIterator(page ManagedInstanceListResultPage) ManagedInstanceListResultIterator {
	return ManagedInstanceListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (milr ManagedInstanceListResult) IsEmpty() bool {
	return milr.Value == nil || len(*milr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (milr ManagedInstanceListResult) hasNextLink() bool {
	return milr.NextLink != nil && len(*milr.NextLink) != 0
}

// managedInstanceListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (milr ManagedInstanceListResult) managedInstanceListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !milr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(milr.NextLink)))
}

// ManagedInstanceListResultPage contains a page of ManagedInstance values.
type ManagedInstanceListResultPage struct {
	fn   func(context.Context, ManagedInstanceListResult) (ManagedInstanceListResult, error)
	milr ManagedInstanceListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ManagedInstanceListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ManagedInstanceListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.milr)
		if err != nil {
			return err
		}
		page.milr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ManagedInstanceListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ManagedInstanceListResultPage) NotDone() bool {
	return !page.milr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ManagedInstanceListResultPage) Response() ManagedInstanceListResult {
	return page.milr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ManagedInstanceListResultPage) Values() []ManagedInstance {
	if page.milr.IsEmpty() {
		return nil
	}
	return *page.milr.Value
}

// Creates a new instance of the ManagedInstanceListResultPage type.
func NewManagedInstanceListResultPage(getNextPage func(context.Context, ManagedInstanceListResult) (ManagedInstanceListResult, error)) ManagedInstanceListResultPage {
	return ManagedInstanceListResultPage{fn: getNextPage}
}

// ManagedInstanceLongTermRetentionBackup a long term retention backup for a managed database.
type ManagedInstanceLongTermRetentionBackup struct {
	autorest.Response `json:"-"`
	// ManagedInstanceLongTermRetentionBackupProperties - Resource properties.
	*ManagedInstanceLongTermRetentionBackupProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagedInstanceLongTermRetentionBackup.
func (miltrb ManagedInstanceLongTermRetentionBackup) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if miltrb.ManagedInstanceLongTermRetentionBackupProperties != nil {
		objectMap["properties"] = miltrb.ManagedInstanceLongTermRetentionBackupProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ManagedInstanceLongTermRetentionBackup struct.
func (miltrb *ManagedInstanceLongTermRetentionBackup) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var managedInstanceLongTermRetentionBackupProperties ManagedInstanceLongTermRetentionBackupProperties
				err = json.Unmarshal(*v, &managedInstanceLongTermRetentionBackupProperties)
				if err != nil {
					return err
				}
				miltrb.ManagedInstanceLongTermRetentionBackupProperties = &managedInstanceLongTermRetentionBackupProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				miltrb.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				miltrb.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				miltrb.Type = &typeVar
			}
		}
	}

	return nil
}

// ManagedInstanceLongTermRetentionBackupListResult a list of long term retention backups for managed
// database(s).
type ManagedInstanceLongTermRetentionBackupListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]ManagedInstanceLongTermRetentionBackup `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ManagedInstanceLongTermRetentionBackupListResultIterator provides access to a complete listing of
// ManagedInstanceLongTermRetentionBackup values.
type ManagedInstanceLongTermRetentionBackupListResultIterator struct {
	i    int
	page ManagedInstanceLongTermRetentionBackupListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ManagedInstanceLongTermRetentionBackupListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ManagedInstanceLongTermRetentionBackupListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ManagedInstanceLongTermRetentionBackupListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ManagedInstanceLongTermRetentionBackupListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ManagedInstanceLongTermRetentionBackupListResultIterator) Response() ManagedInstanceLongTermRetentionBackupListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ManagedInstanceLongTermRetentionBackupListResultIterator) Value() ManagedInstanceLongTermRetentionBackup {
	if !iter.page.NotDone() {
		return ManagedInstanceLongTermRetentionBackup{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ManagedInstanceLongTermRetentionBackupListResultIterator type.
func NewManagedInstanceLongTermRetentionBackupListResultIterator(page ManagedInstanceLongTermRetentionBackupListResultPage) ManagedInstanceLongTermRetentionBackupListResultIterator {
	return ManagedInstanceLongTermRetentionBackupListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (miltrblr ManagedInstanceLongTermRetentionBackupListResult) IsEmpty() bool {
	return miltrblr.Value == nil || len(*miltrblr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (miltrblr ManagedInstanceLongTermRetentionBackupListResult) hasNextLink() bool {
	return miltrblr.NextLink != nil && len(*miltrblr.NextLink) != 0
}

// managedInstanceLongTermRetentionBackupListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (miltrblr ManagedInstanceLongTermRetentionBackupListResult) managedInstanceLongTermRetentionBackupListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !miltrblr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(miltrblr.NextLink)))
}

// ManagedInstanceLongTermRetentionBackupListResultPage contains a page of
// ManagedInstanceLongTermRetentionBackup values.
type ManagedInstanceLongTermRetentionBackupListResultPage struct {
	fn       func(context.Context, ManagedInstanceLongTermRetentionBackupListResult) (ManagedInstanceLongTermRetentionBackupListResult, error)
	miltrblr ManagedInstanceLongTermRetentionBackupListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ManagedInstanceLongTermRetentionBackupListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ManagedInstanceLongTermRetentionBackupListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.miltrblr)
		if err != nil {
			return err
		}
		page.miltrblr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ManagedInstanceLongTermRetentionBackupListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ManagedInstanceLongTermRetentionBackupListResultPage) NotDone() bool {
	return !page.miltrblr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ManagedInstanceLongTermRetentionBackupListResultPage) Response() ManagedInstanceLongTermRetentionBackupListResult {
	return page.miltrblr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ManagedInstanceLongTermRetentionBackupListResultPage) Values() []ManagedInstanceLongTermRetentionBackup {
	if page.miltrblr.IsEmpty() {
		return nil
	}
	return *page.miltrblr.Value
}

// Creates a new instance of the ManagedInstanceLongTermRetentionBackupListResultPage type.
func NewManagedInstanceLongTermRetentionBackupListResultPage(getNextPage func(context.Context, ManagedInstanceLongTermRetentionBackupListResult) (ManagedInstanceLongTermRetentionBackupListResult, error)) ManagedInstanceLongTermRetentionBackupListResultPage {
	return ManagedInstanceLongTermRetentionBackupListResultPage{fn: getNextPage}
}

// ManagedInstanceLongTermRetentionBackupProperties properties of a long term retention backup
type ManagedInstanceLongTermRetentionBackupProperties struct {
	// ManagedInstanceName - READ-ONLY; The managed instance that the backup database belongs to.
	ManagedInstanceName *string `json:"managedInstanceName,omitempty"`
	// ManagedInstanceCreateTime - READ-ONLY; The create time of the instance.
	ManagedInstanceCreateTime *date.Time `json:"managedInstanceCreateTime,omitempty"`
	// DatabaseName - READ-ONLY; The name of the database the backup belong to
	DatabaseName *string `json:"databaseName,omitempty"`
	// DatabaseDeletionTime - READ-ONLY; The delete time of the database
	DatabaseDeletionTime *date.Time `json:"databaseDeletionTime,omitempty"`
	// BackupTime - READ-ONLY; The time the backup was taken
	BackupTime *date.Time `json:"backupTime,omitempty"`
	// BackupExpirationTime - READ-ONLY; The time the long term retention backup will expire.
	BackupExpirationTime *date.Time `json:"backupExpirationTime,omitempty"`
}

// ManagedInstanceLongTermRetentionPoliciesCreateOrUpdateFuture an abstraction for monitoring and retrieving
// the results of a long-running operation.
type ManagedInstanceLongTermRetentionPoliciesCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ManagedInstanceLongTermRetentionPoliciesCreateOrUpdateFuture) Result(client ManagedInstanceLongTermRetentionPoliciesClient) (miltrp ManagedInstanceLongTermRetentionPolicy, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.ManagedInstanceLongTermRetentionPoliciesCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.ManagedInstanceLongTermRetentionPoliciesCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if miltrp.Response.Response, err = future.GetResult(sender); err == nil && miltrp.Response.Response.StatusCode != http.StatusNoContent {
		miltrp, err = client.CreateOrUpdateResponder(miltrp.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.ManagedInstanceLongTermRetentionPoliciesCreateOrUpdateFuture", "Result", miltrp.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ManagedInstanceLongTermRetentionPolicy a long term retention policy.
type ManagedInstanceLongTermRetentionPolicy struct {
	autorest.Response `json:"-"`
	// BaseLongTermRetentionPolicyProperties - Resource properties.
	*BaseLongTermRetentionPolicyProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagedInstanceLongTermRetentionPolicy.
func (miltrp ManagedInstanceLongTermRetentionPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if miltrp.BaseLongTermRetentionPolicyProperties != nil {
		objectMap["properties"] = miltrp.BaseLongTermRetentionPolicyProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ManagedInstanceLongTermRetentionPolicy struct.
func (miltrp *ManagedInstanceLongTermRetentionPolicy) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var baseLongTermRetentionPolicyProperties BaseLongTermRetentionPolicyProperties
				err = json.Unmarshal(*v, &baseLongTermRetentionPolicyProperties)
				if err != nil {
					return err
				}
				miltrp.BaseLongTermRetentionPolicyProperties = &baseLongTermRetentionPolicyProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				miltrp.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				miltrp.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				miltrp.Type = &typeVar
			}
		}
	}

	return nil
}

// ManagedInstanceLongTermRetentionPolicyListResult a list of long term retention policies.
type ManagedInstanceLongTermRetentionPolicyListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]ManagedInstanceLongTermRetentionPolicy `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ManagedInstanceLongTermRetentionPolicyListResultIterator provides access to a complete listing of
// ManagedInstanceLongTermRetentionPolicy values.
type ManagedInstanceLongTermRetentionPolicyListResultIterator struct {
	i    int
	page ManagedInstanceLongTermRetentionPolicyListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ManagedInstanceLongTermRetentionPolicyListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ManagedInstanceLongTermRetentionPolicyListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ManagedInstanceLongTermRetentionPolicyListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ManagedInstanceLongTermRetentionPolicyListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ManagedInstanceLongTermRetentionPolicyListResultIterator) Response() ManagedInstanceLongTermRetentionPolicyListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ManagedInstanceLongTermRetentionPolicyListResultIterator) Value() ManagedInstanceLongTermRetentionPolicy {
	if !iter.page.NotDone() {
		return ManagedInstanceLongTermRetentionPolicy{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ManagedInstanceLongTermRetentionPolicyListResultIterator type.
func NewManagedInstanceLongTermRetentionPolicyListResultIterator(page ManagedInstanceLongTermRetentionPolicyListResultPage) ManagedInstanceLongTermRetentionPolicyListResultIterator {
	return ManagedInstanceLongTermRetentionPolicyListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (miltrplr ManagedInstanceLongTermRetentionPolicyListResult) IsEmpty() bool {
	return miltrplr.Value == nil || len(*miltrplr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (miltrplr ManagedInstanceLongTermRetentionPolicyListResult) hasNextLink() bool {
	return miltrplr.NextLink != nil && len(*miltrplr.NextLink) != 0
}

// managedInstanceLongTermRetentionPolicyListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (miltrplr ManagedInstanceLongTermRetentionPolicyListResult) managedInstanceLongTermRetentionPolicyListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !miltrplr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(miltrplr.NextLink)))
}

// ManagedInstanceLongTermRetentionPolicyListResultPage contains a page of
// ManagedInstanceLongTermRetentionPolicy values.
type ManagedInstanceLongTermRetentionPolicyListResultPage struct {
	fn       func(context.Context, ManagedInstanceLongTermRetentionPolicyListResult) (ManagedInstanceLongTermRetentionPolicyListResult, error)
	miltrplr ManagedInstanceLongTermRetentionPolicyListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ManagedInstanceLongTermRetentionPolicyListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ManagedInstanceLongTermRetentionPolicyListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.miltrplr)
		if err != nil {
			return err
		}
		page.miltrplr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ManagedInstanceLongTermRetentionPolicyListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ManagedInstanceLongTermRetentionPolicyListResultPage) NotDone() bool {
	return !page.miltrplr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ManagedInstanceLongTermRetentionPolicyListResultPage) Response() ManagedInstanceLongTermRetentionPolicyListResult {
	return page.miltrplr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ManagedInstanceLongTermRetentionPolicyListResultPage) Values() []ManagedInstanceLongTermRetentionPolicy {
	if page.miltrplr.IsEmpty() {
		return nil
	}
	return *page.miltrplr.Value
}

// Creates a new instance of the ManagedInstanceLongTermRetentionPolicyListResultPage type.
func NewManagedInstanceLongTermRetentionPolicyListResultPage(getNextPage func(context.Context, ManagedInstanceLongTermRetentionPolicyListResult) (ManagedInstanceLongTermRetentionPolicyListResult, error)) ManagedInstanceLongTermRetentionPolicyListResultPage {
	return ManagedInstanceLongTermRetentionPolicyListResultPage{fn: getNextPage}
}

// ManagedInstanceOperation a managed instance operation.
type ManagedInstanceOperation struct {
	autorest.Response `json:"-"`
	// ManagedInstanceOperationProperties - Resource properties.
	*ManagedInstanceOperationProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagedInstanceOperation.
func (mio ManagedInstanceOperation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mio.ManagedInstanceOperationProperties != nil {
		objectMap["properties"] = mio.ManagedInstanceOperationProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ManagedInstanceOperation struct.
func (mio *ManagedInstanceOperation) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var managedInstanceOperationProperties ManagedInstanceOperationProperties
				err = json.Unmarshal(*v, &managedInstanceOperationProperties)
				if err != nil {
					return err
				}
				mio.ManagedInstanceOperationProperties = &managedInstanceOperationProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				mio.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				mio.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				mio.Type = &typeVar
			}
		}
	}

	return nil
}

// ManagedInstanceOperationListResult the response to a list managed instance operations request
type ManagedInstanceOperationListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]ManagedInstanceOperation `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ManagedInstanceOperationListResultIterator provides access to a complete listing of ManagedInstanceOperation
// values.
type ManagedInstanceOperationListResultIterator struct {
	i    int
	page ManagedInstanceOperationListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ManagedInstanceOperationListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ManagedInstanceOperationListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ManagedInstanceOperationListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ManagedInstanceOperationListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ManagedInstanceOperationListResultIterator) Response() ManagedInstanceOperationListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ManagedInstanceOperationListResultIterator) Value() ManagedInstanceOperation {
	if !iter.page.NotDone() {
		return ManagedInstanceOperation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ManagedInstanceOperationListResultIterator type.
func NewManagedInstanceOperationListResultIterator(page ManagedInstanceOperationListResultPage) ManagedInstanceOperationListResultIterator {
	return ManagedInstanceOperationListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (miolr ManagedInstanceOperationListResult) IsEmpty() bool {
	return miolr.Value == nil || len(*miolr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (miolr ManagedInstanceOperationListResult) hasNextLink() bool {
	return miolr.NextLink != nil && len(*miolr.NextLink) != 0
}

// managedInstanceOperationListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (miolr ManagedInstanceOperationListResult) managedInstanceOperationListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !miolr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(miolr.NextLink)))
}

// ManagedInstanceOperationListResultPage contains a page of ManagedInstanceOperation values.
type ManagedInstanceOperationListResultPage struct {
	fn    func(context.Context, ManagedInstanceOperationListResult) (ManagedInstanceOperationListResult, error)
	miolr ManagedInstanceOperationListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ManagedInstanceOperationListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ManagedInstanceOperationListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.miolr)
		if err != nil {
			return err
		}
		page.miolr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ManagedInstanceOperationListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ManagedInstanceOperationListResultPage) NotDone() bool {
	return !page.miolr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ManagedInstanceOperationListResultPage) Response() ManagedInstanceOperationListResult {
	return page.miolr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ManagedInstanceOperationListResultPage) Values() []ManagedInstanceOperation {
	if page.miolr.IsEmpty() {
		return nil
	}
	return *page.miolr.Value
}

// Creates a new instance of the ManagedInstanceOperationListResultPage type.
func NewManagedInstanceOperationListResultPage(getNextPage func(context.Context, ManagedInstanceOperationListResult) (ManagedInstanceOperationListResult, error)) ManagedInstanceOperationListResultPage {
	return ManagedInstanceOperationListResultPage{fn: getNextPage}
}

// ManagedInstanceOperationParametersPair the parameters of a managed instance operation.
type ManagedInstanceOperationParametersPair struct {
	// CurrentParameters - READ-ONLY; The current parameters.
	CurrentParameters *UpsertManagedServerOperationParameters `json:"currentParameters,omitempty"`
	// RequestedParameters - READ-ONLY; The requested parameters.
	RequestedParameters *UpsertManagedServerOperationParameters `json:"requestedParameters,omitempty"`
}

// ManagedInstanceOperationProperties the properties of a managed instance operation.
type ManagedInstanceOperationProperties struct {
	// ManagedInstanceName - READ-ONLY; The name of the managed instance the operation is being performed on.
	ManagedInstanceName *string `json:"managedInstanceName,omitempty"`
	// Operation - READ-ONLY; The name of operation.
	Operation *string `json:"operation,omitempty"`
	// OperationFriendlyName - READ-ONLY; The friendly name of operation.
	OperationFriendlyName *string `json:"operationFriendlyName,omitempty"`
	// PercentComplete - READ-ONLY; The percentage of the operation completed.
	PercentComplete *int32 `json:"percentComplete,omitempty"`
	// StartTime - READ-ONLY; The operation start time.
	StartTime *date.Time `json:"startTime,omitempty"`
	// State - READ-ONLY; The operation state. Possible values include: 'ManagementOperationStatePending', 'ManagementOperationStateInProgress', 'ManagementOperationStateSucceeded', 'ManagementOperationStateFailed', 'ManagementOperationStateCancelInProgress', 'ManagementOperationStateCancelled'
	State ManagementOperationState `json:"state,omitempty"`
	// ErrorCode - READ-ONLY; The operation error code.
	ErrorCode *int32 `json:"errorCode,omitempty"`
	// ErrorDescription - READ-ONLY; The operation error description.
	ErrorDescription *string `json:"errorDescription,omitempty"`
	// ErrorSeverity - READ-ONLY; The operation error severity.
	ErrorSeverity *int32 `json:"errorSeverity,omitempty"`
	// IsUserError - READ-ONLY; Whether or not the error is a user error.
	IsUserError *bool `json:"isUserError,omitempty"`
	// EstimatedCompletionTime - READ-ONLY; The estimated completion time of the operation.
	EstimatedCompletionTime *date.Time `json:"estimatedCompletionTime,omitempty"`
	// Description - READ-ONLY; The operation description.
	Description *string `json:"description,omitempty"`
	// IsCancellable - READ-ONLY; Whether the operation can be cancelled.
	IsCancellable *bool `json:"isCancellable,omitempty"`
	// OperationParameters - READ-ONLY; The operation parameters.
	OperationParameters *ManagedInstanceOperationParametersPair `json:"operationParameters,omitempty"`
	// OperationSteps - READ-ONLY; The operation steps.
	OperationSteps *ManagedInstanceOperationSteps `json:"operationSteps,omitempty"`
}

// ManagedInstanceOperationSteps the steps of a managed instance operation.
type ManagedInstanceOperationSteps struct {
	// TotalSteps - READ-ONLY; The total number of operation steps.
	TotalSteps *string `json:"totalSteps,omitempty"`
	// CurrentStep - READ-ONLY; The number of current operation steps.
	CurrentStep *int32 `json:"currentStep,omitempty"`
	// StepsList - READ-ONLY; The operation steps list.
	StepsList *[]UpsertManagedServerOperationStep `json:"stepsList,omitempty"`
}

// ManagedInstancePairInfo pairs of Managed Instances in the failover group.
type ManagedInstancePairInfo struct {
	// PrimaryManagedInstanceID - Id of Primary Managed Instance in pair.
	PrimaryManagedInstanceID *string `json:"primaryManagedInstanceId,omitempty"`
	// PartnerManagedInstanceID - Id of Partner Managed Instance in pair.
	PartnerManagedInstanceID *string `json:"partnerManagedInstanceId,omitempty"`
}

// ManagedInstanceProperties the properties of a managed instance.
type ManagedInstanceProperties struct {
	// ManagedInstanceCreateMode - Specifies the mode of database creation.
	//
	// Default: Regular instance creation.
	//
	// Restore: Creates an instance by restoring a set of backups to specific point in time. RestorePointInTime and SourceManagedInstanceId must be specified. Possible values include: 'ManagedServerCreateModeDefault', 'ManagedServerCreateModePointInTimeRestore'
	ManagedInstanceCreateMode ManagedServerCreateMode `json:"managedInstanceCreateMode,omitempty"`
	// FullyQualifiedDomainName - READ-ONLY; The fully qualified domain name of the managed instance.
	FullyQualifiedDomainName *string `json:"fullyQualifiedDomainName,omitempty"`
	// AdministratorLogin - Administrator username for the managed instance. Can only be specified when the managed instance is being created (and is required for creation).
	AdministratorLogin *string `json:"administratorLogin,omitempty"`
	// AdministratorLoginPassword - The administrator login password (required for managed instance creation).
	AdministratorLoginPassword *string `json:"administratorLoginPassword,omitempty"`
	// SubnetID - Subnet resource ID for the managed instance.
	SubnetID *string `json:"subnetId,omitempty"`
	// State - READ-ONLY; The state of the managed instance.
	State *string `json:"state,omitempty"`
	// LicenseType - The license type. Possible values are 'LicenseIncluded' (regular price inclusive of a new SQL license) and 'BasePrice' (discounted AHB price for bringing your own SQL licenses). Possible values include: 'ManagedInstanceLicenseTypeLicenseIncluded', 'ManagedInstanceLicenseTypeBasePrice'
	LicenseType ManagedInstanceLicenseType `json:"licenseType,omitempty"`
	// VCores - The number of vCores. Allowed values: 8, 16, 24, 32, 40, 64, 80.
	VCores *int32 `json:"vCores,omitempty"`
	// StorageSizeInGB - Storage size in GB. Minimum value: 32. Maximum value: 8192. Increments of 32 GB allowed only.
	StorageSizeInGB *int32 `json:"storageSizeInGB,omitempty"`
	// Collation - Collation of the managed instance.
	Collation *string `json:"collation,omitempty"`
	// DNSZone - READ-ONLY; The Dns Zone that the managed instance is in.
	DNSZone *string `json:"dnsZone,omitempty"`
	// DNSZonePartner - The resource id of another managed instance whose DNS zone this managed instance will share after creation.
	DNSZonePartner *string `json:"dnsZonePartner,omitempty"`
	// PublicDataEndpointEnabled - Whether or not the public data endpoint is enabled.
	PublicDataEndpointEnabled *bool `json:"publicDataEndpointEnabled,omitempty"`
	// SourceManagedInstanceID - The resource identifier of the source managed instance associated with create operation of this instance.
	SourceManagedInstanceID *string `json:"sourceManagedInstanceId,omitempty"`
	// RestorePointInTime - Specifies the point in time (ISO8601 format) of the source database that will be restored to create the new database.
	RestorePointInTime *date.Time `json:"restorePointInTime,omitempty"`
	// ProxyOverride - Connection type used for connecting to the instance. Possible values include: 'ManagedInstanceProxyOverrideProxy', 'ManagedInstanceProxyOverrideRedirect', 'ManagedInstanceProxyOverrideDefault'
	ProxyOverride ManagedInstanceProxyOverride `json:"proxyOverride,omitempty"`
	// TimezoneID - Id of the timezone. Allowed values are timezones supported by Windows.
	// Windows keeps details on supported timezones, including the id, in registry under
	// KEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Time Zones.
	// You can get those registry values via SQL Server by querying SELECT name AS timezone_id FROM sys.time_zone_info.
	// List of Ids can also be obtained by executing [System.TimeZoneInfo]::GetSystemTimeZones() in PowerShell.
	// An example of valid timezone id is "Pacific Standard Time" or "W. Europe Standard Time".
	TimezoneID *string `json:"timezoneId,omitempty"`
	// InstancePoolID - The Id of the instance pool this managed server belongs to.
	InstancePoolID *string `json:"instancePoolId,omitempty"`
	// MaintenanceConfigurationID - Specifies maintenance configuration id to apply to this managed instance.
	MaintenanceConfigurationID *string `json:"maintenanceConfigurationId,omitempty"`
	// MinimalTLSVersion - Minimal TLS version. Allowed values: 'None', '1.0', '1.1', '1.2'
	MinimalTLSVersion *string `json:"minimalTlsVersion,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagedInstanceProperties.
func (mip ManagedInstanceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mip.ManagedInstanceCreateMode != "" {
		objectMap["managedInstanceCreateMode"] = mip.ManagedInstanceCreateMode
	}
	if mip.AdministratorLogin != nil {
		objectMap["administratorLogin"] = mip.AdministratorLogin
	}
	if mip.AdministratorLoginPassword != nil {
		objectMap["administratorLoginPassword"] = mip.AdministratorLoginPassword
	}
	if mip.SubnetID != nil {
		objectMap["subnetId"] = mip.SubnetID
	}
	if mip.LicenseType != "" {
		objectMap["licenseType"] = mip.LicenseType
	}
	if mip.VCores != nil {
		objectMap["vCores"] = mip.VCores
	}
	if mip.StorageSizeInGB != nil {
		objectMap["storageSizeInGB"] = mip.StorageSizeInGB
	}
	if mip.Collation != nil {
		objectMap["collation"] = mip.Collation
	}
	if mip.DNSZonePartner != nil {
		objectMap["dnsZonePartner"] = mip.DNSZonePartner
	}
	if mip.PublicDataEndpointEnabled != nil {
		objectMap["publicDataEndpointEnabled"] = mip.PublicDataEndpointEnabled
	}
	if mip.SourceManagedInstanceID != nil {
		objectMap["sourceManagedInstanceId"] = mip.SourceManagedInstanceID
	}
	if mip.RestorePointInTime != nil {
		objectMap["restorePointInTime"] = mip.RestorePointInTime
	}
	if mip.ProxyOverride != "" {
		objectMap["proxyOverride"] = mip.ProxyOverride
	}
	if mip.TimezoneID != nil {
		objectMap["timezoneId"] = mip.TimezoneID
	}
	if mip.InstancePoolID != nil {
		objectMap["instancePoolId"] = mip.InstancePoolID
	}
	if mip.MaintenanceConfigurationID != nil {
		objectMap["maintenanceConfigurationId"] = mip.MaintenanceConfigurationID
	}
	if mip.MinimalTLSVersion != nil {
		objectMap["minimalTlsVersion"] = mip.MinimalTLSVersion
	}
	return json.Marshal(objectMap)
}

// ManagedInstancesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ManagedInstancesCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ManagedInstancesCreateOrUpdateFuture) Result(client ManagedInstancesClient) (mi ManagedInstance, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.ManagedInstancesCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.ManagedInstancesCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if mi.Response.Response, err = future.GetResult(sender); err == nil && mi.Response.Response.StatusCode != http.StatusNoContent {
		mi, err = client.CreateOrUpdateResponder(mi.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.ManagedInstancesCreateOrUpdateFuture", "Result", mi.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ManagedInstancesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ManagedInstancesDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ManagedInstancesDeleteFuture) Result(client ManagedInstancesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.ManagedInstancesDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.ManagedInstancesDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ManagedInstancesFailoverFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ManagedInstancesFailoverFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ManagedInstancesFailoverFuture) Result(client ManagedInstancesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.ManagedInstancesFailoverFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.ManagedInstancesFailoverFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ManagedInstancesUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ManagedInstancesUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ManagedInstancesUpdateFuture) Result(client ManagedInstancesClient) (mi ManagedInstance, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.ManagedInstancesUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.ManagedInstancesUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if mi.Response.Response, err = future.GetResult(sender); err == nil && mi.Response.Response.StatusCode != http.StatusNoContent {
		mi, err = client.UpdateResponder(mi.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.ManagedInstancesUpdateFuture", "Result", mi.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ManagedInstanceTdeCertificatesCreateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ManagedInstanceTdeCertificatesCreateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ManagedInstanceTdeCertificatesCreateFuture) Result(client ManagedInstanceTdeCertificatesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.ManagedInstanceTdeCertificatesCreateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.ManagedInstanceTdeCertificatesCreateFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ManagedInstanceUpdate an update request for an Azure SQL Database managed instance.
type ManagedInstanceUpdate struct {
	// Sku - Managed instance sku
	Sku *Sku `json:"sku,omitempty"`
	// ManagedInstanceProperties - Resource properties.
	*ManagedInstanceProperties `json:"properties,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ManagedInstanceUpdate.
func (miu ManagedInstanceUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if miu.Sku != nil {
		objectMap["sku"] = miu.Sku
	}
	if miu.ManagedInstanceProperties != nil {
		objectMap["properties"] = miu.ManagedInstanceProperties
	}
	if miu.Tags != nil {
		objectMap["tags"] = miu.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ManagedInstanceUpdate struct.
func (miu *ManagedInstanceUpdate) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "sku":
			if v != nil {
				var sku Sku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				miu.Sku = &sku
			}
		case "properties":
			if v != nil {
				var managedInstanceProperties ManagedInstanceProperties
				err = json.Unmarshal(*v, &managedInstanceProperties)
				if err != nil {
					return err
				}
				miu.ManagedInstanceProperties = &managedInstanceProperties
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				miu.Tags = tags
			}
		}
	}

	return nil
}

// ManagedInstanceVcoresCapability the managed instance virtual cores capability.
type ManagedInstanceVcoresCapability struct {
	// Name - READ-ONLY; The virtual cores identifier.
	Name *string `json:"name,omitempty"`
	// Value - READ-ONLY; The virtual cores value.
	Value *int32 `json:"value,omitempty"`
	// IncludedMaxSize - READ-ONLY; Included size.
	IncludedMaxSize *MaxSizeCapability `json:"includedMaxSize,omitempty"`
	// SupportedStorageSizes - READ-ONLY; Storage size ranges.
	SupportedStorageSizes *[]MaxSizeRangeCapability `json:"supportedStorageSizes,omitempty"`
	// InstancePoolSupported - READ-ONLY; True if this service objective is supported for managed instances in an instance pool.
	InstancePoolSupported *bool `json:"instancePoolSupported,omitempty"`
	// StandaloneSupported - READ-ONLY; True if this service objective is supported for standalone managed instances.
	StandaloneSupported *bool `json:"standaloneSupported,omitempty"`
	// Status - READ-ONLY; The status of the capability. Possible values include: 'CapabilityStatusVisible', 'CapabilityStatusAvailable', 'CapabilityStatusDefault', 'CapabilityStatusDisabled'
	Status CapabilityStatus `json:"status,omitempty"`
	// Reason - The reason for the capability not being available.
	Reason *string `json:"reason,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagedInstanceVcoresCapability.
func (mivc ManagedInstanceVcoresCapability) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mivc.Reason != nil {
		objectMap["reason"] = mivc.Reason
	}
	return json.Marshal(objectMap)
}

// ManagedInstanceVersionCapability the managed instance capability
type ManagedInstanceVersionCapability struct {
	// Name - READ-ONLY; The server version name.
	Name *string `json:"name,omitempty"`
	// SupportedEditions - READ-ONLY; The list of supported managed instance editions.
	SupportedEditions *[]ManagedInstanceEditionCapability `json:"supportedEditions,omitempty"`
	// SupportedInstancePoolEditions - READ-ONLY; The list of supported instance pool editions.
	SupportedInstancePoolEditions *[]InstancePoolEditionCapability `json:"supportedInstancePoolEditions,omitempty"`
	// Status - READ-ONLY; The status of the capability. Possible values include: 'CapabilityStatusVisible', 'CapabilityStatusAvailable', 'CapabilityStatusDefault', 'CapabilityStatusDisabled'
	Status CapabilityStatus `json:"status,omitempty"`
	// Reason - The reason for the capability not being available.
	Reason *string `json:"reason,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagedInstanceVersionCapability.
func (mivc ManagedInstanceVersionCapability) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mivc.Reason != nil {
		objectMap["reason"] = mivc.Reason
	}
	return json.Marshal(objectMap)
}

// ManagedInstanceVulnerabilityAssessment a managed instance vulnerability assessment.
type ManagedInstanceVulnerabilityAssessment struct {
	autorest.Response `json:"-"`
	// ManagedInstanceVulnerabilityAssessmentProperties - Resource properties.
	*ManagedInstanceVulnerabilityAssessmentProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagedInstanceVulnerabilityAssessment.
func (miva ManagedInstanceVulnerabilityAssessment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if miva.ManagedInstanceVulnerabilityAssessmentProperties != nil {
		objectMap["properties"] = miva.ManagedInstanceVulnerabilityAssessmentProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ManagedInstanceVulnerabilityAssessment struct.
func (miva *ManagedInstanceVulnerabilityAssessment) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var managedInstanceVulnerabilityAssessmentProperties ManagedInstanceVulnerabilityAssessmentProperties
				err = json.Unmarshal(*v, &managedInstanceVulnerabilityAssessmentProperties)
				if err != nil {
					return err
				}
				miva.ManagedInstanceVulnerabilityAssessmentProperties = &managedInstanceVulnerabilityAssessmentProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				miva.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				miva.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				miva.Type = &typeVar
			}
		}
	}

	return nil
}

// ManagedInstanceVulnerabilityAssessmentListResult a list of the ManagedInstance's vulnerability assessments.
type ManagedInstanceVulnerabilityAssessmentListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]ManagedInstanceVulnerabilityAssessment `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ManagedInstanceVulnerabilityAssessmentListResultIterator provides access to a complete listing of
// ManagedInstanceVulnerabilityAssessment values.
type ManagedInstanceVulnerabilityAssessmentListResultIterator struct {
	i    int
	page ManagedInstanceVulnerabilityAssessmentListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ManagedInstanceVulnerabilityAssessmentListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ManagedInstanceVulnerabilityAssessmentListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ManagedInstanceVulnerabilityAssessmentListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ManagedInstanceVulnerabilityAssessmentListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ManagedInstanceVulnerabilityAssessmentListResultIterator) Response() ManagedInstanceVulnerabilityAssessmentListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ManagedInstanceVulnerabilityAssessmentListResultIterator) Value() ManagedInstanceVulnerabilityAssessment {
	if !iter.page.NotDone() {
		return ManagedInstanceVulnerabilityAssessment{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ManagedInstanceVulnerabilityAssessmentListResultIterator type.
func NewManagedInstanceVulnerabilityAssessmentListResultIterator(page ManagedInstanceVulnerabilityAssessmentListResultPage) ManagedInstanceVulnerabilityAssessmentListResultIterator {
	return ManagedInstanceVulnerabilityAssessmentListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (mivalr ManagedInstanceVulnerabilityAssessmentListResult) IsEmpty() bool {
	return mivalr.Value == nil || len(*mivalr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (mivalr ManagedInstanceVulnerabilityAssessmentListResult) hasNextLink() bool {
	return mivalr.NextLink != nil && len(*mivalr.NextLink) != 0
}

// managedInstanceVulnerabilityAssessmentListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (mivalr ManagedInstanceVulnerabilityAssessmentListResult) managedInstanceVulnerabilityAssessmentListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !mivalr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(mivalr.NextLink)))
}

// ManagedInstanceVulnerabilityAssessmentListResultPage contains a page of
// ManagedInstanceVulnerabilityAssessment values.
type ManagedInstanceVulnerabilityAssessmentListResultPage struct {
	fn     func(context.Context, ManagedInstanceVulnerabilityAssessmentListResult) (ManagedInstanceVulnerabilityAssessmentListResult, error)
	mivalr ManagedInstanceVulnerabilityAssessmentListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ManagedInstanceVulnerabilityAssessmentListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ManagedInstanceVulnerabilityAssessmentListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.mivalr)
		if err != nil {
			return err
		}
		page.mivalr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ManagedInstanceVulnerabilityAssessmentListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ManagedInstanceVulnerabilityAssessmentListResultPage) NotDone() bool {
	return !page.mivalr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ManagedInstanceVulnerabilityAssessmentListResultPage) Response() ManagedInstanceVulnerabilityAssessmentListResult {
	return page.mivalr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ManagedInstanceVulnerabilityAssessmentListResultPage) Values() []ManagedInstanceVulnerabilityAssessment {
	if page.mivalr.IsEmpty() {
		return nil
	}
	return *page.mivalr.Value
}

// Creates a new instance of the ManagedInstanceVulnerabilityAssessmentListResultPage type.
func NewManagedInstanceVulnerabilityAssessmentListResultPage(getNextPage func(context.Context, ManagedInstanceVulnerabilityAssessmentListResult) (ManagedInstanceVulnerabilityAssessmentListResult, error)) ManagedInstanceVulnerabilityAssessmentListResultPage {
	return ManagedInstanceVulnerabilityAssessmentListResultPage{fn: getNextPage}
}

// ManagedInstanceVulnerabilityAssessmentProperties properties of a managed instance vulnerability assessment.
type ManagedInstanceVulnerabilityAssessmentProperties struct {
	// StorageContainerPath - A blob storage container path to hold the scan results (e.g. https://myStorage.blob.core.windows.net/VaScans/).
	StorageContainerPath *string `json:"storageContainerPath,omitempty"`
	// StorageContainerSasKey - A shared access signature (SAS Key) that has read and write access to the blob container specified in 'storageContainerPath' parameter. If 'storageAccountAccessKey' isn't specified, StorageContainerSasKey is required.
	StorageContainerSasKey *string `json:"storageContainerSasKey,omitempty"`
	// StorageAccountAccessKey - Specifies the identifier key of the storage account for vulnerability assessment scan results. If 'StorageContainerSasKey' isn't specified, storageAccountAccessKey is required.
	StorageAccountAccessKey *string `json:"storageAccountAccessKey,omitempty"`
	// RecurringScans - The recurring scans settings
	RecurringScans *VulnerabilityAssessmentRecurringScansProperties `json:"recurringScans,omitempty"`
}

// ManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesCreateOrUpdateFuture an abstraction for
// monitoring and retrieving the results of a long-running operation.
type ManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesCreateOrUpdateFuture) Result(client ManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesClient) (mbstrp ManagedBackupShortTermRetentionPolicy, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.ManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.ManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if mbstrp.Response.Response, err = future.GetResult(sender); err == nil && mbstrp.Response.Response.StatusCode != http.StatusNoContent {
		mbstrp, err = client.CreateOrUpdateResponder(mbstrp.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.ManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesCreateOrUpdateFuture", "Result", mbstrp.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesUpdateFuture an abstraction for monitoring
// and retrieving the results of a long-running operation.
type ManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesUpdateFuture) Result(client ManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesClient) (mbstrp ManagedBackupShortTermRetentionPolicy, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.ManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.ManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if mbstrp.Response.Response, err = future.GetResult(sender); err == nil && mbstrp.Response.Response.StatusCode != http.StatusNoContent {
		mbstrp, err = client.UpdateResponder(mbstrp.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.ManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesUpdateFuture", "Result", mbstrp.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ManagedServerSecurityAlertPoliciesCreateOrUpdateFuture an abstraction for monitoring and retrieving the
// results of a long-running operation.
type ManagedServerSecurityAlertPoliciesCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ManagedServerSecurityAlertPoliciesCreateOrUpdateFuture) Result(client ManagedServerSecurityAlertPoliciesClient) (mssap ManagedServerSecurityAlertPolicy, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.ManagedServerSecurityAlertPoliciesCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.ManagedServerSecurityAlertPoliciesCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if mssap.Response.Response, err = future.GetResult(sender); err == nil && mssap.Response.Response.StatusCode != http.StatusNoContent {
		mssap, err = client.CreateOrUpdateResponder(mssap.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.ManagedServerSecurityAlertPoliciesCreateOrUpdateFuture", "Result", mssap.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ManagedServerSecurityAlertPolicy a managed server security alert policy.
type ManagedServerSecurityAlertPolicy struct {
	autorest.Response `json:"-"`
	// SecurityAlertPolicyProperties - Resource properties.
	*SecurityAlertPolicyProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagedServerSecurityAlertPolicy.
func (mssap ManagedServerSecurityAlertPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mssap.SecurityAlertPolicyProperties != nil {
		objectMap["properties"] = mssap.SecurityAlertPolicyProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ManagedServerSecurityAlertPolicy struct.
func (mssap *ManagedServerSecurityAlertPolicy) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var securityAlertPolicyProperties SecurityAlertPolicyProperties
				err = json.Unmarshal(*v, &securityAlertPolicyProperties)
				if err != nil {
					return err
				}
				mssap.SecurityAlertPolicyProperties = &securityAlertPolicyProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				mssap.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				mssap.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				mssap.Type = &typeVar
			}
		}
	}

	return nil
}

// ManagedServerSecurityAlertPolicyListResult a list of the managed Server's security alert policies.
type ManagedServerSecurityAlertPolicyListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]ManagedServerSecurityAlertPolicy `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ManagedServerSecurityAlertPolicyListResultIterator provides access to a complete listing of
// ManagedServerSecurityAlertPolicy values.
type ManagedServerSecurityAlertPolicyListResultIterator struct {
	i    int
	page ManagedServerSecurityAlertPolicyListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ManagedServerSecurityAlertPolicyListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ManagedServerSecurityAlertPolicyListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ManagedServerSecurityAlertPolicyListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ManagedServerSecurityAlertPolicyListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ManagedServerSecurityAlertPolicyListResultIterator) Response() ManagedServerSecurityAlertPolicyListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ManagedServerSecurityAlertPolicyListResultIterator) Value() ManagedServerSecurityAlertPolicy {
	if !iter.page.NotDone() {
		return ManagedServerSecurityAlertPolicy{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ManagedServerSecurityAlertPolicyListResultIterator type.
func NewManagedServerSecurityAlertPolicyListResultIterator(page ManagedServerSecurityAlertPolicyListResultPage) ManagedServerSecurityAlertPolicyListResultIterator {
	return ManagedServerSecurityAlertPolicyListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (mssaplr ManagedServerSecurityAlertPolicyListResult) IsEmpty() bool {
	return mssaplr.Value == nil || len(*mssaplr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (mssaplr ManagedServerSecurityAlertPolicyListResult) hasNextLink() bool {
	return mssaplr.NextLink != nil && len(*mssaplr.NextLink) != 0
}

// managedServerSecurityAlertPolicyListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (mssaplr ManagedServerSecurityAlertPolicyListResult) managedServerSecurityAlertPolicyListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !mssaplr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(mssaplr.NextLink)))
}

// ManagedServerSecurityAlertPolicyListResultPage contains a page of ManagedServerSecurityAlertPolicy values.
type ManagedServerSecurityAlertPolicyListResultPage struct {
	fn      func(context.Context, ManagedServerSecurityAlertPolicyListResult) (ManagedServerSecurityAlertPolicyListResult, error)
	mssaplr ManagedServerSecurityAlertPolicyListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ManagedServerSecurityAlertPolicyListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ManagedServerSecurityAlertPolicyListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.mssaplr)
		if err != nil {
			return err
		}
		page.mssaplr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ManagedServerSecurityAlertPolicyListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ManagedServerSecurityAlertPolicyListResultPage) NotDone() bool {
	return !page.mssaplr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ManagedServerSecurityAlertPolicyListResultPage) Response() ManagedServerSecurityAlertPolicyListResult {
	return page.mssaplr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ManagedServerSecurityAlertPolicyListResultPage) Values() []ManagedServerSecurityAlertPolicy {
	if page.mssaplr.IsEmpty() {
		return nil
	}
	return *page.mssaplr.Value
}

// Creates a new instance of the ManagedServerSecurityAlertPolicyListResultPage type.
func NewManagedServerSecurityAlertPolicyListResultPage(getNextPage func(context.Context, ManagedServerSecurityAlertPolicyListResult) (ManagedServerSecurityAlertPolicyListResult, error)) ManagedServerSecurityAlertPolicyListResultPage {
	return ManagedServerSecurityAlertPolicyListResultPage{fn: getNextPage}
}

// MaxSizeCapability the maximum size capability.
type MaxSizeCapability struct {
	// Limit - READ-ONLY; The maximum size limit (see 'unit' for the units).
	Limit *int32 `json:"limit,omitempty"`
	// Unit - READ-ONLY; The units that the limit is expressed in. Possible values include: 'MaxSizeUnitMegabytes', 'MaxSizeUnitGigabytes', 'MaxSizeUnitTerabytes', 'MaxSizeUnitPetabytes'
	Unit MaxSizeUnit `json:"unit,omitempty"`
}

// MaxSizeRangeCapability the maximum size range capability.
type MaxSizeRangeCapability struct {
	// MinValue - READ-ONLY; Minimum value.
	MinValue *MaxSizeCapability `json:"minValue,omitempty"`
	// MaxValue - READ-ONLY; Maximum value.
	MaxValue *MaxSizeCapability `json:"maxValue,omitempty"`
	// ScaleSize - READ-ONLY; Scale/step size for discrete values between the minimum value and the maximum value.
	ScaleSize *MaxSizeCapability `json:"scaleSize,omitempty"`
	// LogSize - READ-ONLY; Size of transaction log.
	LogSize *LogSizeCapability `json:"logSize,omitempty"`
	// Status - READ-ONLY; The status of the capability. Possible values include: 'CapabilityStatusVisible', 'CapabilityStatusAvailable', 'CapabilityStatusDefault', 'CapabilityStatusDisabled'
	Status CapabilityStatus `json:"status,omitempty"`
	// Reason - The reason for the capability not being available.
	Reason *string `json:"reason,omitempty"`
}

// MarshalJSON is the custom marshaler for MaxSizeRangeCapability.
func (msrc MaxSizeRangeCapability) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if msrc.Reason != nil {
		objectMap["reason"] = msrc.Reason
	}
	return json.Marshal(objectMap)
}

// Metric database metrics.
type Metric struct {
	// StartTime - READ-ONLY; The start time for the metric (ISO-8601 format).
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - READ-ONLY; The end time for the metric (ISO-8601 format).
	EndTime *date.Time `json:"endTime,omitempty"`
	// TimeGrain - READ-ONLY; The time step to be used to summarize the metric values.
	TimeGrain *string `json:"timeGrain,omitempty"`
	// Unit - READ-ONLY; The unit of the metric. Possible values include: 'UnitTypeCount', 'UnitTypeBytes', 'UnitTypeSeconds', 'UnitTypePercent', 'UnitTypeCountPerSecond', 'UnitTypeBytesPerSecond'
	Unit UnitType `json:"unit,omitempty"`
	// Name - READ-ONLY; The name information for the metric.
	Name *MetricName `json:"name,omitempty"`
	// MetricValues - READ-ONLY; The metric values for the specified time window and timestep.
	MetricValues *[]MetricValue `json:"metricValues,omitempty"`
}

// MetricAvailability a metric availability value.
type MetricAvailability struct {
	// Retention - READ-ONLY; The length of retention for the database metric.
	Retention *string `json:"retention,omitempty"`
	// TimeGrain - READ-ONLY; The granularity of the database metric.
	TimeGrain *string `json:"timeGrain,omitempty"`
}

// MetricDefinition a database metric definition.
type MetricDefinition struct {
	// Name - READ-ONLY; The name information for the metric.
	Name *MetricName `json:"name,omitempty"`
	// PrimaryAggregationType - READ-ONLY; The primary aggregation type defining how metric values are displayed. Possible values include: 'None', 'Average', 'Count', 'Minimum', 'Maximum', 'Total'
	PrimaryAggregationType PrimaryAggregationType `json:"primaryAggregationType,omitempty"`
	// ResourceURI - READ-ONLY; The resource uri of the database.
	ResourceURI *string `json:"resourceUri,omitempty"`
	// Unit - READ-ONLY; The unit of the metric. Possible values include: 'UnitDefinitionTypeCount', 'UnitDefinitionTypeBytes', 'UnitDefinitionTypeSeconds', 'UnitDefinitionTypePercent', 'UnitDefinitionTypeCountPerSecond', 'UnitDefinitionTypeBytesPerSecond'
	Unit UnitDefinitionType `json:"unit,omitempty"`
	// MetricAvailabilities - READ-ONLY; The list of database metric availabilities for the metric.
	MetricAvailabilities *[]MetricAvailability `json:"metricAvailabilities,omitempty"`
}

// MetricDefinitionListResult the response to a list database metric definitions request.
type MetricDefinitionListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of metric definitions for the database.
	Value *[]MetricDefinition `json:"value,omitempty"`
}

// MetricListResult the response to a list database metrics request.
type MetricListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of metrics for the database.
	Value *[]Metric `json:"value,omitempty"`
}

// MetricName a database metric name.
type MetricName struct {
	// Value - READ-ONLY; The name of the database metric.
	Value *string `json:"value,omitempty"`
	// LocalizedValue - READ-ONLY; The friendly name of the database metric.
	LocalizedValue *string `json:"localizedValue,omitempty"`
}

// MetricValue represents database metrics.
type MetricValue struct {
	// Count - READ-ONLY; The number of values for the metric.
	Count *float64 `json:"count,omitempty"`
	// Average - READ-ONLY; The average value of the metric.
	Average *float64 `json:"average,omitempty"`
	// Maximum - READ-ONLY; The max value of the metric.
	Maximum *float64 `json:"maximum,omitempty"`
	// Minimum - READ-ONLY; The min value of the metric.
	Minimum *float64 `json:"minimum,omitempty"`
	// Timestamp - READ-ONLY; The metric timestamp (ISO-8601 format).
	Timestamp *date.Time `json:"timestamp,omitempty"`
	// Total - READ-ONLY; The total value of the metric.
	Total *float64 `json:"total,omitempty"`
}

// MinCapacityCapability the min capacity capability
type MinCapacityCapability struct {
	// Value - READ-ONLY; Min capacity value
	Value *float64 `json:"value,omitempty"`
	// Status - READ-ONLY; The status of the capability. Possible values include: 'CapabilityStatusVisible', 'CapabilityStatusAvailable', 'CapabilityStatusDefault', 'CapabilityStatusDisabled'
	Status CapabilityStatus `json:"status,omitempty"`
	// Reason - The reason for the capability not being available.
	Reason *string `json:"reason,omitempty"`
}

// MarshalJSON is the custom marshaler for MinCapacityCapability.
func (mcc MinCapacityCapability) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mcc.Reason != nil {
		objectMap["reason"] = mcc.Reason
	}
	return json.Marshal(objectMap)
}

// Name ARM Usage Name
type Name struct {
	// Value - Usage name value
	Value *string `json:"value,omitempty"`
	// LocalizedValue - Usage name localized value.
	LocalizedValue *string `json:"localizedValue,omitempty"`
}

// Operation SQL REST API operation definition.
type Operation struct {
	// Name - READ-ONLY; The name of the operation being performed on this particular object.
	Name *string `json:"name,omitempty"`
	// Display - READ-ONLY; The localized display information for this particular operation / action.
	Display *OperationDisplay `json:"display,omitempty"`
	// Origin - READ-ONLY; The intended executor of the operation. Possible values include: 'OperationOriginUser', 'OperationOriginSystem'
	Origin OperationOrigin `json:"origin,omitempty"`
	// Properties - READ-ONLY; Additional descriptions for the operation.
	Properties map[string]interface{} `json:"properties"`
}

// MarshalJSON is the custom marshaler for Operation.
func (o Operation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// OperationDisplay display metadata associated with the operation.
type OperationDisplay struct {
	// Provider - READ-ONLY; The localized friendly form of the resource provider name.
	Provider *string `json:"provider,omitempty"`
	// Resource - READ-ONLY; The localized friendly form of the resource type related to this action/operation.
	Resource *string `json:"resource,omitempty"`
	// Operation - READ-ONLY; The localized friendly name for the operation.
	Operation *string `json:"operation,omitempty"`
	// Description - READ-ONLY; The localized friendly description for the operation.
	Description *string `json:"description,omitempty"`
}

// OperationImpact the impact of an operation, both in absolute and relative terms.
type OperationImpact struct {
	// Name - READ-ONLY; The name of the impact dimension.
	Name *string `json:"name,omitempty"`
	// Unit - READ-ONLY; The unit in which estimated impact to dimension is measured.
	Unit *string `json:"unit,omitempty"`
	// ChangeValueAbsolute - READ-ONLY; The absolute impact to dimension.
	ChangeValueAbsolute *float64 `json:"changeValueAbsolute,omitempty"`
	// ChangeValueRelative - READ-ONLY; The relative impact to dimension (null if not applicable)
	ChangeValueRelative *float64 `json:"changeValueRelative,omitempty"`
}

// OperationListResult result of the request to list SQL operations.
type OperationListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]Operation `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// OperationListResultIterator provides access to a complete listing of Operation values.
type OperationListResultIterator struct {
	i    int
	page OperationListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OperationListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *OperationListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OperationListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OperationListResultIterator) Response() OperationListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OperationListResultIterator) Value() Operation {
	if !iter.page.NotDone() {
		return Operation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the OperationListResultIterator type.
func NewOperationListResultIterator(page OperationListResultPage) OperationListResultIterator {
	return OperationListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (olr OperationListResult) IsEmpty() bool {
	return olr.Value == nil || len(*olr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (olr OperationListResult) hasNextLink() bool {
	return olr.NextLink != nil && len(*olr.NextLink) != 0
}

// operationListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (olr OperationListResult) operationListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !olr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(olr.NextLink)))
}

// OperationListResultPage contains a page of Operation values.
type OperationListResultPage struct {
	fn  func(context.Context, OperationListResult) (OperationListResult, error)
	olr OperationListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OperationListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.olr)
		if err != nil {
			return err
		}
		page.olr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *OperationListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OperationListResultPage) NotDone() bool {
	return !page.olr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OperationListResultPage) Response() OperationListResult {
	return page.olr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OperationListResultPage) Values() []Operation {
	if page.olr.IsEmpty() {
		return nil
	}
	return *page.olr.Value
}

// Creates a new instance of the OperationListResultPage type.
func NewOperationListResultPage(getNextPage func(context.Context, OperationListResult) (OperationListResult, error)) OperationListResultPage {
	return OperationListResultPage{fn: getNextPage}
}

// PartnerInfo partner server information for the failover group.
type PartnerInfo struct {
	// ID - Resource identifier of the partner server.
	ID *string `json:"id,omitempty"`
	// Location - READ-ONLY; Geo location of the partner server.
	Location *string `json:"location,omitempty"`
	// ReplicationRole - READ-ONLY; Replication role of the partner server. Possible values include: 'Primary', 'Secondary'
	ReplicationRole FailoverGroupReplicationRole `json:"replicationRole,omitempty"`
}

// MarshalJSON is the custom marshaler for PartnerInfo.
func (pi PartnerInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pi.ID != nil {
		objectMap["id"] = pi.ID
	}
	return json.Marshal(objectMap)
}

// PartnerRegionInfo partner region information for the failover group.
type PartnerRegionInfo struct {
	// Location - Geo location of the partner managed instances.
	Location *string `json:"location,omitempty"`
	// ReplicationRole - READ-ONLY; Replication role of the partner managed instances. Possible values include: 'InstanceFailoverGroupReplicationRolePrimary', 'InstanceFailoverGroupReplicationRoleSecondary'
	ReplicationRole InstanceFailoverGroupReplicationRole `json:"replicationRole,omitempty"`
}

// MarshalJSON is the custom marshaler for PartnerRegionInfo.
func (pri PartnerRegionInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pri.Location != nil {
		objectMap["location"] = pri.Location
	}
	return json.Marshal(objectMap)
}

// PerformanceLevelCapability the performance level capability.
type PerformanceLevelCapability struct {
	// Value - READ-ONLY; Performance level value.
	Value *float64 `json:"value,omitempty"`
	// Unit - READ-ONLY; Unit type used to measure performance level. Possible values include: 'DTU', 'VCores'
	Unit PerformanceLevelUnit `json:"unit,omitempty"`
}

// PrivateEndpointConnection a private endpoint connection
type PrivateEndpointConnection struct {
	autorest.Response `json:"-"`
	// PrivateEndpointConnectionProperties - Resource properties.
	*PrivateEndpointConnectionProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateEndpointConnection.
func (pec PrivateEndpointConnection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pec.PrivateEndpointConnectionProperties != nil {
		objectMap["properties"] = pec.PrivateEndpointConnectionProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for PrivateEndpointConnection struct.
func (pec *PrivateEndpointConnection) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var privateEndpointConnectionProperties PrivateEndpointConnectionProperties
				err = json.Unmarshal(*v, &privateEndpointConnectionProperties)
				if err != nil {
					return err
				}
				pec.PrivateEndpointConnectionProperties = &privateEndpointConnectionProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				pec.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				pec.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				pec.Type = &typeVar
			}
		}
	}

	return nil
}

// PrivateEndpointConnectionListResult a list of private endpoint connections.
type PrivateEndpointConnectionListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]PrivateEndpointConnection `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// PrivateEndpointConnectionListResultIterator provides access to a complete listing of
// PrivateEndpointConnection values.
type PrivateEndpointConnectionListResultIterator struct {
	i    int
	page PrivateEndpointConnectionListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *PrivateEndpointConnectionListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PrivateEndpointConnectionListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *PrivateEndpointConnectionListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter PrivateEndpointConnectionListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter PrivateEndpointConnectionListResultIterator) Response() PrivateEndpointConnectionListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter PrivateEndpointConnectionListResultIterator) Value() PrivateEndpointConnection {
	if !iter.page.NotDone() {
		return PrivateEndpointConnection{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the PrivateEndpointConnectionListResultIterator type.
func NewPrivateEndpointConnectionListResultIterator(page PrivateEndpointConnectionListResultPage) PrivateEndpointConnectionListResultIterator {
	return PrivateEndpointConnectionListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (peclr PrivateEndpointConnectionListResult) IsEmpty() bool {
	return peclr.Value == nil || len(*peclr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (peclr PrivateEndpointConnectionListResult) hasNextLink() bool {
	return peclr.NextLink != nil && len(*peclr.NextLink) != 0
}

// privateEndpointConnectionListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (peclr PrivateEndpointConnectionListResult) privateEndpointConnectionListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !peclr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(peclr.NextLink)))
}

// PrivateEndpointConnectionListResultPage contains a page of PrivateEndpointConnection values.
type PrivateEndpointConnectionListResultPage struct {
	fn    func(context.Context, PrivateEndpointConnectionListResult) (PrivateEndpointConnectionListResult, error)
	peclr PrivateEndpointConnectionListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *PrivateEndpointConnectionListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PrivateEndpointConnectionListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.peclr)
		if err != nil {
			return err
		}
		page.peclr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *PrivateEndpointConnectionListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page PrivateEndpointConnectionListResultPage) NotDone() bool {
	return !page.peclr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page PrivateEndpointConnectionListResultPage) Response() PrivateEndpointConnectionListResult {
	return page.peclr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page PrivateEndpointConnectionListResultPage) Values() []PrivateEndpointConnection {
	if page.peclr.IsEmpty() {
		return nil
	}
	return *page.peclr.Value
}

// Creates a new instance of the PrivateEndpointConnectionListResultPage type.
func NewPrivateEndpointConnectionListResultPage(getNextPage func(context.Context, PrivateEndpointConnectionListResult) (PrivateEndpointConnectionListResult, error)) PrivateEndpointConnectionListResultPage {
	return PrivateEndpointConnectionListResultPage{fn: getNextPage}
}

// PrivateEndpointConnectionProperties properties of a private endpoint connection.
type PrivateEndpointConnectionProperties struct {
	// PrivateEndpoint - Private endpoint which the connection belongs to.
	PrivateEndpoint *PrivateEndpointProperty `json:"privateEndpoint,omitempty"`
	// PrivateLinkServiceConnectionState - Connection state of the private endpoint connection.
	PrivateLinkServiceConnectionState *PrivateLinkServiceConnectionStateProperty `json:"privateLinkServiceConnectionState,omitempty"`
	// ProvisioningState - READ-ONLY; State of the private endpoint connection. Possible values include: 'PrivateEndpointProvisioningStateApproving', 'PrivateEndpointProvisioningStateReady', 'PrivateEndpointProvisioningStateDropping', 'PrivateEndpointProvisioningStateFailed', 'PrivateEndpointProvisioningStateRejecting'
	ProvisioningState PrivateEndpointProvisioningState `json:"provisioningState,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateEndpointConnectionProperties.
func (pecp PrivateEndpointConnectionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pecp.PrivateEndpoint != nil {
		objectMap["privateEndpoint"] = pecp.PrivateEndpoint
	}
	if pecp.PrivateLinkServiceConnectionState != nil {
		objectMap["privateLinkServiceConnectionState"] = pecp.PrivateLinkServiceConnectionState
	}
	return json.Marshal(objectMap)
}

// PrivateEndpointConnectionsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type PrivateEndpointConnectionsCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *PrivateEndpointConnectionsCreateOrUpdateFuture) Result(client PrivateEndpointConnectionsClient) (pec PrivateEndpointConnection, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.PrivateEndpointConnectionsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.PrivateEndpointConnectionsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if pec.Response.Response, err = future.GetResult(sender); err == nil && pec.Response.Response.StatusCode != http.StatusNoContent {
		pec, err = client.CreateOrUpdateResponder(pec.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.PrivateEndpointConnectionsCreateOrUpdateFuture", "Result", pec.Response.Response, "Failure responding to request")
		}
	}
	return
}

// PrivateEndpointConnectionsDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type PrivateEndpointConnectionsDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *PrivateEndpointConnectionsDeleteFuture) Result(client PrivateEndpointConnectionsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.PrivateEndpointConnectionsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.PrivateEndpointConnectionsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// PrivateEndpointProperty ...
type PrivateEndpointProperty struct {
	// ID - Resource id of the private endpoint.
	ID *string `json:"id,omitempty"`
}

// PrivateLinkResource a private link resource
type PrivateLinkResource struct {
	autorest.Response `json:"-"`
	// Properties - READ-ONLY; The private link resource group id.
	Properties *PrivateLinkResourceProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// PrivateLinkResourceListResult a list of private link resources
type PrivateLinkResourceListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]PrivateLinkResource `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// PrivateLinkResourceListResultIterator provides access to a complete listing of PrivateLinkResource values.
type PrivateLinkResourceListResultIterator struct {
	i    int
	page PrivateLinkResourceListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *PrivateLinkResourceListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PrivateLinkResourceListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *PrivateLinkResourceListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter PrivateLinkResourceListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter PrivateLinkResourceListResultIterator) Response() PrivateLinkResourceListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter PrivateLinkResourceListResultIterator) Value() PrivateLinkResource {
	if !iter.page.NotDone() {
		return PrivateLinkResource{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the PrivateLinkResourceListResultIterator type.
func NewPrivateLinkResourceListResultIterator(page PrivateLinkResourceListResultPage) PrivateLinkResourceListResultIterator {
	return PrivateLinkResourceListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (plrlr PrivateLinkResourceListResult) IsEmpty() bool {
	return plrlr.Value == nil || len(*plrlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (plrlr PrivateLinkResourceListResult) hasNextLink() bool {
	return plrlr.NextLink != nil && len(*plrlr.NextLink) != 0
}

// privateLinkResourceListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (plrlr PrivateLinkResourceListResult) privateLinkResourceListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !plrlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(plrlr.NextLink)))
}

// PrivateLinkResourceListResultPage contains a page of PrivateLinkResource values.
type PrivateLinkResourceListResultPage struct {
	fn    func(context.Context, PrivateLinkResourceListResult) (PrivateLinkResourceListResult, error)
	plrlr PrivateLinkResourceListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *PrivateLinkResourceListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PrivateLinkResourceListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.plrlr)
		if err != nil {
			return err
		}
		page.plrlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *PrivateLinkResourceListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page PrivateLinkResourceListResultPage) NotDone() bool {
	return !page.plrlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page PrivateLinkResourceListResultPage) Response() PrivateLinkResourceListResult {
	return page.plrlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page PrivateLinkResourceListResultPage) Values() []PrivateLinkResource {
	if page.plrlr.IsEmpty() {
		return nil
	}
	return *page.plrlr.Value
}

// Creates a new instance of the PrivateLinkResourceListResultPage type.
func NewPrivateLinkResourceListResultPage(getNextPage func(context.Context, PrivateLinkResourceListResult) (PrivateLinkResourceListResult, error)) PrivateLinkResourceListResultPage {
	return PrivateLinkResourceListResultPage{fn: getNextPage}
}

// PrivateLinkResourceProperties properties of a private link resource.
type PrivateLinkResourceProperties struct {
	// GroupID - READ-ONLY; The private link resource group id.
	GroupID *string `json:"groupId,omitempty"`
	// RequiredMembers - READ-ONLY; The private link resource required member names.
	RequiredMembers *[]string `json:"requiredMembers,omitempty"`
}

// PrivateLinkServiceConnectionStateProperty ...
type PrivateLinkServiceConnectionStateProperty struct {
	// Status - The private link service connection status. Possible values include: 'Approved', 'Pending', 'Rejected', 'Disconnected'
	Status PrivateLinkServiceConnectionStateStatus `json:"status,omitempty"`
	// Description - The private link service connection description.
	Description *string `json:"description,omitempty"`
	// ActionsRequired - READ-ONLY; The actions required for private link service connection. Possible values include: 'PrivateLinkServiceConnectionStateActionsRequireNone'
	ActionsRequired PrivateLinkServiceConnectionStateActionsRequire `json:"actionsRequired,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateLinkServiceConnectionStateProperty.
func (plscsp PrivateLinkServiceConnectionStateProperty) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if plscsp.Status != "" {
		objectMap["status"] = plscsp.Status
	}
	if plscsp.Description != nil {
		objectMap["description"] = plscsp.Description
	}
	return json.Marshal(objectMap)
}

// ProxyResource ARM proxy resource.
type ProxyResource struct {
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// ReadScaleCapability the read scale capability.
type ReadScaleCapability struct {
	// MaxNumberOfReplicas - READ-ONLY; The maximum number of read scale replicas.
	MaxNumberOfReplicas *int32 `json:"maxNumberOfReplicas,omitempty"`
	// Status - READ-ONLY; The status of the capability. Possible values include: 'CapabilityStatusVisible', 'CapabilityStatusAvailable', 'CapabilityStatusDefault', 'CapabilityStatusDisabled'
	Status CapabilityStatus `json:"status,omitempty"`
	// Reason - The reason for the capability not being available.
	Reason *string `json:"reason,omitempty"`
}

// MarshalJSON is the custom marshaler for ReadScaleCapability.
func (rsc ReadScaleCapability) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rsc.Reason != nil {
		objectMap["reason"] = rsc.Reason
	}
	return json.Marshal(objectMap)
}

// RecommendedElasticPool represents a recommended elastic pool.
type RecommendedElasticPool struct {
	autorest.Response `json:"-"`
	// RecommendedElasticPoolProperties - The properties representing the resource.
	*RecommendedElasticPoolProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for RecommendedElasticPool.
func (rep RecommendedElasticPool) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rep.RecommendedElasticPoolProperties != nil {
		objectMap["properties"] = rep.RecommendedElasticPoolProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for RecommendedElasticPool struct.
func (rep *RecommendedElasticPool) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var recommendedElasticPoolProperties RecommendedElasticPoolProperties
				err = json.Unmarshal(*v, &recommendedElasticPoolProperties)
				if err != nil {
					return err
				}
				rep.RecommendedElasticPoolProperties = &recommendedElasticPoolProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				rep.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				rep.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				rep.Type = &typeVar
			}
		}
	}

	return nil
}

// RecommendedElasticPoolListMetricsResult represents the response to a list recommended elastic pool metrics
// request.
type RecommendedElasticPoolListMetricsResult struct {
	autorest.Response `json:"-"`
	// Value - The list of recommended elastic pools metrics.
	Value *[]RecommendedElasticPoolMetric `json:"value,omitempty"`
}

// RecommendedElasticPoolListResult represents the response to a list recommended elastic pool request.
type RecommendedElasticPoolListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of recommended elastic pools hosted in the server.
	Value *[]RecommendedElasticPool `json:"value,omitempty"`
}

// RecommendedElasticPoolMetric represents recommended elastic pool metric.
type RecommendedElasticPoolMetric struct {
	// DateTime - The time of metric (ISO8601 format).
	DateTime *date.Time `json:"dateTime,omitempty"`
	// Dtu - Gets or sets the DTUs (Database Transaction Units). See https://azure.microsoft.com/documentation/articles/sql-database-what-is-a-dtu/
	Dtu *float64 `json:"dtu,omitempty"`
	// SizeGB - Gets or sets size in gigabytes.
	SizeGB *float64 `json:"sizeGB,omitempty"`
}

// RecommendedElasticPoolProperties represents the properties of a recommended elastic pool.
type RecommendedElasticPoolProperties struct {
	// DatabaseEdition - READ-ONLY; The edition of the recommended elastic pool. The ElasticPoolEdition enumeration contains all the valid editions. Possible values include: 'ElasticPoolEditionBasic', 'ElasticPoolEditionStandard', 'ElasticPoolEditionPremium', 'ElasticPoolEditionGeneralPurpose', 'ElasticPoolEditionBusinessCritical'
	DatabaseEdition ElasticPoolEdition `json:"databaseEdition,omitempty"`
	// Dtu - The DTU for the recommended elastic pool.
	Dtu *float64 `json:"dtu,omitempty"`
	// DatabaseDtuMin - The minimum DTU for the database.
	DatabaseDtuMin *float64 `json:"databaseDtuMin,omitempty"`
	// DatabaseDtuMax - The maximum DTU for the database.
	DatabaseDtuMax *float64 `json:"databaseDtuMax,omitempty"`
	// StorageMB - Gets storage size in megabytes.
	StorageMB *float64 `json:"storageMB,omitempty"`
	// ObservationPeriodStart - READ-ONLY; The observation period start (ISO8601 format).
	ObservationPeriodStart *date.Time `json:"observationPeriodStart,omitempty"`
	// ObservationPeriodEnd - READ-ONLY; The observation period start (ISO8601 format).
	ObservationPeriodEnd *date.Time `json:"observationPeriodEnd,omitempty"`
	// MaxObservedDtu - READ-ONLY; Gets maximum observed DTU.
	MaxObservedDtu *float64 `json:"maxObservedDtu,omitempty"`
	// MaxObservedStorageMB - READ-ONLY; Gets maximum observed storage in megabytes.
	MaxObservedStorageMB *float64 `json:"maxObservedStorageMB,omitempty"`
	// Databases - READ-ONLY; The list of databases in this pool. Expanded property
	Databases *[]TrackedResource `json:"databases,omitempty"`
	// Metrics - READ-ONLY; The list of databases housed in the server. Expanded property
	Metrics *[]RecommendedElasticPoolMetric `json:"metrics,omitempty"`
}

// MarshalJSON is the custom marshaler for RecommendedElasticPoolProperties.
func (repp RecommendedElasticPoolProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if repp.Dtu != nil {
		objectMap["dtu"] = repp.Dtu
	}
	if repp.DatabaseDtuMin != nil {
		objectMap["databaseDtuMin"] = repp.DatabaseDtuMin
	}
	if repp.DatabaseDtuMax != nil {
		objectMap["databaseDtuMax"] = repp.DatabaseDtuMax
	}
	if repp.StorageMB != nil {
		objectMap["storageMB"] = repp.StorageMB
	}
	return json.Marshal(objectMap)
}

// RecommendedIndex represents a database recommended index.
type RecommendedIndex struct {
	// RecommendedIndexProperties - READ-ONLY; The properties representing the resource.
	*RecommendedIndexProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for RecommendedIndex.
func (ri RecommendedIndex) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for RecommendedIndex struct.
func (ri *RecommendedIndex) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var recommendedIndexProperties RecommendedIndexProperties
				err = json.Unmarshal(*v, &recommendedIndexProperties)
				if err != nil {
					return err
				}
				ri.RecommendedIndexProperties = &recommendedIndexProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ri.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ri.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ri.Type = &typeVar
			}
		}
	}

	return nil
}

// RecommendedIndexProperties represents the properties of a database recommended index.
type RecommendedIndexProperties struct {
	// Action - READ-ONLY; The proposed index action. You can create a missing index, drop an unused index, or rebuild an existing index to improve its performance. Possible values include: 'Create', 'Drop', 'Rebuild'
	Action RecommendedIndexAction `json:"action,omitempty"`
	// State - READ-ONLY; The current recommendation state. Possible values include: 'RecommendedIndexStateActive', 'RecommendedIndexStatePending', 'RecommendedIndexStateExecuting', 'RecommendedIndexStateVerifying', 'RecommendedIndexStatePendingRevert', 'RecommendedIndexStateReverting', 'RecommendedIndexStateReverted', 'RecommendedIndexStateIgnored', 'RecommendedIndexStateExpired', 'RecommendedIndexStateBlocked', 'RecommendedIndexStateSuccess'
	State RecommendedIndexState `json:"state,omitempty"`
	// Created - READ-ONLY; The UTC datetime showing when this resource was created (ISO8601 format).
	Created *date.Time `json:"created,omitempty"`
	// LastModified - READ-ONLY; The UTC datetime of when was this resource last changed (ISO8601 format).
	LastModified *date.Time `json:"lastModified,omitempty"`
	// IndexType - READ-ONLY; The type of index (CLUSTERED, NONCLUSTERED, COLUMNSTORE, CLUSTERED COLUMNSTORE). Possible values include: 'CLUSTERED', 'NONCLUSTERED', 'COLUMNSTORE', 'CLUSTEREDCOLUMNSTORE'
	IndexType RecommendedIndexType `json:"indexType,omitempty"`
	// Schema - READ-ONLY; The schema where table to build index over resides
	Schema *string `json:"schema,omitempty"`
	// Table - READ-ONLY; The table on which to build index.
	Table *string `json:"table,omitempty"`
	// Columns - READ-ONLY; Columns over which to build index
	Columns *[]string `json:"columns,omitempty"`
	// IncludedColumns - READ-ONLY; The list of column names to be included in the index
	IncludedColumns *[]string `json:"includedColumns,omitempty"`
	// IndexScript - READ-ONLY; The full build index script
	IndexScript *string `json:"indexScript,omitempty"`
	// EstimatedImpact - READ-ONLY; The estimated impact of doing recommended index action.
	EstimatedImpact *[]OperationImpact `json:"estimatedImpact,omitempty"`
	// ReportedImpact - READ-ONLY; The values reported after index action is complete.
	ReportedImpact *[]OperationImpact `json:"reportedImpact,omitempty"`
}

// RecoverableDatabase a recoverable database
type RecoverableDatabase struct {
	autorest.Response `json:"-"`
	// RecoverableDatabaseProperties - The properties of a recoverable database
	*RecoverableDatabaseProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for RecoverableDatabase.
func (rd RecoverableDatabase) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rd.RecoverableDatabaseProperties != nil {
		objectMap["properties"] = rd.RecoverableDatabaseProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for RecoverableDatabase struct.
func (rd *RecoverableDatabase) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var recoverableDatabaseProperties RecoverableDatabaseProperties
				err = json.Unmarshal(*v, &recoverableDatabaseProperties)
				if err != nil {
					return err
				}
				rd.RecoverableDatabaseProperties = &recoverableDatabaseProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				rd.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				rd.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				rd.Type = &typeVar
			}
		}
	}

	return nil
}

// RecoverableDatabaseListResult the response to a list recoverable databases request
type RecoverableDatabaseListResult struct {
	autorest.Response `json:"-"`
	// Value - A list of recoverable databases
	Value *[]RecoverableDatabase `json:"value,omitempty"`
}

// RecoverableDatabaseProperties the properties of a recoverable database
type RecoverableDatabaseProperties struct {
	// Edition - READ-ONLY; The edition of the database
	Edition *string `json:"edition,omitempty"`
	// ServiceLevelObjective - READ-ONLY; The service level objective name of the database
	ServiceLevelObjective *string `json:"serviceLevelObjective,omitempty"`
	// ElasticPoolName - READ-ONLY; The elastic pool name of the database
	ElasticPoolName *string `json:"elasticPoolName,omitempty"`
	// LastAvailableBackupDate - READ-ONLY; The last available backup date of the database (ISO8601 format)
	LastAvailableBackupDate *date.Time `json:"lastAvailableBackupDate,omitempty"`
}

// RecoverableManagedDatabase a recoverable managed database resource.
type RecoverableManagedDatabase struct {
	autorest.Response `json:"-"`
	// RecoverableManagedDatabaseProperties - Resource properties.
	*RecoverableManagedDatabaseProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for RecoverableManagedDatabase.
func (rmd RecoverableManagedDatabase) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rmd.RecoverableManagedDatabaseProperties != nil {
		objectMap["properties"] = rmd.RecoverableManagedDatabaseProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for RecoverableManagedDatabase struct.
func (rmd *RecoverableManagedDatabase) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var recoverableManagedDatabaseProperties RecoverableManagedDatabaseProperties
				err = json.Unmarshal(*v, &recoverableManagedDatabaseProperties)
				if err != nil {
					return err
				}
				rmd.RecoverableManagedDatabaseProperties = &recoverableManagedDatabaseProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				rmd.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				rmd.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				rmd.Type = &typeVar
			}
		}
	}

	return nil
}

// RecoverableManagedDatabaseListResult a list of recoverable managed databases.
type RecoverableManagedDatabaseListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]RecoverableManagedDatabase `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// RecoverableManagedDatabaseListResultIterator provides access to a complete listing of
// RecoverableManagedDatabase values.
type RecoverableManagedDatabaseListResultIterator struct {
	i    int
	page RecoverableManagedDatabaseListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *RecoverableManagedDatabaseListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RecoverableManagedDatabaseListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *RecoverableManagedDatabaseListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter RecoverableManagedDatabaseListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter RecoverableManagedDatabaseListResultIterator) Response() RecoverableManagedDatabaseListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter RecoverableManagedDatabaseListResultIterator) Value() RecoverableManagedDatabase {
	if !iter.page.NotDone() {
		return RecoverableManagedDatabase{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the RecoverableManagedDatabaseListResultIterator type.
func NewRecoverableManagedDatabaseListResultIterator(page RecoverableManagedDatabaseListResultPage) RecoverableManagedDatabaseListResultIterator {
	return RecoverableManagedDatabaseListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (rmdlr RecoverableManagedDatabaseListResult) IsEmpty() bool {
	return rmdlr.Value == nil || len(*rmdlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (rmdlr RecoverableManagedDatabaseListResult) hasNextLink() bool {
	return rmdlr.NextLink != nil && len(*rmdlr.NextLink) != 0
}

// recoverableManagedDatabaseListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rmdlr RecoverableManagedDatabaseListResult) recoverableManagedDatabaseListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !rmdlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rmdlr.NextLink)))
}

// RecoverableManagedDatabaseListResultPage contains a page of RecoverableManagedDatabase values.
type RecoverableManagedDatabaseListResultPage struct {
	fn    func(context.Context, RecoverableManagedDatabaseListResult) (RecoverableManagedDatabaseListResult, error)
	rmdlr RecoverableManagedDatabaseListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *RecoverableManagedDatabaseListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RecoverableManagedDatabaseListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.rmdlr)
		if err != nil {
			return err
		}
		page.rmdlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *RecoverableManagedDatabaseListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page RecoverableManagedDatabaseListResultPage) NotDone() bool {
	return !page.rmdlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page RecoverableManagedDatabaseListResultPage) Response() RecoverableManagedDatabaseListResult {
	return page.rmdlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page RecoverableManagedDatabaseListResultPage) Values() []RecoverableManagedDatabase {
	if page.rmdlr.IsEmpty() {
		return nil
	}
	return *page.rmdlr.Value
}

// Creates a new instance of the RecoverableManagedDatabaseListResultPage type.
func NewRecoverableManagedDatabaseListResultPage(getNextPage func(context.Context, RecoverableManagedDatabaseListResult) (RecoverableManagedDatabaseListResult, error)) RecoverableManagedDatabaseListResultPage {
	return RecoverableManagedDatabaseListResultPage{fn: getNextPage}
}

// RecoverableManagedDatabaseProperties the recoverable managed database's properties.
type RecoverableManagedDatabaseProperties struct {
	// LastAvailableBackupDate - READ-ONLY; The last available backup date.
	LastAvailableBackupDate *string `json:"lastAvailableBackupDate,omitempty"`
}

// ReplicationLink represents a database replication link.
type ReplicationLink struct {
	autorest.Response `json:"-"`
	// Location - READ-ONLY; Location of the server that contains this firewall rule.
	Location *string `json:"location,omitempty"`
	// ReplicationLinkProperties - The properties representing the resource.
	*ReplicationLinkProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ReplicationLink.
func (rl ReplicationLink) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rl.ReplicationLinkProperties != nil {
		objectMap["properties"] = rl.ReplicationLinkProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ReplicationLink struct.
func (rl *ReplicationLink) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				rl.Location = &location
			}
		case "properties":
			if v != nil {
				var replicationLinkProperties ReplicationLinkProperties
				err = json.Unmarshal(*v, &replicationLinkProperties)
				if err != nil {
					return err
				}
				rl.ReplicationLinkProperties = &replicationLinkProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				rl.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				rl.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				rl.Type = &typeVar
			}
		}
	}

	return nil
}

// ReplicationLinkListResult represents the response to a List database replication link request.
type ReplicationLinkListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of database replication links housed in the database.
	Value *[]ReplicationLink `json:"value,omitempty"`
}

// ReplicationLinkProperties represents the properties of a database replication link.
type ReplicationLinkProperties struct {
	// IsTerminationAllowed - READ-ONLY; Legacy value indicating whether termination is allowed.  Currently always returns true.
	IsTerminationAllowed *bool `json:"isTerminationAllowed,omitempty"`
	// ReplicationMode - READ-ONLY; Replication mode of this replication link.
	ReplicationMode *string `json:"replicationMode,omitempty"`
	// PartnerServer - READ-ONLY; The name of the server hosting the partner database.
	PartnerServer *string `json:"partnerServer,omitempty"`
	// PartnerDatabase - READ-ONLY; The name of the partner database.
	PartnerDatabase *string `json:"partnerDatabase,omitempty"`
	// PartnerLocation - READ-ONLY; The Azure Region of the partner database.
	PartnerLocation *string `json:"partnerLocation,omitempty"`
	// Role - READ-ONLY; The role of the database in the replication link. Possible values include: 'ReplicationRolePrimary', 'ReplicationRoleSecondary', 'ReplicationRoleNonReadableSecondary', 'ReplicationRoleSource', 'ReplicationRoleCopy'
	Role ReplicationRole `json:"role,omitempty"`
	// PartnerRole - READ-ONLY; The role of the partner database in the replication link. Possible values include: 'ReplicationRolePrimary', 'ReplicationRoleSecondary', 'ReplicationRoleNonReadableSecondary', 'ReplicationRoleSource', 'ReplicationRoleCopy'
	PartnerRole ReplicationRole `json:"partnerRole,omitempty"`
	// StartTime - READ-ONLY; The start time for the replication link.
	StartTime *date.Time `json:"startTime,omitempty"`
	// PercentComplete - READ-ONLY; The percentage of seeding complete for the replication link.
	PercentComplete *int32 `json:"percentComplete,omitempty"`
	// ReplicationState - READ-ONLY; The replication state for the replication link. Possible values include: 'PENDING', 'SEEDING', 'CATCHUP', 'SUSPENDED'
	ReplicationState ReplicationState `json:"replicationState,omitempty"`
}

// ReplicationLinksFailoverAllowDataLossFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ReplicationLinksFailoverAllowDataLossFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ReplicationLinksFailoverAllowDataLossFuture) Result(client ReplicationLinksClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.ReplicationLinksFailoverAllowDataLossFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.ReplicationLinksFailoverAllowDataLossFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ReplicationLinksFailoverFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ReplicationLinksFailoverFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ReplicationLinksFailoverFuture) Result(client ReplicationLinksClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.ReplicationLinksFailoverFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.ReplicationLinksFailoverFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ReplicationLinksUnlinkFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ReplicationLinksUnlinkFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ReplicationLinksUnlinkFuture) Result(client ReplicationLinksClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.ReplicationLinksUnlinkFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.ReplicationLinksUnlinkFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// Resource ARM resource.
type Resource struct {
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// ResourceIdentity azure Active Directory identity configuration for a resource.
type ResourceIdentity struct {
	// PrincipalID - READ-ONLY; The Azure Active Directory principal id.
	PrincipalID *uuid.UUID `json:"principalId,omitempty"`
	// Type - The identity type. Set this to 'SystemAssigned' in order to automatically create and assign an Azure Active Directory principal for the resource. Possible values include: 'SystemAssigned'
	Type IdentityType `json:"type,omitempty"`
	// TenantID - READ-ONLY; The Azure Active Directory tenant id.
	TenantID *uuid.UUID `json:"tenantId,omitempty"`
}

// MarshalJSON is the custom marshaler for ResourceIdentity.
func (ri ResourceIdentity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ri.Type != "" {
		objectMap["type"] = ri.Type
	}
	return json.Marshal(objectMap)
}

// ResourceMoveDefinition contains the information necessary to perform a resource move (rename).
type ResourceMoveDefinition struct {
	// ID - The target ID for the resource
	ID *string `json:"id,omitempty"`
}

// RestorableDroppedDatabase a restorable dropped database
type RestorableDroppedDatabase struct {
	autorest.Response `json:"-"`
	// Location - READ-ONLY; The geo-location where the resource lives
	Location *string `json:"location,omitempty"`
	// RestorableDroppedDatabaseProperties - The properties of a restorable dropped database
	*RestorableDroppedDatabaseProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for RestorableDroppedDatabase.
func (rdd RestorableDroppedDatabase) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rdd.RestorableDroppedDatabaseProperties != nil {
		objectMap["properties"] = rdd.RestorableDroppedDatabaseProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for RestorableDroppedDatabase struct.
func (rdd *RestorableDroppedDatabase) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				rdd.Location = &location
			}
		case "properties":
			if v != nil {
				var restorableDroppedDatabaseProperties RestorableDroppedDatabaseProperties
				err = json.Unmarshal(*v, &restorableDroppedDatabaseProperties)
				if err != nil {
					return err
				}
				rdd.RestorableDroppedDatabaseProperties = &restorableDroppedDatabaseProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				rdd.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				rdd.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				rdd.Type = &typeVar
			}
		}
	}

	return nil
}

// RestorableDroppedDatabaseListResult the response to a list restorable dropped databases request
type RestorableDroppedDatabaseListResult struct {
	autorest.Response `json:"-"`
	// Value - A list of restorable dropped databases
	Value *[]RestorableDroppedDatabase `json:"value,omitempty"`
}

// RestorableDroppedDatabaseProperties the properties of a restorable dropped database
type RestorableDroppedDatabaseProperties struct {
	// DatabaseName - READ-ONLY; The name of the database
	DatabaseName *string `json:"databaseName,omitempty"`
	// Edition - READ-ONLY; The edition of the database
	Edition *string `json:"edition,omitempty"`
	// MaxSizeBytes - READ-ONLY; The max size in bytes of the database
	MaxSizeBytes *string `json:"maxSizeBytes,omitempty"`
	// ServiceLevelObjective - READ-ONLY; The service level objective name of the database
	ServiceLevelObjective *string `json:"serviceLevelObjective,omitempty"`
	// ElasticPoolName - READ-ONLY; The elastic pool name of the database
	ElasticPoolName *string `json:"elasticPoolName,omitempty"`
	// CreationDate - READ-ONLY; The creation date of the database (ISO8601 format)
	CreationDate *date.Time `json:"creationDate,omitempty"`
	// DeletionDate - READ-ONLY; The deletion date of the database (ISO8601 format)
	DeletionDate *date.Time `json:"deletionDate,omitempty"`
	// EarliestRestoreDate - READ-ONLY; The earliest restore date of the database (ISO8601 format)
	EarliestRestoreDate *date.Time `json:"earliestRestoreDate,omitempty"`
}

// RestorableDroppedManagedDatabase a restorable dropped managed database resource.
type RestorableDroppedManagedDatabase struct {
	autorest.Response `json:"-"`
	// RestorableDroppedManagedDatabaseProperties - Resource properties.
	*RestorableDroppedManagedDatabaseProperties `json:"properties,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for RestorableDroppedManagedDatabase.
func (rdmd RestorableDroppedManagedDatabase) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rdmd.RestorableDroppedManagedDatabaseProperties != nil {
		objectMap["properties"] = rdmd.RestorableDroppedManagedDatabaseProperties
	}
	if rdmd.Location != nil {
		objectMap["location"] = rdmd.Location
	}
	if rdmd.Tags != nil {
		objectMap["tags"] = rdmd.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for RestorableDroppedManagedDatabase struct.
func (rdmd *RestorableDroppedManagedDatabase) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var restorableDroppedManagedDatabaseProperties RestorableDroppedManagedDatabaseProperties
				err = json.Unmarshal(*v, &restorableDroppedManagedDatabaseProperties)
				if err != nil {
					return err
				}
				rdmd.RestorableDroppedManagedDatabaseProperties = &restorableDroppedManagedDatabaseProperties
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				rdmd.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				rdmd.Tags = tags
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				rdmd.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				rdmd.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				rdmd.Type = &typeVar
			}
		}
	}

	return nil
}

// RestorableDroppedManagedDatabaseListResult a list of restorable dropped managed databases.
type RestorableDroppedManagedDatabaseListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]RestorableDroppedManagedDatabase `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// RestorableDroppedManagedDatabaseListResultIterator provides access to a complete listing of
// RestorableDroppedManagedDatabase values.
type RestorableDroppedManagedDatabaseListResultIterator struct {
	i    int
	page RestorableDroppedManagedDatabaseListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *RestorableDroppedManagedDatabaseListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RestorableDroppedManagedDatabaseListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *RestorableDroppedManagedDatabaseListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter RestorableDroppedManagedDatabaseListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter RestorableDroppedManagedDatabaseListResultIterator) Response() RestorableDroppedManagedDatabaseListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter RestorableDroppedManagedDatabaseListResultIterator) Value() RestorableDroppedManagedDatabase {
	if !iter.page.NotDone() {
		return RestorableDroppedManagedDatabase{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the RestorableDroppedManagedDatabaseListResultIterator type.
func NewRestorableDroppedManagedDatabaseListResultIterator(page RestorableDroppedManagedDatabaseListResultPage) RestorableDroppedManagedDatabaseListResultIterator {
	return RestorableDroppedManagedDatabaseListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (rdmdlr RestorableDroppedManagedDatabaseListResult) IsEmpty() bool {
	return rdmdlr.Value == nil || len(*rdmdlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (rdmdlr RestorableDroppedManagedDatabaseListResult) hasNextLink() bool {
	return rdmdlr.NextLink != nil && len(*rdmdlr.NextLink) != 0
}

// restorableDroppedManagedDatabaseListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rdmdlr RestorableDroppedManagedDatabaseListResult) restorableDroppedManagedDatabaseListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !rdmdlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rdmdlr.NextLink)))
}

// RestorableDroppedManagedDatabaseListResultPage contains a page of RestorableDroppedManagedDatabase values.
type RestorableDroppedManagedDatabaseListResultPage struct {
	fn     func(context.Context, RestorableDroppedManagedDatabaseListResult) (RestorableDroppedManagedDatabaseListResult, error)
	rdmdlr RestorableDroppedManagedDatabaseListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *RestorableDroppedManagedDatabaseListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RestorableDroppedManagedDatabaseListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.rdmdlr)
		if err != nil {
			return err
		}
		page.rdmdlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *RestorableDroppedManagedDatabaseListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page RestorableDroppedManagedDatabaseListResultPage) NotDone() bool {
	return !page.rdmdlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page RestorableDroppedManagedDatabaseListResultPage) Response() RestorableDroppedManagedDatabaseListResult {
	return page.rdmdlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page RestorableDroppedManagedDatabaseListResultPage) Values() []RestorableDroppedManagedDatabase {
	if page.rdmdlr.IsEmpty() {
		return nil
	}
	return *page.rdmdlr.Value
}

// Creates a new instance of the RestorableDroppedManagedDatabaseListResultPage type.
func NewRestorableDroppedManagedDatabaseListResultPage(getNextPage func(context.Context, RestorableDroppedManagedDatabaseListResult) (RestorableDroppedManagedDatabaseListResult, error)) RestorableDroppedManagedDatabaseListResultPage {
	return RestorableDroppedManagedDatabaseListResultPage{fn: getNextPage}
}

// RestorableDroppedManagedDatabaseProperties the restorable dropped managed database's properties.
type RestorableDroppedManagedDatabaseProperties struct {
	// DatabaseName - READ-ONLY; The name of the database.
	DatabaseName *string `json:"databaseName,omitempty"`
	// CreationDate - READ-ONLY; The creation date of the database (ISO8601 format).
	CreationDate *date.Time `json:"creationDate,omitempty"`
	// DeletionDate - READ-ONLY; The deletion date of the database (ISO8601 format).
	DeletionDate *date.Time `json:"deletionDate,omitempty"`
	// EarliestRestoreDate - READ-ONLY; The earliest restore date of the database (ISO8601 format).
	EarliestRestoreDate *date.Time `json:"earliestRestoreDate,omitempty"`
}

// RestorePoint database restore points.
type RestorePoint struct {
	autorest.Response `json:"-"`
	// Location - READ-ONLY; Resource location.
	Location *string `json:"location,omitempty"`
	// RestorePointProperties - Resource properties.
	*RestorePointProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for RestorePoint.
func (rp RestorePoint) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rp.RestorePointProperties != nil {
		objectMap["properties"] = rp.RestorePointProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for RestorePoint struct.
func (rp *RestorePoint) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				rp.Location = &location
			}
		case "properties":
			if v != nil {
				var restorePointProperties RestorePointProperties
				err = json.Unmarshal(*v, &restorePointProperties)
				if err != nil {
					return err
				}
				rp.RestorePointProperties = &restorePointProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				rp.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				rp.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				rp.Type = &typeVar
			}
		}
	}

	return nil
}

// RestorePointListResult a list of long term retention backups.
type RestorePointListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]RestorePoint `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// RestorePointProperties properties of a database restore point
type RestorePointProperties struct {
	// RestorePointType - READ-ONLY; The type of restore point. Possible values include: 'CONTINUOUS', 'DISCRETE'
	RestorePointType RestorePointType `json:"restorePointType,omitempty"`
	// EarliestRestoreDate - READ-ONLY; The earliest time to which this database can be restored
	EarliestRestoreDate *date.Time `json:"earliestRestoreDate,omitempty"`
	// RestorePointCreationDate - READ-ONLY; The time the backup was taken
	RestorePointCreationDate *date.Time `json:"restorePointCreationDate,omitempty"`
	// RestorePointLabel - READ-ONLY; The label of restore point for backup request by user
	RestorePointLabel *string `json:"restorePointLabel,omitempty"`
}

// RestorePointsCreateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type RestorePointsCreateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *RestorePointsCreateFuture) Result(client RestorePointsClient) (rp RestorePoint, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.RestorePointsCreateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.RestorePointsCreateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if rp.Response.Response, err = future.GetResult(sender); err == nil && rp.Response.Response.StatusCode != http.StatusNoContent {
		rp, err = client.CreateResponder(rp.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.RestorePointsCreateFuture", "Result", rp.Response.Response, "Failure responding to request")
		}
	}
	return
}

// SecurityAlertPolicyProperties properties of a security alert policy.
type SecurityAlertPolicyProperties struct {
	// State - Specifies the state of the policy, whether it is enabled or disabled or a policy has not been applied yet on the specific database. Possible values include: 'SecurityAlertPolicyStateNew', 'SecurityAlertPolicyStateEnabled', 'SecurityAlertPolicyStateDisabled'
	State SecurityAlertPolicyState `json:"state,omitempty"`
	// DisabledAlerts - Specifies an array of alerts that are disabled. Allowed values are: Sql_Injection, Sql_Injection_Vulnerability, Access_Anomaly, Data_Exfiltration, Unsafe_Action
	DisabledAlerts *[]string `json:"disabledAlerts,omitempty"`
	// EmailAddresses - Specifies an array of e-mail addresses to which the alert is sent.
	EmailAddresses *[]string `json:"emailAddresses,omitempty"`
	// EmailAccountAdmins - Specifies that the alert is sent to the account administrators.
	EmailAccountAdmins *bool `json:"emailAccountAdmins,omitempty"`
	// StorageEndpoint - Specifies the blob storage endpoint (e.g. https://MyAccount.blob.core.windows.net). This blob storage will hold all Threat Detection audit logs.
	StorageEndpoint *string `json:"storageEndpoint,omitempty"`
	// StorageAccountAccessKey - Specifies the identifier key of the Threat Detection audit storage account.
	StorageAccountAccessKey *string `json:"storageAccountAccessKey,omitempty"`
	// RetentionDays - Specifies the number of days to keep in the Threat Detection audit logs.
	RetentionDays *int32 `json:"retentionDays,omitempty"`
	// CreationTime - READ-ONLY; Specifies the UTC creation time of the policy.
	CreationTime *date.Time `json:"creationTime,omitempty"`
}

// MarshalJSON is the custom marshaler for SecurityAlertPolicyProperties.
func (sapp SecurityAlertPolicyProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sapp.State != "" {
		objectMap["state"] = sapp.State
	}
	if sapp.DisabledAlerts != nil {
		objectMap["disabledAlerts"] = sapp.DisabledAlerts
	}
	if sapp.EmailAddresses != nil {
		objectMap["emailAddresses"] = sapp.EmailAddresses
	}
	if sapp.EmailAccountAdmins != nil {
		objectMap["emailAccountAdmins"] = sapp.EmailAccountAdmins
	}
	if sapp.StorageEndpoint != nil {
		objectMap["storageEndpoint"] = sapp.StorageEndpoint
	}
	if sapp.StorageAccountAccessKey != nil {
		objectMap["storageAccountAccessKey"] = sapp.StorageAccountAccessKey
	}
	if sapp.RetentionDays != nil {
		objectMap["retentionDays"] = sapp.RetentionDays
	}
	return json.Marshal(objectMap)
}

// SensitivityLabel a sensitivity label.
type SensitivityLabel struct {
	autorest.Response `json:"-"`
	// SensitivityLabelProperties - Resource properties.
	*SensitivityLabelProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for SensitivityLabel.
func (sl SensitivityLabel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sl.SensitivityLabelProperties != nil {
		objectMap["properties"] = sl.SensitivityLabelProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SensitivityLabel struct.
func (sl *SensitivityLabel) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var sensitivityLabelProperties SensitivityLabelProperties
				err = json.Unmarshal(*v, &sensitivityLabelProperties)
				if err != nil {
					return err
				}
				sl.SensitivityLabelProperties = &sensitivityLabelProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sl.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sl.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sl.Type = &typeVar
			}
		}
	}

	return nil
}

// SensitivityLabelListResult a list of sensitivity labels.
type SensitivityLabelListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]SensitivityLabel `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// SensitivityLabelListResultIterator provides access to a complete listing of SensitivityLabel values.
type SensitivityLabelListResultIterator struct {
	i    int
	page SensitivityLabelListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *SensitivityLabelListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SensitivityLabelListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *SensitivityLabelListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter SensitivityLabelListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter SensitivityLabelListResultIterator) Response() SensitivityLabelListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter SensitivityLabelListResultIterator) Value() SensitivityLabel {
	if !iter.page.NotDone() {
		return SensitivityLabel{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the SensitivityLabelListResultIterator type.
func NewSensitivityLabelListResultIterator(page SensitivityLabelListResultPage) SensitivityLabelListResultIterator {
	return SensitivityLabelListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (sllr SensitivityLabelListResult) IsEmpty() bool {
	return sllr.Value == nil || len(*sllr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (sllr SensitivityLabelListResult) hasNextLink() bool {
	return sllr.NextLink != nil && len(*sllr.NextLink) != 0
}

// sensitivityLabelListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (sllr SensitivityLabelListResult) sensitivityLabelListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !sllr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(sllr.NextLink)))
}

// SensitivityLabelListResultPage contains a page of SensitivityLabel values.
type SensitivityLabelListResultPage struct {
	fn   func(context.Context, SensitivityLabelListResult) (SensitivityLabelListResult, error)
	sllr SensitivityLabelListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *SensitivityLabelListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SensitivityLabelListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.sllr)
		if err != nil {
			return err
		}
		page.sllr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *SensitivityLabelListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page SensitivityLabelListResultPage) NotDone() bool {
	return !page.sllr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page SensitivityLabelListResultPage) Response() SensitivityLabelListResult {
	return page.sllr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page SensitivityLabelListResultPage) Values() []SensitivityLabel {
	if page.sllr.IsEmpty() {
		return nil
	}
	return *page.sllr.Value
}

// Creates a new instance of the SensitivityLabelListResultPage type.
func NewSensitivityLabelListResultPage(getNextPage func(context.Context, SensitivityLabelListResult) (SensitivityLabelListResult, error)) SensitivityLabelListResultPage {
	return SensitivityLabelListResultPage{fn: getNextPage}
}

// SensitivityLabelProperties properties of a sensitivity label.
type SensitivityLabelProperties struct {
	// LabelName - The label name.
	LabelName *string `json:"labelName,omitempty"`
	// LabelID - The label ID.
	LabelID *string `json:"labelId,omitempty"`
	// InformationType - The information type.
	InformationType *string `json:"informationType,omitempty"`
	// InformationTypeID - The information type ID.
	InformationTypeID *string `json:"informationTypeId,omitempty"`
	// IsDisabled - READ-ONLY; Is sensitivity recommendation disabled. Applicable for recommended sensitivity label only. Specifies whether the sensitivity recommendation on this column is disabled (dismissed) or not.
	IsDisabled *bool `json:"isDisabled,omitempty"`
	// Rank - Possible values include: 'SensitivityLabelRankNone', 'SensitivityLabelRankLow', 'SensitivityLabelRankMedium', 'SensitivityLabelRankHigh', 'SensitivityLabelRankCritical'
	Rank SensitivityLabelRank `json:"rank,omitempty"`
}

// MarshalJSON is the custom marshaler for SensitivityLabelProperties.
func (slp SensitivityLabelProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if slp.LabelName != nil {
		objectMap["labelName"] = slp.LabelName
	}
	if slp.LabelID != nil {
		objectMap["labelId"] = slp.LabelID
	}
	if slp.InformationType != nil {
		objectMap["informationType"] = slp.InformationType
	}
	if slp.InformationTypeID != nil {
		objectMap["informationTypeId"] = slp.InformationTypeID
	}
	if slp.Rank != "" {
		objectMap["rank"] = slp.Rank
	}
	return json.Marshal(objectMap)
}

// Server an Azure SQL Database server.
type Server struct {
	autorest.Response `json:"-"`
	// Identity - The Azure Active Directory identity of the server.
	Identity *ResourceIdentity `json:"identity,omitempty"`
	// Kind - READ-ONLY; Kind of sql server. This is metadata used for the Azure portal experience.
	Kind *string `json:"kind,omitempty"`
	// ServerProperties - Resource properties.
	*ServerProperties `json:"properties,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Server.
func (s Server) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if s.Identity != nil {
		objectMap["identity"] = s.Identity
	}
	if s.ServerProperties != nil {
		objectMap["properties"] = s.ServerProperties
	}
	if s.Location != nil {
		objectMap["location"] = s.Location
	}
	if s.Tags != nil {
		objectMap["tags"] = s.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Server struct.
func (s *Server) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "identity":
			if v != nil {
				var identity ResourceIdentity
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				s.Identity = &identity
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				s.Kind = &kind
			}
		case "properties":
			if v != nil {
				var serverProperties ServerProperties
				err = json.Unmarshal(*v, &serverProperties)
				if err != nil {
					return err
				}
				s.ServerProperties = &serverProperties
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				s.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				s.Tags = tags
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				s.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				s.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				s.Type = &typeVar
			}
		}
	}

	return nil
}

// ServerAutomaticTuning server-level Automatic Tuning.
type ServerAutomaticTuning struct {
	autorest.Response `json:"-"`
	// AutomaticTuningServerProperties - Resource properties.
	*AutomaticTuningServerProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ServerAutomaticTuning.
func (sat ServerAutomaticTuning) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sat.AutomaticTuningServerProperties != nil {
		objectMap["properties"] = sat.AutomaticTuningServerProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ServerAutomaticTuning struct.
func (sat *ServerAutomaticTuning) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var automaticTuningServerProperties AutomaticTuningServerProperties
				err = json.Unmarshal(*v, &automaticTuningServerProperties)
				if err != nil {
					return err
				}
				sat.AutomaticTuningServerProperties = &automaticTuningServerProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sat.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sat.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sat.Type = &typeVar
			}
		}
	}

	return nil
}

// ServerAzureADAdministrator azure Active Directory administrator.
type ServerAzureADAdministrator struct {
	autorest.Response `json:"-"`
	// AdministratorProperties - Resource properties.
	*AdministratorProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ServerAzureADAdministrator.
func (saaa ServerAzureADAdministrator) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if saaa.AdministratorProperties != nil {
		objectMap["properties"] = saaa.AdministratorProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ServerAzureADAdministrator struct.
func (saaa *ServerAzureADAdministrator) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var administratorProperties AdministratorProperties
				err = json.Unmarshal(*v, &administratorProperties)
				if err != nil {
					return err
				}
				saaa.AdministratorProperties = &administratorProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				saaa.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				saaa.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				saaa.Type = &typeVar
			}
		}
	}

	return nil
}

// ServerAzureADAdministratorsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of
// a long-running operation.
type ServerAzureADAdministratorsCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ServerAzureADAdministratorsCreateOrUpdateFuture) Result(client ServerAzureADAdministratorsClient) (saaa ServerAzureADAdministrator, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.ServerAzureADAdministratorsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.ServerAzureADAdministratorsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if saaa.Response.Response, err = future.GetResult(sender); err == nil && saaa.Response.Response.StatusCode != http.StatusNoContent {
		saaa, err = client.CreateOrUpdateResponder(saaa.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.ServerAzureADAdministratorsCreateOrUpdateFuture", "Result", saaa.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ServerAzureADAdministratorsDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ServerAzureADAdministratorsDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ServerAzureADAdministratorsDeleteFuture) Result(client ServerAzureADAdministratorsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.ServerAzureADAdministratorsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.ServerAzureADAdministratorsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ServerAzureADOnlyAuthentication azure Active Directory only authentication.
type ServerAzureADOnlyAuthentication struct {
	autorest.Response `json:"-"`
	// AzureADOnlyAuthProperties - Resource properties.
	*AzureADOnlyAuthProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ServerAzureADOnlyAuthentication.
func (saaoa ServerAzureADOnlyAuthentication) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if saaoa.AzureADOnlyAuthProperties != nil {
		objectMap["properties"] = saaoa.AzureADOnlyAuthProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ServerAzureADOnlyAuthentication struct.
func (saaoa *ServerAzureADOnlyAuthentication) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var azureADOnlyAuthProperties AzureADOnlyAuthProperties
				err = json.Unmarshal(*v, &azureADOnlyAuthProperties)
				if err != nil {
					return err
				}
				saaoa.AzureADOnlyAuthProperties = &azureADOnlyAuthProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				saaoa.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				saaoa.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				saaoa.Type = &typeVar
			}
		}
	}

	return nil
}

// ServerAzureADOnlyAuthenticationsCreateOrUpdateFuture an abstraction for monitoring and retrieving the
// results of a long-running operation.
type ServerAzureADOnlyAuthenticationsCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ServerAzureADOnlyAuthenticationsCreateOrUpdateFuture) Result(client ServerAzureADOnlyAuthenticationsClient) (saaoa ServerAzureADOnlyAuthentication, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.ServerAzureADOnlyAuthenticationsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.ServerAzureADOnlyAuthenticationsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if saaoa.Response.Response, err = future.GetResult(sender); err == nil && saaoa.Response.Response.StatusCode != http.StatusNoContent {
		saaoa, err = client.CreateOrUpdateResponder(saaoa.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.ServerAzureADOnlyAuthenticationsCreateOrUpdateFuture", "Result", saaoa.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ServerAzureADOnlyAuthenticationsDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ServerAzureADOnlyAuthenticationsDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ServerAzureADOnlyAuthenticationsDeleteFuture) Result(client ServerAzureADOnlyAuthenticationsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.ServerAzureADOnlyAuthenticationsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.ServerAzureADOnlyAuthenticationsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ServerBlobAuditingPoliciesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ServerBlobAuditingPoliciesCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ServerBlobAuditingPoliciesCreateOrUpdateFuture) Result(client ServerBlobAuditingPoliciesClient) (sbap ServerBlobAuditingPolicy, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.ServerBlobAuditingPoliciesCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.ServerBlobAuditingPoliciesCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if sbap.Response.Response, err = future.GetResult(sender); err == nil && sbap.Response.Response.StatusCode != http.StatusNoContent {
		sbap, err = client.CreateOrUpdateResponder(sbap.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.ServerBlobAuditingPoliciesCreateOrUpdateFuture", "Result", sbap.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ServerBlobAuditingPolicy a server blob auditing policy.
type ServerBlobAuditingPolicy struct {
	autorest.Response `json:"-"`
	// ServerBlobAuditingPolicyProperties - Resource properties.
	*ServerBlobAuditingPolicyProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ServerBlobAuditingPolicy.
func (sbap ServerBlobAuditingPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sbap.ServerBlobAuditingPolicyProperties != nil {
		objectMap["properties"] = sbap.ServerBlobAuditingPolicyProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ServerBlobAuditingPolicy struct.
func (sbap *ServerBlobAuditingPolicy) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var serverBlobAuditingPolicyProperties ServerBlobAuditingPolicyProperties
				err = json.Unmarshal(*v, &serverBlobAuditingPolicyProperties)
				if err != nil {
					return err
				}
				sbap.ServerBlobAuditingPolicyProperties = &serverBlobAuditingPolicyProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sbap.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sbap.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sbap.Type = &typeVar
			}
		}
	}

	return nil
}

// ServerBlobAuditingPolicyListResult a list of server auditing settings.
type ServerBlobAuditingPolicyListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]ServerBlobAuditingPolicy `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ServerBlobAuditingPolicyListResultIterator provides access to a complete listing of ServerBlobAuditingPolicy
// values.
type ServerBlobAuditingPolicyListResultIterator struct {
	i    int
	page ServerBlobAuditingPolicyListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ServerBlobAuditingPolicyListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServerBlobAuditingPolicyListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ServerBlobAuditingPolicyListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ServerBlobAuditingPolicyListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ServerBlobAuditingPolicyListResultIterator) Response() ServerBlobAuditingPolicyListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ServerBlobAuditingPolicyListResultIterator) Value() ServerBlobAuditingPolicy {
	if !iter.page.NotDone() {
		return ServerBlobAuditingPolicy{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ServerBlobAuditingPolicyListResultIterator type.
func NewServerBlobAuditingPolicyListResultIterator(page ServerBlobAuditingPolicyListResultPage) ServerBlobAuditingPolicyListResultIterator {
	return ServerBlobAuditingPolicyListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (sbaplr ServerBlobAuditingPolicyListResult) IsEmpty() bool {
	return sbaplr.Value == nil || len(*sbaplr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (sbaplr ServerBlobAuditingPolicyListResult) hasNextLink() bool {
	return sbaplr.NextLink != nil && len(*sbaplr.NextLink) != 0
}

// serverBlobAuditingPolicyListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (sbaplr ServerBlobAuditingPolicyListResult) serverBlobAuditingPolicyListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !sbaplr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(sbaplr.NextLink)))
}

// ServerBlobAuditingPolicyListResultPage contains a page of ServerBlobAuditingPolicy values.
type ServerBlobAuditingPolicyListResultPage struct {
	fn     func(context.Context, ServerBlobAuditingPolicyListResult) (ServerBlobAuditingPolicyListResult, error)
	sbaplr ServerBlobAuditingPolicyListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ServerBlobAuditingPolicyListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServerBlobAuditingPolicyListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.sbaplr)
		if err != nil {
			return err
		}
		page.sbaplr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ServerBlobAuditingPolicyListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ServerBlobAuditingPolicyListResultPage) NotDone() bool {
	return !page.sbaplr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ServerBlobAuditingPolicyListResultPage) Response() ServerBlobAuditingPolicyListResult {
	return page.sbaplr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ServerBlobAuditingPolicyListResultPage) Values() []ServerBlobAuditingPolicy {
	if page.sbaplr.IsEmpty() {
		return nil
	}
	return *page.sbaplr.Value
}

// Creates a new instance of the ServerBlobAuditingPolicyListResultPage type.
func NewServerBlobAuditingPolicyListResultPage(getNextPage func(context.Context, ServerBlobAuditingPolicyListResult) (ServerBlobAuditingPolicyListResult, error)) ServerBlobAuditingPolicyListResultPage {
	return ServerBlobAuditingPolicyListResultPage{fn: getNextPage}
}

// ServerBlobAuditingPolicyProperties properties of a server blob auditing policy.
type ServerBlobAuditingPolicyProperties struct {
	// State - Specifies the state of the policy. If state is Enabled, storageEndpoint or isAzureMonitorTargetEnabled are required. Possible values include: 'BlobAuditingPolicyStateEnabled', 'BlobAuditingPolicyStateDisabled'
	State BlobAuditingPolicyState `json:"state,omitempty"`
	// StorageEndpoint - Specifies the blob storage endpoint (e.g. https://MyAccount.blob.core.windows.net). If state is Enabled, storageEndpoint or isAzureMonitorTargetEnabled is required.
	StorageEndpoint *string `json:"storageEndpoint,omitempty"`
	// StorageAccountAccessKey - Specifies the identifier key of the auditing storage account.
	// If state is Enabled and storageEndpoint is specified, not specifying the storageAccountAccessKey will use SQL server system-assigned managed identity to access the storage.
	// Prerequisites for using managed identity authentication:
	// 1. Assign SQL Server a system-assigned managed identity in Azure Active Directory (AAD).
	// 2. Grant SQL Server identity access to the storage account by adding 'Storage Blob Data Contributor' RBAC role to the server identity.
	// For more information, see [Auditing to storage using Managed Identity authentication](https://go.microsoft.com/fwlink/?linkid=2114355)
	StorageAccountAccessKey *string `json:"storageAccountAccessKey,omitempty"`
	// RetentionDays - Specifies the number of days to keep in the audit logs in the storage account.
	RetentionDays *int32 `json:"retentionDays,omitempty"`
	// AuditActionsAndGroups - Specifies the Actions-Groups and Actions to audit.
	//
	// The recommended set of action groups to use is the following combination - this will audit all the queries and stored procedures executed against the database, as well as successful and failed logins:
	//
	// BATCH_COMPLETED_GROUP,
	// SUCCESSFUL_DATABASE_AUTHENTICATION_GROUP,
	// FAILED_DATABASE_AUTHENTICATION_GROUP.
	//
	// This above combination is also the set that is configured by default when enabling auditing from the Azure portal.
	//
	// The supported action groups to audit are (note: choose only specific groups that cover your auditing needs. Using unnecessary groups could lead to very large quantities of audit records):
	//
	// APPLICATION_ROLE_CHANGE_PASSWORD_GROUP
	// BACKUP_RESTORE_GROUP
	// DATABASE_LOGOUT_GROUP
	// DATABASE_OBJECT_CHANGE_GROUP
	// DATABASE_OBJECT_OWNERSHIP_CHANGE_GROUP
	// DATABASE_OBJECT_PERMISSION_CHANGE_GROUP
	// DATABASE_OPERATION_GROUP
	// DATABASE_PERMISSION_CHANGE_GROUP
	// DATABASE_PRINCIPAL_CHANGE_GROUP
	// DATABASE_PRINCIPAL_IMPERSONATION_GROUP
	// DATABASE_ROLE_MEMBER_CHANGE_GROUP
	// FAILED_DATABASE_AUTHENTICATION_GROUP
	// SCHEMA_OBJECT_ACCESS_GROUP
	// SCHEMA_OBJECT_CHANGE_GROUP
	// SCHEMA_OBJECT_OWNERSHIP_CHANGE_GROUP
	// SCHEMA_OBJECT_PERMISSION_CHANGE_GROUP
	// SUCCESSFUL_DATABASE_AUTHENTICATION_GROUP
	// USER_CHANGE_PASSWORD_GROUP
	// BATCH_STARTED_GROUP
	// BATCH_COMPLETED_GROUP
	//
	// These are groups that cover all sql statements and stored procedures executed against the database, and should not be used in combination with other groups as this will result in duplicate audit logs.
	//
	// For more information, see [Database-Level Audit Action Groups](https://docs.microsoft.com/en-us/sql/relational-databases/security/auditing/sql-server-audit-action-groups-and-actions#database-level-audit-action-groups).
	//
	// For Database auditing policy, specific Actions can also be specified (note that Actions cannot be specified for Server auditing policy). The supported actions to audit are:
	// SELECT
	// UPDATE
	// INSERT
	// DELETE
	// EXECUTE
	// RECEIVE
	// REFERENCES
	//
	// The general form for defining an action to be audited is:
	// {action} ON {object} BY {principal}
	//
	// Note that <object> in the above format can refer to an object like a table, view, or stored procedure, or an entire database or schema. For the latter cases, the forms DATABASE::{db_name} and SCHEMA::{schema_name} are used, respectively.
	//
	// For example:
	// SELECT on dbo.myTable by public
	// SELECT on DATABASE::myDatabase by public
	// SELECT on SCHEMA::mySchema by public
	//
	// For more information, see [Database-Level Audit Actions](https://docs.microsoft.com/en-us/sql/relational-databases/security/auditing/sql-server-audit-action-groups-and-actions#database-level-audit-actions)
	AuditActionsAndGroups *[]string `json:"auditActionsAndGroups,omitempty"`
	// StorageAccountSubscriptionID - Specifies the blob storage subscription Id.
	StorageAccountSubscriptionID *uuid.UUID `json:"storageAccountSubscriptionId,omitempty"`
	// IsStorageSecondaryKeyInUse - Specifies whether storageAccountAccessKey value is the storage's secondary key.
	IsStorageSecondaryKeyInUse *bool `json:"isStorageSecondaryKeyInUse,omitempty"`
	// IsAzureMonitorTargetEnabled - Specifies whether audit events are sent to Azure Monitor.
	// In order to send the events to Azure Monitor, specify 'state' as 'Enabled' and 'isAzureMonitorTargetEnabled' as true.
	//
	// When using REST API to configure auditing, Diagnostic Settings with 'SQLSecurityAuditEvents' diagnostic logs category on the database should be also created.
	// Note that for server level audit you should use the 'master' database as {databaseName}.
	//
	// Diagnostic Settings URI format:
	// PUT https://management.azure.com/subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/providers/microsoft.insights/diagnosticSettings/{settingsName}?api-version=2017-05-01-preview
	//
	// For more information, see [Diagnostic Settings REST API](https://go.microsoft.com/fwlink/?linkid=2033207)
	// or [Diagnostic Settings PowerShell](https://go.microsoft.com/fwlink/?linkid=2033043)
	IsAzureMonitorTargetEnabled *bool `json:"isAzureMonitorTargetEnabled,omitempty"`
	// QueueDelayMs - Specifies the amount of time in milliseconds that can elapse before audit actions are forced to be processed.
	// The default minimum value is 1000 (1 second). The maximum is 2,147,483,647.
	QueueDelayMs *int32 `json:"queueDelayMs,omitempty"`
}

// ServerCommunicationLink server communication link.
type ServerCommunicationLink struct {
	autorest.Response `json:"-"`
	// ServerCommunicationLinkProperties - The properties of resource.
	*ServerCommunicationLinkProperties `json:"properties,omitempty"`
	// Location - READ-ONLY; Communication link location.
	Location *string `json:"location,omitempty"`
	// Kind - READ-ONLY; Communication link kind.  This property is used for Azure Portal metadata.
	Kind *string `json:"kind,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ServerCommunicationLink.
func (scl ServerCommunicationLink) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if scl.ServerCommunicationLinkProperties != nil {
		objectMap["properties"] = scl.ServerCommunicationLinkProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ServerCommunicationLink struct.
func (scl *ServerCommunicationLink) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var serverCommunicationLinkProperties ServerCommunicationLinkProperties
				err = json.Unmarshal(*v, &serverCommunicationLinkProperties)
				if err != nil {
					return err
				}
				scl.ServerCommunicationLinkProperties = &serverCommunicationLinkProperties
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				scl.Location = &location
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				scl.Kind = &kind
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				scl.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				scl.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				scl.Type = &typeVar
			}
		}
	}

	return nil
}

// ServerCommunicationLinkListResult a list of server communication links.
type ServerCommunicationLinkListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of server communication links.
	Value *[]ServerCommunicationLink `json:"value,omitempty"`
}

// ServerCommunicationLinkProperties the properties of a server communication link.
type ServerCommunicationLinkProperties struct {
	// State - READ-ONLY; The state.
	State *string `json:"state,omitempty"`
	// PartnerServer - The name of the partner server.
	PartnerServer *string `json:"partnerServer,omitempty"`
}

// MarshalJSON is the custom marshaler for ServerCommunicationLinkProperties.
func (sclp ServerCommunicationLinkProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sclp.PartnerServer != nil {
		objectMap["partnerServer"] = sclp.PartnerServer
	}
	return json.Marshal(objectMap)
}

// ServerCommunicationLinksCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ServerCommunicationLinksCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ServerCommunicationLinksCreateOrUpdateFuture) Result(client ServerCommunicationLinksClient) (scl ServerCommunicationLink, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.ServerCommunicationLinksCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.ServerCommunicationLinksCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if scl.Response.Response, err = future.GetResult(sender); err == nil && scl.Response.Response.StatusCode != http.StatusNoContent {
		scl, err = client.CreateOrUpdateResponder(scl.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.ServerCommunicationLinksCreateOrUpdateFuture", "Result", scl.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ServerConnectionPolicy a server secure connection policy.
type ServerConnectionPolicy struct {
	autorest.Response `json:"-"`
	// Kind - READ-ONLY; Metadata used for the Azure portal experience.
	Kind *string `json:"kind,omitempty"`
	// Location - READ-ONLY; Resource location.
	Location *string `json:"location,omitempty"`
	// ServerConnectionPolicyProperties - The properties of the server secure connection policy.
	*ServerConnectionPolicyProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ServerConnectionPolicy.
func (scp ServerConnectionPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if scp.ServerConnectionPolicyProperties != nil {
		objectMap["properties"] = scp.ServerConnectionPolicyProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ServerConnectionPolicy struct.
func (scp *ServerConnectionPolicy) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				scp.Kind = &kind
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				scp.Location = &location
			}
		case "properties":
			if v != nil {
				var serverConnectionPolicyProperties ServerConnectionPolicyProperties
				err = json.Unmarshal(*v, &serverConnectionPolicyProperties)
				if err != nil {
					return err
				}
				scp.ServerConnectionPolicyProperties = &serverConnectionPolicyProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				scp.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				scp.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				scp.Type = &typeVar
			}
		}
	}

	return nil
}

// ServerConnectionPolicyProperties the properties of a server secure connection policy.
type ServerConnectionPolicyProperties struct {
	// ConnectionType - The server connection type. Possible values include: 'ServerConnectionTypeDefault', 'ServerConnectionTypeProxy', 'ServerConnectionTypeRedirect'
	ConnectionType ServerConnectionType `json:"connectionType,omitempty"`
}

// ServerDNSAlias a server DNS alias.
type ServerDNSAlias struct {
	autorest.Response `json:"-"`
	// ServerDNSAliasProperties - Resource properties.
	*ServerDNSAliasProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ServerDNSAlias.
func (sda ServerDNSAlias) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sda.ServerDNSAliasProperties != nil {
		objectMap["properties"] = sda.ServerDNSAliasProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ServerDNSAlias struct.
func (sda *ServerDNSAlias) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var serverDNSAliasProperties ServerDNSAliasProperties
				err = json.Unmarshal(*v, &serverDNSAliasProperties)
				if err != nil {
					return err
				}
				sda.ServerDNSAliasProperties = &serverDNSAliasProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sda.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sda.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sda.Type = &typeVar
			}
		}
	}

	return nil
}

// ServerDNSAliasAcquisition a server DNS alias acquisition request.
type ServerDNSAliasAcquisition struct {
	// OldServerDNSAliasID - The id of the server alias that will be acquired to point to this server instead.
	OldServerDNSAliasID *string `json:"oldServerDnsAliasId,omitempty"`
}

// ServerDNSAliasesAcquireFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ServerDNSAliasesAcquireFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ServerDNSAliasesAcquireFuture) Result(client ServerDNSAliasesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.ServerDNSAliasesAcquireFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.ServerDNSAliasesAcquireFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ServerDNSAliasesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ServerDNSAliasesCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ServerDNSAliasesCreateOrUpdateFuture) Result(client ServerDNSAliasesClient) (sda ServerDNSAlias, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.ServerDNSAliasesCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.ServerDNSAliasesCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if sda.Response.Response, err = future.GetResult(sender); err == nil && sda.Response.Response.StatusCode != http.StatusNoContent {
		sda, err = client.CreateOrUpdateResponder(sda.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.ServerDNSAliasesCreateOrUpdateFuture", "Result", sda.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ServerDNSAliasesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ServerDNSAliasesDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ServerDNSAliasesDeleteFuture) Result(client ServerDNSAliasesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.ServerDNSAliasesDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.ServerDNSAliasesDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ServerDNSAliasListResult a list of server DNS aliases.
type ServerDNSAliasListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]ServerDNSAlias `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ServerDNSAliasListResultIterator provides access to a complete listing of ServerDNSAlias values.
type ServerDNSAliasListResultIterator struct {
	i    int
	page ServerDNSAliasListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ServerDNSAliasListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServerDNSAliasListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ServerDNSAliasListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ServerDNSAliasListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ServerDNSAliasListResultIterator) Response() ServerDNSAliasListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ServerDNSAliasListResultIterator) Value() ServerDNSAlias {
	if !iter.page.NotDone() {
		return ServerDNSAlias{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ServerDNSAliasListResultIterator type.
func NewServerDNSAliasListResultIterator(page ServerDNSAliasListResultPage) ServerDNSAliasListResultIterator {
	return ServerDNSAliasListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (sdalr ServerDNSAliasListResult) IsEmpty() bool {
	return sdalr.Value == nil || len(*sdalr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (sdalr ServerDNSAliasListResult) hasNextLink() bool {
	return sdalr.NextLink != nil && len(*sdalr.NextLink) != 0
}

// serverDNSAliasListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (sdalr ServerDNSAliasListResult) serverDNSAliasListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !sdalr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(sdalr.NextLink)))
}

// ServerDNSAliasListResultPage contains a page of ServerDNSAlias values.
type ServerDNSAliasListResultPage struct {
	fn    func(context.Context, ServerDNSAliasListResult) (ServerDNSAliasListResult, error)
	sdalr ServerDNSAliasListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ServerDNSAliasListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServerDNSAliasListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.sdalr)
		if err != nil {
			return err
		}
		page.sdalr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ServerDNSAliasListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ServerDNSAliasListResultPage) NotDone() bool {
	return !page.sdalr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ServerDNSAliasListResultPage) Response() ServerDNSAliasListResult {
	return page.sdalr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ServerDNSAliasListResultPage) Values() []ServerDNSAlias {
	if page.sdalr.IsEmpty() {
		return nil
	}
	return *page.sdalr.Value
}

// Creates a new instance of the ServerDNSAliasListResultPage type.
func NewServerDNSAliasListResultPage(getNextPage func(context.Context, ServerDNSAliasListResult) (ServerDNSAliasListResult, error)) ServerDNSAliasListResultPage {
	return ServerDNSAliasListResultPage{fn: getNextPage}
}

// ServerDNSAliasProperties properties of a server DNS alias.
type ServerDNSAliasProperties struct {
	// AzureDNSRecord - READ-ONLY; The fully qualified DNS record for alias
	AzureDNSRecord *string `json:"azureDnsRecord,omitempty"`
}

// ServerKey a server key.
type ServerKey struct {
	autorest.Response `json:"-"`
	// Kind - Kind of encryption protector. This is metadata used for the Azure portal experience.
	Kind *string `json:"kind,omitempty"`
	// Location - READ-ONLY; Resource location.
	Location *string `json:"location,omitempty"`
	// ServerKeyProperties - Resource properties.
	*ServerKeyProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ServerKey.
func (sk ServerKey) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sk.Kind != nil {
		objectMap["kind"] = sk.Kind
	}
	if sk.ServerKeyProperties != nil {
		objectMap["properties"] = sk.ServerKeyProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ServerKey struct.
func (sk *ServerKey) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				sk.Kind = &kind
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				sk.Location = &location
			}
		case "properties":
			if v != nil {
				var serverKeyProperties ServerKeyProperties
				err = json.Unmarshal(*v, &serverKeyProperties)
				if err != nil {
					return err
				}
				sk.ServerKeyProperties = &serverKeyProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sk.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sk.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sk.Type = &typeVar
			}
		}
	}

	return nil
}

// ServerKeyListResult a list of server keys.
type ServerKeyListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]ServerKey `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ServerKeyListResultIterator provides access to a complete listing of ServerKey values.
type ServerKeyListResultIterator struct {
	i    int
	page ServerKeyListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ServerKeyListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServerKeyListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ServerKeyListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ServerKeyListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ServerKeyListResultIterator) Response() ServerKeyListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ServerKeyListResultIterator) Value() ServerKey {
	if !iter.page.NotDone() {
		return ServerKey{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ServerKeyListResultIterator type.
func NewServerKeyListResultIterator(page ServerKeyListResultPage) ServerKeyListResultIterator {
	return ServerKeyListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (sklr ServerKeyListResult) IsEmpty() bool {
	return sklr.Value == nil || len(*sklr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (sklr ServerKeyListResult) hasNextLink() bool {
	return sklr.NextLink != nil && len(*sklr.NextLink) != 0
}

// serverKeyListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (sklr ServerKeyListResult) serverKeyListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !sklr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(sklr.NextLink)))
}

// ServerKeyListResultPage contains a page of ServerKey values.
type ServerKeyListResultPage struct {
	fn   func(context.Context, ServerKeyListResult) (ServerKeyListResult, error)
	sklr ServerKeyListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ServerKeyListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServerKeyListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.sklr)
		if err != nil {
			return err
		}
		page.sklr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ServerKeyListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ServerKeyListResultPage) NotDone() bool {
	return !page.sklr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ServerKeyListResultPage) Response() ServerKeyListResult {
	return page.sklr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ServerKeyListResultPage) Values() []ServerKey {
	if page.sklr.IsEmpty() {
		return nil
	}
	return *page.sklr.Value
}

// Creates a new instance of the ServerKeyListResultPage type.
func NewServerKeyListResultPage(getNextPage func(context.Context, ServerKeyListResult) (ServerKeyListResult, error)) ServerKeyListResultPage {
	return ServerKeyListResultPage{fn: getNextPage}
}

// ServerKeyProperties properties for a server key execution.
type ServerKeyProperties struct {
	// Subregion - READ-ONLY; Subregion of the server key.
	Subregion *string `json:"subregion,omitempty"`
	// ServerKeyType - The server key type like 'ServiceManaged', 'AzureKeyVault'. Possible values include: 'ServiceManaged', 'AzureKeyVault'
	ServerKeyType ServerKeyType `json:"serverKeyType,omitempty"`
	// URI - The URI of the server key.
	URI *string `json:"uri,omitempty"`
	// Thumbprint - Thumbprint of the server key.
	Thumbprint *string `json:"thumbprint,omitempty"`
	// CreationDate - The server key creation date.
	CreationDate *date.Time `json:"creationDate,omitempty"`
}

// MarshalJSON is the custom marshaler for ServerKeyProperties.
func (skp ServerKeyProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if skp.ServerKeyType != "" {
		objectMap["serverKeyType"] = skp.ServerKeyType
	}
	if skp.URI != nil {
		objectMap["uri"] = skp.URI
	}
	if skp.Thumbprint != nil {
		objectMap["thumbprint"] = skp.Thumbprint
	}
	if skp.CreationDate != nil {
		objectMap["creationDate"] = skp.CreationDate
	}
	return json.Marshal(objectMap)
}

// ServerKeysCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ServerKeysCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ServerKeysCreateOrUpdateFuture) Result(client ServerKeysClient) (sk ServerKey, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.ServerKeysCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.ServerKeysCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if sk.Response.Response, err = future.GetResult(sender); err == nil && sk.Response.Response.StatusCode != http.StatusNoContent {
		sk, err = client.CreateOrUpdateResponder(sk.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.ServerKeysCreateOrUpdateFuture", "Result", sk.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ServerKeysDeleteFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type ServerKeysDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ServerKeysDeleteFuture) Result(client ServerKeysClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.ServerKeysDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.ServerKeysDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ServerListResult a list of servers.
type ServerListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]Server `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ServerListResultIterator provides access to a complete listing of Server values.
type ServerListResultIterator struct {
	i    int
	page ServerListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ServerListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServerListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ServerListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ServerListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ServerListResultIterator) Response() ServerListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ServerListResultIterator) Value() Server {
	if !iter.page.NotDone() {
		return Server{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ServerListResultIterator type.
func NewServerListResultIterator(page ServerListResultPage) ServerListResultIterator {
	return ServerListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (slr ServerListResult) IsEmpty() bool {
	return slr.Value == nil || len(*slr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (slr ServerListResult) hasNextLink() bool {
	return slr.NextLink != nil && len(*slr.NextLink) != 0
}

// serverListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (slr ServerListResult) serverListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !slr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(slr.NextLink)))
}

// ServerListResultPage contains a page of Server values.
type ServerListResultPage struct {
	fn  func(context.Context, ServerListResult) (ServerListResult, error)
	slr ServerListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ServerListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServerListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.slr)
		if err != nil {
			return err
		}
		page.slr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ServerListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ServerListResultPage) NotDone() bool {
	return !page.slr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ServerListResultPage) Response() ServerListResult {
	return page.slr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ServerListResultPage) Values() []Server {
	if page.slr.IsEmpty() {
		return nil
	}
	return *page.slr.Value
}

// Creates a new instance of the ServerListResultPage type.
func NewServerListResultPage(getNextPage func(context.Context, ServerListResult) (ServerListResult, error)) ServerListResultPage {
	return ServerListResultPage{fn: getNextPage}
}

// ServerPrivateEndpointConnection a private endpoint connection under a server
type ServerPrivateEndpointConnection struct {
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Properties - READ-ONLY; Private endpoint connection properties
	Properties *PrivateEndpointConnectionProperties `json:"properties,omitempty"`
}

// ServerProperties the properties of a server.
type ServerProperties struct {
	// AdministratorLogin - Administrator username for the server. Once created it cannot be changed.
	AdministratorLogin *string `json:"administratorLogin,omitempty"`
	// AdministratorLoginPassword - The administrator login password (required for server creation).
	AdministratorLoginPassword *string `json:"administratorLoginPassword,omitempty"`
	// Version - The version of the server.
	Version *string `json:"version,omitempty"`
	// State - READ-ONLY; The state of the server.
	State *string `json:"state,omitempty"`
	// FullyQualifiedDomainName - READ-ONLY; The fully qualified domain name of the server.
	FullyQualifiedDomainName *string `json:"fullyQualifiedDomainName,omitempty"`
	// PrivateEndpointConnections - READ-ONLY; List of private endpoint connections on a server
	PrivateEndpointConnections *[]ServerPrivateEndpointConnection `json:"privateEndpointConnections,omitempty"`
	// MinimalTLSVersion - Minimal TLS version. Allowed values: '1.0', '1.1', '1.2'
	MinimalTLSVersion *string `json:"minimalTlsVersion,omitempty"`
	// PublicNetworkAccess - Whether or not public endpoint access is allowed for this server.  Value is optional but if passed in, must be 'Enabled' or 'Disabled'. Possible values include: 'ServerPublicNetworkAccessEnabled', 'ServerPublicNetworkAccessDisabled'
	PublicNetworkAccess ServerPublicNetworkAccess `json:"publicNetworkAccess,omitempty"`
}

// MarshalJSON is the custom marshaler for ServerProperties.
func (sp ServerProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sp.AdministratorLogin != nil {
		objectMap["administratorLogin"] = sp.AdministratorLogin
	}
	if sp.AdministratorLoginPassword != nil {
		objectMap["administratorLoginPassword"] = sp.AdministratorLoginPassword
	}
	if sp.Version != nil {
		objectMap["version"] = sp.Version
	}
	if sp.MinimalTLSVersion != nil {
		objectMap["minimalTlsVersion"] = sp.MinimalTLSVersion
	}
	if sp.PublicNetworkAccess != "" {
		objectMap["publicNetworkAccess"] = sp.PublicNetworkAccess
	}
	return json.Marshal(objectMap)
}

// ServersCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ServersCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ServersCreateOrUpdateFuture) Result(client ServersClient) (s Server, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.ServersCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.ServersCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if s.Response.Response, err = future.GetResult(sender); err == nil && s.Response.Response.StatusCode != http.StatusNoContent {
		s, err = client.CreateOrUpdateResponder(s.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.ServersCreateOrUpdateFuture", "Result", s.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ServersDeleteFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type ServersDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ServersDeleteFuture) Result(client ServersClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.ServersDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.ServersDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ServerSecurityAlertPoliciesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of
// a long-running operation.
type ServerSecurityAlertPoliciesCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ServerSecurityAlertPoliciesCreateOrUpdateFuture) Result(client ServerSecurityAlertPoliciesClient) (ssap ServerSecurityAlertPolicy, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.ServerSecurityAlertPoliciesCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.ServerSecurityAlertPoliciesCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if ssap.Response.Response, err = future.GetResult(sender); err == nil && ssap.Response.Response.StatusCode != http.StatusNoContent {
		ssap, err = client.CreateOrUpdateResponder(ssap.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.ServerSecurityAlertPoliciesCreateOrUpdateFuture", "Result", ssap.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ServerSecurityAlertPolicy a server security alert policy.
type ServerSecurityAlertPolicy struct {
	autorest.Response `json:"-"`
	// SecurityAlertPolicyProperties - Resource properties.
	*SecurityAlertPolicyProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ServerSecurityAlertPolicy.
func (ssap ServerSecurityAlertPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ssap.SecurityAlertPolicyProperties != nil {
		objectMap["properties"] = ssap.SecurityAlertPolicyProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ServerSecurityAlertPolicy struct.
func (ssap *ServerSecurityAlertPolicy) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var securityAlertPolicyProperties SecurityAlertPolicyProperties
				err = json.Unmarshal(*v, &securityAlertPolicyProperties)
				if err != nil {
					return err
				}
				ssap.SecurityAlertPolicyProperties = &securityAlertPolicyProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ssap.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ssap.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ssap.Type = &typeVar
			}
		}
	}

	return nil
}

// ServersUpdateFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type ServersUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ServersUpdateFuture) Result(client ServersClient) (s Server, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.ServersUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.ServersUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if s.Response.Response, err = future.GetResult(sender); err == nil && s.Response.Response.StatusCode != http.StatusNoContent {
		s, err = client.UpdateResponder(s.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.ServersUpdateFuture", "Result", s.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ServerUpdate an update request for an Azure SQL Database server.
type ServerUpdate struct {
	// ServerProperties - Resource properties.
	*ServerProperties `json:"properties,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ServerUpdate.
func (su ServerUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if su.ServerProperties != nil {
		objectMap["properties"] = su.ServerProperties
	}
	if su.Tags != nil {
		objectMap["tags"] = su.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ServerUpdate struct.
func (su *ServerUpdate) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var serverProperties ServerProperties
				err = json.Unmarshal(*v, &serverProperties)
				if err != nil {
					return err
				}
				su.ServerProperties = &serverProperties
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				su.Tags = tags
			}
		}
	}

	return nil
}

// ServerUsage represents server metrics.
type ServerUsage struct {
	// Name - READ-ONLY; Name of the server usage metric.
	Name *string `json:"name,omitempty"`
	// ResourceName - READ-ONLY; The name of the resource.
	ResourceName *string `json:"resourceName,omitempty"`
	// DisplayName - READ-ONLY; The metric display name.
	DisplayName *string `json:"displayName,omitempty"`
	// CurrentValue - READ-ONLY; The current value of the metric.
	CurrentValue *float64 `json:"currentValue,omitempty"`
	// Limit - READ-ONLY; The current limit of the metric.
	Limit *float64 `json:"limit,omitempty"`
	// Unit - READ-ONLY; The units of the metric.
	Unit *string `json:"unit,omitempty"`
	// NextResetTime - READ-ONLY; The next reset time for the metric (ISO8601 format).
	NextResetTime *date.Time `json:"nextResetTime,omitempty"`
}

// ServerUsageListResult represents the response to a list server metrics request.
type ServerUsageListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of server metrics for the server.
	Value *[]ServerUsage `json:"value,omitempty"`
}

// ServerVersionCapability the server capability
type ServerVersionCapability struct {
	// Name - READ-ONLY; The server version name.
	Name *string `json:"name,omitempty"`
	// SupportedEditions - READ-ONLY; The list of supported database editions.
	SupportedEditions *[]EditionCapability `json:"supportedEditions,omitempty"`
	// SupportedElasticPoolEditions - READ-ONLY; The list of supported elastic pool editions.
	SupportedElasticPoolEditions *[]ElasticPoolEditionCapability `json:"supportedElasticPoolEditions,omitempty"`
	// Status - READ-ONLY; The status of the capability. Possible values include: 'CapabilityStatusVisible', 'CapabilityStatusAvailable', 'CapabilityStatusDefault', 'CapabilityStatusDisabled'
	Status CapabilityStatus `json:"status,omitempty"`
	// Reason - The reason for the capability not being available.
	Reason *string `json:"reason,omitempty"`
}

// MarshalJSON is the custom marshaler for ServerVersionCapability.
func (svc ServerVersionCapability) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if svc.Reason != nil {
		objectMap["reason"] = svc.Reason
	}
	return json.Marshal(objectMap)
}

// ServerVulnerabilityAssessment a server vulnerability assessment.
type ServerVulnerabilityAssessment struct {
	autorest.Response `json:"-"`
	// ServerVulnerabilityAssessmentProperties - Resource properties.
	*ServerVulnerabilityAssessmentProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ServerVulnerabilityAssessment.
func (sva ServerVulnerabilityAssessment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sva.ServerVulnerabilityAssessmentProperties != nil {
		objectMap["properties"] = sva.ServerVulnerabilityAssessmentProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ServerVulnerabilityAssessment struct.
func (sva *ServerVulnerabilityAssessment) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var serverVulnerabilityAssessmentProperties ServerVulnerabilityAssessmentProperties
				err = json.Unmarshal(*v, &serverVulnerabilityAssessmentProperties)
				if err != nil {
					return err
				}
				sva.ServerVulnerabilityAssessmentProperties = &serverVulnerabilityAssessmentProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sva.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sva.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sva.Type = &typeVar
			}
		}
	}

	return nil
}

// ServerVulnerabilityAssessmentListResult a list of the server's vulnerability assessments.
type ServerVulnerabilityAssessmentListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]ServerVulnerabilityAssessment `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ServerVulnerabilityAssessmentListResultIterator provides access to a complete listing of
// ServerVulnerabilityAssessment values.
type ServerVulnerabilityAssessmentListResultIterator struct {
	i    int
	page ServerVulnerabilityAssessmentListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ServerVulnerabilityAssessmentListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServerVulnerabilityAssessmentListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ServerVulnerabilityAssessmentListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ServerVulnerabilityAssessmentListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ServerVulnerabilityAssessmentListResultIterator) Response() ServerVulnerabilityAssessmentListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ServerVulnerabilityAssessmentListResultIterator) Value() ServerVulnerabilityAssessment {
	if !iter.page.NotDone() {
		return ServerVulnerabilityAssessment{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ServerVulnerabilityAssessmentListResultIterator type.
func NewServerVulnerabilityAssessmentListResultIterator(page ServerVulnerabilityAssessmentListResultPage) ServerVulnerabilityAssessmentListResultIterator {
	return ServerVulnerabilityAssessmentListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (svalr ServerVulnerabilityAssessmentListResult) IsEmpty() bool {
	return svalr.Value == nil || len(*svalr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (svalr ServerVulnerabilityAssessmentListResult) hasNextLink() bool {
	return svalr.NextLink != nil && len(*svalr.NextLink) != 0
}

// serverVulnerabilityAssessmentListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (svalr ServerVulnerabilityAssessmentListResult) serverVulnerabilityAssessmentListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !svalr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(svalr.NextLink)))
}

// ServerVulnerabilityAssessmentListResultPage contains a page of ServerVulnerabilityAssessment values.
type ServerVulnerabilityAssessmentListResultPage struct {
	fn    func(context.Context, ServerVulnerabilityAssessmentListResult) (ServerVulnerabilityAssessmentListResult, error)
	svalr ServerVulnerabilityAssessmentListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ServerVulnerabilityAssessmentListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServerVulnerabilityAssessmentListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.svalr)
		if err != nil {
			return err
		}
		page.svalr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ServerVulnerabilityAssessmentListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ServerVulnerabilityAssessmentListResultPage) NotDone() bool {
	return !page.svalr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ServerVulnerabilityAssessmentListResultPage) Response() ServerVulnerabilityAssessmentListResult {
	return page.svalr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ServerVulnerabilityAssessmentListResultPage) Values() []ServerVulnerabilityAssessment {
	if page.svalr.IsEmpty() {
		return nil
	}
	return *page.svalr.Value
}

// Creates a new instance of the ServerVulnerabilityAssessmentListResultPage type.
func NewServerVulnerabilityAssessmentListResultPage(getNextPage func(context.Context, ServerVulnerabilityAssessmentListResult) (ServerVulnerabilityAssessmentListResult, error)) ServerVulnerabilityAssessmentListResultPage {
	return ServerVulnerabilityAssessmentListResultPage{fn: getNextPage}
}

// ServerVulnerabilityAssessmentProperties properties of a server Vulnerability Assessment.
type ServerVulnerabilityAssessmentProperties struct {
	// StorageContainerPath - A blob storage container path to hold the scan results (e.g. https://myStorage.blob.core.windows.net/VaScans/).
	StorageContainerPath *string `json:"storageContainerPath,omitempty"`
	// StorageContainerSasKey - A shared access signature (SAS Key) that has read and write access to the blob container specified in 'storageContainerPath' parameter. If 'storageAccountAccessKey' isn't specified, StorageContainerSasKey is required.
	StorageContainerSasKey *string `json:"storageContainerSasKey,omitempty"`
	// StorageAccountAccessKey - Specifies the identifier key of the storage account for vulnerability assessment scan results. If 'StorageContainerSasKey' isn't specified, storageAccountAccessKey is required.
	StorageAccountAccessKey *string `json:"storageAccountAccessKey,omitempty"`
	// RecurringScans - The recurring scans settings
	RecurringScans *VulnerabilityAssessmentRecurringScansProperties `json:"recurringScans,omitempty"`
}

// ServiceObjective represents a database service objective.
type ServiceObjective struct {
	autorest.Response `json:"-"`
	// ServiceObjectiveProperties - Represents the properties of the resource.
	*ServiceObjectiveProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ServiceObjective.
func (so ServiceObjective) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if so.ServiceObjectiveProperties != nil {
		objectMap["properties"] = so.ServiceObjectiveProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ServiceObjective struct.
func (so *ServiceObjective) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var serviceObjectiveProperties ServiceObjectiveProperties
				err = json.Unmarshal(*v, &serviceObjectiveProperties)
				if err != nil {
					return err
				}
				so.ServiceObjectiveProperties = &serviceObjectiveProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				so.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				so.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				so.Type = &typeVar
			}
		}
	}

	return nil
}

// ServiceObjectiveCapability the service objectives capability.
type ServiceObjectiveCapability struct {
	// ID - READ-ONLY; The unique ID of the service objective.
	ID *uuid.UUID `json:"id,omitempty"`
	// Name - READ-ONLY; The service objective name.
	Name *string `json:"name,omitempty"`
	// SupportedMaxSizes - READ-ONLY; The list of supported maximum database sizes.
	SupportedMaxSizes *[]MaxSizeRangeCapability `json:"supportedMaxSizes,omitempty"`
	// PerformanceLevel - READ-ONLY; The performance level.
	PerformanceLevel *PerformanceLevelCapability `json:"performanceLevel,omitempty"`
	// Sku - READ-ONLY; The sku.
	Sku *Sku `json:"sku,omitempty"`
	// SupportedLicenseTypes - READ-ONLY; List of supported license types.
	SupportedLicenseTypes *[]LicenseTypeCapability `json:"supportedLicenseTypes,omitempty"`
	// IncludedMaxSize - READ-ONLY; The included (free) max size.
	IncludedMaxSize *MaxSizeCapability `json:"includedMaxSize,omitempty"`
	// ZoneRedundant - READ-ONLY; Whether or not zone redundancy is supported for the service objective.
	ZoneRedundant *bool `json:"zoneRedundant,omitempty"`
	// SupportedAutoPauseDelay - READ-ONLY; Supported time range for auto pause delay
	SupportedAutoPauseDelay *AutoPauseDelayTimeRange `json:"supportedAutoPauseDelay,omitempty"`
	// SupportedMinCapacities - READ-ONLY; List of supported min capacities
	SupportedMinCapacities *[]MinCapacityCapability `json:"supportedMinCapacities,omitempty"`
	// ComputeModel - READ-ONLY; The compute model
	ComputeModel *string `json:"computeModel,omitempty"`
	// Status - READ-ONLY; The status of the capability. Possible values include: 'CapabilityStatusVisible', 'CapabilityStatusAvailable', 'CapabilityStatusDefault', 'CapabilityStatusDisabled'
	Status CapabilityStatus `json:"status,omitempty"`
	// Reason - The reason for the capability not being available.
	Reason *string `json:"reason,omitempty"`
}

// MarshalJSON is the custom marshaler for ServiceObjectiveCapability.
func (soc ServiceObjectiveCapability) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if soc.Reason != nil {
		objectMap["reason"] = soc.Reason
	}
	return json.Marshal(objectMap)
}

// ServiceObjectiveListResult represents the response to a get database service objectives request.
type ServiceObjectiveListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of database service objectives.
	Value *[]ServiceObjective `json:"value,omitempty"`
}

// ServiceObjectiveProperties represents the properties of a database service objective.
type ServiceObjectiveProperties struct {
	// ServiceObjectiveName - READ-ONLY; The name for the service objective.
	ServiceObjectiveName *string `json:"serviceObjectiveName,omitempty"`
	// IsDefault - READ-ONLY; Gets whether the service level objective is the default service objective.
	IsDefault *bool `json:"isDefault,omitempty"`
	// IsSystem - READ-ONLY; Gets whether the service level objective is a system service objective.
	IsSystem *bool `json:"isSystem,omitempty"`
	// Description - READ-ONLY; The description for the service level objective.
	Description *string `json:"description,omitempty"`
	// Enabled - READ-ONLY; Gets whether the service level objective is enabled.
	Enabled *bool `json:"enabled,omitempty"`
}

// ServiceTierAdvisor represents a Service Tier Advisor.
type ServiceTierAdvisor struct {
	autorest.Response `json:"-"`
	// ServiceTierAdvisorProperties - READ-ONLY; The properties representing the resource.
	*ServiceTierAdvisorProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ServiceTierAdvisor.
func (sta ServiceTierAdvisor) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ServiceTierAdvisor struct.
func (sta *ServiceTierAdvisor) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var serviceTierAdvisorProperties ServiceTierAdvisorProperties
				err = json.Unmarshal(*v, &serviceTierAdvisorProperties)
				if err != nil {
					return err
				}
				sta.ServiceTierAdvisorProperties = &serviceTierAdvisorProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sta.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sta.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sta.Type = &typeVar
			}
		}
	}

	return nil
}

// ServiceTierAdvisorListResult represents the response to a list service tier advisor request.
type ServiceTierAdvisorListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of service tier advisors for specified database.
	Value *[]ServiceTierAdvisor `json:"value,omitempty"`
}

// ServiceTierAdvisorProperties represents the properties of a Service Tier Advisor.
type ServiceTierAdvisorProperties struct {
	// ObservationPeriodStart - READ-ONLY; The observation period start (ISO8601 format).
	ObservationPeriodStart *date.Time `json:"observationPeriodStart,omitempty"`
	// ObservationPeriodEnd - READ-ONLY; The observation period start (ISO8601 format).
	ObservationPeriodEnd *date.Time `json:"observationPeriodEnd,omitempty"`
	// ActiveTimeRatio - READ-ONLY; The activeTimeRatio for service tier advisor.
	ActiveTimeRatio *float64 `json:"activeTimeRatio,omitempty"`
	// MinDtu - READ-ONLY; Gets or sets minDtu for service tier advisor.
	MinDtu *float64 `json:"minDtu,omitempty"`
	// AvgDtu - READ-ONLY; Gets or sets avgDtu for service tier advisor.
	AvgDtu *float64 `json:"avgDtu,omitempty"`
	// MaxDtu - READ-ONLY; Gets or sets maxDtu for service tier advisor.
	MaxDtu *float64 `json:"maxDtu,omitempty"`
	// MaxSizeInGB - READ-ONLY; Gets or sets maxSizeInGB for service tier advisor.
	MaxSizeInGB *float64 `json:"maxSizeInGB,omitempty"`
	// ServiceLevelObjectiveUsageMetrics - READ-ONLY; Gets or sets serviceLevelObjectiveUsageMetrics for the service tier advisor.
	ServiceLevelObjectiveUsageMetrics *[]SloUsageMetric `json:"serviceLevelObjectiveUsageMetrics,omitempty"`
	// CurrentServiceLevelObjective - READ-ONLY; Gets or sets currentServiceLevelObjective for service tier advisor.
	CurrentServiceLevelObjective *string `json:"currentServiceLevelObjective,omitempty"`
	// CurrentServiceLevelObjectiveID - READ-ONLY; Gets or sets currentServiceLevelObjectiveId for service tier advisor.
	CurrentServiceLevelObjectiveID *uuid.UUID `json:"currentServiceLevelObjectiveId,omitempty"`
	// UsageBasedRecommendationServiceLevelObjective - READ-ONLY; Gets or sets usageBasedRecommendationServiceLevelObjective for service tier advisor.
	UsageBasedRecommendationServiceLevelObjective *string `json:"usageBasedRecommendationServiceLevelObjective,omitempty"`
	// UsageBasedRecommendationServiceLevelObjectiveID - READ-ONLY; Gets or sets usageBasedRecommendationServiceLevelObjectiveId for service tier advisor.
	UsageBasedRecommendationServiceLevelObjectiveID *uuid.UUID `json:"usageBasedRecommendationServiceLevelObjectiveId,omitempty"`
	// DatabaseSizeBasedRecommendationServiceLevelObjective - READ-ONLY; Gets or sets databaseSizeBasedRecommendationServiceLevelObjective for service tier advisor.
	DatabaseSizeBasedRecommendationServiceLevelObjective *string `json:"databaseSizeBasedRecommendationServiceLevelObjective,omitempty"`
	// DatabaseSizeBasedRecommendationServiceLevelObjectiveID - READ-ONLY; Gets or sets databaseSizeBasedRecommendationServiceLevelObjectiveId for service tier advisor.
	DatabaseSizeBasedRecommendationServiceLevelObjectiveID *uuid.UUID `json:"databaseSizeBasedRecommendationServiceLevelObjectiveId,omitempty"`
	// DisasterPlanBasedRecommendationServiceLevelObjective - READ-ONLY; Gets or sets disasterPlanBasedRecommendationServiceLevelObjective for service tier advisor.
	DisasterPlanBasedRecommendationServiceLevelObjective *string `json:"disasterPlanBasedRecommendationServiceLevelObjective,omitempty"`
	// DisasterPlanBasedRecommendationServiceLevelObjectiveID - READ-ONLY; Gets or sets disasterPlanBasedRecommendationServiceLevelObjectiveId for service tier advisor.
	DisasterPlanBasedRecommendationServiceLevelObjectiveID *uuid.UUID `json:"disasterPlanBasedRecommendationServiceLevelObjectiveId,omitempty"`
	// OverallRecommendationServiceLevelObjective - READ-ONLY; Gets or sets overallRecommendationServiceLevelObjective for service tier advisor.
	OverallRecommendationServiceLevelObjective *string `json:"overallRecommendationServiceLevelObjective,omitempty"`
	// OverallRecommendationServiceLevelObjectiveID - READ-ONLY; Gets or sets overallRecommendationServiceLevelObjectiveId for service tier advisor.
	OverallRecommendationServiceLevelObjectiveID *uuid.UUID `json:"overallRecommendationServiceLevelObjectiveId,omitempty"`
	// Confidence - READ-ONLY; Gets or sets confidence for service tier advisor.
	Confidence *float64 `json:"confidence,omitempty"`
}

// Sku an ARM Resource SKU.
type Sku struct {
	// Name - The name of the SKU, typically, a letter + Number code, e.g. P3.
	Name *string `json:"name,omitempty"`
	// Tier - The tier or edition of the particular SKU, e.g. Basic, Premium.
	Tier *string `json:"tier,omitempty"`
	// Size - Size of the particular SKU
	Size *string `json:"size,omitempty"`
	// Family - If the service has different generations of hardware, for the same SKU, then that can be captured here.
	Family *string `json:"family,omitempty"`
	// Capacity - Capacity of the particular SKU.
	Capacity *int32 `json:"capacity,omitempty"`
}

// SloUsageMetric a Slo Usage Metric.
type SloUsageMetric struct {
	// ServiceLevelObjective - READ-ONLY; The serviceLevelObjective for SLO usage metric. Possible values include: 'ServiceObjectiveNameSystem', 'ServiceObjectiveNameSystem0', 'ServiceObjectiveNameSystem1', 'ServiceObjectiveNameSystem2', 'ServiceObjectiveNameSystem3', 'ServiceObjectiveNameSystem4', 'ServiceObjectiveNameSystem2L', 'ServiceObjectiveNameSystem3L', 'ServiceObjectiveNameSystem4L', 'ServiceObjectiveNameFree', 'ServiceObjectiveNameBasic', 'ServiceObjectiveNameS0', 'ServiceObjectiveNameS1', 'ServiceObjectiveNameS2', 'ServiceObjectiveNameS3', 'ServiceObjectiveNameS4', 'ServiceObjectiveNameS6', 'ServiceObjectiveNameS7', 'ServiceObjectiveNameS9', 'ServiceObjectiveNameS12', 'ServiceObjectiveNameP1', 'ServiceObjectiveNameP2', 'ServiceObjectiveNameP3', 'ServiceObjectiveNameP4', 'ServiceObjectiveNameP6', 'ServiceObjectiveNameP11', 'ServiceObjectiveNameP15', 'ServiceObjectiveNamePRS1', 'ServiceObjectiveNamePRS2', 'ServiceObjectiveNamePRS4', 'ServiceObjectiveNamePRS6', 'ServiceObjectiveNameDW100', 'ServiceObjectiveNameDW200', 'ServiceObjectiveNameDW300', 'ServiceObjectiveNameDW400', 'ServiceObjectiveNameDW500', 'ServiceObjectiveNameDW600', 'ServiceObjectiveNameDW1000', 'ServiceObjectiveNameDW1200', 'ServiceObjectiveNameDW1000c', 'ServiceObjectiveNameDW1500', 'ServiceObjectiveNameDW1500c', 'ServiceObjectiveNameDW2000', 'ServiceObjectiveNameDW2000c', 'ServiceObjectiveNameDW3000', 'ServiceObjectiveNameDW2500c', 'ServiceObjectiveNameDW3000c', 'ServiceObjectiveNameDW6000', 'ServiceObjectiveNameDW5000c', 'ServiceObjectiveNameDW6000c', 'ServiceObjectiveNameDW7500c', 'ServiceObjectiveNameDW10000c', 'ServiceObjectiveNameDW15000c', 'ServiceObjectiveNameDW30000c', 'ServiceObjectiveNameDS100', 'ServiceObjectiveNameDS200', 'ServiceObjectiveNameDS300', 'ServiceObjectiveNameDS400', 'ServiceObjectiveNameDS500', 'ServiceObjectiveNameDS600', 'ServiceObjectiveNameDS1000', 'ServiceObjectiveNameDS1200', 'ServiceObjectiveNameDS1500', 'ServiceObjectiveNameDS2000', 'ServiceObjectiveNameElasticPool'
	ServiceLevelObjective ServiceObjectiveName `json:"serviceLevelObjective,omitempty"`
	// ServiceLevelObjectiveID - READ-ONLY; The serviceLevelObjectiveId for SLO usage metric.
	ServiceLevelObjectiveID *uuid.UUID `json:"serviceLevelObjectiveId,omitempty"`
	// InRangeTimeRatio - READ-ONLY; Gets or sets inRangeTimeRatio for SLO usage metric.
	InRangeTimeRatio *float64 `json:"inRangeTimeRatio,omitempty"`
}

// StorageCapability the storage account type capability.
type StorageCapability struct {
	// StorageAccountType - READ-ONLY; The storage account type for the database's backups. Possible values include: 'GRS', 'LRS', 'ZRS'
	StorageAccountType StorageAccountType `json:"storageAccountType,omitempty"`
	// Status - READ-ONLY; The status of the capability. Possible values include: 'CapabilityStatusVisible', 'CapabilityStatusAvailable', 'CapabilityStatusDefault', 'CapabilityStatusDisabled'
	Status CapabilityStatus `json:"status,omitempty"`
	// Reason - The reason for the capability not being available.
	Reason *string `json:"reason,omitempty"`
}

// MarshalJSON is the custom marshaler for StorageCapability.
func (sc StorageCapability) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sc.Reason != nil {
		objectMap["reason"] = sc.Reason
	}
	return json.Marshal(objectMap)
}

// SubscriptionUsage usage Metric of a Subscription in a Location.
type SubscriptionUsage struct {
	autorest.Response `json:"-"`
	// SubscriptionUsageProperties - Resource properties.
	*SubscriptionUsageProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for SubscriptionUsage.
func (su SubscriptionUsage) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if su.SubscriptionUsageProperties != nil {
		objectMap["properties"] = su.SubscriptionUsageProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SubscriptionUsage struct.
func (su *SubscriptionUsage) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var subscriptionUsageProperties SubscriptionUsageProperties
				err = json.Unmarshal(*v, &subscriptionUsageProperties)
				if err != nil {
					return err
				}
				su.SubscriptionUsageProperties = &subscriptionUsageProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				su.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				su.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				su.Type = &typeVar
			}
		}
	}

	return nil
}

// SubscriptionUsageListResult a list of subscription usage metrics in a location.
type SubscriptionUsageListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]SubscriptionUsage `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// SubscriptionUsageListResultIterator provides access to a complete listing of SubscriptionUsage values.
type SubscriptionUsageListResultIterator struct {
	i    int
	page SubscriptionUsageListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *SubscriptionUsageListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SubscriptionUsageListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *SubscriptionUsageListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter SubscriptionUsageListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter SubscriptionUsageListResultIterator) Response() SubscriptionUsageListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter SubscriptionUsageListResultIterator) Value() SubscriptionUsage {
	if !iter.page.NotDone() {
		return SubscriptionUsage{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the SubscriptionUsageListResultIterator type.
func NewSubscriptionUsageListResultIterator(page SubscriptionUsageListResultPage) SubscriptionUsageListResultIterator {
	return SubscriptionUsageListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (sulr SubscriptionUsageListResult) IsEmpty() bool {
	return sulr.Value == nil || len(*sulr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (sulr SubscriptionUsageListResult) hasNextLink() bool {
	return sulr.NextLink != nil && len(*sulr.NextLink) != 0
}

// subscriptionUsageListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (sulr SubscriptionUsageListResult) subscriptionUsageListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !sulr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(sulr.NextLink)))
}

// SubscriptionUsageListResultPage contains a page of SubscriptionUsage values.
type SubscriptionUsageListResultPage struct {
	fn   func(context.Context, SubscriptionUsageListResult) (SubscriptionUsageListResult, error)
	sulr SubscriptionUsageListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *SubscriptionUsageListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SubscriptionUsageListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.sulr)
		if err != nil {
			return err
		}
		page.sulr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *SubscriptionUsageListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page SubscriptionUsageListResultPage) NotDone() bool {
	return !page.sulr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page SubscriptionUsageListResultPage) Response() SubscriptionUsageListResult {
	return page.sulr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page SubscriptionUsageListResultPage) Values() []SubscriptionUsage {
	if page.sulr.IsEmpty() {
		return nil
	}
	return *page.sulr.Value
}

// Creates a new instance of the SubscriptionUsageListResultPage type.
func NewSubscriptionUsageListResultPage(getNextPage func(context.Context, SubscriptionUsageListResult) (SubscriptionUsageListResult, error)) SubscriptionUsageListResultPage {
	return SubscriptionUsageListResultPage{fn: getNextPage}
}

// SubscriptionUsageProperties properties of a subscription usage.
type SubscriptionUsageProperties struct {
	// DisplayName - READ-ONLY; User-readable name of the metric.
	DisplayName *string `json:"displayName,omitempty"`
	// CurrentValue - READ-ONLY; Current value of the metric.
	CurrentValue *float64 `json:"currentValue,omitempty"`
	// Limit - READ-ONLY; Boundary value of the metric.
	Limit *float64 `json:"limit,omitempty"`
	// Unit - READ-ONLY; Unit of the metric.
	Unit *string `json:"unit,omitempty"`
}

// SyncAgent an Azure SQL Database sync agent.
type SyncAgent struct {
	autorest.Response `json:"-"`
	// SyncAgentProperties - Resource properties.
	*SyncAgentProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for SyncAgent.
func (sa SyncAgent) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sa.SyncAgentProperties != nil {
		objectMap["properties"] = sa.SyncAgentProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SyncAgent struct.
func (sa *SyncAgent) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var syncAgentProperties SyncAgentProperties
				err = json.Unmarshal(*v, &syncAgentProperties)
				if err != nil {
					return err
				}
				sa.SyncAgentProperties = &syncAgentProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sa.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sa.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sa.Type = &typeVar
			}
		}
	}

	return nil
}

// SyncAgentKeyProperties properties of an Azure SQL Database sync agent key.
type SyncAgentKeyProperties struct {
	autorest.Response `json:"-"`
	// SyncAgentKey - READ-ONLY; Key of sync agent.
	SyncAgentKey *string `json:"syncAgentKey,omitempty"`
}

// SyncAgentLinkedDatabase an Azure SQL Database sync agent linked database.
type SyncAgentLinkedDatabase struct {
	// SyncAgentLinkedDatabaseProperties - Resource properties.
	*SyncAgentLinkedDatabaseProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for SyncAgentLinkedDatabase.
func (sald SyncAgentLinkedDatabase) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sald.SyncAgentLinkedDatabaseProperties != nil {
		objectMap["properties"] = sald.SyncAgentLinkedDatabaseProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SyncAgentLinkedDatabase struct.
func (sald *SyncAgentLinkedDatabase) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var syncAgentLinkedDatabaseProperties SyncAgentLinkedDatabaseProperties
				err = json.Unmarshal(*v, &syncAgentLinkedDatabaseProperties)
				if err != nil {
					return err
				}
				sald.SyncAgentLinkedDatabaseProperties = &syncAgentLinkedDatabaseProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sald.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sald.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sald.Type = &typeVar
			}
		}
	}

	return nil
}

// SyncAgentLinkedDatabaseListResult a list of sync agent linked databases.
type SyncAgentLinkedDatabaseListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]SyncAgentLinkedDatabase `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// SyncAgentLinkedDatabaseListResultIterator provides access to a complete listing of SyncAgentLinkedDatabase
// values.
type SyncAgentLinkedDatabaseListResultIterator struct {
	i    int
	page SyncAgentLinkedDatabaseListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *SyncAgentLinkedDatabaseListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SyncAgentLinkedDatabaseListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *SyncAgentLinkedDatabaseListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter SyncAgentLinkedDatabaseListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter SyncAgentLinkedDatabaseListResultIterator) Response() SyncAgentLinkedDatabaseListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter SyncAgentLinkedDatabaseListResultIterator) Value() SyncAgentLinkedDatabase {
	if !iter.page.NotDone() {
		return SyncAgentLinkedDatabase{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the SyncAgentLinkedDatabaseListResultIterator type.
func NewSyncAgentLinkedDatabaseListResultIterator(page SyncAgentLinkedDatabaseListResultPage) SyncAgentLinkedDatabaseListResultIterator {
	return SyncAgentLinkedDatabaseListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (saldlr SyncAgentLinkedDatabaseListResult) IsEmpty() bool {
	return saldlr.Value == nil || len(*saldlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (saldlr SyncAgentLinkedDatabaseListResult) hasNextLink() bool {
	return saldlr.NextLink != nil && len(*saldlr.NextLink) != 0
}

// syncAgentLinkedDatabaseListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (saldlr SyncAgentLinkedDatabaseListResult) syncAgentLinkedDatabaseListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !saldlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(saldlr.NextLink)))
}

// SyncAgentLinkedDatabaseListResultPage contains a page of SyncAgentLinkedDatabase values.
type SyncAgentLinkedDatabaseListResultPage struct {
	fn     func(context.Context, SyncAgentLinkedDatabaseListResult) (SyncAgentLinkedDatabaseListResult, error)
	saldlr SyncAgentLinkedDatabaseListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *SyncAgentLinkedDatabaseListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SyncAgentLinkedDatabaseListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.saldlr)
		if err != nil {
			return err
		}
		page.saldlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *SyncAgentLinkedDatabaseListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page SyncAgentLinkedDatabaseListResultPage) NotDone() bool {
	return !page.saldlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page SyncAgentLinkedDatabaseListResultPage) Response() SyncAgentLinkedDatabaseListResult {
	return page.saldlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page SyncAgentLinkedDatabaseListResultPage) Values() []SyncAgentLinkedDatabase {
	if page.saldlr.IsEmpty() {
		return nil
	}
	return *page.saldlr.Value
}

// Creates a new instance of the SyncAgentLinkedDatabaseListResultPage type.
func NewSyncAgentLinkedDatabaseListResultPage(getNextPage func(context.Context, SyncAgentLinkedDatabaseListResult) (SyncAgentLinkedDatabaseListResult, error)) SyncAgentLinkedDatabaseListResultPage {
	return SyncAgentLinkedDatabaseListResultPage{fn: getNextPage}
}

// SyncAgentLinkedDatabaseProperties properties of an Azure SQL Database sync agent linked database.
type SyncAgentLinkedDatabaseProperties struct {
	// DatabaseType - READ-ONLY; Type of the sync agent linked database. Possible values include: 'AzureSQLDatabase', 'SQLServerDatabase'
	DatabaseType SyncMemberDbType `json:"databaseType,omitempty"`
	// DatabaseID - READ-ONLY; Id of the sync agent linked database.
	DatabaseID *string `json:"databaseId,omitempty"`
	// Description - READ-ONLY; Description of the sync agent linked database.
	Description *string `json:"description,omitempty"`
	// ServerName - READ-ONLY; Server name of the sync agent linked database.
	ServerName *string `json:"serverName,omitempty"`
	// DatabaseName - READ-ONLY; Database name of the sync agent linked database.
	DatabaseName *string `json:"databaseName,omitempty"`
	// UserName - READ-ONLY; User name of the sync agent linked database.
	UserName *string `json:"userName,omitempty"`
}

// SyncAgentListResult a list of sync agents.
type SyncAgentListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]SyncAgent `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// SyncAgentListResultIterator provides access to a complete listing of SyncAgent values.
type SyncAgentListResultIterator struct {
	i    int
	page SyncAgentListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *SyncAgentListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SyncAgentListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *SyncAgentListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter SyncAgentListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter SyncAgentListResultIterator) Response() SyncAgentListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter SyncAgentListResultIterator) Value() SyncAgent {
	if !iter.page.NotDone() {
		return SyncAgent{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the SyncAgentListResultIterator type.
func NewSyncAgentListResultIterator(page SyncAgentListResultPage) SyncAgentListResultIterator {
	return SyncAgentListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (salr SyncAgentListResult) IsEmpty() bool {
	return salr.Value == nil || len(*salr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (salr SyncAgentListResult) hasNextLink() bool {
	return salr.NextLink != nil && len(*salr.NextLink) != 0
}

// syncAgentListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (salr SyncAgentListResult) syncAgentListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !salr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(salr.NextLink)))
}

// SyncAgentListResultPage contains a page of SyncAgent values.
type SyncAgentListResultPage struct {
	fn   func(context.Context, SyncAgentListResult) (SyncAgentListResult, error)
	salr SyncAgentListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *SyncAgentListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SyncAgentListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.salr)
		if err != nil {
			return err
		}
		page.salr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *SyncAgentListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page SyncAgentListResultPage) NotDone() bool {
	return !page.salr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page SyncAgentListResultPage) Response() SyncAgentListResult {
	return page.salr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page SyncAgentListResultPage) Values() []SyncAgent {
	if page.salr.IsEmpty() {
		return nil
	}
	return *page.salr.Value
}

// Creates a new instance of the SyncAgentListResultPage type.
func NewSyncAgentListResultPage(getNextPage func(context.Context, SyncAgentListResult) (SyncAgentListResult, error)) SyncAgentListResultPage {
	return SyncAgentListResultPage{fn: getNextPage}
}

// SyncAgentProperties properties of an Azure SQL Database sync agent.
type SyncAgentProperties struct {
	// Name - READ-ONLY; Name of the sync agent.
	Name *string `json:"name,omitempty"`
	// SyncDatabaseID - ARM resource id of the sync database in the sync agent.
	SyncDatabaseID *string `json:"syncDatabaseId,omitempty"`
	// LastAliveTime - READ-ONLY; Last alive time of the sync agent.
	LastAliveTime *date.Time `json:"lastAliveTime,omitempty"`
	// State - READ-ONLY; State of the sync agent. Possible values include: 'SyncAgentStateOnline', 'SyncAgentStateOffline', 'SyncAgentStateNeverConnected'
	State SyncAgentState `json:"state,omitempty"`
	// IsUpToDate - READ-ONLY; If the sync agent version is up to date.
	IsUpToDate *bool `json:"isUpToDate,omitempty"`
	// ExpiryTime - READ-ONLY; Expiration time of the sync agent version.
	ExpiryTime *date.Time `json:"expiryTime,omitempty"`
	// Version - READ-ONLY; Version of the sync agent.
	Version *string `json:"version,omitempty"`
}

// MarshalJSON is the custom marshaler for SyncAgentProperties.
func (sap SyncAgentProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sap.SyncDatabaseID != nil {
		objectMap["syncDatabaseId"] = sap.SyncDatabaseID
	}
	return json.Marshal(objectMap)
}

// SyncAgentsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type SyncAgentsCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *SyncAgentsCreateOrUpdateFuture) Result(client SyncAgentsClient) (sa SyncAgent, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.SyncAgentsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.SyncAgentsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if sa.Response.Response, err = future.GetResult(sender); err == nil && sa.Response.Response.StatusCode != http.StatusNoContent {
		sa, err = client.CreateOrUpdateResponder(sa.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.SyncAgentsCreateOrUpdateFuture", "Result", sa.Response.Response, "Failure responding to request")
		}
	}
	return
}

// SyncAgentsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type SyncAgentsDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *SyncAgentsDeleteFuture) Result(client SyncAgentsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.SyncAgentsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.SyncAgentsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// SyncDatabaseIDListResult a list of sync database ID properties.
type SyncDatabaseIDListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]SyncDatabaseIDProperties `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// SyncDatabaseIDListResultIterator provides access to a complete listing of SyncDatabaseIDProperties values.
type SyncDatabaseIDListResultIterator struct {
	i    int
	page SyncDatabaseIDListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *SyncDatabaseIDListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SyncDatabaseIDListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *SyncDatabaseIDListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter SyncDatabaseIDListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter SyncDatabaseIDListResultIterator) Response() SyncDatabaseIDListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter SyncDatabaseIDListResultIterator) Value() SyncDatabaseIDProperties {
	if !iter.page.NotDone() {
		return SyncDatabaseIDProperties{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the SyncDatabaseIDListResultIterator type.
func NewSyncDatabaseIDListResultIterator(page SyncDatabaseIDListResultPage) SyncDatabaseIDListResultIterator {
	return SyncDatabaseIDListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (sdilr SyncDatabaseIDListResult) IsEmpty() bool {
	return sdilr.Value == nil || len(*sdilr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (sdilr SyncDatabaseIDListResult) hasNextLink() bool {
	return sdilr.NextLink != nil && len(*sdilr.NextLink) != 0
}

// syncDatabaseIDListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (sdilr SyncDatabaseIDListResult) syncDatabaseIDListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !sdilr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(sdilr.NextLink)))
}

// SyncDatabaseIDListResultPage contains a page of SyncDatabaseIDProperties values.
type SyncDatabaseIDListResultPage struct {
	fn    func(context.Context, SyncDatabaseIDListResult) (SyncDatabaseIDListResult, error)
	sdilr SyncDatabaseIDListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *SyncDatabaseIDListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SyncDatabaseIDListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.sdilr)
		if err != nil {
			return err
		}
		page.sdilr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *SyncDatabaseIDListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page SyncDatabaseIDListResultPage) NotDone() bool {
	return !page.sdilr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page SyncDatabaseIDListResultPage) Response() SyncDatabaseIDListResult {
	return page.sdilr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page SyncDatabaseIDListResultPage) Values() []SyncDatabaseIDProperties {
	if page.sdilr.IsEmpty() {
		return nil
	}
	return *page.sdilr.Value
}

// Creates a new instance of the SyncDatabaseIDListResultPage type.
func NewSyncDatabaseIDListResultPage(getNextPage func(context.Context, SyncDatabaseIDListResult) (SyncDatabaseIDListResult, error)) SyncDatabaseIDListResultPage {
	return SyncDatabaseIDListResultPage{fn: getNextPage}
}

// SyncDatabaseIDProperties properties of the sync database id.
type SyncDatabaseIDProperties struct {
	// ID - READ-ONLY; ARM resource id of sync database.
	ID *string `json:"id,omitempty"`
}

// SyncFullSchemaProperties properties of the database full schema.
type SyncFullSchemaProperties struct {
	// Tables - READ-ONLY; List of tables in the database full schema.
	Tables *[]SyncFullSchemaTable `json:"tables,omitempty"`
	// LastUpdateTime - READ-ONLY; Last update time of the database schema.
	LastUpdateTime *date.Time `json:"lastUpdateTime,omitempty"`
}

// SyncFullSchemaPropertiesListResult a list of sync schema properties.
type SyncFullSchemaPropertiesListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]SyncFullSchemaProperties `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// SyncFullSchemaPropertiesListResultIterator provides access to a complete listing of SyncFullSchemaProperties
// values.
type SyncFullSchemaPropertiesListResultIterator struct {
	i    int
	page SyncFullSchemaPropertiesListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *SyncFullSchemaPropertiesListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SyncFullSchemaPropertiesListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *SyncFullSchemaPropertiesListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter SyncFullSchemaPropertiesListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter SyncFullSchemaPropertiesListResultIterator) Response() SyncFullSchemaPropertiesListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter SyncFullSchemaPropertiesListResultIterator) Value() SyncFullSchemaProperties {
	if !iter.page.NotDone() {
		return SyncFullSchemaProperties{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the SyncFullSchemaPropertiesListResultIterator type.
func NewSyncFullSchemaPropertiesListResultIterator(page SyncFullSchemaPropertiesListResultPage) SyncFullSchemaPropertiesListResultIterator {
	return SyncFullSchemaPropertiesListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (sfsplr SyncFullSchemaPropertiesListResult) IsEmpty() bool {
	return sfsplr.Value == nil || len(*sfsplr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (sfsplr SyncFullSchemaPropertiesListResult) hasNextLink() bool {
	return sfsplr.NextLink != nil && len(*sfsplr.NextLink) != 0
}

// syncFullSchemaPropertiesListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (sfsplr SyncFullSchemaPropertiesListResult) syncFullSchemaPropertiesListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !sfsplr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(sfsplr.NextLink)))
}

// SyncFullSchemaPropertiesListResultPage contains a page of SyncFullSchemaProperties values.
type SyncFullSchemaPropertiesListResultPage struct {
	fn     func(context.Context, SyncFullSchemaPropertiesListResult) (SyncFullSchemaPropertiesListResult, error)
	sfsplr SyncFullSchemaPropertiesListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *SyncFullSchemaPropertiesListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SyncFullSchemaPropertiesListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.sfsplr)
		if err != nil {
			return err
		}
		page.sfsplr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *SyncFullSchemaPropertiesListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page SyncFullSchemaPropertiesListResultPage) NotDone() bool {
	return !page.sfsplr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page SyncFullSchemaPropertiesListResultPage) Response() SyncFullSchemaPropertiesListResult {
	return page.sfsplr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page SyncFullSchemaPropertiesListResultPage) Values() []SyncFullSchemaProperties {
	if page.sfsplr.IsEmpty() {
		return nil
	}
	return *page.sfsplr.Value
}

// Creates a new instance of the SyncFullSchemaPropertiesListResultPage type.
func NewSyncFullSchemaPropertiesListResultPage(getNextPage func(context.Context, SyncFullSchemaPropertiesListResult) (SyncFullSchemaPropertiesListResult, error)) SyncFullSchemaPropertiesListResultPage {
	return SyncFullSchemaPropertiesListResultPage{fn: getNextPage}
}

// SyncFullSchemaTable properties of the table in the database full schema.
type SyncFullSchemaTable struct {
	// Columns - READ-ONLY; List of columns in the table of database full schema.
	Columns *[]SyncFullSchemaTableColumn `json:"columns,omitempty"`
	// ErrorID - READ-ONLY; Error id of the table.
	ErrorID *string `json:"errorId,omitempty"`
	// HasError - READ-ONLY; If there is error in the table.
	HasError *bool `json:"hasError,omitempty"`
	// Name - READ-ONLY; Name of the table.
	Name *string `json:"name,omitempty"`
	// QuotedName - READ-ONLY; Quoted name of the table.
	QuotedName *string `json:"quotedName,omitempty"`
}

// SyncFullSchemaTableColumn properties of the column in the table of database full schema.
type SyncFullSchemaTableColumn struct {
	// DataSize - READ-ONLY; Data size of the column.
	DataSize *string `json:"dataSize,omitempty"`
	// DataType - READ-ONLY; Data type of the column.
	DataType *string `json:"dataType,omitempty"`
	// ErrorID - READ-ONLY; Error id of the column.
	ErrorID *string `json:"errorId,omitempty"`
	// HasError - READ-ONLY; If there is error in the table.
	HasError *bool `json:"hasError,omitempty"`
	// IsPrimaryKey - READ-ONLY; If it is the primary key of the table.
	IsPrimaryKey *bool `json:"isPrimaryKey,omitempty"`
	// Name - READ-ONLY; Name of the column.
	Name *string `json:"name,omitempty"`
	// QuotedName - READ-ONLY; Quoted name of the column.
	QuotedName *string `json:"quotedName,omitempty"`
}

// SyncGroup an Azure SQL Database sync group.
type SyncGroup struct {
	autorest.Response `json:"-"`
	// SyncGroupProperties - Resource properties.
	*SyncGroupProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for SyncGroup.
func (sg SyncGroup) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sg.SyncGroupProperties != nil {
		objectMap["properties"] = sg.SyncGroupProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SyncGroup struct.
func (sg *SyncGroup) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var syncGroupProperties SyncGroupProperties
				err = json.Unmarshal(*v, &syncGroupProperties)
				if err != nil {
					return err
				}
				sg.SyncGroupProperties = &syncGroupProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sg.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sg.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sg.Type = &typeVar
			}
		}
	}

	return nil
}

// SyncGroupListResult a list of sync groups.
type SyncGroupListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]SyncGroup `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// SyncGroupListResultIterator provides access to a complete listing of SyncGroup values.
type SyncGroupListResultIterator struct {
	i    int
	page SyncGroupListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *SyncGroupListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SyncGroupListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *SyncGroupListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter SyncGroupListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter SyncGroupListResultIterator) Response() SyncGroupListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter SyncGroupListResultIterator) Value() SyncGroup {
	if !iter.page.NotDone() {
		return SyncGroup{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the SyncGroupListResultIterator type.
func NewSyncGroupListResultIterator(page SyncGroupListResultPage) SyncGroupListResultIterator {
	return SyncGroupListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (sglr SyncGroupListResult) IsEmpty() bool {
	return sglr.Value == nil || len(*sglr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (sglr SyncGroupListResult) hasNextLink() bool {
	return sglr.NextLink != nil && len(*sglr.NextLink) != 0
}

// syncGroupListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (sglr SyncGroupListResult) syncGroupListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !sglr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(sglr.NextLink)))
}

// SyncGroupListResultPage contains a page of SyncGroup values.
type SyncGroupListResultPage struct {
	fn   func(context.Context, SyncGroupListResult) (SyncGroupListResult, error)
	sglr SyncGroupListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *SyncGroupListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SyncGroupListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.sglr)
		if err != nil {
			return err
		}
		page.sglr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *SyncGroupListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page SyncGroupListResultPage) NotDone() bool {
	return !page.sglr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page SyncGroupListResultPage) Response() SyncGroupListResult {
	return page.sglr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page SyncGroupListResultPage) Values() []SyncGroup {
	if page.sglr.IsEmpty() {
		return nil
	}
	return *page.sglr.Value
}

// Creates a new instance of the SyncGroupListResultPage type.
func NewSyncGroupListResultPage(getNextPage func(context.Context, SyncGroupListResult) (SyncGroupListResult, error)) SyncGroupListResultPage {
	return SyncGroupListResultPage{fn: getNextPage}
}

// SyncGroupLogListResult a list of sync group log properties.
type SyncGroupLogListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]SyncGroupLogProperties `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// SyncGroupLogListResultIterator provides access to a complete listing of SyncGroupLogProperties values.
type SyncGroupLogListResultIterator struct {
	i    int
	page SyncGroupLogListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *SyncGroupLogListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SyncGroupLogListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *SyncGroupLogListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter SyncGroupLogListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter SyncGroupLogListResultIterator) Response() SyncGroupLogListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter SyncGroupLogListResultIterator) Value() SyncGroupLogProperties {
	if !iter.page.NotDone() {
		return SyncGroupLogProperties{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the SyncGroupLogListResultIterator type.
func NewSyncGroupLogListResultIterator(page SyncGroupLogListResultPage) SyncGroupLogListResultIterator {
	return SyncGroupLogListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (sgllr SyncGroupLogListResult) IsEmpty() bool {
	return sgllr.Value == nil || len(*sgllr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (sgllr SyncGroupLogListResult) hasNextLink() bool {
	return sgllr.NextLink != nil && len(*sgllr.NextLink) != 0
}

// syncGroupLogListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (sgllr SyncGroupLogListResult) syncGroupLogListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !sgllr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(sgllr.NextLink)))
}

// SyncGroupLogListResultPage contains a page of SyncGroupLogProperties values.
type SyncGroupLogListResultPage struct {
	fn    func(context.Context, SyncGroupLogListResult) (SyncGroupLogListResult, error)
	sgllr SyncGroupLogListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *SyncGroupLogListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SyncGroupLogListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.sgllr)
		if err != nil {
			return err
		}
		page.sgllr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *SyncGroupLogListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page SyncGroupLogListResultPage) NotDone() bool {
	return !page.sgllr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page SyncGroupLogListResultPage) Response() SyncGroupLogListResult {
	return page.sgllr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page SyncGroupLogListResultPage) Values() []SyncGroupLogProperties {
	if page.sgllr.IsEmpty() {
		return nil
	}
	return *page.sgllr.Value
}

// Creates a new instance of the SyncGroupLogListResultPage type.
func NewSyncGroupLogListResultPage(getNextPage func(context.Context, SyncGroupLogListResult) (SyncGroupLogListResult, error)) SyncGroupLogListResultPage {
	return SyncGroupLogListResultPage{fn: getNextPage}
}

// SyncGroupLogProperties properties of an Azure SQL Database sync group log.
type SyncGroupLogProperties struct {
	// Timestamp - READ-ONLY; Timestamp of the sync group log.
	Timestamp *date.Time `json:"timestamp,omitempty"`
	// Type - READ-ONLY; Type of the sync group log. Possible values include: 'SyncGroupLogTypeAll', 'SyncGroupLogTypeError', 'SyncGroupLogTypeWarning', 'SyncGroupLogTypeSuccess'
	Type SyncGroupLogType `json:"type,omitempty"`
	// Source - READ-ONLY; Source of the sync group log.
	Source *string `json:"source,omitempty"`
	// Details - READ-ONLY; Details of the sync group log.
	Details *string `json:"details,omitempty"`
	// TracingID - READ-ONLY; TracingId of the sync group log.
	TracingID *uuid.UUID `json:"tracingId,omitempty"`
	// OperationStatus - READ-ONLY; OperationStatus of the sync group log.
	OperationStatus *string `json:"operationStatus,omitempty"`
}

// SyncGroupProperties properties of a sync group.
type SyncGroupProperties struct {
	// Interval - Sync interval of the sync group.
	Interval *int32 `json:"interval,omitempty"`
	// LastSyncTime - READ-ONLY; Last sync time of the sync group.
	LastSyncTime *date.Time `json:"lastSyncTime,omitempty"`
	// ConflictResolutionPolicy - Conflict resolution policy of the sync group. Possible values include: 'HubWin', 'MemberWin'
	ConflictResolutionPolicy SyncConflictResolutionPolicy `json:"conflictResolutionPolicy,omitempty"`
	// SyncDatabaseID - ARM resource id of the sync database in the sync group.
	SyncDatabaseID *string `json:"syncDatabaseId,omitempty"`
	// HubDatabaseUserName - User name for the sync group hub database credential.
	HubDatabaseUserName *string `json:"hubDatabaseUserName,omitempty"`
	// HubDatabasePassword - Password for the sync group hub database credential.
	HubDatabasePassword *string `json:"hubDatabasePassword,omitempty"`
	// SyncState - READ-ONLY; Sync state of the sync group. Possible values include: 'NotReady', 'Error', 'Warning', 'Progressing', 'Good'
	SyncState SyncGroupState `json:"syncState,omitempty"`
	// Schema - Sync schema of the sync group.
	Schema *SyncGroupSchema `json:"schema,omitempty"`
	// UsePrivateLinkConnection - If use private link connection is enabled.
	UsePrivateLinkConnection *bool `json:"usePrivateLinkConnection,omitempty"`
}

// MarshalJSON is the custom marshaler for SyncGroupProperties.
func (sgp SyncGroupProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sgp.Interval != nil {
		objectMap["interval"] = sgp.Interval
	}
	if sgp.ConflictResolutionPolicy != "" {
		objectMap["conflictResolutionPolicy"] = sgp.ConflictResolutionPolicy
	}
	if sgp.SyncDatabaseID != nil {
		objectMap["syncDatabaseId"] = sgp.SyncDatabaseID
	}
	if sgp.HubDatabaseUserName != nil {
		objectMap["hubDatabaseUserName"] = sgp.HubDatabaseUserName
	}
	if sgp.HubDatabasePassword != nil {
		objectMap["hubDatabasePassword"] = sgp.HubDatabasePassword
	}
	if sgp.Schema != nil {
		objectMap["schema"] = sgp.Schema
	}
	if sgp.UsePrivateLinkConnection != nil {
		objectMap["usePrivateLinkConnection"] = sgp.UsePrivateLinkConnection
	}
	return json.Marshal(objectMap)
}

// SyncGroupSchema properties of sync group schema.
type SyncGroupSchema struct {
	// Tables - List of tables in sync group schema.
	Tables *[]SyncGroupSchemaTable `json:"tables,omitempty"`
	// MasterSyncMemberName - Name of master sync member where the schema is from.
	MasterSyncMemberName *string `json:"masterSyncMemberName,omitempty"`
}

// SyncGroupSchemaTable properties of table in sync group schema.
type SyncGroupSchemaTable struct {
	// Columns - List of columns in sync group schema.
	Columns *[]SyncGroupSchemaTableColumn `json:"columns,omitempty"`
	// QuotedName - Quoted name of sync group schema table.
	QuotedName *string `json:"quotedName,omitempty"`
}

// SyncGroupSchemaTableColumn properties of column in sync group table.
type SyncGroupSchemaTableColumn struct {
	// QuotedName - Quoted name of sync group table column.
	QuotedName *string `json:"quotedName,omitempty"`
	// DataSize - Data size of the column.
	DataSize *string `json:"dataSize,omitempty"`
	// DataType - Data type of the column.
	DataType *string `json:"dataType,omitempty"`
}

// SyncGroupsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type SyncGroupsCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *SyncGroupsCreateOrUpdateFuture) Result(client SyncGroupsClient) (sg SyncGroup, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.SyncGroupsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.SyncGroupsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if sg.Response.Response, err = future.GetResult(sender); err == nil && sg.Response.Response.StatusCode != http.StatusNoContent {
		sg, err = client.CreateOrUpdateResponder(sg.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.SyncGroupsCreateOrUpdateFuture", "Result", sg.Response.Response, "Failure responding to request")
		}
	}
	return
}

// SyncGroupsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type SyncGroupsDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *SyncGroupsDeleteFuture) Result(client SyncGroupsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.SyncGroupsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.SyncGroupsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// SyncGroupsRefreshHubSchemaFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type SyncGroupsRefreshHubSchemaFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *SyncGroupsRefreshHubSchemaFuture) Result(client SyncGroupsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.SyncGroupsRefreshHubSchemaFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.SyncGroupsRefreshHubSchemaFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// SyncGroupsUpdateFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type SyncGroupsUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *SyncGroupsUpdateFuture) Result(client SyncGroupsClient) (sg SyncGroup, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.SyncGroupsUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.SyncGroupsUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if sg.Response.Response, err = future.GetResult(sender); err == nil && sg.Response.Response.StatusCode != http.StatusNoContent {
		sg, err = client.UpdateResponder(sg.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.SyncGroupsUpdateFuture", "Result", sg.Response.Response, "Failure responding to request")
		}
	}
	return
}

// SyncMember an Azure SQL Database sync member.
type SyncMember struct {
	autorest.Response `json:"-"`
	// SyncMemberProperties - Resource properties.
	*SyncMemberProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for SyncMember.
func (sm SyncMember) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sm.SyncMemberProperties != nil {
		objectMap["properties"] = sm.SyncMemberProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SyncMember struct.
func (sm *SyncMember) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var syncMemberProperties SyncMemberProperties
				err = json.Unmarshal(*v, &syncMemberProperties)
				if err != nil {
					return err
				}
				sm.SyncMemberProperties = &syncMemberProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sm.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sm.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sm.Type = &typeVar
			}
		}
	}

	return nil
}

// SyncMemberListResult a list of Azure SQL Database sync members.
type SyncMemberListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]SyncMember `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// SyncMemberListResultIterator provides access to a complete listing of SyncMember values.
type SyncMemberListResultIterator struct {
	i    int
	page SyncMemberListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *SyncMemberListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SyncMemberListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *SyncMemberListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter SyncMemberListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter SyncMemberListResultIterator) Response() SyncMemberListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter SyncMemberListResultIterator) Value() SyncMember {
	if !iter.page.NotDone() {
		return SyncMember{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the SyncMemberListResultIterator type.
func NewSyncMemberListResultIterator(page SyncMemberListResultPage) SyncMemberListResultIterator {
	return SyncMemberListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (smlr SyncMemberListResult) IsEmpty() bool {
	return smlr.Value == nil || len(*smlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (smlr SyncMemberListResult) hasNextLink() bool {
	return smlr.NextLink != nil && len(*smlr.NextLink) != 0
}

// syncMemberListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (smlr SyncMemberListResult) syncMemberListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !smlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(smlr.NextLink)))
}

// SyncMemberListResultPage contains a page of SyncMember values.
type SyncMemberListResultPage struct {
	fn   func(context.Context, SyncMemberListResult) (SyncMemberListResult, error)
	smlr SyncMemberListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *SyncMemberListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SyncMemberListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.smlr)
		if err != nil {
			return err
		}
		page.smlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *SyncMemberListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page SyncMemberListResultPage) NotDone() bool {
	return !page.smlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page SyncMemberListResultPage) Response() SyncMemberListResult {
	return page.smlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page SyncMemberListResultPage) Values() []SyncMember {
	if page.smlr.IsEmpty() {
		return nil
	}
	return *page.smlr.Value
}

// Creates a new instance of the SyncMemberListResultPage type.
func NewSyncMemberListResultPage(getNextPage func(context.Context, SyncMemberListResult) (SyncMemberListResult, error)) SyncMemberListResultPage {
	return SyncMemberListResultPage{fn: getNextPage}
}

// SyncMemberProperties properties of a sync member.
type SyncMemberProperties struct {
	// DatabaseType - Database type of the sync member. Possible values include: 'AzureSQLDatabase', 'SQLServerDatabase'
	DatabaseType SyncMemberDbType `json:"databaseType,omitempty"`
	// SyncAgentID - ARM resource id of the sync agent in the sync member.
	SyncAgentID *string `json:"syncAgentId,omitempty"`
	// SQLServerDatabaseID - SQL Server database id of the sync member.
	SQLServerDatabaseID *uuid.UUID `json:"sqlServerDatabaseId,omitempty"`
	// SyncMemberAzureDatabaseResourceID - ARM resource id of the sync member logical database, for sync members in Azure.
	SyncMemberAzureDatabaseResourceID *string `json:"syncMemberAzureDatabaseResourceId,omitempty"`
	// UsePrivateLinkConnection - Whether to use private link connection.
	UsePrivateLinkConnection *bool `json:"usePrivateLinkConnection,omitempty"`
	// ServerName - Server name of the member database in the sync member
	ServerName *string `json:"serverName,omitempty"`
	// DatabaseName - Database name of the member database in the sync member.
	DatabaseName *string `json:"databaseName,omitempty"`
	// UserName - User name of the member database in the sync member.
	UserName *string `json:"userName,omitempty"`
	// Password - Password of the member database in the sync member.
	Password *string `json:"password,omitempty"`
	// SyncDirection - Sync direction of the sync member. Possible values include: 'Bidirectional', 'OneWayMemberToHub', 'OneWayHubToMember'
	SyncDirection SyncDirection `json:"syncDirection,omitempty"`
	// SyncState - READ-ONLY; Sync state of the sync member. Possible values include: 'SyncInProgress', 'SyncSucceeded', 'SyncFailed', 'DisabledTombstoneCleanup', 'DisabledBackupRestore', 'SyncSucceededWithWarnings', 'SyncCancelling', 'SyncCancelled', 'UnProvisioned', 'Provisioning', 'Provisioned', 'ProvisionFailed', 'DeProvisioning', 'DeProvisioned', 'DeProvisionFailed', 'Reprovisioning', 'ReprovisionFailed', 'UnReprovisioned'
	SyncState SyncMemberState `json:"syncState,omitempty"`
}

// MarshalJSON is the custom marshaler for SyncMemberProperties.
func (smp SyncMemberProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if smp.DatabaseType != "" {
		objectMap["databaseType"] = smp.DatabaseType
	}
	if smp.SyncAgentID != nil {
		objectMap["syncAgentId"] = smp.SyncAgentID
	}
	if smp.SQLServerDatabaseID != nil {
		objectMap["sqlServerDatabaseId"] = smp.SQLServerDatabaseID
	}
	if smp.SyncMemberAzureDatabaseResourceID != nil {
		objectMap["syncMemberAzureDatabaseResourceId"] = smp.SyncMemberAzureDatabaseResourceID
	}
	if smp.UsePrivateLinkConnection != nil {
		objectMap["usePrivateLinkConnection"] = smp.UsePrivateLinkConnection
	}
	if smp.ServerName != nil {
		objectMap["serverName"] = smp.ServerName
	}
	if smp.DatabaseName != nil {
		objectMap["databaseName"] = smp.DatabaseName
	}
	if smp.UserName != nil {
		objectMap["userName"] = smp.UserName
	}
	if smp.Password != nil {
		objectMap["password"] = smp.Password
	}
	if smp.SyncDirection != "" {
		objectMap["syncDirection"] = smp.SyncDirection
	}
	return json.Marshal(objectMap)
}

// SyncMembersCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type SyncMembersCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *SyncMembersCreateOrUpdateFuture) Result(client SyncMembersClient) (sm SyncMember, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.SyncMembersCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.SyncMembersCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if sm.Response.Response, err = future.GetResult(sender); err == nil && sm.Response.Response.StatusCode != http.StatusNoContent {
		sm, err = client.CreateOrUpdateResponder(sm.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.SyncMembersCreateOrUpdateFuture", "Result", sm.Response.Response, "Failure responding to request")
		}
	}
	return
}

// SyncMembersDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type SyncMembersDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *SyncMembersDeleteFuture) Result(client SyncMembersClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.SyncMembersDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.SyncMembersDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// SyncMembersRefreshMemberSchemaFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type SyncMembersRefreshMemberSchemaFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *SyncMembersRefreshMemberSchemaFuture) Result(client SyncMembersClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.SyncMembersRefreshMemberSchemaFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.SyncMembersRefreshMemberSchemaFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// SyncMembersUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type SyncMembersUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *SyncMembersUpdateFuture) Result(client SyncMembersClient) (sm SyncMember, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.SyncMembersUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.SyncMembersUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if sm.Response.Response, err = future.GetResult(sender); err == nil && sm.Response.Response.StatusCode != http.StatusNoContent {
		sm, err = client.UpdateResponder(sm.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.SyncMembersUpdateFuture", "Result", sm.Response.Response, "Failure responding to request")
		}
	}
	return
}

// TdeCertificate a TDE certificate that can be uploaded into a server.
type TdeCertificate struct {
	// TdeCertificateProperties - Resource properties.
	*TdeCertificateProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for TdeCertificate.
func (tc TdeCertificate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tc.TdeCertificateProperties != nil {
		objectMap["properties"] = tc.TdeCertificateProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for TdeCertificate struct.
func (tc *TdeCertificate) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var tdeCertificateProperties TdeCertificateProperties
				err = json.Unmarshal(*v, &tdeCertificateProperties)
				if err != nil {
					return err
				}
				tc.TdeCertificateProperties = &tdeCertificateProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				tc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				tc.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				tc.Type = &typeVar
			}
		}
	}

	return nil
}

// TdeCertificateProperties properties of a TDE certificate.
type TdeCertificateProperties struct {
	// PrivateBlob - The base64 encoded certificate private blob.
	PrivateBlob *string `json:"privateBlob,omitempty"`
	// CertPassword - The certificate password.
	CertPassword *string `json:"certPassword,omitempty"`
}

// TdeCertificatesCreateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type TdeCertificatesCreateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *TdeCertificatesCreateFuture) Result(client TdeCertificatesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.TdeCertificatesCreateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.TdeCertificatesCreateFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// TrackedResource ARM tracked top level resource.
type TrackedResource struct {
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for TrackedResource.
func (tr TrackedResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tr.Location != nil {
		objectMap["location"] = tr.Location
	}
	if tr.Tags != nil {
		objectMap["tags"] = tr.Tags
	}
	return json.Marshal(objectMap)
}

// TransparentDataEncryption represents a database transparent data encryption configuration.
type TransparentDataEncryption struct {
	autorest.Response `json:"-"`
	// Location - READ-ONLY; Resource location.
	Location *string `json:"location,omitempty"`
	// TransparentDataEncryptionProperties - Represents the properties of the resource.
	*TransparentDataEncryptionProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for TransparentDataEncryption.
func (tde TransparentDataEncryption) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tde.TransparentDataEncryptionProperties != nil {
		objectMap["properties"] = tde.TransparentDataEncryptionProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for TransparentDataEncryption struct.
func (tde *TransparentDataEncryption) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				tde.Location = &location
			}
		case "properties":
			if v != nil {
				var transparentDataEncryptionProperties TransparentDataEncryptionProperties
				err = json.Unmarshal(*v, &transparentDataEncryptionProperties)
				if err != nil {
					return err
				}
				tde.TransparentDataEncryptionProperties = &transparentDataEncryptionProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				tde.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				tde.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				tde.Type = &typeVar
			}
		}
	}

	return nil
}

// TransparentDataEncryptionActivity represents a database transparent data encryption Scan.
type TransparentDataEncryptionActivity struct {
	// Location - READ-ONLY; Resource location.
	Location *string `json:"location,omitempty"`
	// TransparentDataEncryptionActivityProperties - Represents the properties of the resource.
	*TransparentDataEncryptionActivityProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for TransparentDataEncryptionActivity.
func (tdea TransparentDataEncryptionActivity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tdea.TransparentDataEncryptionActivityProperties != nil {
		objectMap["properties"] = tdea.TransparentDataEncryptionActivityProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for TransparentDataEncryptionActivity struct.
func (tdea *TransparentDataEncryptionActivity) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				tdea.Location = &location
			}
		case "properties":
			if v != nil {
				var transparentDataEncryptionActivityProperties TransparentDataEncryptionActivityProperties
				err = json.Unmarshal(*v, &transparentDataEncryptionActivityProperties)
				if err != nil {
					return err
				}
				tdea.TransparentDataEncryptionActivityProperties = &transparentDataEncryptionActivityProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				tdea.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				tdea.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				tdea.Type = &typeVar
			}
		}
	}

	return nil
}

// TransparentDataEncryptionActivityListResult represents the response to a list database transparent data
// encryption activity request.
type TransparentDataEncryptionActivityListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of database transparent data encryption activities.
	Value *[]TransparentDataEncryptionActivity `json:"value,omitempty"`
}

// TransparentDataEncryptionActivityProperties represents the properties of a database transparent data
// encryption Scan.
type TransparentDataEncryptionActivityProperties struct {
	// Status - READ-ONLY; The status of the database. Possible values include: 'Encrypting', 'Decrypting'
	Status TransparentDataEncryptionActivityStatus `json:"status,omitempty"`
	// PercentComplete - READ-ONLY; The percent complete of the transparent data encryption scan for a database.
	PercentComplete *float64 `json:"percentComplete,omitempty"`
}

// TransparentDataEncryptionProperties represents the properties of a database transparent data encryption.
type TransparentDataEncryptionProperties struct {
	// Status - The status of the database transparent data encryption. Possible values include: 'TransparentDataEncryptionStatusEnabled', 'TransparentDataEncryptionStatusDisabled'
	Status TransparentDataEncryptionStatus `json:"status,omitempty"`
}

// UnlinkParameters represents the parameters for Unlink Replication Link request.
type UnlinkParameters struct {
	// ForcedTermination - Determines whether link will be terminated in a forced or a friendly way.
	ForcedTermination *bool `json:"forcedTermination,omitempty"`
}

// UpsertManagedServerOperationParameters ...
type UpsertManagedServerOperationParameters struct {
	Family          *string `json:"family,omitempty"`
	Tier            *string `json:"tier,omitempty"`
	VCores          *int32  `json:"vCores,omitempty"`
	StorageSizeInGB *int32  `json:"storageSizeInGB,omitempty"`
}

// UpsertManagedServerOperationStep ...
type UpsertManagedServerOperationStep struct {
	Order *int32  `json:"order,omitempty"`
	Name  *string `json:"name,omitempty"`
	// Status - Possible values include: 'StatusNotStarted', 'StatusInProgress', 'StatusSlowedDown', 'StatusCompleted', 'StatusFailed', 'StatusCanceled'
	Status Status `json:"status,omitempty"`
}

// Usage ARM usage.
type Usage struct {
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *Name `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Unit - READ-ONLY; Usage unit.
	Unit *string `json:"unit,omitempty"`
	// CurrentValue - READ-ONLY; Usage current value.
	CurrentValue *int32 `json:"currentValue,omitempty"`
	// Limit - READ-ONLY; Usage limit.
	Limit *int32 `json:"limit,omitempty"`
	// RequestedLimit - READ-ONLY; Usage requested limit.
	RequestedLimit *int32 `json:"requestedLimit,omitempty"`
}

// UsageListResult a list of usages.
type UsageListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]Usage `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// UsageListResultIterator provides access to a complete listing of Usage values.
type UsageListResultIterator struct {
	i    int
	page UsageListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *UsageListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/UsageListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *UsageListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter UsageListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter UsageListResultIterator) Response() UsageListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter UsageListResultIterator) Value() Usage {
	if !iter.page.NotDone() {
		return Usage{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the UsageListResultIterator type.
func NewUsageListResultIterator(page UsageListResultPage) UsageListResultIterator {
	return UsageListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ulr UsageListResult) IsEmpty() bool {
	return ulr.Value == nil || len(*ulr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (ulr UsageListResult) hasNextLink() bool {
	return ulr.NextLink != nil && len(*ulr.NextLink) != 0
}

// usageListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ulr UsageListResult) usageListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !ulr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ulr.NextLink)))
}

// UsageListResultPage contains a page of Usage values.
type UsageListResultPage struct {
	fn  func(context.Context, UsageListResult) (UsageListResult, error)
	ulr UsageListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *UsageListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/UsageListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.ulr)
		if err != nil {
			return err
		}
		page.ulr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *UsageListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page UsageListResultPage) NotDone() bool {
	return !page.ulr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page UsageListResultPage) Response() UsageListResult {
	return page.ulr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page UsageListResultPage) Values() []Usage {
	if page.ulr.IsEmpty() {
		return nil
	}
	return *page.ulr.Value
}

// Creates a new instance of the UsageListResultPage type.
func NewUsageListResultPage(getNextPage func(context.Context, UsageListResult) (UsageListResult, error)) UsageListResultPage {
	return UsageListResultPage{fn: getNextPage}
}

// VirtualCluster an Azure SQL virtual cluster.
type VirtualCluster struct {
	autorest.Response `json:"-"`
	// VirtualClusterProperties - Resource properties.
	*VirtualClusterProperties `json:"properties,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for VirtualCluster.
func (vc VirtualCluster) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vc.VirtualClusterProperties != nil {
		objectMap["properties"] = vc.VirtualClusterProperties
	}
	if vc.Location != nil {
		objectMap["location"] = vc.Location
	}
	if vc.Tags != nil {
		objectMap["tags"] = vc.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for VirtualCluster struct.
func (vc *VirtualCluster) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var virtualClusterProperties VirtualClusterProperties
				err = json.Unmarshal(*v, &virtualClusterProperties)
				if err != nil {
					return err
				}
				vc.VirtualClusterProperties = &virtualClusterProperties
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				vc.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				vc.Tags = tags
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				vc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				vc.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				vc.Type = &typeVar
			}
		}
	}

	return nil
}

// VirtualClusterListResult a list of virtual clusters.
type VirtualClusterListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]VirtualCluster `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// VirtualClusterListResultIterator provides access to a complete listing of VirtualCluster values.
type VirtualClusterListResultIterator struct {
	i    int
	page VirtualClusterListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *VirtualClusterListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VirtualClusterListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *VirtualClusterListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter VirtualClusterListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter VirtualClusterListResultIterator) Response() VirtualClusterListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter VirtualClusterListResultIterator) Value() VirtualCluster {
	if !iter.page.NotDone() {
		return VirtualCluster{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the VirtualClusterListResultIterator type.
func NewVirtualClusterListResultIterator(page VirtualClusterListResultPage) VirtualClusterListResultIterator {
	return VirtualClusterListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (vclr VirtualClusterListResult) IsEmpty() bool {
	return vclr.Value == nil || len(*vclr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (vclr VirtualClusterListResult) hasNextLink() bool {
	return vclr.NextLink != nil && len(*vclr.NextLink) != 0
}

// virtualClusterListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (vclr VirtualClusterListResult) virtualClusterListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !vclr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(vclr.NextLink)))
}

// VirtualClusterListResultPage contains a page of VirtualCluster values.
type VirtualClusterListResultPage struct {
	fn   func(context.Context, VirtualClusterListResult) (VirtualClusterListResult, error)
	vclr VirtualClusterListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *VirtualClusterListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VirtualClusterListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.vclr)
		if err != nil {
			return err
		}
		page.vclr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *VirtualClusterListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page VirtualClusterListResultPage) NotDone() bool {
	return !page.vclr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page VirtualClusterListResultPage) Response() VirtualClusterListResult {
	return page.vclr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page VirtualClusterListResultPage) Values() []VirtualCluster {
	if page.vclr.IsEmpty() {
		return nil
	}
	return *page.vclr.Value
}

// Creates a new instance of the VirtualClusterListResultPage type.
func NewVirtualClusterListResultPage(getNextPage func(context.Context, VirtualClusterListResult) (VirtualClusterListResult, error)) VirtualClusterListResultPage {
	return VirtualClusterListResultPage{fn: getNextPage}
}

// VirtualClusterProperties the properties of a virtual cluster.
type VirtualClusterProperties struct {
	// SubnetID - READ-ONLY; Subnet resource ID for the virtual cluster.
	SubnetID *string `json:"subnetId,omitempty"`
	// Family - If the service has different generations of hardware, for the same SKU, then that can be captured here.
	Family *string `json:"family,omitempty"`
	// ChildResources - READ-ONLY; List of resources in this virtual cluster.
	ChildResources *[]string `json:"childResources,omitempty"`
}

// MarshalJSON is the custom marshaler for VirtualClusterProperties.
func (vcp VirtualClusterProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vcp.Family != nil {
		objectMap["family"] = vcp.Family
	}
	return json.Marshal(objectMap)
}

// VirtualClustersDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type VirtualClustersDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *VirtualClustersDeleteFuture) Result(client VirtualClustersClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.VirtualClustersDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.VirtualClustersDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// VirtualClustersUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type VirtualClustersUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *VirtualClustersUpdateFuture) Result(client VirtualClustersClient) (vc VirtualCluster, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.VirtualClustersUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.VirtualClustersUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if vc.Response.Response, err = future.GetResult(sender); err == nil && vc.Response.Response.StatusCode != http.StatusNoContent {
		vc, err = client.UpdateResponder(vc.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.VirtualClustersUpdateFuture", "Result", vc.Response.Response, "Failure responding to request")
		}
	}
	return
}

// VirtualClusterUpdate an update request for an Azure SQL Database virtual cluster.
type VirtualClusterUpdate struct {
	// VirtualClusterProperties - Resource properties.
	*VirtualClusterProperties `json:"properties,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for VirtualClusterUpdate.
func (vcu VirtualClusterUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vcu.VirtualClusterProperties != nil {
		objectMap["properties"] = vcu.VirtualClusterProperties
	}
	if vcu.Tags != nil {
		objectMap["tags"] = vcu.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for VirtualClusterUpdate struct.
func (vcu *VirtualClusterUpdate) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var virtualClusterProperties VirtualClusterProperties
				err = json.Unmarshal(*v, &virtualClusterProperties)
				if err != nil {
					return err
				}
				vcu.VirtualClusterProperties = &virtualClusterProperties
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				vcu.Tags = tags
			}
		}
	}

	return nil
}

// VirtualNetworkRule a virtual network rule.
type VirtualNetworkRule struct {
	autorest.Response `json:"-"`
	// VirtualNetworkRuleProperties - Resource properties.
	*VirtualNetworkRuleProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for VirtualNetworkRule.
func (vnr VirtualNetworkRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vnr.VirtualNetworkRuleProperties != nil {
		objectMap["properties"] = vnr.VirtualNetworkRuleProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for VirtualNetworkRule struct.
func (vnr *VirtualNetworkRule) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var virtualNetworkRuleProperties VirtualNetworkRuleProperties
				err = json.Unmarshal(*v, &virtualNetworkRuleProperties)
				if err != nil {
					return err
				}
				vnr.VirtualNetworkRuleProperties = &virtualNetworkRuleProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				vnr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				vnr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				vnr.Type = &typeVar
			}
		}
	}

	return nil
}

// VirtualNetworkRuleListResult a list of virtual network rules.
type VirtualNetworkRuleListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]VirtualNetworkRule `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// VirtualNetworkRuleListResultIterator provides access to a complete listing of VirtualNetworkRule values.
type VirtualNetworkRuleListResultIterator struct {
	i    int
	page VirtualNetworkRuleListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *VirtualNetworkRuleListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VirtualNetworkRuleListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *VirtualNetworkRuleListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter VirtualNetworkRuleListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter VirtualNetworkRuleListResultIterator) Response() VirtualNetworkRuleListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter VirtualNetworkRuleListResultIterator) Value() VirtualNetworkRule {
	if !iter.page.NotDone() {
		return VirtualNetworkRule{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the VirtualNetworkRuleListResultIterator type.
func NewVirtualNetworkRuleListResultIterator(page VirtualNetworkRuleListResultPage) VirtualNetworkRuleListResultIterator {
	return VirtualNetworkRuleListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (vnrlr VirtualNetworkRuleListResult) IsEmpty() bool {
	return vnrlr.Value == nil || len(*vnrlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (vnrlr VirtualNetworkRuleListResult) hasNextLink() bool {
	return vnrlr.NextLink != nil && len(*vnrlr.NextLink) != 0
}

// virtualNetworkRuleListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (vnrlr VirtualNetworkRuleListResult) virtualNetworkRuleListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !vnrlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(vnrlr.NextLink)))
}

// VirtualNetworkRuleListResultPage contains a page of VirtualNetworkRule values.
type VirtualNetworkRuleListResultPage struct {
	fn    func(context.Context, VirtualNetworkRuleListResult) (VirtualNetworkRuleListResult, error)
	vnrlr VirtualNetworkRuleListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *VirtualNetworkRuleListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VirtualNetworkRuleListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.vnrlr)
		if err != nil {
			return err
		}
		page.vnrlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *VirtualNetworkRuleListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page VirtualNetworkRuleListResultPage) NotDone() bool {
	return !page.vnrlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page VirtualNetworkRuleListResultPage) Response() VirtualNetworkRuleListResult {
	return page.vnrlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page VirtualNetworkRuleListResultPage) Values() []VirtualNetworkRule {
	if page.vnrlr.IsEmpty() {
		return nil
	}
	return *page.vnrlr.Value
}

// Creates a new instance of the VirtualNetworkRuleListResultPage type.
func NewVirtualNetworkRuleListResultPage(getNextPage func(context.Context, VirtualNetworkRuleListResult) (VirtualNetworkRuleListResult, error)) VirtualNetworkRuleListResultPage {
	return VirtualNetworkRuleListResultPage{fn: getNextPage}
}

// VirtualNetworkRuleProperties properties of a virtual network rule.
type VirtualNetworkRuleProperties struct {
	// VirtualNetworkSubnetID - The ARM resource id of the virtual network subnet.
	VirtualNetworkSubnetID *string `json:"virtualNetworkSubnetId,omitempty"`
	// IgnoreMissingVnetServiceEndpoint - Create firewall rule before the virtual network has vnet service endpoint enabled.
	IgnoreMissingVnetServiceEndpoint *bool `json:"ignoreMissingVnetServiceEndpoint,omitempty"`
	// State - READ-ONLY; Virtual Network Rule State. Possible values include: 'VirtualNetworkRuleStateInitializing', 'VirtualNetworkRuleStateInProgress', 'VirtualNetworkRuleStateReady', 'VirtualNetworkRuleStateDeleting', 'VirtualNetworkRuleStateUnknown'
	State VirtualNetworkRuleState `json:"state,omitempty"`
}

// MarshalJSON is the custom marshaler for VirtualNetworkRuleProperties.
func (vnrp VirtualNetworkRuleProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vnrp.VirtualNetworkSubnetID != nil {
		objectMap["virtualNetworkSubnetId"] = vnrp.VirtualNetworkSubnetID
	}
	if vnrp.IgnoreMissingVnetServiceEndpoint != nil {
		objectMap["ignoreMissingVnetServiceEndpoint"] = vnrp.IgnoreMissingVnetServiceEndpoint
	}
	return json.Marshal(objectMap)
}

// VirtualNetworkRulesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type VirtualNetworkRulesCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *VirtualNetworkRulesCreateOrUpdateFuture) Result(client VirtualNetworkRulesClient) (vnr VirtualNetworkRule, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.VirtualNetworkRulesCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.VirtualNetworkRulesCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if vnr.Response.Response, err = future.GetResult(sender); err == nil && vnr.Response.Response.StatusCode != http.StatusNoContent {
		vnr, err = client.CreateOrUpdateResponder(vnr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.VirtualNetworkRulesCreateOrUpdateFuture", "Result", vnr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// VirtualNetworkRulesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type VirtualNetworkRulesDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *VirtualNetworkRulesDeleteFuture) Result(client VirtualNetworkRulesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.VirtualNetworkRulesDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.VirtualNetworkRulesDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// VulnerabilityAssessmentRecurringScansProperties properties of a Vulnerability Assessment recurring scans.
type VulnerabilityAssessmentRecurringScansProperties struct {
	// IsEnabled - Recurring scans state.
	IsEnabled *bool `json:"isEnabled,omitempty"`
	// EmailSubscriptionAdmins - Specifies that the schedule scan notification will be is sent to the subscription administrators.
	EmailSubscriptionAdmins *bool `json:"emailSubscriptionAdmins,omitempty"`
	// Emails - Specifies an array of e-mail addresses to which the scan notification is sent.
	Emails *[]string `json:"emails,omitempty"`
}

// VulnerabilityAssessmentScanError properties of a vulnerability assessment scan error.
type VulnerabilityAssessmentScanError struct {
	// Code - READ-ONLY; The error code.
	Code *string `json:"code,omitempty"`
	// Message - READ-ONLY; The error message.
	Message *string `json:"message,omitempty"`
}

// VulnerabilityAssessmentScanRecord a vulnerability assessment scan record.
type VulnerabilityAssessmentScanRecord struct {
	autorest.Response `json:"-"`
	// VulnerabilityAssessmentScanRecordProperties - Resource properties.
	*VulnerabilityAssessmentScanRecordProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for VulnerabilityAssessmentScanRecord.
func (vasr VulnerabilityAssessmentScanRecord) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vasr.VulnerabilityAssessmentScanRecordProperties != nil {
		objectMap["properties"] = vasr.VulnerabilityAssessmentScanRecordProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for VulnerabilityAssessmentScanRecord struct.
func (vasr *VulnerabilityAssessmentScanRecord) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var vulnerabilityAssessmentScanRecordProperties VulnerabilityAssessmentScanRecordProperties
				err = json.Unmarshal(*v, &vulnerabilityAssessmentScanRecordProperties)
				if err != nil {
					return err
				}
				vasr.VulnerabilityAssessmentScanRecordProperties = &vulnerabilityAssessmentScanRecordProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				vasr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				vasr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				vasr.Type = &typeVar
			}
		}
	}

	return nil
}

// VulnerabilityAssessmentScanRecordListResult a list of vulnerability assessment scan records.
type VulnerabilityAssessmentScanRecordListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]VulnerabilityAssessmentScanRecord `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// VulnerabilityAssessmentScanRecordListResultIterator provides access to a complete listing of
// VulnerabilityAssessmentScanRecord values.
type VulnerabilityAssessmentScanRecordListResultIterator struct {
	i    int
	page VulnerabilityAssessmentScanRecordListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *VulnerabilityAssessmentScanRecordListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VulnerabilityAssessmentScanRecordListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *VulnerabilityAssessmentScanRecordListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter VulnerabilityAssessmentScanRecordListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter VulnerabilityAssessmentScanRecordListResultIterator) Response() VulnerabilityAssessmentScanRecordListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter VulnerabilityAssessmentScanRecordListResultIterator) Value() VulnerabilityAssessmentScanRecord {
	if !iter.page.NotDone() {
		return VulnerabilityAssessmentScanRecord{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the VulnerabilityAssessmentScanRecordListResultIterator type.
func NewVulnerabilityAssessmentScanRecordListResultIterator(page VulnerabilityAssessmentScanRecordListResultPage) VulnerabilityAssessmentScanRecordListResultIterator {
	return VulnerabilityAssessmentScanRecordListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (vasrlr VulnerabilityAssessmentScanRecordListResult) IsEmpty() bool {
	return vasrlr.Value == nil || len(*vasrlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (vasrlr VulnerabilityAssessmentScanRecordListResult) hasNextLink() bool {
	return vasrlr.NextLink != nil && len(*vasrlr.NextLink) != 0
}

// vulnerabilityAssessmentScanRecordListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (vasrlr VulnerabilityAssessmentScanRecordListResult) vulnerabilityAssessmentScanRecordListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !vasrlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(vasrlr.NextLink)))
}

// VulnerabilityAssessmentScanRecordListResultPage contains a page of VulnerabilityAssessmentScanRecord values.
type VulnerabilityAssessmentScanRecordListResultPage struct {
	fn     func(context.Context, VulnerabilityAssessmentScanRecordListResult) (VulnerabilityAssessmentScanRecordListResult, error)
	vasrlr VulnerabilityAssessmentScanRecordListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *VulnerabilityAssessmentScanRecordListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VulnerabilityAssessmentScanRecordListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.vasrlr)
		if err != nil {
			return err
		}
		page.vasrlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *VulnerabilityAssessmentScanRecordListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page VulnerabilityAssessmentScanRecordListResultPage) NotDone() bool {
	return !page.vasrlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page VulnerabilityAssessmentScanRecordListResultPage) Response() VulnerabilityAssessmentScanRecordListResult {
	return page.vasrlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page VulnerabilityAssessmentScanRecordListResultPage) Values() []VulnerabilityAssessmentScanRecord {
	if page.vasrlr.IsEmpty() {
		return nil
	}
	return *page.vasrlr.Value
}

// Creates a new instance of the VulnerabilityAssessmentScanRecordListResultPage type.
func NewVulnerabilityAssessmentScanRecordListResultPage(getNextPage func(context.Context, VulnerabilityAssessmentScanRecordListResult) (VulnerabilityAssessmentScanRecordListResult, error)) VulnerabilityAssessmentScanRecordListResultPage {
	return VulnerabilityAssessmentScanRecordListResultPage{fn: getNextPage}
}

// VulnerabilityAssessmentScanRecordProperties properties of a vulnerability assessment scan record.
type VulnerabilityAssessmentScanRecordProperties struct {
	// ScanID - READ-ONLY; The scan ID.
	ScanID *string `json:"scanId,omitempty"`
	// TriggerType - READ-ONLY; The scan trigger type. Possible values include: 'VulnerabilityAssessmentScanTriggerTypeOnDemand', 'VulnerabilityAssessmentScanTriggerTypeRecurring'
	TriggerType VulnerabilityAssessmentScanTriggerType `json:"triggerType,omitempty"`
	// State - READ-ONLY; The scan status. Possible values include: 'VulnerabilityAssessmentScanStatePassed', 'VulnerabilityAssessmentScanStateFailed', 'VulnerabilityAssessmentScanStateFailedToRun', 'VulnerabilityAssessmentScanStateInProgress'
	State VulnerabilityAssessmentScanState `json:"state,omitempty"`
	// StartTime - READ-ONLY; The scan start time (UTC).
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - READ-ONLY; The scan end time (UTC).
	EndTime *date.Time `json:"endTime,omitempty"`
	// Errors - READ-ONLY; The scan errors.
	Errors *[]VulnerabilityAssessmentScanError `json:"errors,omitempty"`
	// StorageContainerPath - READ-ONLY; The scan results storage container path.
	StorageContainerPath *string `json:"storageContainerPath,omitempty"`
	// NumberOfFailedSecurityChecks - READ-ONLY; The number of failed security checks.
	NumberOfFailedSecurityChecks *int32 `json:"numberOfFailedSecurityChecks,omitempty"`
}

// WorkloadClassifier workload classifier operations for a data warehouse
type WorkloadClassifier struct {
	autorest.Response `json:"-"`
	// WorkloadClassifierProperties - Resource properties.
	*WorkloadClassifierProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for WorkloadClassifier.
func (wc WorkloadClassifier) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if wc.WorkloadClassifierProperties != nil {
		objectMap["properties"] = wc.WorkloadClassifierProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for WorkloadClassifier struct.
func (wc *WorkloadClassifier) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var workloadClassifierProperties WorkloadClassifierProperties
				err = json.Unmarshal(*v, &workloadClassifierProperties)
				if err != nil {
					return err
				}
				wc.WorkloadClassifierProperties = &workloadClassifierProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				wc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				wc.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				wc.Type = &typeVar
			}
		}
	}

	return nil
}

// WorkloadClassifierListResult a list of workload classifiers for a workload group.
type WorkloadClassifierListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]WorkloadClassifier `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// WorkloadClassifierListResultIterator provides access to a complete listing of WorkloadClassifier values.
type WorkloadClassifierListResultIterator struct {
	i    int
	page WorkloadClassifierListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *WorkloadClassifierListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WorkloadClassifierListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *WorkloadClassifierListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter WorkloadClassifierListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter WorkloadClassifierListResultIterator) Response() WorkloadClassifierListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter WorkloadClassifierListResultIterator) Value() WorkloadClassifier {
	if !iter.page.NotDone() {
		return WorkloadClassifier{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the WorkloadClassifierListResultIterator type.
func NewWorkloadClassifierListResultIterator(page WorkloadClassifierListResultPage) WorkloadClassifierListResultIterator {
	return WorkloadClassifierListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (wclr WorkloadClassifierListResult) IsEmpty() bool {
	return wclr.Value == nil || len(*wclr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (wclr WorkloadClassifierListResult) hasNextLink() bool {
	return wclr.NextLink != nil && len(*wclr.NextLink) != 0
}

// workloadClassifierListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (wclr WorkloadClassifierListResult) workloadClassifierListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !wclr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(wclr.NextLink)))
}

// WorkloadClassifierListResultPage contains a page of WorkloadClassifier values.
type WorkloadClassifierListResultPage struct {
	fn   func(context.Context, WorkloadClassifierListResult) (WorkloadClassifierListResult, error)
	wclr WorkloadClassifierListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *WorkloadClassifierListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WorkloadClassifierListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.wclr)
		if err != nil {
			return err
		}
		page.wclr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *WorkloadClassifierListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page WorkloadClassifierListResultPage) NotDone() bool {
	return !page.wclr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page WorkloadClassifierListResultPage) Response() WorkloadClassifierListResult {
	return page.wclr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page WorkloadClassifierListResultPage) Values() []WorkloadClassifier {
	if page.wclr.IsEmpty() {
		return nil
	}
	return *page.wclr.Value
}

// Creates a new instance of the WorkloadClassifierListResultPage type.
func NewWorkloadClassifierListResultPage(getNextPage func(context.Context, WorkloadClassifierListResult) (WorkloadClassifierListResult, error)) WorkloadClassifierListResultPage {
	return WorkloadClassifierListResultPage{fn: getNextPage}
}

// WorkloadClassifierProperties workload classifier definition. For more information look at
// sys.workload_management_workload_classifiers (DMV).
type WorkloadClassifierProperties struct {
	// MemberName - The workload classifier member name.
	MemberName *string `json:"memberName,omitempty"`
	// Label - The workload classifier label.
	Label *string `json:"label,omitempty"`
	// Context - The workload classifier context.
	Context *string `json:"context,omitempty"`
	// StartTime - The workload classifier start time for classification.
	StartTime *string `json:"startTime,omitempty"`
	// EndTime - The workload classifier end time for classification.
	EndTime *string `json:"endTime,omitempty"`
	// Importance - The workload classifier importance.
	Importance *string `json:"importance,omitempty"`
}

// WorkloadClassifiersCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type WorkloadClassifiersCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *WorkloadClassifiersCreateOrUpdateFuture) Result(client WorkloadClassifiersClient) (wc WorkloadClassifier, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.WorkloadClassifiersCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.WorkloadClassifiersCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if wc.Response.Response, err = future.GetResult(sender); err == nil && wc.Response.Response.StatusCode != http.StatusNoContent {
		wc, err = client.CreateOrUpdateResponder(wc.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.WorkloadClassifiersCreateOrUpdateFuture", "Result", wc.Response.Response, "Failure responding to request")
		}
	}
	return
}

// WorkloadClassifiersDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type WorkloadClassifiersDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *WorkloadClassifiersDeleteFuture) Result(client WorkloadClassifiersClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.WorkloadClassifiersDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.WorkloadClassifiersDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// WorkloadGroup workload group operations for a data warehouse
type WorkloadGroup struct {
	autorest.Response `json:"-"`
	// WorkloadGroupProperties - Resource properties.
	*WorkloadGroupProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for WorkloadGroup.
func (wg WorkloadGroup) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if wg.WorkloadGroupProperties != nil {
		objectMap["properties"] = wg.WorkloadGroupProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for WorkloadGroup struct.
func (wg *WorkloadGroup) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var workloadGroupProperties WorkloadGroupProperties
				err = json.Unmarshal(*v, &workloadGroupProperties)
				if err != nil {
					return err
				}
				wg.WorkloadGroupProperties = &workloadGroupProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				wg.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				wg.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				wg.Type = &typeVar
			}
		}
	}

	return nil
}

// WorkloadGroupListResult a list of workload groups.
type WorkloadGroupListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]WorkloadGroup `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// WorkloadGroupListResultIterator provides access to a complete listing of WorkloadGroup values.
type WorkloadGroupListResultIterator struct {
	i    int
	page WorkloadGroupListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *WorkloadGroupListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WorkloadGroupListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *WorkloadGroupListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter WorkloadGroupListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter WorkloadGroupListResultIterator) Response() WorkloadGroupListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter WorkloadGroupListResultIterator) Value() WorkloadGroup {
	if !iter.page.NotDone() {
		return WorkloadGroup{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the WorkloadGroupListResultIterator type.
func NewWorkloadGroupListResultIterator(page WorkloadGroupListResultPage) WorkloadGroupListResultIterator {
	return WorkloadGroupListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (wglr WorkloadGroupListResult) IsEmpty() bool {
	return wglr.Value == nil || len(*wglr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (wglr WorkloadGroupListResult) hasNextLink() bool {
	return wglr.NextLink != nil && len(*wglr.NextLink) != 0
}

// workloadGroupListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (wglr WorkloadGroupListResult) workloadGroupListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !wglr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(wglr.NextLink)))
}

// WorkloadGroupListResultPage contains a page of WorkloadGroup values.
type WorkloadGroupListResultPage struct {
	fn   func(context.Context, WorkloadGroupListResult) (WorkloadGroupListResult, error)
	wglr WorkloadGroupListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *WorkloadGroupListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WorkloadGroupListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.wglr)
		if err != nil {
			return err
		}
		page.wglr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *WorkloadGroupListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page WorkloadGroupListResultPage) NotDone() bool {
	return !page.wglr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page WorkloadGroupListResultPage) Response() WorkloadGroupListResult {
	return page.wglr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page WorkloadGroupListResultPage) Values() []WorkloadGroup {
	if page.wglr.IsEmpty() {
		return nil
	}
	return *page.wglr.Value
}

// Creates a new instance of the WorkloadGroupListResultPage type.
func NewWorkloadGroupListResultPage(getNextPage func(context.Context, WorkloadGroupListResult) (WorkloadGroupListResult, error)) WorkloadGroupListResultPage {
	return WorkloadGroupListResultPage{fn: getNextPage}
}

// WorkloadGroupProperties workload group definition. For more information look at
// sys.workload_management_workload_groups (DMV).
type WorkloadGroupProperties struct {
	// MinResourcePercent - The workload group minimum percentage resource.
	MinResourcePercent *int32 `json:"minResourcePercent,omitempty"`
	// MaxResourcePercent - The workload group cap percentage resource.
	MaxResourcePercent *int32 `json:"maxResourcePercent,omitempty"`
	// MinResourcePercentPerRequest - The workload group request minimum grant percentage.
	MinResourcePercentPerRequest *float64 `json:"minResourcePercentPerRequest,omitempty"`
	// MaxResourcePercentPerRequest - The workload group request maximum grant percentage.
	MaxResourcePercentPerRequest *float64 `json:"maxResourcePercentPerRequest,omitempty"`
	// Importance - The workload group importance level.
	Importance *string `json:"importance,omitempty"`
	// QueryExecutionTimeout - The workload group query execution timeout.
	QueryExecutionTimeout *int32 `json:"queryExecutionTimeout,omitempty"`
}

// WorkloadGroupsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type WorkloadGroupsCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *WorkloadGroupsCreateOrUpdateFuture) Result(client WorkloadGroupsClient) (wg WorkloadGroup, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.WorkloadGroupsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.WorkloadGroupsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if wg.Response.Response, err = future.GetResult(sender); err == nil && wg.Response.Response.StatusCode != http.StatusNoContent {
		wg, err = client.CreateOrUpdateResponder(wg.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.WorkloadGroupsCreateOrUpdateFuture", "Result", wg.Response.Response, "Failure responding to request")
		}
	}
	return
}

// WorkloadGroupsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type WorkloadGroupsDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *WorkloadGroupsDeleteFuture) Result(client WorkloadGroupsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.WorkloadGroupsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.WorkloadGroupsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}
