// Code generated by client-gen. DO NOT EDIT.

package v1

import (
	"context"
	"time"

	v1 "github.com/openshift/hive/apis/hive/v1"
	scheme "github.com/openshift/hive/pkg/client/clientset/versioned/scheme"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// ClusterPoolsGetter has a method to return a ClusterPoolInterface.
// A group's client should implement this interface.
type ClusterPoolsGetter interface {
	ClusterPools(namespace string) ClusterPoolInterface
}

// ClusterPoolInterface has methods to work with ClusterPool resources.
type ClusterPoolInterface interface {
	Create(ctx context.Context, clusterPool *v1.ClusterPool, opts metav1.CreateOptions) (*v1.ClusterPool, error)
	Update(ctx context.Context, clusterPool *v1.ClusterPool, opts metav1.UpdateOptions) (*v1.ClusterPool, error)
	UpdateStatus(ctx context.Context, clusterPool *v1.ClusterPool, opts metav1.UpdateOptions) (*v1.ClusterPool, error)
	Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error
	Get(ctx context.Context, name string, opts metav1.GetOptions) (*v1.ClusterPool, error)
	List(ctx context.Context, opts metav1.ListOptions) (*v1.ClusterPoolList, error)
	Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *v1.ClusterPool, err error)
	ClusterPoolExpansion
}

// clusterPools implements ClusterPoolInterface
type clusterPools struct {
	client rest.Interface
	ns     string
}

// newClusterPools returns a ClusterPools
func newClusterPools(c *HiveV1Client, namespace string) *clusterPools {
	return &clusterPools{
		client: c.RESTClient(),
		ns:     namespace,
	}
}

// Get takes name of the clusterPool, and returns the corresponding clusterPool object, and an error if there is any.
func (c *clusterPools) Get(ctx context.Context, name string, options metav1.GetOptions) (result *v1.ClusterPool, err error) {
	result = &v1.ClusterPool{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("clusterpools").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of ClusterPools that match those selectors.
func (c *clusterPools) List(ctx context.Context, opts metav1.ListOptions) (result *v1.ClusterPoolList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1.ClusterPoolList{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("clusterpools").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do(ctx).
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested clusterPools.
func (c *clusterPools) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Namespace(c.ns).
		Resource("clusterpools").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch(ctx)
}

// Create takes the representation of a clusterPool and creates it.  Returns the server's representation of the clusterPool, and an error, if there is any.
func (c *clusterPools) Create(ctx context.Context, clusterPool *v1.ClusterPool, opts metav1.CreateOptions) (result *v1.ClusterPool, err error) {
	result = &v1.ClusterPool{}
	err = c.client.Post().
		Namespace(c.ns).
		Resource("clusterpools").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(clusterPool).
		Do(ctx).
		Into(result)
	return
}

// Update takes the representation of a clusterPool and updates it. Returns the server's representation of the clusterPool, and an error, if there is any.
func (c *clusterPools) Update(ctx context.Context, clusterPool *v1.ClusterPool, opts metav1.UpdateOptions) (result *v1.ClusterPool, err error) {
	result = &v1.ClusterPool{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("clusterpools").
		Name(clusterPool.Name).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(clusterPool).
		Do(ctx).
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *clusterPools) UpdateStatus(ctx context.Context, clusterPool *v1.ClusterPool, opts metav1.UpdateOptions) (result *v1.ClusterPool, err error) {
	result = &v1.ClusterPool{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("clusterpools").
		Name(clusterPool.Name).
		SubResource("status").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(clusterPool).
		Do(ctx).
		Into(result)
	return
}

// Delete takes name of the clusterPool and deletes it. Returns an error if one occurs.
func (c *clusterPools) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("clusterpools").
		Name(name).
		Body(&opts).
		Do(ctx).
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *clusterPools) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	var timeout time.Duration
	if listOpts.TimeoutSeconds != nil {
		timeout = time.Duration(*listOpts.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Namespace(c.ns).
		Resource("clusterpools").
		VersionedParams(&listOpts, scheme.ParameterCodec).
		Timeout(timeout).
		Body(&opts).
		Do(ctx).
		Error()
}

// Patch applies the patch and returns the patched clusterPool.
func (c *clusterPools) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *v1.ClusterPool, err error) {
	result = &v1.ClusterPool{}
	err = c.client.Patch(pt).
		Namespace(c.ns).
		Resource("clusterpools").
		Name(name).
		SubResource(subresources...).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}
