---
layout: "docs"
page_title: "PKCS11 - Seals - Configuration"
sidebar_title: "HSM PKCS11 <sup>ENT</sup>"
sidebar_current: "docs-configuration-seal-pkcs11"
description: |-
  The PKCS11 seal configures Vault to use an HSM with PKCS11 as the seal
  wrapping mechanism.
---

# `pkcs11` Seal

The PKCS11 seal configures Vault to use an HSM with PKCS11 as the seal wrapping
mechanism. Vault Enterprise's HSM PKCS11 support is activated by one of the
following:

* The presence of a `seal "pkcs11"` block in Vault's configuration file
* The presence of the environment variable `VAULT_HSM_LIB` set to the library's
  path as well as `VAULT_HSM_TYPE` set to `pkcs11`. If enabling via environment
  variable, all other required values (i.e. `VAULT_HSM_SLOT`) must be also
  supplied.

**IMPORTANT**: Having Vault generate its own key is the easiest way to get up
and running, but for security, Vault marks the key as non-exportable. If your
HSM key backup strategy requires the key to be exportable, you should generate
the key yourself. The list of creation attributes that Vault uses to generate
the key are listed at the end of this document.

## Requirements

The following software packages are required for Vault Enterprise HSM:

- PKCS#11 compatible HSM integration library. Vault targets version 2.2 or
  higher of PKCS#11. Depending on any given HSM, some functions (such as key
  generation) may have to be performed manually.
- The [GNU libltdl
  library](https://www.gnu.org/software/libtool/manual/html_node/Using-libltdl.html)
  — ensure that it is installed for the correct architecture of your servers

## `pkcs11` Example

This example shows configuring HSM PKCS11 seal through the Vault configuration
file by providing all the required values:

```hcl
seal "pkcs11" {
  lib            = "/usr/vault/lib/libCryptoki2_64.so"
  slot           = "0"
  pin            = "AAAA-BBBB-CCCC-DDDD"
  key_label      = "vault-hsm-key"
  hmac_key_label = "vault-hsm-hmac-key"
}
```

## `pkcs11` Parameters

These parameters apply to the `seal` stanza in the Vault configuration file:

- `lib` `(string: <required>)`: The path to the PKCS#11 library shared object
  file. May also be specified by the `VAULT_HSM_LIB` environment variable.
  **Note:** Depending on your HSM, this may be either a binary or a dynamic
  library, and its use may require other libraries depending on which system the
  Vault binary is currently running on (e.g.: a Linux system may require other
  libraries to interpret Windows .dll files).

- `slot` `(string: <slot or token label required>)`: The slot number to use,
  specified as a string (e.g. `"0"`). May also be specified by the `VAULT_HSM_SLOT`
  environment variable.

- `token_label` `(string: <slot or token label required>)`: The slot token label to
  use. May also be specified by the `VAULT_HSM_TOKEN_LABEL` environment variable.

- `pin` `(string: <required>)`: The PIN for login. May also be specified by the
  `VAULT_HSM_PIN` environment variable. _If set via the environment variable,
  Vault will obfuscate the environment variable after reading it, and it will
  need to be re-set if Vault is restarted._

- `key_label` `(string: <required>)`: The label of the key to use. If the key
  does not exist and generation is enabled, this is the label that will be given
  to the generated key. May also be specified by the `VAULT_HSM_KEY_LABEL`
  environment variable.

- `default_key_label` `(string: "")`: This is the default key label for decryption
  operations.  Prior to 0.10.1, key labels were not stored with the ciphertext.
  Seal entries now track the label used in encryption operations.  The default value
  for this field is the `key_label`.  If `key_label` is rotated and this value is not
  set, decryption may fail. May also be specified by the `VAULT_HSM_DEFAULT_KEY_LABEL`
  environment variable.  This value is ignored in new installations.

- `hmac_key_label` `(string: <required>)`: The label of the key to use for
  HMACing. This needs to be a suitable type. If Vault tries to create this it
  will attempt to use CKK_GENERIC_SECRET_KEY. If the key does not exist and
  generation is enabled, this is the label that will be given to the generated
  key. May also be specified by the `VAULT_HSM_HMAC_KEY_LABEL` environment
  variable.

- `default_hmac_key_label` `(string: "")`: This is the default HMAC key label for signing
  operations.  Prior to 0.10.1, HMAC key labels were not stored with the signature.
  Seal entries now track the label used in signing operations.  The default value
  for this field is the `hmac_key_label`.  If `hmac_key_label` is rotated and this
  value is not set, signature verification may fail. May also be specified by the
  `VAULT_HSM_HMAC_DEFAULT_KEY_LABEL` environment variable.  This value is ignored in
  new installations.

- `mechanism` `(string: <best available>)`: The encryption/decryption mechanism to use,
  specified as a decimal or hexadecimal (prefixed by `0x`) string. May also be
  specified by the `VAULT_HSM_MECHANISM` environment variable.  
  Currently supported mechanisms (in order of precedence):

    - `0x1085` `CKM_AES_CBC_PAD` (HMAC mechanism required)
    - `0x1082` `CKM_AES_CBC` (HMAC mechanism required)
    - `0x1087` `CKM_AES_GCM`
    - `0x0009` `CKM_RSA_PKCS_OAEP`
    - `0x0001` `CKM_RSA_PKCS`

- `hmac_mechanism` `(string: "0x0251")`: The encryption/decryption mechanism to
  use, specified as a decimal or hexadecimal (prefixed by `0x`) string.
  Currently only `0x0251` (corresponding to `CKM_SHA256_HMAC` from the
  specification) is supported. May also be specified by the
  `VAULT_HSM_HMAC_MECHANISM` environment variable. This value is only required
  for specific mechanisms.

- `generate_key` `(string: "false")`: If no existing key with the label
  specified by `key_label` can be found at Vault initialization time, instructs
  Vault to generate a key. This is a boolean expressed as a string (e.g.
  `"true"`). May also be specified by the `VAULT_HSM_GENERATE_KEY` environment
  variable. Vault may not be able to successfully generate keys in all
  circumstances, such as if proprietary vendor extensions are required to
  create keys of a suitable type.

### Mechanism Specific Flags

- `rsa_encrypt_local` `(string: "false")`: For HSMs that do not support encryption
  for RSA keys, perform encryption locally.  Available for mechanisms
  `CKM_RSA_PKCS_OAEP` and `CKM_RSA_PKCS`.  May also be specified by the
  `VAULT_HSM_RSA_ENCRYPT_LOCAL` environment variable.

- `rsa_oaep_hash` `(string: "sha256")`: Specify the hash algorithm to use for RSA
  with OAEP padding.  Valid values are sha1, sha224, sha256, sha384, and sha512.
  Available for mechanism `CKM_RSA_PKCS_OAEP`.  May also be specified by the
  `VAULT_HSM_RSA_OAEP_HASH` environment variable.

~> **Note:** Although the configuration file allows you to pass in
`VAULT_HSM_PIN` as part of the seal's parameters, it is *strongly* recommended
to set this value via environment variables.

## `pkcs11` Environment Variables

Alternatively, the HSM seal can be activated by providing the following
environment variables:

```text
VAULT_HSM_LIB
VAULT_HSM_TYPE
VAULT_HSM_SLOT
VAULT_HSM_TOKEN_LABEL
VAULT_HSM_PIN
VAULT_HSM_KEY_LABEL
VAULT_HSM_DEFAULT_KEY_LABEL
VAULT_HSM_HMAC_KEY_LABEL
VAULT_HSM_HMAC_DEFAULT_KEY_LABEL
VAULT_HSM_MECHANISM
VAULT_HSM_HMAC_MECHANISM
VAULT_HSM_GENERATE_KEY
VAULT_HSM_RSA_ENCRYPT_LOCAL
VAULT_HSM_RSA_OAEP_HASH
```

## Vault Key Generation Attributes

If Vault generates the HSM key for you, the following is the list of attributes
it uses. These identifiers correspond to official PKCS#11 identifiers.

### AES Key

* `CKA_CLASS`: `CKO_SECRET_KEY` (It's a secret key)
* `CKA_KEY_TYPE`: `CKK_AES` (Key type is AES)
* `CKA_VALUE_LEN`: `32` (Key size is 256 bits)
* `CKA_LABEL`: Set to the key label set in Vault's configuration
* `CKA_ID`: Set to a random 32-bit unsigned integer
* `CKA_PRIVATE`: `true` (Key is private to this slot/token)
* `CKA_TOKEN`: `true` (Key persists to the slot/token rather than being for one
  session only)
* `CKA_SENSITIVE`: `true` (Key is a sensitive value)
* `CKA_ENCRYPT`: `true` (Key can be used for encryption)
* `CKA_DECRYPT`: `true` (Key can be used for decryption)
* `CKA_WRAP`: `true` (Key can be used for wrapping)
* `CKA_UNWRAP`: `true` (Key can be used for unwrapping)
* `CKA_EXTRACTABLE`: `false` (Key cannot be exported)

### RSA Key

_Public Key_

* `CKA_CLASS`: `CKO_PUBLIC_KEY` (It's a public key)
* `CKA_KEY_TYPE`: `CKK_RSA` (Key type is RSA)
* `CKA_LABEL`: Set to the key label set in Vault's configuration
* `CKA_ID`: Set to a random 32-bit unsigned integer
* `CKA_ENCRYPT`: `true` (Key can be used for encryption)
* `CKA_WRAP`: `true` (Key can be used for wrapping)
* `CKA_MODULUS_BITS`: `2048` (Key size is 2048 bits)
* `CKA_PUBLIC_EXPONENT`: `0x10001` (Public exponent of 65537)
* `CKA_TOKEN`: `true` (Key persists to the slot/token rather than being for one
  session only)

_Private Key_

* `CKA_CLASS`: `CKO_PRIVATE_KEY` (It's a private key)
* `CKA_KEY_TYPE`: `CKK_RSA` (Key type is RSA)
* `CKA_LABEL`: Set to the key label set in Vault's configuration
* `CKA_ID`: Set to a random 32-bit unsigned integer
* `CKA_DECRYPT`: `true` (Key can be used for decryption)
* `CKA_UNWRAP`: `true` (Key can be used for unwrapping)
* `CKA_TOKEN`: `true` (Key persists to the slot/token rather than being for one
  session only)
* `CKA_EXTRACTABLE`: `false` (Key cannot be exported)

### HMAC Key

* `CKA_CLASS`: `CKO_SECRET_KEY` (It's a secret key)
* `CKA_KEY_TYPE`: `CKK_GENERIC_SECRET_KEY` (Key type is a generic secret key)
* `CKA_VALUE_LEN`: `32` (Key size is 256 bits)
* `CKA_LABEL`: Set to the HMAC key label set in Vault's configuration
* `CKA_ID`: Set to a random 32-bit unsigned integer
* `CKA_PRIVATE`: `true` (Key is private to this slot/token)
* `CKA_TOKEN`: `true` (Key persists to the slot/token rather than being for one
  session only)
* `CKA_SENSITIVE`: `true` (Key is a sensitive value)
* `CKA_SIGN`: `true` (Key can be used for signing)
* `CKA_VERIFY`: `true` (Key can be used for verifying)
* `CKA_EXTRACTABLE`: `false` (Key cannot be exported)

## Key Rotation

This seal supports rotating keys by using different key labels to track key versions. To rotate
the key value, generate a new key in a different key label in the HSM and update Vault's
configuration with the new key label value.  Restart your vault instance to pick up the new key
label and all new encryption operations will use the updated key label. Old keys must not be disabled
or deleted and are used to decrypt older data.

**NOTE**: Prior to version 0.10.1, key information was not tracked with the ciphertext. If
rotation is desired for data that was seal wrapped prior to this version must also set
`default_key_label` and `hmac_default_key_label` to allow for decryption of older values.


## Learn

Refer to the [HSM Integration - Seal Wrap](https://learn.hashicorp.com/vault/operations/ops-seal-wrap)
guide for a step-by-step tutorial.
