---
layout: "docs"
page_title: "Azure - Storage Backends - Configuration"
sidebar_title: "Azure"
sidebar_current: "docs-configuration-storage-azure"
description: |-
  The Azure storage backend is used to persist Vault's data in an Azure Storage
  Container. The storage container must already exist and the provided account
  credentials must have read and write  permissions to the storage container.
---

# Azure Storage Backend

The Azure storage backend is used to persist Vault's data in an
[Azure Storage Container][azure-storage]. The storage container must already
exist and the provided account credentials must have read and write permissions
to the storage container. The storage account type must support block blobs. This
currently includes the general purpose "Storage V2" type with _Standard_ performance
(Premium will not work), as well as Premium "Block Blob Storage"
([limited region availability](https://azure.microsoft.com/en-us/global-infrastructure/services/?products=storage&regions=all)).


- **No High Availability** – the Azure storage backend does not support high
  availability.

- **Community Supported** – the Azure storage backend is supported by the
  community. While it has undergone review by HashiCorp employees, they may not
  be as knowledgeable about the technology. If you encounter problems with them,
  you may be referred to the original author.

```hcl
storage "azure" {
  accountName = "my-storage-account"
  accountKey  = "abcd1234"
  container   = "container-efgh5678"
  environment = "AzurePublicCloud"
}
```

The current implementation is limited to a maximum of 4 megabytes per blob.

## `azure` Parameters

- `accountName` `(string: <required>)` – Specifies the Azure Storage account
  name.

- `accountKey` `(string: <required>)` – Specifies the Azure Storage account key.

- `container` `(string: <required>)` – Specifies the Azure Storage Blob
  container name.

- `environment` `(string: "AzurePublicCloud")` - Specifies the cloud
   environment the storage account belongs to by way of the case-insensitive
   name defined in the [Azure Go SDK][azure-environment].

- `arm_endpoint` `(string: "")` - Specifies the cloud environment
  the storage account belongs to by way of the Azure Resource Manager endpoint
  URL.

- `max_parallel` `(string: "128")` – Specifies The maximum number of concurrent
  requests to Azure.

## `azure` Examples

This example shows configuring the Azure storage backend with a custom number of
maximum parallel connections.

```hcl
storage "azure" {
  accountName  = "my-storage-account"
  accountKey   = "abcd1234"
  container    = "container-efgh5678"
  max_parallel = 512
}
```

[azure-storage]: https://azure.microsoft.com/en-us/services/storage/
[azure-environment]: https://godoc.org/github.com/Azure/go-autorest/autorest/azure#pkg-variables
