---
layout: "docs"
page_title: "Upgrading to Vault 1.2.4 - Guides"
sidebar_title: "Upgrade to 1.2.4"
sidebar_current: "docs-upgrading-to-1.2.4"
description: |-
  This page contains the list of deprecations and important or breaking changes
  for Vault 1.2.4. Please read it carefully.
---

# Overview

This page contains the list of deprecations and important or breaking changes
for Vault 1.2.4 compared to 1.2.3. Please read it carefully.

## Detached Leases From Tokens in non-root Namespaces

In a non-root namespace, revocation of a token scoped to a non-root namespace
did not trigger the expected revocation of dynamic secret leases associated with
that token. As a result, dynamic secret leases in non-root namespaces may
outlive the token that created them. This vulnerability, CVE-2019-18616, affects
Vault Enterprise 0.11.0 and newer.

## Mount Filtering in Disaster Recovery Secondary Clusters

Disaster Recovery secondary clusters did not delete already-replicated data
after a mount filter has been created on an upstream Performance secondary
cluster. As a result, encrypted secrets may remain replicated on a Disaster
Recovery secondary cluster after application of a mount filter excluding those
secrets from replication. This vulnerability, CVE-2019-18617, affects Vault
Enterprise 0.8 and newer.

## Golang crypto/dsa CVE

Update version of Go to 1.12.12 to fix Go bug golang.org/issue/34960 which
corresponds to CVE-2019-17596.

## AWS Region Detection in Agent and CLI

If a custom sts_endpoint is configured, Vault Agent and the CLI should provide
the corresponding region via the region parameter (which already existed as a
CLI parameter, and has now been added to Agent). The automatic region detection
added to the CLI and Agent in 1.2 has been removed.

