package schema

// SamSchema defined a JSON Schema that can be used to validate CloudFormation/SAM templates
var SamSchema = `{
    "$id": "http://json-schema.org/draft-04/schema#",
    "additionalProperties": false,
    "definitions": {
        "AWS::AmazonMQ::Broker": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "AutoMinorVersionUpgrade": {
                            "type": "boolean"
                        },
                        "BrokerName": {
                            "type": "string"
                        },
                        "Configuration": {
                            "$ref": "#/definitions/AWS::AmazonMQ::Broker.ConfigurationId"
                        },
                        "DeploymentMode": {
                            "type": "string"
                        },
                        "EngineType": {
                            "type": "string"
                        },
                        "EngineVersion": {
                            "type": "string"
                        },
                        "HostInstanceType": {
                            "type": "string"
                        },
                        "Logs": {
                            "$ref": "#/definitions/AWS::AmazonMQ::Broker.LogList"
                        },
                        "MaintenanceWindowStartTime": {
                            "$ref": "#/definitions/AWS::AmazonMQ::Broker.MaintenanceWindow"
                        },
                        "PubliclyAccessible": {
                            "type": "boolean"
                        },
                        "SecurityGroups": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "SubnetIds": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/AWS::AmazonMQ::Broker.TagsEntry"
                            },
                            "type": "array"
                        },
                        "Users": {
                            "items": {
                                "$ref": "#/definitions/AWS::AmazonMQ::Broker.User"
                            },
                            "type": "array"
                        }
                    },
                    "required": [
                        "AutoMinorVersionUpgrade",
                        "BrokerName",
                        "DeploymentMode",
                        "EngineType",
                        "EngineVersion",
                        "HostInstanceType",
                        "PubliclyAccessible",
                        "Users"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::AmazonMQ::Broker"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::AmazonMQ::Broker.ConfigurationId": {
            "additionalProperties": false,
            "properties": {
                "Id": {
                    "type": "string"
                },
                "Revision": {
                    "type": "number"
                }
            },
            "required": [
                "Id",
                "Revision"
            ],
            "type": "object"
        },
        "AWS::AmazonMQ::Broker.LogList": {
            "additionalProperties": false,
            "properties": {
                "Audit": {
                    "type": "boolean"
                },
                "General": {
                    "type": "boolean"
                }
            },
            "type": "object"
        },
        "AWS::AmazonMQ::Broker.MaintenanceWindow": {
            "additionalProperties": false,
            "properties": {
                "DayOfWeek": {
                    "type": "string"
                },
                "TimeOfDay": {
                    "type": "string"
                },
                "TimeZone": {
                    "type": "string"
                }
            },
            "required": [
                "DayOfWeek",
                "TimeOfDay",
                "TimeZone"
            ],
            "type": "object"
        },
        "AWS::AmazonMQ::Broker.TagsEntry": {
            "additionalProperties": false,
            "properties": {
                "Key": {
                    "type": "string"
                },
                "Value": {
                    "type": "string"
                }
            },
            "required": [
                "Key",
                "Value"
            ],
            "type": "object"
        },
        "AWS::AmazonMQ::Broker.User": {
            "additionalProperties": false,
            "properties": {
                "ConsoleAccess": {
                    "type": "boolean"
                },
                "Groups": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "Password": {
                    "type": "string"
                },
                "Username": {
                    "type": "string"
                }
            },
            "required": [
                "Password",
                "Username"
            ],
            "type": "object"
        },
        "AWS::AmazonMQ::Configuration": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Data": {
                            "type": "string"
                        },
                        "Description": {
                            "type": "string"
                        },
                        "EngineType": {
                            "type": "string"
                        },
                        "EngineVersion": {
                            "type": "string"
                        },
                        "Name": {
                            "type": "string"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/AWS::AmazonMQ::Configuration.TagsEntry"
                            },
                            "type": "array"
                        }
                    },
                    "required": [
                        "Data",
                        "EngineType",
                        "EngineVersion",
                        "Name"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::AmazonMQ::Configuration"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::AmazonMQ::Configuration.TagsEntry": {
            "additionalProperties": false,
            "properties": {
                "Key": {
                    "type": "string"
                },
                "Value": {
                    "type": "string"
                }
            },
            "required": [
                "Key",
                "Value"
            ],
            "type": "object"
        },
        "AWS::AmazonMQ::ConfigurationAssociation": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Broker": {
                            "type": "string"
                        },
                        "Configuration": {
                            "$ref": "#/definitions/AWS::AmazonMQ::ConfigurationAssociation.ConfigurationId"
                        }
                    },
                    "required": [
                        "Broker",
                        "Configuration"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::AmazonMQ::ConfigurationAssociation"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::AmazonMQ::ConfigurationAssociation.ConfigurationId": {
            "additionalProperties": false,
            "properties": {
                "Id": {
                    "type": "string"
                },
                "Revision": {
                    "type": "number"
                }
            },
            "required": [
                "Id",
                "Revision"
            ],
            "type": "object"
        },
        "AWS::ApiGateway::Account": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "CloudWatchRoleArn": {
                            "type": "string"
                        }
                    },
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::ApiGateway::Account"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type"
            ],
            "type": "object"
        },
        "AWS::ApiGateway::ApiKey": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "CustomerId": {
                            "type": "string"
                        },
                        "Description": {
                            "type": "string"
                        },
                        "Enabled": {
                            "type": "boolean"
                        },
                        "GenerateDistinctId": {
                            "type": "boolean"
                        },
                        "Name": {
                            "type": "string"
                        },
                        "StageKeys": {
                            "items": {
                                "$ref": "#/definitions/AWS::ApiGateway::ApiKey.StageKey"
                            },
                            "type": "array"
                        },
                        "Value": {
                            "type": "string"
                        }
                    },
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::ApiGateway::ApiKey"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type"
            ],
            "type": "object"
        },
        "AWS::ApiGateway::ApiKey.StageKey": {
            "additionalProperties": false,
            "properties": {
                "RestApiId": {
                    "type": "string"
                },
                "StageName": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::ApiGateway::Authorizer": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "AuthType": {
                            "type": "string"
                        },
                        "AuthorizerCredentials": {
                            "type": "string"
                        },
                        "AuthorizerResultTtlInSeconds": {
                            "type": "number"
                        },
                        "AuthorizerUri": {
                            "type": "string"
                        },
                        "IdentitySource": {
                            "type": "string"
                        },
                        "IdentityValidationExpression": {
                            "type": "string"
                        },
                        "Name": {
                            "type": "string"
                        },
                        "ProviderARNs": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "RestApiId": {
                            "type": "string"
                        },
                        "Type": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "RestApiId",
                        "Type"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::ApiGateway::Authorizer"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::ApiGateway::BasePathMapping": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "BasePath": {
                            "type": "string"
                        },
                        "DomainName": {
                            "type": "string"
                        },
                        "RestApiId": {
                            "type": "string"
                        },
                        "Stage": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "DomainName"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::ApiGateway::BasePathMapping"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::ApiGateway::ClientCertificate": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Description": {
                            "type": "string"
                        }
                    },
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::ApiGateway::ClientCertificate"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type"
            ],
            "type": "object"
        },
        "AWS::ApiGateway::Deployment": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "DeploymentCanarySettings": {
                            "$ref": "#/definitions/AWS::ApiGateway::Deployment.DeploymentCanarySettings"
                        },
                        "Description": {
                            "type": "string"
                        },
                        "RestApiId": {
                            "type": "string"
                        },
                        "StageDescription": {
                            "$ref": "#/definitions/AWS::ApiGateway::Deployment.StageDescription"
                        },
                        "StageName": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "RestApiId"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::ApiGateway::Deployment"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::ApiGateway::Deployment.AccessLogSetting": {
            "additionalProperties": false,
            "properties": {
                "DestinationArn": {
                    "type": "string"
                },
                "Format": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::ApiGateway::Deployment.CanarySetting": {
            "additionalProperties": false,
            "properties": {
                "PercentTraffic": {
                    "type": "number"
                },
                "StageVariableOverrides": {
                    "additionalProperties": true,
                    "patternProperties": {
                        "^[a-zA-Z0-9]+$": {
                            "type": "string"
                        }
                    },
                    "type": "object"
                },
                "UseStageCache": {
                    "type": "boolean"
                }
            },
            "type": "object"
        },
        "AWS::ApiGateway::Deployment.DeploymentCanarySettings": {
            "additionalProperties": false,
            "properties": {
                "PercentTraffic": {
                    "type": "number"
                },
                "StageVariableOverrides": {
                    "additionalProperties": true,
                    "patternProperties": {
                        "^[a-zA-Z0-9]+$": {
                            "type": "string"
                        }
                    },
                    "type": "object"
                },
                "UseStageCache": {
                    "type": "boolean"
                }
            },
            "type": "object"
        },
        "AWS::ApiGateway::Deployment.MethodSetting": {
            "additionalProperties": false,
            "properties": {
                "CacheDataEncrypted": {
                    "type": "boolean"
                },
                "CacheTtlInSeconds": {
                    "type": "number"
                },
                "CachingEnabled": {
                    "type": "boolean"
                },
                "DataTraceEnabled": {
                    "type": "boolean"
                },
                "HttpMethod": {
                    "type": "string"
                },
                "LoggingLevel": {
                    "type": "string"
                },
                "MetricsEnabled": {
                    "type": "boolean"
                },
                "ResourcePath": {
                    "type": "string"
                },
                "ThrottlingBurstLimit": {
                    "type": "number"
                },
                "ThrottlingRateLimit": {
                    "type": "number"
                }
            },
            "type": "object"
        },
        "AWS::ApiGateway::Deployment.StageDescription": {
            "additionalProperties": false,
            "properties": {
                "AccessLogSetting": {
                    "$ref": "#/definitions/AWS::ApiGateway::Deployment.AccessLogSetting"
                },
                "CacheClusterEnabled": {
                    "type": "boolean"
                },
                "CacheClusterSize": {
                    "type": "string"
                },
                "CacheDataEncrypted": {
                    "type": "boolean"
                },
                "CacheTtlInSeconds": {
                    "type": "number"
                },
                "CachingEnabled": {
                    "type": "boolean"
                },
                "CanarySetting": {
                    "$ref": "#/definitions/AWS::ApiGateway::Deployment.CanarySetting"
                },
                "ClientCertificateId": {
                    "type": "string"
                },
                "DataTraceEnabled": {
                    "type": "boolean"
                },
                "Description": {
                    "type": "string"
                },
                "DocumentationVersion": {
                    "type": "string"
                },
                "LoggingLevel": {
                    "type": "string"
                },
                "MethodSettings": {
                    "items": {
                        "$ref": "#/definitions/AWS::ApiGateway::Deployment.MethodSetting"
                    },
                    "type": "array"
                },
                "MetricsEnabled": {
                    "type": "boolean"
                },
                "Tags": {
                    "items": {
                        "$ref": "#/definitions/Tag"
                    },
                    "type": "array"
                },
                "ThrottlingBurstLimit": {
                    "type": "number"
                },
                "ThrottlingRateLimit": {
                    "type": "number"
                },
                "TracingEnabled": {
                    "type": "boolean"
                },
                "Variables": {
                    "additionalProperties": true,
                    "patternProperties": {
                        "^[a-zA-Z0-9]+$": {
                            "type": "string"
                        }
                    },
                    "type": "object"
                }
            },
            "type": "object"
        },
        "AWS::ApiGateway::DocumentationPart": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Location": {
                            "$ref": "#/definitions/AWS::ApiGateway::DocumentationPart.Location"
                        },
                        "Properties": {
                            "type": "string"
                        },
                        "RestApiId": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "Location",
                        "Properties",
                        "RestApiId"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::ApiGateway::DocumentationPart"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::ApiGateway::DocumentationPart.Location": {
            "additionalProperties": false,
            "properties": {
                "Method": {
                    "type": "string"
                },
                "Name": {
                    "type": "string"
                },
                "Path": {
                    "type": "string"
                },
                "StatusCode": {
                    "type": "string"
                },
                "Type": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::ApiGateway::DocumentationVersion": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Description": {
                            "type": "string"
                        },
                        "DocumentationVersion": {
                            "type": "string"
                        },
                        "RestApiId": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "DocumentationVersion",
                        "RestApiId"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::ApiGateway::DocumentationVersion"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::ApiGateway::DomainName": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "CertificateArn": {
                            "type": "string"
                        },
                        "DomainName": {
                            "type": "string"
                        },
                        "EndpointConfiguration": {
                            "$ref": "#/definitions/AWS::ApiGateway::DomainName.EndpointConfiguration"
                        },
                        "RegionalCertificateArn": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "DomainName"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::ApiGateway::DomainName"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::ApiGateway::DomainName.EndpointConfiguration": {
            "additionalProperties": false,
            "properties": {
                "Types": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                }
            },
            "type": "object"
        },
        "AWS::ApiGateway::GatewayResponse": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "ResponseParameters": {
                            "additionalProperties": true,
                            "patternProperties": {
                                "^[a-zA-Z0-9]+$": {
                                    "type": "string"
                                }
                            },
                            "type": "object"
                        },
                        "ResponseTemplates": {
                            "additionalProperties": true,
                            "patternProperties": {
                                "^[a-zA-Z0-9]+$": {
                                    "type": "string"
                                }
                            },
                            "type": "object"
                        },
                        "ResponseType": {
                            "type": "string"
                        },
                        "RestApiId": {
                            "type": "string"
                        },
                        "StatusCode": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "ResponseType",
                        "RestApiId"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::ApiGateway::GatewayResponse"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::ApiGateway::Method": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "ApiKeyRequired": {
                            "type": "boolean"
                        },
                        "AuthorizationScopes": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "AuthorizationType": {
                            "type": "string"
                        },
                        "AuthorizerId": {
                            "type": "string"
                        },
                        "HttpMethod": {
                            "type": "string"
                        },
                        "Integration": {
                            "$ref": "#/definitions/AWS::ApiGateway::Method.Integration"
                        },
                        "MethodResponses": {
                            "items": {
                                "$ref": "#/definitions/AWS::ApiGateway::Method.MethodResponse"
                            },
                            "type": "array"
                        },
                        "OperationName": {
                            "type": "string"
                        },
                        "RequestModels": {
                            "additionalProperties": true,
                            "patternProperties": {
                                "^[a-zA-Z0-9]+$": {
                                    "type": "string"
                                }
                            },
                            "type": "object"
                        },
                        "RequestParameters": {
                            "additionalProperties": true,
                            "patternProperties": {
                                "^[a-zA-Z0-9]+$": {
                                    "type": "boolean"
                                }
                            },
                            "type": "object"
                        },
                        "RequestValidatorId": {
                            "type": "string"
                        },
                        "ResourceId": {
                            "type": "string"
                        },
                        "RestApiId": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "HttpMethod",
                        "ResourceId",
                        "RestApiId"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::ApiGateway::Method"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::ApiGateway::Method.Integration": {
            "additionalProperties": false,
            "properties": {
                "CacheKeyParameters": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "CacheNamespace": {
                    "type": "string"
                },
                "ConnectionId": {
                    "type": "string"
                },
                "ConnectionType": {
                    "type": "string"
                },
                "ContentHandling": {
                    "type": "string"
                },
                "Credentials": {
                    "type": "string"
                },
                "IntegrationHttpMethod": {
                    "type": "string"
                },
                "IntegrationResponses": {
                    "items": {
                        "$ref": "#/definitions/AWS::ApiGateway::Method.IntegrationResponse"
                    },
                    "type": "array"
                },
                "PassthroughBehavior": {
                    "type": "string"
                },
                "RequestParameters": {
                    "additionalProperties": true,
                    "patternProperties": {
                        "^[a-zA-Z0-9]+$": {
                            "type": "string"
                        }
                    },
                    "type": "object"
                },
                "RequestTemplates": {
                    "additionalProperties": true,
                    "patternProperties": {
                        "^[a-zA-Z0-9]+$": {
                            "type": "string"
                        }
                    },
                    "type": "object"
                },
                "TimeoutInMillis": {
                    "type": "number"
                },
                "Type": {
                    "type": "string"
                },
                "Uri": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::ApiGateway::Method.IntegrationResponse": {
            "additionalProperties": false,
            "properties": {
                "ContentHandling": {
                    "type": "string"
                },
                "ResponseParameters": {
                    "additionalProperties": true,
                    "patternProperties": {
                        "^[a-zA-Z0-9]+$": {
                            "type": "string"
                        }
                    },
                    "type": "object"
                },
                "ResponseTemplates": {
                    "additionalProperties": true,
                    "patternProperties": {
                        "^[a-zA-Z0-9]+$": {
                            "type": "string"
                        }
                    },
                    "type": "object"
                },
                "SelectionPattern": {
                    "type": "string"
                },
                "StatusCode": {
                    "type": "string"
                }
            },
            "required": [
                "StatusCode"
            ],
            "type": "object"
        },
        "AWS::ApiGateway::Method.MethodResponse": {
            "additionalProperties": false,
            "properties": {
                "ResponseModels": {
                    "additionalProperties": true,
                    "patternProperties": {
                        "^[a-zA-Z0-9]+$": {
                            "type": "string"
                        }
                    },
                    "type": "object"
                },
                "ResponseParameters": {
                    "additionalProperties": true,
                    "patternProperties": {
                        "^[a-zA-Z0-9]+$": {
                            "type": "boolean"
                        }
                    },
                    "type": "object"
                },
                "StatusCode": {
                    "type": "string"
                }
            },
            "required": [
                "StatusCode"
            ],
            "type": "object"
        },
        "AWS::ApiGateway::Model": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "ContentType": {
                            "type": "string"
                        },
                        "Description": {
                            "type": "string"
                        },
                        "Name": {
                            "type": "string"
                        },
                        "RestApiId": {
                            "type": "string"
                        },
                        "Schema": {
                            "type": "object"
                        }
                    },
                    "required": [
                        "RestApiId"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::ApiGateway::Model"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::ApiGateway::RequestValidator": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Name": {
                            "type": "string"
                        },
                        "RestApiId": {
                            "type": "string"
                        },
                        "ValidateRequestBody": {
                            "type": "boolean"
                        },
                        "ValidateRequestParameters": {
                            "type": "boolean"
                        }
                    },
                    "required": [
                        "RestApiId"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::ApiGateway::RequestValidator"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::ApiGateway::Resource": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "ParentId": {
                            "type": "string"
                        },
                        "PathPart": {
                            "type": "string"
                        },
                        "RestApiId": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "ParentId",
                        "PathPart",
                        "RestApiId"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::ApiGateway::Resource"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::ApiGateway::RestApi": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "ApiKeySourceType": {
                            "type": "string"
                        },
                        "BinaryMediaTypes": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "Body": {
                            "type": "object"
                        },
                        "BodyS3Location": {
                            "$ref": "#/definitions/AWS::ApiGateway::RestApi.S3Location"
                        },
                        "CloneFrom": {
                            "type": "string"
                        },
                        "Description": {
                            "type": "string"
                        },
                        "EndpointConfiguration": {
                            "$ref": "#/definitions/AWS::ApiGateway::RestApi.EndpointConfiguration"
                        },
                        "FailOnWarnings": {
                            "type": "boolean"
                        },
                        "MinimumCompressionSize": {
                            "type": "number"
                        },
                        "Name": {
                            "type": "string"
                        },
                        "Parameters": {
                            "additionalProperties": true,
                            "patternProperties": {
                                "^[a-zA-Z0-9]+$": {
                                    "type": "string"
                                }
                            },
                            "type": "object"
                        },
                        "Policy": {
                            "type": "object"
                        }
                    },
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::ApiGateway::RestApi"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type"
            ],
            "type": "object"
        },
        "AWS::ApiGateway::RestApi.EndpointConfiguration": {
            "additionalProperties": false,
            "properties": {
                "Types": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                }
            },
            "type": "object"
        },
        "AWS::ApiGateway::RestApi.S3Location": {
            "additionalProperties": false,
            "properties": {
                "Bucket": {
                    "type": "string"
                },
                "ETag": {
                    "type": "string"
                },
                "Key": {
                    "type": "string"
                },
                "Version": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::ApiGateway::Stage": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "AccessLogSetting": {
                            "$ref": "#/definitions/AWS::ApiGateway::Stage.AccessLogSetting"
                        },
                        "CacheClusterEnabled": {
                            "type": "boolean"
                        },
                        "CacheClusterSize": {
                            "type": "string"
                        },
                        "CanarySetting": {
                            "$ref": "#/definitions/AWS::ApiGateway::Stage.CanarySetting"
                        },
                        "ClientCertificateId": {
                            "type": "string"
                        },
                        "DeploymentId": {
                            "type": "string"
                        },
                        "Description": {
                            "type": "string"
                        },
                        "DocumentationVersion": {
                            "type": "string"
                        },
                        "MethodSettings": {
                            "items": {
                                "$ref": "#/definitions/AWS::ApiGateway::Stage.MethodSetting"
                            },
                            "type": "array"
                        },
                        "RestApiId": {
                            "type": "string"
                        },
                        "StageName": {
                            "type": "string"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        },
                        "TracingEnabled": {
                            "type": "boolean"
                        },
                        "Variables": {
                            "additionalProperties": true,
                            "patternProperties": {
                                "^[a-zA-Z0-9]+$": {
                                    "type": "string"
                                }
                            },
                            "type": "object"
                        }
                    },
                    "required": [
                        "RestApiId"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::ApiGateway::Stage"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::ApiGateway::Stage.AccessLogSetting": {
            "additionalProperties": false,
            "properties": {
                "DestinationArn": {
                    "type": "string"
                },
                "Format": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::ApiGateway::Stage.CanarySetting": {
            "additionalProperties": false,
            "properties": {
                "DeploymentId": {
                    "type": "string"
                },
                "PercentTraffic": {
                    "type": "number"
                },
                "StageVariableOverrides": {
                    "additionalProperties": true,
                    "patternProperties": {
                        "^[a-zA-Z0-9]+$": {
                            "type": "string"
                        }
                    },
                    "type": "object"
                },
                "UseStageCache": {
                    "type": "boolean"
                }
            },
            "type": "object"
        },
        "AWS::ApiGateway::Stage.MethodSetting": {
            "additionalProperties": false,
            "properties": {
                "CacheDataEncrypted": {
                    "type": "boolean"
                },
                "CacheTtlInSeconds": {
                    "type": "number"
                },
                "CachingEnabled": {
                    "type": "boolean"
                },
                "DataTraceEnabled": {
                    "type": "boolean"
                },
                "HttpMethod": {
                    "type": "string"
                },
                "LoggingLevel": {
                    "type": "string"
                },
                "MetricsEnabled": {
                    "type": "boolean"
                },
                "ResourcePath": {
                    "type": "string"
                },
                "ThrottlingBurstLimit": {
                    "type": "number"
                },
                "ThrottlingRateLimit": {
                    "type": "number"
                }
            },
            "type": "object"
        },
        "AWS::ApiGateway::UsagePlan": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "ApiStages": {
                            "items": {
                                "$ref": "#/definitions/AWS::ApiGateway::UsagePlan.ApiStage"
                            },
                            "type": "array"
                        },
                        "Description": {
                            "type": "string"
                        },
                        "Quota": {
                            "$ref": "#/definitions/AWS::ApiGateway::UsagePlan.QuotaSettings"
                        },
                        "Throttle": {
                            "$ref": "#/definitions/AWS::ApiGateway::UsagePlan.ThrottleSettings"
                        },
                        "UsagePlanName": {
                            "type": "string"
                        }
                    },
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::ApiGateway::UsagePlan"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type"
            ],
            "type": "object"
        },
        "AWS::ApiGateway::UsagePlan.ApiStage": {
            "additionalProperties": false,
            "properties": {
                "ApiId": {
                    "type": "string"
                },
                "Stage": {
                    "type": "string"
                },
                "Throttle": {
                    "additionalProperties": false,
                    "patternProperties": {
                        "^[a-zA-Z0-9]+$": {
                            "$ref": "#/definitions/AWS::ApiGateway::UsagePlan.ThrottleSettings"
                        }
                    },
                    "type": "object"
                }
            },
            "type": "object"
        },
        "AWS::ApiGateway::UsagePlan.QuotaSettings": {
            "additionalProperties": false,
            "properties": {
                "Limit": {
                    "type": "number"
                },
                "Offset": {
                    "type": "number"
                },
                "Period": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::ApiGateway::UsagePlan.ThrottleSettings": {
            "additionalProperties": false,
            "properties": {
                "BurstLimit": {
                    "type": "number"
                },
                "RateLimit": {
                    "type": "number"
                }
            },
            "type": "object"
        },
        "AWS::ApiGateway::UsagePlanKey": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "KeyId": {
                            "type": "string"
                        },
                        "KeyType": {
                            "type": "string"
                        },
                        "UsagePlanId": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "KeyId",
                        "KeyType",
                        "UsagePlanId"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::ApiGateway::UsagePlanKey"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::ApiGateway::VpcLink": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Description": {
                            "type": "string"
                        },
                        "Name": {
                            "type": "string"
                        },
                        "TargetArns": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        }
                    },
                    "required": [
                        "Name",
                        "TargetArns"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::ApiGateway::VpcLink"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::ApiGatewayV2::Api": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "ApiKeySelectionExpression": {
                            "type": "string"
                        },
                        "Description": {
                            "type": "string"
                        },
                        "DisableSchemaValidation": {
                            "type": "boolean"
                        },
                        "Name": {
                            "type": "string"
                        },
                        "ProtocolType": {
                            "type": "string"
                        },
                        "RouteSelectionExpression": {
                            "type": "string"
                        },
                        "Version": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "Name",
                        "ProtocolType",
                        "RouteSelectionExpression"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::ApiGatewayV2::Api"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::ApiGatewayV2::Authorizer": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "ApiId": {
                            "type": "string"
                        },
                        "AuthorizerCredentialsArn": {
                            "type": "string"
                        },
                        "AuthorizerResultTtlInSeconds": {
                            "type": "number"
                        },
                        "AuthorizerType": {
                            "type": "string"
                        },
                        "AuthorizerUri": {
                            "type": "string"
                        },
                        "IdentitySource": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "IdentityValidationExpression": {
                            "type": "string"
                        },
                        "Name": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "ApiId",
                        "AuthorizerType",
                        "AuthorizerUri",
                        "IdentitySource",
                        "Name"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::ApiGatewayV2::Authorizer"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::ApiGatewayV2::Deployment": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "ApiId": {
                            "type": "string"
                        },
                        "Description": {
                            "type": "string"
                        },
                        "StageName": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "ApiId"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::ApiGatewayV2::Deployment"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::ApiGatewayV2::Integration": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "ApiId": {
                            "type": "string"
                        },
                        "ConnectionType": {
                            "type": "string"
                        },
                        "ContentHandlingStrategy": {
                            "type": "string"
                        },
                        "CredentialsArn": {
                            "type": "string"
                        },
                        "Description": {
                            "type": "string"
                        },
                        "IntegrationMethod": {
                            "type": "string"
                        },
                        "IntegrationType": {
                            "type": "string"
                        },
                        "IntegrationUri": {
                            "type": "string"
                        },
                        "PassthroughBehavior": {
                            "type": "string"
                        },
                        "RequestParameters": {
                            "type": "object"
                        },
                        "RequestTemplates": {
                            "type": "object"
                        },
                        "TemplateSelectionExpression": {
                            "type": "string"
                        },
                        "TimeoutInMillis": {
                            "type": "number"
                        }
                    },
                    "required": [
                        "ApiId",
                        "IntegrationType"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::ApiGatewayV2::Integration"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::ApiGatewayV2::IntegrationResponse": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "ApiId": {
                            "type": "string"
                        },
                        "ContentHandlingStrategy": {
                            "type": "string"
                        },
                        "IntegrationId": {
                            "type": "string"
                        },
                        "IntegrationResponseKey": {
                            "type": "string"
                        },
                        "ResponseParameters": {
                            "type": "object"
                        },
                        "ResponseTemplates": {
                            "type": "object"
                        },
                        "TemplateSelectionExpression": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "ApiId",
                        "IntegrationId",
                        "IntegrationResponseKey"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::ApiGatewayV2::IntegrationResponse"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::ApiGatewayV2::Model": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "ApiId": {
                            "type": "string"
                        },
                        "ContentType": {
                            "type": "string"
                        },
                        "Description": {
                            "type": "string"
                        },
                        "Name": {
                            "type": "string"
                        },
                        "Schema": {
                            "type": "object"
                        }
                    },
                    "required": [
                        "ApiId",
                        "Name",
                        "Schema"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::ApiGatewayV2::Model"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::ApiGatewayV2::Route": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "ApiId": {
                            "type": "string"
                        },
                        "ApiKeyRequired": {
                            "type": "boolean"
                        },
                        "AuthorizationScopes": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "AuthorizationType": {
                            "type": "string"
                        },
                        "AuthorizerId": {
                            "type": "string"
                        },
                        "ModelSelectionExpression": {
                            "type": "string"
                        },
                        "OperationName": {
                            "type": "string"
                        },
                        "RequestModels": {
                            "type": "object"
                        },
                        "RequestParameters": {
                            "type": "object"
                        },
                        "RouteKey": {
                            "type": "string"
                        },
                        "RouteResponseSelectionExpression": {
                            "type": "string"
                        },
                        "Target": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "ApiId",
                        "RouteKey"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::ApiGatewayV2::Route"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::ApiGatewayV2::Route.ParameterConstraints": {
            "additionalProperties": false,
            "properties": {
                "Required": {
                    "type": "boolean"
                }
            },
            "required": [
                "Required"
            ],
            "type": "object"
        },
        "AWS::ApiGatewayV2::RouteResponse": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "ApiId": {
                            "type": "string"
                        },
                        "ModelSelectionExpression": {
                            "type": "string"
                        },
                        "ResponseModels": {
                            "type": "object"
                        },
                        "ResponseParameters": {
                            "type": "object"
                        },
                        "RouteId": {
                            "type": "string"
                        },
                        "RouteResponseKey": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "ApiId",
                        "RouteId",
                        "RouteResponseKey"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::ApiGatewayV2::RouteResponse"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::ApiGatewayV2::RouteResponse.ParameterConstraints": {
            "additionalProperties": false,
            "properties": {
                "Required": {
                    "type": "boolean"
                }
            },
            "required": [
                "Required"
            ],
            "type": "object"
        },
        "AWS::ApiGatewayV2::Stage": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "AccessLogSettings": {
                            "$ref": "#/definitions/AWS::ApiGatewayV2::Stage.AccessLogSettings"
                        },
                        "ApiId": {
                            "type": "string"
                        },
                        "ClientCertificateId": {
                            "type": "string"
                        },
                        "DefaultRouteSettings": {
                            "$ref": "#/definitions/AWS::ApiGatewayV2::Stage.RouteSettings"
                        },
                        "DeploymentId": {
                            "type": "string"
                        },
                        "Description": {
                            "type": "string"
                        },
                        "RouteSettings": {
                            "type": "object"
                        },
                        "StageName": {
                            "type": "string"
                        },
                        "StageVariables": {
                            "type": "object"
                        }
                    },
                    "required": [
                        "ApiId",
                        "DeploymentId",
                        "StageName"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::ApiGatewayV2::Stage"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::ApiGatewayV2::Stage.AccessLogSettings": {
            "additionalProperties": false,
            "properties": {
                "DestinationArn": {
                    "type": "string"
                },
                "Format": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::ApiGatewayV2::Stage.RouteSettings": {
            "additionalProperties": false,
            "properties": {
                "DataTraceEnabled": {
                    "type": "boolean"
                },
                "DetailedMetricsEnabled": {
                    "type": "boolean"
                },
                "LoggingLevel": {
                    "type": "string"
                },
                "ThrottlingBurstLimit": {
                    "type": "number"
                },
                "ThrottlingRateLimit": {
                    "type": "number"
                }
            },
            "type": "object"
        },
        "AWS::AppStream::DirectoryConfig": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "DirectoryName": {
                            "type": "string"
                        },
                        "OrganizationalUnitDistinguishedNames": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "ServiceAccountCredentials": {
                            "$ref": "#/definitions/AWS::AppStream::DirectoryConfig.ServiceAccountCredentials"
                        }
                    },
                    "required": [
                        "DirectoryName",
                        "OrganizationalUnitDistinguishedNames",
                        "ServiceAccountCredentials"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::AppStream::DirectoryConfig"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::AppStream::DirectoryConfig.ServiceAccountCredentials": {
            "additionalProperties": false,
            "properties": {
                "AccountName": {
                    "type": "string"
                },
                "AccountPassword": {
                    "type": "string"
                }
            },
            "required": [
                "AccountName",
                "AccountPassword"
            ],
            "type": "object"
        },
        "AWS::AppStream::Fleet": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "ComputeCapacity": {
                            "$ref": "#/definitions/AWS::AppStream::Fleet.ComputeCapacity"
                        },
                        "Description": {
                            "type": "string"
                        },
                        "DisconnectTimeoutInSeconds": {
                            "type": "number"
                        },
                        "DisplayName": {
                            "type": "string"
                        },
                        "DomainJoinInfo": {
                            "$ref": "#/definitions/AWS::AppStream::Fleet.DomainJoinInfo"
                        },
                        "EnableDefaultInternetAccess": {
                            "type": "boolean"
                        },
                        "FleetType": {
                            "type": "string"
                        },
                        "ImageArn": {
                            "type": "string"
                        },
                        "ImageName": {
                            "type": "string"
                        },
                        "InstanceType": {
                            "type": "string"
                        },
                        "MaxUserDurationInSeconds": {
                            "type": "number"
                        },
                        "Name": {
                            "type": "string"
                        },
                        "VpcConfig": {
                            "$ref": "#/definitions/AWS::AppStream::Fleet.VpcConfig"
                        }
                    },
                    "required": [
                        "ComputeCapacity",
                        "InstanceType"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::AppStream::Fleet"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::AppStream::Fleet.ComputeCapacity": {
            "additionalProperties": false,
            "properties": {
                "DesiredInstances": {
                    "type": "number"
                }
            },
            "required": [
                "DesiredInstances"
            ],
            "type": "object"
        },
        "AWS::AppStream::Fleet.DomainJoinInfo": {
            "additionalProperties": false,
            "properties": {
                "DirectoryName": {
                    "type": "string"
                },
                "OrganizationalUnitDistinguishedName": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::AppStream::Fleet.VpcConfig": {
            "additionalProperties": false,
            "properties": {
                "SecurityGroupIds": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "SubnetIds": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                }
            },
            "type": "object"
        },
        "AWS::AppStream::ImageBuilder": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "AppstreamAgentVersion": {
                            "type": "string"
                        },
                        "Description": {
                            "type": "string"
                        },
                        "DisplayName": {
                            "type": "string"
                        },
                        "DomainJoinInfo": {
                            "$ref": "#/definitions/AWS::AppStream::ImageBuilder.DomainJoinInfo"
                        },
                        "EnableDefaultInternetAccess": {
                            "type": "boolean"
                        },
                        "ImageArn": {
                            "type": "string"
                        },
                        "ImageName": {
                            "type": "string"
                        },
                        "InstanceType": {
                            "type": "string"
                        },
                        "Name": {
                            "type": "string"
                        },
                        "VpcConfig": {
                            "$ref": "#/definitions/AWS::AppStream::ImageBuilder.VpcConfig"
                        }
                    },
                    "required": [
                        "InstanceType"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::AppStream::ImageBuilder"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::AppStream::ImageBuilder.DomainJoinInfo": {
            "additionalProperties": false,
            "properties": {
                "DirectoryName": {
                    "type": "string"
                },
                "OrganizationalUnitDistinguishedName": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::AppStream::ImageBuilder.VpcConfig": {
            "additionalProperties": false,
            "properties": {
                "SecurityGroupIds": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "SubnetIds": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                }
            },
            "type": "object"
        },
        "AWS::AppStream::Stack": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "ApplicationSettings": {
                            "$ref": "#/definitions/AWS::AppStream::Stack.ApplicationSettings"
                        },
                        "AttributesToDelete": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "DeleteStorageConnectors": {
                            "type": "boolean"
                        },
                        "Description": {
                            "type": "string"
                        },
                        "DisplayName": {
                            "type": "string"
                        },
                        "FeedbackURL": {
                            "type": "string"
                        },
                        "Name": {
                            "type": "string"
                        },
                        "RedirectURL": {
                            "type": "string"
                        },
                        "StorageConnectors": {
                            "items": {
                                "$ref": "#/definitions/AWS::AppStream::Stack.StorageConnector"
                            },
                            "type": "array"
                        },
                        "UserSettings": {
                            "items": {
                                "$ref": "#/definitions/AWS::AppStream::Stack.UserSetting"
                            },
                            "type": "array"
                        }
                    },
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::AppStream::Stack"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type"
            ],
            "type": "object"
        },
        "AWS::AppStream::Stack.ApplicationSettings": {
            "additionalProperties": false,
            "properties": {
                "Enabled": {
                    "type": "boolean"
                },
                "SettingsGroup": {
                    "type": "string"
                }
            },
            "required": [
                "Enabled"
            ],
            "type": "object"
        },
        "AWS::AppStream::Stack.StorageConnector": {
            "additionalProperties": false,
            "properties": {
                "ConnectorType": {
                    "type": "string"
                },
                "Domains": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "ResourceIdentifier": {
                    "type": "string"
                }
            },
            "required": [
                "ConnectorType"
            ],
            "type": "object"
        },
        "AWS::AppStream::Stack.UserSetting": {
            "additionalProperties": false,
            "properties": {
                "Action": {
                    "type": "string"
                },
                "Permission": {
                    "type": "string"
                }
            },
            "required": [
                "Action",
                "Permission"
            ],
            "type": "object"
        },
        "AWS::AppStream::StackFleetAssociation": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "FleetName": {
                            "type": "string"
                        },
                        "StackName": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "FleetName",
                        "StackName"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::AppStream::StackFleetAssociation"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::AppStream::StackUserAssociation": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "AuthenticationType": {
                            "type": "string"
                        },
                        "SendEmailNotification": {
                            "type": "boolean"
                        },
                        "StackName": {
                            "type": "string"
                        },
                        "UserName": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "AuthenticationType",
                        "StackName",
                        "UserName"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::AppStream::StackUserAssociation"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::AppStream::User": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "AuthenticationType": {
                            "type": "string"
                        },
                        "FirstName": {
                            "type": "string"
                        },
                        "LastName": {
                            "type": "string"
                        },
                        "MessageAction": {
                            "type": "string"
                        },
                        "UserName": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "AuthenticationType",
                        "UserName"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::AppStream::User"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::AppSync::ApiKey": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "ApiId": {
                            "type": "string"
                        },
                        "Description": {
                            "type": "string"
                        },
                        "Expires": {
                            "type": "number"
                        }
                    },
                    "required": [
                        "ApiId"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::AppSync::ApiKey"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::AppSync::DataSource": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "ApiId": {
                            "type": "string"
                        },
                        "Description": {
                            "type": "string"
                        },
                        "DynamoDBConfig": {
                            "$ref": "#/definitions/AWS::AppSync::DataSource.DynamoDBConfig"
                        },
                        "ElasticsearchConfig": {
                            "$ref": "#/definitions/AWS::AppSync::DataSource.ElasticsearchConfig"
                        },
                        "HttpConfig": {
                            "$ref": "#/definitions/AWS::AppSync::DataSource.HttpConfig"
                        },
                        "LambdaConfig": {
                            "$ref": "#/definitions/AWS::AppSync::DataSource.LambdaConfig"
                        },
                        "Name": {
                            "type": "string"
                        },
                        "RelationalDatabaseConfig": {
                            "$ref": "#/definitions/AWS::AppSync::DataSource.RelationalDatabaseConfig"
                        },
                        "ServiceRoleArn": {
                            "type": "string"
                        },
                        "Type": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "ApiId",
                        "Name",
                        "Type"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::AppSync::DataSource"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::AppSync::DataSource.AuthorizationConfig": {
            "additionalProperties": false,
            "properties": {
                "AuthorizationType": {
                    "type": "string"
                },
                "AwsIamConfig": {
                    "$ref": "#/definitions/AWS::AppSync::DataSource.AwsIamConfig"
                }
            },
            "required": [
                "AuthorizationType"
            ],
            "type": "object"
        },
        "AWS::AppSync::DataSource.AwsIamConfig": {
            "additionalProperties": false,
            "properties": {
                "SigningRegion": {
                    "type": "string"
                },
                "SigningServiceName": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::AppSync::DataSource.DynamoDBConfig": {
            "additionalProperties": false,
            "properties": {
                "AwsRegion": {
                    "type": "string"
                },
                "TableName": {
                    "type": "string"
                },
                "UseCallerCredentials": {
                    "type": "boolean"
                }
            },
            "required": [
                "AwsRegion",
                "TableName"
            ],
            "type": "object"
        },
        "AWS::AppSync::DataSource.ElasticsearchConfig": {
            "additionalProperties": false,
            "properties": {
                "AwsRegion": {
                    "type": "string"
                },
                "Endpoint": {
                    "type": "string"
                }
            },
            "required": [
                "AwsRegion",
                "Endpoint"
            ],
            "type": "object"
        },
        "AWS::AppSync::DataSource.HttpConfig": {
            "additionalProperties": false,
            "properties": {
                "AuthorizationConfig": {
                    "$ref": "#/definitions/AWS::AppSync::DataSource.AuthorizationConfig"
                },
                "Endpoint": {
                    "type": "string"
                }
            },
            "required": [
                "Endpoint"
            ],
            "type": "object"
        },
        "AWS::AppSync::DataSource.LambdaConfig": {
            "additionalProperties": false,
            "properties": {
                "LambdaFunctionArn": {
                    "type": "string"
                }
            },
            "required": [
                "LambdaFunctionArn"
            ],
            "type": "object"
        },
        "AWS::AppSync::DataSource.RdsHttpEndpointConfig": {
            "additionalProperties": false,
            "properties": {
                "AwsRegion": {
                    "type": "string"
                },
                "AwsSecretStoreArn": {
                    "type": "string"
                },
                "DatabaseName": {
                    "type": "string"
                },
                "DbClusterIdentifier": {
                    "type": "string"
                },
                "Schema": {
                    "type": "string"
                }
            },
            "required": [
                "AwsRegion",
                "AwsSecretStoreArn",
                "DbClusterIdentifier"
            ],
            "type": "object"
        },
        "AWS::AppSync::DataSource.RelationalDatabaseConfig": {
            "additionalProperties": false,
            "properties": {
                "RdsHttpEndpointConfig": {
                    "$ref": "#/definitions/AWS::AppSync::DataSource.RdsHttpEndpointConfig"
                },
                "RelationalDatabaseSourceType": {
                    "type": "string"
                }
            },
            "required": [
                "RelationalDatabaseSourceType"
            ],
            "type": "object"
        },
        "AWS::AppSync::FunctionConfiguration": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "ApiId": {
                            "type": "string"
                        },
                        "DataSourceName": {
                            "type": "string"
                        },
                        "Description": {
                            "type": "string"
                        },
                        "FunctionVersion": {
                            "type": "string"
                        },
                        "Name": {
                            "type": "string"
                        },
                        "RequestMappingTemplate": {
                            "type": "string"
                        },
                        "RequestMappingTemplateS3Location": {
                            "type": "string"
                        },
                        "ResponseMappingTemplate": {
                            "type": "string"
                        },
                        "ResponseMappingTemplateS3Location": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "ApiId"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::AppSync::FunctionConfiguration"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::AppSync::GraphQLApi": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "AuthenticationType": {
                            "type": "string"
                        },
                        "LogConfig": {
                            "$ref": "#/definitions/AWS::AppSync::GraphQLApi.LogConfig"
                        },
                        "Name": {
                            "type": "string"
                        },
                        "OpenIDConnectConfig": {
                            "$ref": "#/definitions/AWS::AppSync::GraphQLApi.OpenIDConnectConfig"
                        },
                        "UserPoolConfig": {
                            "$ref": "#/definitions/AWS::AppSync::GraphQLApi.UserPoolConfig"
                        }
                    },
                    "required": [
                        "AuthenticationType",
                        "Name"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::AppSync::GraphQLApi"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::AppSync::GraphQLApi.LogConfig": {
            "additionalProperties": false,
            "properties": {
                "CloudWatchLogsRoleArn": {
                    "type": "string"
                },
                "FieldLogLevel": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::AppSync::GraphQLApi.OpenIDConnectConfig": {
            "additionalProperties": false,
            "properties": {
                "AuthTTL": {
                    "type": "number"
                },
                "ClientId": {
                    "type": "string"
                },
                "IatTTL": {
                    "type": "number"
                },
                "Issuer": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::AppSync::GraphQLApi.UserPoolConfig": {
            "additionalProperties": false,
            "properties": {
                "AppIdClientRegex": {
                    "type": "string"
                },
                "AwsRegion": {
                    "type": "string"
                },
                "DefaultAction": {
                    "type": "string"
                },
                "UserPoolId": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::AppSync::GraphQLSchema": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "ApiId": {
                            "type": "string"
                        },
                        "Definition": {
                            "type": "string"
                        },
                        "DefinitionS3Location": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "ApiId"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::AppSync::GraphQLSchema"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::AppSync::Resolver": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "ApiId": {
                            "type": "string"
                        },
                        "DataSourceName": {
                            "type": "string"
                        },
                        "FieldName": {
                            "type": "string"
                        },
                        "Kind": {
                            "type": "string"
                        },
                        "PipelineConfig": {
                            "$ref": "#/definitions/AWS::AppSync::Resolver.PipelineConfig"
                        },
                        "RequestMappingTemplate": {
                            "type": "string"
                        },
                        "RequestMappingTemplateS3Location": {
                            "type": "string"
                        },
                        "ResponseMappingTemplate": {
                            "type": "string"
                        },
                        "ResponseMappingTemplateS3Location": {
                            "type": "string"
                        },
                        "TypeName": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "ApiId",
                        "FieldName",
                        "TypeName"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::AppSync::Resolver"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::AppSync::Resolver.PipelineConfig": {
            "additionalProperties": false,
            "properties": {
                "Functions": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                }
            },
            "type": "object"
        },
        "AWS::ApplicationAutoScaling::ScalableTarget": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "MaxCapacity": {
                            "type": "number"
                        },
                        "MinCapacity": {
                            "type": "number"
                        },
                        "ResourceId": {
                            "type": "string"
                        },
                        "RoleARN": {
                            "type": "string"
                        },
                        "ScalableDimension": {
                            "type": "string"
                        },
                        "ScheduledActions": {
                            "items": {
                                "$ref": "#/definitions/AWS::ApplicationAutoScaling::ScalableTarget.ScheduledAction"
                            },
                            "type": "array"
                        },
                        "ServiceNamespace": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "MaxCapacity",
                        "MinCapacity",
                        "ResourceId",
                        "RoleARN",
                        "ScalableDimension",
                        "ServiceNamespace"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::ApplicationAutoScaling::ScalableTarget"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::ApplicationAutoScaling::ScalableTarget.ScalableTargetAction": {
            "additionalProperties": false,
            "properties": {
                "MaxCapacity": {
                    "type": "number"
                },
                "MinCapacity": {
                    "type": "number"
                }
            },
            "type": "object"
        },
        "AWS::ApplicationAutoScaling::ScalableTarget.ScheduledAction": {
            "additionalProperties": false,
            "properties": {
                "EndTime": {
                    "type": "string"
                },
                "ScalableTargetAction": {
                    "$ref": "#/definitions/AWS::ApplicationAutoScaling::ScalableTarget.ScalableTargetAction"
                },
                "Schedule": {
                    "type": "string"
                },
                "ScheduledActionName": {
                    "type": "string"
                },
                "StartTime": {
                    "type": "string"
                }
            },
            "required": [
                "Schedule",
                "ScheduledActionName"
            ],
            "type": "object"
        },
        "AWS::ApplicationAutoScaling::ScalingPolicy": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "PolicyName": {
                            "type": "string"
                        },
                        "PolicyType": {
                            "type": "string"
                        },
                        "ResourceId": {
                            "type": "string"
                        },
                        "ScalableDimension": {
                            "type": "string"
                        },
                        "ScalingTargetId": {
                            "type": "string"
                        },
                        "ServiceNamespace": {
                            "type": "string"
                        },
                        "StepScalingPolicyConfiguration": {
                            "$ref": "#/definitions/AWS::ApplicationAutoScaling::ScalingPolicy.StepScalingPolicyConfiguration"
                        },
                        "TargetTrackingScalingPolicyConfiguration": {
                            "$ref": "#/definitions/AWS::ApplicationAutoScaling::ScalingPolicy.TargetTrackingScalingPolicyConfiguration"
                        }
                    },
                    "required": [
                        "PolicyName",
                        "PolicyType"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::ApplicationAutoScaling::ScalingPolicy"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::ApplicationAutoScaling::ScalingPolicy.CustomizedMetricSpecification": {
            "additionalProperties": false,
            "properties": {
                "Dimensions": {
                    "items": {
                        "$ref": "#/definitions/AWS::ApplicationAutoScaling::ScalingPolicy.MetricDimension"
                    },
                    "type": "array"
                },
                "MetricName": {
                    "type": "string"
                },
                "Namespace": {
                    "type": "string"
                },
                "Statistic": {
                    "type": "string"
                },
                "Unit": {
                    "type": "string"
                }
            },
            "required": [
                "MetricName",
                "Namespace",
                "Statistic"
            ],
            "type": "object"
        },
        "AWS::ApplicationAutoScaling::ScalingPolicy.MetricDimension": {
            "additionalProperties": false,
            "properties": {
                "Name": {
                    "type": "string"
                },
                "Value": {
                    "type": "string"
                }
            },
            "required": [
                "Name",
                "Value"
            ],
            "type": "object"
        },
        "AWS::ApplicationAutoScaling::ScalingPolicy.PredefinedMetricSpecification": {
            "additionalProperties": false,
            "properties": {
                "PredefinedMetricType": {
                    "type": "string"
                },
                "ResourceLabel": {
                    "type": "string"
                }
            },
            "required": [
                "PredefinedMetricType"
            ],
            "type": "object"
        },
        "AWS::ApplicationAutoScaling::ScalingPolicy.StepAdjustment": {
            "additionalProperties": false,
            "properties": {
                "MetricIntervalLowerBound": {
                    "type": "number"
                },
                "MetricIntervalUpperBound": {
                    "type": "number"
                },
                "ScalingAdjustment": {
                    "type": "number"
                }
            },
            "required": [
                "ScalingAdjustment"
            ],
            "type": "object"
        },
        "AWS::ApplicationAutoScaling::ScalingPolicy.StepScalingPolicyConfiguration": {
            "additionalProperties": false,
            "properties": {
                "AdjustmentType": {
                    "type": "string"
                },
                "Cooldown": {
                    "type": "number"
                },
                "MetricAggregationType": {
                    "type": "string"
                },
                "MinAdjustmentMagnitude": {
                    "type": "number"
                },
                "StepAdjustments": {
                    "items": {
                        "$ref": "#/definitions/AWS::ApplicationAutoScaling::ScalingPolicy.StepAdjustment"
                    },
                    "type": "array"
                }
            },
            "type": "object"
        },
        "AWS::ApplicationAutoScaling::ScalingPolicy.TargetTrackingScalingPolicyConfiguration": {
            "additionalProperties": false,
            "properties": {
                "CustomizedMetricSpecification": {
                    "$ref": "#/definitions/AWS::ApplicationAutoScaling::ScalingPolicy.CustomizedMetricSpecification"
                },
                "DisableScaleIn": {
                    "type": "boolean"
                },
                "PredefinedMetricSpecification": {
                    "$ref": "#/definitions/AWS::ApplicationAutoScaling::ScalingPolicy.PredefinedMetricSpecification"
                },
                "ScaleInCooldown": {
                    "type": "number"
                },
                "ScaleOutCooldown": {
                    "type": "number"
                },
                "TargetValue": {
                    "type": "number"
                }
            },
            "required": [
                "TargetValue"
            ],
            "type": "object"
        },
        "AWS::Athena::NamedQuery": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Database": {
                            "type": "string"
                        },
                        "Description": {
                            "type": "string"
                        },
                        "Name": {
                            "type": "string"
                        },
                        "QueryString": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "Database",
                        "QueryString"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::Athena::NamedQuery"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::AutoScaling::AutoScalingGroup": {
            "additionalProperties": false,
            "properties": {
                "CreationPolicy": {
                    "type": "object"
                },
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "AutoScalingGroupName": {
                            "type": "string"
                        },
                        "AvailabilityZones": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "Cooldown": {
                            "type": "string"
                        },
                        "DesiredCapacity": {
                            "type": "string"
                        },
                        "HealthCheckGracePeriod": {
                            "type": "number"
                        },
                        "HealthCheckType": {
                            "type": "string"
                        },
                        "InstanceId": {
                            "type": "string"
                        },
                        "LaunchConfigurationName": {
                            "type": "string"
                        },
                        "LaunchTemplate": {
                            "$ref": "#/definitions/AWS::AutoScaling::AutoScalingGroup.LaunchTemplateSpecification"
                        },
                        "LifecycleHookSpecificationList": {
                            "items": {
                                "$ref": "#/definitions/AWS::AutoScaling::AutoScalingGroup.LifecycleHookSpecification"
                            },
                            "type": "array"
                        },
                        "LoadBalancerNames": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "MaxSize": {
                            "type": "string"
                        },
                        "MetricsCollection": {
                            "items": {
                                "$ref": "#/definitions/AWS::AutoScaling::AutoScalingGroup.MetricsCollection"
                            },
                            "type": "array"
                        },
                        "MinSize": {
                            "type": "string"
                        },
                        "MixedInstancesPolicy": {
                            "$ref": "#/definitions/AWS::AutoScaling::AutoScalingGroup.MixedInstancesPolicy"
                        },
                        "NotificationConfigurations": {
                            "items": {
                                "$ref": "#/definitions/AWS::AutoScaling::AutoScalingGroup.NotificationConfiguration"
                            },
                            "type": "array"
                        },
                        "PlacementGroup": {
                            "type": "string"
                        },
                        "ServiceLinkedRoleARN": {
                            "type": "string"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/AWS::AutoScaling::AutoScalingGroup.TagProperty"
                            },
                            "type": "array"
                        },
                        "TargetGroupARNs": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "TerminationPolicies": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "VPCZoneIdentifier": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        }
                    },
                    "required": [
                        "MaxSize",
                        "MinSize"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::AutoScaling::AutoScalingGroup"
                    ],
                    "type": "string"
                },
                "UpdatePolicy": {
                    "type": "object"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::AutoScaling::AutoScalingGroup.InstancesDistribution": {
            "additionalProperties": false,
            "properties": {
                "OnDemandAllocationStrategy": {
                    "type": "string"
                },
                "OnDemandBaseCapacity": {
                    "type": "number"
                },
                "OnDemandPercentageAboveBaseCapacity": {
                    "type": "number"
                },
                "SpotAllocationStrategy": {
                    "type": "string"
                },
                "SpotInstancePools": {
                    "type": "number"
                },
                "SpotMaxPrice": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::AutoScaling::AutoScalingGroup.LaunchTemplate": {
            "additionalProperties": false,
            "properties": {
                "LaunchTemplateSpecification": {
                    "$ref": "#/definitions/AWS::AutoScaling::AutoScalingGroup.LaunchTemplateSpecification"
                },
                "Overrides": {
                    "items": {
                        "$ref": "#/definitions/AWS::AutoScaling::AutoScalingGroup.LaunchTemplateOverrides"
                    },
                    "type": "array"
                }
            },
            "required": [
                "LaunchTemplateSpecification"
            ],
            "type": "object"
        },
        "AWS::AutoScaling::AutoScalingGroup.LaunchTemplateOverrides": {
            "additionalProperties": false,
            "properties": {
                "InstanceType": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::AutoScaling::AutoScalingGroup.LaunchTemplateSpecification": {
            "additionalProperties": false,
            "properties": {
                "LaunchTemplateId": {
                    "type": "string"
                },
                "LaunchTemplateName": {
                    "type": "string"
                },
                "Version": {
                    "type": "string"
                }
            },
            "required": [
                "Version"
            ],
            "type": "object"
        },
        "AWS::AutoScaling::AutoScalingGroup.LifecycleHookSpecification": {
            "additionalProperties": false,
            "properties": {
                "DefaultResult": {
                    "type": "string"
                },
                "HeartbeatTimeout": {
                    "type": "number"
                },
                "LifecycleHookName": {
                    "type": "string"
                },
                "LifecycleTransition": {
                    "type": "string"
                },
                "NotificationMetadata": {
                    "type": "string"
                },
                "NotificationTargetARN": {
                    "type": "string"
                },
                "RoleARN": {
                    "type": "string"
                }
            },
            "required": [
                "LifecycleHookName",
                "LifecycleTransition"
            ],
            "type": "object"
        },
        "AWS::AutoScaling::AutoScalingGroup.MetricsCollection": {
            "additionalProperties": false,
            "properties": {
                "Granularity": {
                    "type": "string"
                },
                "Metrics": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                }
            },
            "required": [
                "Granularity"
            ],
            "type": "object"
        },
        "AWS::AutoScaling::AutoScalingGroup.MixedInstancesPolicy": {
            "additionalProperties": false,
            "properties": {
                "InstancesDistribution": {
                    "$ref": "#/definitions/AWS::AutoScaling::AutoScalingGroup.InstancesDistribution"
                },
                "LaunchTemplate": {
                    "$ref": "#/definitions/AWS::AutoScaling::AutoScalingGroup.LaunchTemplate"
                }
            },
            "required": [
                "LaunchTemplate"
            ],
            "type": "object"
        },
        "AWS::AutoScaling::AutoScalingGroup.NotificationConfiguration": {
            "additionalProperties": false,
            "properties": {
                "NotificationTypes": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "TopicARN": {
                    "type": "string"
                }
            },
            "required": [
                "TopicARN"
            ],
            "type": "object"
        },
        "AWS::AutoScaling::AutoScalingGroup.TagProperty": {
            "additionalProperties": false,
            "properties": {
                "Key": {
                    "type": "string"
                },
                "PropagateAtLaunch": {
                    "type": "boolean"
                },
                "Value": {
                    "type": "string"
                }
            },
            "required": [
                "Key",
                "PropagateAtLaunch",
                "Value"
            ],
            "type": "object"
        },
        "AWS::AutoScaling::LaunchConfiguration": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "AssociatePublicIpAddress": {
                            "type": "boolean"
                        },
                        "BlockDeviceMappings": {
                            "items": {
                                "$ref": "#/definitions/AWS::AutoScaling::LaunchConfiguration.BlockDeviceMapping"
                            },
                            "type": "array"
                        },
                        "ClassicLinkVPCId": {
                            "type": "string"
                        },
                        "ClassicLinkVPCSecurityGroups": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "EbsOptimized": {
                            "type": "boolean"
                        },
                        "IamInstanceProfile": {
                            "type": "string"
                        },
                        "ImageId": {
                            "type": "string"
                        },
                        "InstanceId": {
                            "type": "string"
                        },
                        "InstanceMonitoring": {
                            "type": "boolean"
                        },
                        "InstanceType": {
                            "type": "string"
                        },
                        "KernelId": {
                            "type": "string"
                        },
                        "KeyName": {
                            "type": "string"
                        },
                        "LaunchConfigurationName": {
                            "type": "string"
                        },
                        "PlacementTenancy": {
                            "type": "string"
                        },
                        "RamDiskId": {
                            "type": "string"
                        },
                        "SecurityGroups": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "SpotPrice": {
                            "type": "string"
                        },
                        "UserData": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "ImageId",
                        "InstanceType"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::AutoScaling::LaunchConfiguration"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::AutoScaling::LaunchConfiguration.BlockDevice": {
            "additionalProperties": false,
            "properties": {
                "DeleteOnTermination": {
                    "type": "boolean"
                },
                "Encrypted": {
                    "type": "boolean"
                },
                "Iops": {
                    "type": "number"
                },
                "SnapshotId": {
                    "type": "string"
                },
                "VolumeSize": {
                    "type": "number"
                },
                "VolumeType": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::AutoScaling::LaunchConfiguration.BlockDeviceMapping": {
            "additionalProperties": false,
            "properties": {
                "DeviceName": {
                    "type": "string"
                },
                "Ebs": {
                    "$ref": "#/definitions/AWS::AutoScaling::LaunchConfiguration.BlockDevice"
                },
                "NoDevice": {
                    "type": "boolean"
                },
                "VirtualName": {
                    "type": "string"
                }
            },
            "required": [
                "DeviceName"
            ],
            "type": "object"
        },
        "AWS::AutoScaling::LifecycleHook": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "AutoScalingGroupName": {
                            "type": "string"
                        },
                        "DefaultResult": {
                            "type": "string"
                        },
                        "HeartbeatTimeout": {
                            "type": "number"
                        },
                        "LifecycleHookName": {
                            "type": "string"
                        },
                        "LifecycleTransition": {
                            "type": "string"
                        },
                        "NotificationMetadata": {
                            "type": "string"
                        },
                        "NotificationTargetARN": {
                            "type": "string"
                        },
                        "RoleARN": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "AutoScalingGroupName",
                        "LifecycleTransition"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::AutoScaling::LifecycleHook"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::AutoScaling::ScalingPolicy": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "AdjustmentType": {
                            "type": "string"
                        },
                        "AutoScalingGroupName": {
                            "type": "string"
                        },
                        "Cooldown": {
                            "type": "string"
                        },
                        "EstimatedInstanceWarmup": {
                            "type": "number"
                        },
                        "MetricAggregationType": {
                            "type": "string"
                        },
                        "MinAdjustmentMagnitude": {
                            "type": "number"
                        },
                        "PolicyType": {
                            "type": "string"
                        },
                        "ScalingAdjustment": {
                            "type": "number"
                        },
                        "StepAdjustments": {
                            "items": {
                                "$ref": "#/definitions/AWS::AutoScaling::ScalingPolicy.StepAdjustment"
                            },
                            "type": "array"
                        },
                        "TargetTrackingConfiguration": {
                            "$ref": "#/definitions/AWS::AutoScaling::ScalingPolicy.TargetTrackingConfiguration"
                        }
                    },
                    "required": [
                        "AutoScalingGroupName"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::AutoScaling::ScalingPolicy"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::AutoScaling::ScalingPolicy.CustomizedMetricSpecification": {
            "additionalProperties": false,
            "properties": {
                "Dimensions": {
                    "items": {
                        "$ref": "#/definitions/AWS::AutoScaling::ScalingPolicy.MetricDimension"
                    },
                    "type": "array"
                },
                "MetricName": {
                    "type": "string"
                },
                "Namespace": {
                    "type": "string"
                },
                "Statistic": {
                    "type": "string"
                },
                "Unit": {
                    "type": "string"
                }
            },
            "required": [
                "MetricName",
                "Namespace",
                "Statistic"
            ],
            "type": "object"
        },
        "AWS::AutoScaling::ScalingPolicy.MetricDimension": {
            "additionalProperties": false,
            "properties": {
                "Name": {
                    "type": "string"
                },
                "Value": {
                    "type": "string"
                }
            },
            "required": [
                "Name",
                "Value"
            ],
            "type": "object"
        },
        "AWS::AutoScaling::ScalingPolicy.PredefinedMetricSpecification": {
            "additionalProperties": false,
            "properties": {
                "PredefinedMetricType": {
                    "type": "string"
                },
                "ResourceLabel": {
                    "type": "string"
                }
            },
            "required": [
                "PredefinedMetricType"
            ],
            "type": "object"
        },
        "AWS::AutoScaling::ScalingPolicy.StepAdjustment": {
            "additionalProperties": false,
            "properties": {
                "MetricIntervalLowerBound": {
                    "type": "number"
                },
                "MetricIntervalUpperBound": {
                    "type": "number"
                },
                "ScalingAdjustment": {
                    "type": "number"
                }
            },
            "required": [
                "ScalingAdjustment"
            ],
            "type": "object"
        },
        "AWS::AutoScaling::ScalingPolicy.TargetTrackingConfiguration": {
            "additionalProperties": false,
            "properties": {
                "CustomizedMetricSpecification": {
                    "$ref": "#/definitions/AWS::AutoScaling::ScalingPolicy.CustomizedMetricSpecification"
                },
                "DisableScaleIn": {
                    "type": "boolean"
                },
                "PredefinedMetricSpecification": {
                    "$ref": "#/definitions/AWS::AutoScaling::ScalingPolicy.PredefinedMetricSpecification"
                },
                "TargetValue": {
                    "type": "number"
                }
            },
            "required": [
                "TargetValue"
            ],
            "type": "object"
        },
        "AWS::AutoScaling::ScheduledAction": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "AutoScalingGroupName": {
                            "type": "string"
                        },
                        "DesiredCapacity": {
                            "type": "number"
                        },
                        "EndTime": {
                            "type": "string"
                        },
                        "MaxSize": {
                            "type": "number"
                        },
                        "MinSize": {
                            "type": "number"
                        },
                        "Recurrence": {
                            "type": "string"
                        },
                        "StartTime": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "AutoScalingGroupName"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::AutoScaling::ScheduledAction"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::AutoScalingPlans::ScalingPlan": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "ApplicationSource": {
                            "$ref": "#/definitions/AWS::AutoScalingPlans::ScalingPlan.ApplicationSource"
                        },
                        "ScalingInstructions": {
                            "items": {
                                "$ref": "#/definitions/AWS::AutoScalingPlans::ScalingPlan.ScalingInstruction"
                            },
                            "type": "array"
                        }
                    },
                    "required": [
                        "ApplicationSource",
                        "ScalingInstructions"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::AutoScalingPlans::ScalingPlan"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::AutoScalingPlans::ScalingPlan.ApplicationSource": {
            "additionalProperties": false,
            "properties": {
                "CloudFormationStackARN": {
                    "type": "string"
                },
                "TagFilters": {
                    "items": {
                        "$ref": "#/definitions/AWS::AutoScalingPlans::ScalingPlan.TagFilter"
                    },
                    "type": "array"
                }
            },
            "type": "object"
        },
        "AWS::AutoScalingPlans::ScalingPlan.CustomizedLoadMetricSpecification": {
            "additionalProperties": false,
            "properties": {
                "Dimensions": {
                    "items": {
                        "$ref": "#/definitions/AWS::AutoScalingPlans::ScalingPlan.MetricDimension"
                    },
                    "type": "array"
                },
                "MetricName": {
                    "type": "string"
                },
                "Namespace": {
                    "type": "string"
                },
                "Statistic": {
                    "type": "string"
                },
                "Unit": {
                    "type": "string"
                }
            },
            "required": [
                "MetricName",
                "Namespace",
                "Statistic"
            ],
            "type": "object"
        },
        "AWS::AutoScalingPlans::ScalingPlan.CustomizedScalingMetricSpecification": {
            "additionalProperties": false,
            "properties": {
                "Dimensions": {
                    "items": {
                        "$ref": "#/definitions/AWS::AutoScalingPlans::ScalingPlan.MetricDimension"
                    },
                    "type": "array"
                },
                "MetricName": {
                    "type": "string"
                },
                "Namespace": {
                    "type": "string"
                },
                "Statistic": {
                    "type": "string"
                },
                "Unit": {
                    "type": "string"
                }
            },
            "required": [
                "MetricName",
                "Namespace",
                "Statistic"
            ],
            "type": "object"
        },
        "AWS::AutoScalingPlans::ScalingPlan.MetricDimension": {
            "additionalProperties": false,
            "properties": {
                "Name": {
                    "type": "string"
                },
                "Value": {
                    "type": "string"
                }
            },
            "required": [
                "Name",
                "Value"
            ],
            "type": "object"
        },
        "AWS::AutoScalingPlans::ScalingPlan.PredefinedLoadMetricSpecification": {
            "additionalProperties": false,
            "properties": {
                "PredefinedLoadMetricType": {
                    "type": "string"
                },
                "ResourceLabel": {
                    "type": "string"
                }
            },
            "required": [
                "PredefinedLoadMetricType"
            ],
            "type": "object"
        },
        "AWS::AutoScalingPlans::ScalingPlan.PredefinedScalingMetricSpecification": {
            "additionalProperties": false,
            "properties": {
                "PredefinedScalingMetricType": {
                    "type": "string"
                },
                "ResourceLabel": {
                    "type": "string"
                }
            },
            "required": [
                "PredefinedScalingMetricType"
            ],
            "type": "object"
        },
        "AWS::AutoScalingPlans::ScalingPlan.ScalingInstruction": {
            "additionalProperties": false,
            "properties": {
                "CustomizedLoadMetricSpecification": {
                    "$ref": "#/definitions/AWS::AutoScalingPlans::ScalingPlan.CustomizedLoadMetricSpecification"
                },
                "DisableDynamicScaling": {
                    "type": "boolean"
                },
                "MaxCapacity": {
                    "type": "number"
                },
                "MinCapacity": {
                    "type": "number"
                },
                "PredefinedLoadMetricSpecification": {
                    "$ref": "#/definitions/AWS::AutoScalingPlans::ScalingPlan.PredefinedLoadMetricSpecification"
                },
                "PredictiveScalingMaxCapacityBehavior": {
                    "type": "string"
                },
                "PredictiveScalingMaxCapacityBuffer": {
                    "type": "number"
                },
                "PredictiveScalingMode": {
                    "type": "string"
                },
                "ResourceId": {
                    "type": "string"
                },
                "ScalableDimension": {
                    "type": "string"
                },
                "ScalingPolicyUpdateBehavior": {
                    "type": "string"
                },
                "ScheduledActionBufferTime": {
                    "type": "number"
                },
                "ServiceNamespace": {
                    "type": "string"
                },
                "TargetTrackingConfigurations": {
                    "items": {
                        "$ref": "#/definitions/AWS::AutoScalingPlans::ScalingPlan.TargetTrackingConfiguration"
                    },
                    "type": "array"
                }
            },
            "required": [
                "MaxCapacity",
                "MinCapacity",
                "ResourceId",
                "ScalableDimension",
                "ServiceNamespace",
                "TargetTrackingConfigurations"
            ],
            "type": "object"
        },
        "AWS::AutoScalingPlans::ScalingPlan.TagFilter": {
            "additionalProperties": false,
            "properties": {
                "Key": {
                    "type": "string"
                },
                "Values": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                }
            },
            "required": [
                "Key"
            ],
            "type": "object"
        },
        "AWS::AutoScalingPlans::ScalingPlan.TargetTrackingConfiguration": {
            "additionalProperties": false,
            "properties": {
                "CustomizedScalingMetricSpecification": {
                    "$ref": "#/definitions/AWS::AutoScalingPlans::ScalingPlan.CustomizedScalingMetricSpecification"
                },
                "DisableScaleIn": {
                    "type": "boolean"
                },
                "EstimatedInstanceWarmup": {
                    "type": "number"
                },
                "PredefinedScalingMetricSpecification": {
                    "$ref": "#/definitions/AWS::AutoScalingPlans::ScalingPlan.PredefinedScalingMetricSpecification"
                },
                "ScaleInCooldown": {
                    "type": "number"
                },
                "ScaleOutCooldown": {
                    "type": "number"
                },
                "TargetValue": {
                    "type": "number"
                }
            },
            "required": [
                "TargetValue"
            ],
            "type": "object"
        },
        "AWS::Batch::ComputeEnvironment": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "ComputeEnvironmentName": {
                            "type": "string"
                        },
                        "ComputeResources": {
                            "$ref": "#/definitions/AWS::Batch::ComputeEnvironment.ComputeResources"
                        },
                        "ServiceRole": {
                            "type": "string"
                        },
                        "State": {
                            "type": "string"
                        },
                        "Type": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "ServiceRole",
                        "Type"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::Batch::ComputeEnvironment"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::Batch::ComputeEnvironment.ComputeResources": {
            "additionalProperties": false,
            "properties": {
                "BidPercentage": {
                    "type": "number"
                },
                "DesiredvCpus": {
                    "type": "number"
                },
                "Ec2KeyPair": {
                    "type": "string"
                },
                "ImageId": {
                    "type": "string"
                },
                "InstanceRole": {
                    "type": "string"
                },
                "InstanceTypes": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "LaunchTemplate": {
                    "$ref": "#/definitions/AWS::Batch::ComputeEnvironment.LaunchTemplateSpecification"
                },
                "MaxvCpus": {
                    "type": "number"
                },
                "MinvCpus": {
                    "type": "number"
                },
                "PlacementGroup": {
                    "type": "string"
                },
                "SecurityGroupIds": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "SpotIamFleetRole": {
                    "type": "string"
                },
                "Subnets": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "Tags": {
                    "type": "object"
                },
                "Type": {
                    "type": "string"
                }
            },
            "required": [
                "InstanceRole",
                "InstanceTypes",
                "MaxvCpus",
                "MinvCpus",
                "SecurityGroupIds",
                "Subnets",
                "Type"
            ],
            "type": "object"
        },
        "AWS::Batch::ComputeEnvironment.LaunchTemplateSpecification": {
            "additionalProperties": false,
            "properties": {
                "LaunchTemplateId": {
                    "type": "string"
                },
                "LaunchTemplateName": {
                    "type": "string"
                },
                "Version": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::Batch::JobDefinition": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "ContainerProperties": {
                            "$ref": "#/definitions/AWS::Batch::JobDefinition.ContainerProperties"
                        },
                        "JobDefinitionName": {
                            "type": "string"
                        },
                        "NodeProperties": {
                            "$ref": "#/definitions/AWS::Batch::JobDefinition.NodeProperties"
                        },
                        "Parameters": {
                            "type": "object"
                        },
                        "RetryStrategy": {
                            "$ref": "#/definitions/AWS::Batch::JobDefinition.RetryStrategy"
                        },
                        "Timeout": {
                            "$ref": "#/definitions/AWS::Batch::JobDefinition.Timeout"
                        },
                        "Type": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "Type"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::Batch::JobDefinition"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::Batch::JobDefinition.ContainerProperties": {
            "additionalProperties": false,
            "properties": {
                "Command": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "Environment": {
                    "items": {
                        "$ref": "#/definitions/AWS::Batch::JobDefinition.Environment"
                    },
                    "type": "array"
                },
                "Image": {
                    "type": "string"
                },
                "InstanceType": {
                    "type": "string"
                },
                "JobRoleArn": {
                    "type": "string"
                },
                "Memory": {
                    "type": "number"
                },
                "MountPoints": {
                    "items": {
                        "$ref": "#/definitions/AWS::Batch::JobDefinition.MountPoints"
                    },
                    "type": "array"
                },
                "Privileged": {
                    "type": "boolean"
                },
                "ReadonlyRootFilesystem": {
                    "type": "boolean"
                },
                "Ulimits": {
                    "items": {
                        "$ref": "#/definitions/AWS::Batch::JobDefinition.Ulimit"
                    },
                    "type": "array"
                },
                "User": {
                    "type": "string"
                },
                "Vcpus": {
                    "type": "number"
                },
                "Volumes": {
                    "items": {
                        "$ref": "#/definitions/AWS::Batch::JobDefinition.Volumes"
                    },
                    "type": "array"
                }
            },
            "required": [
                "Image",
                "Memory",
                "Vcpus"
            ],
            "type": "object"
        },
        "AWS::Batch::JobDefinition.Environment": {
            "additionalProperties": false,
            "properties": {
                "Name": {
                    "type": "string"
                },
                "Value": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::Batch::JobDefinition.MountPoints": {
            "additionalProperties": false,
            "properties": {
                "ContainerPath": {
                    "type": "string"
                },
                "ReadOnly": {
                    "type": "boolean"
                },
                "SourceVolume": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::Batch::JobDefinition.NodeProperties": {
            "additionalProperties": false,
            "properties": {
                "MainNode": {
                    "type": "number"
                },
                "NodeRangeProperties": {
                    "items": {
                        "$ref": "#/definitions/AWS::Batch::JobDefinition.NodeRangeProperty"
                    },
                    "type": "array"
                },
                "NumNodes": {
                    "type": "number"
                }
            },
            "required": [
                "MainNode",
                "NodeRangeProperties",
                "NumNodes"
            ],
            "type": "object"
        },
        "AWS::Batch::JobDefinition.NodeRangeProperty": {
            "additionalProperties": false,
            "properties": {
                "Container": {
                    "$ref": "#/definitions/AWS::Batch::JobDefinition.ContainerProperties"
                },
                "TargetNodes": {
                    "type": "string"
                }
            },
            "required": [
                "TargetNodes"
            ],
            "type": "object"
        },
        "AWS::Batch::JobDefinition.RetryStrategy": {
            "additionalProperties": false,
            "properties": {
                "Attempts": {
                    "type": "number"
                }
            },
            "type": "object"
        },
        "AWS::Batch::JobDefinition.Timeout": {
            "additionalProperties": false,
            "properties": {
                "AttemptDurationSeconds": {
                    "type": "number"
                }
            },
            "type": "object"
        },
        "AWS::Batch::JobDefinition.Ulimit": {
            "additionalProperties": false,
            "properties": {
                "HardLimit": {
                    "type": "number"
                },
                "Name": {
                    "type": "string"
                },
                "SoftLimit": {
                    "type": "number"
                }
            },
            "required": [
                "HardLimit",
                "Name",
                "SoftLimit"
            ],
            "type": "object"
        },
        "AWS::Batch::JobDefinition.Volumes": {
            "additionalProperties": false,
            "properties": {
                "Host": {
                    "$ref": "#/definitions/AWS::Batch::JobDefinition.VolumesHost"
                },
                "Name": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::Batch::JobDefinition.VolumesHost": {
            "additionalProperties": false,
            "properties": {
                "SourcePath": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::Batch::JobQueue": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "ComputeEnvironmentOrder": {
                            "items": {
                                "$ref": "#/definitions/AWS::Batch::JobQueue.ComputeEnvironmentOrder"
                            },
                            "type": "array"
                        },
                        "JobQueueName": {
                            "type": "string"
                        },
                        "Priority": {
                            "type": "number"
                        },
                        "State": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "ComputeEnvironmentOrder",
                        "Priority"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::Batch::JobQueue"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::Batch::JobQueue.ComputeEnvironmentOrder": {
            "additionalProperties": false,
            "properties": {
                "ComputeEnvironment": {
                    "type": "string"
                },
                "Order": {
                    "type": "number"
                }
            },
            "required": [
                "ComputeEnvironment",
                "Order"
            ],
            "type": "object"
        },
        "AWS::Budgets::Budget": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Budget": {
                            "$ref": "#/definitions/AWS::Budgets::Budget.BudgetData"
                        },
                        "NotificationsWithSubscribers": {
                            "items": {
                                "$ref": "#/definitions/AWS::Budgets::Budget.NotificationWithSubscribers"
                            },
                            "type": "array"
                        }
                    },
                    "required": [
                        "Budget"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::Budgets::Budget"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::Budgets::Budget.BudgetData": {
            "additionalProperties": false,
            "properties": {
                "BudgetLimit": {
                    "$ref": "#/definitions/AWS::Budgets::Budget.Spend"
                },
                "BudgetName": {
                    "type": "string"
                },
                "BudgetType": {
                    "type": "string"
                },
                "CostFilters": {
                    "type": "object"
                },
                "CostTypes": {
                    "$ref": "#/definitions/AWS::Budgets::Budget.CostTypes"
                },
                "TimePeriod": {
                    "$ref": "#/definitions/AWS::Budgets::Budget.TimePeriod"
                },
                "TimeUnit": {
                    "type": "string"
                }
            },
            "required": [
                "BudgetType",
                "TimeUnit"
            ],
            "type": "object"
        },
        "AWS::Budgets::Budget.CostTypes": {
            "additionalProperties": false,
            "properties": {
                "IncludeCredit": {
                    "type": "boolean"
                },
                "IncludeDiscount": {
                    "type": "boolean"
                },
                "IncludeOtherSubscription": {
                    "type": "boolean"
                },
                "IncludeRecurring": {
                    "type": "boolean"
                },
                "IncludeRefund": {
                    "type": "boolean"
                },
                "IncludeSubscription": {
                    "type": "boolean"
                },
                "IncludeSupport": {
                    "type": "boolean"
                },
                "IncludeTax": {
                    "type": "boolean"
                },
                "IncludeUpfront": {
                    "type": "boolean"
                },
                "UseAmortized": {
                    "type": "boolean"
                },
                "UseBlended": {
                    "type": "boolean"
                }
            },
            "type": "object"
        },
        "AWS::Budgets::Budget.Notification": {
            "additionalProperties": false,
            "properties": {
                "ComparisonOperator": {
                    "type": "string"
                },
                "NotificationType": {
                    "type": "string"
                },
                "Threshold": {
                    "type": "number"
                },
                "ThresholdType": {
                    "type": "string"
                }
            },
            "required": [
                "ComparisonOperator",
                "NotificationType",
                "Threshold"
            ],
            "type": "object"
        },
        "AWS::Budgets::Budget.NotificationWithSubscribers": {
            "additionalProperties": false,
            "properties": {
                "Notification": {
                    "$ref": "#/definitions/AWS::Budgets::Budget.Notification"
                },
                "Subscribers": {
                    "items": {
                        "$ref": "#/definitions/AWS::Budgets::Budget.Subscriber"
                    },
                    "type": "array"
                }
            },
            "required": [
                "Notification",
                "Subscribers"
            ],
            "type": "object"
        },
        "AWS::Budgets::Budget.Spend": {
            "additionalProperties": false,
            "properties": {
                "Amount": {
                    "type": "number"
                },
                "Unit": {
                    "type": "string"
                }
            },
            "required": [
                "Amount",
                "Unit"
            ],
            "type": "object"
        },
        "AWS::Budgets::Budget.Subscriber": {
            "additionalProperties": false,
            "properties": {
                "Address": {
                    "type": "string"
                },
                "SubscriptionType": {
                    "type": "string"
                }
            },
            "required": [
                "Address",
                "SubscriptionType"
            ],
            "type": "object"
        },
        "AWS::Budgets::Budget.TimePeriod": {
            "additionalProperties": false,
            "properties": {
                "End": {
                    "type": "string"
                },
                "Start": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::CertificateManager::Certificate": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "DomainName": {
                            "type": "string"
                        },
                        "DomainValidationOptions": {
                            "items": {
                                "$ref": "#/definitions/AWS::CertificateManager::Certificate.DomainValidationOption"
                            },
                            "type": "array"
                        },
                        "SubjectAlternativeNames": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        },
                        "ValidationMethod": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "DomainName"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::CertificateManager::Certificate"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::CertificateManager::Certificate.DomainValidationOption": {
            "additionalProperties": false,
            "properties": {
                "DomainName": {
                    "type": "string"
                },
                "ValidationDomain": {
                    "type": "string"
                }
            },
            "required": [
                "DomainName",
                "ValidationDomain"
            ],
            "type": "object"
        },
        "AWS::Cloud9::EnvironmentEC2": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "AutomaticStopTimeMinutes": {
                            "type": "number"
                        },
                        "Description": {
                            "type": "string"
                        },
                        "InstanceType": {
                            "type": "string"
                        },
                        "Name": {
                            "type": "string"
                        },
                        "OwnerArn": {
                            "type": "string"
                        },
                        "Repositories": {
                            "items": {
                                "$ref": "#/definitions/AWS::Cloud9::EnvironmentEC2.Repository"
                            },
                            "type": "array"
                        },
                        "SubnetId": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "InstanceType"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::Cloud9::EnvironmentEC2"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::Cloud9::EnvironmentEC2.Repository": {
            "additionalProperties": false,
            "properties": {
                "PathComponent": {
                    "type": "string"
                },
                "RepositoryUrl": {
                    "type": "string"
                }
            },
            "required": [
                "PathComponent",
                "RepositoryUrl"
            ],
            "type": "object"
        },
        "AWS::CloudFormation::CustomResource": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "ServiceToken": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "ServiceToken"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::CloudFormation::CustomResource"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::CloudFormation::Macro": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Description": {
                            "type": "string"
                        },
                        "FunctionName": {
                            "type": "string"
                        },
                        "LogGroupName": {
                            "type": "string"
                        },
                        "LogRoleARN": {
                            "type": "string"
                        },
                        "Name": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "FunctionName",
                        "Name"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::CloudFormation::Macro"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::CloudFormation::Stack": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "NotificationARNs": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "Parameters": {
                            "additionalProperties": true,
                            "patternProperties": {
                                "^[a-zA-Z0-9]+$": {
                                    "type": "string"
                                }
                            },
                            "type": "object"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        },
                        "TemplateURL": {
                            "type": "string"
                        },
                        "TimeoutInMinutes": {
                            "type": "number"
                        }
                    },
                    "required": [
                        "TemplateURL"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::CloudFormation::Stack"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::CloudFormation::WaitCondition": {
            "additionalProperties": false,
            "properties": {
                "CreationPolicy": {
                    "type": "object"
                },
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Count": {
                            "type": "number"
                        },
                        "Handle": {
                            "type": "string"
                        },
                        "Timeout": {
                            "type": "string"
                        }
                    },
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::CloudFormation::WaitCondition"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type"
            ],
            "type": "object"
        },
        "AWS::CloudFormation::WaitConditionHandle": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {},
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::CloudFormation::WaitConditionHandle"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type"
            ],
            "type": "object"
        },
        "AWS::CloudFront::CloudFrontOriginAccessIdentity": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "CloudFrontOriginAccessIdentityConfig": {
                            "$ref": "#/definitions/AWS::CloudFront::CloudFrontOriginAccessIdentity.CloudFrontOriginAccessIdentityConfig"
                        }
                    },
                    "required": [
                        "CloudFrontOriginAccessIdentityConfig"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::CloudFront::CloudFrontOriginAccessIdentity"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::CloudFront::CloudFrontOriginAccessIdentity.CloudFrontOriginAccessIdentityConfig": {
            "additionalProperties": false,
            "properties": {
                "Comment": {
                    "type": "string"
                }
            },
            "required": [
                "Comment"
            ],
            "type": "object"
        },
        "AWS::CloudFront::Distribution": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "DistributionConfig": {
                            "$ref": "#/definitions/AWS::CloudFront::Distribution.DistributionConfig"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        }
                    },
                    "required": [
                        "DistributionConfig"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::CloudFront::Distribution"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::CloudFront::Distribution.CacheBehavior": {
            "additionalProperties": false,
            "properties": {
                "AllowedMethods": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "CachedMethods": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "Compress": {
                    "type": "boolean"
                },
                "DefaultTTL": {
                    "type": "number"
                },
                "FieldLevelEncryptionId": {
                    "type": "string"
                },
                "ForwardedValues": {
                    "$ref": "#/definitions/AWS::CloudFront::Distribution.ForwardedValues"
                },
                "LambdaFunctionAssociations": {
                    "items": {
                        "$ref": "#/definitions/AWS::CloudFront::Distribution.LambdaFunctionAssociation"
                    },
                    "type": "array"
                },
                "MaxTTL": {
                    "type": "number"
                },
                "MinTTL": {
                    "type": "number"
                },
                "PathPattern": {
                    "type": "string"
                },
                "SmoothStreaming": {
                    "type": "boolean"
                },
                "TargetOriginId": {
                    "type": "string"
                },
                "TrustedSigners": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "ViewerProtocolPolicy": {
                    "type": "string"
                }
            },
            "required": [
                "ForwardedValues",
                "PathPattern",
                "TargetOriginId",
                "ViewerProtocolPolicy"
            ],
            "type": "object"
        },
        "AWS::CloudFront::Distribution.Cookies": {
            "additionalProperties": false,
            "properties": {
                "Forward": {
                    "type": "string"
                },
                "WhitelistedNames": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                }
            },
            "required": [
                "Forward"
            ],
            "type": "object"
        },
        "AWS::CloudFront::Distribution.CustomErrorResponse": {
            "additionalProperties": false,
            "properties": {
                "ErrorCachingMinTTL": {
                    "type": "number"
                },
                "ErrorCode": {
                    "type": "number"
                },
                "ResponseCode": {
                    "type": "number"
                },
                "ResponsePagePath": {
                    "type": "string"
                }
            },
            "required": [
                "ErrorCode"
            ],
            "type": "object"
        },
        "AWS::CloudFront::Distribution.CustomOriginConfig": {
            "additionalProperties": false,
            "properties": {
                "HTTPPort": {
                    "type": "number"
                },
                "HTTPSPort": {
                    "type": "number"
                },
                "OriginKeepaliveTimeout": {
                    "type": "number"
                },
                "OriginProtocolPolicy": {
                    "type": "string"
                },
                "OriginReadTimeout": {
                    "type": "number"
                },
                "OriginSSLProtocols": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                }
            },
            "required": [
                "OriginProtocolPolicy"
            ],
            "type": "object"
        },
        "AWS::CloudFront::Distribution.DefaultCacheBehavior": {
            "additionalProperties": false,
            "properties": {
                "AllowedMethods": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "CachedMethods": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "Compress": {
                    "type": "boolean"
                },
                "DefaultTTL": {
                    "type": "number"
                },
                "FieldLevelEncryptionId": {
                    "type": "string"
                },
                "ForwardedValues": {
                    "$ref": "#/definitions/AWS::CloudFront::Distribution.ForwardedValues"
                },
                "LambdaFunctionAssociations": {
                    "items": {
                        "$ref": "#/definitions/AWS::CloudFront::Distribution.LambdaFunctionAssociation"
                    },
                    "type": "array"
                },
                "MaxTTL": {
                    "type": "number"
                },
                "MinTTL": {
                    "type": "number"
                },
                "SmoothStreaming": {
                    "type": "boolean"
                },
                "TargetOriginId": {
                    "type": "string"
                },
                "TrustedSigners": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "ViewerProtocolPolicy": {
                    "type": "string"
                }
            },
            "required": [
                "ForwardedValues",
                "TargetOriginId",
                "ViewerProtocolPolicy"
            ],
            "type": "object"
        },
        "AWS::CloudFront::Distribution.DistributionConfig": {
            "additionalProperties": false,
            "properties": {
                "Aliases": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "CacheBehaviors": {
                    "items": {
                        "$ref": "#/definitions/AWS::CloudFront::Distribution.CacheBehavior"
                    },
                    "type": "array"
                },
                "Comment": {
                    "type": "string"
                },
                "CustomErrorResponses": {
                    "items": {
                        "$ref": "#/definitions/AWS::CloudFront::Distribution.CustomErrorResponse"
                    },
                    "type": "array"
                },
                "DefaultCacheBehavior": {
                    "$ref": "#/definitions/AWS::CloudFront::Distribution.DefaultCacheBehavior"
                },
                "DefaultRootObject": {
                    "type": "string"
                },
                "Enabled": {
                    "type": "boolean"
                },
                "HttpVersion": {
                    "type": "string"
                },
                "IPV6Enabled": {
                    "type": "boolean"
                },
                "Logging": {
                    "$ref": "#/definitions/AWS::CloudFront::Distribution.Logging"
                },
                "Origins": {
                    "items": {
                        "$ref": "#/definitions/AWS::CloudFront::Distribution.Origin"
                    },
                    "type": "array"
                },
                "PriceClass": {
                    "type": "string"
                },
                "Restrictions": {
                    "$ref": "#/definitions/AWS::CloudFront::Distribution.Restrictions"
                },
                "ViewerCertificate": {
                    "$ref": "#/definitions/AWS::CloudFront::Distribution.ViewerCertificate"
                },
                "WebACLId": {
                    "type": "string"
                }
            },
            "required": [
                "Enabled"
            ],
            "type": "object"
        },
        "AWS::CloudFront::Distribution.ForwardedValues": {
            "additionalProperties": false,
            "properties": {
                "Cookies": {
                    "$ref": "#/definitions/AWS::CloudFront::Distribution.Cookies"
                },
                "Headers": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "QueryString": {
                    "type": "boolean"
                },
                "QueryStringCacheKeys": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                }
            },
            "required": [
                "QueryString"
            ],
            "type": "object"
        },
        "AWS::CloudFront::Distribution.GeoRestriction": {
            "additionalProperties": false,
            "properties": {
                "Locations": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "RestrictionType": {
                    "type": "string"
                }
            },
            "required": [
                "RestrictionType"
            ],
            "type": "object"
        },
        "AWS::CloudFront::Distribution.LambdaFunctionAssociation": {
            "additionalProperties": false,
            "properties": {
                "EventType": {
                    "type": "string"
                },
                "LambdaFunctionARN": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::CloudFront::Distribution.Logging": {
            "additionalProperties": false,
            "properties": {
                "Bucket": {
                    "type": "string"
                },
                "IncludeCookies": {
                    "type": "boolean"
                },
                "Prefix": {
                    "type": "string"
                }
            },
            "required": [
                "Bucket"
            ],
            "type": "object"
        },
        "AWS::CloudFront::Distribution.Origin": {
            "additionalProperties": false,
            "properties": {
                "CustomOriginConfig": {
                    "$ref": "#/definitions/AWS::CloudFront::Distribution.CustomOriginConfig"
                },
                "DomainName": {
                    "type": "string"
                },
                "Id": {
                    "type": "string"
                },
                "OriginCustomHeaders": {
                    "items": {
                        "$ref": "#/definitions/AWS::CloudFront::Distribution.OriginCustomHeader"
                    },
                    "type": "array"
                },
                "OriginPath": {
                    "type": "string"
                },
                "S3OriginConfig": {
                    "$ref": "#/definitions/AWS::CloudFront::Distribution.S3OriginConfig"
                }
            },
            "required": [
                "DomainName",
                "Id"
            ],
            "type": "object"
        },
        "AWS::CloudFront::Distribution.OriginCustomHeader": {
            "additionalProperties": false,
            "properties": {
                "HeaderName": {
                    "type": "string"
                },
                "HeaderValue": {
                    "type": "string"
                }
            },
            "required": [
                "HeaderName",
                "HeaderValue"
            ],
            "type": "object"
        },
        "AWS::CloudFront::Distribution.Restrictions": {
            "additionalProperties": false,
            "properties": {
                "GeoRestriction": {
                    "$ref": "#/definitions/AWS::CloudFront::Distribution.GeoRestriction"
                }
            },
            "required": [
                "GeoRestriction"
            ],
            "type": "object"
        },
        "AWS::CloudFront::Distribution.S3OriginConfig": {
            "additionalProperties": false,
            "properties": {
                "OriginAccessIdentity": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::CloudFront::Distribution.ViewerCertificate": {
            "additionalProperties": false,
            "properties": {
                "AcmCertificateArn": {
                    "type": "string"
                },
                "CloudFrontDefaultCertificate": {
                    "type": "boolean"
                },
                "IamCertificateId": {
                    "type": "string"
                },
                "MinimumProtocolVersion": {
                    "type": "string"
                },
                "SslSupportMethod": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::CloudFront::StreamingDistribution": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "StreamingDistributionConfig": {
                            "$ref": "#/definitions/AWS::CloudFront::StreamingDistribution.StreamingDistributionConfig"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        }
                    },
                    "required": [
                        "StreamingDistributionConfig",
                        "Tags"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::CloudFront::StreamingDistribution"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::CloudFront::StreamingDistribution.Logging": {
            "additionalProperties": false,
            "properties": {
                "Bucket": {
                    "type": "string"
                },
                "Enabled": {
                    "type": "boolean"
                },
                "Prefix": {
                    "type": "string"
                }
            },
            "required": [
                "Bucket",
                "Enabled",
                "Prefix"
            ],
            "type": "object"
        },
        "AWS::CloudFront::StreamingDistribution.S3Origin": {
            "additionalProperties": false,
            "properties": {
                "DomainName": {
                    "type": "string"
                },
                "OriginAccessIdentity": {
                    "type": "string"
                }
            },
            "required": [
                "DomainName",
                "OriginAccessIdentity"
            ],
            "type": "object"
        },
        "AWS::CloudFront::StreamingDistribution.StreamingDistributionConfig": {
            "additionalProperties": false,
            "properties": {
                "Aliases": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "Comment": {
                    "type": "string"
                },
                "Enabled": {
                    "type": "boolean"
                },
                "Logging": {
                    "$ref": "#/definitions/AWS::CloudFront::StreamingDistribution.Logging"
                },
                "PriceClass": {
                    "type": "string"
                },
                "S3Origin": {
                    "$ref": "#/definitions/AWS::CloudFront::StreamingDistribution.S3Origin"
                },
                "TrustedSigners": {
                    "$ref": "#/definitions/AWS::CloudFront::StreamingDistribution.TrustedSigners"
                }
            },
            "required": [
                "Comment",
                "Enabled",
                "S3Origin",
                "TrustedSigners"
            ],
            "type": "object"
        },
        "AWS::CloudFront::StreamingDistribution.TrustedSigners": {
            "additionalProperties": false,
            "properties": {
                "AwsAccountNumbers": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "Enabled": {
                    "type": "boolean"
                }
            },
            "required": [
                "Enabled"
            ],
            "type": "object"
        },
        "AWS::CloudTrail::Trail": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "CloudWatchLogsLogGroupArn": {
                            "type": "string"
                        },
                        "CloudWatchLogsRoleArn": {
                            "type": "string"
                        },
                        "EnableLogFileValidation": {
                            "type": "boolean"
                        },
                        "EventSelectors": {
                            "items": {
                                "$ref": "#/definitions/AWS::CloudTrail::Trail.EventSelector"
                            },
                            "type": "array"
                        },
                        "IncludeGlobalServiceEvents": {
                            "type": "boolean"
                        },
                        "IsLogging": {
                            "type": "boolean"
                        },
                        "IsMultiRegionTrail": {
                            "type": "boolean"
                        },
                        "KMSKeyId": {
                            "type": "string"
                        },
                        "S3BucketName": {
                            "type": "string"
                        },
                        "S3KeyPrefix": {
                            "type": "string"
                        },
                        "SnsTopicName": {
                            "type": "string"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        },
                        "TrailName": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "IsLogging",
                        "S3BucketName"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::CloudTrail::Trail"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::CloudTrail::Trail.DataResource": {
            "additionalProperties": false,
            "properties": {
                "Type": {
                    "type": "string"
                },
                "Values": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                }
            },
            "required": [
                "Type"
            ],
            "type": "object"
        },
        "AWS::CloudTrail::Trail.EventSelector": {
            "additionalProperties": false,
            "properties": {
                "DataResources": {
                    "items": {
                        "$ref": "#/definitions/AWS::CloudTrail::Trail.DataResource"
                    },
                    "type": "array"
                },
                "IncludeManagementEvents": {
                    "type": "boolean"
                },
                "ReadWriteType": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::CloudWatch::Alarm": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "ActionsEnabled": {
                            "type": "boolean"
                        },
                        "AlarmActions": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "AlarmDescription": {
                            "type": "string"
                        },
                        "AlarmName": {
                            "type": "string"
                        },
                        "ComparisonOperator": {
                            "type": "string"
                        },
                        "DatapointsToAlarm": {
                            "type": "number"
                        },
                        "Dimensions": {
                            "items": {
                                "$ref": "#/definitions/AWS::CloudWatch::Alarm.Dimension"
                            },
                            "type": "array"
                        },
                        "EvaluateLowSampleCountPercentile": {
                            "type": "string"
                        },
                        "EvaluationPeriods": {
                            "type": "number"
                        },
                        "ExtendedStatistic": {
                            "type": "string"
                        },
                        "InsufficientDataActions": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "MetricName": {
                            "type": "string"
                        },
                        "Metrics": {
                            "items": {
                                "$ref": "#/definitions/AWS::CloudWatch::Alarm.MetricDataQuery"
                            },
                            "type": "array"
                        },
                        "Namespace": {
                            "type": "string"
                        },
                        "OKActions": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "Period": {
                            "type": "number"
                        },
                        "Statistic": {
                            "type": "string"
                        },
                        "Threshold": {
                            "type": "number"
                        },
                        "TreatMissingData": {
                            "type": "string"
                        },
                        "Unit": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "ComparisonOperator",
                        "EvaluationPeriods",
                        "Threshold"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::CloudWatch::Alarm"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::CloudWatch::Alarm.Dimension": {
            "additionalProperties": false,
            "properties": {
                "Name": {
                    "type": "string"
                },
                "Value": {
                    "type": "string"
                }
            },
            "required": [
                "Name",
                "Value"
            ],
            "type": "object"
        },
        "AWS::CloudWatch::Alarm.Metric": {
            "additionalProperties": false,
            "properties": {
                "Dimensions": {
                    "items": {
                        "$ref": "#/definitions/AWS::CloudWatch::Alarm.Dimension"
                    },
                    "type": "array"
                },
                "MetricName": {
                    "type": "string"
                },
                "Namespace": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::CloudWatch::Alarm.MetricDataQuery": {
            "additionalProperties": false,
            "properties": {
                "Expression": {
                    "type": "string"
                },
                "Id": {
                    "type": "string"
                },
                "Label": {
                    "type": "string"
                },
                "MetricStat": {
                    "$ref": "#/definitions/AWS::CloudWatch::Alarm.MetricStat"
                },
                "ReturnData": {
                    "type": "boolean"
                }
            },
            "required": [
                "Id"
            ],
            "type": "object"
        },
        "AWS::CloudWatch::Alarm.MetricStat": {
            "additionalProperties": false,
            "properties": {
                "Metric": {
                    "$ref": "#/definitions/AWS::CloudWatch::Alarm.Metric"
                },
                "Period": {
                    "type": "number"
                },
                "Stat": {
                    "type": "string"
                },
                "Unit": {
                    "type": "string"
                }
            },
            "required": [
                "Metric",
                "Period",
                "Stat"
            ],
            "type": "object"
        },
        "AWS::CloudWatch::Dashboard": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "DashboardBody": {
                            "type": "string"
                        },
                        "DashboardName": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "DashboardBody"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::CloudWatch::Dashboard"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::CodeBuild::Project": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Artifacts": {
                            "$ref": "#/definitions/AWS::CodeBuild::Project.Artifacts"
                        },
                        "BadgeEnabled": {
                            "type": "boolean"
                        },
                        "Cache": {
                            "$ref": "#/definitions/AWS::CodeBuild::Project.ProjectCache"
                        },
                        "Description": {
                            "type": "string"
                        },
                        "EncryptionKey": {
                            "type": "string"
                        },
                        "Environment": {
                            "$ref": "#/definitions/AWS::CodeBuild::Project.Environment"
                        },
                        "LogsConfig": {
                            "$ref": "#/definitions/AWS::CodeBuild::Project.LogsConfig"
                        },
                        "Name": {
                            "type": "string"
                        },
                        "QueuedTimeoutInMinutes": {
                            "type": "number"
                        },
                        "SecondaryArtifacts": {
                            "items": {
                                "$ref": "#/definitions/AWS::CodeBuild::Project.Artifacts"
                            },
                            "type": "array"
                        },
                        "SecondarySources": {
                            "items": {
                                "$ref": "#/definitions/AWS::CodeBuild::Project.Source"
                            },
                            "type": "array"
                        },
                        "ServiceRole": {
                            "type": "string"
                        },
                        "Source": {
                            "$ref": "#/definitions/AWS::CodeBuild::Project.Source"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        },
                        "TimeoutInMinutes": {
                            "type": "number"
                        },
                        "Triggers": {
                            "$ref": "#/definitions/AWS::CodeBuild::Project.ProjectTriggers"
                        },
                        "VpcConfig": {
                            "$ref": "#/definitions/AWS::CodeBuild::Project.VpcConfig"
                        }
                    },
                    "required": [
                        "Artifacts",
                        "Environment",
                        "ServiceRole",
                        "Source"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::CodeBuild::Project"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::CodeBuild::Project.Artifacts": {
            "additionalProperties": false,
            "properties": {
                "ArtifactIdentifier": {
                    "type": "string"
                },
                "EncryptionDisabled": {
                    "type": "boolean"
                },
                "Location": {
                    "type": "string"
                },
                "Name": {
                    "type": "string"
                },
                "NamespaceType": {
                    "type": "string"
                },
                "OverrideArtifactName": {
                    "type": "boolean"
                },
                "Packaging": {
                    "type": "string"
                },
                "Path": {
                    "type": "string"
                },
                "Type": {
                    "type": "string"
                }
            },
            "required": [
                "Type"
            ],
            "type": "object"
        },
        "AWS::CodeBuild::Project.CloudWatchLogsConfig": {
            "additionalProperties": false,
            "properties": {
                "GroupName": {
                    "type": "string"
                },
                "Status": {
                    "type": "string"
                },
                "StreamName": {
                    "type": "string"
                }
            },
            "required": [
                "Status"
            ],
            "type": "object"
        },
        "AWS::CodeBuild::Project.Environment": {
            "additionalProperties": false,
            "properties": {
                "Certificate": {
                    "type": "string"
                },
                "ComputeType": {
                    "type": "string"
                },
                "EnvironmentVariables": {
                    "items": {
                        "$ref": "#/definitions/AWS::CodeBuild::Project.EnvironmentVariable"
                    },
                    "type": "array"
                },
                "Image": {
                    "type": "string"
                },
                "ImagePullCredentialsType": {
                    "type": "string"
                },
                "PrivilegedMode": {
                    "type": "boolean"
                },
                "RegistryCredential": {
                    "$ref": "#/definitions/AWS::CodeBuild::Project.RegistryCredential"
                },
                "Type": {
                    "type": "string"
                }
            },
            "required": [
                "ComputeType",
                "Image",
                "Type"
            ],
            "type": "object"
        },
        "AWS::CodeBuild::Project.EnvironmentVariable": {
            "additionalProperties": false,
            "properties": {
                "Name": {
                    "type": "string"
                },
                "Type": {
                    "type": "string"
                },
                "Value": {
                    "type": "string"
                }
            },
            "required": [
                "Name",
                "Value"
            ],
            "type": "object"
        },
        "AWS::CodeBuild::Project.FilterGroup": {
            "additionalProperties": false,
            "properties": {},
            "type": "object"
        },
        "AWS::CodeBuild::Project.LogsConfig": {
            "additionalProperties": false,
            "properties": {
                "CloudWatchLogs": {
                    "$ref": "#/definitions/AWS::CodeBuild::Project.CloudWatchLogsConfig"
                },
                "S3Logs": {
                    "$ref": "#/definitions/AWS::CodeBuild::Project.S3LogsConfig"
                }
            },
            "type": "object"
        },
        "AWS::CodeBuild::Project.ProjectCache": {
            "additionalProperties": false,
            "properties": {
                "Location": {
                    "type": "string"
                },
                "Modes": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "Type": {
                    "type": "string"
                }
            },
            "required": [
                "Type"
            ],
            "type": "object"
        },
        "AWS::CodeBuild::Project.ProjectTriggers": {
            "additionalProperties": false,
            "properties": {
                "FilterGroups": {
                    "items": {
                        "$ref": "#/definitions/AWS::CodeBuild::Project.FilterGroup"
                    },
                    "type": "array"
                },
                "Webhook": {
                    "type": "boolean"
                }
            },
            "type": "object"
        },
        "AWS::CodeBuild::Project.RegistryCredential": {
            "additionalProperties": false,
            "properties": {
                "Credential": {
                    "type": "string"
                },
                "CredentialProvider": {
                    "type": "string"
                }
            },
            "required": [
                "Credential",
                "CredentialProvider"
            ],
            "type": "object"
        },
        "AWS::CodeBuild::Project.S3LogsConfig": {
            "additionalProperties": false,
            "properties": {
                "Location": {
                    "type": "string"
                },
                "Status": {
                    "type": "string"
                }
            },
            "required": [
                "Status"
            ],
            "type": "object"
        },
        "AWS::CodeBuild::Project.Source": {
            "additionalProperties": false,
            "properties": {
                "Auth": {
                    "$ref": "#/definitions/AWS::CodeBuild::Project.SourceAuth"
                },
                "BuildSpec": {
                    "type": "string"
                },
                "GitCloneDepth": {
                    "type": "number"
                },
                "InsecureSsl": {
                    "type": "boolean"
                },
                "Location": {
                    "type": "string"
                },
                "ReportBuildStatus": {
                    "type": "boolean"
                },
                "SourceIdentifier": {
                    "type": "string"
                },
                "Type": {
                    "type": "string"
                }
            },
            "required": [
                "Type"
            ],
            "type": "object"
        },
        "AWS::CodeBuild::Project.SourceAuth": {
            "additionalProperties": false,
            "properties": {
                "Resource": {
                    "type": "string"
                },
                "Type": {
                    "type": "string"
                }
            },
            "required": [
                "Type"
            ],
            "type": "object"
        },
        "AWS::CodeBuild::Project.VpcConfig": {
            "additionalProperties": false,
            "properties": {
                "SecurityGroupIds": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "Subnets": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "VpcId": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::CodeBuild::Project.WebhookFilter": {
            "additionalProperties": false,
            "properties": {
                "ExcludeMatchedPattern": {
                    "type": "boolean"
                },
                "Pattern": {
                    "type": "string"
                },
                "Type": {
                    "type": "string"
                }
            },
            "required": [
                "Pattern",
                "Type"
            ],
            "type": "object"
        },
        "AWS::CodeCommit::Repository": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "RepositoryDescription": {
                            "type": "string"
                        },
                        "RepositoryName": {
                            "type": "string"
                        },
                        "Triggers": {
                            "items": {
                                "$ref": "#/definitions/AWS::CodeCommit::Repository.RepositoryTrigger"
                            },
                            "type": "array"
                        }
                    },
                    "required": [
                        "RepositoryName"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::CodeCommit::Repository"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::CodeCommit::Repository.RepositoryTrigger": {
            "additionalProperties": false,
            "properties": {
                "Branches": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "CustomData": {
                    "type": "string"
                },
                "DestinationArn": {
                    "type": "string"
                },
                "Events": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "Name": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::CodeDeploy::Application": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "ApplicationName": {
                            "type": "string"
                        },
                        "ComputePlatform": {
                            "type": "string"
                        }
                    },
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::CodeDeploy::Application"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type"
            ],
            "type": "object"
        },
        "AWS::CodeDeploy::DeploymentConfig": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "DeploymentConfigName": {
                            "type": "string"
                        },
                        "MinimumHealthyHosts": {
                            "$ref": "#/definitions/AWS::CodeDeploy::DeploymentConfig.MinimumHealthyHosts"
                        }
                    },
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::CodeDeploy::DeploymentConfig"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type"
            ],
            "type": "object"
        },
        "AWS::CodeDeploy::DeploymentConfig.MinimumHealthyHosts": {
            "additionalProperties": false,
            "properties": {
                "Type": {
                    "type": "string"
                },
                "Value": {
                    "type": "number"
                }
            },
            "required": [
                "Type",
                "Value"
            ],
            "type": "object"
        },
        "AWS::CodeDeploy::DeploymentGroup": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "AlarmConfiguration": {
                            "$ref": "#/definitions/AWS::CodeDeploy::DeploymentGroup.AlarmConfiguration"
                        },
                        "ApplicationName": {
                            "type": "string"
                        },
                        "AutoRollbackConfiguration": {
                            "$ref": "#/definitions/AWS::CodeDeploy::DeploymentGroup.AutoRollbackConfiguration"
                        },
                        "AutoScalingGroups": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "Deployment": {
                            "$ref": "#/definitions/AWS::CodeDeploy::DeploymentGroup.Deployment"
                        },
                        "DeploymentConfigName": {
                            "type": "string"
                        },
                        "DeploymentGroupName": {
                            "type": "string"
                        },
                        "DeploymentStyle": {
                            "$ref": "#/definitions/AWS::CodeDeploy::DeploymentGroup.DeploymentStyle"
                        },
                        "Ec2TagFilters": {
                            "items": {
                                "$ref": "#/definitions/AWS::CodeDeploy::DeploymentGroup.EC2TagFilter"
                            },
                            "type": "array"
                        },
                        "Ec2TagSet": {
                            "$ref": "#/definitions/AWS::CodeDeploy::DeploymentGroup.EC2TagSet"
                        },
                        "LoadBalancerInfo": {
                            "$ref": "#/definitions/AWS::CodeDeploy::DeploymentGroup.LoadBalancerInfo"
                        },
                        "OnPremisesInstanceTagFilters": {
                            "items": {
                                "$ref": "#/definitions/AWS::CodeDeploy::DeploymentGroup.TagFilter"
                            },
                            "type": "array"
                        },
                        "OnPremisesTagSet": {
                            "$ref": "#/definitions/AWS::CodeDeploy::DeploymentGroup.OnPremisesTagSet"
                        },
                        "ServiceRoleArn": {
                            "type": "string"
                        },
                        "TriggerConfigurations": {
                            "items": {
                                "$ref": "#/definitions/AWS::CodeDeploy::DeploymentGroup.TriggerConfig"
                            },
                            "type": "array"
                        }
                    },
                    "required": [
                        "ApplicationName",
                        "ServiceRoleArn"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::CodeDeploy::DeploymentGroup"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::CodeDeploy::DeploymentGroup.Alarm": {
            "additionalProperties": false,
            "properties": {
                "Name": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::CodeDeploy::DeploymentGroup.AlarmConfiguration": {
            "additionalProperties": false,
            "properties": {
                "Alarms": {
                    "items": {
                        "$ref": "#/definitions/AWS::CodeDeploy::DeploymentGroup.Alarm"
                    },
                    "type": "array"
                },
                "Enabled": {
                    "type": "boolean"
                },
                "IgnorePollAlarmFailure": {
                    "type": "boolean"
                }
            },
            "type": "object"
        },
        "AWS::CodeDeploy::DeploymentGroup.AutoRollbackConfiguration": {
            "additionalProperties": false,
            "properties": {
                "Enabled": {
                    "type": "boolean"
                },
                "Events": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                }
            },
            "type": "object"
        },
        "AWS::CodeDeploy::DeploymentGroup.Deployment": {
            "additionalProperties": false,
            "properties": {
                "Description": {
                    "type": "string"
                },
                "IgnoreApplicationStopFailures": {
                    "type": "boolean"
                },
                "Revision": {
                    "$ref": "#/definitions/AWS::CodeDeploy::DeploymentGroup.RevisionLocation"
                }
            },
            "required": [
                "Revision"
            ],
            "type": "object"
        },
        "AWS::CodeDeploy::DeploymentGroup.DeploymentStyle": {
            "additionalProperties": false,
            "properties": {
                "DeploymentOption": {
                    "type": "string"
                },
                "DeploymentType": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::CodeDeploy::DeploymentGroup.EC2TagFilter": {
            "additionalProperties": false,
            "properties": {
                "Key": {
                    "type": "string"
                },
                "Type": {
                    "type": "string"
                },
                "Value": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::CodeDeploy::DeploymentGroup.EC2TagSet": {
            "additionalProperties": false,
            "properties": {
                "Ec2TagSetList": {
                    "items": {
                        "$ref": "#/definitions/AWS::CodeDeploy::DeploymentGroup.EC2TagSetListObject"
                    },
                    "type": "array"
                }
            },
            "type": "object"
        },
        "AWS::CodeDeploy::DeploymentGroup.EC2TagSetListObject": {
            "additionalProperties": false,
            "properties": {
                "Ec2TagGroup": {
                    "items": {
                        "$ref": "#/definitions/AWS::CodeDeploy::DeploymentGroup.EC2TagFilter"
                    },
                    "type": "array"
                }
            },
            "type": "object"
        },
        "AWS::CodeDeploy::DeploymentGroup.ELBInfo": {
            "additionalProperties": false,
            "properties": {
                "Name": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::CodeDeploy::DeploymentGroup.GitHubLocation": {
            "additionalProperties": false,
            "properties": {
                "CommitId": {
                    "type": "string"
                },
                "Repository": {
                    "type": "string"
                }
            },
            "required": [
                "CommitId",
                "Repository"
            ],
            "type": "object"
        },
        "AWS::CodeDeploy::DeploymentGroup.LoadBalancerInfo": {
            "additionalProperties": false,
            "properties": {
                "ElbInfoList": {
                    "items": {
                        "$ref": "#/definitions/AWS::CodeDeploy::DeploymentGroup.ELBInfo"
                    },
                    "type": "array"
                },
                "TargetGroupInfoList": {
                    "items": {
                        "$ref": "#/definitions/AWS::CodeDeploy::DeploymentGroup.TargetGroupInfo"
                    },
                    "type": "array"
                }
            },
            "type": "object"
        },
        "AWS::CodeDeploy::DeploymentGroup.OnPremisesTagSet": {
            "additionalProperties": false,
            "properties": {
                "OnPremisesTagSetList": {
                    "items": {
                        "$ref": "#/definitions/AWS::CodeDeploy::DeploymentGroup.OnPremisesTagSetListObject"
                    },
                    "type": "array"
                }
            },
            "type": "object"
        },
        "AWS::CodeDeploy::DeploymentGroup.OnPremisesTagSetListObject": {
            "additionalProperties": false,
            "properties": {
                "OnPremisesTagGroup": {
                    "items": {
                        "$ref": "#/definitions/AWS::CodeDeploy::DeploymentGroup.TagFilter"
                    },
                    "type": "array"
                }
            },
            "type": "object"
        },
        "AWS::CodeDeploy::DeploymentGroup.RevisionLocation": {
            "additionalProperties": false,
            "properties": {
                "GitHubLocation": {
                    "$ref": "#/definitions/AWS::CodeDeploy::DeploymentGroup.GitHubLocation"
                },
                "RevisionType": {
                    "type": "string"
                },
                "S3Location": {
                    "$ref": "#/definitions/AWS::CodeDeploy::DeploymentGroup.S3Location"
                }
            },
            "type": "object"
        },
        "AWS::CodeDeploy::DeploymentGroup.S3Location": {
            "additionalProperties": false,
            "properties": {
                "Bucket": {
                    "type": "string"
                },
                "BundleType": {
                    "type": "string"
                },
                "ETag": {
                    "type": "string"
                },
                "Key": {
                    "type": "string"
                },
                "Version": {
                    "type": "string"
                }
            },
            "required": [
                "Bucket",
                "Key"
            ],
            "type": "object"
        },
        "AWS::CodeDeploy::DeploymentGroup.TagFilter": {
            "additionalProperties": false,
            "properties": {
                "Key": {
                    "type": "string"
                },
                "Type": {
                    "type": "string"
                },
                "Value": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::CodeDeploy::DeploymentGroup.TargetGroupInfo": {
            "additionalProperties": false,
            "properties": {
                "Name": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::CodeDeploy::DeploymentGroup.TriggerConfig": {
            "additionalProperties": false,
            "properties": {
                "TriggerEvents": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "TriggerName": {
                    "type": "string"
                },
                "TriggerTargetArn": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::CodePipeline::CustomActionType": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Category": {
                            "type": "string"
                        },
                        "ConfigurationProperties": {
                            "items": {
                                "$ref": "#/definitions/AWS::CodePipeline::CustomActionType.ConfigurationProperties"
                            },
                            "type": "array"
                        },
                        "InputArtifactDetails": {
                            "$ref": "#/definitions/AWS::CodePipeline::CustomActionType.ArtifactDetails"
                        },
                        "OutputArtifactDetails": {
                            "$ref": "#/definitions/AWS::CodePipeline::CustomActionType.ArtifactDetails"
                        },
                        "Provider": {
                            "type": "string"
                        },
                        "Settings": {
                            "$ref": "#/definitions/AWS::CodePipeline::CustomActionType.Settings"
                        },
                        "Version": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "Category",
                        "InputArtifactDetails",
                        "OutputArtifactDetails",
                        "Provider"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::CodePipeline::CustomActionType"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::CodePipeline::CustomActionType.ArtifactDetails": {
            "additionalProperties": false,
            "properties": {
                "MaximumCount": {
                    "type": "number"
                },
                "MinimumCount": {
                    "type": "number"
                }
            },
            "required": [
                "MaximumCount",
                "MinimumCount"
            ],
            "type": "object"
        },
        "AWS::CodePipeline::CustomActionType.ConfigurationProperties": {
            "additionalProperties": false,
            "properties": {
                "Description": {
                    "type": "string"
                },
                "Key": {
                    "type": "boolean"
                },
                "Name": {
                    "type": "string"
                },
                "Queryable": {
                    "type": "boolean"
                },
                "Required": {
                    "type": "boolean"
                },
                "Secret": {
                    "type": "boolean"
                },
                "Type": {
                    "type": "string"
                }
            },
            "required": [
                "Key",
                "Name",
                "Required",
                "Secret"
            ],
            "type": "object"
        },
        "AWS::CodePipeline::CustomActionType.Settings": {
            "additionalProperties": false,
            "properties": {
                "EntityUrlTemplate": {
                    "type": "string"
                },
                "ExecutionUrlTemplate": {
                    "type": "string"
                },
                "RevisionUrlTemplate": {
                    "type": "string"
                },
                "ThirdPartyConfigurationUrl": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::CodePipeline::Pipeline": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "ArtifactStore": {
                            "$ref": "#/definitions/AWS::CodePipeline::Pipeline.ArtifactStore"
                        },
                        "ArtifactStores": {
                            "items": {
                                "$ref": "#/definitions/AWS::CodePipeline::Pipeline.ArtifactStoreMap"
                            },
                            "type": "array"
                        },
                        "DisableInboundStageTransitions": {
                            "items": {
                                "$ref": "#/definitions/AWS::CodePipeline::Pipeline.StageTransition"
                            },
                            "type": "array"
                        },
                        "Name": {
                            "type": "string"
                        },
                        "RestartExecutionOnUpdate": {
                            "type": "boolean"
                        },
                        "RoleArn": {
                            "type": "string"
                        },
                        "Stages": {
                            "items": {
                                "$ref": "#/definitions/AWS::CodePipeline::Pipeline.StageDeclaration"
                            },
                            "type": "array"
                        }
                    },
                    "required": [
                        "RoleArn",
                        "Stages"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::CodePipeline::Pipeline"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::CodePipeline::Pipeline.ActionDeclaration": {
            "additionalProperties": false,
            "properties": {
                "ActionTypeId": {
                    "$ref": "#/definitions/AWS::CodePipeline::Pipeline.ActionTypeId"
                },
                "Configuration": {
                    "type": "object"
                },
                "InputArtifacts": {
                    "items": {
                        "$ref": "#/definitions/AWS::CodePipeline::Pipeline.InputArtifact"
                    },
                    "type": "array"
                },
                "Name": {
                    "type": "string"
                },
                "OutputArtifacts": {
                    "items": {
                        "$ref": "#/definitions/AWS::CodePipeline::Pipeline.OutputArtifact"
                    },
                    "type": "array"
                },
                "Region": {
                    "type": "string"
                },
                "RoleArn": {
                    "type": "string"
                },
                "RunOrder": {
                    "type": "number"
                }
            },
            "required": [
                "ActionTypeId",
                "Name"
            ],
            "type": "object"
        },
        "AWS::CodePipeline::Pipeline.ActionTypeId": {
            "additionalProperties": false,
            "properties": {
                "Category": {
                    "type": "string"
                },
                "Owner": {
                    "type": "string"
                },
                "Provider": {
                    "type": "string"
                },
                "Version": {
                    "type": "string"
                }
            },
            "required": [
                "Category",
                "Owner",
                "Provider",
                "Version"
            ],
            "type": "object"
        },
        "AWS::CodePipeline::Pipeline.ArtifactStore": {
            "additionalProperties": false,
            "properties": {
                "EncryptionKey": {
                    "$ref": "#/definitions/AWS::CodePipeline::Pipeline.EncryptionKey"
                },
                "Location": {
                    "type": "string"
                },
                "Type": {
                    "type": "string"
                }
            },
            "required": [
                "Location",
                "Type"
            ],
            "type": "object"
        },
        "AWS::CodePipeline::Pipeline.ArtifactStoreMap": {
            "additionalProperties": false,
            "properties": {
                "ArtifactStore": {
                    "$ref": "#/definitions/AWS::CodePipeline::Pipeline.ArtifactStore"
                },
                "Region": {
                    "type": "string"
                }
            },
            "required": [
                "ArtifactStore",
                "Region"
            ],
            "type": "object"
        },
        "AWS::CodePipeline::Pipeline.BlockerDeclaration": {
            "additionalProperties": false,
            "properties": {
                "Name": {
                    "type": "string"
                },
                "Type": {
                    "type": "string"
                }
            },
            "required": [
                "Name",
                "Type"
            ],
            "type": "object"
        },
        "AWS::CodePipeline::Pipeline.EncryptionKey": {
            "additionalProperties": false,
            "properties": {
                "Id": {
                    "type": "string"
                },
                "Type": {
                    "type": "string"
                }
            },
            "required": [
                "Id",
                "Type"
            ],
            "type": "object"
        },
        "AWS::CodePipeline::Pipeline.InputArtifact": {
            "additionalProperties": false,
            "properties": {
                "Name": {
                    "type": "string"
                }
            },
            "required": [
                "Name"
            ],
            "type": "object"
        },
        "AWS::CodePipeline::Pipeline.OutputArtifact": {
            "additionalProperties": false,
            "properties": {
                "Name": {
                    "type": "string"
                }
            },
            "required": [
                "Name"
            ],
            "type": "object"
        },
        "AWS::CodePipeline::Pipeline.StageDeclaration": {
            "additionalProperties": false,
            "properties": {
                "Actions": {
                    "items": {
                        "$ref": "#/definitions/AWS::CodePipeline::Pipeline.ActionDeclaration"
                    },
                    "type": "array"
                },
                "Blockers": {
                    "items": {
                        "$ref": "#/definitions/AWS::CodePipeline::Pipeline.BlockerDeclaration"
                    },
                    "type": "array"
                },
                "Name": {
                    "type": "string"
                }
            },
            "required": [
                "Actions",
                "Name"
            ],
            "type": "object"
        },
        "AWS::CodePipeline::Pipeline.StageTransition": {
            "additionalProperties": false,
            "properties": {
                "Reason": {
                    "type": "string"
                },
                "StageName": {
                    "type": "string"
                }
            },
            "required": [
                "Reason",
                "StageName"
            ],
            "type": "object"
        },
        "AWS::CodePipeline::Webhook": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Authentication": {
                            "type": "string"
                        },
                        "AuthenticationConfiguration": {
                            "$ref": "#/definitions/AWS::CodePipeline::Webhook.WebhookAuthConfiguration"
                        },
                        "Filters": {
                            "items": {
                                "$ref": "#/definitions/AWS::CodePipeline::Webhook.WebhookFilterRule"
                            },
                            "type": "array"
                        },
                        "Name": {
                            "type": "string"
                        },
                        "RegisterWithThirdParty": {
                            "type": "boolean"
                        },
                        "TargetAction": {
                            "type": "string"
                        },
                        "TargetPipeline": {
                            "type": "string"
                        },
                        "TargetPipelineVersion": {
                            "type": "number"
                        }
                    },
                    "required": [
                        "Authentication",
                        "AuthenticationConfiguration",
                        "Filters",
                        "TargetAction",
                        "TargetPipeline",
                        "TargetPipelineVersion"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::CodePipeline::Webhook"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::CodePipeline::Webhook.WebhookAuthConfiguration": {
            "additionalProperties": false,
            "properties": {
                "AllowedIPRange": {
                    "type": "string"
                },
                "SecretToken": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::CodePipeline::Webhook.WebhookFilterRule": {
            "additionalProperties": false,
            "properties": {
                "JsonPath": {
                    "type": "string"
                },
                "MatchEquals": {
                    "type": "string"
                }
            },
            "required": [
                "JsonPath"
            ],
            "type": "object"
        },
        "AWS::Cognito::IdentityPool": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "AllowUnauthenticatedIdentities": {
                            "type": "boolean"
                        },
                        "CognitoEvents": {
                            "type": "object"
                        },
                        "CognitoIdentityProviders": {
                            "items": {
                                "$ref": "#/definitions/AWS::Cognito::IdentityPool.CognitoIdentityProvider"
                            },
                            "type": "array"
                        },
                        "CognitoStreams": {
                            "$ref": "#/definitions/AWS::Cognito::IdentityPool.CognitoStreams"
                        },
                        "DeveloperProviderName": {
                            "type": "string"
                        },
                        "IdentityPoolName": {
                            "type": "string"
                        },
                        "OpenIdConnectProviderARNs": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "PushSync": {
                            "$ref": "#/definitions/AWS::Cognito::IdentityPool.PushSync"
                        },
                        "SamlProviderARNs": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "SupportedLoginProviders": {
                            "type": "object"
                        }
                    },
                    "required": [
                        "AllowUnauthenticatedIdentities"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::Cognito::IdentityPool"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::Cognito::IdentityPool.CognitoIdentityProvider": {
            "additionalProperties": false,
            "properties": {
                "ClientId": {
                    "type": "string"
                },
                "ProviderName": {
                    "type": "string"
                },
                "ServerSideTokenCheck": {
                    "type": "boolean"
                }
            },
            "type": "object"
        },
        "AWS::Cognito::IdentityPool.CognitoStreams": {
            "additionalProperties": false,
            "properties": {
                "RoleArn": {
                    "type": "string"
                },
                "StreamName": {
                    "type": "string"
                },
                "StreamingStatus": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::Cognito::IdentityPool.PushSync": {
            "additionalProperties": false,
            "properties": {
                "ApplicationArns": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "RoleArn": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::Cognito::IdentityPoolRoleAttachment": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "IdentityPoolId": {
                            "type": "string"
                        },
                        "RoleMappings": {
                            "type": "object"
                        },
                        "Roles": {
                            "type": "object"
                        }
                    },
                    "required": [
                        "IdentityPoolId"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::Cognito::IdentityPoolRoleAttachment"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::Cognito::IdentityPoolRoleAttachment.MappingRule": {
            "additionalProperties": false,
            "properties": {
                "Claim": {
                    "type": "string"
                },
                "MatchType": {
                    "type": "string"
                },
                "RoleARN": {
                    "type": "string"
                },
                "Value": {
                    "type": "string"
                }
            },
            "required": [
                "Claim",
                "MatchType",
                "RoleARN",
                "Value"
            ],
            "type": "object"
        },
        "AWS::Cognito::IdentityPoolRoleAttachment.RoleMapping": {
            "additionalProperties": false,
            "properties": {
                "AmbiguousRoleResolution": {
                    "type": "string"
                },
                "RulesConfiguration": {
                    "$ref": "#/definitions/AWS::Cognito::IdentityPoolRoleAttachment.RulesConfigurationType"
                },
                "Type": {
                    "type": "string"
                }
            },
            "required": [
                "Type"
            ],
            "type": "object"
        },
        "AWS::Cognito::IdentityPoolRoleAttachment.RulesConfigurationType": {
            "additionalProperties": false,
            "properties": {
                "Rules": {
                    "items": {
                        "$ref": "#/definitions/AWS::Cognito::IdentityPoolRoleAttachment.MappingRule"
                    },
                    "type": "array"
                }
            },
            "required": [
                "Rules"
            ],
            "type": "object"
        },
        "AWS::Cognito::UserPool": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "AdminCreateUserConfig": {
                            "$ref": "#/definitions/AWS::Cognito::UserPool.AdminCreateUserConfig"
                        },
                        "AliasAttributes": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "AutoVerifiedAttributes": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "DeviceConfiguration": {
                            "$ref": "#/definitions/AWS::Cognito::UserPool.DeviceConfiguration"
                        },
                        "EmailConfiguration": {
                            "$ref": "#/definitions/AWS::Cognito::UserPool.EmailConfiguration"
                        },
                        "EmailVerificationMessage": {
                            "type": "string"
                        },
                        "EmailVerificationSubject": {
                            "type": "string"
                        },
                        "LambdaConfig": {
                            "$ref": "#/definitions/AWS::Cognito::UserPool.LambdaConfig"
                        },
                        "MfaConfiguration": {
                            "type": "string"
                        },
                        "Policies": {
                            "$ref": "#/definitions/AWS::Cognito::UserPool.Policies"
                        },
                        "Schema": {
                            "items": {
                                "$ref": "#/definitions/AWS::Cognito::UserPool.SchemaAttribute"
                            },
                            "type": "array"
                        },
                        "SmsAuthenticationMessage": {
                            "type": "string"
                        },
                        "SmsConfiguration": {
                            "$ref": "#/definitions/AWS::Cognito::UserPool.SmsConfiguration"
                        },
                        "SmsVerificationMessage": {
                            "type": "string"
                        },
                        "UserPoolName": {
                            "type": "string"
                        },
                        "UserPoolTags": {
                            "type": "object"
                        },
                        "UsernameAttributes": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        }
                    },
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::Cognito::UserPool"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type"
            ],
            "type": "object"
        },
        "AWS::Cognito::UserPool.AdminCreateUserConfig": {
            "additionalProperties": false,
            "properties": {
                "AllowAdminCreateUserOnly": {
                    "type": "boolean"
                },
                "InviteMessageTemplate": {
                    "$ref": "#/definitions/AWS::Cognito::UserPool.InviteMessageTemplate"
                },
                "UnusedAccountValidityDays": {
                    "type": "number"
                }
            },
            "type": "object"
        },
        "AWS::Cognito::UserPool.DeviceConfiguration": {
            "additionalProperties": false,
            "properties": {
                "ChallengeRequiredOnNewDevice": {
                    "type": "boolean"
                },
                "DeviceOnlyRememberedOnUserPrompt": {
                    "type": "boolean"
                }
            },
            "type": "object"
        },
        "AWS::Cognito::UserPool.EmailConfiguration": {
            "additionalProperties": false,
            "properties": {
                "ReplyToEmailAddress": {
                    "type": "string"
                },
                "SourceArn": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::Cognito::UserPool.InviteMessageTemplate": {
            "additionalProperties": false,
            "properties": {
                "EmailMessage": {
                    "type": "string"
                },
                "EmailSubject": {
                    "type": "string"
                },
                "SMSMessage": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::Cognito::UserPool.LambdaConfig": {
            "additionalProperties": false,
            "properties": {
                "CreateAuthChallenge": {
                    "type": "string"
                },
                "CustomMessage": {
                    "type": "string"
                },
                "DefineAuthChallenge": {
                    "type": "string"
                },
                "PostAuthentication": {
                    "type": "string"
                },
                "PostConfirmation": {
                    "type": "string"
                },
                "PreAuthentication": {
                    "type": "string"
                },
                "PreSignUp": {
                    "type": "string"
                },
                "VerifyAuthChallengeResponse": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::Cognito::UserPool.NumberAttributeConstraints": {
            "additionalProperties": false,
            "properties": {
                "MaxValue": {
                    "type": "string"
                },
                "MinValue": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::Cognito::UserPool.PasswordPolicy": {
            "additionalProperties": false,
            "properties": {
                "MinimumLength": {
                    "type": "number"
                },
                "RequireLowercase": {
                    "type": "boolean"
                },
                "RequireNumbers": {
                    "type": "boolean"
                },
                "RequireSymbols": {
                    "type": "boolean"
                },
                "RequireUppercase": {
                    "type": "boolean"
                }
            },
            "type": "object"
        },
        "AWS::Cognito::UserPool.Policies": {
            "additionalProperties": false,
            "properties": {
                "PasswordPolicy": {
                    "$ref": "#/definitions/AWS::Cognito::UserPool.PasswordPolicy"
                }
            },
            "type": "object"
        },
        "AWS::Cognito::UserPool.SchemaAttribute": {
            "additionalProperties": false,
            "properties": {
                "AttributeDataType": {
                    "type": "string"
                },
                "DeveloperOnlyAttribute": {
                    "type": "boolean"
                },
                "Mutable": {
                    "type": "boolean"
                },
                "Name": {
                    "type": "string"
                },
                "NumberAttributeConstraints": {
                    "$ref": "#/definitions/AWS::Cognito::UserPool.NumberAttributeConstraints"
                },
                "Required": {
                    "type": "boolean"
                },
                "StringAttributeConstraints": {
                    "$ref": "#/definitions/AWS::Cognito::UserPool.StringAttributeConstraints"
                }
            },
            "type": "object"
        },
        "AWS::Cognito::UserPool.SmsConfiguration": {
            "additionalProperties": false,
            "properties": {
                "ExternalId": {
                    "type": "string"
                },
                "SnsCallerArn": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::Cognito::UserPool.StringAttributeConstraints": {
            "additionalProperties": false,
            "properties": {
                "MaxLength": {
                    "type": "string"
                },
                "MinLength": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::Cognito::UserPoolClient": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "ClientName": {
                            "type": "string"
                        },
                        "ExplicitAuthFlows": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "GenerateSecret": {
                            "type": "boolean"
                        },
                        "ReadAttributes": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "RefreshTokenValidity": {
                            "type": "number"
                        },
                        "UserPoolId": {
                            "type": "string"
                        },
                        "WriteAttributes": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        }
                    },
                    "required": [
                        "UserPoolId"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::Cognito::UserPoolClient"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::Cognito::UserPoolGroup": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Description": {
                            "type": "string"
                        },
                        "GroupName": {
                            "type": "string"
                        },
                        "Precedence": {
                            "type": "number"
                        },
                        "RoleArn": {
                            "type": "string"
                        },
                        "UserPoolId": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "UserPoolId"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::Cognito::UserPoolGroup"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::Cognito::UserPoolUser": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "DesiredDeliveryMediums": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "ForceAliasCreation": {
                            "type": "boolean"
                        },
                        "MessageAction": {
                            "type": "string"
                        },
                        "UserAttributes": {
                            "items": {
                                "$ref": "#/definitions/AWS::Cognito::UserPoolUser.AttributeType"
                            },
                            "type": "array"
                        },
                        "UserPoolId": {
                            "type": "string"
                        },
                        "Username": {
                            "type": "string"
                        },
                        "ValidationData": {
                            "items": {
                                "$ref": "#/definitions/AWS::Cognito::UserPoolUser.AttributeType"
                            },
                            "type": "array"
                        }
                    },
                    "required": [
                        "UserPoolId"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::Cognito::UserPoolUser"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::Cognito::UserPoolUser.AttributeType": {
            "additionalProperties": false,
            "properties": {
                "Name": {
                    "type": "string"
                },
                "Value": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::Cognito::UserPoolUserToGroupAttachment": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "GroupName": {
                            "type": "string"
                        },
                        "UserPoolId": {
                            "type": "string"
                        },
                        "Username": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "GroupName",
                        "UserPoolId",
                        "Username"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::Cognito::UserPoolUserToGroupAttachment"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::Config::AggregationAuthorization": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "AuthorizedAccountId": {
                            "type": "string"
                        },
                        "AuthorizedAwsRegion": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "AuthorizedAccountId",
                        "AuthorizedAwsRegion"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::Config::AggregationAuthorization"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::Config::ConfigRule": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "ConfigRuleName": {
                            "type": "string"
                        },
                        "Description": {
                            "type": "string"
                        },
                        "InputParameters": {
                            "type": "object"
                        },
                        "MaximumExecutionFrequency": {
                            "type": "string"
                        },
                        "Scope": {
                            "$ref": "#/definitions/AWS::Config::ConfigRule.Scope"
                        },
                        "Source": {
                            "$ref": "#/definitions/AWS::Config::ConfigRule.Source"
                        }
                    },
                    "required": [
                        "Source"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::Config::ConfigRule"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::Config::ConfigRule.Scope": {
            "additionalProperties": false,
            "properties": {
                "ComplianceResourceId": {
                    "type": "string"
                },
                "ComplianceResourceTypes": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "TagKey": {
                    "type": "string"
                },
                "TagValue": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::Config::ConfigRule.Source": {
            "additionalProperties": false,
            "properties": {
                "Owner": {
                    "type": "string"
                },
                "SourceDetails": {
                    "items": {
                        "$ref": "#/definitions/AWS::Config::ConfigRule.SourceDetail"
                    },
                    "type": "array"
                },
                "SourceIdentifier": {
                    "type": "string"
                }
            },
            "required": [
                "Owner",
                "SourceIdentifier"
            ],
            "type": "object"
        },
        "AWS::Config::ConfigRule.SourceDetail": {
            "additionalProperties": false,
            "properties": {
                "EventSource": {
                    "type": "string"
                },
                "MaximumExecutionFrequency": {
                    "type": "string"
                },
                "MessageType": {
                    "type": "string"
                }
            },
            "required": [
                "EventSource",
                "MessageType"
            ],
            "type": "object"
        },
        "AWS::Config::ConfigurationAggregator": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "AccountAggregationSources": {
                            "items": {
                                "$ref": "#/definitions/AWS::Config::ConfigurationAggregator.AccountAggregationSource"
                            },
                            "type": "array"
                        },
                        "ConfigurationAggregatorName": {
                            "type": "string"
                        },
                        "OrganizationAggregationSource": {
                            "$ref": "#/definitions/AWS::Config::ConfigurationAggregator.OrganizationAggregationSource"
                        }
                    },
                    "required": [
                        "ConfigurationAggregatorName"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::Config::ConfigurationAggregator"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::Config::ConfigurationAggregator.AccountAggregationSource": {
            "additionalProperties": false,
            "properties": {
                "AccountIds": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "AllAwsRegions": {
                    "type": "boolean"
                },
                "AwsRegions": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                }
            },
            "required": [
                "AccountIds"
            ],
            "type": "object"
        },
        "AWS::Config::ConfigurationAggregator.OrganizationAggregationSource": {
            "additionalProperties": false,
            "properties": {
                "AllAwsRegions": {
                    "type": "boolean"
                },
                "AwsRegions": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "RoleArn": {
                    "type": "string"
                }
            },
            "required": [
                "RoleArn"
            ],
            "type": "object"
        },
        "AWS::Config::ConfigurationRecorder": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Name": {
                            "type": "string"
                        },
                        "RecordingGroup": {
                            "$ref": "#/definitions/AWS::Config::ConfigurationRecorder.RecordingGroup"
                        },
                        "RoleARN": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "RoleARN"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::Config::ConfigurationRecorder"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::Config::ConfigurationRecorder.RecordingGroup": {
            "additionalProperties": false,
            "properties": {
                "AllSupported": {
                    "type": "boolean"
                },
                "IncludeGlobalResourceTypes": {
                    "type": "boolean"
                },
                "ResourceTypes": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                }
            },
            "type": "object"
        },
        "AWS::Config::DeliveryChannel": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "ConfigSnapshotDeliveryProperties": {
                            "$ref": "#/definitions/AWS::Config::DeliveryChannel.ConfigSnapshotDeliveryProperties"
                        },
                        "Name": {
                            "type": "string"
                        },
                        "S3BucketName": {
                            "type": "string"
                        },
                        "S3KeyPrefix": {
                            "type": "string"
                        },
                        "SnsTopicARN": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "S3BucketName"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::Config::DeliveryChannel"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::Config::DeliveryChannel.ConfigSnapshotDeliveryProperties": {
            "additionalProperties": false,
            "properties": {
                "DeliveryFrequency": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::DAX::Cluster": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "AvailabilityZones": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "ClusterName": {
                            "type": "string"
                        },
                        "Description": {
                            "type": "string"
                        },
                        "IAMRoleARN": {
                            "type": "string"
                        },
                        "NodeType": {
                            "type": "string"
                        },
                        "NotificationTopicARN": {
                            "type": "string"
                        },
                        "ParameterGroupName": {
                            "type": "string"
                        },
                        "PreferredMaintenanceWindow": {
                            "type": "string"
                        },
                        "ReplicationFactor": {
                            "type": "number"
                        },
                        "SSESpecification": {
                            "$ref": "#/definitions/AWS::DAX::Cluster.SSESpecification"
                        },
                        "SecurityGroupIds": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "SubnetGroupName": {
                            "type": "string"
                        },
                        "Tags": {
                            "type": "object"
                        }
                    },
                    "required": [
                        "IAMRoleARN",
                        "NodeType",
                        "ReplicationFactor"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::DAX::Cluster"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::DAX::Cluster.SSESpecification": {
            "additionalProperties": false,
            "properties": {
                "SSEEnabled": {
                    "type": "boolean"
                }
            },
            "type": "object"
        },
        "AWS::DAX::ParameterGroup": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Description": {
                            "type": "string"
                        },
                        "ParameterGroupName": {
                            "type": "string"
                        },
                        "ParameterNameValues": {
                            "type": "object"
                        }
                    },
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::DAX::ParameterGroup"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type"
            ],
            "type": "object"
        },
        "AWS::DAX::SubnetGroup": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Description": {
                            "type": "string"
                        },
                        "SubnetGroupName": {
                            "type": "string"
                        },
                        "SubnetIds": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        }
                    },
                    "required": [
                        "SubnetIds"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::DAX::SubnetGroup"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::DLM::LifecyclePolicy": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Description": {
                            "type": "string"
                        },
                        "ExecutionRoleArn": {
                            "type": "string"
                        },
                        "PolicyDetails": {
                            "$ref": "#/definitions/AWS::DLM::LifecyclePolicy.PolicyDetails"
                        },
                        "State": {
                            "type": "string"
                        }
                    },
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::DLM::LifecyclePolicy"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type"
            ],
            "type": "object"
        },
        "AWS::DLM::LifecyclePolicy.CreateRule": {
            "additionalProperties": false,
            "properties": {
                "Interval": {
                    "type": "number"
                },
                "IntervalUnit": {
                    "type": "string"
                },
                "Times": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                }
            },
            "required": [
                "Interval",
                "IntervalUnit"
            ],
            "type": "object"
        },
        "AWS::DLM::LifecyclePolicy.PolicyDetails": {
            "additionalProperties": false,
            "properties": {
                "ResourceTypes": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "Schedules": {
                    "items": {
                        "$ref": "#/definitions/AWS::DLM::LifecyclePolicy.Schedule"
                    },
                    "type": "array"
                },
                "TargetTags": {
                    "items": {
                        "$ref": "#/definitions/Tag"
                    },
                    "type": "array"
                }
            },
            "type": "object"
        },
        "AWS::DLM::LifecyclePolicy.RetainRule": {
            "additionalProperties": false,
            "properties": {
                "Count": {
                    "type": "number"
                }
            },
            "required": [
                "Count"
            ],
            "type": "object"
        },
        "AWS::DLM::LifecyclePolicy.Schedule": {
            "additionalProperties": false,
            "properties": {
                "CopyTags": {
                    "type": "boolean"
                },
                "CreateRule": {
                    "$ref": "#/definitions/AWS::DLM::LifecyclePolicy.CreateRule"
                },
                "Name": {
                    "type": "string"
                },
                "RetainRule": {
                    "$ref": "#/definitions/AWS::DLM::LifecyclePolicy.RetainRule"
                },
                "TagsToAdd": {
                    "items": {
                        "$ref": "#/definitions/Tag"
                    },
                    "type": "array"
                }
            },
            "type": "object"
        },
        "AWS::DMS::Certificate": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "CertificateIdentifier": {
                            "type": "string"
                        },
                        "CertificatePem": {
                            "type": "string"
                        },
                        "CertificateWallet": {
                            "type": "string"
                        }
                    },
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::DMS::Certificate"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type"
            ],
            "type": "object"
        },
        "AWS::DMS::Endpoint": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "CertificateArn": {
                            "type": "string"
                        },
                        "DatabaseName": {
                            "type": "string"
                        },
                        "DynamoDbSettings": {
                            "$ref": "#/definitions/AWS::DMS::Endpoint.DynamoDbSettings"
                        },
                        "ElasticsearchSettings": {
                            "$ref": "#/definitions/AWS::DMS::Endpoint.ElasticsearchSettings"
                        },
                        "EndpointIdentifier": {
                            "type": "string"
                        },
                        "EndpointType": {
                            "type": "string"
                        },
                        "EngineName": {
                            "type": "string"
                        },
                        "ExtraConnectionAttributes": {
                            "type": "string"
                        },
                        "KinesisSettings": {
                            "$ref": "#/definitions/AWS::DMS::Endpoint.KinesisSettings"
                        },
                        "KmsKeyId": {
                            "type": "string"
                        },
                        "MongoDbSettings": {
                            "$ref": "#/definitions/AWS::DMS::Endpoint.MongoDbSettings"
                        },
                        "Password": {
                            "type": "string"
                        },
                        "Port": {
                            "type": "number"
                        },
                        "S3Settings": {
                            "$ref": "#/definitions/AWS::DMS::Endpoint.S3Settings"
                        },
                        "ServerName": {
                            "type": "string"
                        },
                        "SslMode": {
                            "type": "string"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        },
                        "Username": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "EndpointType",
                        "EngineName"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::DMS::Endpoint"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::DMS::Endpoint.DynamoDbSettings": {
            "additionalProperties": false,
            "properties": {
                "ServiceAccessRoleArn": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::DMS::Endpoint.ElasticsearchSettings": {
            "additionalProperties": false,
            "properties": {
                "EndpointUri": {
                    "type": "string"
                },
                "ErrorRetryDuration": {
                    "type": "number"
                },
                "FullLoadErrorPercentage": {
                    "type": "number"
                },
                "ServiceAccessRoleArn": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::DMS::Endpoint.KinesisSettings": {
            "additionalProperties": false,
            "properties": {
                "MessageFormat": {
                    "type": "string"
                },
                "ServiceAccessRoleArn": {
                    "type": "string"
                },
                "StreamArn": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::DMS::Endpoint.MongoDbSettings": {
            "additionalProperties": false,
            "properties": {
                "AuthMechanism": {
                    "type": "string"
                },
                "AuthSource": {
                    "type": "string"
                },
                "AuthType": {
                    "type": "string"
                },
                "DatabaseName": {
                    "type": "string"
                },
                "DocsToInvestigate": {
                    "type": "string"
                },
                "ExtractDocId": {
                    "type": "string"
                },
                "NestingLevel": {
                    "type": "string"
                },
                "Password": {
                    "type": "string"
                },
                "Port": {
                    "type": "number"
                },
                "ServerName": {
                    "type": "string"
                },
                "Username": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::DMS::Endpoint.S3Settings": {
            "additionalProperties": false,
            "properties": {
                "BucketFolder": {
                    "type": "string"
                },
                "BucketName": {
                    "type": "string"
                },
                "CompressionType": {
                    "type": "string"
                },
                "CsvDelimiter": {
                    "type": "string"
                },
                "CsvRowDelimiter": {
                    "type": "string"
                },
                "ExternalTableDefinition": {
                    "type": "string"
                },
                "ServiceAccessRoleArn": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::DMS::EventSubscription": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Enabled": {
                            "type": "boolean"
                        },
                        "EventCategories": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "SnsTopicArn": {
                            "type": "string"
                        },
                        "SourceIds": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "SourceType": {
                            "type": "string"
                        },
                        "SubscriptionName": {
                            "type": "string"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        }
                    },
                    "required": [
                        "SnsTopicArn"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::DMS::EventSubscription"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::DMS::ReplicationInstance": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "AllocatedStorage": {
                            "type": "number"
                        },
                        "AllowMajorVersionUpgrade": {
                            "type": "boolean"
                        },
                        "AutoMinorVersionUpgrade": {
                            "type": "boolean"
                        },
                        "AvailabilityZone": {
                            "type": "string"
                        },
                        "EngineVersion": {
                            "type": "string"
                        },
                        "KmsKeyId": {
                            "type": "string"
                        },
                        "MultiAZ": {
                            "type": "boolean"
                        },
                        "PreferredMaintenanceWindow": {
                            "type": "string"
                        },
                        "PubliclyAccessible": {
                            "type": "boolean"
                        },
                        "ReplicationInstanceClass": {
                            "type": "string"
                        },
                        "ReplicationInstanceIdentifier": {
                            "type": "string"
                        },
                        "ReplicationSubnetGroupIdentifier": {
                            "type": "string"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        },
                        "VpcSecurityGroupIds": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        }
                    },
                    "required": [
                        "ReplicationInstanceClass"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::DMS::ReplicationInstance"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::DMS::ReplicationSubnetGroup": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "ReplicationSubnetGroupDescription": {
                            "type": "string"
                        },
                        "ReplicationSubnetGroupIdentifier": {
                            "type": "string"
                        },
                        "SubnetIds": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        }
                    },
                    "required": [
                        "ReplicationSubnetGroupDescription",
                        "SubnetIds"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::DMS::ReplicationSubnetGroup"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::DMS::ReplicationTask": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "CdcStartTime": {
                            "type": "number"
                        },
                        "MigrationType": {
                            "type": "string"
                        },
                        "ReplicationInstanceArn": {
                            "type": "string"
                        },
                        "ReplicationTaskIdentifier": {
                            "type": "string"
                        },
                        "ReplicationTaskSettings": {
                            "type": "string"
                        },
                        "SourceEndpointArn": {
                            "type": "string"
                        },
                        "TableMappings": {
                            "type": "string"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        },
                        "TargetEndpointArn": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "MigrationType",
                        "ReplicationInstanceArn",
                        "SourceEndpointArn",
                        "TableMappings",
                        "TargetEndpointArn"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::DMS::ReplicationTask"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::DataPipeline::Pipeline": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Activate": {
                            "type": "boolean"
                        },
                        "Description": {
                            "type": "string"
                        },
                        "Name": {
                            "type": "string"
                        },
                        "ParameterObjects": {
                            "items": {
                                "$ref": "#/definitions/AWS::DataPipeline::Pipeline.ParameterObject"
                            },
                            "type": "array"
                        },
                        "ParameterValues": {
                            "items": {
                                "$ref": "#/definitions/AWS::DataPipeline::Pipeline.ParameterValue"
                            },
                            "type": "array"
                        },
                        "PipelineObjects": {
                            "items": {
                                "$ref": "#/definitions/AWS::DataPipeline::Pipeline.PipelineObject"
                            },
                            "type": "array"
                        },
                        "PipelineTags": {
                            "items": {
                                "$ref": "#/definitions/AWS::DataPipeline::Pipeline.PipelineTag"
                            },
                            "type": "array"
                        }
                    },
                    "required": [
                        "Name",
                        "ParameterObjects"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::DataPipeline::Pipeline"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::DataPipeline::Pipeline.Field": {
            "additionalProperties": false,
            "properties": {
                "Key": {
                    "type": "string"
                },
                "RefValue": {
                    "type": "string"
                },
                "StringValue": {
                    "type": "string"
                }
            },
            "required": [
                "Key"
            ],
            "type": "object"
        },
        "AWS::DataPipeline::Pipeline.ParameterAttribute": {
            "additionalProperties": false,
            "properties": {
                "Key": {
                    "type": "string"
                },
                "StringValue": {
                    "type": "string"
                }
            },
            "required": [
                "Key",
                "StringValue"
            ],
            "type": "object"
        },
        "AWS::DataPipeline::Pipeline.ParameterObject": {
            "additionalProperties": false,
            "properties": {
                "Attributes": {
                    "items": {
                        "$ref": "#/definitions/AWS::DataPipeline::Pipeline.ParameterAttribute"
                    },
                    "type": "array"
                },
                "Id": {
                    "type": "string"
                }
            },
            "required": [
                "Attributes",
                "Id"
            ],
            "type": "object"
        },
        "AWS::DataPipeline::Pipeline.ParameterValue": {
            "additionalProperties": false,
            "properties": {
                "Id": {
                    "type": "string"
                },
                "StringValue": {
                    "type": "string"
                }
            },
            "required": [
                "Id",
                "StringValue"
            ],
            "type": "object"
        },
        "AWS::DataPipeline::Pipeline.PipelineObject": {
            "additionalProperties": false,
            "properties": {
                "Fields": {
                    "items": {
                        "$ref": "#/definitions/AWS::DataPipeline::Pipeline.Field"
                    },
                    "type": "array"
                },
                "Id": {
                    "type": "string"
                },
                "Name": {
                    "type": "string"
                }
            },
            "required": [
                "Fields",
                "Id",
                "Name"
            ],
            "type": "object"
        },
        "AWS::DataPipeline::Pipeline.PipelineTag": {
            "additionalProperties": false,
            "properties": {
                "Key": {
                    "type": "string"
                },
                "Value": {
                    "type": "string"
                }
            },
            "required": [
                "Key",
                "Value"
            ],
            "type": "object"
        },
        "AWS::DirectoryService::MicrosoftAD": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "CreateAlias": {
                            "type": "boolean"
                        },
                        "Edition": {
                            "type": "string"
                        },
                        "EnableSso": {
                            "type": "boolean"
                        },
                        "Name": {
                            "type": "string"
                        },
                        "Password": {
                            "type": "string"
                        },
                        "ShortName": {
                            "type": "string"
                        },
                        "VpcSettings": {
                            "$ref": "#/definitions/AWS::DirectoryService::MicrosoftAD.VpcSettings"
                        }
                    },
                    "required": [
                        "Name",
                        "Password",
                        "VpcSettings"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::DirectoryService::MicrosoftAD"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::DirectoryService::MicrosoftAD.VpcSettings": {
            "additionalProperties": false,
            "properties": {
                "SubnetIds": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "VpcId": {
                    "type": "string"
                }
            },
            "required": [
                "SubnetIds",
                "VpcId"
            ],
            "type": "object"
        },
        "AWS::DirectoryService::SimpleAD": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "CreateAlias": {
                            "type": "boolean"
                        },
                        "Description": {
                            "type": "string"
                        },
                        "EnableSso": {
                            "type": "boolean"
                        },
                        "Name": {
                            "type": "string"
                        },
                        "Password": {
                            "type": "string"
                        },
                        "ShortName": {
                            "type": "string"
                        },
                        "Size": {
                            "type": "string"
                        },
                        "VpcSettings": {
                            "$ref": "#/definitions/AWS::DirectoryService::SimpleAD.VpcSettings"
                        }
                    },
                    "required": [
                        "Name",
                        "Password",
                        "Size",
                        "VpcSettings"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::DirectoryService::SimpleAD"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::DirectoryService::SimpleAD.VpcSettings": {
            "additionalProperties": false,
            "properties": {
                "SubnetIds": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "VpcId": {
                    "type": "string"
                }
            },
            "required": [
                "SubnetIds",
                "VpcId"
            ],
            "type": "object"
        },
        "AWS::DocDB::DBCluster": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "AvailabilityZones": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "BackupRetentionPeriod": {
                            "type": "number"
                        },
                        "DBClusterIdentifier": {
                            "type": "string"
                        },
                        "DBClusterParameterGroupName": {
                            "type": "string"
                        },
                        "DBSubnetGroupName": {
                            "type": "string"
                        },
                        "EngineVersion": {
                            "type": "string"
                        },
                        "KmsKeyId": {
                            "type": "string"
                        },
                        "MasterUserPassword": {
                            "type": "string"
                        },
                        "MasterUsername": {
                            "type": "string"
                        },
                        "Port": {
                            "type": "number"
                        },
                        "PreferredBackupWindow": {
                            "type": "string"
                        },
                        "PreferredMaintenanceWindow": {
                            "type": "string"
                        },
                        "SnapshotIdentifier": {
                            "type": "string"
                        },
                        "StorageEncrypted": {
                            "type": "boolean"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        },
                        "VpcSecurityGroupIds": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        }
                    },
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::DocDB::DBCluster"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type"
            ],
            "type": "object"
        },
        "AWS::DocDB::DBClusterParameterGroup": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Description": {
                            "type": "string"
                        },
                        "Family": {
                            "type": "string"
                        },
                        "Name": {
                            "type": "string"
                        },
                        "Parameters": {
                            "type": "object"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        }
                    },
                    "required": [
                        "Description",
                        "Family",
                        "Parameters"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::DocDB::DBClusterParameterGroup"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::DocDB::DBInstance": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "AutoMinorVersionUpgrade": {
                            "type": "boolean"
                        },
                        "AvailabilityZone": {
                            "type": "string"
                        },
                        "DBClusterIdentifier": {
                            "type": "string"
                        },
                        "DBInstanceClass": {
                            "type": "string"
                        },
                        "DBInstanceIdentifier": {
                            "type": "string"
                        },
                        "PreferredMaintenanceWindow": {
                            "type": "string"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        }
                    },
                    "required": [
                        "DBClusterIdentifier",
                        "DBInstanceClass"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::DocDB::DBInstance"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::DocDB::DBSubnetGroup": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "DBSubnetGroupDescription": {
                            "type": "string"
                        },
                        "DBSubnetGroupName": {
                            "type": "string"
                        },
                        "SubnetIds": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        }
                    },
                    "required": [
                        "DBSubnetGroupDescription",
                        "SubnetIds"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::DocDB::DBSubnetGroup"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::DynamoDB::Table": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "AttributeDefinitions": {
                            "items": {
                                "$ref": "#/definitions/AWS::DynamoDB::Table.AttributeDefinition"
                            },
                            "type": "array"
                        },
                        "BillingMode": {
                            "type": "string"
                        },
                        "GlobalSecondaryIndexes": {
                            "items": {
                                "$ref": "#/definitions/AWS::DynamoDB::Table.GlobalSecondaryIndex"
                            },
                            "type": "array"
                        },
                        "KeySchema": {
                            "items": {
                                "$ref": "#/definitions/AWS::DynamoDB::Table.KeySchema"
                            },
                            "type": "array"
                        },
                        "LocalSecondaryIndexes": {
                            "items": {
                                "$ref": "#/definitions/AWS::DynamoDB::Table.LocalSecondaryIndex"
                            },
                            "type": "array"
                        },
                        "PointInTimeRecoverySpecification": {
                            "$ref": "#/definitions/AWS::DynamoDB::Table.PointInTimeRecoverySpecification"
                        },
                        "ProvisionedThroughput": {
                            "$ref": "#/definitions/AWS::DynamoDB::Table.ProvisionedThroughput"
                        },
                        "SSESpecification": {
                            "$ref": "#/definitions/AWS::DynamoDB::Table.SSESpecification"
                        },
                        "StreamSpecification": {
                            "$ref": "#/definitions/AWS::DynamoDB::Table.StreamSpecification"
                        },
                        "TableName": {
                            "type": "string"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        },
                        "TimeToLiveSpecification": {
                            "$ref": "#/definitions/AWS::DynamoDB::Table.TimeToLiveSpecification"
                        }
                    },
                    "required": [
                        "KeySchema"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::DynamoDB::Table"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::DynamoDB::Table.AttributeDefinition": {
            "additionalProperties": false,
            "properties": {
                "AttributeName": {
                    "type": "string"
                },
                "AttributeType": {
                    "type": "string"
                }
            },
            "required": [
                "AttributeName",
                "AttributeType"
            ],
            "type": "object"
        },
        "AWS::DynamoDB::Table.GlobalSecondaryIndex": {
            "additionalProperties": false,
            "properties": {
                "IndexName": {
                    "type": "string"
                },
                "KeySchema": {
                    "items": {
                        "$ref": "#/definitions/AWS::DynamoDB::Table.KeySchema"
                    },
                    "type": "array"
                },
                "Projection": {
                    "$ref": "#/definitions/AWS::DynamoDB::Table.Projection"
                },
                "ProvisionedThroughput": {
                    "$ref": "#/definitions/AWS::DynamoDB::Table.ProvisionedThroughput"
                }
            },
            "required": [
                "IndexName",
                "KeySchema",
                "Projection"
            ],
            "type": "object"
        },
        "AWS::DynamoDB::Table.KeySchema": {
            "additionalProperties": false,
            "properties": {
                "AttributeName": {
                    "type": "string"
                },
                "KeyType": {
                    "type": "string"
                }
            },
            "required": [
                "AttributeName",
                "KeyType"
            ],
            "type": "object"
        },
        "AWS::DynamoDB::Table.LocalSecondaryIndex": {
            "additionalProperties": false,
            "properties": {
                "IndexName": {
                    "type": "string"
                },
                "KeySchema": {
                    "items": {
                        "$ref": "#/definitions/AWS::DynamoDB::Table.KeySchema"
                    },
                    "type": "array"
                },
                "Projection": {
                    "$ref": "#/definitions/AWS::DynamoDB::Table.Projection"
                }
            },
            "required": [
                "IndexName",
                "KeySchema",
                "Projection"
            ],
            "type": "object"
        },
        "AWS::DynamoDB::Table.PointInTimeRecoverySpecification": {
            "additionalProperties": false,
            "properties": {
                "PointInTimeRecoveryEnabled": {
                    "type": "boolean"
                }
            },
            "type": "object"
        },
        "AWS::DynamoDB::Table.Projection": {
            "additionalProperties": false,
            "properties": {
                "NonKeyAttributes": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "ProjectionType": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::DynamoDB::Table.ProvisionedThroughput": {
            "additionalProperties": false,
            "properties": {
                "ReadCapacityUnits": {
                    "type": "number"
                },
                "WriteCapacityUnits": {
                    "type": "number"
                }
            },
            "required": [
                "ReadCapacityUnits",
                "WriteCapacityUnits"
            ],
            "type": "object"
        },
        "AWS::DynamoDB::Table.SSESpecification": {
            "additionalProperties": false,
            "properties": {
                "SSEEnabled": {
                    "type": "boolean"
                }
            },
            "required": [
                "SSEEnabled"
            ],
            "type": "object"
        },
        "AWS::DynamoDB::Table.StreamSpecification": {
            "additionalProperties": false,
            "properties": {
                "StreamViewType": {
                    "type": "string"
                }
            },
            "required": [
                "StreamViewType"
            ],
            "type": "object"
        },
        "AWS::DynamoDB::Table.TimeToLiveSpecification": {
            "additionalProperties": false,
            "properties": {
                "AttributeName": {
                    "type": "string"
                },
                "Enabled": {
                    "type": "boolean"
                }
            },
            "required": [
                "AttributeName",
                "Enabled"
            ],
            "type": "object"
        },
        "AWS::EC2::CustomerGateway": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "BgpAsn": {
                            "type": "number"
                        },
                        "IpAddress": {
                            "type": "string"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        },
                        "Type": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "BgpAsn",
                        "IpAddress",
                        "Type"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EC2::CustomerGateway"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::EC2::DHCPOptions": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "DomainName": {
                            "type": "string"
                        },
                        "DomainNameServers": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "NetbiosNameServers": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "NetbiosNodeType": {
                            "type": "number"
                        },
                        "NtpServers": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        }
                    },
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EC2::DHCPOptions"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type"
            ],
            "type": "object"
        },
        "AWS::EC2::EC2Fleet": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "ExcessCapacityTerminationPolicy": {
                            "type": "string"
                        },
                        "LaunchTemplateConfigs": {
                            "items": {
                                "$ref": "#/definitions/AWS::EC2::EC2Fleet.FleetLaunchTemplateConfigRequest"
                            },
                            "type": "array"
                        },
                        "OnDemandOptions": {
                            "$ref": "#/definitions/AWS::EC2::EC2Fleet.OnDemandOptionsRequest"
                        },
                        "ReplaceUnhealthyInstances": {
                            "type": "boolean"
                        },
                        "SpotOptions": {
                            "$ref": "#/definitions/AWS::EC2::EC2Fleet.SpotOptionsRequest"
                        },
                        "TagSpecifications": {
                            "items": {
                                "$ref": "#/definitions/AWS::EC2::EC2Fleet.TagSpecification"
                            },
                            "type": "array"
                        },
                        "TargetCapacitySpecification": {
                            "$ref": "#/definitions/AWS::EC2::EC2Fleet.TargetCapacitySpecificationRequest"
                        },
                        "TerminateInstancesWithExpiration": {
                            "type": "boolean"
                        },
                        "Type": {
                            "type": "string"
                        },
                        "ValidFrom": {
                            "type": "string"
                        },
                        "ValidUntil": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "LaunchTemplateConfigs",
                        "TargetCapacitySpecification"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EC2::EC2Fleet"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::EC2::EC2Fleet.FleetLaunchTemplateConfigRequest": {
            "additionalProperties": false,
            "properties": {
                "LaunchTemplateSpecification": {
                    "$ref": "#/definitions/AWS::EC2::EC2Fleet.FleetLaunchTemplateSpecificationRequest"
                },
                "Overrides": {
                    "items": {
                        "$ref": "#/definitions/AWS::EC2::EC2Fleet.FleetLaunchTemplateOverridesRequest"
                    },
                    "type": "array"
                }
            },
            "type": "object"
        },
        "AWS::EC2::EC2Fleet.FleetLaunchTemplateOverridesRequest": {
            "additionalProperties": false,
            "properties": {
                "AvailabilityZone": {
                    "type": "string"
                },
                "InstanceType": {
                    "type": "string"
                },
                "MaxPrice": {
                    "type": "string"
                },
                "Priority": {
                    "type": "number"
                },
                "SubnetId": {
                    "type": "string"
                },
                "WeightedCapacity": {
                    "type": "number"
                }
            },
            "type": "object"
        },
        "AWS::EC2::EC2Fleet.FleetLaunchTemplateSpecificationRequest": {
            "additionalProperties": false,
            "properties": {
                "LaunchTemplateId": {
                    "type": "string"
                },
                "LaunchTemplateName": {
                    "type": "string"
                },
                "Version": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::EC2::EC2Fleet.OnDemandOptionsRequest": {
            "additionalProperties": false,
            "properties": {
                "AllocationStrategy": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::EC2::EC2Fleet.SpotOptionsRequest": {
            "additionalProperties": false,
            "properties": {
                "AllocationStrategy": {
                    "type": "string"
                },
                "InstanceInterruptionBehavior": {
                    "type": "string"
                },
                "InstancePoolsToUseCount": {
                    "type": "number"
                }
            },
            "type": "object"
        },
        "AWS::EC2::EC2Fleet.TagRequest": {
            "additionalProperties": false,
            "properties": {
                "Key": {
                    "type": "string"
                },
                "Value": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::EC2::EC2Fleet.TagSpecification": {
            "additionalProperties": false,
            "properties": {
                "ResourceType": {
                    "type": "string"
                },
                "Tags": {
                    "items": {
                        "$ref": "#/definitions/AWS::EC2::EC2Fleet.TagRequest"
                    },
                    "type": "array"
                }
            },
            "type": "object"
        },
        "AWS::EC2::EC2Fleet.TargetCapacitySpecificationRequest": {
            "additionalProperties": false,
            "properties": {
                "DefaultTargetCapacityType": {
                    "type": "string"
                },
                "OnDemandTargetCapacity": {
                    "type": "number"
                },
                "SpotTargetCapacity": {
                    "type": "number"
                },
                "TotalTargetCapacity": {
                    "type": "number"
                }
            },
            "required": [
                "TotalTargetCapacity"
            ],
            "type": "object"
        },
        "AWS::EC2::EIP": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Domain": {
                            "type": "string"
                        },
                        "InstanceId": {
                            "type": "string"
                        },
                        "PublicIpv4Pool": {
                            "type": "string"
                        }
                    },
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EC2::EIP"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type"
            ],
            "type": "object"
        },
        "AWS::EC2::EIPAssociation": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "AllocationId": {
                            "type": "string"
                        },
                        "EIP": {
                            "type": "string"
                        },
                        "InstanceId": {
                            "type": "string"
                        },
                        "NetworkInterfaceId": {
                            "type": "string"
                        },
                        "PrivateIpAddress": {
                            "type": "string"
                        }
                    },
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EC2::EIPAssociation"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type"
            ],
            "type": "object"
        },
        "AWS::EC2::EgressOnlyInternetGateway": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "VpcId": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "VpcId"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EC2::EgressOnlyInternetGateway"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::EC2::FlowLog": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "DeliverLogsPermissionArn": {
                            "type": "string"
                        },
                        "LogDestination": {
                            "type": "string"
                        },
                        "LogDestinationType": {
                            "type": "string"
                        },
                        "LogGroupName": {
                            "type": "string"
                        },
                        "ResourceId": {
                            "type": "string"
                        },
                        "ResourceType": {
                            "type": "string"
                        },
                        "TrafficType": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "ResourceId",
                        "ResourceType",
                        "TrafficType"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EC2::FlowLog"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::EC2::Host": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "AutoPlacement": {
                            "type": "string"
                        },
                        "AvailabilityZone": {
                            "type": "string"
                        },
                        "InstanceType": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "AvailabilityZone",
                        "InstanceType"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EC2::Host"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::EC2::Instance": {
            "additionalProperties": false,
            "properties": {
                "CreationPolicy": {
                    "type": "object"
                },
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "AdditionalInfo": {
                            "type": "string"
                        },
                        "Affinity": {
                            "type": "string"
                        },
                        "AvailabilityZone": {
                            "type": "string"
                        },
                        "BlockDeviceMappings": {
                            "items": {
                                "$ref": "#/definitions/AWS::EC2::Instance.BlockDeviceMapping"
                            },
                            "type": "array"
                        },
                        "CreditSpecification": {
                            "$ref": "#/definitions/AWS::EC2::Instance.CreditSpecification"
                        },
                        "DisableApiTermination": {
                            "type": "boolean"
                        },
                        "EbsOptimized": {
                            "type": "boolean"
                        },
                        "ElasticGpuSpecifications": {
                            "items": {
                                "$ref": "#/definitions/AWS::EC2::Instance.ElasticGpuSpecification"
                            },
                            "type": "array"
                        },
                        "ElasticInferenceAccelerators": {
                            "items": {
                                "$ref": "#/definitions/AWS::EC2::Instance.ElasticInferenceAccelerator"
                            },
                            "type": "array"
                        },
                        "HostId": {
                            "type": "string"
                        },
                        "IamInstanceProfile": {
                            "type": "string"
                        },
                        "ImageId": {
                            "type": "string"
                        },
                        "InstanceInitiatedShutdownBehavior": {
                            "type": "string"
                        },
                        "InstanceType": {
                            "type": "string"
                        },
                        "Ipv6AddressCount": {
                            "type": "number"
                        },
                        "Ipv6Addresses": {
                            "items": {
                                "$ref": "#/definitions/AWS::EC2::Instance.InstanceIpv6Address"
                            },
                            "type": "array"
                        },
                        "KernelId": {
                            "type": "string"
                        },
                        "KeyName": {
                            "type": "string"
                        },
                        "LaunchTemplate": {
                            "$ref": "#/definitions/AWS::EC2::Instance.LaunchTemplateSpecification"
                        },
                        "LicenseSpecifications": {
                            "items": {
                                "$ref": "#/definitions/AWS::EC2::Instance.LicenseSpecification"
                            },
                            "type": "array"
                        },
                        "Monitoring": {
                            "type": "boolean"
                        },
                        "NetworkInterfaces": {
                            "items": {
                                "$ref": "#/definitions/AWS::EC2::Instance.NetworkInterface"
                            },
                            "type": "array"
                        },
                        "PlacementGroupName": {
                            "type": "string"
                        },
                        "PrivateIpAddress": {
                            "type": "string"
                        },
                        "RamdiskId": {
                            "type": "string"
                        },
                        "SecurityGroupIds": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "SecurityGroups": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "SourceDestCheck": {
                            "type": "boolean"
                        },
                        "SsmAssociations": {
                            "items": {
                                "$ref": "#/definitions/AWS::EC2::Instance.SsmAssociation"
                            },
                            "type": "array"
                        },
                        "SubnetId": {
                            "type": "string"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        },
                        "Tenancy": {
                            "type": "string"
                        },
                        "UserData": {
                            "type": "string"
                        },
                        "Volumes": {
                            "items": {
                                "$ref": "#/definitions/AWS::EC2::Instance.Volume"
                            },
                            "type": "array"
                        }
                    },
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EC2::Instance"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type"
            ],
            "type": "object"
        },
        "AWS::EC2::Instance.AssociationParameter": {
            "additionalProperties": false,
            "properties": {
                "Key": {
                    "type": "string"
                },
                "Value": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                }
            },
            "required": [
                "Key",
                "Value"
            ],
            "type": "object"
        },
        "AWS::EC2::Instance.BlockDeviceMapping": {
            "additionalProperties": false,
            "properties": {
                "DeviceName": {
                    "type": "string"
                },
                "Ebs": {
                    "$ref": "#/definitions/AWS::EC2::Instance.Ebs"
                },
                "NoDevice": {
                    "$ref": "#/definitions/AWS::EC2::Instance.NoDevice"
                },
                "VirtualName": {
                    "type": "string"
                }
            },
            "required": [
                "DeviceName"
            ],
            "type": "object"
        },
        "AWS::EC2::Instance.CreditSpecification": {
            "additionalProperties": false,
            "properties": {
                "CPUCredits": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::EC2::Instance.Ebs": {
            "additionalProperties": false,
            "properties": {
                "DeleteOnTermination": {
                    "type": "boolean"
                },
                "Encrypted": {
                    "type": "boolean"
                },
                "Iops": {
                    "type": "number"
                },
                "SnapshotId": {
                    "type": "string"
                },
                "VolumeSize": {
                    "type": "number"
                },
                "VolumeType": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::EC2::Instance.ElasticGpuSpecification": {
            "additionalProperties": false,
            "properties": {
                "Type": {
                    "type": "string"
                }
            },
            "required": [
                "Type"
            ],
            "type": "object"
        },
        "AWS::EC2::Instance.ElasticInferenceAccelerator": {
            "additionalProperties": false,
            "properties": {
                "Type": {
                    "type": "string"
                }
            },
            "required": [
                "Type"
            ],
            "type": "object"
        },
        "AWS::EC2::Instance.InstanceIpv6Address": {
            "additionalProperties": false,
            "properties": {
                "Ipv6Address": {
                    "type": "string"
                }
            },
            "required": [
                "Ipv6Address"
            ],
            "type": "object"
        },
        "AWS::EC2::Instance.LaunchTemplateSpecification": {
            "additionalProperties": false,
            "properties": {
                "LaunchTemplateId": {
                    "type": "string"
                },
                "LaunchTemplateName": {
                    "type": "string"
                },
                "Version": {
                    "type": "string"
                }
            },
            "required": [
                "Version"
            ],
            "type": "object"
        },
        "AWS::EC2::Instance.LicenseSpecification": {
            "additionalProperties": false,
            "properties": {
                "LicenseConfigurationArn": {
                    "type": "string"
                }
            },
            "required": [
                "LicenseConfigurationArn"
            ],
            "type": "object"
        },
        "AWS::EC2::Instance.NetworkInterface": {
            "additionalProperties": false,
            "properties": {
                "AssociatePublicIpAddress": {
                    "type": "boolean"
                },
                "DeleteOnTermination": {
                    "type": "boolean"
                },
                "Description": {
                    "type": "string"
                },
                "DeviceIndex": {
                    "type": "string"
                },
                "GroupSet": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "Ipv6AddressCount": {
                    "type": "number"
                },
                "Ipv6Addresses": {
                    "items": {
                        "$ref": "#/definitions/AWS::EC2::Instance.InstanceIpv6Address"
                    },
                    "type": "array"
                },
                "NetworkInterfaceId": {
                    "type": "string"
                },
                "PrivateIpAddress": {
                    "type": "string"
                },
                "PrivateIpAddresses": {
                    "items": {
                        "$ref": "#/definitions/AWS::EC2::Instance.PrivateIpAddressSpecification"
                    },
                    "type": "array"
                },
                "SecondaryPrivateIpAddressCount": {
                    "type": "number"
                },
                "SubnetId": {
                    "type": "string"
                }
            },
            "required": [
                "DeviceIndex"
            ],
            "type": "object"
        },
        "AWS::EC2::Instance.NoDevice": {
            "additionalProperties": false,
            "properties": {},
            "type": "object"
        },
        "AWS::EC2::Instance.PrivateIpAddressSpecification": {
            "additionalProperties": false,
            "properties": {
                "Primary": {
                    "type": "boolean"
                },
                "PrivateIpAddress": {
                    "type": "string"
                }
            },
            "required": [
                "Primary",
                "PrivateIpAddress"
            ],
            "type": "object"
        },
        "AWS::EC2::Instance.SsmAssociation": {
            "additionalProperties": false,
            "properties": {
                "AssociationParameters": {
                    "items": {
                        "$ref": "#/definitions/AWS::EC2::Instance.AssociationParameter"
                    },
                    "type": "array"
                },
                "DocumentName": {
                    "type": "string"
                }
            },
            "required": [
                "DocumentName"
            ],
            "type": "object"
        },
        "AWS::EC2::Instance.Volume": {
            "additionalProperties": false,
            "properties": {
                "Device": {
                    "type": "string"
                },
                "VolumeId": {
                    "type": "string"
                }
            },
            "required": [
                "Device",
                "VolumeId"
            ],
            "type": "object"
        },
        "AWS::EC2::InternetGateway": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        }
                    },
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EC2::InternetGateway"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type"
            ],
            "type": "object"
        },
        "AWS::EC2::LaunchTemplate": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "LaunchTemplateData": {
                            "$ref": "#/definitions/AWS::EC2::LaunchTemplate.LaunchTemplateData"
                        },
                        "LaunchTemplateName": {
                            "type": "string"
                        }
                    },
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EC2::LaunchTemplate"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type"
            ],
            "type": "object"
        },
        "AWS::EC2::LaunchTemplate.BlockDeviceMapping": {
            "additionalProperties": false,
            "properties": {
                "DeviceName": {
                    "type": "string"
                },
                "Ebs": {
                    "$ref": "#/definitions/AWS::EC2::LaunchTemplate.Ebs"
                },
                "NoDevice": {
                    "type": "string"
                },
                "VirtualName": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::EC2::LaunchTemplate.CapacityReservationPreference": {
            "additionalProperties": false,
            "properties": {},
            "type": "object"
        },
        "AWS::EC2::LaunchTemplate.CapacityReservationSpecification": {
            "additionalProperties": false,
            "properties": {
                "CapacityReservationPreference": {
                    "$ref": "#/definitions/AWS::EC2::LaunchTemplate.CapacityReservationPreference"
                },
                "CapacityReservationTarget": {
                    "$ref": "#/definitions/AWS::EC2::LaunchTemplate.CapacityReservationTarget"
                }
            },
            "type": "object"
        },
        "AWS::EC2::LaunchTemplate.CapacityReservationTarget": {
            "additionalProperties": false,
            "properties": {
                "CapacityReservationId": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::EC2::LaunchTemplate.CpuOptions": {
            "additionalProperties": false,
            "properties": {
                "CoreCount": {
                    "type": "number"
                },
                "ThreadsPerCore": {
                    "type": "number"
                }
            },
            "type": "object"
        },
        "AWS::EC2::LaunchTemplate.CreditSpecification": {
            "additionalProperties": false,
            "properties": {
                "CpuCredits": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::EC2::LaunchTemplate.Ebs": {
            "additionalProperties": false,
            "properties": {
                "DeleteOnTermination": {
                    "type": "boolean"
                },
                "Encrypted": {
                    "type": "boolean"
                },
                "Iops": {
                    "type": "number"
                },
                "KmsKeyId": {
                    "type": "string"
                },
                "SnapshotId": {
                    "type": "string"
                },
                "VolumeSize": {
                    "type": "number"
                },
                "VolumeType": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::EC2::LaunchTemplate.ElasticGpuSpecification": {
            "additionalProperties": false,
            "properties": {
                "Type": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::EC2::LaunchTemplate.HibernationOptions": {
            "additionalProperties": false,
            "properties": {
                "Configured": {
                    "type": "boolean"
                }
            },
            "type": "object"
        },
        "AWS::EC2::LaunchTemplate.IamInstanceProfile": {
            "additionalProperties": false,
            "properties": {
                "Arn": {
                    "type": "string"
                },
                "Name": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::EC2::LaunchTemplate.InstanceMarketOptions": {
            "additionalProperties": false,
            "properties": {
                "MarketType": {
                    "type": "string"
                },
                "SpotOptions": {
                    "$ref": "#/definitions/AWS::EC2::LaunchTemplate.SpotOptions"
                }
            },
            "type": "object"
        },
        "AWS::EC2::LaunchTemplate.Ipv6Add": {
            "additionalProperties": false,
            "properties": {
                "Ipv6Address": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::EC2::LaunchTemplate.LaunchTemplateData": {
            "additionalProperties": false,
            "properties": {
                "BlockDeviceMappings": {
                    "items": {
                        "$ref": "#/definitions/AWS::EC2::LaunchTemplate.BlockDeviceMapping"
                    },
                    "type": "array"
                },
                "CapacityReservationSpecification": {
                    "$ref": "#/definitions/AWS::EC2::LaunchTemplate.CapacityReservationSpecification"
                },
                "CpuOptions": {
                    "$ref": "#/definitions/AWS::EC2::LaunchTemplate.CpuOptions"
                },
                "CreditSpecification": {
                    "$ref": "#/definitions/AWS::EC2::LaunchTemplate.CreditSpecification"
                },
                "DisableApiTermination": {
                    "type": "boolean"
                },
                "EbsOptimized": {
                    "type": "boolean"
                },
                "ElasticGpuSpecifications": {
                    "items": {
                        "$ref": "#/definitions/AWS::EC2::LaunchTemplate.ElasticGpuSpecification"
                    },
                    "type": "array"
                },
                "ElasticInferenceAccelerators": {
                    "items": {
                        "$ref": "#/definitions/AWS::EC2::LaunchTemplate.LaunchTemplateElasticInferenceAccelerator"
                    },
                    "type": "array"
                },
                "HibernationOptions": {
                    "$ref": "#/definitions/AWS::EC2::LaunchTemplate.HibernationOptions"
                },
                "IamInstanceProfile": {
                    "$ref": "#/definitions/AWS::EC2::LaunchTemplate.IamInstanceProfile"
                },
                "ImageId": {
                    "type": "string"
                },
                "InstanceInitiatedShutdownBehavior": {
                    "type": "string"
                },
                "InstanceMarketOptions": {
                    "$ref": "#/definitions/AWS::EC2::LaunchTemplate.InstanceMarketOptions"
                },
                "InstanceType": {
                    "type": "string"
                },
                "KernelId": {
                    "type": "string"
                },
                "KeyName": {
                    "type": "string"
                },
                "LicenseSpecifications": {
                    "items": {
                        "$ref": "#/definitions/AWS::EC2::LaunchTemplate.LicenseSpecification"
                    },
                    "type": "array"
                },
                "Monitoring": {
                    "$ref": "#/definitions/AWS::EC2::LaunchTemplate.Monitoring"
                },
                "NetworkInterfaces": {
                    "items": {
                        "$ref": "#/definitions/AWS::EC2::LaunchTemplate.NetworkInterface"
                    },
                    "type": "array"
                },
                "Placement": {
                    "$ref": "#/definitions/AWS::EC2::LaunchTemplate.Placement"
                },
                "RamDiskId": {
                    "type": "string"
                },
                "SecurityGroupIds": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "SecurityGroups": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "TagSpecifications": {
                    "items": {
                        "$ref": "#/definitions/AWS::EC2::LaunchTemplate.TagSpecification"
                    },
                    "type": "array"
                },
                "UserData": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::EC2::LaunchTemplate.LaunchTemplateElasticInferenceAccelerator": {
            "additionalProperties": false,
            "properties": {
                "Type": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::EC2::LaunchTemplate.LicenseSpecification": {
            "additionalProperties": false,
            "properties": {
                "LicenseConfigurationArn": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::EC2::LaunchTemplate.Monitoring": {
            "additionalProperties": false,
            "properties": {
                "Enabled": {
                    "type": "boolean"
                }
            },
            "type": "object"
        },
        "AWS::EC2::LaunchTemplate.NetworkInterface": {
            "additionalProperties": false,
            "properties": {
                "AssociatePublicIpAddress": {
                    "type": "boolean"
                },
                "DeleteOnTermination": {
                    "type": "boolean"
                },
                "Description": {
                    "type": "string"
                },
                "DeviceIndex": {
                    "type": "number"
                },
                "Groups": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "Ipv6AddressCount": {
                    "type": "number"
                },
                "Ipv6Addresses": {
                    "items": {
                        "$ref": "#/definitions/AWS::EC2::LaunchTemplate.Ipv6Add"
                    },
                    "type": "array"
                },
                "NetworkInterfaceId": {
                    "type": "string"
                },
                "PrivateIpAddress": {
                    "type": "string"
                },
                "PrivateIpAddresses": {
                    "items": {
                        "$ref": "#/definitions/AWS::EC2::LaunchTemplate.PrivateIpAdd"
                    },
                    "type": "array"
                },
                "SecondaryPrivateIpAddressCount": {
                    "type": "number"
                },
                "SubnetId": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::EC2::LaunchTemplate.Placement": {
            "additionalProperties": false,
            "properties": {
                "Affinity": {
                    "type": "string"
                },
                "AvailabilityZone": {
                    "type": "string"
                },
                "GroupName": {
                    "type": "string"
                },
                "HostId": {
                    "type": "string"
                },
                "Tenancy": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::EC2::LaunchTemplate.PrivateIpAdd": {
            "additionalProperties": false,
            "properties": {
                "Primary": {
                    "type": "boolean"
                },
                "PrivateIpAddress": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::EC2::LaunchTemplate.SpotOptions": {
            "additionalProperties": false,
            "properties": {
                "InstanceInterruptionBehavior": {
                    "type": "string"
                },
                "MaxPrice": {
                    "type": "string"
                },
                "SpotInstanceType": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::EC2::LaunchTemplate.TagSpecification": {
            "additionalProperties": false,
            "properties": {
                "ResourceType": {
                    "type": "string"
                },
                "Tags": {
                    "items": {
                        "$ref": "#/definitions/Tag"
                    },
                    "type": "array"
                }
            },
            "type": "object"
        },
        "AWS::EC2::NatGateway": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "AllocationId": {
                            "type": "string"
                        },
                        "SubnetId": {
                            "type": "string"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        }
                    },
                    "required": [
                        "AllocationId",
                        "SubnetId"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EC2::NatGateway"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::EC2::NetworkAcl": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        },
                        "VpcId": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "VpcId"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EC2::NetworkAcl"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::EC2::NetworkAclEntry": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "CidrBlock": {
                            "type": "string"
                        },
                        "Egress": {
                            "type": "boolean"
                        },
                        "Icmp": {
                            "$ref": "#/definitions/AWS::EC2::NetworkAclEntry.Icmp"
                        },
                        "Ipv6CidrBlock": {
                            "type": "string"
                        },
                        "NetworkAclId": {
                            "type": "string"
                        },
                        "PortRange": {
                            "$ref": "#/definitions/AWS::EC2::NetworkAclEntry.PortRange"
                        },
                        "Protocol": {
                            "type": "number"
                        },
                        "RuleAction": {
                            "type": "string"
                        },
                        "RuleNumber": {
                            "type": "number"
                        }
                    },
                    "required": [
                        "CidrBlock",
                        "NetworkAclId",
                        "Protocol",
                        "RuleAction",
                        "RuleNumber"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EC2::NetworkAclEntry"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::EC2::NetworkAclEntry.Icmp": {
            "additionalProperties": false,
            "properties": {
                "Code": {
                    "type": "number"
                },
                "Type": {
                    "type": "number"
                }
            },
            "type": "object"
        },
        "AWS::EC2::NetworkAclEntry.PortRange": {
            "additionalProperties": false,
            "properties": {
                "From": {
                    "type": "number"
                },
                "To": {
                    "type": "number"
                }
            },
            "type": "object"
        },
        "AWS::EC2::NetworkInterface": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Description": {
                            "type": "string"
                        },
                        "GroupSet": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "InterfaceType": {
                            "type": "string"
                        },
                        "Ipv6AddressCount": {
                            "type": "number"
                        },
                        "Ipv6Addresses": {
                            "$ref": "#/definitions/AWS::EC2::NetworkInterface.InstanceIpv6Address"
                        },
                        "PrivateIpAddress": {
                            "type": "string"
                        },
                        "PrivateIpAddresses": {
                            "items": {
                                "$ref": "#/definitions/AWS::EC2::NetworkInterface.PrivateIpAddressSpecification"
                            },
                            "type": "array"
                        },
                        "SecondaryPrivateIpAddressCount": {
                            "type": "number"
                        },
                        "SourceDestCheck": {
                            "type": "boolean"
                        },
                        "SubnetId": {
                            "type": "string"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        }
                    },
                    "required": [
                        "SubnetId"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EC2::NetworkInterface"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::EC2::NetworkInterface.InstanceIpv6Address": {
            "additionalProperties": false,
            "properties": {
                "Ipv6Address": {
                    "type": "string"
                }
            },
            "required": [
                "Ipv6Address"
            ],
            "type": "object"
        },
        "AWS::EC2::NetworkInterface.PrivateIpAddressSpecification": {
            "additionalProperties": false,
            "properties": {
                "Primary": {
                    "type": "boolean"
                },
                "PrivateIpAddress": {
                    "type": "string"
                }
            },
            "required": [
                "Primary",
                "PrivateIpAddress"
            ],
            "type": "object"
        },
        "AWS::EC2::NetworkInterfaceAttachment": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "DeleteOnTermination": {
                            "type": "boolean"
                        },
                        "DeviceIndex": {
                            "type": "string"
                        },
                        "InstanceId": {
                            "type": "string"
                        },
                        "NetworkInterfaceId": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "DeviceIndex",
                        "InstanceId",
                        "NetworkInterfaceId"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EC2::NetworkInterfaceAttachment"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::EC2::NetworkInterfacePermission": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "AwsAccountId": {
                            "type": "string"
                        },
                        "NetworkInterfaceId": {
                            "type": "string"
                        },
                        "Permission": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "AwsAccountId",
                        "NetworkInterfaceId",
                        "Permission"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EC2::NetworkInterfacePermission"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::EC2::PlacementGroup": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Strategy": {
                            "type": "string"
                        }
                    },
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EC2::PlacementGroup"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type"
            ],
            "type": "object"
        },
        "AWS::EC2::Route": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "DestinationCidrBlock": {
                            "type": "string"
                        },
                        "DestinationIpv6CidrBlock": {
                            "type": "string"
                        },
                        "EgressOnlyInternetGatewayId": {
                            "type": "string"
                        },
                        "GatewayId": {
                            "type": "string"
                        },
                        "InstanceId": {
                            "type": "string"
                        },
                        "NatGatewayId": {
                            "type": "string"
                        },
                        "NetworkInterfaceId": {
                            "type": "string"
                        },
                        "RouteTableId": {
                            "type": "string"
                        },
                        "VpcPeeringConnectionId": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "RouteTableId"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EC2::Route"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::EC2::RouteTable": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        },
                        "VpcId": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "VpcId"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EC2::RouteTable"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::EC2::SecurityGroup": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "GroupDescription": {
                            "type": "string"
                        },
                        "GroupName": {
                            "type": "string"
                        },
                        "SecurityGroupEgress": {
                            "items": {
                                "$ref": "#/definitions/AWS::EC2::SecurityGroup.Egress"
                            },
                            "type": "array"
                        },
                        "SecurityGroupIngress": {
                            "items": {
                                "$ref": "#/definitions/AWS::EC2::SecurityGroup.Ingress"
                            },
                            "type": "array"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        },
                        "VpcId": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "GroupDescription"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EC2::SecurityGroup"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::EC2::SecurityGroup.Egress": {
            "additionalProperties": false,
            "properties": {
                "CidrIp": {
                    "type": "string"
                },
                "CidrIpv6": {
                    "type": "string"
                },
                "Description": {
                    "type": "string"
                },
                "DestinationPrefixListId": {
                    "type": "string"
                },
                "DestinationSecurityGroupId": {
                    "type": "string"
                },
                "FromPort": {
                    "type": "number"
                },
                "IpProtocol": {
                    "type": "string"
                },
                "ToPort": {
                    "type": "number"
                }
            },
            "required": [
                "IpProtocol"
            ],
            "type": "object"
        },
        "AWS::EC2::SecurityGroup.Ingress": {
            "additionalProperties": false,
            "properties": {
                "CidrIp": {
                    "type": "string"
                },
                "CidrIpv6": {
                    "type": "string"
                },
                "Description": {
                    "type": "string"
                },
                "FromPort": {
                    "type": "number"
                },
                "IpProtocol": {
                    "type": "string"
                },
                "SourcePrefixListId": {
                    "type": "string"
                },
                "SourceSecurityGroupId": {
                    "type": "string"
                },
                "SourceSecurityGroupName": {
                    "type": "string"
                },
                "SourceSecurityGroupOwnerId": {
                    "type": "string"
                },
                "ToPort": {
                    "type": "number"
                }
            },
            "required": [
                "IpProtocol"
            ],
            "type": "object"
        },
        "AWS::EC2::SecurityGroupEgress": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "CidrIp": {
                            "type": "string"
                        },
                        "CidrIpv6": {
                            "type": "string"
                        },
                        "Description": {
                            "type": "string"
                        },
                        "DestinationPrefixListId": {
                            "type": "string"
                        },
                        "DestinationSecurityGroupId": {
                            "type": "string"
                        },
                        "FromPort": {
                            "type": "number"
                        },
                        "GroupId": {
                            "type": "string"
                        },
                        "IpProtocol": {
                            "type": "string"
                        },
                        "ToPort": {
                            "type": "number"
                        }
                    },
                    "required": [
                        "GroupId",
                        "IpProtocol"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EC2::SecurityGroupEgress"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::EC2::SecurityGroupIngress": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "CidrIp": {
                            "type": "string"
                        },
                        "CidrIpv6": {
                            "type": "string"
                        },
                        "Description": {
                            "type": "string"
                        },
                        "FromPort": {
                            "type": "number"
                        },
                        "GroupId": {
                            "type": "string"
                        },
                        "GroupName": {
                            "type": "string"
                        },
                        "IpProtocol": {
                            "type": "string"
                        },
                        "SourcePrefixListId": {
                            "type": "string"
                        },
                        "SourceSecurityGroupId": {
                            "type": "string"
                        },
                        "SourceSecurityGroupName": {
                            "type": "string"
                        },
                        "SourceSecurityGroupOwnerId": {
                            "type": "string"
                        },
                        "ToPort": {
                            "type": "number"
                        }
                    },
                    "required": [
                        "IpProtocol"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EC2::SecurityGroupIngress"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::EC2::SpotFleet": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "SpotFleetRequestConfigData": {
                            "$ref": "#/definitions/AWS::EC2::SpotFleet.SpotFleetRequestConfigData"
                        }
                    },
                    "required": [
                        "SpotFleetRequestConfigData"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EC2::SpotFleet"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::EC2::SpotFleet.BlockDeviceMapping": {
            "additionalProperties": false,
            "properties": {
                "DeviceName": {
                    "type": "string"
                },
                "Ebs": {
                    "$ref": "#/definitions/AWS::EC2::SpotFleet.EbsBlockDevice"
                },
                "NoDevice": {
                    "type": "string"
                },
                "VirtualName": {
                    "type": "string"
                }
            },
            "required": [
                "DeviceName"
            ],
            "type": "object"
        },
        "AWS::EC2::SpotFleet.ClassicLoadBalancer": {
            "additionalProperties": false,
            "properties": {
                "Name": {
                    "type": "string"
                }
            },
            "required": [
                "Name"
            ],
            "type": "object"
        },
        "AWS::EC2::SpotFleet.ClassicLoadBalancersConfig": {
            "additionalProperties": false,
            "properties": {
                "ClassicLoadBalancers": {
                    "items": {
                        "$ref": "#/definitions/AWS::EC2::SpotFleet.ClassicLoadBalancer"
                    },
                    "type": "array"
                }
            },
            "required": [
                "ClassicLoadBalancers"
            ],
            "type": "object"
        },
        "AWS::EC2::SpotFleet.EbsBlockDevice": {
            "additionalProperties": false,
            "properties": {
                "DeleteOnTermination": {
                    "type": "boolean"
                },
                "Encrypted": {
                    "type": "boolean"
                },
                "Iops": {
                    "type": "number"
                },
                "SnapshotId": {
                    "type": "string"
                },
                "VolumeSize": {
                    "type": "number"
                },
                "VolumeType": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::EC2::SpotFleet.FleetLaunchTemplateSpecification": {
            "additionalProperties": false,
            "properties": {
                "LaunchTemplateId": {
                    "type": "string"
                },
                "LaunchTemplateName": {
                    "type": "string"
                },
                "Version": {
                    "type": "string"
                }
            },
            "required": [
                "Version"
            ],
            "type": "object"
        },
        "AWS::EC2::SpotFleet.GroupIdentifier": {
            "additionalProperties": false,
            "properties": {
                "GroupId": {
                    "type": "string"
                }
            },
            "required": [
                "GroupId"
            ],
            "type": "object"
        },
        "AWS::EC2::SpotFleet.IamInstanceProfileSpecification": {
            "additionalProperties": false,
            "properties": {
                "Arn": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::EC2::SpotFleet.InstanceIpv6Address": {
            "additionalProperties": false,
            "properties": {
                "Ipv6Address": {
                    "type": "string"
                }
            },
            "required": [
                "Ipv6Address"
            ],
            "type": "object"
        },
        "AWS::EC2::SpotFleet.InstanceNetworkInterfaceSpecification": {
            "additionalProperties": false,
            "properties": {
                "AssociatePublicIpAddress": {
                    "type": "boolean"
                },
                "DeleteOnTermination": {
                    "type": "boolean"
                },
                "Description": {
                    "type": "string"
                },
                "DeviceIndex": {
                    "type": "number"
                },
                "Groups": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "Ipv6AddressCount": {
                    "type": "number"
                },
                "Ipv6Addresses": {
                    "items": {
                        "$ref": "#/definitions/AWS::EC2::SpotFleet.InstanceIpv6Address"
                    },
                    "type": "array"
                },
                "NetworkInterfaceId": {
                    "type": "string"
                },
                "PrivateIpAddresses": {
                    "items": {
                        "$ref": "#/definitions/AWS::EC2::SpotFleet.PrivateIpAddressSpecification"
                    },
                    "type": "array"
                },
                "SecondaryPrivateIpAddressCount": {
                    "type": "number"
                },
                "SubnetId": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::EC2::SpotFleet.LaunchTemplateConfig": {
            "additionalProperties": false,
            "properties": {
                "LaunchTemplateSpecification": {
                    "$ref": "#/definitions/AWS::EC2::SpotFleet.FleetLaunchTemplateSpecification"
                },
                "Overrides": {
                    "items": {
                        "$ref": "#/definitions/AWS::EC2::SpotFleet.LaunchTemplateOverrides"
                    },
                    "type": "array"
                }
            },
            "type": "object"
        },
        "AWS::EC2::SpotFleet.LaunchTemplateOverrides": {
            "additionalProperties": false,
            "properties": {
                "AvailabilityZone": {
                    "type": "string"
                },
                "InstanceType": {
                    "type": "string"
                },
                "SpotPrice": {
                    "type": "string"
                },
                "SubnetId": {
                    "type": "string"
                },
                "WeightedCapacity": {
                    "type": "number"
                }
            },
            "type": "object"
        },
        "AWS::EC2::SpotFleet.LoadBalancersConfig": {
            "additionalProperties": false,
            "properties": {
                "ClassicLoadBalancersConfig": {
                    "$ref": "#/definitions/AWS::EC2::SpotFleet.ClassicLoadBalancersConfig"
                },
                "TargetGroupsConfig": {
                    "$ref": "#/definitions/AWS::EC2::SpotFleet.TargetGroupsConfig"
                }
            },
            "type": "object"
        },
        "AWS::EC2::SpotFleet.PrivateIpAddressSpecification": {
            "additionalProperties": false,
            "properties": {
                "Primary": {
                    "type": "boolean"
                },
                "PrivateIpAddress": {
                    "type": "string"
                }
            },
            "required": [
                "PrivateIpAddress"
            ],
            "type": "object"
        },
        "AWS::EC2::SpotFleet.SpotFleetLaunchSpecification": {
            "additionalProperties": false,
            "properties": {
                "BlockDeviceMappings": {
                    "items": {
                        "$ref": "#/definitions/AWS::EC2::SpotFleet.BlockDeviceMapping"
                    },
                    "type": "array"
                },
                "EbsOptimized": {
                    "type": "boolean"
                },
                "IamInstanceProfile": {
                    "$ref": "#/definitions/AWS::EC2::SpotFleet.IamInstanceProfileSpecification"
                },
                "ImageId": {
                    "type": "string"
                },
                "InstanceType": {
                    "type": "string"
                },
                "KernelId": {
                    "type": "string"
                },
                "KeyName": {
                    "type": "string"
                },
                "Monitoring": {
                    "$ref": "#/definitions/AWS::EC2::SpotFleet.SpotFleetMonitoring"
                },
                "NetworkInterfaces": {
                    "items": {
                        "$ref": "#/definitions/AWS::EC2::SpotFleet.InstanceNetworkInterfaceSpecification"
                    },
                    "type": "array"
                },
                "Placement": {
                    "$ref": "#/definitions/AWS::EC2::SpotFleet.SpotPlacement"
                },
                "RamdiskId": {
                    "type": "string"
                },
                "SecurityGroups": {
                    "items": {
                        "$ref": "#/definitions/AWS::EC2::SpotFleet.GroupIdentifier"
                    },
                    "type": "array"
                },
                "SpotPrice": {
                    "type": "string"
                },
                "SubnetId": {
                    "type": "string"
                },
                "TagSpecifications": {
                    "items": {
                        "$ref": "#/definitions/AWS::EC2::SpotFleet.SpotFleetTagSpecification"
                    },
                    "type": "array"
                },
                "UserData": {
                    "type": "string"
                },
                "WeightedCapacity": {
                    "type": "number"
                }
            },
            "required": [
                "ImageId",
                "InstanceType"
            ],
            "type": "object"
        },
        "AWS::EC2::SpotFleet.SpotFleetMonitoring": {
            "additionalProperties": false,
            "properties": {
                "Enabled": {
                    "type": "boolean"
                }
            },
            "type": "object"
        },
        "AWS::EC2::SpotFleet.SpotFleetRequestConfigData": {
            "additionalProperties": false,
            "properties": {
                "AllocationStrategy": {
                    "type": "string"
                },
                "ExcessCapacityTerminationPolicy": {
                    "type": "string"
                },
                "IamFleetRole": {
                    "type": "string"
                },
                "InstanceInterruptionBehavior": {
                    "type": "string"
                },
                "LaunchSpecifications": {
                    "items": {
                        "$ref": "#/definitions/AWS::EC2::SpotFleet.SpotFleetLaunchSpecification"
                    },
                    "type": "array"
                },
                "LaunchTemplateConfigs": {
                    "items": {
                        "$ref": "#/definitions/AWS::EC2::SpotFleet.LaunchTemplateConfig"
                    },
                    "type": "array"
                },
                "LoadBalancersConfig": {
                    "$ref": "#/definitions/AWS::EC2::SpotFleet.LoadBalancersConfig"
                },
                "ReplaceUnhealthyInstances": {
                    "type": "boolean"
                },
                "SpotPrice": {
                    "type": "string"
                },
                "TargetCapacity": {
                    "type": "number"
                },
                "TerminateInstancesWithExpiration": {
                    "type": "boolean"
                },
                "Type": {
                    "type": "string"
                },
                "ValidFrom": {
                    "type": "string"
                },
                "ValidUntil": {
                    "type": "string"
                }
            },
            "required": [
                "IamFleetRole",
                "TargetCapacity"
            ],
            "type": "object"
        },
        "AWS::EC2::SpotFleet.SpotFleetTagSpecification": {
            "additionalProperties": false,
            "properties": {
                "ResourceType": {
                    "type": "string"
                },
                "Tags": {
                    "items": {
                        "$ref": "#/definitions/Tag"
                    },
                    "type": "array"
                }
            },
            "type": "object"
        },
        "AWS::EC2::SpotFleet.SpotPlacement": {
            "additionalProperties": false,
            "properties": {
                "AvailabilityZone": {
                    "type": "string"
                },
                "GroupName": {
                    "type": "string"
                },
                "Tenancy": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::EC2::SpotFleet.TargetGroup": {
            "additionalProperties": false,
            "properties": {
                "Arn": {
                    "type": "string"
                }
            },
            "required": [
                "Arn"
            ],
            "type": "object"
        },
        "AWS::EC2::SpotFleet.TargetGroupsConfig": {
            "additionalProperties": false,
            "properties": {
                "TargetGroups": {
                    "items": {
                        "$ref": "#/definitions/AWS::EC2::SpotFleet.TargetGroup"
                    },
                    "type": "array"
                }
            },
            "required": [
                "TargetGroups"
            ],
            "type": "object"
        },
        "AWS::EC2::Subnet": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "AssignIpv6AddressOnCreation": {
                            "type": "boolean"
                        },
                        "AvailabilityZone": {
                            "type": "string"
                        },
                        "CidrBlock": {
                            "type": "string"
                        },
                        "Ipv6CidrBlock": {
                            "type": "string"
                        },
                        "MapPublicIpOnLaunch": {
                            "type": "boolean"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        },
                        "VpcId": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "CidrBlock",
                        "VpcId"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EC2::Subnet"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::EC2::SubnetCidrBlock": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Ipv6CidrBlock": {
                            "type": "string"
                        },
                        "SubnetId": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "Ipv6CidrBlock",
                        "SubnetId"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EC2::SubnetCidrBlock"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::EC2::SubnetNetworkAclAssociation": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "NetworkAclId": {
                            "type": "string"
                        },
                        "SubnetId": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "NetworkAclId",
                        "SubnetId"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EC2::SubnetNetworkAclAssociation"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::EC2::SubnetRouteTableAssociation": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "RouteTableId": {
                            "type": "string"
                        },
                        "SubnetId": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "RouteTableId",
                        "SubnetId"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EC2::SubnetRouteTableAssociation"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::EC2::TransitGateway": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "AmazonSideAsn": {
                            "type": "number"
                        },
                        "AutoAcceptSharedAttachments": {
                            "type": "string"
                        },
                        "DefaultRouteTableAssociation": {
                            "type": "string"
                        },
                        "DefaultRouteTablePropagation": {
                            "type": "string"
                        },
                        "Description": {
                            "type": "string"
                        },
                        "DnsSupport": {
                            "type": "string"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        },
                        "VpnEcmpSupport": {
                            "type": "string"
                        }
                    },
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EC2::TransitGateway"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type"
            ],
            "type": "object"
        },
        "AWS::EC2::TransitGatewayAttachment": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "SubnetIds": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        },
                        "TransitGatewayId": {
                            "type": "string"
                        },
                        "VpcId": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "SubnetIds",
                        "TransitGatewayId",
                        "VpcId"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EC2::TransitGatewayAttachment"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::EC2::TransitGatewayRoute": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Blackhole": {
                            "type": "boolean"
                        },
                        "DestinationCidrBlock": {
                            "type": "string"
                        },
                        "TransitGatewayAttachmentId": {
                            "type": "string"
                        },
                        "TransitGatewayRouteTableId": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "TransitGatewayRouteTableId"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EC2::TransitGatewayRoute"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::EC2::TransitGatewayRouteTable": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        },
                        "TransitGatewayId": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "TransitGatewayId"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EC2::TransitGatewayRouteTable"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::EC2::TransitGatewayRouteTableAssociation": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "TransitGatewayAttachmentId": {
                            "type": "string"
                        },
                        "TransitGatewayRouteTableId": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "TransitGatewayAttachmentId",
                        "TransitGatewayRouteTableId"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EC2::TransitGatewayRouteTableAssociation"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::EC2::TransitGatewayRouteTablePropagation": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "TransitGatewayAttachmentId": {
                            "type": "string"
                        },
                        "TransitGatewayRouteTableId": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "TransitGatewayAttachmentId",
                        "TransitGatewayRouteTableId"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EC2::TransitGatewayRouteTablePropagation"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::EC2::TrunkInterfaceAssociation": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "BranchInterfaceId": {
                            "type": "string"
                        },
                        "GREKey": {
                            "type": "number"
                        },
                        "TrunkInterfaceId": {
                            "type": "string"
                        },
                        "VLANId": {
                            "type": "number"
                        }
                    },
                    "required": [
                        "BranchInterfaceId",
                        "TrunkInterfaceId"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EC2::TrunkInterfaceAssociation"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::EC2::VPC": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "CidrBlock": {
                            "type": "string"
                        },
                        "EnableDnsHostnames": {
                            "type": "boolean"
                        },
                        "EnableDnsSupport": {
                            "type": "boolean"
                        },
                        "InstanceTenancy": {
                            "type": "string"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        }
                    },
                    "required": [
                        "CidrBlock"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EC2::VPC"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::EC2::VPCCidrBlock": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "AmazonProvidedIpv6CidrBlock": {
                            "type": "boolean"
                        },
                        "CidrBlock": {
                            "type": "string"
                        },
                        "VpcId": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "VpcId"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EC2::VPCCidrBlock"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::EC2::VPCDHCPOptionsAssociation": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "DhcpOptionsId": {
                            "type": "string"
                        },
                        "VpcId": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "DhcpOptionsId",
                        "VpcId"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EC2::VPCDHCPOptionsAssociation"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::EC2::VPCEndpoint": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "PolicyDocument": {
                            "type": "object"
                        },
                        "PrivateDnsEnabled": {
                            "type": "boolean"
                        },
                        "RouteTableIds": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "SecurityGroupIds": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "ServiceName": {
                            "type": "string"
                        },
                        "SubnetIds": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "VpcEndpointType": {
                            "type": "string"
                        },
                        "VpcId": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "ServiceName",
                        "VpcId"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EC2::VPCEndpoint"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::EC2::VPCEndpointConnectionNotification": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "ConnectionEvents": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "ConnectionNotificationArn": {
                            "type": "string"
                        },
                        "ServiceId": {
                            "type": "string"
                        },
                        "VPCEndpointId": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "ConnectionEvents",
                        "ConnectionNotificationArn"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EC2::VPCEndpointConnectionNotification"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::EC2::VPCEndpointServicePermissions": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "AllowedPrincipals": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "ServiceId": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "ServiceId"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EC2::VPCEndpointServicePermissions"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::EC2::VPCGatewayAttachment": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "InternetGatewayId": {
                            "type": "string"
                        },
                        "VpcId": {
                            "type": "string"
                        },
                        "VpnGatewayId": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "VpcId"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EC2::VPCGatewayAttachment"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::EC2::VPCPeeringConnection": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "PeerOwnerId": {
                            "type": "string"
                        },
                        "PeerRegion": {
                            "type": "string"
                        },
                        "PeerRoleArn": {
                            "type": "string"
                        },
                        "PeerVpcId": {
                            "type": "string"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        },
                        "VpcId": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "PeerVpcId",
                        "VpcId"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EC2::VPCPeeringConnection"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::EC2::VPNConnection": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "CustomerGatewayId": {
                            "type": "string"
                        },
                        "StaticRoutesOnly": {
                            "type": "boolean"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        },
                        "Type": {
                            "type": "string"
                        },
                        "VpnGatewayId": {
                            "type": "string"
                        },
                        "VpnTunnelOptionsSpecifications": {
                            "items": {
                                "$ref": "#/definitions/AWS::EC2::VPNConnection.VpnTunnelOptionsSpecification"
                            },
                            "type": "array"
                        }
                    },
                    "required": [
                        "CustomerGatewayId",
                        "Type",
                        "VpnGatewayId"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EC2::VPNConnection"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::EC2::VPNConnection.VpnTunnelOptionsSpecification": {
            "additionalProperties": false,
            "properties": {
                "PreSharedKey": {
                    "type": "string"
                },
                "TunnelInsideCidr": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::EC2::VPNConnectionRoute": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "DestinationCidrBlock": {
                            "type": "string"
                        },
                        "VpnConnectionId": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "DestinationCidrBlock",
                        "VpnConnectionId"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EC2::VPNConnectionRoute"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::EC2::VPNGateway": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "AmazonSideAsn": {
                            "type": "number"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        },
                        "Type": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "Type"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EC2::VPNGateway"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::EC2::VPNGatewayRoutePropagation": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "RouteTableIds": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "VpnGatewayId": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "RouteTableIds",
                        "VpnGatewayId"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EC2::VPNGatewayRoutePropagation"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::EC2::Volume": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "AutoEnableIO": {
                            "type": "boolean"
                        },
                        "AvailabilityZone": {
                            "type": "string"
                        },
                        "Encrypted": {
                            "type": "boolean"
                        },
                        "Iops": {
                            "type": "number"
                        },
                        "KmsKeyId": {
                            "type": "string"
                        },
                        "Size": {
                            "type": "number"
                        },
                        "SnapshotId": {
                            "type": "string"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        },
                        "VolumeType": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "AvailabilityZone"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EC2::Volume"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::EC2::VolumeAttachment": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Device": {
                            "type": "string"
                        },
                        "InstanceId": {
                            "type": "string"
                        },
                        "VolumeId": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "Device",
                        "InstanceId",
                        "VolumeId"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EC2::VolumeAttachment"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::ECR::Repository": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "LifecyclePolicy": {
                            "$ref": "#/definitions/AWS::ECR::Repository.LifecyclePolicy"
                        },
                        "RepositoryName": {
                            "type": "string"
                        },
                        "RepositoryPolicyText": {
                            "type": "object"
                        }
                    },
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::ECR::Repository"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type"
            ],
            "type": "object"
        },
        "AWS::ECR::Repository.LifecyclePolicy": {
            "additionalProperties": false,
            "properties": {
                "LifecyclePolicyText": {
                    "type": "string"
                },
                "RegistryId": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::ECS::Cluster": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "ClusterName": {
                            "type": "string"
                        }
                    },
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::ECS::Cluster"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type"
            ],
            "type": "object"
        },
        "AWS::ECS::Service": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Cluster": {
                            "type": "string"
                        },
                        "DeploymentConfiguration": {
                            "$ref": "#/definitions/AWS::ECS::Service.DeploymentConfiguration"
                        },
                        "DesiredCount": {
                            "type": "number"
                        },
                        "HealthCheckGracePeriodSeconds": {
                            "type": "number"
                        },
                        "LaunchType": {
                            "type": "string"
                        },
                        "LoadBalancers": {
                            "items": {
                                "$ref": "#/definitions/AWS::ECS::Service.LoadBalancer"
                            },
                            "type": "array"
                        },
                        "NetworkConfiguration": {
                            "$ref": "#/definitions/AWS::ECS::Service.NetworkConfiguration"
                        },
                        "PlacementConstraints": {
                            "items": {
                                "$ref": "#/definitions/AWS::ECS::Service.PlacementConstraint"
                            },
                            "type": "array"
                        },
                        "PlacementStrategies": {
                            "items": {
                                "$ref": "#/definitions/AWS::ECS::Service.PlacementStrategy"
                            },
                            "type": "array"
                        },
                        "PlatformVersion": {
                            "type": "string"
                        },
                        "Role": {
                            "type": "string"
                        },
                        "SchedulingStrategy": {
                            "type": "string"
                        },
                        "ServiceName": {
                            "type": "string"
                        },
                        "ServiceRegistries": {
                            "items": {
                                "$ref": "#/definitions/AWS::ECS::Service.ServiceRegistry"
                            },
                            "type": "array"
                        },
                        "TaskDefinition": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "TaskDefinition"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::ECS::Service"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::ECS::Service.AwsVpcConfiguration": {
            "additionalProperties": false,
            "properties": {
                "AssignPublicIp": {
                    "type": "string"
                },
                "SecurityGroups": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "Subnets": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                }
            },
            "required": [
                "Subnets"
            ],
            "type": "object"
        },
        "AWS::ECS::Service.DeploymentConfiguration": {
            "additionalProperties": false,
            "properties": {
                "MaximumPercent": {
                    "type": "number"
                },
                "MinimumHealthyPercent": {
                    "type": "number"
                }
            },
            "type": "object"
        },
        "AWS::ECS::Service.LoadBalancer": {
            "additionalProperties": false,
            "properties": {
                "ContainerName": {
                    "type": "string"
                },
                "ContainerPort": {
                    "type": "number"
                },
                "LoadBalancerName": {
                    "type": "string"
                },
                "TargetGroupArn": {
                    "type": "string"
                }
            },
            "required": [
                "ContainerPort"
            ],
            "type": "object"
        },
        "AWS::ECS::Service.NetworkConfiguration": {
            "additionalProperties": false,
            "properties": {
                "AwsvpcConfiguration": {
                    "$ref": "#/definitions/AWS::ECS::Service.AwsVpcConfiguration"
                }
            },
            "type": "object"
        },
        "AWS::ECS::Service.PlacementConstraint": {
            "additionalProperties": false,
            "properties": {
                "Expression": {
                    "type": "string"
                },
                "Type": {
                    "type": "string"
                }
            },
            "required": [
                "Type"
            ],
            "type": "object"
        },
        "AWS::ECS::Service.PlacementStrategy": {
            "additionalProperties": false,
            "properties": {
                "Field": {
                    "type": "string"
                },
                "Type": {
                    "type": "string"
                }
            },
            "required": [
                "Type"
            ],
            "type": "object"
        },
        "AWS::ECS::Service.ServiceRegistry": {
            "additionalProperties": false,
            "properties": {
                "ContainerName": {
                    "type": "string"
                },
                "ContainerPort": {
                    "type": "number"
                },
                "Port": {
                    "type": "number"
                },
                "RegistryArn": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::ECS::TaskDefinition": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "ContainerDefinitions": {
                            "items": {
                                "$ref": "#/definitions/AWS::ECS::TaskDefinition.ContainerDefinition"
                            },
                            "type": "array"
                        },
                        "Cpu": {
                            "type": "string"
                        },
                        "ExecutionRoleArn": {
                            "type": "string"
                        },
                        "Family": {
                            "type": "string"
                        },
                        "Memory": {
                            "type": "string"
                        },
                        "NetworkMode": {
                            "type": "string"
                        },
                        "PlacementConstraints": {
                            "items": {
                                "$ref": "#/definitions/AWS::ECS::TaskDefinition.TaskDefinitionPlacementConstraint"
                            },
                            "type": "array"
                        },
                        "RequiresCompatibilities": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "TaskRoleArn": {
                            "type": "string"
                        },
                        "Volumes": {
                            "items": {
                                "$ref": "#/definitions/AWS::ECS::TaskDefinition.Volume"
                            },
                            "type": "array"
                        }
                    },
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::ECS::TaskDefinition"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type"
            ],
            "type": "object"
        },
        "AWS::ECS::TaskDefinition.ContainerDefinition": {
            "additionalProperties": false,
            "properties": {
                "Command": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "Cpu": {
                    "type": "number"
                },
                "DisableNetworking": {
                    "type": "boolean"
                },
                "DnsSearchDomains": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "DnsServers": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "DockerLabels": {
                    "additionalProperties": true,
                    "patternProperties": {
                        "^[a-zA-Z0-9]+$": {
                            "type": "string"
                        }
                    },
                    "type": "object"
                },
                "DockerSecurityOptions": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "EntryPoint": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "Environment": {
                    "items": {
                        "$ref": "#/definitions/AWS::ECS::TaskDefinition.KeyValuePair"
                    },
                    "type": "array"
                },
                "Essential": {
                    "type": "boolean"
                },
                "ExtraHosts": {
                    "items": {
                        "$ref": "#/definitions/AWS::ECS::TaskDefinition.HostEntry"
                    },
                    "type": "array"
                },
                "HealthCheck": {
                    "$ref": "#/definitions/AWS::ECS::TaskDefinition.HealthCheck"
                },
                "Hostname": {
                    "type": "string"
                },
                "Image": {
                    "type": "string"
                },
                "Links": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "LinuxParameters": {
                    "$ref": "#/definitions/AWS::ECS::TaskDefinition.LinuxParameters"
                },
                "LogConfiguration": {
                    "$ref": "#/definitions/AWS::ECS::TaskDefinition.LogConfiguration"
                },
                "Memory": {
                    "type": "number"
                },
                "MemoryReservation": {
                    "type": "number"
                },
                "MountPoints": {
                    "items": {
                        "$ref": "#/definitions/AWS::ECS::TaskDefinition.MountPoint"
                    },
                    "type": "array"
                },
                "Name": {
                    "type": "string"
                },
                "PortMappings": {
                    "items": {
                        "$ref": "#/definitions/AWS::ECS::TaskDefinition.PortMapping"
                    },
                    "type": "array"
                },
                "Privileged": {
                    "type": "boolean"
                },
                "ReadonlyRootFilesystem": {
                    "type": "boolean"
                },
                "RepositoryCredentials": {
                    "$ref": "#/definitions/AWS::ECS::TaskDefinition.RepositoryCredentials"
                },
                "Ulimits": {
                    "items": {
                        "$ref": "#/definitions/AWS::ECS::TaskDefinition.Ulimit"
                    },
                    "type": "array"
                },
                "User": {
                    "type": "string"
                },
                "VolumesFrom": {
                    "items": {
                        "$ref": "#/definitions/AWS::ECS::TaskDefinition.VolumeFrom"
                    },
                    "type": "array"
                },
                "WorkingDirectory": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::ECS::TaskDefinition.Device": {
            "additionalProperties": false,
            "properties": {
                "ContainerPath": {
                    "type": "string"
                },
                "HostPath": {
                    "type": "string"
                },
                "Permissions": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                }
            },
            "required": [
                "HostPath"
            ],
            "type": "object"
        },
        "AWS::ECS::TaskDefinition.DockerVolumeConfiguration": {
            "additionalProperties": false,
            "properties": {
                "Autoprovision": {
                    "type": "boolean"
                },
                "Driver": {
                    "type": "string"
                },
                "DriverOpts": {
                    "additionalProperties": true,
                    "patternProperties": {
                        "^[a-zA-Z0-9]+$": {
                            "type": "string"
                        }
                    },
                    "type": "object"
                },
                "Labels": {
                    "additionalProperties": true,
                    "patternProperties": {
                        "^[a-zA-Z0-9]+$": {
                            "type": "string"
                        }
                    },
                    "type": "object"
                },
                "Scope": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::ECS::TaskDefinition.HealthCheck": {
            "additionalProperties": false,
            "properties": {
                "Command": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "Interval": {
                    "type": "number"
                },
                "Retries": {
                    "type": "number"
                },
                "StartPeriod": {
                    "type": "number"
                },
                "Timeout": {
                    "type": "number"
                }
            },
            "required": [
                "Command"
            ],
            "type": "object"
        },
        "AWS::ECS::TaskDefinition.HostEntry": {
            "additionalProperties": false,
            "properties": {
                "Hostname": {
                    "type": "string"
                },
                "IpAddress": {
                    "type": "string"
                }
            },
            "required": [
                "Hostname",
                "IpAddress"
            ],
            "type": "object"
        },
        "AWS::ECS::TaskDefinition.HostVolumeProperties": {
            "additionalProperties": false,
            "properties": {
                "SourcePath": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::ECS::TaskDefinition.KernelCapabilities": {
            "additionalProperties": false,
            "properties": {
                "Add": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "Drop": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                }
            },
            "type": "object"
        },
        "AWS::ECS::TaskDefinition.KeyValuePair": {
            "additionalProperties": false,
            "properties": {
                "Name": {
                    "type": "string"
                },
                "Value": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::ECS::TaskDefinition.LinuxParameters": {
            "additionalProperties": false,
            "properties": {
                "Capabilities": {
                    "$ref": "#/definitions/AWS::ECS::TaskDefinition.KernelCapabilities"
                },
                "Devices": {
                    "items": {
                        "$ref": "#/definitions/AWS::ECS::TaskDefinition.Device"
                    },
                    "type": "array"
                },
                "InitProcessEnabled": {
                    "type": "boolean"
                },
                "SharedMemorySize": {
                    "type": "number"
                },
                "Tmpfs": {
                    "items": {
                        "$ref": "#/definitions/AWS::ECS::TaskDefinition.Tmpfs"
                    },
                    "type": "array"
                }
            },
            "type": "object"
        },
        "AWS::ECS::TaskDefinition.LogConfiguration": {
            "additionalProperties": false,
            "properties": {
                "LogDriver": {
                    "type": "string"
                },
                "Options": {
                    "additionalProperties": true,
                    "patternProperties": {
                        "^[a-zA-Z0-9]+$": {
                            "type": "string"
                        }
                    },
                    "type": "object"
                }
            },
            "required": [
                "LogDriver"
            ],
            "type": "object"
        },
        "AWS::ECS::TaskDefinition.MountPoint": {
            "additionalProperties": false,
            "properties": {
                "ContainerPath": {
                    "type": "string"
                },
                "ReadOnly": {
                    "type": "boolean"
                },
                "SourceVolume": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::ECS::TaskDefinition.PortMapping": {
            "additionalProperties": false,
            "properties": {
                "ContainerPort": {
                    "type": "number"
                },
                "HostPort": {
                    "type": "number"
                },
                "Protocol": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::ECS::TaskDefinition.RepositoryCredentials": {
            "additionalProperties": false,
            "properties": {
                "CredentialsParameter": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::ECS::TaskDefinition.TaskDefinitionPlacementConstraint": {
            "additionalProperties": false,
            "properties": {
                "Expression": {
                    "type": "string"
                },
                "Type": {
                    "type": "string"
                }
            },
            "required": [
                "Type"
            ],
            "type": "object"
        },
        "AWS::ECS::TaskDefinition.Tmpfs": {
            "additionalProperties": false,
            "properties": {
                "ContainerPath": {
                    "type": "string"
                },
                "MountOptions": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "Size": {
                    "type": "number"
                }
            },
            "type": "object"
        },
        "AWS::ECS::TaskDefinition.Ulimit": {
            "additionalProperties": false,
            "properties": {
                "HardLimit": {
                    "type": "number"
                },
                "Name": {
                    "type": "string"
                },
                "SoftLimit": {
                    "type": "number"
                }
            },
            "required": [
                "HardLimit",
                "Name",
                "SoftLimit"
            ],
            "type": "object"
        },
        "AWS::ECS::TaskDefinition.Volume": {
            "additionalProperties": false,
            "properties": {
                "DockerVolumeConfiguration": {
                    "$ref": "#/definitions/AWS::ECS::TaskDefinition.DockerVolumeConfiguration"
                },
                "Host": {
                    "$ref": "#/definitions/AWS::ECS::TaskDefinition.HostVolumeProperties"
                },
                "Name": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::ECS::TaskDefinition.VolumeFrom": {
            "additionalProperties": false,
            "properties": {
                "ReadOnly": {
                    "type": "boolean"
                },
                "SourceContainer": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::EFS::FileSystem": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Encrypted": {
                            "type": "boolean"
                        },
                        "FileSystemTags": {
                            "items": {
                                "$ref": "#/definitions/AWS::EFS::FileSystem.ElasticFileSystemTag"
                            },
                            "type": "array"
                        },
                        "KmsKeyId": {
                            "type": "string"
                        },
                        "PerformanceMode": {
                            "type": "string"
                        },
                        "ProvisionedThroughputInMibps": {
                            "type": "number"
                        },
                        "ThroughputMode": {
                            "type": "string"
                        }
                    },
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EFS::FileSystem"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type"
            ],
            "type": "object"
        },
        "AWS::EFS::FileSystem.ElasticFileSystemTag": {
            "additionalProperties": false,
            "properties": {
                "Key": {
                    "type": "string"
                },
                "Value": {
                    "type": "string"
                }
            },
            "required": [
                "Key",
                "Value"
            ],
            "type": "object"
        },
        "AWS::EFS::MountTarget": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "FileSystemId": {
                            "type": "string"
                        },
                        "IpAddress": {
                            "type": "string"
                        },
                        "SecurityGroups": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "SubnetId": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "FileSystemId",
                        "SecurityGroups",
                        "SubnetId"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EFS::MountTarget"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::EKS::Cluster": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Name": {
                            "type": "string"
                        },
                        "ResourcesVpcConfig": {
                            "$ref": "#/definitions/AWS::EKS::Cluster.ResourcesVpcConfig"
                        },
                        "RoleArn": {
                            "type": "string"
                        },
                        "Version": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "ResourcesVpcConfig",
                        "RoleArn"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EKS::Cluster"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::EKS::Cluster.ResourcesVpcConfig": {
            "additionalProperties": false,
            "properties": {
                "SecurityGroupIds": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "SubnetIds": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                }
            },
            "required": [
                "SubnetIds"
            ],
            "type": "object"
        },
        "AWS::EMR::Cluster": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "AdditionalInfo": {
                            "type": "object"
                        },
                        "Applications": {
                            "items": {
                                "$ref": "#/definitions/AWS::EMR::Cluster.Application"
                            },
                            "type": "array"
                        },
                        "AutoScalingRole": {
                            "type": "string"
                        },
                        "BootstrapActions": {
                            "items": {
                                "$ref": "#/definitions/AWS::EMR::Cluster.BootstrapActionConfig"
                            },
                            "type": "array"
                        },
                        "Configurations": {
                            "items": {
                                "$ref": "#/definitions/AWS::EMR::Cluster.Configuration"
                            },
                            "type": "array"
                        },
                        "CustomAmiId": {
                            "type": "string"
                        },
                        "EbsRootVolumeSize": {
                            "type": "number"
                        },
                        "Instances": {
                            "$ref": "#/definitions/AWS::EMR::Cluster.JobFlowInstancesConfig"
                        },
                        "JobFlowRole": {
                            "type": "string"
                        },
                        "KerberosAttributes": {
                            "$ref": "#/definitions/AWS::EMR::Cluster.KerberosAttributes"
                        },
                        "LogUri": {
                            "type": "string"
                        },
                        "Name": {
                            "type": "string"
                        },
                        "ReleaseLabel": {
                            "type": "string"
                        },
                        "ScaleDownBehavior": {
                            "type": "string"
                        },
                        "SecurityConfiguration": {
                            "type": "string"
                        },
                        "ServiceRole": {
                            "type": "string"
                        },
                        "Steps": {
                            "items": {
                                "$ref": "#/definitions/AWS::EMR::Cluster.StepConfig"
                            },
                            "type": "array"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        },
                        "VisibleToAllUsers": {
                            "type": "boolean"
                        }
                    },
                    "required": [
                        "Instances",
                        "JobFlowRole",
                        "Name",
                        "ServiceRole"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EMR::Cluster"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::EMR::Cluster.Application": {
            "additionalProperties": false,
            "properties": {
                "AdditionalInfo": {
                    "additionalProperties": true,
                    "patternProperties": {
                        "^[a-zA-Z0-9]+$": {
                            "type": "string"
                        }
                    },
                    "type": "object"
                },
                "Args": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "Name": {
                    "type": "string"
                },
                "Version": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::EMR::Cluster.AutoScalingPolicy": {
            "additionalProperties": false,
            "properties": {
                "Constraints": {
                    "$ref": "#/definitions/AWS::EMR::Cluster.ScalingConstraints"
                },
                "Rules": {
                    "items": {
                        "$ref": "#/definitions/AWS::EMR::Cluster.ScalingRule"
                    },
                    "type": "array"
                }
            },
            "required": [
                "Constraints",
                "Rules"
            ],
            "type": "object"
        },
        "AWS::EMR::Cluster.BootstrapActionConfig": {
            "additionalProperties": false,
            "properties": {
                "Name": {
                    "type": "string"
                },
                "ScriptBootstrapAction": {
                    "$ref": "#/definitions/AWS::EMR::Cluster.ScriptBootstrapActionConfig"
                }
            },
            "required": [
                "Name",
                "ScriptBootstrapAction"
            ],
            "type": "object"
        },
        "AWS::EMR::Cluster.CloudWatchAlarmDefinition": {
            "additionalProperties": false,
            "properties": {
                "ComparisonOperator": {
                    "type": "string"
                },
                "Dimensions": {
                    "items": {
                        "$ref": "#/definitions/AWS::EMR::Cluster.MetricDimension"
                    },
                    "type": "array"
                },
                "EvaluationPeriods": {
                    "type": "number"
                },
                "MetricName": {
                    "type": "string"
                },
                "Namespace": {
                    "type": "string"
                },
                "Period": {
                    "type": "number"
                },
                "Statistic": {
                    "type": "string"
                },
                "Threshold": {
                    "type": "number"
                },
                "Unit": {
                    "type": "string"
                }
            },
            "required": [
                "ComparisonOperator",
                "MetricName",
                "Period",
                "Threshold"
            ],
            "type": "object"
        },
        "AWS::EMR::Cluster.Configuration": {
            "additionalProperties": false,
            "properties": {
                "Classification": {
                    "type": "string"
                },
                "ConfigurationProperties": {
                    "additionalProperties": true,
                    "patternProperties": {
                        "^[a-zA-Z0-9]+$": {
                            "type": "string"
                        }
                    },
                    "type": "object"
                },
                "Configurations": {
                    "items": {
                        "$ref": "#/definitions/AWS::EMR::Cluster.Configuration"
                    },
                    "type": "array"
                }
            },
            "type": "object"
        },
        "AWS::EMR::Cluster.EbsBlockDeviceConfig": {
            "additionalProperties": false,
            "properties": {
                "VolumeSpecification": {
                    "$ref": "#/definitions/AWS::EMR::Cluster.VolumeSpecification"
                },
                "VolumesPerInstance": {
                    "type": "number"
                }
            },
            "required": [
                "VolumeSpecification"
            ],
            "type": "object"
        },
        "AWS::EMR::Cluster.EbsConfiguration": {
            "additionalProperties": false,
            "properties": {
                "EbsBlockDeviceConfigs": {
                    "items": {
                        "$ref": "#/definitions/AWS::EMR::Cluster.EbsBlockDeviceConfig"
                    },
                    "type": "array"
                },
                "EbsOptimized": {
                    "type": "boolean"
                }
            },
            "type": "object"
        },
        "AWS::EMR::Cluster.HadoopJarStepConfig": {
            "additionalProperties": false,
            "properties": {
                "Args": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "Jar": {
                    "type": "string"
                },
                "MainClass": {
                    "type": "string"
                },
                "StepProperties": {
                    "items": {
                        "$ref": "#/definitions/AWS::EMR::Cluster.KeyValue"
                    },
                    "type": "array"
                }
            },
            "required": [
                "Jar"
            ],
            "type": "object"
        },
        "AWS::EMR::Cluster.InstanceFleetConfig": {
            "additionalProperties": false,
            "properties": {
                "InstanceTypeConfigs": {
                    "items": {
                        "$ref": "#/definitions/AWS::EMR::Cluster.InstanceTypeConfig"
                    },
                    "type": "array"
                },
                "LaunchSpecifications": {
                    "$ref": "#/definitions/AWS::EMR::Cluster.InstanceFleetProvisioningSpecifications"
                },
                "Name": {
                    "type": "string"
                },
                "TargetOnDemandCapacity": {
                    "type": "number"
                },
                "TargetSpotCapacity": {
                    "type": "number"
                }
            },
            "type": "object"
        },
        "AWS::EMR::Cluster.InstanceFleetProvisioningSpecifications": {
            "additionalProperties": false,
            "properties": {
                "SpotSpecification": {
                    "$ref": "#/definitions/AWS::EMR::Cluster.SpotProvisioningSpecification"
                }
            },
            "required": [
                "SpotSpecification"
            ],
            "type": "object"
        },
        "AWS::EMR::Cluster.InstanceGroupConfig": {
            "additionalProperties": false,
            "properties": {
                "AutoScalingPolicy": {
                    "$ref": "#/definitions/AWS::EMR::Cluster.AutoScalingPolicy"
                },
                "BidPrice": {
                    "type": "string"
                },
                "Configurations": {
                    "items": {
                        "$ref": "#/definitions/AWS::EMR::Cluster.Configuration"
                    },
                    "type": "array"
                },
                "EbsConfiguration": {
                    "$ref": "#/definitions/AWS::EMR::Cluster.EbsConfiguration"
                },
                "InstanceCount": {
                    "type": "number"
                },
                "InstanceType": {
                    "type": "string"
                },
                "Market": {
                    "type": "string"
                },
                "Name": {
                    "type": "string"
                }
            },
            "required": [
                "InstanceCount",
                "InstanceType"
            ],
            "type": "object"
        },
        "AWS::EMR::Cluster.InstanceTypeConfig": {
            "additionalProperties": false,
            "properties": {
                "BidPrice": {
                    "type": "string"
                },
                "BidPriceAsPercentageOfOnDemandPrice": {
                    "type": "number"
                },
                "Configurations": {
                    "items": {
                        "$ref": "#/definitions/AWS::EMR::Cluster.Configuration"
                    },
                    "type": "array"
                },
                "EbsConfiguration": {
                    "$ref": "#/definitions/AWS::EMR::Cluster.EbsConfiguration"
                },
                "InstanceType": {
                    "type": "string"
                },
                "WeightedCapacity": {
                    "type": "number"
                }
            },
            "required": [
                "InstanceType"
            ],
            "type": "object"
        },
        "AWS::EMR::Cluster.JobFlowInstancesConfig": {
            "additionalProperties": false,
            "properties": {
                "AdditionalMasterSecurityGroups": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "AdditionalSlaveSecurityGroups": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "CoreInstanceFleet": {
                    "$ref": "#/definitions/AWS::EMR::Cluster.InstanceFleetConfig"
                },
                "CoreInstanceGroup": {
                    "$ref": "#/definitions/AWS::EMR::Cluster.InstanceGroupConfig"
                },
                "Ec2KeyName": {
                    "type": "string"
                },
                "Ec2SubnetId": {
                    "type": "string"
                },
                "EmrManagedMasterSecurityGroup": {
                    "type": "string"
                },
                "EmrManagedSlaveSecurityGroup": {
                    "type": "string"
                },
                "HadoopVersion": {
                    "type": "string"
                },
                "KeepJobFlowAliveWhenNoSteps": {
                    "type": "boolean"
                },
                "MasterInstanceFleet": {
                    "$ref": "#/definitions/AWS::EMR::Cluster.InstanceFleetConfig"
                },
                "MasterInstanceGroup": {
                    "$ref": "#/definitions/AWS::EMR::Cluster.InstanceGroupConfig"
                },
                "Placement": {
                    "$ref": "#/definitions/AWS::EMR::Cluster.PlacementType"
                },
                "ServiceAccessSecurityGroup": {
                    "type": "string"
                },
                "TerminationProtected": {
                    "type": "boolean"
                }
            },
            "type": "object"
        },
        "AWS::EMR::Cluster.KerberosAttributes": {
            "additionalProperties": false,
            "properties": {
                "ADDomainJoinPassword": {
                    "type": "string"
                },
                "ADDomainJoinUser": {
                    "type": "string"
                },
                "CrossRealmTrustPrincipalPassword": {
                    "type": "string"
                },
                "KdcAdminPassword": {
                    "type": "string"
                },
                "Realm": {
                    "type": "string"
                }
            },
            "required": [
                "KdcAdminPassword",
                "Realm"
            ],
            "type": "object"
        },
        "AWS::EMR::Cluster.KeyValue": {
            "additionalProperties": false,
            "properties": {
                "Key": {
                    "type": "string"
                },
                "Value": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::EMR::Cluster.MetricDimension": {
            "additionalProperties": false,
            "properties": {
                "Key": {
                    "type": "string"
                },
                "Value": {
                    "type": "string"
                }
            },
            "required": [
                "Key",
                "Value"
            ],
            "type": "object"
        },
        "AWS::EMR::Cluster.PlacementType": {
            "additionalProperties": false,
            "properties": {
                "AvailabilityZone": {
                    "type": "string"
                }
            },
            "required": [
                "AvailabilityZone"
            ],
            "type": "object"
        },
        "AWS::EMR::Cluster.ScalingAction": {
            "additionalProperties": false,
            "properties": {
                "Market": {
                    "type": "string"
                },
                "SimpleScalingPolicyConfiguration": {
                    "$ref": "#/definitions/AWS::EMR::Cluster.SimpleScalingPolicyConfiguration"
                }
            },
            "required": [
                "SimpleScalingPolicyConfiguration"
            ],
            "type": "object"
        },
        "AWS::EMR::Cluster.ScalingConstraints": {
            "additionalProperties": false,
            "properties": {
                "MaxCapacity": {
                    "type": "number"
                },
                "MinCapacity": {
                    "type": "number"
                }
            },
            "required": [
                "MaxCapacity",
                "MinCapacity"
            ],
            "type": "object"
        },
        "AWS::EMR::Cluster.ScalingRule": {
            "additionalProperties": false,
            "properties": {
                "Action": {
                    "$ref": "#/definitions/AWS::EMR::Cluster.ScalingAction"
                },
                "Description": {
                    "type": "string"
                },
                "Name": {
                    "type": "string"
                },
                "Trigger": {
                    "$ref": "#/definitions/AWS::EMR::Cluster.ScalingTrigger"
                }
            },
            "required": [
                "Action",
                "Name",
                "Trigger"
            ],
            "type": "object"
        },
        "AWS::EMR::Cluster.ScalingTrigger": {
            "additionalProperties": false,
            "properties": {
                "CloudWatchAlarmDefinition": {
                    "$ref": "#/definitions/AWS::EMR::Cluster.CloudWatchAlarmDefinition"
                }
            },
            "required": [
                "CloudWatchAlarmDefinition"
            ],
            "type": "object"
        },
        "AWS::EMR::Cluster.ScriptBootstrapActionConfig": {
            "additionalProperties": false,
            "properties": {
                "Args": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "Path": {
                    "type": "string"
                }
            },
            "required": [
                "Path"
            ],
            "type": "object"
        },
        "AWS::EMR::Cluster.SimpleScalingPolicyConfiguration": {
            "additionalProperties": false,
            "properties": {
                "AdjustmentType": {
                    "type": "string"
                },
                "CoolDown": {
                    "type": "number"
                },
                "ScalingAdjustment": {
                    "type": "number"
                }
            },
            "required": [
                "ScalingAdjustment"
            ],
            "type": "object"
        },
        "AWS::EMR::Cluster.SpotProvisioningSpecification": {
            "additionalProperties": false,
            "properties": {
                "BlockDurationMinutes": {
                    "type": "number"
                },
                "TimeoutAction": {
                    "type": "string"
                },
                "TimeoutDurationMinutes": {
                    "type": "number"
                }
            },
            "required": [
                "TimeoutAction",
                "TimeoutDurationMinutes"
            ],
            "type": "object"
        },
        "AWS::EMR::Cluster.StepConfig": {
            "additionalProperties": false,
            "properties": {
                "ActionOnFailure": {
                    "type": "string"
                },
                "HadoopJarStep": {
                    "$ref": "#/definitions/AWS::EMR::Cluster.HadoopJarStepConfig"
                },
                "Name": {
                    "type": "string"
                }
            },
            "required": [
                "HadoopJarStep",
                "Name"
            ],
            "type": "object"
        },
        "AWS::EMR::Cluster.VolumeSpecification": {
            "additionalProperties": false,
            "properties": {
                "Iops": {
                    "type": "number"
                },
                "SizeInGB": {
                    "type": "number"
                },
                "VolumeType": {
                    "type": "string"
                }
            },
            "required": [
                "SizeInGB",
                "VolumeType"
            ],
            "type": "object"
        },
        "AWS::EMR::InstanceFleetConfig": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "ClusterId": {
                            "type": "string"
                        },
                        "InstanceFleetType": {
                            "type": "string"
                        },
                        "InstanceTypeConfigs": {
                            "items": {
                                "$ref": "#/definitions/AWS::EMR::InstanceFleetConfig.InstanceTypeConfig"
                            },
                            "type": "array"
                        },
                        "LaunchSpecifications": {
                            "$ref": "#/definitions/AWS::EMR::InstanceFleetConfig.InstanceFleetProvisioningSpecifications"
                        },
                        "Name": {
                            "type": "string"
                        },
                        "TargetOnDemandCapacity": {
                            "type": "number"
                        },
                        "TargetSpotCapacity": {
                            "type": "number"
                        }
                    },
                    "required": [
                        "ClusterId",
                        "InstanceFleetType"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EMR::InstanceFleetConfig"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::EMR::InstanceFleetConfig.Configuration": {
            "additionalProperties": false,
            "properties": {
                "Classification": {
                    "type": "string"
                },
                "ConfigurationProperties": {
                    "additionalProperties": true,
                    "patternProperties": {
                        "^[a-zA-Z0-9]+$": {
                            "type": "string"
                        }
                    },
                    "type": "object"
                },
                "Configurations": {
                    "items": {
                        "$ref": "#/definitions/AWS::EMR::InstanceFleetConfig.Configuration"
                    },
                    "type": "array"
                }
            },
            "type": "object"
        },
        "AWS::EMR::InstanceFleetConfig.EbsBlockDeviceConfig": {
            "additionalProperties": false,
            "properties": {
                "VolumeSpecification": {
                    "$ref": "#/definitions/AWS::EMR::InstanceFleetConfig.VolumeSpecification"
                },
                "VolumesPerInstance": {
                    "type": "number"
                }
            },
            "required": [
                "VolumeSpecification"
            ],
            "type": "object"
        },
        "AWS::EMR::InstanceFleetConfig.EbsConfiguration": {
            "additionalProperties": false,
            "properties": {
                "EbsBlockDeviceConfigs": {
                    "items": {
                        "$ref": "#/definitions/AWS::EMR::InstanceFleetConfig.EbsBlockDeviceConfig"
                    },
                    "type": "array"
                },
                "EbsOptimized": {
                    "type": "boolean"
                }
            },
            "type": "object"
        },
        "AWS::EMR::InstanceFleetConfig.InstanceFleetProvisioningSpecifications": {
            "additionalProperties": false,
            "properties": {
                "SpotSpecification": {
                    "$ref": "#/definitions/AWS::EMR::InstanceFleetConfig.SpotProvisioningSpecification"
                }
            },
            "required": [
                "SpotSpecification"
            ],
            "type": "object"
        },
        "AWS::EMR::InstanceFleetConfig.InstanceTypeConfig": {
            "additionalProperties": false,
            "properties": {
                "BidPrice": {
                    "type": "string"
                },
                "BidPriceAsPercentageOfOnDemandPrice": {
                    "type": "number"
                },
                "Configurations": {
                    "items": {
                        "$ref": "#/definitions/AWS::EMR::InstanceFleetConfig.Configuration"
                    },
                    "type": "array"
                },
                "EbsConfiguration": {
                    "$ref": "#/definitions/AWS::EMR::InstanceFleetConfig.EbsConfiguration"
                },
                "InstanceType": {
                    "type": "string"
                },
                "WeightedCapacity": {
                    "type": "number"
                }
            },
            "required": [
                "InstanceType"
            ],
            "type": "object"
        },
        "AWS::EMR::InstanceFleetConfig.SpotProvisioningSpecification": {
            "additionalProperties": false,
            "properties": {
                "BlockDurationMinutes": {
                    "type": "number"
                },
                "TimeoutAction": {
                    "type": "string"
                },
                "TimeoutDurationMinutes": {
                    "type": "number"
                }
            },
            "required": [
                "TimeoutAction",
                "TimeoutDurationMinutes"
            ],
            "type": "object"
        },
        "AWS::EMR::InstanceFleetConfig.VolumeSpecification": {
            "additionalProperties": false,
            "properties": {
                "Iops": {
                    "type": "number"
                },
                "SizeInGB": {
                    "type": "number"
                },
                "VolumeType": {
                    "type": "string"
                }
            },
            "required": [
                "SizeInGB",
                "VolumeType"
            ],
            "type": "object"
        },
        "AWS::EMR::InstanceGroupConfig": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "AutoScalingPolicy": {
                            "$ref": "#/definitions/AWS::EMR::InstanceGroupConfig.AutoScalingPolicy"
                        },
                        "BidPrice": {
                            "type": "string"
                        },
                        "Configurations": {
                            "items": {
                                "$ref": "#/definitions/AWS::EMR::InstanceGroupConfig.Configuration"
                            },
                            "type": "array"
                        },
                        "EbsConfiguration": {
                            "$ref": "#/definitions/AWS::EMR::InstanceGroupConfig.EbsConfiguration"
                        },
                        "InstanceCount": {
                            "type": "number"
                        },
                        "InstanceRole": {
                            "type": "string"
                        },
                        "InstanceType": {
                            "type": "string"
                        },
                        "JobFlowId": {
                            "type": "string"
                        },
                        "Market": {
                            "type": "string"
                        },
                        "Name": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "InstanceCount",
                        "InstanceRole",
                        "InstanceType",
                        "JobFlowId"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EMR::InstanceGroupConfig"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::EMR::InstanceGroupConfig.AutoScalingPolicy": {
            "additionalProperties": false,
            "properties": {
                "Constraints": {
                    "$ref": "#/definitions/AWS::EMR::InstanceGroupConfig.ScalingConstraints"
                },
                "Rules": {
                    "items": {
                        "$ref": "#/definitions/AWS::EMR::InstanceGroupConfig.ScalingRule"
                    },
                    "type": "array"
                }
            },
            "required": [
                "Constraints",
                "Rules"
            ],
            "type": "object"
        },
        "AWS::EMR::InstanceGroupConfig.CloudWatchAlarmDefinition": {
            "additionalProperties": false,
            "properties": {
                "ComparisonOperator": {
                    "type": "string"
                },
                "Dimensions": {
                    "items": {
                        "$ref": "#/definitions/AWS::EMR::InstanceGroupConfig.MetricDimension"
                    },
                    "type": "array"
                },
                "EvaluationPeriods": {
                    "type": "number"
                },
                "MetricName": {
                    "type": "string"
                },
                "Namespace": {
                    "type": "string"
                },
                "Period": {
                    "type": "number"
                },
                "Statistic": {
                    "type": "string"
                },
                "Threshold": {
                    "type": "number"
                },
                "Unit": {
                    "type": "string"
                }
            },
            "required": [
                "ComparisonOperator",
                "MetricName",
                "Period",
                "Threshold"
            ],
            "type": "object"
        },
        "AWS::EMR::InstanceGroupConfig.Configuration": {
            "additionalProperties": false,
            "properties": {
                "Classification": {
                    "type": "string"
                },
                "ConfigurationProperties": {
                    "additionalProperties": true,
                    "patternProperties": {
                        "^[a-zA-Z0-9]+$": {
                            "type": "string"
                        }
                    },
                    "type": "object"
                },
                "Configurations": {
                    "items": {
                        "$ref": "#/definitions/AWS::EMR::InstanceGroupConfig.Configuration"
                    },
                    "type": "array"
                }
            },
            "type": "object"
        },
        "AWS::EMR::InstanceGroupConfig.EbsBlockDeviceConfig": {
            "additionalProperties": false,
            "properties": {
                "VolumeSpecification": {
                    "$ref": "#/definitions/AWS::EMR::InstanceGroupConfig.VolumeSpecification"
                },
                "VolumesPerInstance": {
                    "type": "number"
                }
            },
            "required": [
                "VolumeSpecification"
            ],
            "type": "object"
        },
        "AWS::EMR::InstanceGroupConfig.EbsConfiguration": {
            "additionalProperties": false,
            "properties": {
                "EbsBlockDeviceConfigs": {
                    "items": {
                        "$ref": "#/definitions/AWS::EMR::InstanceGroupConfig.EbsBlockDeviceConfig"
                    },
                    "type": "array"
                },
                "EbsOptimized": {
                    "type": "boolean"
                }
            },
            "type": "object"
        },
        "AWS::EMR::InstanceGroupConfig.MetricDimension": {
            "additionalProperties": false,
            "properties": {
                "Key": {
                    "type": "string"
                },
                "Value": {
                    "type": "string"
                }
            },
            "required": [
                "Key",
                "Value"
            ],
            "type": "object"
        },
        "AWS::EMR::InstanceGroupConfig.ScalingAction": {
            "additionalProperties": false,
            "properties": {
                "Market": {
                    "type": "string"
                },
                "SimpleScalingPolicyConfiguration": {
                    "$ref": "#/definitions/AWS::EMR::InstanceGroupConfig.SimpleScalingPolicyConfiguration"
                }
            },
            "required": [
                "SimpleScalingPolicyConfiguration"
            ],
            "type": "object"
        },
        "AWS::EMR::InstanceGroupConfig.ScalingConstraints": {
            "additionalProperties": false,
            "properties": {
                "MaxCapacity": {
                    "type": "number"
                },
                "MinCapacity": {
                    "type": "number"
                }
            },
            "required": [
                "MaxCapacity",
                "MinCapacity"
            ],
            "type": "object"
        },
        "AWS::EMR::InstanceGroupConfig.ScalingRule": {
            "additionalProperties": false,
            "properties": {
                "Action": {
                    "$ref": "#/definitions/AWS::EMR::InstanceGroupConfig.ScalingAction"
                },
                "Description": {
                    "type": "string"
                },
                "Name": {
                    "type": "string"
                },
                "Trigger": {
                    "$ref": "#/definitions/AWS::EMR::InstanceGroupConfig.ScalingTrigger"
                }
            },
            "required": [
                "Action",
                "Name",
                "Trigger"
            ],
            "type": "object"
        },
        "AWS::EMR::InstanceGroupConfig.ScalingTrigger": {
            "additionalProperties": false,
            "properties": {
                "CloudWatchAlarmDefinition": {
                    "$ref": "#/definitions/AWS::EMR::InstanceGroupConfig.CloudWatchAlarmDefinition"
                }
            },
            "required": [
                "CloudWatchAlarmDefinition"
            ],
            "type": "object"
        },
        "AWS::EMR::InstanceGroupConfig.SimpleScalingPolicyConfiguration": {
            "additionalProperties": false,
            "properties": {
                "AdjustmentType": {
                    "type": "string"
                },
                "CoolDown": {
                    "type": "number"
                },
                "ScalingAdjustment": {
                    "type": "number"
                }
            },
            "required": [
                "ScalingAdjustment"
            ],
            "type": "object"
        },
        "AWS::EMR::InstanceGroupConfig.VolumeSpecification": {
            "additionalProperties": false,
            "properties": {
                "Iops": {
                    "type": "number"
                },
                "SizeInGB": {
                    "type": "number"
                },
                "VolumeType": {
                    "type": "string"
                }
            },
            "required": [
                "SizeInGB",
                "VolumeType"
            ],
            "type": "object"
        },
        "AWS::EMR::SecurityConfiguration": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Name": {
                            "type": "string"
                        },
                        "SecurityConfiguration": {
                            "type": "object"
                        }
                    },
                    "required": [
                        "SecurityConfiguration"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EMR::SecurityConfiguration"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::EMR::Step": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "ActionOnFailure": {
                            "type": "string"
                        },
                        "HadoopJarStep": {
                            "$ref": "#/definitions/AWS::EMR::Step.HadoopJarStepConfig"
                        },
                        "JobFlowId": {
                            "type": "string"
                        },
                        "Name": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "ActionOnFailure",
                        "HadoopJarStep",
                        "JobFlowId",
                        "Name"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::EMR::Step"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::EMR::Step.HadoopJarStepConfig": {
            "additionalProperties": false,
            "properties": {
                "Args": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "Jar": {
                    "type": "string"
                },
                "MainClass": {
                    "type": "string"
                },
                "StepProperties": {
                    "items": {
                        "$ref": "#/definitions/AWS::EMR::Step.KeyValue"
                    },
                    "type": "array"
                }
            },
            "required": [
                "Jar"
            ],
            "type": "object"
        },
        "AWS::EMR::Step.KeyValue": {
            "additionalProperties": false,
            "properties": {
                "Key": {
                    "type": "string"
                },
                "Value": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::ElastiCache::CacheCluster": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "AZMode": {
                            "type": "string"
                        },
                        "AutoMinorVersionUpgrade": {
                            "type": "boolean"
                        },
                        "CacheNodeType": {
                            "type": "string"
                        },
                        "CacheParameterGroupName": {
                            "type": "string"
                        },
                        "CacheSecurityGroupNames": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "CacheSubnetGroupName": {
                            "type": "string"
                        },
                        "ClusterName": {
                            "type": "string"
                        },
                        "Engine": {
                            "type": "string"
                        },
                        "EngineVersion": {
                            "type": "string"
                        },
                        "NotificationTopicArn": {
                            "type": "string"
                        },
                        "NumCacheNodes": {
                            "type": "number"
                        },
                        "Port": {
                            "type": "number"
                        },
                        "PreferredAvailabilityZone": {
                            "type": "string"
                        },
                        "PreferredAvailabilityZones": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "PreferredMaintenanceWindow": {
                            "type": "string"
                        },
                        "SnapshotArns": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "SnapshotName": {
                            "type": "string"
                        },
                        "SnapshotRetentionLimit": {
                            "type": "number"
                        },
                        "SnapshotWindow": {
                            "type": "string"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        },
                        "VpcSecurityGroupIds": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        }
                    },
                    "required": [
                        "CacheNodeType",
                        "Engine",
                        "NumCacheNodes"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::ElastiCache::CacheCluster"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::ElastiCache::ParameterGroup": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "CacheParameterGroupFamily": {
                            "type": "string"
                        },
                        "Description": {
                            "type": "string"
                        },
                        "Properties": {
                            "additionalProperties": true,
                            "patternProperties": {
                                "^[a-zA-Z0-9]+$": {
                                    "type": "string"
                                }
                            },
                            "type": "object"
                        }
                    },
                    "required": [
                        "CacheParameterGroupFamily",
                        "Description"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::ElastiCache::ParameterGroup"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::ElastiCache::ReplicationGroup": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "AtRestEncryptionEnabled": {
                            "type": "boolean"
                        },
                        "AuthToken": {
                            "type": "string"
                        },
                        "AutoMinorVersionUpgrade": {
                            "type": "boolean"
                        },
                        "AutomaticFailoverEnabled": {
                            "type": "boolean"
                        },
                        "CacheNodeType": {
                            "type": "string"
                        },
                        "CacheParameterGroupName": {
                            "type": "string"
                        },
                        "CacheSecurityGroupNames": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "CacheSubnetGroupName": {
                            "type": "string"
                        },
                        "Engine": {
                            "type": "string"
                        },
                        "EngineVersion": {
                            "type": "string"
                        },
                        "NodeGroupConfiguration": {
                            "items": {
                                "$ref": "#/definitions/AWS::ElastiCache::ReplicationGroup.NodeGroupConfiguration"
                            },
                            "type": "array"
                        },
                        "NotificationTopicArn": {
                            "type": "string"
                        },
                        "NumCacheClusters": {
                            "type": "number"
                        },
                        "NumNodeGroups": {
                            "type": "number"
                        },
                        "Port": {
                            "type": "number"
                        },
                        "PreferredCacheClusterAZs": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "PreferredMaintenanceWindow": {
                            "type": "string"
                        },
                        "PrimaryClusterId": {
                            "type": "string"
                        },
                        "ReplicasPerNodeGroup": {
                            "type": "number"
                        },
                        "ReplicationGroupDescription": {
                            "type": "string"
                        },
                        "ReplicationGroupId": {
                            "type": "string"
                        },
                        "SecurityGroupIds": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "SnapshotArns": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "SnapshotName": {
                            "type": "string"
                        },
                        "SnapshotRetentionLimit": {
                            "type": "number"
                        },
                        "SnapshotWindow": {
                            "type": "string"
                        },
                        "SnapshottingClusterId": {
                            "type": "string"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        },
                        "TransitEncryptionEnabled": {
                            "type": "boolean"
                        }
                    },
                    "required": [
                        "ReplicationGroupDescription"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::ElastiCache::ReplicationGroup"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::ElastiCache::ReplicationGroup.NodeGroupConfiguration": {
            "additionalProperties": false,
            "properties": {
                "NodeGroupId": {
                    "type": "string"
                },
                "PrimaryAvailabilityZone": {
                    "type": "string"
                },
                "ReplicaAvailabilityZones": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "ReplicaCount": {
                    "type": "number"
                },
                "Slots": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::ElastiCache::SecurityGroup": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Description": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "Description"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::ElastiCache::SecurityGroup"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::ElastiCache::SecurityGroupIngress": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "CacheSecurityGroupName": {
                            "type": "string"
                        },
                        "EC2SecurityGroupName": {
                            "type": "string"
                        },
                        "EC2SecurityGroupOwnerId": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "CacheSecurityGroupName",
                        "EC2SecurityGroupName"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::ElastiCache::SecurityGroupIngress"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::ElastiCache::SubnetGroup": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "CacheSubnetGroupName": {
                            "type": "string"
                        },
                        "Description": {
                            "type": "string"
                        },
                        "SubnetIds": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        }
                    },
                    "required": [
                        "Description",
                        "SubnetIds"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::ElastiCache::SubnetGroup"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::ElasticBeanstalk::Application": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "ApplicationName": {
                            "type": "string"
                        },
                        "Description": {
                            "type": "string"
                        },
                        "ResourceLifecycleConfig": {
                            "$ref": "#/definitions/AWS::ElasticBeanstalk::Application.ApplicationResourceLifecycleConfig"
                        }
                    },
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::ElasticBeanstalk::Application"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type"
            ],
            "type": "object"
        },
        "AWS::ElasticBeanstalk::Application.ApplicationResourceLifecycleConfig": {
            "additionalProperties": false,
            "properties": {
                "ServiceRole": {
                    "type": "string"
                },
                "VersionLifecycleConfig": {
                    "$ref": "#/definitions/AWS::ElasticBeanstalk::Application.ApplicationVersionLifecycleConfig"
                }
            },
            "type": "object"
        },
        "AWS::ElasticBeanstalk::Application.ApplicationVersionLifecycleConfig": {
            "additionalProperties": false,
            "properties": {
                "MaxAgeRule": {
                    "$ref": "#/definitions/AWS::ElasticBeanstalk::Application.MaxAgeRule"
                },
                "MaxCountRule": {
                    "$ref": "#/definitions/AWS::ElasticBeanstalk::Application.MaxCountRule"
                }
            },
            "type": "object"
        },
        "AWS::ElasticBeanstalk::Application.MaxAgeRule": {
            "additionalProperties": false,
            "properties": {
                "DeleteSourceFromS3": {
                    "type": "boolean"
                },
                "Enabled": {
                    "type": "boolean"
                },
                "MaxAgeInDays": {
                    "type": "number"
                }
            },
            "type": "object"
        },
        "AWS::ElasticBeanstalk::Application.MaxCountRule": {
            "additionalProperties": false,
            "properties": {
                "DeleteSourceFromS3": {
                    "type": "boolean"
                },
                "Enabled": {
                    "type": "boolean"
                },
                "MaxCount": {
                    "type": "number"
                }
            },
            "type": "object"
        },
        "AWS::ElasticBeanstalk::ApplicationVersion": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "ApplicationName": {
                            "type": "string"
                        },
                        "Description": {
                            "type": "string"
                        },
                        "SourceBundle": {
                            "$ref": "#/definitions/AWS::ElasticBeanstalk::ApplicationVersion.SourceBundle"
                        }
                    },
                    "required": [
                        "ApplicationName",
                        "SourceBundle"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::ElasticBeanstalk::ApplicationVersion"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::ElasticBeanstalk::ApplicationVersion.SourceBundle": {
            "additionalProperties": false,
            "properties": {
                "S3Bucket": {
                    "type": "string"
                },
                "S3Key": {
                    "type": "string"
                }
            },
            "required": [
                "S3Bucket",
                "S3Key"
            ],
            "type": "object"
        },
        "AWS::ElasticBeanstalk::ConfigurationTemplate": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "ApplicationName": {
                            "type": "string"
                        },
                        "Description": {
                            "type": "string"
                        },
                        "EnvironmentId": {
                            "type": "string"
                        },
                        "OptionSettings": {
                            "items": {
                                "$ref": "#/definitions/AWS::ElasticBeanstalk::ConfigurationTemplate.ConfigurationOptionSetting"
                            },
                            "type": "array"
                        },
                        "PlatformArn": {
                            "type": "string"
                        },
                        "SolutionStackName": {
                            "type": "string"
                        },
                        "SourceConfiguration": {
                            "$ref": "#/definitions/AWS::ElasticBeanstalk::ConfigurationTemplate.SourceConfiguration"
                        }
                    },
                    "required": [
                        "ApplicationName"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::ElasticBeanstalk::ConfigurationTemplate"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::ElasticBeanstalk::ConfigurationTemplate.ConfigurationOptionSetting": {
            "additionalProperties": false,
            "properties": {
                "Namespace": {
                    "type": "string"
                },
                "OptionName": {
                    "type": "string"
                },
                "ResourceName": {
                    "type": "string"
                },
                "Value": {
                    "type": "string"
                }
            },
            "required": [
                "Namespace",
                "OptionName"
            ],
            "type": "object"
        },
        "AWS::ElasticBeanstalk::ConfigurationTemplate.SourceConfiguration": {
            "additionalProperties": false,
            "properties": {
                "ApplicationName": {
                    "type": "string"
                },
                "TemplateName": {
                    "type": "string"
                }
            },
            "required": [
                "ApplicationName",
                "TemplateName"
            ],
            "type": "object"
        },
        "AWS::ElasticBeanstalk::Environment": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "ApplicationName": {
                            "type": "string"
                        },
                        "CNAMEPrefix": {
                            "type": "string"
                        },
                        "Description": {
                            "type": "string"
                        },
                        "EnvironmentName": {
                            "type": "string"
                        },
                        "OptionSettings": {
                            "items": {
                                "$ref": "#/definitions/AWS::ElasticBeanstalk::Environment.OptionSetting"
                            },
                            "type": "array"
                        },
                        "PlatformArn": {
                            "type": "string"
                        },
                        "SolutionStackName": {
                            "type": "string"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        },
                        "TemplateName": {
                            "type": "string"
                        },
                        "Tier": {
                            "$ref": "#/definitions/AWS::ElasticBeanstalk::Environment.Tier"
                        },
                        "VersionLabel": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "ApplicationName"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::ElasticBeanstalk::Environment"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::ElasticBeanstalk::Environment.OptionSetting": {
            "additionalProperties": false,
            "properties": {
                "Namespace": {
                    "type": "string"
                },
                "OptionName": {
                    "type": "string"
                },
                "ResourceName": {
                    "type": "string"
                },
                "Value": {
                    "type": "string"
                }
            },
            "required": [
                "Namespace",
                "OptionName"
            ],
            "type": "object"
        },
        "AWS::ElasticBeanstalk::Environment.Tier": {
            "additionalProperties": false,
            "properties": {
                "Name": {
                    "type": "string"
                },
                "Type": {
                    "type": "string"
                },
                "Version": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::ElasticLoadBalancing::LoadBalancer": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "AccessLoggingPolicy": {
                            "$ref": "#/definitions/AWS::ElasticLoadBalancing::LoadBalancer.AccessLoggingPolicy"
                        },
                        "AppCookieStickinessPolicy": {
                            "items": {
                                "$ref": "#/definitions/AWS::ElasticLoadBalancing::LoadBalancer.AppCookieStickinessPolicy"
                            },
                            "type": "array"
                        },
                        "AvailabilityZones": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "ConnectionDrainingPolicy": {
                            "$ref": "#/definitions/AWS::ElasticLoadBalancing::LoadBalancer.ConnectionDrainingPolicy"
                        },
                        "ConnectionSettings": {
                            "$ref": "#/definitions/AWS::ElasticLoadBalancing::LoadBalancer.ConnectionSettings"
                        },
                        "CrossZone": {
                            "type": "boolean"
                        },
                        "HealthCheck": {
                            "$ref": "#/definitions/AWS::ElasticLoadBalancing::LoadBalancer.HealthCheck"
                        },
                        "Instances": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "LBCookieStickinessPolicy": {
                            "items": {
                                "$ref": "#/definitions/AWS::ElasticLoadBalancing::LoadBalancer.LBCookieStickinessPolicy"
                            },
                            "type": "array"
                        },
                        "Listeners": {
                            "items": {
                                "$ref": "#/definitions/AWS::ElasticLoadBalancing::LoadBalancer.Listeners"
                            },
                            "type": "array"
                        },
                        "LoadBalancerName": {
                            "type": "string"
                        },
                        "Policies": {
                            "items": {
                                "$ref": "#/definitions/AWS::ElasticLoadBalancing::LoadBalancer.Policies"
                            },
                            "type": "array"
                        },
                        "Scheme": {
                            "type": "string"
                        },
                        "SecurityGroups": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "Subnets": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        }
                    },
                    "required": [
                        "Listeners"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::ElasticLoadBalancing::LoadBalancer"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::ElasticLoadBalancing::LoadBalancer.AccessLoggingPolicy": {
            "additionalProperties": false,
            "properties": {
                "EmitInterval": {
                    "type": "number"
                },
                "Enabled": {
                    "type": "boolean"
                },
                "S3BucketName": {
                    "type": "string"
                },
                "S3BucketPrefix": {
                    "type": "string"
                }
            },
            "required": [
                "Enabled",
                "S3BucketName"
            ],
            "type": "object"
        },
        "AWS::ElasticLoadBalancing::LoadBalancer.AppCookieStickinessPolicy": {
            "additionalProperties": false,
            "properties": {
                "CookieName": {
                    "type": "string"
                },
                "PolicyName": {
                    "type": "string"
                }
            },
            "required": [
                "CookieName",
                "PolicyName"
            ],
            "type": "object"
        },
        "AWS::ElasticLoadBalancing::LoadBalancer.ConnectionDrainingPolicy": {
            "additionalProperties": false,
            "properties": {
                "Enabled": {
                    "type": "boolean"
                },
                "Timeout": {
                    "type": "number"
                }
            },
            "required": [
                "Enabled"
            ],
            "type": "object"
        },
        "AWS::ElasticLoadBalancing::LoadBalancer.ConnectionSettings": {
            "additionalProperties": false,
            "properties": {
                "IdleTimeout": {
                    "type": "number"
                }
            },
            "required": [
                "IdleTimeout"
            ],
            "type": "object"
        },
        "AWS::ElasticLoadBalancing::LoadBalancer.HealthCheck": {
            "additionalProperties": false,
            "properties": {
                "HealthyThreshold": {
                    "type": "string"
                },
                "Interval": {
                    "type": "string"
                },
                "Target": {
                    "type": "string"
                },
                "Timeout": {
                    "type": "string"
                },
                "UnhealthyThreshold": {
                    "type": "string"
                }
            },
            "required": [
                "HealthyThreshold",
                "Interval",
                "Target",
                "Timeout",
                "UnhealthyThreshold"
            ],
            "type": "object"
        },
        "AWS::ElasticLoadBalancing::LoadBalancer.LBCookieStickinessPolicy": {
            "additionalProperties": false,
            "properties": {
                "CookieExpirationPeriod": {
                    "type": "string"
                },
                "PolicyName": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::ElasticLoadBalancing::LoadBalancer.Listeners": {
            "additionalProperties": false,
            "properties": {
                "InstancePort": {
                    "type": "string"
                },
                "InstanceProtocol": {
                    "type": "string"
                },
                "LoadBalancerPort": {
                    "type": "string"
                },
                "PolicyNames": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "Protocol": {
                    "type": "string"
                },
                "SSLCertificateId": {
                    "type": "string"
                }
            },
            "required": [
                "InstancePort",
                "LoadBalancerPort",
                "Protocol"
            ],
            "type": "object"
        },
        "AWS::ElasticLoadBalancing::LoadBalancer.Policies": {
            "additionalProperties": false,
            "properties": {
                "Attributes": {
                    "items": {
                        "type": "object"
                    },
                    "type": "array"
                },
                "InstancePorts": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "LoadBalancerPorts": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "PolicyName": {
                    "type": "string"
                },
                "PolicyType": {
                    "type": "string"
                }
            },
            "required": [
                "Attributes",
                "PolicyName",
                "PolicyType"
            ],
            "type": "object"
        },
        "AWS::ElasticLoadBalancingV2::Listener": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Certificates": {
                            "items": {
                                "$ref": "#/definitions/AWS::ElasticLoadBalancingV2::Listener.Certificate"
                            },
                            "type": "array"
                        },
                        "DefaultActions": {
                            "items": {
                                "$ref": "#/definitions/AWS::ElasticLoadBalancingV2::Listener.Action"
                            },
                            "type": "array"
                        },
                        "LoadBalancerArn": {
                            "type": "string"
                        },
                        "Port": {
                            "type": "number"
                        },
                        "Protocol": {
                            "type": "string"
                        },
                        "SslPolicy": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "DefaultActions",
                        "LoadBalancerArn",
                        "Port",
                        "Protocol"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::ElasticLoadBalancingV2::Listener"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::ElasticLoadBalancingV2::Listener.Action": {
            "additionalProperties": false,
            "properties": {
                "AuthenticateCognitoConfig": {
                    "$ref": "#/definitions/AWS::ElasticLoadBalancingV2::Listener.AuthenticateCognitoConfig"
                },
                "AuthenticateOidcConfig": {
                    "$ref": "#/definitions/AWS::ElasticLoadBalancingV2::Listener.AuthenticateOidcConfig"
                },
                "FixedResponseConfig": {
                    "$ref": "#/definitions/AWS::ElasticLoadBalancingV2::Listener.FixedResponseConfig"
                },
                "Order": {
                    "type": "number"
                },
                "RedirectConfig": {
                    "$ref": "#/definitions/AWS::ElasticLoadBalancingV2::Listener.RedirectConfig"
                },
                "TargetGroupArn": {
                    "type": "string"
                },
                "Type": {
                    "type": "string"
                }
            },
            "required": [
                "Type"
            ],
            "type": "object"
        },
        "AWS::ElasticLoadBalancingV2::Listener.AuthenticateCognitoConfig": {
            "additionalProperties": false,
            "properties": {
                "AuthenticationRequestExtraParams": {
                    "additionalProperties": true,
                    "patternProperties": {
                        "^[a-zA-Z0-9]+$": {
                            "type": "string"
                        }
                    },
                    "type": "object"
                },
                "OnUnauthenticatedRequest": {
                    "type": "string"
                },
                "Scope": {
                    "type": "string"
                },
                "SessionCookieName": {
                    "type": "string"
                },
                "SessionTimeout": {
                    "type": "number"
                },
                "UserPoolArn": {
                    "type": "string"
                },
                "UserPoolClientId": {
                    "type": "string"
                },
                "UserPoolDomain": {
                    "type": "string"
                }
            },
            "required": [
                "UserPoolArn",
                "UserPoolClientId",
                "UserPoolDomain"
            ],
            "type": "object"
        },
        "AWS::ElasticLoadBalancingV2::Listener.AuthenticateOidcConfig": {
            "additionalProperties": false,
            "properties": {
                "AuthenticationRequestExtraParams": {
                    "additionalProperties": true,
                    "patternProperties": {
                        "^[a-zA-Z0-9]+$": {
                            "type": "string"
                        }
                    },
                    "type": "object"
                },
                "AuthorizationEndpoint": {
                    "type": "string"
                },
                "ClientId": {
                    "type": "string"
                },
                "ClientSecret": {
                    "type": "string"
                },
                "Issuer": {
                    "type": "string"
                },
                "OnUnauthenticatedRequest": {
                    "type": "string"
                },
                "Scope": {
                    "type": "string"
                },
                "SessionCookieName": {
                    "type": "string"
                },
                "SessionTimeout": {
                    "type": "number"
                },
                "TokenEndpoint": {
                    "type": "string"
                },
                "UserInfoEndpoint": {
                    "type": "string"
                }
            },
            "required": [
                "AuthorizationEndpoint",
                "ClientId",
                "ClientSecret",
                "Issuer",
                "TokenEndpoint",
                "UserInfoEndpoint"
            ],
            "type": "object"
        },
        "AWS::ElasticLoadBalancingV2::Listener.Certificate": {
            "additionalProperties": false,
            "properties": {
                "CertificateArn": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::ElasticLoadBalancingV2::Listener.FixedResponseConfig": {
            "additionalProperties": false,
            "properties": {
                "ContentType": {
                    "type": "string"
                },
                "MessageBody": {
                    "type": "string"
                },
                "StatusCode": {
                    "type": "string"
                }
            },
            "required": [
                "StatusCode"
            ],
            "type": "object"
        },
        "AWS::ElasticLoadBalancingV2::Listener.RedirectConfig": {
            "additionalProperties": false,
            "properties": {
                "Host": {
                    "type": "string"
                },
                "Path": {
                    "type": "string"
                },
                "Port": {
                    "type": "string"
                },
                "Protocol": {
                    "type": "string"
                },
                "Query": {
                    "type": "string"
                },
                "StatusCode": {
                    "type": "string"
                }
            },
            "required": [
                "StatusCode"
            ],
            "type": "object"
        },
        "AWS::ElasticLoadBalancingV2::ListenerCertificate": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Certificates": {
                            "items": {
                                "$ref": "#/definitions/AWS::ElasticLoadBalancingV2::ListenerCertificate.Certificate"
                            },
                            "type": "array"
                        },
                        "ListenerArn": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "Certificates",
                        "ListenerArn"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::ElasticLoadBalancingV2::ListenerCertificate"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::ElasticLoadBalancingV2::ListenerCertificate.Certificate": {
            "additionalProperties": false,
            "properties": {
                "CertificateArn": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::ElasticLoadBalancingV2::ListenerRule": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Actions": {
                            "items": {
                                "$ref": "#/definitions/AWS::ElasticLoadBalancingV2::ListenerRule.Action"
                            },
                            "type": "array"
                        },
                        "Conditions": {
                            "items": {
                                "$ref": "#/definitions/AWS::ElasticLoadBalancingV2::ListenerRule.RuleCondition"
                            },
                            "type": "array"
                        },
                        "ListenerArn": {
                            "type": "string"
                        },
                        "Priority": {
                            "type": "number"
                        }
                    },
                    "required": [
                        "Actions",
                        "Conditions",
                        "ListenerArn",
                        "Priority"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::ElasticLoadBalancingV2::ListenerRule"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::ElasticLoadBalancingV2::ListenerRule.Action": {
            "additionalProperties": false,
            "properties": {
                "AuthenticateCognitoConfig": {
                    "$ref": "#/definitions/AWS::ElasticLoadBalancingV2::ListenerRule.AuthenticateCognitoConfig"
                },
                "AuthenticateOidcConfig": {
                    "$ref": "#/definitions/AWS::ElasticLoadBalancingV2::ListenerRule.AuthenticateOidcConfig"
                },
                "FixedResponseConfig": {
                    "$ref": "#/definitions/AWS::ElasticLoadBalancingV2::ListenerRule.FixedResponseConfig"
                },
                "Order": {
                    "type": "number"
                },
                "RedirectConfig": {
                    "$ref": "#/definitions/AWS::ElasticLoadBalancingV2::ListenerRule.RedirectConfig"
                },
                "TargetGroupArn": {
                    "type": "string"
                },
                "Type": {
                    "type": "string"
                }
            },
            "required": [
                "Type"
            ],
            "type": "object"
        },
        "AWS::ElasticLoadBalancingV2::ListenerRule.AuthenticateCognitoConfig": {
            "additionalProperties": false,
            "properties": {
                "AuthenticationRequestExtraParams": {
                    "additionalProperties": true,
                    "patternProperties": {
                        "^[a-zA-Z0-9]+$": {
                            "type": "string"
                        }
                    },
                    "type": "object"
                },
                "OnUnauthenticatedRequest": {
                    "type": "string"
                },
                "Scope": {
                    "type": "string"
                },
                "SessionCookieName": {
                    "type": "string"
                },
                "SessionTimeout": {
                    "type": "number"
                },
                "UserPoolArn": {
                    "type": "string"
                },
                "UserPoolClientId": {
                    "type": "string"
                },
                "UserPoolDomain": {
                    "type": "string"
                }
            },
            "required": [
                "UserPoolArn",
                "UserPoolClientId",
                "UserPoolDomain"
            ],
            "type": "object"
        },
        "AWS::ElasticLoadBalancingV2::ListenerRule.AuthenticateOidcConfig": {
            "additionalProperties": false,
            "properties": {
                "AuthenticationRequestExtraParams": {
                    "additionalProperties": true,
                    "patternProperties": {
                        "^[a-zA-Z0-9]+$": {
                            "type": "string"
                        }
                    },
                    "type": "object"
                },
                "AuthorizationEndpoint": {
                    "type": "string"
                },
                "ClientId": {
                    "type": "string"
                },
                "ClientSecret": {
                    "type": "string"
                },
                "Issuer": {
                    "type": "string"
                },
                "OnUnauthenticatedRequest": {
                    "type": "string"
                },
                "Scope": {
                    "type": "string"
                },
                "SessionCookieName": {
                    "type": "string"
                },
                "SessionTimeout": {
                    "type": "number"
                },
                "TokenEndpoint": {
                    "type": "string"
                },
                "UserInfoEndpoint": {
                    "type": "string"
                }
            },
            "required": [
                "AuthorizationEndpoint",
                "ClientId",
                "ClientSecret",
                "Issuer",
                "TokenEndpoint",
                "UserInfoEndpoint"
            ],
            "type": "object"
        },
        "AWS::ElasticLoadBalancingV2::ListenerRule.FixedResponseConfig": {
            "additionalProperties": false,
            "properties": {
                "ContentType": {
                    "type": "string"
                },
                "MessageBody": {
                    "type": "string"
                },
                "StatusCode": {
                    "type": "string"
                }
            },
            "required": [
                "StatusCode"
            ],
            "type": "object"
        },
        "AWS::ElasticLoadBalancingV2::ListenerRule.RedirectConfig": {
            "additionalProperties": false,
            "properties": {
                "Host": {
                    "type": "string"
                },
                "Path": {
                    "type": "string"
                },
                "Port": {
                    "type": "string"
                },
                "Protocol": {
                    "type": "string"
                },
                "Query": {
                    "type": "string"
                },
                "StatusCode": {
                    "type": "string"
                }
            },
            "required": [
                "StatusCode"
            ],
            "type": "object"
        },
        "AWS::ElasticLoadBalancingV2::ListenerRule.RuleCondition": {
            "additionalProperties": false,
            "properties": {
                "Field": {
                    "type": "string"
                },
                "Values": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                }
            },
            "type": "object"
        },
        "AWS::ElasticLoadBalancingV2::LoadBalancer": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "IpAddressType": {
                            "type": "string"
                        },
                        "LoadBalancerAttributes": {
                            "items": {
                                "$ref": "#/definitions/AWS::ElasticLoadBalancingV2::LoadBalancer.LoadBalancerAttribute"
                            },
                            "type": "array"
                        },
                        "Name": {
                            "type": "string"
                        },
                        "Scheme": {
                            "type": "string"
                        },
                        "SecurityGroups": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "SubnetMappings": {
                            "items": {
                                "$ref": "#/definitions/AWS::ElasticLoadBalancingV2::LoadBalancer.SubnetMapping"
                            },
                            "type": "array"
                        },
                        "Subnets": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        },
                        "Type": {
                            "type": "string"
                        }
                    },
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::ElasticLoadBalancingV2::LoadBalancer"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type"
            ],
            "type": "object"
        },
        "AWS::ElasticLoadBalancingV2::LoadBalancer.LoadBalancerAttribute": {
            "additionalProperties": false,
            "properties": {
                "Key": {
                    "type": "string"
                },
                "Value": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::ElasticLoadBalancingV2::LoadBalancer.SubnetMapping": {
            "additionalProperties": false,
            "properties": {
                "AllocationId": {
                    "type": "string"
                },
                "SubnetId": {
                    "type": "string"
                }
            },
            "required": [
                "AllocationId",
                "SubnetId"
            ],
            "type": "object"
        },
        "AWS::ElasticLoadBalancingV2::TargetGroup": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "HealthCheckEnabled": {
                            "type": "boolean"
                        },
                        "HealthCheckIntervalSeconds": {
                            "type": "number"
                        },
                        "HealthCheckPath": {
                            "type": "string"
                        },
                        "HealthCheckPort": {
                            "type": "string"
                        },
                        "HealthCheckProtocol": {
                            "type": "string"
                        },
                        "HealthCheckTimeoutSeconds": {
                            "type": "number"
                        },
                        "HealthyThresholdCount": {
                            "type": "number"
                        },
                        "Matcher": {
                            "$ref": "#/definitions/AWS::ElasticLoadBalancingV2::TargetGroup.Matcher"
                        },
                        "Name": {
                            "type": "string"
                        },
                        "Port": {
                            "type": "number"
                        },
                        "Protocol": {
                            "type": "string"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        },
                        "TargetGroupAttributes": {
                            "items": {
                                "$ref": "#/definitions/AWS::ElasticLoadBalancingV2::TargetGroup.TargetGroupAttribute"
                            },
                            "type": "array"
                        },
                        "TargetType": {
                            "type": "string"
                        },
                        "Targets": {
                            "items": {
                                "$ref": "#/definitions/AWS::ElasticLoadBalancingV2::TargetGroup.TargetDescription"
                            },
                            "type": "array"
                        },
                        "UnhealthyThresholdCount": {
                            "type": "number"
                        },
                        "VpcId": {
                            "type": "string"
                        }
                    },
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::ElasticLoadBalancingV2::TargetGroup"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type"
            ],
            "type": "object"
        },
        "AWS::ElasticLoadBalancingV2::TargetGroup.Matcher": {
            "additionalProperties": false,
            "properties": {
                "HttpCode": {
                    "type": "string"
                }
            },
            "required": [
                "HttpCode"
            ],
            "type": "object"
        },
        "AWS::ElasticLoadBalancingV2::TargetGroup.TargetDescription": {
            "additionalProperties": false,
            "properties": {
                "AvailabilityZone": {
                    "type": "string"
                },
                "Id": {
                    "type": "string"
                },
                "Port": {
                    "type": "number"
                }
            },
            "required": [
                "Id"
            ],
            "type": "object"
        },
        "AWS::ElasticLoadBalancingV2::TargetGroup.TargetGroupAttribute": {
            "additionalProperties": false,
            "properties": {
                "Key": {
                    "type": "string"
                },
                "Value": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::Elasticsearch::Domain": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "AccessPolicies": {
                            "type": "object"
                        },
                        "AdvancedOptions": {
                            "additionalProperties": true,
                            "patternProperties": {
                                "^[a-zA-Z0-9]+$": {
                                    "type": "string"
                                }
                            },
                            "type": "object"
                        },
                        "DomainName": {
                            "type": "string"
                        },
                        "EBSOptions": {
                            "$ref": "#/definitions/AWS::Elasticsearch::Domain.EBSOptions"
                        },
                        "ElasticsearchClusterConfig": {
                            "$ref": "#/definitions/AWS::Elasticsearch::Domain.ElasticsearchClusterConfig"
                        },
                        "ElasticsearchVersion": {
                            "type": "string"
                        },
                        "EncryptionAtRestOptions": {
                            "$ref": "#/definitions/AWS::Elasticsearch::Domain.EncryptionAtRestOptions"
                        },
                        "NodeToNodeEncryptionOptions": {
                            "$ref": "#/definitions/AWS::Elasticsearch::Domain.NodeToNodeEncryptionOptions"
                        },
                        "SnapshotOptions": {
                            "$ref": "#/definitions/AWS::Elasticsearch::Domain.SnapshotOptions"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        },
                        "VPCOptions": {
                            "$ref": "#/definitions/AWS::Elasticsearch::Domain.VPCOptions"
                        }
                    },
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::Elasticsearch::Domain"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type"
            ],
            "type": "object"
        },
        "AWS::Elasticsearch::Domain.EBSOptions": {
            "additionalProperties": false,
            "properties": {
                "EBSEnabled": {
                    "type": "boolean"
                },
                "Iops": {
                    "type": "number"
                },
                "VolumeSize": {
                    "type": "number"
                },
                "VolumeType": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::Elasticsearch::Domain.ElasticsearchClusterConfig": {
            "additionalProperties": false,
            "properties": {
                "DedicatedMasterCount": {
                    "type": "number"
                },
                "DedicatedMasterEnabled": {
                    "type": "boolean"
                },
                "DedicatedMasterType": {
                    "type": "string"
                },
                "InstanceCount": {
                    "type": "number"
                },
                "InstanceType": {
                    "type": "string"
                },
                "ZoneAwarenessEnabled": {
                    "type": "boolean"
                }
            },
            "type": "object"
        },
        "AWS::Elasticsearch::Domain.EncryptionAtRestOptions": {
            "additionalProperties": false,
            "properties": {
                "Enabled": {
                    "type": "boolean"
                },
                "KmsKeyId": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::Elasticsearch::Domain.NodeToNodeEncryptionOptions": {
            "additionalProperties": false,
            "properties": {
                "Enabled": {
                    "type": "boolean"
                }
            },
            "type": "object"
        },
        "AWS::Elasticsearch::Domain.SnapshotOptions": {
            "additionalProperties": false,
            "properties": {
                "AutomatedSnapshotStartHour": {
                    "type": "number"
                }
            },
            "type": "object"
        },
        "AWS::Elasticsearch::Domain.VPCOptions": {
            "additionalProperties": false,
            "properties": {
                "SecurityGroupIds": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "SubnetIds": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                }
            },
            "type": "object"
        },
        "AWS::Events::EventBusPolicy": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Action": {
                            "type": "string"
                        },
                        "Condition": {
                            "$ref": "#/definitions/AWS::Events::EventBusPolicy.Condition"
                        },
                        "Principal": {
                            "type": "string"
                        },
                        "StatementId": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "Action",
                        "Principal",
                        "StatementId"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::Events::EventBusPolicy"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::Events::EventBusPolicy.Condition": {
            "additionalProperties": false,
            "properties": {
                "Key": {
                    "type": "string"
                },
                "Type": {
                    "type": "string"
                },
                "Value": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::Events::Rule": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Description": {
                            "type": "string"
                        },
                        "EventPattern": {
                            "type": "object"
                        },
                        "Name": {
                            "type": "string"
                        },
                        "RoleArn": {
                            "type": "string"
                        },
                        "ScheduleExpression": {
                            "type": "string"
                        },
                        "State": {
                            "type": "string"
                        },
                        "Targets": {
                            "items": {
                                "$ref": "#/definitions/AWS::Events::Rule.Target"
                            },
                            "type": "array"
                        }
                    },
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::Events::Rule"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type"
            ],
            "type": "object"
        },
        "AWS::Events::Rule.EcsParameters": {
            "additionalProperties": false,
            "properties": {
                "TaskCount": {
                    "type": "number"
                },
                "TaskDefinitionArn": {
                    "type": "string"
                }
            },
            "required": [
                "TaskDefinitionArn"
            ],
            "type": "object"
        },
        "AWS::Events::Rule.InputTransformer": {
            "additionalProperties": false,
            "properties": {
                "InputPathsMap": {
                    "additionalProperties": true,
                    "patternProperties": {
                        "^[a-zA-Z0-9]+$": {
                            "type": "string"
                        }
                    },
                    "type": "object"
                },
                "InputTemplate": {
                    "type": "string"
                }
            },
            "required": [
                "InputTemplate"
            ],
            "type": "object"
        },
        "AWS::Events::Rule.KinesisParameters": {
            "additionalProperties": false,
            "properties": {
                "PartitionKeyPath": {
                    "type": "string"
                }
            },
            "required": [
                "PartitionKeyPath"
            ],
            "type": "object"
        },
        "AWS::Events::Rule.RunCommandParameters": {
            "additionalProperties": false,
            "properties": {
                "RunCommandTargets": {
                    "items": {
                        "$ref": "#/definitions/AWS::Events::Rule.RunCommandTarget"
                    },
                    "type": "array"
                }
            },
            "required": [
                "RunCommandTargets"
            ],
            "type": "object"
        },
        "AWS::Events::Rule.RunCommandTarget": {
            "additionalProperties": false,
            "properties": {
                "Key": {
                    "type": "string"
                },
                "Values": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                }
            },
            "required": [
                "Key",
                "Values"
            ],
            "type": "object"
        },
        "AWS::Events::Rule.SqsParameters": {
            "additionalProperties": false,
            "properties": {
                "MessageGroupId": {
                    "type": "string"
                }
            },
            "required": [
                "MessageGroupId"
            ],
            "type": "object"
        },
        "AWS::Events::Rule.Target": {
            "additionalProperties": false,
            "properties": {
                "Arn": {
                    "type": "string"
                },
                "EcsParameters": {
                    "$ref": "#/definitions/AWS::Events::Rule.EcsParameters"
                },
                "Id": {
                    "type": "string"
                },
                "Input": {
                    "type": "string"
                },
                "InputPath": {
                    "type": "string"
                },
                "InputTransformer": {
                    "$ref": "#/definitions/AWS::Events::Rule.InputTransformer"
                },
                "KinesisParameters": {
                    "$ref": "#/definitions/AWS::Events::Rule.KinesisParameters"
                },
                "RoleArn": {
                    "type": "string"
                },
                "RunCommandParameters": {
                    "$ref": "#/definitions/AWS::Events::Rule.RunCommandParameters"
                },
                "SqsParameters": {
                    "$ref": "#/definitions/AWS::Events::Rule.SqsParameters"
                }
            },
            "required": [
                "Arn",
                "Id"
            ],
            "type": "object"
        },
        "AWS::FSx::FileSystem": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "BackupId": {
                            "type": "string"
                        },
                        "FileSystemType": {
                            "type": "string"
                        },
                        "KmsKeyId": {
                            "type": "string"
                        },
                        "LustreConfiguration": {
                            "$ref": "#/definitions/AWS::FSx::FileSystem.LustreConfiguration"
                        },
                        "SecurityGroupIds": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "StorageCapacity": {
                            "type": "number"
                        },
                        "SubnetIds": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/AWS::FSx::FileSystem.TagEntry"
                            },
                            "type": "array"
                        },
                        "WindowsConfiguration": {
                            "$ref": "#/definitions/AWS::FSx::FileSystem.WindowsConfiguration"
                        }
                    },
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::FSx::FileSystem"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type"
            ],
            "type": "object"
        },
        "AWS::FSx::FileSystem.LustreConfiguration": {
            "additionalProperties": false,
            "properties": {
                "ExportPath": {
                    "type": "string"
                },
                "ImportPath": {
                    "type": "string"
                },
                "ImportedFileChunkSize": {
                    "type": "number"
                },
                "WeeklyMaintenanceStartTime": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::FSx::FileSystem.TagEntry": {
            "additionalProperties": false,
            "properties": {
                "Key": {
                    "type": "string"
                },
                "Value": {
                    "type": "string"
                }
            },
            "required": [
                "Key",
                "Value"
            ],
            "type": "object"
        },
        "AWS::FSx::FileSystem.WindowsConfiguration": {
            "additionalProperties": false,
            "properties": {
                "ActiveDirectoryId": {
                    "type": "string"
                },
                "AutomaticBackupRetentionDays": {
                    "type": "number"
                },
                "CopyTagsToBackups": {
                    "type": "boolean"
                },
                "DailyAutomaticBackupStartTime": {
                    "type": "string"
                },
                "ThroughputCapacity": {
                    "type": "number"
                },
                "WeeklyMaintenanceStartTime": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::GameLift::Alias": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Description": {
                            "type": "string"
                        },
                        "Name": {
                            "type": "string"
                        },
                        "RoutingStrategy": {
                            "$ref": "#/definitions/AWS::GameLift::Alias.RoutingStrategy"
                        }
                    },
                    "required": [
                        "Name",
                        "RoutingStrategy"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::GameLift::Alias"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::GameLift::Alias.RoutingStrategy": {
            "additionalProperties": false,
            "properties": {
                "FleetId": {
                    "type": "string"
                },
                "Message": {
                    "type": "string"
                },
                "Type": {
                    "type": "string"
                }
            },
            "required": [
                "Type"
            ],
            "type": "object"
        },
        "AWS::GameLift::Build": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Name": {
                            "type": "string"
                        },
                        "StorageLocation": {
                            "$ref": "#/definitions/AWS::GameLift::Build.S3Location"
                        },
                        "Version": {
                            "type": "string"
                        }
                    },
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::GameLift::Build"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type"
            ],
            "type": "object"
        },
        "AWS::GameLift::Build.S3Location": {
            "additionalProperties": false,
            "properties": {
                "Bucket": {
                    "type": "string"
                },
                "Key": {
                    "type": "string"
                },
                "RoleArn": {
                    "type": "string"
                }
            },
            "required": [
                "Bucket",
                "Key",
                "RoleArn"
            ],
            "type": "object"
        },
        "AWS::GameLift::Fleet": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "BuildId": {
                            "type": "string"
                        },
                        "Description": {
                            "type": "string"
                        },
                        "DesiredEC2Instances": {
                            "type": "number"
                        },
                        "EC2InboundPermissions": {
                            "items": {
                                "$ref": "#/definitions/AWS::GameLift::Fleet.IpPermission"
                            },
                            "type": "array"
                        },
                        "EC2InstanceType": {
                            "type": "string"
                        },
                        "LogPaths": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "MaxSize": {
                            "type": "number"
                        },
                        "MinSize": {
                            "type": "number"
                        },
                        "Name": {
                            "type": "string"
                        },
                        "ServerLaunchParameters": {
                            "type": "string"
                        },
                        "ServerLaunchPath": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "BuildId",
                        "DesiredEC2Instances",
                        "EC2InstanceType",
                        "Name",
                        "ServerLaunchPath"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::GameLift::Fleet"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::GameLift::Fleet.IpPermission": {
            "additionalProperties": false,
            "properties": {
                "FromPort": {
                    "type": "number"
                },
                "IpRange": {
                    "type": "string"
                },
                "Protocol": {
                    "type": "string"
                },
                "ToPort": {
                    "type": "number"
                }
            },
            "required": [
                "FromPort",
                "IpRange",
                "Protocol",
                "ToPort"
            ],
            "type": "object"
        },
        "AWS::Glue::Classifier": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "GrokClassifier": {
                            "$ref": "#/definitions/AWS::Glue::Classifier.GrokClassifier"
                        },
                        "JsonClassifier": {
                            "$ref": "#/definitions/AWS::Glue::Classifier.JsonClassifier"
                        },
                        "XMLClassifier": {
                            "$ref": "#/definitions/AWS::Glue::Classifier.XMLClassifier"
                        }
                    },
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::Glue::Classifier"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type"
            ],
            "type": "object"
        },
        "AWS::Glue::Classifier.GrokClassifier": {
            "additionalProperties": false,
            "properties": {
                "Classification": {
                    "type": "string"
                },
                "CustomPatterns": {
                    "type": "string"
                },
                "GrokPattern": {
                    "type": "string"
                },
                "Name": {
                    "type": "string"
                }
            },
            "required": [
                "Classification",
                "GrokPattern"
            ],
            "type": "object"
        },
        "AWS::Glue::Classifier.JsonClassifier": {
            "additionalProperties": false,
            "properties": {
                "JsonPath": {
                    "type": "string"
                },
                "Name": {
                    "type": "string"
                }
            },
            "required": [
                "JsonPath"
            ],
            "type": "object"
        },
        "AWS::Glue::Classifier.XMLClassifier": {
            "additionalProperties": false,
            "properties": {
                "Classification": {
                    "type": "string"
                },
                "Name": {
                    "type": "string"
                },
                "RowTag": {
                    "type": "string"
                }
            },
            "required": [
                "Classification",
                "RowTag"
            ],
            "type": "object"
        },
        "AWS::Glue::Connection": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "CatalogId": {
                            "type": "string"
                        },
                        "ConnectionInput": {
                            "$ref": "#/definitions/AWS::Glue::Connection.ConnectionInput"
                        }
                    },
                    "required": [
                        "CatalogId",
                        "ConnectionInput"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::Glue::Connection"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::Glue::Connection.ConnectionInput": {
            "additionalProperties": false,
            "properties": {
                "ConnectionProperties": {
                    "type": "object"
                },
                "ConnectionType": {
                    "type": "string"
                },
                "Description": {
                    "type": "string"
                },
                "MatchCriteria": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "Name": {
                    "type": "string"
                },
                "PhysicalConnectionRequirements": {
                    "$ref": "#/definitions/AWS::Glue::Connection.PhysicalConnectionRequirements"
                }
            },
            "required": [
                "ConnectionProperties",
                "ConnectionType"
            ],
            "type": "object"
        },
        "AWS::Glue::Connection.PhysicalConnectionRequirements": {
            "additionalProperties": false,
            "properties": {
                "AvailabilityZone": {
                    "type": "string"
                },
                "SecurityGroupIdList": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "SubnetId": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::Glue::Crawler": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Classifiers": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "Configuration": {
                            "type": "string"
                        },
                        "DatabaseName": {
                            "type": "string"
                        },
                        "Description": {
                            "type": "string"
                        },
                        "Name": {
                            "type": "string"
                        },
                        "Role": {
                            "type": "string"
                        },
                        "Schedule": {
                            "$ref": "#/definitions/AWS::Glue::Crawler.Schedule"
                        },
                        "SchemaChangePolicy": {
                            "$ref": "#/definitions/AWS::Glue::Crawler.SchemaChangePolicy"
                        },
                        "TablePrefix": {
                            "type": "string"
                        },
                        "Targets": {
                            "$ref": "#/definitions/AWS::Glue::Crawler.Targets"
                        }
                    },
                    "required": [
                        "DatabaseName",
                        "Role",
                        "Targets"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::Glue::Crawler"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::Glue::Crawler.JdbcTarget": {
            "additionalProperties": false,
            "properties": {
                "ConnectionName": {
                    "type": "string"
                },
                "Exclusions": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "Path": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::Glue::Crawler.S3Target": {
            "additionalProperties": false,
            "properties": {
                "Exclusions": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "Path": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::Glue::Crawler.Schedule": {
            "additionalProperties": false,
            "properties": {
                "ScheduleExpression": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::Glue::Crawler.SchemaChangePolicy": {
            "additionalProperties": false,
            "properties": {
                "DeleteBehavior": {
                    "type": "string"
                },
                "UpdateBehavior": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::Glue::Crawler.Targets": {
            "additionalProperties": false,
            "properties": {
                "JdbcTargets": {
                    "items": {
                        "$ref": "#/definitions/AWS::Glue::Crawler.JdbcTarget"
                    },
                    "type": "array"
                },
                "S3Targets": {
                    "items": {
                        "$ref": "#/definitions/AWS::Glue::Crawler.S3Target"
                    },
                    "type": "array"
                }
            },
            "type": "object"
        },
        "AWS::Glue::Database": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "CatalogId": {
                            "type": "string"
                        },
                        "DatabaseInput": {
                            "$ref": "#/definitions/AWS::Glue::Database.DatabaseInput"
                        }
                    },
                    "required": [
                        "CatalogId",
                        "DatabaseInput"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::Glue::Database"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::Glue::Database.DatabaseInput": {
            "additionalProperties": false,
            "properties": {
                "Description": {
                    "type": "string"
                },
                "LocationUri": {
                    "type": "string"
                },
                "Name": {
                    "type": "string"
                },
                "Parameters": {
                    "type": "object"
                }
            },
            "type": "object"
        },
        "AWS::Glue::DevEndpoint": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "EndpointName": {
                            "type": "string"
                        },
                        "ExtraJarsS3Path": {
                            "type": "string"
                        },
                        "ExtraPythonLibsS3Path": {
                            "type": "string"
                        },
                        "NumberOfNodes": {
                            "type": "number"
                        },
                        "PublicKey": {
                            "type": "string"
                        },
                        "RoleArn": {
                            "type": "string"
                        },
                        "SecurityGroupIds": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "SubnetId": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "PublicKey",
                        "RoleArn"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::Glue::DevEndpoint"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::Glue::Job": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "AllocatedCapacity": {
                            "type": "number"
                        },
                        "Command": {
                            "$ref": "#/definitions/AWS::Glue::Job.JobCommand"
                        },
                        "Connections": {
                            "$ref": "#/definitions/AWS::Glue::Job.ConnectionsList"
                        },
                        "DefaultArguments": {
                            "type": "object"
                        },
                        "Description": {
                            "type": "string"
                        },
                        "ExecutionProperty": {
                            "$ref": "#/definitions/AWS::Glue::Job.ExecutionProperty"
                        },
                        "LogUri": {
                            "type": "string"
                        },
                        "MaxRetries": {
                            "type": "number"
                        },
                        "Name": {
                            "type": "string"
                        },
                        "Role": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "Command",
                        "Role"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::Glue::Job"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::Glue::Job.ConnectionsList": {
            "additionalProperties": false,
            "properties": {
                "Connections": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                }
            },
            "type": "object"
        },
        "AWS::Glue::Job.ExecutionProperty": {
            "additionalProperties": false,
            "properties": {
                "MaxConcurrentRuns": {
                    "type": "number"
                }
            },
            "type": "object"
        },
        "AWS::Glue::Job.JobCommand": {
            "additionalProperties": false,
            "properties": {
                "Name": {
                    "type": "string"
                },
                "ScriptLocation": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::Glue::Partition": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "CatalogId": {
                            "type": "string"
                        },
                        "DatabaseName": {
                            "type": "string"
                        },
                        "PartitionInput": {
                            "$ref": "#/definitions/AWS::Glue::Partition.PartitionInput"
                        },
                        "TableName": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "CatalogId",
                        "DatabaseName",
                        "PartitionInput",
                        "TableName"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::Glue::Partition"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::Glue::Partition.Column": {
            "additionalProperties": false,
            "properties": {
                "Comment": {
                    "type": "string"
                },
                "Name": {
                    "type": "string"
                },
                "Type": {
                    "type": "string"
                }
            },
            "required": [
                "Name"
            ],
            "type": "object"
        },
        "AWS::Glue::Partition.Order": {
            "additionalProperties": false,
            "properties": {
                "Column": {
                    "type": "string"
                },
                "SortOrder": {
                    "type": "number"
                }
            },
            "required": [
                "Column"
            ],
            "type": "object"
        },
        "AWS::Glue::Partition.PartitionInput": {
            "additionalProperties": false,
            "properties": {
                "Parameters": {
                    "type": "object"
                },
                "StorageDescriptor": {
                    "$ref": "#/definitions/AWS::Glue::Partition.StorageDescriptor"
                },
                "Values": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                }
            },
            "required": [
                "Values"
            ],
            "type": "object"
        },
        "AWS::Glue::Partition.SerdeInfo": {
            "additionalProperties": false,
            "properties": {
                "Name": {
                    "type": "string"
                },
                "Parameters": {
                    "type": "object"
                },
                "SerializationLibrary": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::Glue::Partition.SkewedInfo": {
            "additionalProperties": false,
            "properties": {
                "SkewedColumnNames": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "SkewedColumnValueLocationMaps": {
                    "type": "object"
                },
                "SkewedColumnValues": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                }
            },
            "type": "object"
        },
        "AWS::Glue::Partition.StorageDescriptor": {
            "additionalProperties": false,
            "properties": {
                "BucketColumns": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "Columns": {
                    "items": {
                        "$ref": "#/definitions/AWS::Glue::Partition.Column"
                    },
                    "type": "array"
                },
                "Compressed": {
                    "type": "boolean"
                },
                "InputFormat": {
                    "type": "string"
                },
                "Location": {
                    "type": "string"
                },
                "NumberOfBuckets": {
                    "type": "number"
                },
                "OutputFormat": {
                    "type": "string"
                },
                "Parameters": {
                    "type": "object"
                },
                "SerdeInfo": {
                    "$ref": "#/definitions/AWS::Glue::Partition.SerdeInfo"
                },
                "SkewedInfo": {
                    "$ref": "#/definitions/AWS::Glue::Partition.SkewedInfo"
                },
                "SortColumns": {
                    "items": {
                        "$ref": "#/definitions/AWS::Glue::Partition.Order"
                    },
                    "type": "array"
                },
                "StoredAsSubDirectories": {
                    "type": "boolean"
                }
            },
            "type": "object"
        },
        "AWS::Glue::Table": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "CatalogId": {
                            "type": "string"
                        },
                        "DatabaseName": {
                            "type": "string"
                        },
                        "TableInput": {
                            "$ref": "#/definitions/AWS::Glue::Table.TableInput"
                        }
                    },
                    "required": [
                        "CatalogId",
                        "DatabaseName",
                        "TableInput"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::Glue::Table"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::Glue::Table.Column": {
            "additionalProperties": false,
            "properties": {
                "Comment": {
                    "type": "string"
                },
                "Name": {
                    "type": "string"
                },
                "Type": {
                    "type": "string"
                }
            },
            "required": [
                "Name"
            ],
            "type": "object"
        },
        "AWS::Glue::Table.Order": {
            "additionalProperties": false,
            "properties": {
                "Column": {
                    "type": "string"
                },
                "SortOrder": {
                    "type": "number"
                }
            },
            "required": [
                "Column",
                "SortOrder"
            ],
            "type": "object"
        },
        "AWS::Glue::Table.SerdeInfo": {
            "additionalProperties": false,
            "properties": {
                "Name": {
                    "type": "string"
                },
                "Parameters": {
                    "type": "object"
                },
                "SerializationLibrary": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::Glue::Table.SkewedInfo": {
            "additionalProperties": false,
            "properties": {
                "SkewedColumnNames": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "SkewedColumnValueLocationMaps": {
                    "type": "object"
                },
                "SkewedColumnValues": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                }
            },
            "type": "object"
        },
        "AWS::Glue::Table.StorageDescriptor": {
            "additionalProperties": false,
            "properties": {
                "BucketColumns": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "Columns": {
                    "items": {
                        "$ref": "#/definitions/AWS::Glue::Table.Column"
                    },
                    "type": "array"
                },
                "Compressed": {
                    "type": "boolean"
                },
                "InputFormat": {
                    "type": "string"
                },
                "Location": {
                    "type": "string"
                },
                "NumberOfBuckets": {
                    "type": "number"
                },
                "OutputFormat": {
                    "type": "string"
                },
                "Parameters": {
                    "type": "object"
                },
                "SerdeInfo": {
                    "$ref": "#/definitions/AWS::Glue::Table.SerdeInfo"
                },
                "SkewedInfo": {
                    "$ref": "#/definitions/AWS::Glue::Table.SkewedInfo"
                },
                "SortColumns": {
                    "items": {
                        "$ref": "#/definitions/AWS::Glue::Table.Order"
                    },
                    "type": "array"
                },
                "StoredAsSubDirectories": {
                    "type": "boolean"
                }
            },
            "type": "object"
        },
        "AWS::Glue::Table.TableInput": {
            "additionalProperties": false,
            "properties": {
                "Description": {
                    "type": "string"
                },
                "Name": {
                    "type": "string"
                },
                "Owner": {
                    "type": "string"
                },
                "Parameters": {
                    "type": "object"
                },
                "PartitionKeys": {
                    "items": {
                        "$ref": "#/definitions/AWS::Glue::Table.Column"
                    },
                    "type": "array"
                },
                "Retention": {
                    "type": "number"
                },
                "StorageDescriptor": {
                    "$ref": "#/definitions/AWS::Glue::Table.StorageDescriptor"
                },
                "TableType": {
                    "type": "string"
                },
                "ViewExpandedText": {
                    "type": "string"
                },
                "ViewOriginalText": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::Glue::Trigger": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Actions": {
                            "items": {
                                "$ref": "#/definitions/AWS::Glue::Trigger.Action"
                            },
                            "type": "array"
                        },
                        "Description": {
                            "type": "string"
                        },
                        "Name": {
                            "type": "string"
                        },
                        "Predicate": {
                            "$ref": "#/definitions/AWS::Glue::Trigger.Predicate"
                        },
                        "Schedule": {
                            "type": "string"
                        },
                        "Type": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "Actions",
                        "Type"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::Glue::Trigger"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::Glue::Trigger.Action": {
            "additionalProperties": false,
            "properties": {
                "Arguments": {
                    "type": "object"
                },
                "JobName": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::Glue::Trigger.Condition": {
            "additionalProperties": false,
            "properties": {
                "JobName": {
                    "type": "string"
                },
                "LogicalOperator": {
                    "type": "string"
                },
                "State": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::Glue::Trigger.Predicate": {
            "additionalProperties": false,
            "properties": {
                "Conditions": {
                    "items": {
                        "$ref": "#/definitions/AWS::Glue::Trigger.Condition"
                    },
                    "type": "array"
                },
                "Logical": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::GuardDuty::Detector": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Enable": {
                            "type": "boolean"
                        },
                        "FindingPublishingFrequency": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "Enable"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::GuardDuty::Detector"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::GuardDuty::Filter": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Action": {
                            "type": "string"
                        },
                        "Description": {
                            "type": "string"
                        },
                        "DetectorId": {
                            "type": "string"
                        },
                        "FindingCriteria": {
                            "$ref": "#/definitions/AWS::GuardDuty::Filter.FindingCriteria"
                        },
                        "Name": {
                            "type": "string"
                        },
                        "Rank": {
                            "type": "number"
                        }
                    },
                    "required": [
                        "Action",
                        "Description",
                        "DetectorId",
                        "FindingCriteria",
                        "Rank"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::GuardDuty::Filter"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::GuardDuty::Filter.Condition": {
            "additionalProperties": false,
            "properties": {
                "Eq": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "Gte": {
                    "type": "number"
                },
                "Lt": {
                    "type": "number"
                },
                "Lte": {
                    "type": "number"
                },
                "Neq": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                }
            },
            "type": "object"
        },
        "AWS::GuardDuty::Filter.FindingCriteria": {
            "additionalProperties": false,
            "properties": {
                "Criterion": {
                    "type": "object"
                },
                "ItemType": {
                    "$ref": "#/definitions/AWS::GuardDuty::Filter.Condition"
                }
            },
            "type": "object"
        },
        "AWS::GuardDuty::IPSet": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Activate": {
                            "type": "boolean"
                        },
                        "DetectorId": {
                            "type": "string"
                        },
                        "Format": {
                            "type": "string"
                        },
                        "Location": {
                            "type": "string"
                        },
                        "Name": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "Activate",
                        "DetectorId",
                        "Format",
                        "Location"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::GuardDuty::IPSet"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::GuardDuty::Master": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "DetectorId": {
                            "type": "string"
                        },
                        "InvitationId": {
                            "type": "string"
                        },
                        "MasterId": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "DetectorId",
                        "MasterId"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::GuardDuty::Master"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::GuardDuty::Member": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "DetectorId": {
                            "type": "string"
                        },
                        "DisableEmailNotification": {
                            "type": "boolean"
                        },
                        "Email": {
                            "type": "string"
                        },
                        "MemberId": {
                            "type": "string"
                        },
                        "Message": {
                            "type": "string"
                        },
                        "Status": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "DetectorId",
                        "Email",
                        "MemberId"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::GuardDuty::Member"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::GuardDuty::ThreatIntelSet": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Activate": {
                            "type": "boolean"
                        },
                        "DetectorId": {
                            "type": "string"
                        },
                        "Format": {
                            "type": "string"
                        },
                        "Location": {
                            "type": "string"
                        },
                        "Name": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "Activate",
                        "DetectorId",
                        "Format",
                        "Location"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::GuardDuty::ThreatIntelSet"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::IAM::AccessKey": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Serial": {
                            "type": "number"
                        },
                        "Status": {
                            "type": "string"
                        },
                        "UserName": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "UserName"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::IAM::AccessKey"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::IAM::Group": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "GroupName": {
                            "type": "string"
                        },
                        "ManagedPolicyArns": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "Path": {
                            "type": "string"
                        },
                        "Policies": {
                            "items": {
                                "$ref": "#/definitions/AWS::IAM::Group.Policy"
                            },
                            "type": "array"
                        }
                    },
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::IAM::Group"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type"
            ],
            "type": "object"
        },
        "AWS::IAM::Group.Policy": {
            "additionalProperties": false,
            "properties": {
                "PolicyDocument": {
                    "type": "object"
                },
                "PolicyName": {
                    "type": "string"
                }
            },
            "required": [
                "PolicyDocument",
                "PolicyName"
            ],
            "type": "object"
        },
        "AWS::IAM::InstanceProfile": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "InstanceProfileName": {
                            "type": "string"
                        },
                        "Path": {
                            "type": "string"
                        },
                        "Roles": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        }
                    },
                    "required": [
                        "Roles"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::IAM::InstanceProfile"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::IAM::ManagedPolicy": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Description": {
                            "type": "string"
                        },
                        "Groups": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "ManagedPolicyName": {
                            "type": "string"
                        },
                        "Path": {
                            "type": "string"
                        },
                        "PolicyDocument": {
                            "type": "object"
                        },
                        "Roles": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "Users": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        }
                    },
                    "required": [
                        "PolicyDocument"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::IAM::ManagedPolicy"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::IAM::Policy": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Groups": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "PolicyDocument": {
                            "type": "object"
                        },
                        "PolicyName": {
                            "type": "string"
                        },
                        "Roles": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "Users": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        }
                    },
                    "required": [
                        "PolicyDocument",
                        "PolicyName"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::IAM::Policy"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::IAM::Role": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "AssumeRolePolicyDocument": {
                            "type": "object"
                        },
                        "ManagedPolicyArns": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "MaxSessionDuration": {
                            "type": "number"
                        },
                        "Path": {
                            "type": "string"
                        },
                        "PermissionsBoundary": {
                            "type": "string"
                        },
                        "Policies": {
                            "items": {
                                "$ref": "#/definitions/AWS::IAM::Role.Policy"
                            },
                            "type": "array"
                        },
                        "RoleName": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "AssumeRolePolicyDocument"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::IAM::Role"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::IAM::Role.Policy": {
            "additionalProperties": false,
            "properties": {
                "PolicyDocument": {
                    "type": "object"
                },
                "PolicyName": {
                    "type": "string"
                }
            },
            "required": [
                "PolicyDocument",
                "PolicyName"
            ],
            "type": "object"
        },
        "AWS::IAM::ServiceLinkedRole": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "AWSServiceName": {
                            "type": "string"
                        },
                        "CustomSuffix": {
                            "type": "string"
                        },
                        "Description": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "AWSServiceName"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::IAM::ServiceLinkedRole"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::IAM::User": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Groups": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "LoginProfile": {
                            "$ref": "#/definitions/AWS::IAM::User.LoginProfile"
                        },
                        "ManagedPolicyArns": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "Path": {
                            "type": "string"
                        },
                        "PermissionsBoundary": {
                            "type": "string"
                        },
                        "Policies": {
                            "items": {
                                "$ref": "#/definitions/AWS::IAM::User.Policy"
                            },
                            "type": "array"
                        },
                        "UserName": {
                            "type": "string"
                        }
                    },
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::IAM::User"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type"
            ],
            "type": "object"
        },
        "AWS::IAM::User.LoginProfile": {
            "additionalProperties": false,
            "properties": {
                "Password": {
                    "type": "string"
                },
                "PasswordResetRequired": {
                    "type": "boolean"
                }
            },
            "required": [
                "Password"
            ],
            "type": "object"
        },
        "AWS::IAM::User.Policy": {
            "additionalProperties": false,
            "properties": {
                "PolicyDocument": {
                    "type": "object"
                },
                "PolicyName": {
                    "type": "string"
                }
            },
            "required": [
                "PolicyDocument",
                "PolicyName"
            ],
            "type": "object"
        },
        "AWS::IAM::UserToGroupAddition": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "GroupName": {
                            "type": "string"
                        },
                        "Users": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        }
                    },
                    "required": [
                        "GroupName",
                        "Users"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::IAM::UserToGroupAddition"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::Inspector::AssessmentTarget": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "AssessmentTargetName": {
                            "type": "string"
                        },
                        "ResourceGroupArn": {
                            "type": "string"
                        }
                    },
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::Inspector::AssessmentTarget"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type"
            ],
            "type": "object"
        },
        "AWS::Inspector::AssessmentTemplate": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "AssessmentTargetArn": {
                            "type": "string"
                        },
                        "AssessmentTemplateName": {
                            "type": "string"
                        },
                        "DurationInSeconds": {
                            "type": "number"
                        },
                        "RulesPackageArns": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "UserAttributesForFindings": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        }
                    },
                    "required": [
                        "AssessmentTargetArn",
                        "DurationInSeconds",
                        "RulesPackageArns"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::Inspector::AssessmentTemplate"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::Inspector::ResourceGroup": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "ResourceGroupTags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        }
                    },
                    "required": [
                        "ResourceGroupTags"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::Inspector::ResourceGroup"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::IoT1Click::Device": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "DeviceId": {
                            "type": "string"
                        },
                        "Enabled": {
                            "type": "boolean"
                        }
                    },
                    "required": [
                        "DeviceId",
                        "Enabled"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::IoT1Click::Device"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::IoT1Click::Placement": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "AssociatedDevices": {
                            "type": "object"
                        },
                        "Attributes": {
                            "type": "object"
                        },
                        "PlacementName": {
                            "type": "string"
                        },
                        "ProjectName": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "ProjectName"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::IoT1Click::Placement"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::IoT1Click::Project": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Description": {
                            "type": "string"
                        },
                        "PlacementTemplate": {
                            "$ref": "#/definitions/AWS::IoT1Click::Project.PlacementTemplate"
                        },
                        "ProjectName": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "PlacementTemplate"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::IoT1Click::Project"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::IoT1Click::Project.DeviceTemplate": {
            "additionalProperties": false,
            "properties": {
                "CallbackOverrides": {
                    "type": "object"
                },
                "DeviceType": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::IoT1Click::Project.PlacementTemplate": {
            "additionalProperties": false,
            "properties": {
                "DefaultAttributes": {
                    "type": "object"
                },
                "DeviceTemplates": {
                    "type": "object"
                }
            },
            "type": "object"
        },
        "AWS::IoT::Certificate": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "CertificateSigningRequest": {
                            "type": "string"
                        },
                        "Status": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "CertificateSigningRequest",
                        "Status"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::IoT::Certificate"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::IoT::Policy": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "PolicyDocument": {
                            "type": "object"
                        },
                        "PolicyName": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "PolicyDocument"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::IoT::Policy"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::IoT::PolicyPrincipalAttachment": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "PolicyName": {
                            "type": "string"
                        },
                        "Principal": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "PolicyName",
                        "Principal"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::IoT::PolicyPrincipalAttachment"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::IoT::Thing": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "AttributePayload": {
                            "$ref": "#/definitions/AWS::IoT::Thing.AttributePayload"
                        },
                        "ThingName": {
                            "type": "string"
                        }
                    },
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::IoT::Thing"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type"
            ],
            "type": "object"
        },
        "AWS::IoT::Thing.AttributePayload": {
            "additionalProperties": false,
            "properties": {
                "Attributes": {
                    "additionalProperties": true,
                    "patternProperties": {
                        "^[a-zA-Z0-9]+$": {
                            "type": "string"
                        }
                    },
                    "type": "object"
                }
            },
            "type": "object"
        },
        "AWS::IoT::ThingPrincipalAttachment": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Principal": {
                            "type": "string"
                        },
                        "ThingName": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "Principal",
                        "ThingName"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::IoT::ThingPrincipalAttachment"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::IoT::TopicRule": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "RuleName": {
                            "type": "string"
                        },
                        "TopicRulePayload": {
                            "$ref": "#/definitions/AWS::IoT::TopicRule.TopicRulePayload"
                        }
                    },
                    "required": [
                        "TopicRulePayload"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::IoT::TopicRule"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::IoT::TopicRule.Action": {
            "additionalProperties": false,
            "properties": {
                "CloudwatchAlarm": {
                    "$ref": "#/definitions/AWS::IoT::TopicRule.CloudwatchAlarmAction"
                },
                "CloudwatchMetric": {
                    "$ref": "#/definitions/AWS::IoT::TopicRule.CloudwatchMetricAction"
                },
                "DynamoDB": {
                    "$ref": "#/definitions/AWS::IoT::TopicRule.DynamoDBAction"
                },
                "DynamoDBv2": {
                    "$ref": "#/definitions/AWS::IoT::TopicRule.DynamoDBv2Action"
                },
                "Elasticsearch": {
                    "$ref": "#/definitions/AWS::IoT::TopicRule.ElasticsearchAction"
                },
                "Firehose": {
                    "$ref": "#/definitions/AWS::IoT::TopicRule.FirehoseAction"
                },
                "IotAnalytics": {
                    "$ref": "#/definitions/AWS::IoT::TopicRule.IotAnalyticsAction"
                },
                "Kinesis": {
                    "$ref": "#/definitions/AWS::IoT::TopicRule.KinesisAction"
                },
                "Lambda": {
                    "$ref": "#/definitions/AWS::IoT::TopicRule.LambdaAction"
                },
                "Republish": {
                    "$ref": "#/definitions/AWS::IoT::TopicRule.RepublishAction"
                },
                "S3": {
                    "$ref": "#/definitions/AWS::IoT::TopicRule.S3Action"
                },
                "Sns": {
                    "$ref": "#/definitions/AWS::IoT::TopicRule.SnsAction"
                },
                "Sqs": {
                    "$ref": "#/definitions/AWS::IoT::TopicRule.SqsAction"
                },
                "StepFunctions": {
                    "$ref": "#/definitions/AWS::IoT::TopicRule.StepFunctionsAction"
                }
            },
            "type": "object"
        },
        "AWS::IoT::TopicRule.CloudwatchAlarmAction": {
            "additionalProperties": false,
            "properties": {
                "AlarmName": {
                    "type": "string"
                },
                "RoleArn": {
                    "type": "string"
                },
                "StateReason": {
                    "type": "string"
                },
                "StateValue": {
                    "type": "string"
                }
            },
            "required": [
                "AlarmName",
                "RoleArn",
                "StateReason",
                "StateValue"
            ],
            "type": "object"
        },
        "AWS::IoT::TopicRule.CloudwatchMetricAction": {
            "additionalProperties": false,
            "properties": {
                "MetricName": {
                    "type": "string"
                },
                "MetricNamespace": {
                    "type": "string"
                },
                "MetricTimestamp": {
                    "type": "string"
                },
                "MetricUnit": {
                    "type": "string"
                },
                "MetricValue": {
                    "type": "string"
                },
                "RoleArn": {
                    "type": "string"
                }
            },
            "required": [
                "MetricName",
                "MetricNamespace",
                "MetricUnit",
                "MetricValue",
                "RoleArn"
            ],
            "type": "object"
        },
        "AWS::IoT::TopicRule.DynamoDBAction": {
            "additionalProperties": false,
            "properties": {
                "HashKeyField": {
                    "type": "string"
                },
                "HashKeyType": {
                    "type": "string"
                },
                "HashKeyValue": {
                    "type": "string"
                },
                "PayloadField": {
                    "type": "string"
                },
                "RangeKeyField": {
                    "type": "string"
                },
                "RangeKeyType": {
                    "type": "string"
                },
                "RangeKeyValue": {
                    "type": "string"
                },
                "RoleArn": {
                    "type": "string"
                },
                "TableName": {
                    "type": "string"
                }
            },
            "required": [
                "HashKeyField",
                "HashKeyValue",
                "RoleArn",
                "TableName"
            ],
            "type": "object"
        },
        "AWS::IoT::TopicRule.DynamoDBv2Action": {
            "additionalProperties": false,
            "properties": {
                "PutItem": {
                    "$ref": "#/definitions/AWS::IoT::TopicRule.PutItemInput"
                },
                "RoleArn": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::IoT::TopicRule.ElasticsearchAction": {
            "additionalProperties": false,
            "properties": {
                "Endpoint": {
                    "type": "string"
                },
                "Id": {
                    "type": "string"
                },
                "Index": {
                    "type": "string"
                },
                "RoleArn": {
                    "type": "string"
                },
                "Type": {
                    "type": "string"
                }
            },
            "required": [
                "Endpoint",
                "Id",
                "Index",
                "RoleArn",
                "Type"
            ],
            "type": "object"
        },
        "AWS::IoT::TopicRule.FirehoseAction": {
            "additionalProperties": false,
            "properties": {
                "DeliveryStreamName": {
                    "type": "string"
                },
                "RoleArn": {
                    "type": "string"
                },
                "Separator": {
                    "type": "string"
                }
            },
            "required": [
                "DeliveryStreamName",
                "RoleArn"
            ],
            "type": "object"
        },
        "AWS::IoT::TopicRule.IotAnalyticsAction": {
            "additionalProperties": false,
            "properties": {
                "ChannelName": {
                    "type": "string"
                },
                "RoleArn": {
                    "type": "string"
                }
            },
            "required": [
                "ChannelName",
                "RoleArn"
            ],
            "type": "object"
        },
        "AWS::IoT::TopicRule.KinesisAction": {
            "additionalProperties": false,
            "properties": {
                "PartitionKey": {
                    "type": "string"
                },
                "RoleArn": {
                    "type": "string"
                },
                "StreamName": {
                    "type": "string"
                }
            },
            "required": [
                "RoleArn",
                "StreamName"
            ],
            "type": "object"
        },
        "AWS::IoT::TopicRule.LambdaAction": {
            "additionalProperties": false,
            "properties": {
                "FunctionArn": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::IoT::TopicRule.PutItemInput": {
            "additionalProperties": false,
            "properties": {
                "TableName": {
                    "type": "string"
                }
            },
            "required": [
                "TableName"
            ],
            "type": "object"
        },
        "AWS::IoT::TopicRule.RepublishAction": {
            "additionalProperties": false,
            "properties": {
                "RoleArn": {
                    "type": "string"
                },
                "Topic": {
                    "type": "string"
                }
            },
            "required": [
                "RoleArn",
                "Topic"
            ],
            "type": "object"
        },
        "AWS::IoT::TopicRule.S3Action": {
            "additionalProperties": false,
            "properties": {
                "BucketName": {
                    "type": "string"
                },
                "Key": {
                    "type": "string"
                },
                "RoleArn": {
                    "type": "string"
                }
            },
            "required": [
                "BucketName",
                "Key",
                "RoleArn"
            ],
            "type": "object"
        },
        "AWS::IoT::TopicRule.SnsAction": {
            "additionalProperties": false,
            "properties": {
                "MessageFormat": {
                    "type": "string"
                },
                "RoleArn": {
                    "type": "string"
                },
                "TargetArn": {
                    "type": "string"
                }
            },
            "required": [
                "RoleArn",
                "TargetArn"
            ],
            "type": "object"
        },
        "AWS::IoT::TopicRule.SqsAction": {
            "additionalProperties": false,
            "properties": {
                "QueueUrl": {
                    "type": "string"
                },
                "RoleArn": {
                    "type": "string"
                },
                "UseBase64": {
                    "type": "boolean"
                }
            },
            "required": [
                "QueueUrl",
                "RoleArn"
            ],
            "type": "object"
        },
        "AWS::IoT::TopicRule.StepFunctionsAction": {
            "additionalProperties": false,
            "properties": {
                "ExecutionNamePrefix": {
                    "type": "string"
                },
                "RoleArn": {
                    "type": "string"
                },
                "StateMachineName": {
                    "type": "string"
                }
            },
            "required": [
                "RoleArn",
                "StateMachineName"
            ],
            "type": "object"
        },
        "AWS::IoT::TopicRule.TopicRulePayload": {
            "additionalProperties": false,
            "properties": {
                "Actions": {
                    "items": {
                        "$ref": "#/definitions/AWS::IoT::TopicRule.Action"
                    },
                    "type": "array"
                },
                "AwsIotSqlVersion": {
                    "type": "string"
                },
                "Description": {
                    "type": "string"
                },
                "ErrorAction": {
                    "$ref": "#/definitions/AWS::IoT::TopicRule.Action"
                },
                "RuleDisabled": {
                    "type": "boolean"
                },
                "Sql": {
                    "type": "string"
                }
            },
            "required": [
                "Actions",
                "RuleDisabled",
                "Sql"
            ],
            "type": "object"
        },
        "AWS::IoTAnalytics::Channel": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "ChannelName": {
                            "type": "string"
                        },
                        "RetentionPeriod": {
                            "$ref": "#/definitions/AWS::IoTAnalytics::Channel.RetentionPeriod"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        }
                    },
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::IoTAnalytics::Channel"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type"
            ],
            "type": "object"
        },
        "AWS::IoTAnalytics::Channel.RetentionPeriod": {
            "additionalProperties": false,
            "properties": {
                "NumberOfDays": {
                    "type": "number"
                },
                "Unlimited": {
                    "type": "boolean"
                }
            },
            "type": "object"
        },
        "AWS::IoTAnalytics::Dataset": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Actions": {
                            "items": {
                                "$ref": "#/definitions/AWS::IoTAnalytics::Dataset.Action"
                            },
                            "type": "array"
                        },
                        "DatasetName": {
                            "type": "string"
                        },
                        "RetentionPeriod": {
                            "$ref": "#/definitions/AWS::IoTAnalytics::Dataset.RetentionPeriod"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        },
                        "Triggers": {
                            "items": {
                                "$ref": "#/definitions/AWS::IoTAnalytics::Dataset.Trigger"
                            },
                            "type": "array"
                        }
                    },
                    "required": [
                        "Actions"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::IoTAnalytics::Dataset"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::IoTAnalytics::Dataset.Action": {
            "additionalProperties": false,
            "properties": {
                "ActionName": {
                    "type": "string"
                },
                "ContainerAction": {
                    "$ref": "#/definitions/AWS::IoTAnalytics::Dataset.ContainerAction"
                },
                "QueryAction": {
                    "$ref": "#/definitions/AWS::IoTAnalytics::Dataset.QueryAction"
                }
            },
            "required": [
                "ActionName"
            ],
            "type": "object"
        },
        "AWS::IoTAnalytics::Dataset.ContainerAction": {
            "additionalProperties": false,
            "properties": {
                "ExecutionRoleArn": {
                    "type": "string"
                },
                "Image": {
                    "type": "string"
                },
                "ResourceConfiguration": {
                    "$ref": "#/definitions/AWS::IoTAnalytics::Dataset.ResourceConfiguration"
                },
                "Variables": {
                    "items": {
                        "$ref": "#/definitions/AWS::IoTAnalytics::Dataset.Variable"
                    },
                    "type": "array"
                }
            },
            "required": [
                "ExecutionRoleArn",
                "Image",
                "ResourceConfiguration"
            ],
            "type": "object"
        },
        "AWS::IoTAnalytics::Dataset.DatasetContentVersionValue": {
            "additionalProperties": false,
            "properties": {
                "DatasetName": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::IoTAnalytics::Dataset.DeltaTime": {
            "additionalProperties": false,
            "properties": {
                "OffsetSeconds": {
                    "type": "number"
                },
                "TimeExpression": {
                    "type": "string"
                }
            },
            "required": [
                "OffsetSeconds",
                "TimeExpression"
            ],
            "type": "object"
        },
        "AWS::IoTAnalytics::Dataset.Filter": {
            "additionalProperties": false,
            "properties": {
                "DeltaTime": {
                    "$ref": "#/definitions/AWS::IoTAnalytics::Dataset.DeltaTime"
                }
            },
            "type": "object"
        },
        "AWS::IoTAnalytics::Dataset.OutputFileUriValue": {
            "additionalProperties": false,
            "properties": {
                "FileName": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::IoTAnalytics::Dataset.QueryAction": {
            "additionalProperties": false,
            "properties": {
                "Filters": {
                    "items": {
                        "$ref": "#/definitions/AWS::IoTAnalytics::Dataset.Filter"
                    },
                    "type": "array"
                },
                "SqlQuery": {
                    "type": "string"
                }
            },
            "required": [
                "SqlQuery"
            ],
            "type": "object"
        },
        "AWS::IoTAnalytics::Dataset.ResourceConfiguration": {
            "additionalProperties": false,
            "properties": {
                "ComputeType": {
                    "type": "string"
                },
                "VolumeSizeInGB": {
                    "type": "number"
                }
            },
            "required": [
                "ComputeType",
                "VolumeSizeInGB"
            ],
            "type": "object"
        },
        "AWS::IoTAnalytics::Dataset.RetentionPeriod": {
            "additionalProperties": false,
            "properties": {
                "NumberOfDays": {
                    "type": "number"
                },
                "Unlimited": {
                    "type": "boolean"
                }
            },
            "required": [
                "NumberOfDays",
                "Unlimited"
            ],
            "type": "object"
        },
        "AWS::IoTAnalytics::Dataset.Schedule": {
            "additionalProperties": false,
            "properties": {
                "ScheduleExpression": {
                    "type": "string"
                }
            },
            "required": [
                "ScheduleExpression"
            ],
            "type": "object"
        },
        "AWS::IoTAnalytics::Dataset.Trigger": {
            "additionalProperties": false,
            "properties": {
                "Schedule": {
                    "$ref": "#/definitions/AWS::IoTAnalytics::Dataset.Schedule"
                },
                "TriggeringDataset": {
                    "$ref": "#/definitions/AWS::IoTAnalytics::Dataset.TriggeringDataset"
                }
            },
            "type": "object"
        },
        "AWS::IoTAnalytics::Dataset.TriggeringDataset": {
            "additionalProperties": false,
            "properties": {
                "DatasetName": {
                    "type": "string"
                }
            },
            "required": [
                "DatasetName"
            ],
            "type": "object"
        },
        "AWS::IoTAnalytics::Dataset.Variable": {
            "additionalProperties": false,
            "properties": {
                "DatasetContentVersionValue": {
                    "$ref": "#/definitions/AWS::IoTAnalytics::Dataset.DatasetContentVersionValue"
                },
                "DoubleValue": {
                    "type": "number"
                },
                "OutputFileUriValue": {
                    "$ref": "#/definitions/AWS::IoTAnalytics::Dataset.OutputFileUriValue"
                },
                "StringValue": {
                    "type": "string"
                },
                "VariableName": {
                    "type": "string"
                }
            },
            "required": [
                "VariableName"
            ],
            "type": "object"
        },
        "AWS::IoTAnalytics::Datastore": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "DatastoreName": {
                            "type": "string"
                        },
                        "RetentionPeriod": {
                            "$ref": "#/definitions/AWS::IoTAnalytics::Datastore.RetentionPeriod"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        }
                    },
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::IoTAnalytics::Datastore"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type"
            ],
            "type": "object"
        },
        "AWS::IoTAnalytics::Datastore.RetentionPeriod": {
            "additionalProperties": false,
            "properties": {
                "NumberOfDays": {
                    "type": "number"
                },
                "Unlimited": {
                    "type": "boolean"
                }
            },
            "type": "object"
        },
        "AWS::IoTAnalytics::Pipeline": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "PipelineActivities": {
                            "items": {
                                "$ref": "#/definitions/AWS::IoTAnalytics::Pipeline.Activity"
                            },
                            "type": "array"
                        },
                        "PipelineName": {
                            "type": "string"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        }
                    },
                    "required": [
                        "PipelineActivities"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::IoTAnalytics::Pipeline"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::IoTAnalytics::Pipeline.Activity": {
            "additionalProperties": false,
            "properties": {
                "AddAttributes": {
                    "$ref": "#/definitions/AWS::IoTAnalytics::Pipeline.AddAttributes"
                },
                "Channel": {
                    "$ref": "#/definitions/AWS::IoTAnalytics::Pipeline.Channel"
                },
                "Datastore": {
                    "$ref": "#/definitions/AWS::IoTAnalytics::Pipeline.Datastore"
                },
                "DeviceRegistryEnrich": {
                    "$ref": "#/definitions/AWS::IoTAnalytics::Pipeline.DeviceRegistryEnrich"
                },
                "DeviceShadowEnrich": {
                    "$ref": "#/definitions/AWS::IoTAnalytics::Pipeline.DeviceShadowEnrich"
                },
                "Filter": {
                    "$ref": "#/definitions/AWS::IoTAnalytics::Pipeline.Filter"
                },
                "Lambda": {
                    "$ref": "#/definitions/AWS::IoTAnalytics::Pipeline.Lambda"
                },
                "Math": {
                    "$ref": "#/definitions/AWS::IoTAnalytics::Pipeline.Math"
                },
                "RemoveAttributes": {
                    "$ref": "#/definitions/AWS::IoTAnalytics::Pipeline.RemoveAttributes"
                },
                "SelectAttributes": {
                    "$ref": "#/definitions/AWS::IoTAnalytics::Pipeline.SelectAttributes"
                }
            },
            "type": "object"
        },
        "AWS::IoTAnalytics::Pipeline.AddAttributes": {
            "additionalProperties": false,
            "properties": {
                "Attributes": {
                    "type": "object"
                },
                "Name": {
                    "type": "string"
                },
                "Next": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::IoTAnalytics::Pipeline.Channel": {
            "additionalProperties": false,
            "properties": {
                "ChannelName": {
                    "type": "string"
                },
                "Name": {
                    "type": "string"
                },
                "Next": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::IoTAnalytics::Pipeline.Datastore": {
            "additionalProperties": false,
            "properties": {
                "DatastoreName": {
                    "type": "string"
                },
                "Name": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::IoTAnalytics::Pipeline.DeviceRegistryEnrich": {
            "additionalProperties": false,
            "properties": {
                "Attribute": {
                    "type": "string"
                },
                "Name": {
                    "type": "string"
                },
                "Next": {
                    "type": "string"
                },
                "RoleArn": {
                    "type": "string"
                },
                "ThingName": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::IoTAnalytics::Pipeline.DeviceShadowEnrich": {
            "additionalProperties": false,
            "properties": {
                "Attribute": {
                    "type": "string"
                },
                "Name": {
                    "type": "string"
                },
                "Next": {
                    "type": "string"
                },
                "RoleArn": {
                    "type": "string"
                },
                "ThingName": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::IoTAnalytics::Pipeline.Filter": {
            "additionalProperties": false,
            "properties": {
                "Filter": {
                    "type": "string"
                },
                "Name": {
                    "type": "string"
                },
                "Next": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::IoTAnalytics::Pipeline.Lambda": {
            "additionalProperties": false,
            "properties": {
                "BatchSize": {
                    "type": "number"
                },
                "LambdaName": {
                    "type": "string"
                },
                "Name": {
                    "type": "string"
                },
                "Next": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::IoTAnalytics::Pipeline.Math": {
            "additionalProperties": false,
            "properties": {
                "Attribute": {
                    "type": "string"
                },
                "Math": {
                    "type": "string"
                },
                "Name": {
                    "type": "string"
                },
                "Next": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::IoTAnalytics::Pipeline.RemoveAttributes": {
            "additionalProperties": false,
            "properties": {
                "Attributes": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "Name": {
                    "type": "string"
                },
                "Next": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::IoTAnalytics::Pipeline.SelectAttributes": {
            "additionalProperties": false,
            "properties": {
                "Attributes": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "Name": {
                    "type": "string"
                },
                "Next": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::KMS::Alias": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "AliasName": {
                            "type": "string"
                        },
                        "TargetKeyId": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "AliasName",
                        "TargetKeyId"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::KMS::Alias"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::KMS::Key": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Description": {
                            "type": "string"
                        },
                        "EnableKeyRotation": {
                            "type": "boolean"
                        },
                        "Enabled": {
                            "type": "boolean"
                        },
                        "KeyPolicy": {
                            "type": "object"
                        },
                        "KeyUsage": {
                            "type": "string"
                        },
                        "PendingWindowInDays": {
                            "type": "number"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        }
                    },
                    "required": [
                        "KeyPolicy"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::KMS::Key"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::Kinesis::Stream": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Name": {
                            "type": "string"
                        },
                        "RetentionPeriodHours": {
                            "type": "number"
                        },
                        "ShardCount": {
                            "type": "number"
                        },
                        "StreamEncryption": {
                            "$ref": "#/definitions/AWS::Kinesis::Stream.StreamEncryption"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        }
                    },
                    "required": [
                        "ShardCount"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::Kinesis::Stream"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::Kinesis::Stream.StreamEncryption": {
            "additionalProperties": false,
            "properties": {
                "EncryptionType": {
                    "type": "string"
                },
                "KeyId": {
                    "type": "string"
                }
            },
            "required": [
                "EncryptionType",
                "KeyId"
            ],
            "type": "object"
        },
        "AWS::Kinesis::StreamConsumer": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "ConsumerName": {
                            "type": "string"
                        },
                        "StreamARN": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "ConsumerName",
                        "StreamARN"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::Kinesis::StreamConsumer"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::KinesisAnalytics::Application": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "ApplicationCode": {
                            "type": "string"
                        },
                        "ApplicationDescription": {
                            "type": "string"
                        },
                        "ApplicationName": {
                            "type": "string"
                        },
                        "Inputs": {
                            "items": {
                                "$ref": "#/definitions/AWS::KinesisAnalytics::Application.Input"
                            },
                            "type": "array"
                        }
                    },
                    "required": [
                        "Inputs"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::KinesisAnalytics::Application"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::KinesisAnalytics::Application.CSVMappingParameters": {
            "additionalProperties": false,
            "properties": {
                "RecordColumnDelimiter": {
                    "type": "string"
                },
                "RecordRowDelimiter": {
                    "type": "string"
                }
            },
            "required": [
                "RecordColumnDelimiter",
                "RecordRowDelimiter"
            ],
            "type": "object"
        },
        "AWS::KinesisAnalytics::Application.Input": {
            "additionalProperties": false,
            "properties": {
                "InputParallelism": {
                    "$ref": "#/definitions/AWS::KinesisAnalytics::Application.InputParallelism"
                },
                "InputProcessingConfiguration": {
                    "$ref": "#/definitions/AWS::KinesisAnalytics::Application.InputProcessingConfiguration"
                },
                "InputSchema": {
                    "$ref": "#/definitions/AWS::KinesisAnalytics::Application.InputSchema"
                },
                "KinesisFirehoseInput": {
                    "$ref": "#/definitions/AWS::KinesisAnalytics::Application.KinesisFirehoseInput"
                },
                "KinesisStreamsInput": {
                    "$ref": "#/definitions/AWS::KinesisAnalytics::Application.KinesisStreamsInput"
                },
                "NamePrefix": {
                    "type": "string"
                }
            },
            "required": [
                "InputSchema",
                "NamePrefix"
            ],
            "type": "object"
        },
        "AWS::KinesisAnalytics::Application.InputLambdaProcessor": {
            "additionalProperties": false,
            "properties": {
                "ResourceARN": {
                    "type": "string"
                },
                "RoleARN": {
                    "type": "string"
                }
            },
            "required": [
                "ResourceARN",
                "RoleARN"
            ],
            "type": "object"
        },
        "AWS::KinesisAnalytics::Application.InputParallelism": {
            "additionalProperties": false,
            "properties": {
                "Count": {
                    "type": "number"
                }
            },
            "type": "object"
        },
        "AWS::KinesisAnalytics::Application.InputProcessingConfiguration": {
            "additionalProperties": false,
            "properties": {
                "InputLambdaProcessor": {
                    "$ref": "#/definitions/AWS::KinesisAnalytics::Application.InputLambdaProcessor"
                }
            },
            "type": "object"
        },
        "AWS::KinesisAnalytics::Application.InputSchema": {
            "additionalProperties": false,
            "properties": {
                "RecordColumns": {
                    "items": {
                        "$ref": "#/definitions/AWS::KinesisAnalytics::Application.RecordColumn"
                    },
                    "type": "array"
                },
                "RecordEncoding": {
                    "type": "string"
                },
                "RecordFormat": {
                    "$ref": "#/definitions/AWS::KinesisAnalytics::Application.RecordFormat"
                }
            },
            "required": [
                "RecordColumns",
                "RecordFormat"
            ],
            "type": "object"
        },
        "AWS::KinesisAnalytics::Application.JSONMappingParameters": {
            "additionalProperties": false,
            "properties": {
                "RecordRowPath": {
                    "type": "string"
                }
            },
            "required": [
                "RecordRowPath"
            ],
            "type": "object"
        },
        "AWS::KinesisAnalytics::Application.KinesisFirehoseInput": {
            "additionalProperties": false,
            "properties": {
                "ResourceARN": {
                    "type": "string"
                },
                "RoleARN": {
                    "type": "string"
                }
            },
            "required": [
                "ResourceARN",
                "RoleARN"
            ],
            "type": "object"
        },
        "AWS::KinesisAnalytics::Application.KinesisStreamsInput": {
            "additionalProperties": false,
            "properties": {
                "ResourceARN": {
                    "type": "string"
                },
                "RoleARN": {
                    "type": "string"
                }
            },
            "required": [
                "ResourceARN",
                "RoleARN"
            ],
            "type": "object"
        },
        "AWS::KinesisAnalytics::Application.MappingParameters": {
            "additionalProperties": false,
            "properties": {
                "CSVMappingParameters": {
                    "$ref": "#/definitions/AWS::KinesisAnalytics::Application.CSVMappingParameters"
                },
                "JSONMappingParameters": {
                    "$ref": "#/definitions/AWS::KinesisAnalytics::Application.JSONMappingParameters"
                }
            },
            "type": "object"
        },
        "AWS::KinesisAnalytics::Application.RecordColumn": {
            "additionalProperties": false,
            "properties": {
                "Mapping": {
                    "type": "string"
                },
                "Name": {
                    "type": "string"
                },
                "SqlType": {
                    "type": "string"
                }
            },
            "required": [
                "Name",
                "SqlType"
            ],
            "type": "object"
        },
        "AWS::KinesisAnalytics::Application.RecordFormat": {
            "additionalProperties": false,
            "properties": {
                "MappingParameters": {
                    "$ref": "#/definitions/AWS::KinesisAnalytics::Application.MappingParameters"
                },
                "RecordFormatType": {
                    "type": "string"
                }
            },
            "required": [
                "RecordFormatType"
            ],
            "type": "object"
        },
        "AWS::KinesisAnalytics::ApplicationOutput": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "ApplicationName": {
                            "type": "string"
                        },
                        "Output": {
                            "$ref": "#/definitions/AWS::KinesisAnalytics::ApplicationOutput.Output"
                        }
                    },
                    "required": [
                        "ApplicationName",
                        "Output"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::KinesisAnalytics::ApplicationOutput"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::KinesisAnalytics::ApplicationOutput.DestinationSchema": {
            "additionalProperties": false,
            "properties": {
                "RecordFormatType": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::KinesisAnalytics::ApplicationOutput.KinesisFirehoseOutput": {
            "additionalProperties": false,
            "properties": {
                "ResourceARN": {
                    "type": "string"
                },
                "RoleARN": {
                    "type": "string"
                }
            },
            "required": [
                "ResourceARN",
                "RoleARN"
            ],
            "type": "object"
        },
        "AWS::KinesisAnalytics::ApplicationOutput.KinesisStreamsOutput": {
            "additionalProperties": false,
            "properties": {
                "ResourceARN": {
                    "type": "string"
                },
                "RoleARN": {
                    "type": "string"
                }
            },
            "required": [
                "ResourceARN",
                "RoleARN"
            ],
            "type": "object"
        },
        "AWS::KinesisAnalytics::ApplicationOutput.LambdaOutput": {
            "additionalProperties": false,
            "properties": {
                "ResourceARN": {
                    "type": "string"
                },
                "RoleARN": {
                    "type": "string"
                }
            },
            "required": [
                "ResourceARN",
                "RoleARN"
            ],
            "type": "object"
        },
        "AWS::KinesisAnalytics::ApplicationOutput.Output": {
            "additionalProperties": false,
            "properties": {
                "DestinationSchema": {
                    "$ref": "#/definitions/AWS::KinesisAnalytics::ApplicationOutput.DestinationSchema"
                },
                "KinesisFirehoseOutput": {
                    "$ref": "#/definitions/AWS::KinesisAnalytics::ApplicationOutput.KinesisFirehoseOutput"
                },
                "KinesisStreamsOutput": {
                    "$ref": "#/definitions/AWS::KinesisAnalytics::ApplicationOutput.KinesisStreamsOutput"
                },
                "LambdaOutput": {
                    "$ref": "#/definitions/AWS::KinesisAnalytics::ApplicationOutput.LambdaOutput"
                },
                "Name": {
                    "type": "string"
                }
            },
            "required": [
                "DestinationSchema"
            ],
            "type": "object"
        },
        "AWS::KinesisAnalytics::ApplicationReferenceDataSource": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "ApplicationName": {
                            "type": "string"
                        },
                        "ReferenceDataSource": {
                            "$ref": "#/definitions/AWS::KinesisAnalytics::ApplicationReferenceDataSource.ReferenceDataSource"
                        }
                    },
                    "required": [
                        "ApplicationName",
                        "ReferenceDataSource"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::KinesisAnalytics::ApplicationReferenceDataSource"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::KinesisAnalytics::ApplicationReferenceDataSource.CSVMappingParameters": {
            "additionalProperties": false,
            "properties": {
                "RecordColumnDelimiter": {
                    "type": "string"
                },
                "RecordRowDelimiter": {
                    "type": "string"
                }
            },
            "required": [
                "RecordColumnDelimiter",
                "RecordRowDelimiter"
            ],
            "type": "object"
        },
        "AWS::KinesisAnalytics::ApplicationReferenceDataSource.JSONMappingParameters": {
            "additionalProperties": false,
            "properties": {
                "RecordRowPath": {
                    "type": "string"
                }
            },
            "required": [
                "RecordRowPath"
            ],
            "type": "object"
        },
        "AWS::KinesisAnalytics::ApplicationReferenceDataSource.MappingParameters": {
            "additionalProperties": false,
            "properties": {
                "CSVMappingParameters": {
                    "$ref": "#/definitions/AWS::KinesisAnalytics::ApplicationReferenceDataSource.CSVMappingParameters"
                },
                "JSONMappingParameters": {
                    "$ref": "#/definitions/AWS::KinesisAnalytics::ApplicationReferenceDataSource.JSONMappingParameters"
                }
            },
            "type": "object"
        },
        "AWS::KinesisAnalytics::ApplicationReferenceDataSource.RecordColumn": {
            "additionalProperties": false,
            "properties": {
                "Mapping": {
                    "type": "string"
                },
                "Name": {
                    "type": "string"
                },
                "SqlType": {
                    "type": "string"
                }
            },
            "required": [
                "Name",
                "SqlType"
            ],
            "type": "object"
        },
        "AWS::KinesisAnalytics::ApplicationReferenceDataSource.RecordFormat": {
            "additionalProperties": false,
            "properties": {
                "MappingParameters": {
                    "$ref": "#/definitions/AWS::KinesisAnalytics::ApplicationReferenceDataSource.MappingParameters"
                },
                "RecordFormatType": {
                    "type": "string"
                }
            },
            "required": [
                "RecordFormatType"
            ],
            "type": "object"
        },
        "AWS::KinesisAnalytics::ApplicationReferenceDataSource.ReferenceDataSource": {
            "additionalProperties": false,
            "properties": {
                "ReferenceSchema": {
                    "$ref": "#/definitions/AWS::KinesisAnalytics::ApplicationReferenceDataSource.ReferenceSchema"
                },
                "S3ReferenceDataSource": {
                    "$ref": "#/definitions/AWS::KinesisAnalytics::ApplicationReferenceDataSource.S3ReferenceDataSource"
                },
                "TableName": {
                    "type": "string"
                }
            },
            "required": [
                "ReferenceSchema"
            ],
            "type": "object"
        },
        "AWS::KinesisAnalytics::ApplicationReferenceDataSource.ReferenceSchema": {
            "additionalProperties": false,
            "properties": {
                "RecordColumns": {
                    "items": {
                        "$ref": "#/definitions/AWS::KinesisAnalytics::ApplicationReferenceDataSource.RecordColumn"
                    },
                    "type": "array"
                },
                "RecordEncoding": {
                    "type": "string"
                },
                "RecordFormat": {
                    "$ref": "#/definitions/AWS::KinesisAnalytics::ApplicationReferenceDataSource.RecordFormat"
                }
            },
            "required": [
                "RecordColumns",
                "RecordFormat"
            ],
            "type": "object"
        },
        "AWS::KinesisAnalytics::ApplicationReferenceDataSource.S3ReferenceDataSource": {
            "additionalProperties": false,
            "properties": {
                "BucketARN": {
                    "type": "string"
                },
                "FileKey": {
                    "type": "string"
                },
                "ReferenceRoleARN": {
                    "type": "string"
                }
            },
            "required": [
                "BucketARN",
                "FileKey",
                "ReferenceRoleARN"
            ],
            "type": "object"
        },
        "AWS::KinesisAnalyticsV2::Application": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "ApplicationConfiguration": {
                            "$ref": "#/definitions/AWS::KinesisAnalyticsV2::Application.ApplicationConfiguration"
                        },
                        "ApplicationDescription": {
                            "type": "string"
                        },
                        "ApplicationName": {
                            "type": "string"
                        },
                        "RuntimeEnvironment": {
                            "type": "string"
                        },
                        "ServiceExecutionRole": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "RuntimeEnvironment",
                        "ServiceExecutionRole"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::KinesisAnalyticsV2::Application"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::KinesisAnalyticsV2::Application.ApplicationCodeConfiguration": {
            "additionalProperties": false,
            "properties": {
                "CodeContent": {
                    "$ref": "#/definitions/AWS::KinesisAnalyticsV2::Application.CodeContent"
                },
                "CodeContentType": {
                    "type": "string"
                }
            },
            "required": [
                "CodeContent",
                "CodeContentType"
            ],
            "type": "object"
        },
        "AWS::KinesisAnalyticsV2::Application.ApplicationConfiguration": {
            "additionalProperties": false,
            "properties": {
                "ApplicationCodeConfiguration": {
                    "$ref": "#/definitions/AWS::KinesisAnalyticsV2::Application.ApplicationCodeConfiguration"
                },
                "ApplicationSnapshotConfiguration": {
                    "$ref": "#/definitions/AWS::KinesisAnalyticsV2::Application.ApplicationSnapshotConfiguration"
                },
                "EnvironmentProperties": {
                    "$ref": "#/definitions/AWS::KinesisAnalyticsV2::Application.EnvironmentProperties"
                },
                "FlinkApplicationConfiguration": {
                    "$ref": "#/definitions/AWS::KinesisAnalyticsV2::Application.FlinkApplicationConfiguration"
                },
                "SqlApplicationConfiguration": {
                    "$ref": "#/definitions/AWS::KinesisAnalyticsV2::Application.SqlApplicationConfiguration"
                }
            },
            "type": "object"
        },
        "AWS::KinesisAnalyticsV2::Application.ApplicationSnapshotConfiguration": {
            "additionalProperties": false,
            "properties": {
                "SnapshotsEnabled": {
                    "type": "boolean"
                }
            },
            "required": [
                "SnapshotsEnabled"
            ],
            "type": "object"
        },
        "AWS::KinesisAnalyticsV2::Application.CSVMappingParameters": {
            "additionalProperties": false,
            "properties": {
                "RecordColumnDelimiter": {
                    "type": "string"
                },
                "RecordRowDelimiter": {
                    "type": "string"
                }
            },
            "required": [
                "RecordColumnDelimiter",
                "RecordRowDelimiter"
            ],
            "type": "object"
        },
        "AWS::KinesisAnalyticsV2::Application.CheckpointConfiguration": {
            "additionalProperties": false,
            "properties": {
                "CheckpointInterval": {
                    "type": "number"
                },
                "CheckpointingEnabled": {
                    "type": "boolean"
                },
                "ConfigurationType": {
                    "type": "string"
                },
                "MinPauseBetweenCheckpoints": {
                    "type": "number"
                }
            },
            "required": [
                "ConfigurationType"
            ],
            "type": "object"
        },
        "AWS::KinesisAnalyticsV2::Application.CodeContent": {
            "additionalProperties": false,
            "properties": {
                "S3ContentLocation": {
                    "$ref": "#/definitions/AWS::KinesisAnalyticsV2::Application.S3ContentLocation"
                },
                "TextContent": {
                    "type": "string"
                },
                "ZipFileContent": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::KinesisAnalyticsV2::Application.EnvironmentProperties": {
            "additionalProperties": false,
            "properties": {
                "PropertyGroups": {
                    "items": {
                        "$ref": "#/definitions/AWS::KinesisAnalyticsV2::Application.PropertyGroup"
                    },
                    "type": "array"
                }
            },
            "type": "object"
        },
        "AWS::KinesisAnalyticsV2::Application.FlinkApplicationConfiguration": {
            "additionalProperties": false,
            "properties": {
                "CheckpointConfiguration": {
                    "$ref": "#/definitions/AWS::KinesisAnalyticsV2::Application.CheckpointConfiguration"
                },
                "MonitoringConfiguration": {
                    "$ref": "#/definitions/AWS::KinesisAnalyticsV2::Application.MonitoringConfiguration"
                },
                "ParallelismConfiguration": {
                    "$ref": "#/definitions/AWS::KinesisAnalyticsV2::Application.ParallelismConfiguration"
                }
            },
            "type": "object"
        },
        "AWS::KinesisAnalyticsV2::Application.Input": {
            "additionalProperties": false,
            "properties": {
                "InputParallelism": {
                    "$ref": "#/definitions/AWS::KinesisAnalyticsV2::Application.InputParallelism"
                },
                "InputProcessingConfiguration": {
                    "$ref": "#/definitions/AWS::KinesisAnalyticsV2::Application.InputProcessingConfiguration"
                },
                "InputSchema": {
                    "$ref": "#/definitions/AWS::KinesisAnalyticsV2::Application.InputSchema"
                },
                "KinesisFirehoseInput": {
                    "$ref": "#/definitions/AWS::KinesisAnalyticsV2::Application.KinesisFirehoseInput"
                },
                "KinesisStreamsInput": {
                    "$ref": "#/definitions/AWS::KinesisAnalyticsV2::Application.KinesisStreamsInput"
                },
                "NamePrefix": {
                    "type": "string"
                }
            },
            "required": [
                "InputSchema",
                "NamePrefix"
            ],
            "type": "object"
        },
        "AWS::KinesisAnalyticsV2::Application.InputLambdaProcessor": {
            "additionalProperties": false,
            "properties": {
                "ResourceARN": {
                    "type": "string"
                }
            },
            "required": [
                "ResourceARN"
            ],
            "type": "object"
        },
        "AWS::KinesisAnalyticsV2::Application.InputParallelism": {
            "additionalProperties": false,
            "properties": {
                "Count": {
                    "type": "number"
                }
            },
            "type": "object"
        },
        "AWS::KinesisAnalyticsV2::Application.InputProcessingConfiguration": {
            "additionalProperties": false,
            "properties": {
                "InputLambdaProcessor": {
                    "$ref": "#/definitions/AWS::KinesisAnalyticsV2::Application.InputLambdaProcessor"
                }
            },
            "type": "object"
        },
        "AWS::KinesisAnalyticsV2::Application.InputSchema": {
            "additionalProperties": false,
            "properties": {
                "RecordColumns": {
                    "items": {
                        "$ref": "#/definitions/AWS::KinesisAnalyticsV2::Application.RecordColumn"
                    },
                    "type": "array"
                },
                "RecordEncoding": {
                    "type": "string"
                },
                "RecordFormat": {
                    "$ref": "#/definitions/AWS::KinesisAnalyticsV2::Application.RecordFormat"
                }
            },
            "required": [
                "RecordColumns",
                "RecordFormat"
            ],
            "type": "object"
        },
        "AWS::KinesisAnalyticsV2::Application.JSONMappingParameters": {
            "additionalProperties": false,
            "properties": {
                "RecordRowPath": {
                    "type": "string"
                }
            },
            "required": [
                "RecordRowPath"
            ],
            "type": "object"
        },
        "AWS::KinesisAnalyticsV2::Application.KinesisFirehoseInput": {
            "additionalProperties": false,
            "properties": {
                "ResourceARN": {
                    "type": "string"
                }
            },
            "required": [
                "ResourceARN"
            ],
            "type": "object"
        },
        "AWS::KinesisAnalyticsV2::Application.KinesisStreamsInput": {
            "additionalProperties": false,
            "properties": {
                "ResourceARN": {
                    "type": "string"
                }
            },
            "required": [
                "ResourceARN"
            ],
            "type": "object"
        },
        "AWS::KinesisAnalyticsV2::Application.MappingParameters": {
            "additionalProperties": false,
            "properties": {
                "CSVMappingParameters": {
                    "$ref": "#/definitions/AWS::KinesisAnalyticsV2::Application.CSVMappingParameters"
                },
                "JSONMappingParameters": {
                    "$ref": "#/definitions/AWS::KinesisAnalyticsV2::Application.JSONMappingParameters"
                }
            },
            "type": "object"
        },
        "AWS::KinesisAnalyticsV2::Application.MonitoringConfiguration": {
            "additionalProperties": false,
            "properties": {
                "ConfigurationType": {
                    "type": "string"
                },
                "LogLevel": {
                    "type": "string"
                },
                "MetricsLevel": {
                    "type": "string"
                }
            },
            "required": [
                "ConfigurationType"
            ],
            "type": "object"
        },
        "AWS::KinesisAnalyticsV2::Application.ParallelismConfiguration": {
            "additionalProperties": false,
            "properties": {
                "AutoScalingEnabled": {
                    "type": "boolean"
                },
                "ConfigurationType": {
                    "type": "string"
                },
                "Parallelism": {
                    "type": "number"
                },
                "ParallelismPerKPU": {
                    "type": "number"
                }
            },
            "required": [
                "ConfigurationType"
            ],
            "type": "object"
        },
        "AWS::KinesisAnalyticsV2::Application.PropertyGroup": {
            "additionalProperties": false,
            "properties": {
                "PropertyGroupId": {
                    "type": "string"
                },
                "PropertyMap": {
                    "type": "object"
                }
            },
            "type": "object"
        },
        "AWS::KinesisAnalyticsV2::Application.RecordColumn": {
            "additionalProperties": false,
            "properties": {
                "Mapping": {
                    "type": "string"
                },
                "Name": {
                    "type": "string"
                },
                "SqlType": {
                    "type": "string"
                }
            },
            "required": [
                "Name",
                "SqlType"
            ],
            "type": "object"
        },
        "AWS::KinesisAnalyticsV2::Application.RecordFormat": {
            "additionalProperties": false,
            "properties": {
                "MappingParameters": {
                    "$ref": "#/definitions/AWS::KinesisAnalyticsV2::Application.MappingParameters"
                },
                "RecordFormatType": {
                    "type": "string"
                }
            },
            "required": [
                "RecordFormatType"
            ],
            "type": "object"
        },
        "AWS::KinesisAnalyticsV2::Application.S3ContentLocation": {
            "additionalProperties": false,
            "properties": {
                "BucketARN": {
                    "type": "string"
                },
                "FileKey": {
                    "type": "string"
                },
                "ObjectVersion": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::KinesisAnalyticsV2::Application.SqlApplicationConfiguration": {
            "additionalProperties": false,
            "properties": {
                "Inputs": {
                    "items": {
                        "$ref": "#/definitions/AWS::KinesisAnalyticsV2::Application.Input"
                    },
                    "type": "array"
                }
            },
            "type": "object"
        },
        "AWS::KinesisAnalyticsV2::ApplicationCloudWatchLoggingOption": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "ApplicationName": {
                            "type": "string"
                        },
                        "CloudWatchLoggingOption": {
                            "$ref": "#/definitions/AWS::KinesisAnalyticsV2::ApplicationCloudWatchLoggingOption.CloudWatchLoggingOption"
                        }
                    },
                    "required": [
                        "ApplicationName",
                        "CloudWatchLoggingOption"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::KinesisAnalyticsV2::ApplicationCloudWatchLoggingOption"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::KinesisAnalyticsV2::ApplicationCloudWatchLoggingOption.CloudWatchLoggingOption": {
            "additionalProperties": false,
            "properties": {
                "LogStreamARN": {
                    "type": "string"
                }
            },
            "required": [
                "LogStreamARN"
            ],
            "type": "object"
        },
        "AWS::KinesisAnalyticsV2::ApplicationOutput": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "ApplicationName": {
                            "type": "string"
                        },
                        "Output": {
                            "$ref": "#/definitions/AWS::KinesisAnalyticsV2::ApplicationOutput.Output"
                        }
                    },
                    "required": [
                        "ApplicationName",
                        "Output"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::KinesisAnalyticsV2::ApplicationOutput"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::KinesisAnalyticsV2::ApplicationOutput.DestinationSchema": {
            "additionalProperties": false,
            "properties": {
                "RecordFormatType": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::KinesisAnalyticsV2::ApplicationOutput.KinesisFirehoseOutput": {
            "additionalProperties": false,
            "properties": {
                "ResourceARN": {
                    "type": "string"
                }
            },
            "required": [
                "ResourceARN"
            ],
            "type": "object"
        },
        "AWS::KinesisAnalyticsV2::ApplicationOutput.KinesisStreamsOutput": {
            "additionalProperties": false,
            "properties": {
                "ResourceARN": {
                    "type": "string"
                }
            },
            "required": [
                "ResourceARN"
            ],
            "type": "object"
        },
        "AWS::KinesisAnalyticsV2::ApplicationOutput.LambdaOutput": {
            "additionalProperties": false,
            "properties": {
                "ResourceARN": {
                    "type": "string"
                }
            },
            "required": [
                "ResourceARN"
            ],
            "type": "object"
        },
        "AWS::KinesisAnalyticsV2::ApplicationOutput.Output": {
            "additionalProperties": false,
            "properties": {
                "DestinationSchema": {
                    "$ref": "#/definitions/AWS::KinesisAnalyticsV2::ApplicationOutput.DestinationSchema"
                },
                "KinesisFirehoseOutput": {
                    "$ref": "#/definitions/AWS::KinesisAnalyticsV2::ApplicationOutput.KinesisFirehoseOutput"
                },
                "KinesisStreamsOutput": {
                    "$ref": "#/definitions/AWS::KinesisAnalyticsV2::ApplicationOutput.KinesisStreamsOutput"
                },
                "LambdaOutput": {
                    "$ref": "#/definitions/AWS::KinesisAnalyticsV2::ApplicationOutput.LambdaOutput"
                },
                "Name": {
                    "type": "string"
                }
            },
            "required": [
                "DestinationSchema"
            ],
            "type": "object"
        },
        "AWS::KinesisAnalyticsV2::ApplicationReferenceDataSource": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "ApplicationName": {
                            "type": "string"
                        },
                        "ReferenceDataSource": {
                            "$ref": "#/definitions/AWS::KinesisAnalyticsV2::ApplicationReferenceDataSource.ReferenceDataSource"
                        }
                    },
                    "required": [
                        "ApplicationName",
                        "ReferenceDataSource"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::KinesisAnalyticsV2::ApplicationReferenceDataSource"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::KinesisAnalyticsV2::ApplicationReferenceDataSource.CSVMappingParameters": {
            "additionalProperties": false,
            "properties": {
                "RecordColumnDelimiter": {
                    "type": "string"
                },
                "RecordRowDelimiter": {
                    "type": "string"
                }
            },
            "required": [
                "RecordColumnDelimiter",
                "RecordRowDelimiter"
            ],
            "type": "object"
        },
        "AWS::KinesisAnalyticsV2::ApplicationReferenceDataSource.JSONMappingParameters": {
            "additionalProperties": false,
            "properties": {
                "RecordRowPath": {
                    "type": "string"
                }
            },
            "required": [
                "RecordRowPath"
            ],
            "type": "object"
        },
        "AWS::KinesisAnalyticsV2::ApplicationReferenceDataSource.MappingParameters": {
            "additionalProperties": false,
            "properties": {
                "CSVMappingParameters": {
                    "$ref": "#/definitions/AWS::KinesisAnalyticsV2::ApplicationReferenceDataSource.CSVMappingParameters"
                },
                "JSONMappingParameters": {
                    "$ref": "#/definitions/AWS::KinesisAnalyticsV2::ApplicationReferenceDataSource.JSONMappingParameters"
                }
            },
            "type": "object"
        },
        "AWS::KinesisAnalyticsV2::ApplicationReferenceDataSource.RecordColumn": {
            "additionalProperties": false,
            "properties": {
                "Mapping": {
                    "type": "string"
                },
                "Name": {
                    "type": "string"
                },
                "SqlType": {
                    "type": "string"
                }
            },
            "required": [
                "Name",
                "SqlType"
            ],
            "type": "object"
        },
        "AWS::KinesisAnalyticsV2::ApplicationReferenceDataSource.RecordFormat": {
            "additionalProperties": false,
            "properties": {
                "MappingParameters": {
                    "$ref": "#/definitions/AWS::KinesisAnalyticsV2::ApplicationReferenceDataSource.MappingParameters"
                },
                "RecordFormatType": {
                    "type": "string"
                }
            },
            "required": [
                "RecordFormatType"
            ],
            "type": "object"
        },
        "AWS::KinesisAnalyticsV2::ApplicationReferenceDataSource.ReferenceDataSource": {
            "additionalProperties": false,
            "properties": {
                "ReferenceSchema": {
                    "$ref": "#/definitions/AWS::KinesisAnalyticsV2::ApplicationReferenceDataSource.ReferenceSchema"
                },
                "S3ReferenceDataSource": {
                    "$ref": "#/definitions/AWS::KinesisAnalyticsV2::ApplicationReferenceDataSource.S3ReferenceDataSource"
                },
                "TableName": {
                    "type": "string"
                }
            },
            "required": [
                "ReferenceSchema"
            ],
            "type": "object"
        },
        "AWS::KinesisAnalyticsV2::ApplicationReferenceDataSource.ReferenceSchema": {
            "additionalProperties": false,
            "properties": {
                "RecordColumns": {
                    "items": {
                        "$ref": "#/definitions/AWS::KinesisAnalyticsV2::ApplicationReferenceDataSource.RecordColumn"
                    },
                    "type": "array"
                },
                "RecordEncoding": {
                    "type": "string"
                },
                "RecordFormat": {
                    "$ref": "#/definitions/AWS::KinesisAnalyticsV2::ApplicationReferenceDataSource.RecordFormat"
                }
            },
            "required": [
                "RecordColumns",
                "RecordFormat"
            ],
            "type": "object"
        },
        "AWS::KinesisAnalyticsV2::ApplicationReferenceDataSource.S3ReferenceDataSource": {
            "additionalProperties": false,
            "properties": {
                "BucketARN": {
                    "type": "string"
                },
                "FileKey": {
                    "type": "string"
                }
            },
            "required": [
                "BucketARN",
                "FileKey"
            ],
            "type": "object"
        },
        "AWS::KinesisFirehose::DeliveryStream": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "DeliveryStreamName": {
                            "type": "string"
                        },
                        "DeliveryStreamType": {
                            "type": "string"
                        },
                        "ElasticsearchDestinationConfiguration": {
                            "$ref": "#/definitions/AWS::KinesisFirehose::DeliveryStream.ElasticsearchDestinationConfiguration"
                        },
                        "ExtendedS3DestinationConfiguration": {
                            "$ref": "#/definitions/AWS::KinesisFirehose::DeliveryStream.ExtendedS3DestinationConfiguration"
                        },
                        "KinesisStreamSourceConfiguration": {
                            "$ref": "#/definitions/AWS::KinesisFirehose::DeliveryStream.KinesisStreamSourceConfiguration"
                        },
                        "RedshiftDestinationConfiguration": {
                            "$ref": "#/definitions/AWS::KinesisFirehose::DeliveryStream.RedshiftDestinationConfiguration"
                        },
                        "S3DestinationConfiguration": {
                            "$ref": "#/definitions/AWS::KinesisFirehose::DeliveryStream.S3DestinationConfiguration"
                        },
                        "SplunkDestinationConfiguration": {
                            "$ref": "#/definitions/AWS::KinesisFirehose::DeliveryStream.SplunkDestinationConfiguration"
                        }
                    },
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::KinesisFirehose::DeliveryStream"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type"
            ],
            "type": "object"
        },
        "AWS::KinesisFirehose::DeliveryStream.BufferingHints": {
            "additionalProperties": false,
            "properties": {
                "IntervalInSeconds": {
                    "type": "number"
                },
                "SizeInMBs": {
                    "type": "number"
                }
            },
            "required": [
                "IntervalInSeconds",
                "SizeInMBs"
            ],
            "type": "object"
        },
        "AWS::KinesisFirehose::DeliveryStream.CloudWatchLoggingOptions": {
            "additionalProperties": false,
            "properties": {
                "Enabled": {
                    "type": "boolean"
                },
                "LogGroupName": {
                    "type": "string"
                },
                "LogStreamName": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::KinesisFirehose::DeliveryStream.CopyCommand": {
            "additionalProperties": false,
            "properties": {
                "CopyOptions": {
                    "type": "string"
                },
                "DataTableColumns": {
                    "type": "string"
                },
                "DataTableName": {
                    "type": "string"
                }
            },
            "required": [
                "DataTableName"
            ],
            "type": "object"
        },
        "AWS::KinesisFirehose::DeliveryStream.ElasticsearchBufferingHints": {
            "additionalProperties": false,
            "properties": {
                "IntervalInSeconds": {
                    "type": "number"
                },
                "SizeInMBs": {
                    "type": "number"
                }
            },
            "required": [
                "IntervalInSeconds",
                "SizeInMBs"
            ],
            "type": "object"
        },
        "AWS::KinesisFirehose::DeliveryStream.ElasticsearchDestinationConfiguration": {
            "additionalProperties": false,
            "properties": {
                "BufferingHints": {
                    "$ref": "#/definitions/AWS::KinesisFirehose::DeliveryStream.ElasticsearchBufferingHints"
                },
                "CloudWatchLoggingOptions": {
                    "$ref": "#/definitions/AWS::KinesisFirehose::DeliveryStream.CloudWatchLoggingOptions"
                },
                "DomainARN": {
                    "type": "string"
                },
                "IndexName": {
                    "type": "string"
                },
                "IndexRotationPeriod": {
                    "type": "string"
                },
                "ProcessingConfiguration": {
                    "$ref": "#/definitions/AWS::KinesisFirehose::DeliveryStream.ProcessingConfiguration"
                },
                "RetryOptions": {
                    "$ref": "#/definitions/AWS::KinesisFirehose::DeliveryStream.ElasticsearchRetryOptions"
                },
                "RoleARN": {
                    "type": "string"
                },
                "S3BackupMode": {
                    "type": "string"
                },
                "S3Configuration": {
                    "$ref": "#/definitions/AWS::KinesisFirehose::DeliveryStream.S3DestinationConfiguration"
                },
                "TypeName": {
                    "type": "string"
                }
            },
            "required": [
                "BufferingHints",
                "DomainARN",
                "IndexName",
                "IndexRotationPeriod",
                "RetryOptions",
                "RoleARN",
                "S3BackupMode",
                "S3Configuration",
                "TypeName"
            ],
            "type": "object"
        },
        "AWS::KinesisFirehose::DeliveryStream.ElasticsearchRetryOptions": {
            "additionalProperties": false,
            "properties": {
                "DurationInSeconds": {
                    "type": "number"
                }
            },
            "required": [
                "DurationInSeconds"
            ],
            "type": "object"
        },
        "AWS::KinesisFirehose::DeliveryStream.EncryptionConfiguration": {
            "additionalProperties": false,
            "properties": {
                "KMSEncryptionConfig": {
                    "$ref": "#/definitions/AWS::KinesisFirehose::DeliveryStream.KMSEncryptionConfig"
                },
                "NoEncryptionConfig": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::KinesisFirehose::DeliveryStream.ExtendedS3DestinationConfiguration": {
            "additionalProperties": false,
            "properties": {
                "BucketARN": {
                    "type": "string"
                },
                "BufferingHints": {
                    "$ref": "#/definitions/AWS::KinesisFirehose::DeliveryStream.BufferingHints"
                },
                "CloudWatchLoggingOptions": {
                    "$ref": "#/definitions/AWS::KinesisFirehose::DeliveryStream.CloudWatchLoggingOptions"
                },
                "CompressionFormat": {
                    "type": "string"
                },
                "EncryptionConfiguration": {
                    "$ref": "#/definitions/AWS::KinesisFirehose::DeliveryStream.EncryptionConfiguration"
                },
                "Prefix": {
                    "type": "string"
                },
                "ProcessingConfiguration": {
                    "$ref": "#/definitions/AWS::KinesisFirehose::DeliveryStream.ProcessingConfiguration"
                },
                "RoleARN": {
                    "type": "string"
                },
                "S3BackupConfiguration": {
                    "$ref": "#/definitions/AWS::KinesisFirehose::DeliveryStream.S3DestinationConfiguration"
                },
                "S3BackupMode": {
                    "type": "string"
                }
            },
            "required": [
                "BucketARN",
                "BufferingHints",
                "CompressionFormat",
                "Prefix",
                "RoleARN"
            ],
            "type": "object"
        },
        "AWS::KinesisFirehose::DeliveryStream.KMSEncryptionConfig": {
            "additionalProperties": false,
            "properties": {
                "AWSKMSKeyARN": {
                    "type": "string"
                }
            },
            "required": [
                "AWSKMSKeyARN"
            ],
            "type": "object"
        },
        "AWS::KinesisFirehose::DeliveryStream.KinesisStreamSourceConfiguration": {
            "additionalProperties": false,
            "properties": {
                "KinesisStreamARN": {
                    "type": "string"
                },
                "RoleARN": {
                    "type": "string"
                }
            },
            "required": [
                "KinesisStreamARN",
                "RoleARN"
            ],
            "type": "object"
        },
        "AWS::KinesisFirehose::DeliveryStream.ProcessingConfiguration": {
            "additionalProperties": false,
            "properties": {
                "Enabled": {
                    "type": "boolean"
                },
                "Processors": {
                    "items": {
                        "$ref": "#/definitions/AWS::KinesisFirehose::DeliveryStream.Processor"
                    },
                    "type": "array"
                }
            },
            "type": "object"
        },
        "AWS::KinesisFirehose::DeliveryStream.Processor": {
            "additionalProperties": false,
            "properties": {
                "Parameters": {
                    "items": {
                        "$ref": "#/definitions/AWS::KinesisFirehose::DeliveryStream.ProcessorParameter"
                    },
                    "type": "array"
                },
                "Type": {
                    "type": "string"
                }
            },
            "required": [
                "Parameters",
                "Type"
            ],
            "type": "object"
        },
        "AWS::KinesisFirehose::DeliveryStream.ProcessorParameter": {
            "additionalProperties": false,
            "properties": {
                "ParameterName": {
                    "type": "string"
                },
                "ParameterValue": {
                    "type": "string"
                }
            },
            "required": [
                "ParameterName",
                "ParameterValue"
            ],
            "type": "object"
        },
        "AWS::KinesisFirehose::DeliveryStream.RedshiftDestinationConfiguration": {
            "additionalProperties": false,
            "properties": {
                "CloudWatchLoggingOptions": {
                    "$ref": "#/definitions/AWS::KinesisFirehose::DeliveryStream.CloudWatchLoggingOptions"
                },
                "ClusterJDBCURL": {
                    "type": "string"
                },
                "CopyCommand": {
                    "$ref": "#/definitions/AWS::KinesisFirehose::DeliveryStream.CopyCommand"
                },
                "Password": {
                    "type": "string"
                },
                "ProcessingConfiguration": {
                    "$ref": "#/definitions/AWS::KinesisFirehose::DeliveryStream.ProcessingConfiguration"
                },
                "RoleARN": {
                    "type": "string"
                },
                "S3Configuration": {
                    "$ref": "#/definitions/AWS::KinesisFirehose::DeliveryStream.S3DestinationConfiguration"
                },
                "Username": {
                    "type": "string"
                }
            },
            "required": [
                "ClusterJDBCURL",
                "CopyCommand",
                "Password",
                "RoleARN",
                "S3Configuration",
                "Username"
            ],
            "type": "object"
        },
        "AWS::KinesisFirehose::DeliveryStream.S3DestinationConfiguration": {
            "additionalProperties": false,
            "properties": {
                "BucketARN": {
                    "type": "string"
                },
                "BufferingHints": {
                    "$ref": "#/definitions/AWS::KinesisFirehose::DeliveryStream.BufferingHints"
                },
                "CloudWatchLoggingOptions": {
                    "$ref": "#/definitions/AWS::KinesisFirehose::DeliveryStream.CloudWatchLoggingOptions"
                },
                "CompressionFormat": {
                    "type": "string"
                },
                "EncryptionConfiguration": {
                    "$ref": "#/definitions/AWS::KinesisFirehose::DeliveryStream.EncryptionConfiguration"
                },
                "Prefix": {
                    "type": "string"
                },
                "RoleARN": {
                    "type": "string"
                }
            },
            "required": [
                "BucketARN",
                "BufferingHints",
                "CompressionFormat",
                "RoleARN"
            ],
            "type": "object"
        },
        "AWS::KinesisFirehose::DeliveryStream.SplunkDestinationConfiguration": {
            "additionalProperties": false,
            "properties": {
                "CloudWatchLoggingOptions": {
                    "$ref": "#/definitions/AWS::KinesisFirehose::DeliveryStream.CloudWatchLoggingOptions"
                },
                "HECAcknowledgmentTimeoutInSeconds": {
                    "type": "number"
                },
                "HECEndpoint": {
                    "type": "string"
                },
                "HECEndpointType": {
                    "type": "string"
                },
                "HECToken": {
                    "type": "string"
                },
                "ProcessingConfiguration": {
                    "$ref": "#/definitions/AWS::KinesisFirehose::DeliveryStream.ProcessingConfiguration"
                },
                "RetryOptions": {
                    "$ref": "#/definitions/AWS::KinesisFirehose::DeliveryStream.SplunkRetryOptions"
                },
                "S3BackupMode": {
                    "type": "string"
                },
                "S3Configuration": {
                    "$ref": "#/definitions/AWS::KinesisFirehose::DeliveryStream.S3DestinationConfiguration"
                }
            },
            "required": [
                "HECEndpoint",
                "HECEndpointType",
                "HECToken",
                "S3Configuration"
            ],
            "type": "object"
        },
        "AWS::KinesisFirehose::DeliveryStream.SplunkRetryOptions": {
            "additionalProperties": false,
            "properties": {
                "DurationInSeconds": {
                    "type": "number"
                }
            },
            "required": [
                "DurationInSeconds"
            ],
            "type": "object"
        },
        "AWS::Lambda::Alias": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Description": {
                            "type": "string"
                        },
                        "FunctionName": {
                            "type": "string"
                        },
                        "FunctionVersion": {
                            "type": "string"
                        },
                        "Name": {
                            "type": "string"
                        },
                        "RoutingConfig": {
                            "$ref": "#/definitions/AWS::Lambda::Alias.AliasRoutingConfiguration"
                        }
                    },
                    "required": [
                        "FunctionName",
                        "FunctionVersion",
                        "Name"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::Lambda::Alias"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::Lambda::Alias.AliasRoutingConfiguration": {
            "additionalProperties": false,
            "properties": {
                "AdditionalVersionWeights": {
                    "items": {
                        "$ref": "#/definitions/AWS::Lambda::Alias.VersionWeight"
                    },
                    "type": "array"
                }
            },
            "required": [
                "AdditionalVersionWeights"
            ],
            "type": "object"
        },
        "AWS::Lambda::Alias.VersionWeight": {
            "additionalProperties": false,
            "properties": {
                "FunctionVersion": {
                    "type": "string"
                },
                "FunctionWeight": {
                    "type": "number"
                }
            },
            "required": [
                "FunctionVersion",
                "FunctionWeight"
            ],
            "type": "object"
        },
        "AWS::Lambda::EventSourceMapping": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "BatchSize": {
                            "type": "number"
                        },
                        "Enabled": {
                            "type": "boolean"
                        },
                        "EventSourceArn": {
                            "type": "string"
                        },
                        "FunctionName": {
                            "type": "string"
                        },
                        "StartingPosition": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "EventSourceArn",
                        "FunctionName"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::Lambda::EventSourceMapping"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::Lambda::Function": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Code": {
                            "$ref": "#/definitions/AWS::Lambda::Function.Code"
                        },
                        "DeadLetterConfig": {
                            "$ref": "#/definitions/AWS::Lambda::Function.DeadLetterConfig"
                        },
                        "Description": {
                            "type": "string"
                        },
                        "Environment": {
                            "$ref": "#/definitions/AWS::Lambda::Function.Environment"
                        },
                        "FunctionName": {
                            "type": "string"
                        },
                        "Handler": {
                            "type": "string"
                        },
                        "KmsKeyArn": {
                            "type": "string"
                        },
                        "Layers": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "MemorySize": {
                            "type": "number"
                        },
                        "ReservedConcurrentExecutions": {
                            "type": "number"
                        },
                        "Role": {
                            "type": "string"
                        },
                        "Runtime": {
                            "type": "string"
                        },
                        "Tags": {
                            "items": {
                                "$ref": "#/definitions/Tag"
                            },
                            "type": "array"
                        },
                        "Timeout": {
                            "type": "number"
                        },
                        "TracingConfig": {
                            "$ref": "#/definitions/AWS::Lambda::Function.TracingConfig"
                        },
                        "VpcConfig": {
                            "$ref": "#/definitions/AWS::Lambda::Function.VpcConfig"
                        }
                    },
                    "required": [
                        "Code",
                        "Handler",
                        "Role",
                        "Runtime"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::Lambda::Function"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::Lambda::Function.Code": {
            "additionalProperties": false,
            "properties": {
                "S3Bucket": {
                    "type": "string"
                },
                "S3Key": {
                    "type": "string"
                },
                "S3ObjectVersion": {
                    "type": "string"
                },
                "ZipFile": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::Lambda::Function.DeadLetterConfig": {
            "additionalProperties": false,
            "properties": {
                "TargetArn": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::Lambda::Function.Environment": {
            "additionalProperties": false,
            "properties": {
                "Variables": {
                    "additionalProperties": true,
                    "patternProperties": {
                        "^[a-zA-Z0-9]+$": {
                            "type": "string"
                        }
                    },
                    "type": "object"
                }
            },
            "type": "object"
        },
        "AWS::Lambda::Function.TracingConfig": {
            "additionalProperties": false,
            "properties": {
                "Mode": {
                    "type": "string"
                }
            },
            "type": "object"
        },
        "AWS::Lambda::Function.VpcConfig": {
            "additionalProperties": false,
            "properties": {
                "SecurityGroupIds": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                },
                "SubnetIds": {
                    "items": {
                        "type": "string"
                    },
                    "type": "array"
                }
            },
            "required": [
                "SecurityGroupIds",
                "SubnetIds"
            ],
            "type": "object"
        },
        "AWS::Lambda::LayerVersion": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "CompatibleRuntimes": {
                            "items": {
                                "type": "string"
                            },
                            "type": "array"
                        },
                        "Content": {
                            "$ref": "#/definitions/AWS::Lambda::LayerVersion.Content"
                        },
                        "Description": {
                            "type": "string"
                        },
                        "LayerName": {
                            "type": "string"
                        },
                        "LicenseInfo": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "Content"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::Lambda::LayerVersion"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::Lambda::LayerVersion.Content": {
            "additionalProperties": false,
            "properties": {
                "S3Bucket": {
                    "type": "string"
                },
                "S3Key": {
                    "type": "string"
                },
                "S3ObjectVersion": {
                    "type": "string"
                }
            },
            "required": [
                "S3Bucket",
                "S3Key"
            ],
            "type": "object"
        },
        "AWS::Lambda::LayerVersionPermission": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Action": {
                            "type": "string"
                        },
                        "LayerVersionArn": {
                            "type": "string"
                        },
                        "OrganizationId": {
                            "type": "string"
                        },
                        "Principal": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "Action",
                        "LayerVersionArn",
                        "Principal"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::Lambda::LayerVersionPermission"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::Lambda::Permission": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "Action": {
                            "type": "string"
                        },
                        "EventSourceToken": {
                            "type": "string"
                        },
                        "FunctionName": {
                            "type": "string"
                        },
                        "Principal": {
                            "type": "string"
                        },
                        "SourceAccount": {
                            "type": "string"
                        },
                        "SourceArn": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "Action",
                        "FunctionName",
                        "Principal"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::Lambda::Permission"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::Lambda::Version": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "CodeSha256": {
                            "type": "string"
                        },
                        "Description": {
                            "type": "string"
                        },
                        "FunctionName": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "FunctionName"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::Lambda::Version"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::Logs::Destination": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "DestinationName": {
                            "type": "string"
                        },
                        "DestinationPolicy": {
                            "type": "string"
                        },
                        "RoleArn": {
                            "type": "string"
                        },
                        "TargetArn": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "DestinationName",
                        "DestinationPolicy",
                        "RoleArn",
                        "TargetArn"
                    ],
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::Logs::Destination"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type",
                "Properties"
            ],
            "type": "object"
        },
        "AWS::Logs::LogGroup": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
                        "Snapshot"
                    ],
                    "type": "string"
                },
                "DependsOn": {
                    "anyOf": [
                        {
                            "pattern": "^[a-zA-Z0-9]+$",
                            "type": "string"
                        },
                        {
                            "items": {
                                "pattern": "^[a-zA-Z0-9]+$",
                                "type": "string"
                            },
                            "type": "array"
                        }
                    ]
                },
                "Metadata": {
                    "type": "object"
                },
                "Properties": {
                    "additionalProperties": false,
                    "properties": {
                        "LogGroupName": {
                            "type": "string"
                        },
                        "RetentionInDays": {
                            "type": "number"
                        }
                    },
                    "type": "object"
                },
                "Type": {
                    "enum": [
                        "AWS::Logs::LogGroup"
                    ],
                    "type": "string"
                }
            },
            "required": [
                "Type"
            ],
            "type": "object"
        },
        "AWS::Logs::LogStream": {
            "additionalProperties": false,
            "properties": {
                "DeletionPolicy": {
                    "enum": [
                        "Delete",
                        "Retain",
     