// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package computeoptimizer

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type GetEC2InstanceRecommendationsInput struct {
	_ struct{} `type:"structure"`

	// The AWS account IDs for which to return instance recommendations.
	//
	// Only one account ID can be specified per request.
	AccountIds []string `locationName:"accountIds" type:"list"`

	// An array of objects that describe a filter that returns a more specific list
	// of instance recommendations.
	Filters []Filter `locationName:"filters" type:"list"`

	// The Amazon Resource Name (ARN) of the instances for which to return recommendations.
	InstanceArns []string `locationName:"instanceArns" type:"list"`

	// The maximum number of instance recommendations to return with a single call.
	//
	// To retrieve the remaining results, make another call with the returned NextToken
	// value.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// The token to advance to the next page of instance recommendations.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s GetEC2InstanceRecommendationsInput) String() string {
	return awsutil.Prettify(s)
}

type GetEC2InstanceRecommendationsOutput struct {
	_ struct{} `type:"structure"`

	// An array of objects that describe errors of the request.
	//
	// For example, an error is returned if you request recommendations for an instance
	// of an unsupported instance family.
	Errors []GetRecommendationError `locationName:"errors" type:"list"`

	// An array of objects that describe instance recommendations.
	InstanceRecommendations []InstanceRecommendation `locationName:"instanceRecommendations" type:"list"`

	// The token to use to advance to the next page of instance recommendations.
	//
	// This value is null when there are no more pages of instance recommendations
	// to return.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s GetEC2InstanceRecommendationsOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetEC2InstanceRecommendations = "GetEC2InstanceRecommendations"

// GetEC2InstanceRecommendationsRequest returns a request value for making API operation for
// AWS Compute Optimizer.
//
// Returns Amazon EC2 instance recommendations.
//
// AWS Compute Optimizer currently generates recommendations for Amazon Elastic
// Compute Cloud (Amazon EC2) and Amazon EC2 Auto Scaling. It generates recommendations
// for M, C, R, T, and X instance families. For more information, see the AWS
// Compute Optimizer User Guide (https://docs.aws.amazon.com/compute-optimizer/latest/ug/what-is.html).
//
//    // Example sending a request using GetEC2InstanceRecommendationsRequest.
//    req := client.GetEC2InstanceRecommendationsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/compute-optimizer-2019-11-01/GetEC2InstanceRecommendations
func (c *Client) GetEC2InstanceRecommendationsRequest(input *GetEC2InstanceRecommendationsInput) GetEC2InstanceRecommendationsRequest {
	op := &aws.Operation{
		Name:       opGetEC2InstanceRecommendations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetEC2InstanceRecommendationsInput{}
	}

	req := c.newRequest(op, input, &GetEC2InstanceRecommendationsOutput{})
	return GetEC2InstanceRecommendationsRequest{Request: req, Input: input, Copy: c.GetEC2InstanceRecommendationsRequest}
}

// GetEC2InstanceRecommendationsRequest is the request type for the
// GetEC2InstanceRecommendations API operation.
type GetEC2InstanceRecommendationsRequest struct {
	*aws.Request
	Input *GetEC2InstanceRecommendationsInput
	Copy  func(*GetEC2InstanceRecommendationsInput) GetEC2InstanceRecommendationsRequest
}

// Send marshals and sends the GetEC2InstanceRecommendations API request.
func (r GetEC2InstanceRecommendationsRequest) Send(ctx context.Context) (*GetEC2InstanceRecommendationsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetEC2InstanceRecommendationsResponse{
		GetEC2InstanceRecommendationsOutput: r.Request.Data.(*GetEC2InstanceRecommendationsOutput),
		response:                            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetEC2InstanceRecommendationsResponse is the response type for the
// GetEC2InstanceRecommendations API operation.
type GetEC2InstanceRecommendationsResponse struct {
	*GetEC2InstanceRecommendationsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetEC2InstanceRecommendations request.
func (r *GetEC2InstanceRecommendationsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
