// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ec2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/ec2query"
)

type CancelExportTaskInput struct {
	_ struct{} `type:"structure"`

	// The ID of the export task. This is the ID returned by CreateInstanceExportTask.
	//
	// ExportTaskId is a required field
	ExportTaskId *string `locationName:"exportTaskId" type:"string" required:"true"`
}

// String returns the string representation
func (s CancelExportTaskInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CancelExportTaskInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CancelExportTaskInput"}

	if s.ExportTaskId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ExportTaskId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type CancelExportTaskOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CancelExportTaskOutput) String() string {
	return awsutil.Prettify(s)
}

const opCancelExportTask = "CancelExportTask"

// CancelExportTaskRequest returns a request value for making API operation for
// Amazon Elastic Compute Cloud.
//
// Cancels an active export task. The request removes all artifacts of the export,
// including any partially-created Amazon S3 objects. If the export task is
// complete or is in the process of transferring the final disk image, the command
// fails and returns an error.
//
//    // Example sending a request using CancelExportTaskRequest.
//    req := client.CancelExportTaskRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelExportTask
func (c *Client) CancelExportTaskRequest(input *CancelExportTaskInput) CancelExportTaskRequest {
	op := &aws.Operation{
		Name:       opCancelExportTask,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CancelExportTaskInput{}
	}

	req := c.newRequest(op, input, &CancelExportTaskOutput{})
	req.Handlers.Unmarshal.Remove(ec2query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return CancelExportTaskRequest{Request: req, Input: input, Copy: c.CancelExportTaskRequest}
}

// CancelExportTaskRequest is the request type for the
// CancelExportTask API operation.
type CancelExportTaskRequest struct {
	*aws.Request
	Input *CancelExportTaskInput
	Copy  func(*CancelExportTaskInput) CancelExportTaskRequest
}

// Send marshals and sends the CancelExportTask API request.
func (r CancelExportTaskRequest) Send(ctx context.Context) (*CancelExportTaskResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CancelExportTaskResponse{
		CancelExportTaskOutput: r.Request.Data.(*CancelExportTaskOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CancelExportTaskResponse is the response type for the
// CancelExportTask API operation.
type CancelExportTaskResponse struct {
	*CancelExportTaskOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CancelExportTask request.
func (r *CancelExportTaskResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
