// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package kinesisanalyticsv2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DiscoverInputSchemaInput struct {
	_ struct{} `type:"structure"`

	// The InputProcessingConfiguration to use to preprocess the records before
	// discovering the schema of the records.
	InputProcessingConfiguration *InputProcessingConfiguration `type:"structure"`

	// The point at which you want Kinesis Data Analytics to start reading records
	// from the specified streaming source discovery purposes.
	InputStartingPositionConfiguration *InputStartingPositionConfiguration `type:"structure"`

	// The Amazon Resource Name (ARN) of the streaming source.
	ResourceARN *string `min:"1" type:"string"`

	// Specify this parameter to discover a schema from data in an Amazon S3 object.
	S3Configuration *S3Configuration `type:"structure"`

	// The ARN of the role that is used to access the streaming source.
	//
	// ServiceExecutionRole is a required field
	ServiceExecutionRole *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DiscoverInputSchemaInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DiscoverInputSchemaInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DiscoverInputSchemaInput"}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ResourceARN", 1))
	}

	if s.ServiceExecutionRole == nil {
		invalidParams.Add(aws.NewErrParamRequired("ServiceExecutionRole"))
	}
	if s.ServiceExecutionRole != nil && len(*s.ServiceExecutionRole) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ServiceExecutionRole", 1))
	}
	if s.InputProcessingConfiguration != nil {
		if err := s.InputProcessingConfiguration.Validate(); err != nil {
			invalidParams.AddNested("InputProcessingConfiguration", err.(aws.ErrInvalidParams))
		}
	}
	if s.S3Configuration != nil {
		if err := s.S3Configuration.Validate(); err != nil {
			invalidParams.AddNested("S3Configuration", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DiscoverInputSchemaOutput struct {
	_ struct{} `type:"structure"`

	// The schema inferred from the streaming source. It identifies the format of
	// the data in the streaming source and how each data element maps to corresponding
	// columns in the in-application stream that you can create.
	InputSchema *SourceSchema `type:"structure"`

	// An array of elements, where each element corresponds to a row in a stream
	// record (a stream record can have more than one row).
	ParsedInputRecords [][]string `type:"list"`

	// The stream data that was modified by the processor specified in the InputProcessingConfiguration
	// parameter.
	ProcessedInputRecords []string `type:"list"`

	// The raw stream data that was sampled to infer the schema.
	RawInputRecords []string `type:"list"`
}

// String returns the string representation
func (s DiscoverInputSchemaOutput) String() string {
	return awsutil.Prettify(s)
}

const opDiscoverInputSchema = "DiscoverInputSchema"

// DiscoverInputSchemaRequest returns a request value for making API operation for
// Amazon Kinesis Analytics.
//
// Infers a schema for an SQL-based Amazon Kinesis Data Analytics application
// by evaluating sample records on the specified streaming source (Kinesis data
// stream or Kinesis Data Firehose delivery stream) or Amazon S3 object. In
// the response, the operation returns the inferred schema and also the sample
// records that the operation used to infer the schema.
//
// You can use the inferred schema when configuring a streaming source for your
// application. When you create an application using the Kinesis Data Analytics
// console, the console uses this operation to infer a schema and show it in
// the console user interface.
//
//    // Example sending a request using DiscoverInputSchemaRequest.
//    req := client.DiscoverInputSchemaRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/DiscoverInputSchema
func (c *Client) DiscoverInputSchemaRequest(input *DiscoverInputSchemaInput) DiscoverInputSchemaRequest {
	op := &aws.Operation{
		Name:       opDiscoverInputSchema,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DiscoverInputSchemaInput{}
	}

	req := c.newRequest(op, input, &DiscoverInputSchemaOutput{})
	return DiscoverInputSchemaRequest{Request: req, Input: input, Copy: c.DiscoverInputSchemaRequest}
}

// DiscoverInputSchemaRequest is the request type for the
// DiscoverInputSchema API operation.
type DiscoverInputSchemaRequest struct {
	*aws.Request
	Input *DiscoverInputSchemaInput
	Copy  func(*DiscoverInputSchemaInput) DiscoverInputSchemaRequest
}

// Send marshals and sends the DiscoverInputSchema API request.
func (r DiscoverInputSchemaRequest) Send(ctx context.Context) (*DiscoverInputSchemaResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DiscoverInputSchemaResponse{
		DiscoverInputSchemaOutput: r.Request.Data.(*DiscoverInputSchemaOutput),
		response:                  &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DiscoverInputSchemaResponse is the response type for the
// DiscoverInputSchema API operation.
type DiscoverInputSchemaResponse struct {
	*DiscoverInputSchemaOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DiscoverInputSchema request.
func (r *DiscoverInputSchemaResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
