// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package servicecatalog

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ProvisionProductInput struct {
	_ struct{} `type:"structure"`

	// The language code.
	//
	//    * en - English (default)
	//
	//    * jp - Japanese
	//
	//    * zh - Chinese
	AcceptLanguage *string `type:"string"`

	// Passed to CloudFormation. The SNS topic ARNs to which to publish stack-related
	// events.
	NotificationArns []string `type:"list"`

	// The path identifier of the product. This value is optional if the product
	// has a default path, and required if the product has more than one path. To
	// list the paths for a product, use ListLaunchPaths.
	PathId *string `min:"1" type:"string"`

	// The product identifier.
	//
	// ProductId is a required field
	ProductId *string `min:"1" type:"string" required:"true"`

	// An idempotency token that uniquely identifies the provisioning request.
	//
	// ProvisionToken is a required field
	ProvisionToken *string `min:"1" type:"string" required:"true" idempotencyToken:"true"`

	// A user-friendly name for the provisioned product. This value must be unique
	// for the AWS account and cannot be updated after the product is provisioned.
	//
	// ProvisionedProductName is a required field
	ProvisionedProductName *string `min:"1" type:"string" required:"true"`

	// The identifier of the provisioning artifact.
	//
	// ProvisioningArtifactId is a required field
	ProvisioningArtifactId *string `min:"1" type:"string" required:"true"`

	// Parameters specified by the administrator that are required for provisioning
	// the product.
	ProvisioningParameters []ProvisioningParameter `type:"list"`

	// An object that contains information about the provisioning preferences for
	// a stack set.
	ProvisioningPreferences *ProvisioningPreferences `type:"structure"`

	// One or more tags.
	Tags []Tag `type:"list"`
}

// String returns the string representation
func (s ProvisionProductInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ProvisionProductInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ProvisionProductInput"}
	if s.PathId != nil && len(*s.PathId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("PathId", 1))
	}

	if s.ProductId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ProductId"))
	}
	if s.ProductId != nil && len(*s.ProductId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ProductId", 1))
	}

	if s.ProvisionToken == nil {
		invalidParams.Add(aws.NewErrParamRequired("ProvisionToken"))
	}
	if s.ProvisionToken != nil && len(*s.ProvisionToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ProvisionToken", 1))
	}

	if s.ProvisionedProductName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ProvisionedProductName"))
	}
	if s.ProvisionedProductName != nil && len(*s.ProvisionedProductName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ProvisionedProductName", 1))
	}

	if s.ProvisioningArtifactId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ProvisioningArtifactId"))
	}
	if s.ProvisioningArtifactId != nil && len(*s.ProvisioningArtifactId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ProvisioningArtifactId", 1))
	}
	if s.ProvisioningParameters != nil {
		for i, v := range s.ProvisioningParameters {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ProvisioningParameters", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.ProvisioningPreferences != nil {
		if err := s.ProvisioningPreferences.Validate(); err != nil {
			invalidParams.AddNested("ProvisioningPreferences", err.(aws.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ProvisionProductOutput struct {
	_ struct{} `type:"structure"`

	// Information about the result of provisioning the product.
	RecordDetail *RecordDetail `type:"structure"`
}

// String returns the string representation
func (s ProvisionProductOutput) String() string {
	return awsutil.Prettify(s)
}

const opProvisionProduct = "ProvisionProduct"

// ProvisionProductRequest returns a request value for making API operation for
// AWS Service Catalog.
//
// Provisions the specified product.
//
// A provisioned product is a resourced instance of a product. For example,
// provisioning a product based on a CloudFormation template launches a CloudFormation
// stack and its underlying resources. You can check the status of this request
// using DescribeRecord.
//
// If the request contains a tag key with an empty list of values, there is
// a tag conflict for that key. Do not include conflicted keys as tags, or this
// causes the error "Parameter validation failed: Missing required parameter
// in Tags[N]:Value".
//
//    // Example sending a request using ProvisionProductRequest.
//    req := client.ProvisionProductRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ProvisionProduct
func (c *Client) ProvisionProductRequest(input *ProvisionProductInput) ProvisionProductRequest {
	op := &aws.Operation{
		Name:       opProvisionProduct,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ProvisionProductInput{}
	}

	req := c.newRequest(op, input, &ProvisionProductOutput{})
	return ProvisionProductRequest{Request: req, Input: input, Copy: c.ProvisionProductRequest}
}

// ProvisionProductRequest is the request type for the
// ProvisionProduct API operation.
type ProvisionProductRequest struct {
	*aws.Request
	Input *ProvisionProductInput
	Copy  func(*ProvisionProductInput) ProvisionProductRequest
}

// Send marshals and sends the ProvisionProduct API request.
func (r ProvisionProductRequest) Send(ctx context.Context) (*ProvisionProductResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ProvisionProductResponse{
		ProvisionProductOutput: r.Request.Data.(*ProvisionProductOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ProvisionProductResponse is the response type for the
// ProvisionProduct API operation.
type ProvisionProductResponse struct {
	*ProvisionProductOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ProvisionProduct request.
func (r *ProvisionProductResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
