package aegis

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeScreenSecurityStatInfo invokes the aegis.DescribeScreenSecurityStatInfo API synchronously
// api document: https://help.aliyun.com/api/aegis/describescreensecuritystatinfo.html
func (client *Client) DescribeScreenSecurityStatInfo(request *DescribeScreenSecurityStatInfoRequest) (response *DescribeScreenSecurityStatInfoResponse, err error) {
	response = CreateDescribeScreenSecurityStatInfoResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeScreenSecurityStatInfoWithChan invokes the aegis.DescribeScreenSecurityStatInfo API asynchronously
// api document: https://help.aliyun.com/api/aegis/describescreensecuritystatinfo.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeScreenSecurityStatInfoWithChan(request *DescribeScreenSecurityStatInfoRequest) (<-chan *DescribeScreenSecurityStatInfoResponse, <-chan error) {
	responseChan := make(chan *DescribeScreenSecurityStatInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeScreenSecurityStatInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeScreenSecurityStatInfoWithCallback invokes the aegis.DescribeScreenSecurityStatInfo API asynchronously
// api document: https://help.aliyun.com/api/aegis/describescreensecuritystatinfo.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeScreenSecurityStatInfoWithCallback(request *DescribeScreenSecurityStatInfoRequest, callback func(response *DescribeScreenSecurityStatInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeScreenSecurityStatInfoResponse
		var err error
		defer close(result)
		response, err = client.DescribeScreenSecurityStatInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeScreenSecurityStatInfoRequest is the request struct for api DescribeScreenSecurityStatInfo
type DescribeScreenSecurityStatInfoRequest struct {
	*requests.RpcRequest
	SourceIp string `position:"Query" name:"SourceIp"`
	Lang     string `position:"Query" name:"Lang"`
}

// DescribeScreenSecurityStatInfoResponse is the response struct for api DescribeScreenSecurityStatInfo
type DescribeScreenSecurityStatInfoResponse struct {
	*responses.BaseResponse
	RequestId     string        `json:"RequestId" xml:"RequestId"`
	Success       bool          `json:"Success" xml:"Success"`
	SecurityEvent SecurityEvent `json:"SecurityEvent" xml:"SecurityEvent"`
	AttackEvent   AttackEvent   `json:"AttackEvent" xml:"AttackEvent"`
	HealthCheck   HealthCheck   `json:"HealthCheck" xml:"HealthCheck"`
	Vulnerability Vulnerability `json:"Vulnerability" xml:"Vulnerability"`
}

// CreateDescribeScreenSecurityStatInfoRequest creates a request to invoke DescribeScreenSecurityStatInfo API
func CreateDescribeScreenSecurityStatInfoRequest() (request *DescribeScreenSecurityStatInfoRequest) {
	request = &DescribeScreenSecurityStatInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("aegis", "2016-11-11", "DescribeScreenSecurityStatInfo", "vipaegis", "openAPI")
	return
}

// CreateDescribeScreenSecurityStatInfoResponse creates a response to parse from DescribeScreenSecurityStatInfo response
func CreateDescribeScreenSecurityStatInfoResponse() (response *DescribeScreenSecurityStatInfoResponse) {
	response = &DescribeScreenSecurityStatInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
