package baas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeOssProperties invokes the baas.DescribeOssProperties API synchronously
// api document: https://help.aliyun.com/api/baas/describeossproperties.html
func (client *Client) DescribeOssProperties(request *DescribeOssPropertiesRequest) (response *DescribeOssPropertiesResponse, err error) {
	response = CreateDescribeOssPropertiesResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeOssPropertiesWithChan invokes the baas.DescribeOssProperties API asynchronously
// api document: https://help.aliyun.com/api/baas/describeossproperties.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeOssPropertiesWithChan(request *DescribeOssPropertiesRequest) (<-chan *DescribeOssPropertiesResponse, <-chan error) {
	responseChan := make(chan *DescribeOssPropertiesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeOssProperties(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeOssPropertiesWithCallback invokes the baas.DescribeOssProperties API asynchronously
// api document: https://help.aliyun.com/api/baas/describeossproperties.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeOssPropertiesWithCallback(request *DescribeOssPropertiesRequest, callback func(response *DescribeOssPropertiesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeOssPropertiesResponse
		var err error
		defer close(result)
		response, err = client.DescribeOssProperties(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeOssPropertiesRequest is the request struct for api DescribeOssProperties
type DescribeOssPropertiesRequest struct {
	*requests.RpcRequest
	Bizid string `position:"Body" name:"Bizid"`
}

// DescribeOssPropertiesResponse is the response struct for api DescribeOssProperties
type DescribeOssPropertiesResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Result    Result `json:"Result" xml:"Result"`
}

// CreateDescribeOssPropertiesRequest creates a request to invoke DescribeOssProperties API
func CreateDescribeOssPropertiesRequest() (request *DescribeOssPropertiesRequest) {
	request = &DescribeOssPropertiesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Baas", "2018-07-31", "DescribeOssProperties", "", "")
	return
}

// CreateDescribeOssPropertiesResponse creates a response to parse from DescribeOssProperties response
func CreateDescribeOssPropertiesResponse() (response *DescribeOssPropertiesResponse) {
	response = &DescribeOssPropertiesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
