package cloudapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteIpControl invokes the cloudapi.DeleteIpControl API synchronously
// api document: https://help.aliyun.com/api/cloudapi/deleteipcontrol.html
func (client *Client) DeleteIpControl(request *DeleteIpControlRequest) (response *DeleteIpControlResponse, err error) {
	response = CreateDeleteIpControlResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteIpControlWithChan invokes the cloudapi.DeleteIpControl API asynchronously
// api document: https://help.aliyun.com/api/cloudapi/deleteipcontrol.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteIpControlWithChan(request *DeleteIpControlRequest) (<-chan *DeleteIpControlResponse, <-chan error) {
	responseChan := make(chan *DeleteIpControlResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteIpControl(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteIpControlWithCallback invokes the cloudapi.DeleteIpControl API asynchronously
// api document: https://help.aliyun.com/api/cloudapi/deleteipcontrol.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteIpControlWithCallback(request *DeleteIpControlRequest, callback func(response *DeleteIpControlResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteIpControlResponse
		var err error
		defer close(result)
		response, err = client.DeleteIpControl(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteIpControlRequest is the request struct for api DeleteIpControl
type DeleteIpControlRequest struct {
	*requests.RpcRequest
	IpControlId   string `position:"Query" name:"IpControlId"`
	SecurityToken string `position:"Query" name:"SecurityToken"`
}

// DeleteIpControlResponse is the response struct for api DeleteIpControl
type DeleteIpControlResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteIpControlRequest creates a request to invoke DeleteIpControl API
func CreateDeleteIpControlRequest() (request *DeleteIpControlRequest) {
	request = &DeleteIpControlRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudAPI", "2016-07-14", "DeleteIpControl", "apigateway", "openAPI")
	return
}

// CreateDeleteIpControlResponse creates a response to parse from DeleteIpControl response
func CreateDeleteIpControlResponse() (response *DeleteIpControlResponse) {
	response = &DeleteIpControlResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
