package cloudapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RemoveVpcAccess invokes the cloudapi.RemoveVpcAccess API synchronously
// api document: https://help.aliyun.com/api/cloudapi/removevpcaccess.html
func (client *Client) RemoveVpcAccess(request *RemoveVpcAccessRequest) (response *RemoveVpcAccessResponse, err error) {
	response = CreateRemoveVpcAccessResponse()
	err = client.DoAction(request, response)
	return
}

// RemoveVpcAccessWithChan invokes the cloudapi.RemoveVpcAccess API asynchronously
// api document: https://help.aliyun.com/api/cloudapi/removevpcaccess.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) RemoveVpcAccessWithChan(request *RemoveVpcAccessRequest) (<-chan *RemoveVpcAccessResponse, <-chan error) {
	responseChan := make(chan *RemoveVpcAccessResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RemoveVpcAccess(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RemoveVpcAccessWithCallback invokes the cloudapi.RemoveVpcAccess API asynchronously
// api document: https://help.aliyun.com/api/cloudapi/removevpcaccess.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) RemoveVpcAccessWithCallback(request *RemoveVpcAccessRequest, callback func(response *RemoveVpcAccessResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RemoveVpcAccessResponse
		var err error
		defer close(result)
		response, err = client.RemoveVpcAccess(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RemoveVpcAccessRequest is the request struct for api RemoveVpcAccess
type RemoveVpcAccessRequest struct {
	*requests.RpcRequest
	InstanceId    string           `position:"Query" name:"InstanceId"`
	SecurityToken string           `position:"Query" name:"SecurityToken"`
	Port          requests.Integer `position:"Query" name:"Port"`
	VpcId         string           `position:"Query" name:"VpcId"`
}

// RemoveVpcAccessResponse is the response struct for api RemoveVpcAccess
type RemoveVpcAccessResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateRemoveVpcAccessRequest creates a request to invoke RemoveVpcAccess API
func CreateRemoveVpcAccessRequest() (request *RemoveVpcAccessRequest) {
	request = &RemoveVpcAccessRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudAPI", "2016-07-14", "RemoveVpcAccess", "apigateway", "openAPI")
	return
}

// CreateRemoveVpcAccessResponse creates a response to parse from RemoveVpcAccess response
func CreateRemoveVpcAccessResponse() (response *RemoveVpcAccessResponse) {
	response = &RemoveVpcAccessResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
