package cloudwf

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryRenewPrice invokes the cloudwf.QueryRenewPrice API synchronously
// api document: https://help.aliyun.com/api/cloudwf/queryrenewprice.html
func (client *Client) QueryRenewPrice(request *QueryRenewPriceRequest) (response *QueryRenewPriceResponse, err error) {
	response = CreateQueryRenewPriceResponse()
	err = client.DoAction(request, response)
	return
}

// QueryRenewPriceWithChan invokes the cloudwf.QueryRenewPrice API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/queryrenewprice.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) QueryRenewPriceWithChan(request *QueryRenewPriceRequest) (<-chan *QueryRenewPriceResponse, <-chan error) {
	responseChan := make(chan *QueryRenewPriceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryRenewPrice(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryRenewPriceWithCallback invokes the cloudwf.QueryRenewPrice API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/queryrenewprice.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) QueryRenewPriceWithCallback(request *QueryRenewPriceRequest, callback func(response *QueryRenewPriceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryRenewPriceResponse
		var err error
		defer close(result)
		response, err = client.QueryRenewPrice(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryRenewPriceRequest is the request struct for api QueryRenewPrice
type QueryRenewPriceRequest struct {
	*requests.RpcRequest
	TimeCycleNum requests.Integer `position:"Query" name:"TimeCycleNum"`
	ApList       *[]string        `position:"Query" name:"ApList"  type:"Repeated"`
}

// QueryRenewPriceResponse is the response struct for api QueryRenewPrice
type QueryRenewPriceResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"success" xml:"success"`
	Message   string `json:"message" xml:"message"`
	Code      string `json:"code" xml:"code"`
	Data      string `json:"data" xml:"data"`
}

// CreateQueryRenewPriceRequest creates a request to invoke QueryRenewPrice API
func CreateQueryRenewPriceRequest() (request *QueryRenewPriceRequest) {
	request = &QueryRenewPriceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudwf", "2017-03-28", "QueryRenewPrice", "cloudwf", "openAPI")
	return
}

// CreateQueryRenewPriceResponse creates a response to parse from QueryRenewPrice response
func CreateQueryRenewPriceResponse() (response *QueryRenewPriceResponse) {
	response = &QueryRenewPriceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
