package cms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeMetricTop invokes the cms.DescribeMetricTop API synchronously
// api document: https://help.aliyun.com/api/cms/describemetrictop.html
func (client *Client) DescribeMetricTop(request *DescribeMetricTopRequest) (response *DescribeMetricTopResponse, err error) {
	response = CreateDescribeMetricTopResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeMetricTopWithChan invokes the cms.DescribeMetricTop API asynchronously
// api document: https://help.aliyun.com/api/cms/describemetrictop.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeMetricTopWithChan(request *DescribeMetricTopRequest) (<-chan *DescribeMetricTopResponse, <-chan error) {
	responseChan := make(chan *DescribeMetricTopResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeMetricTop(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeMetricTopWithCallback invokes the cms.DescribeMetricTop API asynchronously
// api document: https://help.aliyun.com/api/cms/describemetrictop.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeMetricTopWithCallback(request *DescribeMetricTopRequest, callback func(response *DescribeMetricTopResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeMetricTopResponse
		var err error
		defer close(result)
		response, err = client.DescribeMetricTop(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeMetricTopRequest is the request struct for api DescribeMetricTop
type DescribeMetricTopRequest struct {
	*requests.RpcRequest
	Period     string `position:"Query" name:"Period"`
	Namespace  string `position:"Query" name:"Namespace"`
	Length     string `position:"Query" name:"Length"`
	EndTime    string `position:"Query" name:"EndTime"`
	Orderby    string `position:"Query" name:"Orderby"`
	Express    string `position:"Query" name:"Express"`
	StartTime  string `position:"Query" name:"StartTime"`
	MetricName string `position:"Query" name:"MetricName"`
	Dimensions string `position:"Query" name:"Dimensions"`
	OrderDesc  string `position:"Query" name:"OrderDesc"`
}

// DescribeMetricTopResponse is the response struct for api DescribeMetricTop
type DescribeMetricTopResponse struct {
	*responses.BaseResponse
	Code       string `json:"Code" xml:"Code"`
	Message    string `json:"Message" xml:"Message"`
	RequestId  string `json:"RequestId" xml:"RequestId"`
	Datapoints string `json:"Datapoints" xml:"Datapoints"`
	Period     string `json:"Period" xml:"Period"`
}

// CreateDescribeMetricTopRequest creates a request to invoke DescribeMetricTop API
func CreateDescribeMetricTopRequest() (request *DescribeMetricTopRequest) {
	request = &DescribeMetricTopRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cms", "2019-01-01", "DescribeMetricTop", "cms", "openAPI")
	return
}

// CreateDescribeMetricTopResponse creates a response to parse from DescribeMetricTop response
func CreateDescribeMetricTopResponse() (response *DescribeMetricTopResponse) {
	response = &DescribeMetricTopResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
