package ecs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeFleetHistory invokes the ecs.DescribeFleetHistory API synchronously
// api document: https://help.aliyun.com/api/ecs/describefleethistory.html
func (client *Client) DescribeFleetHistory(request *DescribeFleetHistoryRequest) (response *DescribeFleetHistoryResponse, err error) {
	response = CreateDescribeFleetHistoryResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeFleetHistoryWithChan invokes the ecs.DescribeFleetHistory API asynchronously
// api document: https://help.aliyun.com/api/ecs/describefleethistory.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeFleetHistoryWithChan(request *DescribeFleetHistoryRequest) (<-chan *DescribeFleetHistoryResponse, <-chan error) {
	responseChan := make(chan *DescribeFleetHistoryResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeFleetHistory(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeFleetHistoryWithCallback invokes the ecs.DescribeFleetHistory API asynchronously
// api document: https://help.aliyun.com/api/ecs/describefleethistory.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeFleetHistoryWithCallback(request *DescribeFleetHistoryRequest, callback func(response *DescribeFleetHistoryResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeFleetHistoryResponse
		var err error
		defer close(result)
		response, err = client.DescribeFleetHistory(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeFleetHistoryRequest is the request struct for api DescribeFleetHistory
type DescribeFleetHistoryRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	FleetId              string           `position:"Query" name:"FleetId"`
}

// DescribeFleetHistoryResponse is the response struct for api DescribeFleetHistory
type DescribeFleetHistoryResponse struct {
	*responses.BaseResponse
	RequestId     string        `json:"RequestId" xml:"RequestId"`
	TotalCount    int           `json:"TotalCount" xml:"TotalCount"`
	PageNumber    int           `json:"PageNumber" xml:"PageNumber"`
	PageSize      int           `json:"PageSize" xml:"PageSize"`
	FleetHistorys FleetHistorys `json:"FleetHistorys" xml:"FleetHistorys"`
}

// CreateDescribeFleetHistoryRequest creates a request to invoke DescribeFleetHistory API
func CreateDescribeFleetHistoryRequest() (request *DescribeFleetHistoryRequest) {
	request = &DescribeFleetHistoryRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ecs", "2014-05-26", "DescribeFleetHistory", "ecs", "openAPI")
	return
}

// CreateDescribeFleetHistoryResponse creates a response to parse from DescribeFleetHistory response
func CreateDescribeFleetHistoryResponse() (response *DescribeFleetHistoryResponse) {
	response = &DescribeFleetHistoryResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
