package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetOpsCommandDetail invokes the emr.GetOpsCommandDetail API synchronously
// api document: https://help.aliyun.com/api/emr/getopscommanddetail.html
func (client *Client) GetOpsCommandDetail(request *GetOpsCommandDetailRequest) (response *GetOpsCommandDetailResponse, err error) {
	response = CreateGetOpsCommandDetailResponse()
	err = client.DoAction(request, response)
	return
}

// GetOpsCommandDetailWithChan invokes the emr.GetOpsCommandDetail API asynchronously
// api document: https://help.aliyun.com/api/emr/getopscommanddetail.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetOpsCommandDetailWithChan(request *GetOpsCommandDetailRequest) (<-chan *GetOpsCommandDetailResponse, <-chan error) {
	responseChan := make(chan *GetOpsCommandDetailResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetOpsCommandDetail(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetOpsCommandDetailWithCallback invokes the emr.GetOpsCommandDetail API asynchronously
// api document: https://help.aliyun.com/api/emr/getopscommanddetail.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetOpsCommandDetailWithCallback(request *GetOpsCommandDetailRequest, callback func(response *GetOpsCommandDetailResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetOpsCommandDetailResponse
		var err error
		defer close(result)
		response, err = client.GetOpsCommandDetail(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetOpsCommandDetailRequest is the request struct for api GetOpsCommandDetail
type GetOpsCommandDetailRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	OpsCommandName  string           `position:"Query" name:"OpsCommandName"`
}

// GetOpsCommandDetailResponse is the response struct for api GetOpsCommandDetail
type GetOpsCommandDetailResponse struct {
	*responses.BaseResponse
	RequestId   string `json:"RequestId" xml:"RequestId"`
	Id          int    `json:"Id" xml:"Id"`
	Name        string `json:"Name" xml:"Name"`
	Description string `json:"Description" xml:"Description"`
	TargetType  string `json:"TargetType" xml:"TargetType"`
	ServiceName string `json:"ServiceName" xml:"ServiceName"`
	Category    string `json:"Category" xml:"Category"`
	Params      string `json:"Params" xml:"Params"`
}

// CreateGetOpsCommandDetailRequest creates a request to invoke GetOpsCommandDetail API
func CreateGetOpsCommandDetailRequest() (request *GetOpsCommandDetailRequest) {
	request = &GetOpsCommandDetailRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "GetOpsCommandDetail", "emr", "openAPI")
	return
}

// CreateGetOpsCommandDetailResponse creates a response to parse from GetOpsCommandDetail response
func CreateGetOpsCommandDetailResponse() (response *GetOpsCommandDetailResponse) {
	response = &GetOpsCommandDetailResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
