package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListETLJobTriggerEntity invokes the emr.ListETLJobTriggerEntity API synchronously
// api document: https://help.aliyun.com/api/emr/listetljobtriggerentity.html
func (client *Client) ListETLJobTriggerEntity(request *ListETLJobTriggerEntityRequest) (response *ListETLJobTriggerEntityResponse, err error) {
	response = CreateListETLJobTriggerEntityResponse()
	err = client.DoAction(request, response)
	return
}

// ListETLJobTriggerEntityWithChan invokes the emr.ListETLJobTriggerEntity API asynchronously
// api document: https://help.aliyun.com/api/emr/listetljobtriggerentity.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListETLJobTriggerEntityWithChan(request *ListETLJobTriggerEntityRequest) (<-chan *ListETLJobTriggerEntityResponse, <-chan error) {
	responseChan := make(chan *ListETLJobTriggerEntityResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListETLJobTriggerEntity(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListETLJobTriggerEntityWithCallback invokes the emr.ListETLJobTriggerEntity API asynchronously
// api document: https://help.aliyun.com/api/emr/listetljobtriggerentity.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListETLJobTriggerEntityWithCallback(request *ListETLJobTriggerEntityRequest, callback func(response *ListETLJobTriggerEntityResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListETLJobTriggerEntityResponse
		var err error
		defer close(result)
		response, err = client.ListETLJobTriggerEntity(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListETLJobTriggerEntityRequest is the request struct for api ListETLJobTriggerEntity
type ListETLJobTriggerEntityRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	EntityType      string           `position:"Query" name:"EntityType"`
}

// ListETLJobTriggerEntityResponse is the response struct for api ListETLJobTriggerEntity
type ListETLJobTriggerEntityResponse struct {
	*responses.BaseResponse
	RequestId         string            `json:"RequestId" xml:"RequestId"`
	TriggerEntityList TriggerEntityList `json:"TriggerEntityList" xml:"TriggerEntityList"`
}

// CreateListETLJobTriggerEntityRequest creates a request to invoke ListETLJobTriggerEntity API
func CreateListETLJobTriggerEntityRequest() (request *ListETLJobTriggerEntityRequest) {
	request = &ListETLJobTriggerEntityRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "ListETLJobTriggerEntity", "emr", "openAPI")
	return
}

// CreateListETLJobTriggerEntityResponse creates a response to parse from ListETLJobTriggerEntity response
func CreateListETLJobTriggerEntityResponse() (response *ListETLJobTriggerEntityResponse) {
	response = &ListETLJobTriggerEntityResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
