package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RenderResourcePoolXml invokes the emr.RenderResourcePoolXml API synchronously
// api document: https://help.aliyun.com/api/emr/renderresourcepoolxml.html
func (client *Client) RenderResourcePoolXml(request *RenderResourcePoolXmlRequest) (response *RenderResourcePoolXmlResponse, err error) {
	response = CreateRenderResourcePoolXmlResponse()
	err = client.DoAction(request, response)
	return
}

// RenderResourcePoolXmlWithChan invokes the emr.RenderResourcePoolXml API asynchronously
// api document: https://help.aliyun.com/api/emr/renderresourcepoolxml.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) RenderResourcePoolXmlWithChan(request *RenderResourcePoolXmlRequest) (<-chan *RenderResourcePoolXmlResponse, <-chan error) {
	responseChan := make(chan *RenderResourcePoolXmlResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RenderResourcePoolXml(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RenderResourcePoolXmlWithCallback invokes the emr.RenderResourcePoolXml API asynchronously
// api document: https://help.aliyun.com/api/emr/renderresourcepoolxml.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) RenderResourcePoolXmlWithCallback(request *RenderResourcePoolXmlRequest, callback func(response *RenderResourcePoolXmlResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RenderResourcePoolXmlResponse
		var err error
		defer close(result)
		response, err = client.RenderResourcePoolXml(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RenderResourcePoolXmlRequest is the request struct for api RenderResourcePoolXml
type RenderResourcePoolXmlRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourcePoolId  string           `position:"Query" name:"ResourcePoolId"`
	ClusterId       string           `position:"Query" name:"ClusterId"`
}

// RenderResourcePoolXmlResponse is the response struct for api RenderResourcePoolXml
type RenderResourcePoolXmlResponse struct {
	*responses.BaseResponse
	RequestId  string `json:"RequestId" xml:"RequestId"`
	XmlContent string `json:"XmlContent" xml:"XmlContent"`
}

// CreateRenderResourcePoolXmlRequest creates a request to invoke RenderResourcePoolXml API
func CreateRenderResourcePoolXmlRequest() (request *RenderResourcePoolXmlRequest) {
	request = &RenderResourcePoolXmlRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "RenderResourcePoolXml", "emr", "openAPI")
	return
}

// CreateRenderResourcePoolXmlResponse creates a response to parse from RenderResourcePoolXml response
func CreateRenderResourcePoolXmlResponse() (response *RenderResourcePoolXmlResponse) {
	response = &RenderResourcePoolXmlResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
