package green

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UploadImageToLib invokes the green.UploadImageToLib API synchronously
// api document: https://help.aliyun.com/api/green/uploadimagetolib.html
func (client *Client) UploadImageToLib(request *UploadImageToLibRequest) (response *UploadImageToLibResponse, err error) {
	response = CreateUploadImageToLibResponse()
	err = client.DoAction(request, response)
	return
}

// UploadImageToLibWithChan invokes the green.UploadImageToLib API asynchronously
// api document: https://help.aliyun.com/api/green/uploadimagetolib.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UploadImageToLibWithChan(request *UploadImageToLibRequest) (<-chan *UploadImageToLibResponse, <-chan error) {
	responseChan := make(chan *UploadImageToLibResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UploadImageToLib(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UploadImageToLibWithCallback invokes the green.UploadImageToLib API asynchronously
// api document: https://help.aliyun.com/api/green/uploadimagetolib.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UploadImageToLibWithCallback(request *UploadImageToLibRequest, callback func(response *UploadImageToLibResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UploadImageToLibResponse
		var err error
		defer close(result)
		response, err = client.UploadImageToLib(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UploadImageToLibRequest is the request struct for api UploadImageToLib
type UploadImageToLibRequest struct {
	*requests.RpcRequest
	Images     string           `position:"Query" name:"Images"`
	SourceIp   string           `position:"Query" name:"SourceIp"`
	ImageLibId requests.Integer `position:"Query" name:"ImageLibId"`
}

// UploadImageToLibResponse is the response struct for api UploadImageToLib
type UploadImageToLibResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUploadImageToLibRequest creates a request to invoke UploadImageToLib API
func CreateUploadImageToLibRequest() (request *UploadImageToLibRequest) {
	request = &UploadImageToLibRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Green", "2017-08-23", "UploadImageToLib", "green", "openAPI")
	return
}

// CreateUploadImageToLibResponse creates a response to parse from UploadImageToLib response
func CreateUploadImageToLibResponse() (response *UploadImageToLibResponse) {
	response = &UploadImageToLibResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
