package imm

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CompareFace invokes the imm.CompareFace API synchronously
// api document: https://help.aliyun.com/api/imm/compareface.html
func (client *Client) CompareFace(request *CompareFaceRequest) (response *CompareFaceResponse, err error) {
	response = CreateCompareFaceResponse()
	err = client.DoAction(request, response)
	return
}

// CompareFaceWithChan invokes the imm.CompareFace API asynchronously
// api document: https://help.aliyun.com/api/imm/compareface.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CompareFaceWithChan(request *CompareFaceRequest) (<-chan *CompareFaceResponse, <-chan error) {
	responseChan := make(chan *CompareFaceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CompareFace(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CompareFaceWithCallback invokes the imm.CompareFace API asynchronously
// api document: https://help.aliyun.com/api/imm/compareface.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CompareFaceWithCallback(request *CompareFaceRequest, callback func(response *CompareFaceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CompareFaceResponse
		var err error
		defer close(result)
		response, err = client.CompareFace(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CompareFaceRequest is the request struct for api CompareFace
type CompareFaceRequest struct {
	*requests.RpcRequest
	SrcUriB string `position:"Query" name:"SrcUriB"`
	SrcUriA string `position:"Query" name:"SrcUriA"`
	Project string `position:"Query" name:"Project"`
}

// CompareFaceResponse is the response struct for api CompareFace
type CompareFaceResponse struct {
	*responses.BaseResponse
	RequestId     string              `json:"RequestId" xml:"RequestId"`
	CompareResult []CompareResultItem `json:"CompareResult" xml:"CompareResult"`
}

// CreateCompareFaceRequest creates a request to invoke CompareFace API
func CreateCompareFaceRequest() (request *CompareFaceRequest) {
	request = &CompareFaceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("imm", "2017-09-06", "CompareFace", "imm", "openAPI")
	return
}

// CreateCompareFaceResponse creates a response to parse from CompareFace response
func CreateCompareFaceResponse() (response *CompareFaceResponse) {
	response = &CompareFaceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
