package imm

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListPornBatchDetectJobs invokes the imm.ListPornBatchDetectJobs API synchronously
// api document: https://help.aliyun.com/api/imm/listpornbatchdetectjobs.html
func (client *Client) ListPornBatchDetectJobs(request *ListPornBatchDetectJobsRequest) (response *ListPornBatchDetectJobsResponse, err error) {
	response = CreateListPornBatchDetectJobsResponse()
	err = client.DoAction(request, response)
	return
}

// ListPornBatchDetectJobsWithChan invokes the imm.ListPornBatchDetectJobs API asynchronously
// api document: https://help.aliyun.com/api/imm/listpornbatchdetectjobs.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListPornBatchDetectJobsWithChan(request *ListPornBatchDetectJobsRequest) (<-chan *ListPornBatchDetectJobsResponse, <-chan error) {
	responseChan := make(chan *ListPornBatchDetectJobsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListPornBatchDetectJobs(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListPornBatchDetectJobsWithCallback invokes the imm.ListPornBatchDetectJobs API asynchronously
// api document: https://help.aliyun.com/api/imm/listpornbatchdetectjobs.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListPornBatchDetectJobsWithCallback(request *ListPornBatchDetectJobsRequest, callback func(response *ListPornBatchDetectJobsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListPornBatchDetectJobsResponse
		var err error
		defer close(result)
		response, err = client.ListPornBatchDetectJobs(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListPornBatchDetectJobsRequest is the request struct for api ListPornBatchDetectJobs
type ListPornBatchDetectJobsRequest struct {
	*requests.RpcRequest
	MaxKeys requests.Integer `position:"Query" name:"MaxKeys"`
	Marker  string           `position:"Query" name:"Marker"`
	Project string           `position:"Query" name:"Project"`
}

// ListPornBatchDetectJobsResponse is the response struct for api ListPornBatchDetectJobs
type ListPornBatchDetectJobsResponse struct {
	*responses.BaseResponse
	RequestId  string                              `json:"RequestId" xml:"RequestId"`
	NextMarker string                              `json:"NextMarker" xml:"NextMarker"`
	Jobs       []JobsItemInListPornBatchDetectJobs `json:"Jobs" xml:"Jobs"`
}

// CreateListPornBatchDetectJobsRequest creates a request to invoke ListPornBatchDetectJobs API
func CreateListPornBatchDetectJobsRequest() (request *ListPornBatchDetectJobsRequest) {
	request = &ListPornBatchDetectJobsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("imm", "2017-09-06", "ListPornBatchDetectJobs", "imm", "openAPI")
	return
}

// CreateListPornBatchDetectJobsResponse creates a response to parse from ListPornBatchDetectJobs response
func CreateListPornBatchDetectJobsResponse() (response *ListPornBatchDetectJobsResponse) {
	response = &ListPornBatchDetectJobsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
