package ivision

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateTrainDatasTag invokes the ivision.CreateTrainDatasTag API synchronously
// api document: https://help.aliyun.com/api/ivision/createtraindatastag.html
func (client *Client) CreateTrainDatasTag(request *CreateTrainDatasTagRequest) (response *CreateTrainDatasTagResponse, err error) {
	response = CreateCreateTrainDatasTagResponse()
	err = client.DoAction(request, response)
	return
}

// CreateTrainDatasTagWithChan invokes the ivision.CreateTrainDatasTag API asynchronously
// api document: https://help.aliyun.com/api/ivision/createtraindatastag.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateTrainDatasTagWithChan(request *CreateTrainDatasTagRequest) (<-chan *CreateTrainDatasTagResponse, <-chan error) {
	responseChan := make(chan *CreateTrainDatasTagResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateTrainDatasTag(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateTrainDatasTagWithCallback invokes the ivision.CreateTrainDatasTag API asynchronously
// api document: https://help.aliyun.com/api/ivision/createtraindatastag.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateTrainDatasTagWithCallback(request *CreateTrainDatasTagRequest, callback func(response *CreateTrainDatasTagResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateTrainDatasTagResponse
		var err error
		defer close(result)
		response, err = client.CreateTrainDatasTag(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateTrainDatasTagRequest is the request struct for api CreateTrainDatasTag
type CreateTrainDatasTagRequest struct {
	*requests.RpcRequest
	DataIds   string           `position:"Query" name:"DataIds"`
	ProjectId string           `position:"Query" name:"ProjectId"`
	ShowLog   string           `position:"Query" name:"ShowLog"`
	TagId     string           `position:"Query" name:"TagId"`
	OwnerId   requests.Integer `position:"Query" name:"OwnerId"`
}

// CreateTrainDatasTagResponse is the response struct for api CreateTrainDatasTag
type CreateTrainDatasTagResponse struct {
	*responses.BaseResponse
	RequestId string    `json:"RequestId" xml:"RequestId"`
	TrainData TrainData `json:"TrainData" xml:"TrainData"`
}

// CreateCreateTrainDatasTagRequest creates a request to invoke CreateTrainDatasTag API
func CreateCreateTrainDatasTagRequest() (request *CreateTrainDatasTagRequest) {
	request = &CreateTrainDatasTagRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ivision", "2019-03-08", "CreateTrainDatasTag", "ivision", "openAPI")
	return
}

// CreateCreateTrainDatasTagResponse creates a response to parse from CreateTrainDatasTag response
func CreateCreateTrainDatasTagResponse() (response *CreateTrainDatasTagResponse) {
	response = &CreateTrainDatasTagResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
