package ivision

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeTrainDatas invokes the ivision.DescribeTrainDatas API synchronously
// api document: https://help.aliyun.com/api/ivision/describetraindatas.html
func (client *Client) DescribeTrainDatas(request *DescribeTrainDatasRequest) (response *DescribeTrainDatasResponse, err error) {
	response = CreateDescribeTrainDatasResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeTrainDatasWithChan invokes the ivision.DescribeTrainDatas API asynchronously
// api document: https://help.aliyun.com/api/ivision/describetraindatas.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeTrainDatasWithChan(request *DescribeTrainDatasRequest) (<-chan *DescribeTrainDatasResponse, <-chan error) {
	responseChan := make(chan *DescribeTrainDatasResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeTrainDatas(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeTrainDatasWithCallback invokes the ivision.DescribeTrainDatas API asynchronously
// api document: https://help.aliyun.com/api/ivision/describetraindatas.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeTrainDatasWithCallback(request *DescribeTrainDatasRequest, callback func(response *DescribeTrainDatasResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeTrainDatasResponse
		var err error
		defer close(result)
		response, err = client.DescribeTrainDatas(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeTrainDatasRequest is the request struct for api DescribeTrainDatas
type DescribeTrainDatasRequest struct {
	*requests.RpcRequest
	NextPageToken string           `position:"Query" name:"NextPageToken"`
	TagStatus     string           `position:"Query" name:"TagStatus"`
	PageSize      requests.Integer `position:"Query" name:"PageSize"`
	ProjectId     string           `position:"Query" name:"ProjectId"`
	ShowLog       string           `position:"Query" name:"ShowLog"`
	TagId         string           `position:"Query" name:"TagId"`
	CurrentPage   requests.Integer `position:"Query" name:"CurrentPage"`
	OwnerId       requests.Integer `position:"Query" name:"OwnerId"`
	IterationId   string           `position:"Query" name:"IterationId"`
}

// DescribeTrainDatasResponse is the response struct for api DescribeTrainDatas
type DescribeTrainDatasResponse struct {
	*responses.BaseResponse
	RequestId     string                         `json:"RequestId" xml:"RequestId"`
	TotalNum      int                            `json:"TotalNum" xml:"TotalNum"`
	CurrentPage   int                            `json:"CurrentPage" xml:"CurrentPage"`
	PageSize      int                            `json:"PageSize" xml:"PageSize"`
	NextPageToken string                         `json:"NextPageToken" xml:"NextPageToken"`
	TrainDatas    TrainDatasInDescribeTrainDatas `json:"TrainDatas" xml:"TrainDatas"`
}

// CreateDescribeTrainDatasRequest creates a request to invoke DescribeTrainDatas API
func CreateDescribeTrainDatasRequest() (request *DescribeTrainDatasRequest) {
	request = &DescribeTrainDatasRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ivision", "2019-03-08", "DescribeTrainDatas", "ivision", "openAPI")
	return
}

// CreateDescribeTrainDatasResponse creates a response to parse from DescribeTrainDatas response
func CreateDescribeTrainDatasResponse() (response *DescribeTrainDatasResponse) {
	response = &DescribeTrainDatasResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
