package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// StartBoardRecord invokes the live.StartBoardRecord API synchronously
// api document: https://help.aliyun.com/api/live/startboardrecord.html
func (client *Client) StartBoardRecord(request *StartBoardRecordRequest) (response *StartBoardRecordResponse, err error) {
	response = CreateStartBoardRecordResponse()
	err = client.DoAction(request, response)
	return
}

// StartBoardRecordWithChan invokes the live.StartBoardRecord API asynchronously
// api document: https://help.aliyun.com/api/live/startboardrecord.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) StartBoardRecordWithChan(request *StartBoardRecordRequest) (<-chan *StartBoardRecordResponse, <-chan error) {
	responseChan := make(chan *StartBoardRecordResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.StartBoardRecord(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// StartBoardRecordWithCallback invokes the live.StartBoardRecord API asynchronously
// api document: https://help.aliyun.com/api/live/startboardrecord.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) StartBoardRecordWithCallback(request *StartBoardRecordRequest, callback func(response *StartBoardRecordResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *StartBoardRecordResponse
		var err error
		defer close(result)
		response, err = client.StartBoardRecord(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// StartBoardRecordRequest is the request struct for api StartBoardRecord
type StartBoardRecordRequest struct {
	*requests.RpcRequest
	StartTime string           `position:"Query" name:"StartTime"`
	BoardId   string           `position:"Query" name:"BoardId"`
	OwnerId   requests.Integer `position:"Query" name:"OwnerId"`
	AppId     string           `position:"Query" name:"AppId"`
}

// StartBoardRecordResponse is the response struct for api StartBoardRecord
type StartBoardRecordResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	RecordId  string `json:"RecordId" xml:"RecordId"`
}

// CreateStartBoardRecordRequest creates a request to invoke StartBoardRecord API
func CreateStartBoardRecordRequest() (request *StartBoardRecordRequest) {
	request = &StartBoardRecordRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "StartBoardRecord", "live", "openAPI")
	return
}

// CreateStartBoardRecordResponse creates a response to parse from StartBoardRecord response
func CreateStartBoardRecordResponse() (response *StartBoardRecordResponse) {
	response = &StartBoardRecordResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
