package rds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AllocateInstanceVpcNetworkType invokes the rds.AllocateInstanceVpcNetworkType API synchronously
// api document: https://help.aliyun.com/api/rds/allocateinstancevpcnetworktype.html
func (client *Client) AllocateInstanceVpcNetworkType(request *AllocateInstanceVpcNetworkTypeRequest) (response *AllocateInstanceVpcNetworkTypeResponse, err error) {
	response = CreateAllocateInstanceVpcNetworkTypeResponse()
	err = client.DoAction(request, response)
	return
}

// AllocateInstanceVpcNetworkTypeWithChan invokes the rds.AllocateInstanceVpcNetworkType API asynchronously
// api document: https://help.aliyun.com/api/rds/allocateinstancevpcnetworktype.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) AllocateInstanceVpcNetworkTypeWithChan(request *AllocateInstanceVpcNetworkTypeRequest) (<-chan *AllocateInstanceVpcNetworkTypeResponse, <-chan error) {
	responseChan := make(chan *AllocateInstanceVpcNetworkTypeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AllocateInstanceVpcNetworkType(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AllocateInstanceVpcNetworkTypeWithCallback invokes the rds.AllocateInstanceVpcNetworkType API asynchronously
// api document: https://help.aliyun.com/api/rds/allocateinstancevpcnetworktype.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) AllocateInstanceVpcNetworkTypeWithCallback(request *AllocateInstanceVpcNetworkTypeRequest, callback func(response *AllocateInstanceVpcNetworkTypeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AllocateInstanceVpcNetworkTypeResponse
		var err error
		defer close(result)
		response, err = client.AllocateInstanceVpcNetworkType(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AllocateInstanceVpcNetworkTypeRequest is the request struct for api AllocateInstanceVpcNetworkType
type AllocateInstanceVpcNetworkTypeRequest struct {
	*requests.RpcRequest
	TargetVpcId          string           `position:"Query" name:"TargetVpcId"`
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	TargetZoneId         string           `position:"Query" name:"TargetZoneId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	DBInstanceId         string           `position:"Query" name:"DBInstanceId"`
	TargetRegionId       string           `position:"Query" name:"TargetRegionId"`
	TargetVSwitchId      string           `position:"Query" name:"TargetVSwitchId"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// AllocateInstanceVpcNetworkTypeResponse is the response struct for api AllocateInstanceVpcNetworkType
type AllocateInstanceVpcNetworkTypeResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateAllocateInstanceVpcNetworkTypeRequest creates a request to invoke AllocateInstanceVpcNetworkType API
func CreateAllocateInstanceVpcNetworkTypeRequest() (request *AllocateInstanceVpcNetworkTypeRequest) {
	request = &AllocateInstanceVpcNetworkTypeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Rds", "2014-08-15", "AllocateInstanceVpcNetworkType", "rds", "openAPI")
	return
}

// CreateAllocateInstanceVpcNetworkTypeResponse creates a response to parse from AllocateInstanceVpcNetworkType response
func CreateAllocateInstanceVpcNetworkTypeResponse() (response *AllocateInstanceVpcNetworkTypeResponse) {
	response = &AllocateInstanceVpcNetworkTypeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
