package rds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeCrossRegionLogBackupFiles invokes the rds.DescribeCrossRegionLogBackupFiles API synchronously
// api document: https://help.aliyun.com/api/rds/describecrossregionlogbackupfiles.html
func (client *Client) DescribeCrossRegionLogBackupFiles(request *DescribeCrossRegionLogBackupFilesRequest) (response *DescribeCrossRegionLogBackupFilesResponse, err error) {
	response = CreateDescribeCrossRegionLogBackupFilesResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeCrossRegionLogBackupFilesWithChan invokes the rds.DescribeCrossRegionLogBackupFiles API asynchronously
// api document: https://help.aliyun.com/api/rds/describecrossregionlogbackupfiles.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeCrossRegionLogBackupFilesWithChan(request *DescribeCrossRegionLogBackupFilesRequest) (<-chan *DescribeCrossRegionLogBackupFilesResponse, <-chan error) {
	responseChan := make(chan *DescribeCrossRegionLogBackupFilesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeCrossRegionLogBackupFiles(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeCrossRegionLogBackupFilesWithCallback invokes the rds.DescribeCrossRegionLogBackupFiles API asynchronously
// api document: https://help.aliyun.com/api/rds/describecrossregionlogbackupfiles.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeCrossRegionLogBackupFilesWithCallback(request *DescribeCrossRegionLogBackupFilesRequest, callback func(response *DescribeCrossRegionLogBackupFilesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeCrossRegionLogBackupFilesResponse
		var err error
		defer close(result)
		response, err = client.DescribeCrossRegionLogBackupFiles(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeCrossRegionLogBackupFilesRequest is the request struct for api DescribeCrossRegionLogBackupFiles
type DescribeCrossRegionLogBackupFilesRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	PageSize             requests.Integer `position:"Query" name:"PageSize"`
	EndTime              string           `position:"Query" name:"EndTime"`
	DBInstanceId         string           `position:"Query" name:"DBInstanceId"`
	StartTime            string           `position:"Query" name:"StartTime"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	CrossBackupRegion    string           `position:"Query" name:"CrossBackupRegion"`
	PageNumber           requests.Integer `position:"Query" name:"PageNumber"`
}

// DescribeCrossRegionLogBackupFilesResponse is the response struct for api DescribeCrossRegionLogBackupFiles
type DescribeCrossRegionLogBackupFilesResponse struct {
	*responses.BaseResponse
	RequestId        string                                   `json:"RequestId" xml:"RequestId"`
	RegionId         string                                   `json:"RegionId" xml:"RegionId"`
	DBInstanceId     string                                   `json:"DBInstanceId" xml:"DBInstanceId"`
	StartTime        string                                   `json:"StartTime" xml:"StartTime"`
	EndTime          string                                   `json:"EndTime" xml:"EndTime"`
	TotalRecordCount int                                      `json:"TotalRecordCount" xml:"TotalRecordCount"`
	PageRecordCount  int                                      `json:"PageRecordCount" xml:"PageRecordCount"`
	PageNumber       int                                      `json:"PageNumber" xml:"PageNumber"`
	Items            ItemsInDescribeCrossRegionLogBackupFiles `json:"Items" xml:"Items"`
}

// CreateDescribeCrossRegionLogBackupFilesRequest creates a request to invoke DescribeCrossRegionLogBackupFiles API
func CreateDescribeCrossRegionLogBackupFilesRequest() (request *DescribeCrossRegionLogBackupFilesRequest) {
	request = &DescribeCrossRegionLogBackupFilesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Rds", "2014-08-15", "DescribeCrossRegionLogBackupFiles", "rds", "openAPI")
	return
}

// CreateDescribeCrossRegionLogBackupFilesResponse creates a response to parse from DescribeCrossRegionLogBackupFiles response
func CreateDescribeCrossRegionLogBackupFilesResponse() (response *DescribeCrossRegionLogBackupFilesResponse) {
	response = &DescribeCrossRegionLogBackupFilesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
