//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package rtc

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeRtcDurationData invokes the rtc.DescribeRtcDurationData API synchronously
// api document: https://help.aliyun.com/api/rtc/describertcdurationdata.html
func (client *Client) DescribeRtcDurationData(request *DescribeRtcDurationDataRequest) (response *DescribeRtcDurationDataResponse, err error) {
	response = CreateDescribeRtcDurationDataResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeRtcDurationDataWithChan invokes the rtc.DescribeRtcDurationData API asynchronously
// api document: https://help.aliyun.com/api/rtc/describertcdurationdata.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeRtcDurationDataWithChan(request *DescribeRtcDurationDataRequest) (<-chan *DescribeRtcDurationDataResponse, <-chan error) {
	responseChan := make(chan *DescribeRtcDurationDataResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeRtcDurationData(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeRtcDurationDataWithCallback invokes the rtc.DescribeRtcDurationData API asynchronously
// api document: https://help.aliyun.com/api/rtc/describertcdurationdata.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeRtcDurationDataWithCallback(request *DescribeRtcDurationDataRequest, callback func(response *DescribeRtcDurationDataResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeRtcDurationDataResponse
		var err error
		defer close(result)
		response, err = client.DescribeRtcDurationData(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeRtcDurationDataRequest is the request struct for api DescribeRtcDurationData
type DescribeRtcDurationDataRequest struct {
	*requests.RpcRequest
	OwnerId     requests.Integer `position:"Query" name:"OwnerId"`
	StartTime   string           `position:"Query" name:"StartTime"`
	EndTime     string           `position:"Query" name:"EndTime"`
	AppId       string           `position:"Query" name:"AppId"`
	ServiceArea string           `position:"Query" name:"ServiceArea"`
	Interval    string           `position:"Query" name:"Interval"`
}

// DescribeRtcDurationDataResponse is the response struct for api DescribeRtcDurationData
type DescribeRtcDurationDataResponse struct {
	*responses.BaseResponse
	RequestId               string                                          `json:"RequestId" xml:"RequestId"`
	DurationDataPerInterval DescribeRtcDurationDataDurationDataPerInterval0 `json:"DurationDataPerInterval" xml:"DurationDataPerInterval"`
}

type DescribeRtcDurationDataDurationDataPerInterval0 struct {
	DurationModule []DescribeRtcDurationDataDurationModule1 `json:"DurationModule" xml:"DurationModule"`
}

type DescribeRtcDurationDataDurationModule1 struct {
	TimeStamp       string `json:"TimeStamp" xml:"TimeStamp"`
	TotalDuration   int64  `json:"TotalDuration" xml:"TotalDuration"`
	AudioDuration   int64  `json:"AudioDuration" xml:"AudioDuration"`
	V360Duration    int64  `json:"V360Duration" xml:"V360Duration"`
	V720Duration    int64  `json:"V720Duration" xml:"V720Duration"`
	V1080Duration   int64  `json:"V1080Duration" xml:"V1080Duration"`
	ContentDuration int64  `json:"ContentDuration" xml:"ContentDuration"`
}

// CreateDescribeRtcDurationDataRequest creates a request to invoke DescribeRtcDurationData API
func CreateDescribeRtcDurationDataRequest() (request *DescribeRtcDurationDataRequest) {
	request = &DescribeRtcDurationDataRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("rtc", "2018-01-11", "DescribeRtcDurationData", "rtc", "openAPI")
	return
}

// CreateDescribeRtcDurationDataResponse creates a response to parse from DescribeRtcDurationData response
func CreateDescribeRtcDurationDataResponse() (response *DescribeRtcDurationDataResponse) {
	response = &DescribeRtcDurationDataResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
