//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package rtc

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// MuteAudioAll invokes the rtc.MuteAudioAll API synchronously
// api document: https://help.aliyun.com/api/rtc/muteaudioall.html
func (client *Client) MuteAudioAll(request *MuteAudioAllRequest) (response *MuteAudioAllResponse, err error) {
	response = CreateMuteAudioAllResponse()
	err = client.DoAction(request, response)
	return
}

// MuteAudioAllWithChan invokes the rtc.MuteAudioAll API asynchronously
// api document: https://help.aliyun.com/api/rtc/muteaudioall.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) MuteAudioAllWithChan(request *MuteAudioAllRequest) (<-chan *MuteAudioAllResponse, <-chan error) {
	responseChan := make(chan *MuteAudioAllResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.MuteAudioAll(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// MuteAudioAllWithCallback invokes the rtc.MuteAudioAll API asynchronously
// api document: https://help.aliyun.com/api/rtc/muteaudioall.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) MuteAudioAllWithCallback(request *MuteAudioAllRequest, callback func(response *MuteAudioAllResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *MuteAudioAllResponse
		var err error
		defer close(result)
		response, err = client.MuteAudioAll(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// MuteAudioAllRequest is the request struct for api MuteAudioAll
type MuteAudioAllRequest struct {
	*requests.RpcRequest
	OwnerId       requests.Integer `position:"Query" name:"OwnerId"`
	AppId         string           `position:"Query" name:"AppId"`
	ConferenceId  string           `position:"Query" name:"ConferenceId"`
	ParticipantId string           `position:"Query" name:"ParticipantId"`
}

// MuteAudioAllResponse is the response struct for api MuteAudioAll
type MuteAudioAllResponse struct {
	*responses.BaseResponse
	RequestId    string                    `json:"RequestId" xml:"RequestId"`
	ConferenceId string                    `json:"ConferenceId" xml:"ConferenceId"`
	Participants MuteAudioAllParticipants0 `json:"Participants" xml:"Participants"`
}

type MuteAudioAllParticipants0 struct {
	Participant []MuteAudioAllParticipant1 `json:"Participant" xml:"Participant"`
}

type MuteAudioAllParticipant1 struct {
	Id      string `json:"Id" xml:"Id"`
	Code    string `json:"Code" xml:"Code"`
	Message string `json:"Message" xml:"Message"`
}

// CreateMuteAudioAllRequest creates a request to invoke MuteAudioAll API
func CreateMuteAudioAllRequest() (request *MuteAudioAllRequest) {
	request = &MuteAudioAllRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("rtc", "2018-01-11", "MuteAudioAll", "rtc", "openAPI")
	return
}

// CreateMuteAudioAllResponse creates a response to parse from MuteAudioAll response
func CreateMuteAudioAllResponse() (response *MuteAudioAllResponse) {
	response = &MuteAudioAllResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
