//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package rtc

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// StartMPUTask invokes the rtc.StartMPUTask API synchronously
// api document: https://help.aliyun.com/api/rtc/startmputask.html
func (client *Client) StartMPUTask(request *StartMPUTaskRequest) (response *StartMPUTaskResponse, err error) {
	response = CreateStartMPUTaskResponse()
	err = client.DoAction(request, response)
	return
}

// StartMPUTaskWithChan invokes the rtc.StartMPUTask API asynchronously
// api document: https://help.aliyun.com/api/rtc/startmputask.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) StartMPUTaskWithChan(request *StartMPUTaskRequest) (<-chan *StartMPUTaskResponse, <-chan error) {
	responseChan := make(chan *StartMPUTaskResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.StartMPUTask(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// StartMPUTaskWithCallback invokes the rtc.StartMPUTask API asynchronously
// api document: https://help.aliyun.com/api/rtc/startmputask.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) StartMPUTaskWithCallback(request *StartMPUTaskRequest, callback func(response *StartMPUTaskResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *StartMPUTaskResponse
		var err error
		defer close(result)
		response, err = client.StartMPUTask(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// StartMPUTaskRequest is the request struct for api StartMPUTask
type StartMPUTaskRequest struct {
	*requests.RpcRequest
	OwnerId         requests.Integer         `position:"Query" name:"OwnerId"`
	AppId           string                   `position:"Query" name:"AppId"`
	ChannelId       string                   `position:"Query" name:"ChannelId"`
	TaskId          string                   `position:"Query" name:"TaskId"`
	TaskProfile     string                   `position:"Query" name:"TaskProfile"`
	MediaEncode     requests.Integer         `position:"Query" name:"MediaEncode"`
	BackgroundColor requests.Integer         `position:"Query" name:"BackgroundColor"`
	LayoutIds       []requests.Integer       `position:"Query" name:"LayoutIds" type:"Repeated"`
	UserPanes       *[]StartMPUTaskUserPanes `position:"Query" name:"UserPanes" type:"Repeated"`
	StreamURL       string                   `position:"Query" name:"StreamURL"`
}

type StartMPUTaskUserPanes struct {
	PaneId     requests.Integer `name:"PaneId"`
	UserId     string           `name:"UserId"`
	SourceType string           `name:"SourceType"`
}

// StartMPUTaskResponse is the response struct for api StartMPUTask
type StartMPUTaskResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateStartMPUTaskRequest creates a request to invoke StartMPUTask API
func CreateStartMPUTaskRequest() (request *StartMPUTaskRequest) {
	request = &StartMPUTaskRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("rtc", "2018-01-11", "StartMPUTask", "rtc", "openAPI")
	return
}

// CreateStartMPUTaskResponse creates a response to parse from StartMPUTask response
func CreateStartMPUTaskResponse() (response *StartMPUTaskResponse) {
	response = &StartMPUTaskResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
