package sas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyConcernNecessity invokes the sas.ModifyConcernNecessity API synchronously
// api document: https://help.aliyun.com/api/sas/modifyconcernnecessity.html
func (client *Client) ModifyConcernNecessity(request *ModifyConcernNecessityRequest) (response *ModifyConcernNecessityResponse, err error) {
	response = CreateModifyConcernNecessityResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyConcernNecessityWithChan invokes the sas.ModifyConcernNecessity API asynchronously
// api document: https://help.aliyun.com/api/sas/modifyconcernnecessity.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyConcernNecessityWithChan(request *ModifyConcernNecessityRequest) (<-chan *ModifyConcernNecessityResponse, <-chan error) {
	responseChan := make(chan *ModifyConcernNecessityResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyConcernNecessity(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyConcernNecessityWithCallback invokes the sas.ModifyConcernNecessity API asynchronously
// api document: https://help.aliyun.com/api/sas/modifyconcernnecessity.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyConcernNecessityWithCallback(request *ModifyConcernNecessityRequest, callback func(response *ModifyConcernNecessityResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyConcernNecessityResponse
		var err error
		defer close(result)
		response, err = client.ModifyConcernNecessity(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyConcernNecessityRequest is the request struct for api ModifyConcernNecessity
type ModifyConcernNecessityRequest struct {
	*requests.RpcRequest
	SourceIp         string `position:"Query" name:"SourceIp"`
	Lang             string `position:"Query" name:"Lang"`
	ConcernNecessity string `position:"Query" name:"ConcernNecessity"`
}

// ModifyConcernNecessityResponse is the response struct for api ModifyConcernNecessity
type ModifyConcernNecessityResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyConcernNecessityRequest creates a request to invoke ModifyConcernNecessity API
func CreateModifyConcernNecessityRequest() (request *ModifyConcernNecessityRequest) {
	request = &ModifyConcernNecessityRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Sas", "2018-12-03", "ModifyConcernNecessity", "sas", "openAPI")
	return
}

// CreateModifyConcernNecessityResponse creates a response to parse from ModifyConcernNecessity response
func CreateModifyConcernNecessityResponse() (response *ModifyConcernNecessityResponse) {
	response = &ModifyConcernNecessityResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
