package scdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeScdnDomainRealTimeByteHitRateData invokes the scdn.DescribeScdnDomainRealTimeByteHitRateData API synchronously
// api document: https://help.aliyun.com/api/scdn/describescdndomainrealtimebytehitratedata.html
func (client *Client) DescribeScdnDomainRealTimeByteHitRateData(request *DescribeScdnDomainRealTimeByteHitRateDataRequest) (response *DescribeScdnDomainRealTimeByteHitRateDataResponse, err error) {
	response = CreateDescribeScdnDomainRealTimeByteHitRateDataResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeScdnDomainRealTimeByteHitRateDataWithChan invokes the scdn.DescribeScdnDomainRealTimeByteHitRateData API asynchronously
// api document: https://help.aliyun.com/api/scdn/describescdndomainrealtimebytehitratedata.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeScdnDomainRealTimeByteHitRateDataWithChan(request *DescribeScdnDomainRealTimeByteHitRateDataRequest) (<-chan *DescribeScdnDomainRealTimeByteHitRateDataResponse, <-chan error) {
	responseChan := make(chan *DescribeScdnDomainRealTimeByteHitRateDataResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeScdnDomainRealTimeByteHitRateData(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeScdnDomainRealTimeByteHitRateDataWithCallback invokes the scdn.DescribeScdnDomainRealTimeByteHitRateData API asynchronously
// api document: https://help.aliyun.com/api/scdn/describescdndomainrealtimebytehitratedata.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeScdnDomainRealTimeByteHitRateDataWithCallback(request *DescribeScdnDomainRealTimeByteHitRateDataRequest, callback func(response *DescribeScdnDomainRealTimeByteHitRateDataResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeScdnDomainRealTimeByteHitRateDataResponse
		var err error
		defer close(result)
		response, err = client.DescribeScdnDomainRealTimeByteHitRateData(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeScdnDomainRealTimeByteHitRateDataRequest is the request struct for api DescribeScdnDomainRealTimeByteHitRateData
type DescribeScdnDomainRealTimeByteHitRateDataRequest struct {
	*requests.RpcRequest
	StartTime  string           `position:"Query" name:"StartTime"`
	DomainName string           `position:"Query" name:"DomainName"`
	EndTime    string           `position:"Query" name:"EndTime"`
	OwnerId    requests.Integer `position:"Query" name:"OwnerId"`
}

// DescribeScdnDomainRealTimeByteHitRateDataResponse is the response struct for api DescribeScdnDomainRealTimeByteHitRateData
type DescribeScdnDomainRealTimeByteHitRateDataResponse struct {
	*responses.BaseResponse
	RequestId string                                          `json:"RequestId" xml:"RequestId"`
	Data      DataInDescribeScdnDomainRealTimeByteHitRateData `json:"Data" xml:"Data"`
}

// CreateDescribeScdnDomainRealTimeByteHitRateDataRequest creates a request to invoke DescribeScdnDomainRealTimeByteHitRateData API
func CreateDescribeScdnDomainRealTimeByteHitRateDataRequest() (request *DescribeScdnDomainRealTimeByteHitRateDataRequest) {
	request = &DescribeScdnDomainRealTimeByteHitRateDataRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("scdn", "2017-11-15", "DescribeScdnDomainRealTimeByteHitRateData", "scdn", "openAPI")
	return
}

// CreateDescribeScdnDomainRealTimeByteHitRateDataResponse creates a response to parse from DescribeScdnDomainRealTimeByteHitRateData response
func CreateDescribeScdnDomainRealTimeByteHitRateDataResponse() (response *DescribeScdnDomainRealTimeByteHitRateDataResponse) {
	response = &DescribeScdnDomainRealTimeByteHitRateDataResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
