package sddp

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeCloudDatabases invokes the sddp.DescribeCloudDatabases API synchronously
// api document: https://help.aliyun.com/api/sddp/describeclouddatabases.html
func (client *Client) DescribeCloudDatabases(request *DescribeCloudDatabasesRequest) (response *DescribeCloudDatabasesResponse, err error) {
	response = CreateDescribeCloudDatabasesResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeCloudDatabasesWithChan invokes the sddp.DescribeCloudDatabases API asynchronously
// api document: https://help.aliyun.com/api/sddp/describeclouddatabases.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeCloudDatabasesWithChan(request *DescribeCloudDatabasesRequest) (<-chan *DescribeCloudDatabasesResponse, <-chan error) {
	responseChan := make(chan *DescribeCloudDatabasesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeCloudDatabases(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeCloudDatabasesWithCallback invokes the sddp.DescribeCloudDatabases API asynchronously
// api document: https://help.aliyun.com/api/sddp/describeclouddatabases.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeCloudDatabasesWithCallback(request *DescribeCloudDatabasesRequest, callback func(response *DescribeCloudDatabasesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeCloudDatabasesResponse
		var err error
		defer close(result)
		response, err = client.DescribeCloudDatabases(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeCloudDatabasesRequest is the request struct for api DescribeCloudDatabases
type DescribeCloudDatabasesRequest struct {
	*requests.RpcRequest
	InstanceId      string           `position:"Query" name:"InstanceId"`
	SourceIp        string           `position:"Query" name:"SourceIp"`
	Lang            string           `position:"Query" name:"Lang"`
	ResourceType    requests.Integer `position:"Query" name:"ResourceType"`
	ServiceRegionId string           `position:"Query" name:"ServiceRegionId"`
}

// DescribeCloudDatabasesResponse is the response struct for api DescribeCloudDatabases
type DescribeCloudDatabasesResponse struct {
	*responses.BaseResponse
	RequestId         string          `json:"RequestId" xml:"RequestId"`
	CloudDatabaseList []CloudDatabase `json:"CloudDatabaseList" xml:"CloudDatabaseList"`
}

// CreateDescribeCloudDatabasesRequest creates a request to invoke DescribeCloudDatabases API
func CreateDescribeCloudDatabasesRequest() (request *DescribeCloudDatabasesRequest) {
	request = &DescribeCloudDatabasesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Sddp", "2019-01-03", "DescribeCloudDatabases", "sddp", "openAPI")
	return
}

// CreateDescribeCloudDatabasesResponse creates a response to parse from DescribeCloudDatabases response
func CreateDescribeCloudDatabasesResponse() (response *DescribeCloudDatabasesResponse) {
	response = &DescribeCloudDatabasesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
