// Copyright 2015 The Go Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

package stats

import "testing"

func TestT(t *testing.T) {
	testFunc(t, "PDF(%v|v=1)", TDist{1}.PDF, map[float64]float64{
		-10: 0.0031515830315226806,
		-9:  0.0038818278802901312,
		-8:  0.0048970751720583188,
		-7:  0.0063661977236758151,
		-6:  0.0086029698968592104,
		-5:  0.012242687930145799,
		-4:  0.018724110951987692,
		-3:  0.031830988618379075,
		-2:  0.063661977236758149,
		-1:  0.15915494309189537,
		0:   0.31830988618379075,
		1:   0.15915494309189537,
		2:   0.063661977236758149,
		3:   0.031830988618379075,
		4:   0.018724110951987692,
		5:   0.012242687930145799,
		6:   0.0086029698968592104,
		7:   0.0063661977236758151,
		8:   0.0048970751720583188,
		9:   0.0038818278802901312})
	testFunc(t, "PDF(%v|v=5)", TDist{5}.PDF, map[float64]float64{
		-10: 4.0989816415343313e-05,
		-9:  7.4601664362590413e-05,
		-8:  0.00014444303269563934,
		-7:  0.00030134402928803911,
		-6:  0.00068848154013743002,
		-5:  0.0017574383788078445,
		-4:  0.0051237270519179133,
		-3:  0.017292578800222964,
		-2:  0.065090310326216455,
		-1:  0.21967979735098059,
		0:   0.3796066898224944,
		1:   0.21967979735098059,
		2:   0.065090310326216455,
		3:   0.017292578800222964,
		4:   0.0051237270519179133,
		5:   0.0017574383788078445,
		6:   0.00068848154013743002,
		7:   0.00030134402928803911,
		8:   0.00014444303269563934,
		9:   7.4601664362590413e-05})

	testFunc(t, "CDF(%v|v=1)", TDist{1}.CDF, map[float64]float64{
		-10: 0.03172551743055356,
		-9:  0.035223287477277272,
		-8:  0.039583424160565539,
		-7:  0.045167235300866547,
		-6:  0.052568456711253424,
		-5:  0.06283295818900117,
		-4:  0.077979130377369324,
		-3:  0.10241638234956672,
		-2:  0.14758361765043321,
		-1:  0.24999999999999978,
		0:   0.5,
		1:   0.75000000000000022,
		2:   0.85241638234956674,
		3:   0.89758361765043326,
		4:   0.92202086962263075,
		5:   0.93716704181099886,
		6:   0.94743154328874657,
		7:   0.95483276469913347,
		8:   0.96041657583943452,
		9:   0.96477671252272279})
	testFunc(t, "CDF(%v|v=5)", TDist{5}.CDF, map[float64]float64{
		-10: 8.5473787871481787e-05,
		-9:  0.00014133998712194845,
		-8:  0.00024645333028622187,
		-7:  0.00045837375719920225,
		-6:  0.00092306914479700695,
		-5:  0.0020523579900266612,
		-4:  0.0051617077404157259,
		-3:  0.015049623948731284,
		-2:  0.05096973941492914,
		-1:  0.18160873382456127,
		0:   0.5,
		1:   0.81839126617543867,
		2:   0.9490302605850709,
		3:   0.98495037605126878,
		4:   0.99483829225958431,
		5:   0.99794764200997332,
		6:   0.99907693085520299,
		7:   0.99954162624280074,
		8:   0.99975354666971372,
		9:   0.9998586600128780})
}
